#include "thumbnailsize.h"


ThumbnailSize::ThumbnailSize(Size value) : size(value) {}


ThumbnailSize::ThumbnailSize(const QString& str) {

  QString low=str.lower();
  if (low=="small") {
    size=Small;
  } else if (low=="medium") {
    size=Med;
  } else {
    size=Large;
  }
}

ThumbnailSize::ThumbnailSize(const ThumbnailSize& thumbSize) {

  size = thumbSize.size;

}

bool ThumbnailSize :: operator==(const ThumbnailSize& thumbSize) const {

  return (size == thumbSize.size);

}

QSize ThumbnailSize :: rescaledSize(const QSize& origSize) const {

  QSize newSize;
  int newWidth;
  int newHeight;

  switch(size) {

  case Small: {

    newWidth  = int(origSize.width() * 60.0/100.0);
    newHeight = int(origSize.height() * 60.0/100.0);
    break;

  }

  case Med: {

    newWidth  = int(origSize.width() * 80.0/100.0);
    newHeight = int(origSize.height() * 80.0/100.0);
    break;

  }

  default : {

    newWidth  = origSize.width();
    newHeight = origSize.height();
    break;

  }

  }

  newSize.setWidth(newWidth);
  newSize.setHeight(newHeight);
  return newSize;

}

double ThumbnailSize::scaleFactor() const
{

    switch(size) {

    case Small:
        return 0.6;

    case Med:
        return 0.8;

    case Large:
        return 1.0;
    }


}
