/*
  Copyright (c) 2009 Constantin Berzan <exit3219@gmail.com>

  This library is free software; you can redistribute it and/or modify it
  under the terms of the GNU Library General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
  License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to the
  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/

#ifndef MESSAGECOMPOSER_MAINTEXTJOB_H
#define MESSAGECOMPOSER_MAINTEXTJOB_H

#include "contentjobbase.h"
#include "messagecomposer_export.h"

namespace MessageComposer {
class MainTextJobPrivate;
class TextPart;
/**
 * @brief The MainTextJob class
 */
class MESSAGECOMPOSER_EXPORT MainTextJob : public ContentJobBase
{
    Q_OBJECT

public:
    explicit MainTextJob(TextPart *textPart = nullptr, QObject *parent = nullptr);
    ~MainTextJob() override;

    Q_REQUIRED_RESULT TextPart *textPart() const;
    void setTextPart(TextPart *part);

protected Q_SLOTS:
    void doStart() override;
    void process() override;

private:
    Q_DECLARE_PRIVATE(MainTextJob)
};
} // namespace MessageComposer

#endif
