# - Find the native PThreadsWin32 includes and library
#
# This module defines
#  PTHREADS_WIN32_INCLUDE_DIR, where to find pthread.h, etc.
#  PTHREADS_WIN32_LIBRARIES, the libraries to link against to use PThreadsWin32.
#  PTHREADS_WIN32_FOUND, If false, do not try to use PThreadsWin32.

#=============================================================================
#
find_path(PTHREADS_WIN32_INCLUDE_DIR pthread.h)
find_library(PTHREADS_WIN32_LIBRARIES NAMES pthreads)

# handle the QUIETLY and REQUIRED arguments and set PTHREADS_WIN32_FOUND to TRUE if
# all listed variables are TRUE
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(PThreadsWin32  DEFAULT_MSG  PTHREADS_WIN32_LIBRARIES PTHREADS_WIN32_INCLUDE_DIR)

mark_as_advanced(PTHREADS_WIN32_INCLUDE_DIR PTHREADS_WIN32_LIBRARIES)
