/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGOPERATIONPLUGINWIDGET_H
#define SKGOPERATIONPLUGINWIDGET_H
/** @file
* This file is Skrooge plugin for bank management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgoperationpluginwidget_base.h"
#include "skgtabpage.h"
#include "skgoperationobject.h"
#include "skgsuboperationobject.h"

#include <QDomDocument>

class SKGDocumentBank;
class SKGObjectModel;
class SKGSplitTableDelegate;
class SKGTreeView;
class KAction;

/**
 * This file is Skrooge plugin for operation management
 */
class SKGOperationPluginWidget : public SKGTabPage
{
    Q_OBJECT


public:
    /**
     * Default Constructor
     */
    explicit SKGOperationPluginWidget(SKGDocumentBank* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGOperationPluginWidget();

    /**
     * Get the table view
     * @return the table view
     */
    virtual SKGTreeView* getTableView();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState);

    /**
     * Get attribute name to save the default state
     * MUST BE OVERWRITTEN
     * @return attribute name to save the default state.
     */
    virtual QString getDefaultStateAttribute();

    /**
     * Get the main widget
     * @return a widget
     */
    virtual QWidget* mainWidget() const;

    /**
     * Set or not the template mode
     * @param iTemplate the template mode
     */
    virtual void setTemplateMode(bool iTemplate);

    /**
     * To know if this page contains an editor. MUST BE OVERWRITTEN
     * @return the editor state
     */
    virtual bool isEditor();

    /**
     * To activate the editor by setting focus on right widget. MUST BE OVERWRITTEN
     */
    virtual void activateEditor();

protected:
    /**
     * Event filtering
     * @param object object
     * @param event event
     * @return In your reimplementation of this function, if you want to filter the event out, i.e. stop it being handled further, return true; otherwise return false.
     */
    virtual bool eventFilter(QObject* object, QEvent* event);

private Q_SLOTS:
    void dataModified(const QString& iTableName, int iIdTransaction);
    void onOperationCreatorModified();
    void onAddOperationClicked();
    void onUpdateOperationClicked();
    void onFilterChanged();
    void onAccountChanged();
    void onResetInternalFilter();
    void onSelectionChanged();
    void onFocusChanged();
    void onFastEdition();
    void onDoubleClick();
    void onQuantityChanged();
    void onSubopCellChanged(int row, int column);
    void onRemoveSubOperation(int iRow = -1);
    void onRefreshInformationZone();
    void onRefreshInformationZoneDelayed();
    void onRotateAccountTools();
    void onValidatePointedOperations();
    void onBtnModeClicked(int mode);
    void onAutoPoint();
    void onAddFakeOperation();
    void onFreeze();
    void cleanEditor();
    void displaySelectionAmount();
    void displayReconciliationInfo();
    void displayBalance();
    void fillTargetAccount();

private:
    Q_DISABLE_COPY(SKGOperationPluginWidget)

    SKGError getSelectedOperation(SKGOperationObject& operation);

    bool isWidgetEditionEnabled(QWidget* iWidget);
    void setWidgetEditionEnabled(QWidget* iWidget, bool iEnabled);
    void setAllWidgetsEnabled();

    bool isTemplateMode();
    void displaySubOperations();
    void displaySubOperations(const SKGOperationObject& iOperation , bool iKeepId = true);
    double getRemainingQuantity();
    void addSubOperationLine(int row, const QString& category, const QString& tracker, const QString& comment, double quantity, const QString& formula, int id = 0);
    SKGError updateSelection(const SKGObjectBase::SKGListSKGObjectBase& iSelection, bool forceCreation = false);
    void fillNumber();
    QString currentAccount();

    Ui::skgoperationplugin_base ui;
    SKGObjectModel* m_objectModel;
    QString m_operationWhereClause;
    QString m_previousValue;
    QDomDocument m_lastState;

    QAction* m_fastEditionAction;

    QString m_lastFastEditionWhereClause;
    int m_lastFastEditionOperationFound;
    bool m_showClosedAccounts;

    bool m_numberFieldIsNotUptodate;
    int m_modeInfoZone;
    QKeySequence m_deleteShortcut;
    QString m_frozenLogo;

    SKGSplitTableDelegate* m_tableDelegate;
    QTimer m_timer;

};

#endif // SKGOPERATIONPLUGINWIDGET_H
