/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is Plasma Applet for Highlighted Operation Skroogoid
*
* @author Siddharth SHARMA
*/

#include "highlightedoperationskroogoid.h"
#include "skgdocumentbank.h"
#include "skgservices.h"
#include "skgmainpanel.h"

#include <QGraphicsGridLayout>
#include <kmessagebox.h>

HighlightedOperationSkroogoid::HighlightedOperationSkroogoid(QObject* iParent, const QVariantList& args) :
    Applet(iParent, args), widgetLayout(NULL)
{}

HighlightedOperationSkroogoid::~HighlightedOperationSkroogoid()
{}

void HighlightedOperationSkroogoid::init()
{
    // This is the layout for the whole widget
    if (widgetLayout == NULL) {
        widgetLayout = new QGraphicsLinearLayout(Qt::Vertical);
        setLayout(widgetLayout);

        Plasma::DataEngine* engine = dataEngine("skgdataengine");
        if (engine->isValid())  engine->connectSource("Highlighted Operations", this);
    }
}

void HighlightedOperationSkroogoid::dataUpdated(const QString& sourceName, const Plasma::DataEngine::Data& engineData)
{
    if (sourceName != "Highlighted Operations") return;

    QHash<QString, QStringList> listData;
    for (int i = 0 ; i < engineData.keys().count() ; ++i) {
        QString operationId = engineData.keys().at(i);
        QVariant operationValuesVariant = engineData.value(operationId);
        QStringList operationValues = operationValuesVariant.value<QStringList>();

        listData[operationId] = operationValues;
    }

    // Get the current document
    SKGMainPanel* panel = SKGMainPanel::getMainPanel();
    SKGDocumentBank* doc = qobject_cast<SKGDocumentBank*> (panel->getDocument());

    // Get the primary unit
    primary = doc->getPrimaryUnit();

    //Initialisation
    int nb = widgetLayout->count();
    for (int i = 0; widgetLayout && i < nb; ++i) {
        QGraphicsLayoutItem* item = widgetLayout->itemAt(0);
        if (item) {
            widgetLayout->removeAt(0);
            delete item;
        }
    }

    nb = listData.count();
    for (int i = 0; i < nb; ++i) {
        // Operation id
        QString operationId = listData.keys().at(i);

        QStringList values = listData[operationId];

        // Date
        QString date = values.at(0);

        // Payee
        QString payee = values.at(1);

        // Amount
        double amount = SKGServices::stringToDouble(values.at(2));

        // Add a line in the applet
        QGraphicsLinearLayout* lineLayout = new QGraphicsLinearLayout(Qt::Horizontal);
        widgetLayout->addItem(lineLayout);

        KLocale* loc = KGlobal::locale();
        Plasma::Label* dateLabel = new Plasma::Label();
        lineLayout->addItem(dateLabel);
        dateLabel->setText(loc->formatDate(SKGServices::stringToTime(date).date() , KLocale::FancyShortDate));
        dateLabel->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);

        lineLayout->addStretch(10);

        Plasma::Label* payeeLabel = new Plasma::Label();
        lineLayout->addItem(payeeLabel);
        payeeLabel->setText(payee);
        payeeLabel->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);

        lineLayout->addStretch(20);

        Plasma::Label* amountLabel = new Plasma::Label();
        amountLabel->setText(doc->formatMoney(amount, primary));
        lineLayout->addItem(amountLabel);
        amountLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
    }

    widgetLayout->addStretch(20);
}

#include "highlightedoperationskroogoid.moc"
