/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGSORTFILTERPROXYMODEL_H
#define SKGSORTFILTERPROXYMODEL_H
/** @file
 * This file is a proxy model with better filter mechanism.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <kglobal.h>

#include <QSortFilterProxyModel>
#include "skgbasegui_export.h"
/**
 * This class is a proxy model with better filter mechanism
 */
class SKGBASEGUI_EXPORT SKGSortFilterProxyModel : public QSortFilterProxyModel
{
public:
    /**
     * Contructor
     * @param iParent parent widget
     */
    explicit SKGSortFilterProxyModel(QObject* iParent = 0);

    /**
     * Destructor
     */
    virtual ~SKGSortFilterProxyModel();

protected:
    /**
     * To know if a row must be displayed or not
     * @param source_row source row
     * @param source_parent prent
     * @return true of false
     */
    virtual bool filterAcceptsRow(int source_row, const QModelIndex& source_parent) const;

    /**
     * To sort items
     * @param left left item
     * @param right right item
     * @return true of false
     */
    virtual bool lessThan(const QModelIndex& left, const QModelIndex& right) const;

private:
    bool filterAcceptsRowWords(int source_row, const QModelIndex& source_parent, const QStringList& iWords) const;
};

#endif
