<?php
/**
 * $Horde: imp/lib/Block/summary.php,v 1.11 2003/08/05 14:45:02 chuck Exp $
 *
 * @package horde.block
 */
class imp_summary_Block extends Horde_Block {

    function imp_summary_Block($params = array())
    {
        $this->_params = $params;
        $this->_app = 'imp';
        $this->_type = 'summary';
    }

    function isEditable()
    {
        return false;
    }

    function _title()
    {
        global $registry;

        $html  = Horde::link(Horde::url($registry->getInitialPage(), true), $registry->getParam('name'), 'header') . $registry->getParam('name') . '</a> - ';
        $html .= Horde::link($registry->call('mail/compose'), _("Compose"), 'smallheader') . Horde::img('compose.gif', _("Compose"), 'hspace="5"', Horde::url($registry->getParam('graphics'), true, -1)) . _("Compose") . '</a>';

        return $html;
    }

    function _content()
    {
        global $conf, $prefs, $registry, $css;

        Horde::getThemeConfig(IMP_BASE);

        $authentication = 'none';
        require dirname(__FILE__) . '/../base.php';

        $html = '<table border="0" cellpadding="0" cellspacing="0" width="100%">';

        if (IMP::checkAuthentication(OP_HALFOPEN, true) === true) {
            $folders = @unserialize($prefs->getValue('nav_poll'));
            if (!isset($folders) || !is_array($folders)) {
                $folders = array('INBOX' => 1);
            }
            uksort($folders, create_function('$a, $b', 'return strcasecmp($a, $b);'));

            $serverstring = IMP::serverString();
            $newmsgs = array();
            foreach ($folders as $folder => $true) {
                if (($folder == 'INBOX') ||
                    ($_SESSION['imp']['base_protocol'] != 'pop3')) {
                    /* Filter on INBOX display, if requested. */
                    if ($prefs->getValue('filter_on_display')) {
                        require_once IMP_BASE . '/lib/Filter.php';
                        IMP_Filter::filter();
                    }

                    $sts = imap_status($_SESSION['imp']['stream'], $serverstring . $folder, SA_UNSEEN | SA_RECENT);
                    if ($sts) {
                        if (!empty($sts->recent)) {
                            $newmsgs[$folder] = $sts->recent;
                        }
                        $url = Horde::addParameter(Horde::applicationUrl('mailbox.php', true), 'no_newmail_popup', 1);
                        $url = Horde::addParameter($url, 'mailbox', $folder);
                        $html .= '<tr class="text" onmouseover="javascript:style.backgroundColor=\'' . $css['.text-hi']['background-color'] . '\'; style.cursor=\'pointer\';" onmouseout="javascript:style.backgroundColor=\'' . $css['.text']['background-color'] . '\'" onclick="self.location=\'' . $url . '\'"><td>';
                        if (!empty($sts->unseen)) {
                            $html .= '<b>';
                        }
                        $html .= Horde::link($url, IMP::displayFolder($folder)) . IMP::displayFolder($folder) . '</a>';
                        if (!empty($sts->unseen)) {
                            $html .= '</b>';
                        }
                        $html .= '</td><td>&nbsp;&nbsp;&nbsp;</td><td>';
                        $html .= !empty($sts->unseen) ? '<b>' . $sts->unseen . '</b>' : '0';
                        $html .= '</td></tr>';
                    }
                }
            }
        } else {
            $html .= '<tr><td class="text">' . Horde::link(Horde::applicationUrl('index.php', true), sprintf(_("Log in to %s"), $registry->applications['imp']['name'])) . sprintf(_("Log in to %s"), $registry->applications['imp']['name']) . '</a></td></tr>';
        }

        $html .= '</table>';

        /* Check to see if user wants new mail notification */
        if ($prefs->getValue('nav_popup')) {
            global $__alert, $__mailbox_message;

            $__alert = '';
            $count = 0;
            foreach ($newmsgs as $mb => $nm) {
                $count++;
                $__mailbox_message = $mb;
                $__alert .= IMP::displayFolder($__mailbox_message) . ($nm > 1 ? _(" - $nm new messages") : _(" - $nm new message")) . '\n';
            }
            if (!empty($__alert)) {
                if ($count == 1) {
                    $html .= Horde::bufferOutput('require', IMP_TEMPLATES . '/folders/confirm.inc');
                } else {
                    $html .= Horde::bufferOutput('require', IMP_TEMPLATES . '/folders/alert.inc');
                }
            }
        }

        // Catch error messages from c-client.
        imap_errors();

        return $html;
    }

}
