<?php
/**
 * $Horde: imp/redirect.php,v 1.82 2003/07/17 19:58:30 slusarz Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('IMP_BASE', dirname(__FILE__));
$authentication = 'none';
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/Session.php';

/* Get the actionID. */
$actionID = (Horde::getFormData('action') == 'compose') ? 'login_compose' : Horde::getFormData('actionID');

$frameset = Horde::getFormData('frameset');
$imapuser = Horde::getPost('imapuser');
$pass = Horde::getPost('pass');

/* If we already have a session... */
if (isset($_SESSION['imp']) && is_array($_SESSION['imp'])) {
    /* Make sure that if a username was specified, it is the current
       username. */
    if ((is_null($imapuser) || ($imapuser == $_SESSION['imp']['user'])) &&
        (is_null($pass) || ($pass == Secret::read(Secret::getKey('imp'), $_SESSION['imp']['pass'])))) {

        $isLogin = IMP_Session::loginFlag();

        IMP_Session::loginTasks();

        $url = Horde::getFormData('url');
        if (empty($url)) {
            $url = IMP::getInitialUrl($actionID);
        } elseif (!empty($actionID)) {
            $url = Horde::addParameter($url, 'actionID', $actionID);
        }

        /* Don't show popup window in initial page. */
        if ($isLogin) {
            $url = Horde::addParameter($url, 'no_newmail_popup', 1);
        }

        /* Show frameset if we are aren't in there already. */
        if (!$frameset) {
            // $url = Horde::addParameter(Horde::applicationUrl($registry->getParam('webroot', 'horde') . '/index.php', true), 'url', $url);
        }

        header('Location: ' . $url);
        exit;
    } else {
        /* Disable the old session. */
        unset($_SESSION['imp']);
        header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', 'failed'), true));
        exit;
    }
}

/* Create a new session if we're given the proper parameters. */
if (!is_null($imapuser) && !is_null($pass)) {
    if (Auth::getProvider() == 'imp') {
        /* Destroy any existing session on login and make sure to use
         * a new session ID, to avoid session fixation issues. */
        Horde::getCleanSession();
    }
    $sessArray = array('realm'      => Horde::getFormData('realm'),
                       'port'       => Horde::getFormData('port'),
                       'protocol'   => Horde::getFormData('protocol'),
                       'maildomain' => Horde::getFormData('maildomain'),
                       'namespace'  => Horde::getFormData('namespace'),
                       'folders'    => Horde::getFormData('folders'));
    if (IMP_Session::createSession($imapuser, $pass, Horde::getFormData('server'), $sessArray)) {
        $entry = sprintf('Login success for %s [%s] to {%s:%s}', $imp['uniquser'], $_SERVER['REMOTE_ADDR'], $imp['server'], $imp['port']);
        Horde::logMessage($entry, __FILE__, __LINE__, PEAR_LOG_NOTICE);

        if (($horde_language = Horde::getFormData('new_lang'))) {
            $_SESSION['horde_language'] = $horde_language;
        }

        $isLogin = IMP_Session::loginFlag();

        IMP_Session::loginTasks();

        if (Horde::getFormData('url')) {
            $url = Horde::url(Horde::removeParameter(Horde::getFormData('url'), session_name()));
            if (!empty($actionID)) {
                $url = Horde::addParameter($url, 'actionID', $actionID);
            }
        } else {
            $url = IMP::getInitialUrl($actionID);
        }

        /* Don't show popup window in initial page. */
        if ($isLogin) {
            $url = Horde::addParameter($url, 'no_newmail_popup', 1);
        }

        /* Show frameset if we are aren't in there already. */
        if ($frameset) {
            $full_url = $url;
        } else {
            $full_url = Horde::applicationUrl($registry->getParam('webroot', 'horde') . '/index.php', true);
            $full_url = Horde::addParameter($full_url, 'url', $url);
        }

        header('Location: ' . $full_url);
        exit;
    } else {
        header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', 'failed'), true));
        exit;
    }
}

/* No session, and no login attempt. Just go to the login page. */
require IMP_BASE . '/login.php';
