<?php
/**
 * $Horde: kronolith/editeventaction.php,v 1.46 2003/05/22 16:56:58 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

$url = Horde::getFormData('url');

if (!Horde::getFormData('cancel')) {
    if (Horde::getFormData('delete')) {
        $delurl = 'delevent.php';
        Horde::addParameter($delurl, 'eventID', Horde::getFormData('eventID'));
        Horde::addParameter($delurl, 'calendar', Horde::getFormData('existingcalendar'));
        $location = Horde::applicationUrl($delUrl);
        if (!empty($url)) {
            $location = Horde::addParameter($location, 'url', $url);
        }
        if ($timestamp = Horde::getFormData('timestamp')) {
            $location = Horde::addParameter($location, 'timestamp', $timestamp);
        }
        header('Location: ' . $location);
    } else {
        $source = Horde::getFormData('existingcalendar');
        $target = Horde::getFormData('targetcalendar');
        $share = &$shares->getShare($target);

        if (is_a($share, 'PEAR_Error')) {
            $notification->push(sprintf(_("There was an error accessing the calendar: %s"), $share->getMessage()), 'horde.error');
        } else {
            if (Horde::getFormData('saveAsNew')) {
                $calendar->open($target);
                $event = &$calendar->getEventObject();

                // Don't go back to the old event.
                unset($url);
            } else {
                if ($target != $source) {
                    // Only delete the event from the source calendar
                    // if this user has permissions to do so.
                    $share = &$shares->getShare($source);
                    if (!is_a($share, 'PEAR_Error') &&
                        $share->hasPermission(Auth::getAuth(), _PERMS_DELETE)) {
                        $calendar->open($source);
                        $calendar->deleteEvent(Horde::getFormData('eventID'));
                        $calendar->close();
                    }

                    $calendar->open($target);
                    $event = &$calendar->getEventObject();
                } else {    
                    $calendar->open($source);
                    $event = &$calendar->getEventObject(Horde::getFormData('eventID'));
                }
            }

            if (!$share->hasPermission(Auth::getAuth(), _PERMS_EDIT, $event->getCreatorID())) {
                $notification->push(_("You do not have permission to edit this event."), 'horde.warning');
            } else {
                $event->readForm();
                $res = $event->save();
                if (is_a($res, 'PEAR_Error')) {
                    $notification->push(sprintf(_("There was an error editing the event: %s"), $res->getMessage()), 'horde.error');
                }
            }
        }
    }
}

if (!empty($url)) {
    $location = Horde::applicationUrl($url, true);
} else {
    $url = Horde::addParameter($prefs->getValue('defaultview') . '.php', 'month', Horde::getFormData('month'));
    $url = Horde::addParameter($url, 'year', Horde::getFormData('year'));
    $location = Horde::applicationUrl($url, true);
}

// Make sure URL is unique.
$location = Horde::addParameter($location, 'unique', md5(microtime()));

header('Location: ' . $location);
