<?php
/**
 * The Horde_Cipher_BlockMode_ofb64:: This class implements the
 * Horde_Cipher_BlockMode using a 64 bit output feedback. This can
 * used to encypt any length string and the encrypted version will be
 * the same length.
 *
 * $Horde: horde/lib/Cipher/BlockMode/ofb64.php,v 1.5 2003/02/06 15:07:58 mikec Exp $
 *
 * Copyright 2002-2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @version $Revision: 1.5 $
 * @since   Horde 2.2
 * @package horde.cipher
 */
class Horde_Cipher_BlockMode_ofb64 extends Horde_Cipher_BlockMode {

    function encrypt(&$cipher, $plaintext)
    {
        $encrypted = '';

        $n = 0;
        $jMax = strlen($plaintext);
        for ($j = 0; $j < $jMax; $j++) {
            if ($n == 0) {
                $this->_iv = $cipher->encryptBlock($this->_iv);
            }

            $c = $plaintext[$j] ^ $this->_iv[$n];
            $encrypted .= $c;

            $n = (++$n) & 0x07;
        }

        return $encrypted;
    }

    function decrypt(&$cipher, $ciphertext)
    {
        $decrypted = '';

        $n = 0;
        $jMax = strlen($ciphertext);
        for ($j = 0; $j < $jMax; $j++) {
            if ($n == 0) {
                $this->_iv = $cipher->encryptBlock($this->_iv);
            }

            $c = $ciphertext[$j] ^ $this->_iv[$n];
            $decrypted .= $c;

            $n = (++$n) & 0x07;
        }

        return $decrypted;
    }

}
