<?php
/*
 * $Horde: passwd/lib/Driver/expect.php,v 1.13 2003/06/26 01:38:00 mdjukic Exp $
 *
 * Copyright 2000       Gaudenz Steinlin <gaudenz@soziologie.ch>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 */

/**
 * The Passwd_expect class provides an expect implementation of the
 * passwd system.
 *
 * @author   Gaudenz Steinlin <gaudenz.steinlin@id.unibe.ch>
 * @version  $Revision: 1.13 $
 * @since    Passwd 2.2
 */
class Passwd_Driver_expect extends Passwd_Driver {

  /** Hash containing connection parameters. */
  var $params = array();

  /**
   * Constructs a new expect Passwd_Driver object.
   *
   * @param $params   A hash containing connection parameters.
   */
  function Passwd_Driver_expect($params = array()) {
    $this->params = $params;
  }

  /**
   * Change the users password by executing an excpect script
   * @param $user          User ID
   * @param $old_password  Old password
   * @param $new_password  New password
   *
   * @return true on success, false or error message on error
   */
  function changePassword($user, $old_password, $new_password) {

    global $conf;

    // temporary logfile for error messages
    $log = tempnam(ini_get('upload_tmp_dir')
        ? ini_get('upload_tmp_dir')
        : '/tmp', 'passwd');

    // open expect script for writing
    $prog = $this->params['program'] . ' -f ' . $this->params['script'] .
            ' -- ' . $this->params['params'] . ' -log ' . $log;

    $exp = @popen($prog, 'w');
    @fwrite($exp, "$user\n");
    @fwrite($exp, "$old_password\n");
    @fwrite($exp, "$new_password\n");
    $res = @pclose($exp);
    if ($res != 0) {
      $errormsg = implode(' ', @file($log));
      @unlink($log);
      return $errormsg ? PEAR::raiseError($errormsg) : false;
    } else {
      $this->resetCredentials($user, $old_password, $new_password);
      return true;
    }
  }
}
