<?php
/**
 * $Horde: passwd/lib/Driver/vmailmgr.php,v 1.8 2003/06/26 01:38:01 mdjukic Exp $
 *
 * The vmailmgr class attempts to change a user's password on a local vmailmgr daemon
 *
 * @author   Marco Kaiser <bate@php.net>
 * @package  passwd
 */
 class Passwd_Driver_vmailmgr extends Passwd_Driver {

    /** Hash containing configuration parameters. */
    var $_params;

    /**
     * Constructs a new vmailmgr Passwd_Driver object.
     *
     * @param array  $params    A hash containing connection parameters.
     */
    function Passwd_Driver_vmailmgr($params = array())
    {
        $this->_params = $params;
    }

    /**
     * Change the user's password.
     *
     * @param   $username      The user for which to change the password.
     * @param   $old_password  The old (current) user password.
     * @param   $new_password  The new user password to set.
     *
     * @return  boolean        True or false based on success of the change.
     */
    function changePassword($username, $old_password, $new_password) 
    {
        if (is_readable($this->_params['vmailinc']) && isset($this->_params['vmailinc'])) {
            @include($this->_params['vmailinc']);
        } else {
            return PEAR::raiseError('vmail.inc not found ! (' . $this->_params['vmailinc'] . ')');
        }
        
        $_splitted = split('@', $username);
        $_username = $_splitted[0];
        $_domain = $_splitted[1];
        $_returnChange = vchpass($_domain, $old_password, $_username, $new_password);
        
        if ($_returnChange[0] == 0) {
            $this->resetCredentials($username, $old_password, $newpassword);
            return true;
        }
        
        return PEAR::raiseError(_("Incorrect Password"));    
    }
}
