<?php
/**
 * $Horde: horde/prefs.php,v 2.12 2003/08/11 23:04:02 jan Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function prefs_callback()
{
    global $prefs, $js_onLoad;

    if ($prefs->isDirty('theme') || $prefs->isDirty('menu_view')) {
        $js_onLoad = 'if (window.parent.frames.horde_menu) window.parent.frames.horde_menu.location.reload();';
    }
}

function handle_showsummaryselect($updated)
{
    global $prefs;

    $show_summaries = Horde::getFormData('show_summaries');
    if (!is_null($show_summaries)) {
        $prefs->setValue('show_summaries', $show_summaries);
        $updated = true;
    }

    return $updated;
}

function handle_themeselect($updated)
{
    global $prefs;

    $theme = Horde::getFormData('theme');
    if (!is_null($theme)) {
        $prefs->setValue('theme', $theme);
        $updated = true;
    }

    return $updated;
}

define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require HORDE_BASE . '/config/prefs.php';

if (!Auth::getAuth()) {
    header('Location: ' . Horde::applicationUrl('login.php'), true);
    exit;
}

$js_onLoad = null;

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');

if (PrefsUI::handleForm($group)) {
    $group = null;
    include HORDE_BASE . '/config/prefs.php';
}

Horde::compressOutput();

/* Assign variables for select lists. */
if (!$prefs->isLocked('timezone')) {
    $timezone_options = &$tz;
}
if (!$prefs->isLocked('initial_application')) {
    $initial_application_options = array();
    $apps = $registry->listApps(array('active'));
    foreach ($apps as $app) {
        $initial_application_options[$app] = $registry->getParam('name', $app);
    }
}
if (!$prefs->isLocked('theme')) {
    $theme_options = array();
    $dh = @opendir(HORDE_BASE . '/config/themes');
    if (!$dh) {
        $notification->push("Theme directory can't be opened", 'horde.error');
    } else {
        while (($file = readdir($dh)) !== false) {
            if (substr($file, 0, 5) == 'html-' && substr($file, -4) == '.php') {
                $theme_name = null;
                @include HORDE_BASE . '/config/themes/' . $file;
                if (!empty($theme_name)) {
                    $theme_options[substr($file, 5, -4)] = $theme_name;
                }
            }
        }
    }
    asort($theme_options);
    $theme_options = array_merge(
        array('' => sprintf(_("%s Standard"), $GLOBALS['registry']->getParam('name'))),
        $theme_options
    );
}

$title = _("User Options");
require HORDE_TEMPLATES . '/common-header.inc';
require HORDE_BASE . '/navbar.php';

/* Show the UI. */
PrefsUI::generateUI($group);

require HORDE_TEMPLATES . '/common-footer.inc';
