/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test for bank widgets.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestbankwidgets.h"
#include "skgbkwidgetcollectiondesignerplugin.h"
#include "skgdocumentbank.h"
#include "skgquerycreator.h"
#include "skgtestmacro.h"
#include "skgunitcombobox.h"
#include <utility>

void SKGTESTBankWidgets::TestSKGUnitComboBox()
{
    SKGDocumentBank doc;
    QVERIFY2(!doc.load(SKGTest::getTestPath(QLatin1String("OUT")) % "/advice.skg"), "Load document failed");

    SKGUnitComboBox unitWidget(nullptr);
    unitWidget.setDocument(&doc);
    unitWidget.setWhereClauseCondition(QLatin1String("t_type='S'"));
    SKGUnitObject unit = unitWidget.getUnit();
    unitWidget.setUnit(unit);

    unitWidget.setText(QLatin1String("newunit"));
    SKGUnitObject newunit = unitWidget.getUnit();
}

void SKGTESTBankWidgets::TestSKGQueryCreator()
{
    SKGDocumentBank doc;
    QVERIFY2(!doc.load(SKGTest::getTestPath(QLatin1String("OUT")) % "/advice.skg"), "Load document failed");

    QStringList attributeForQuery;
    attributeForQuery << QLatin1String("d_date") << QLatin1String("t_number") << QLatin1String("t_mode") << QLatin1String("t_PAYEE") << QLatin1String("t_comment") << QLatin1String("t_REALCOMMENT") << QLatin1String("t_REALCATEGORY") << QLatin1String("t_status") << QLatin1String("t_bookmarked") << QLatin1String("t_imported") << QLatin1String("t_TRANSFER") << QLatin1String("t_UNIT") << QLatin1String("t_ACCOUNT") << QLatin1String("t_TOACCOUNT") << QLatin1String("f_REALCURRENTAMOUNT") << QLatin1String("t_REALREFUND") << QLatin1String("f_BALANCE");

    SKGQueryCreator creator(nullptr);
    creator.setParameters(&doc, QLatin1String("v_operation"), attributeForQuery);
    QCOMPARE(creator.getColumnsCount(), 0);
    QCOMPARE(creator.getLinesCount(), 1);

    QString cond = QLatin1String("<!DOCTYPE SKGML><element> <!--OR--> <element>  <!--AND-->  <element operator=\"#ATT# LIKE '%#V1S#%'\" att2s=\"\" attribute=\"t_PAYEE\" att2=\"\" value=\"VIR CAF \" value2=\"\"/> </element></element>");
    creator.setXMLCondition(cond);
    QTest::qWait(100);
    QString result = creator.getXMLCondition();

    QVERIFY(result.contains(QLatin1String("operator=\"#ATT# LIKE '%#V1S#%'\"")));
    QVERIFY(result.contains(QLatin1String("att2s=\"\"")));
    QVERIFY(result.contains(QLatin1String("attribute=\"t_PAYEE\"")));
    QVERIFY(result.contains(QLatin1String("att2=\"\"")));
    QVERIFY(result.contains(QLatin1String("value=\"VIR CAF \"")));
    QVERIFY(result.contains(QLatin1String("value2=\"\"")));

    QCOMPARE(creator.getColumnsCount(), 1);
    QCOMPARE(creator.getLinesCount(), 2);

    creator.addNewLine();
    QCOMPARE(creator.getColumnsCount(), 1);
    QCOMPARE(creator.getLinesCount(), 3);

    creator.removeLine(0);
    creator.removeLine(0);
    QCOMPARE(creator.getColumnsCount(), 1);
    QCOMPARE(creator.getLinesCount(), 1);

    creator.removeColumn(0);
    QCOMPARE(creator.getColumnsCount(), 0);
    QCOMPARE(creator.getLinesCount(), 1);

    creator.removeLine(0);
    QCOMPARE(creator.getColumnsCount(), 0);
    QCOMPARE(creator.getLinesCount(), 1);
}

void SKGTESTBankWidgets::TestSKGBKWidgetCollectionDesignerPlugin()
{
    SKGBKWidgetCollectionDesignerPlugin col(nullptr);
    QList<QDesignerCustomWidgetInterface*> items = col.customWidgets();
    for (auto item : std::as_const(items)) {
        QCOMPARE(item != nullptr, true);

        item->isContainer();
        QCOMPARE(item->isInitialized(), false);
        item->initialize(nullptr);
        QCOMPARE(item->isInitialized(), true);
        item->icon();
        QCOMPARE(item->domXml() != QLatin1String(""), true);
        QCOMPARE(item->group(), QLatin1String("SKG Widgets"));
        QCOMPARE(item->includeFile() != QLatin1String(""), true);
        QCOMPARE(item->name() != QLatin1String(""), true);
        QCOMPARE(item->toolTip() != QLatin1String(""), true);
        QCOMPARE(item->whatsThis() != QLatin1String(""), true);
        QCOMPARE(item->createWidget(nullptr) != nullptr, true);
    }
}

QTEST_MAIN(SKGTESTBankWidgets)

