/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"
#include <utility>

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true) {
        // Test import PDF skrooge
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_PDF"), err)
            QString dir = SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportpdf/";
            auto listFiles = QDir(dir).entryList(QStringList() << QLatin1String("*.pdf"), QDir::Files, QDir::Name);
            for (const auto& file : std::as_const(listFiles)) {
                SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(dir % file));
                SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
            }


            document1.dump(DUMPOPERATION | DUMPACCOUNT);
        }

        SKGAccountObject account;
        SKGTESTERROR(QLatin1String("ACCOUNT.getObjectByName"), SKGNamedObject::getObjectByName(&document1, QLatin1String("v_account"), QLatin1String("Facture allopneus"), account), true)
        SKGTESTERROR(QLatin1String("ACCOUNT.load"), account.load(), true)
        SKGTEST(QLatin1String("ACCOUNT:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-2041.24"))

        int nb = 0;
        SKGTESTERROR(QLatin1String("DOC:getNbObjects"), document1.getNbObjects(QLatin1String("operation"), QLatin1String(""), nb), true)
        SKGTEST(QLatin1String("DOC:getNbObjects"), nb, 11)

        SKGTESTERROR(QLatin1String("DOC:getNbObjects"), document1.getNbObjects(QLatin1String("operation"), QLatin1String("d_date='") + SKGServices::dateToSqlString(QDate::currentDate()) + '\'', nb), true)
        SKGTEST(QLatin1String("DOC:getNbObjects"), nb, 0)
    }
    // End test
    SKGENDTEST()
}
