/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgservices.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    // ============================================================================
    {
        // Test bank document
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGBankObject bank(&document1);
        SKGAccountObject account;
        SKGUnitObject unit_euro(&document1);
        SKGUnitValueObject unit_euro_val1;
        QDate d1 = QDate::currentDate().addMonths(-6);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("BANK_T1"), err)

            // Creation bank
            SKGTESTERROR(QLatin1String("BANK:setName"), bank.setName(QLatin1String("CREDIT COOP")), true)
            SKGTESTERROR(QLatin1String("BANK:save"), bank.save(), true)

            // Creation account
            SKGTESTERROR(QLatin1String("BANK:addAccount"), bank.addAccount(account), true)
            SKGTESTERROR(QLatin1String("ACCOUNT:setName"), account.setName(QLatin1String("Courant steph")), true)
            SKGTESTERROR(QLatin1String("ACCOUNT:save"), account.save(), true)

            // Creation unit
            SKGTESTERROR(QLatin1String("UNIT:setName"), unit_euro.setName(QLatin1String("euro")), true)
            SKGTESTERROR(QLatin1String("UNIT:save"), unit_euro.save(), true)

            // Creation unitvalue
            SKGTESTERROR(QLatin1String("UNIT:addUnitValue"), unit_euro.addUnitValue(unit_euro_val1), true)
            SKGTESTERROR(QLatin1String("UNITVALUE:setQuantity"), unit_euro_val1.setQuantity(1), true)
            SKGTESTERROR(QLatin1String("UNITVALUE:setDate"), unit_euro_val1.setDate(d1), true)
            SKGTESTERROR(QLatin1String("UNITVALUE:save"), unit_euro_val1.save(), true)

            // Creation operation
            SKGOperationObject op;
            SKGTESTERROR(QLatin1String("ACCOUNT:addOperation"), account.addOperation(op), true)
            SKGTESTERROR(QLatin1String("OPE:setMode"), op.setMode(QLatin1String("cheque")), true)
            SKGTESTERROR(QLatin1String("OPE:setDate"), op.setDate(d1), true)
            SKGTESTERROR(QLatin1String("OPE:setUnit"), op.setUnit(unit_euro), true)
            SKGTESTERROR(QLatin1String("OPE:save"), op.save(), true)

            SKGPayeeObject payee(&document1);
            SKGPayeeObject payeeCopy(payee);
            SKGPayeeObject payeeCopy2(static_cast<SKGObjectBase>(payee));
            SKGTESTERROR(QLatin1String("REF:setName"), payee.setName(QLatin1String("payee")), true)
            SKGTESTERROR(QLatin1String("REF:setAddress"), payee.setAddress(QLatin1String("address")), true)
            SKGTESTBOOL("REF:isBookmarked", payee.isBookmarked(), false)
            SKGTESTERROR(QLatin1String("REF:bookmark"), payee.bookmark(true), true)
            SKGTESTBOOL("REF:isBookmarked", payee.isBookmarked(), true)

            SKGTESTBOOL("REF:isClosed", payee.isClosed(), false)
            SKGTESTERROR(QLatin1String("REF:setClosed"), payee.setClosed(true), true)
            SKGTESTBOOL("REF:isClosed", payee.isClosed(), true)

            SKGTESTERROR(QLatin1String("REF:save"), payee.save(), true)
            SKGTEST(QLatin1String("REF:getName"), payee.getName(), QLatin1String("payee"))
            SKGTEST(QLatin1String("REF:getAddress"), payee.getAddress(), QLatin1String("address"))

            SKGTESTERROR(QLatin1String("OPE:setPayee"), op.setPayee(payee), true)
            SKGTESTERROR(QLatin1String("OPE:save"), op.save(), true)
            SKGPayeeObject payee2;
            SKGTESTERROR(QLatin1String("OPE:getPayee"), op.getPayee(payee2), true)
            SKGTESTBOOL("OPE:compare", (payee == payee2), true)

            SKGCategoryObject cat;
            SKGTESTERROR(QLatin1String("REF:getCategory"), payee.getCategory(cat), false)

            SKGTESTERROR(QLatin1String("CAT:createPathCategory"), SKGCategoryObject::createPathCategory(&document1, QLatin1String("A"), cat), true)
            SKGTESTERROR(QLatin1String("REF:setCategory"), payee.setCategory(cat), true)
            SKGTESTERROR(QLatin1String("REF:getCategory"), payee.getCategory(cat), true)

            SKGTESTERROR(QLatin1String("REF:save"), payee.save(), true)
            SKGTESTERROR(QLatin1String("REF:load"), payee.load(), true)

            SKGPayeeObject pay;
            SKGTESTERROR(QLatin1String("REF:createPayee"), SKGPayeeObject::createPayee(&document1, QLatin1String("pay"), pay, true), true)

            SKGTEST(QLatin1String("DOC:getCategoryForPayee"), document1.getCategoryForPayee(QLatin1String("payee")), QLatin1String("A"))

            // Merge
            SKGTESTERROR(QLatin1String("CAT:merge"), payee2.merge(pay), true)
        }
    }

    // End test
    SKGENDTEST()
}
