/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)
    QString filenameInput1 = SKGTest::getTestPath(QLatin1String("IN")) % "/all_plugins.skg";
    QString filenameOutput1 = SKGTest::getTestPath(QLatin1String("OUT")) % "/all_plugins_encrypted.skg";
    QString filenameOutput2 = SKGTest::getTestPath(QLatin1String("OUT")) % "/all_plugins_decrypted.skg";

    bool mode;
    SKGTESTERROR(QLatin1String("DOC:cryptFile"), SKGServices::cryptFile(QLatin1String("notfound"), filenameOutput1, QLatin1String("password"), true, QLatin1String("SKROOGE"), mode), false)
    SKGTESTERROR(QLatin1String("DOC:cryptFile"), SKGServices::cryptFile(filenameInput1, filenameOutput1, QLatin1String("password"), true, QLatin1String("SKROOGE"), mode), true)
    SKGTESTERROR(QLatin1String("DOC:cryptFile"), SKGServices::cryptFile(filenameOutput1, filenameOutput2, QLatin1String("password"), false, QLatin1String("SKROOGE"), mode), true)
    SKGTESTERROR(QLatin1String("DOC:cryptFile"), SKGServices::cryptFile(QLatin1String("notfound"), filenameOutput1, QLatin1String("password"), false, QLatin1String("SKROOGE"), mode), false)

    // End test
    SKGENDTEST()
}
