#ifndef LINK_H
#define LINK_H

#define DEPMOD_RELEASE		"0.8"
#define ETC_CONF_MODULES	"/etc/conf.modules"

#ifndef STDIO_H
	#include <stdio.h>
#endif


class MODULE;
struct SYMBOL{
	SYMBOL *next;	// Liste li pour hashing
	MODULE *module;	// Module qui dclare ce symbole
	char *name;
	char requis;		// Requis par d'autre module
	char defini;		// La dfinition a t vue
	char vue_avant;		// Dfinie avant d'etre vue
	char force;			// Chargement doit tre forc pour viter
						// un link multi passe.
	char is_common;		// ???
	char is_dup;		// Ce symbole a dj t charg d'un autre module
};

enum SYM_STATUS {
	SYM_PASUTIL,	// Requis par un module qui n'est pas requis lui meme.
	SYM_DEFINI,		// On a trouve un module qui le connait
	SYM_REQUIS		// Requis par un autre module
};

struct LIST_SYMBOL{
	LIST_SYMBOL *next;
	SYMBOL alloc[1];
	// Structure alloue plus longue
};

struct LIST_TEXTE {
	LIST_TEXTE *next;
	char alloc[1];
	// Structure alloue plus longue
};
	
class MODULES;
class SYMBOLS{
	SYMBOL *hash[2048];
	struct {
		LIST_SYMBOL *cur;
		int nb;
		SYMBOL *ptacc;
		SYMBOL *lastacc;
	} sym;
	/*~PROTOBEG~ SYMBOLS */
public:
	SYMBOLS (void);
	SYMBOL *add (const char *name,
		 MODULE *module,
		 SYM_STATUS status,
		 int &module_requis,
		 int is_common);
protected:
	void allocsym (void);
public:
	void dump (FILE *fout);
	int findforce (char **tb, int maxtb);
	/*~PROTOEND~ SYMBOLS */
};

struct MODULE{
	char *name;
	struct {		// Symbole publique et externe de ce module
		SYMBOL **tb;
		int nb;
	} pub,ext;
	char is_load;	// Ce module doit tre inclus dans le programme
	short lib;		// Numro de la librairie de provenance
};

class MODULES{
	MODULE *tbmod;
	int nbmod;
	char **tblibs;
	int nblib;
	/*~PROTOBEG~ MODULES */
public:
	MODULES (void);
	int findundef (FILE *fout);
	int loadlib (SYMBOLS&syms, const char *libname);
	int loadobj (SYMBOLS&syms, const char *objname);
	int multipass (void);
	void prtdepend (FILE *fout, const char *dontcare);
	MODULE *setdummy (const char *name);
private:
	void setmod (MODULE *mod,
		 SYMBOL *tbpub[],
		 int nbpub,
		 SYMBOL *tbext[],
		 int nbext,
		 int module_requis);
public:
	void showall (FILE *fout);
	int showload (FILE *fout);
	void showundef (SYMBOL *undef, FILE *fout);
	/*~PROTOEND~ MODULES */
};

#include "link.p"

#endif

