/*
 * Copyright (C) 2017  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _nbif_6_1_OFFSET_HEADER
#define _nbif_6_1_OFFSET_HEADER


// addressBlock: bif_cfg_dev0_epf0_bifcfgdecp
// base address: 0x0
#define cfgVENDOR_ID                                                                                    0x0000 // duplicate 
#define cfgDEVICE_ID                                                                                    0x0002 // duplicate 
#define cfgCOMMAND                                                                                      0x0004 // duplicate 
#define cfgSTATUS                                                                                       0x0006 // duplicate 
#define cfgREVISION_ID                                                                                  0x0008 // duplicate 
#define cfgPROG_INTERFACE                                                                               0x0009 // duplicate 
#define cfgSUB_CLASS                                                                                    0x000a // duplicate 
#define cfgBASE_CLASS                                                                                   0x000b // duplicate 
#define cfgCACHE_LINE                                                                                   0x000c // duplicate 
#define cfgLATENCY                                                                                      0x000d // duplicate 
#define cfgHEADER                                                                                       0x000e // duplicate 
#define cfgBIST                                                                                         0x000f // duplicate 
#define cfgBASE_ADDR_1                                                                                  0x0010 // duplicate 
#define cfgBASE_ADDR_2                                                                                  0x0014 // duplicate 
#define cfgBASE_ADDR_3                                                                                  0x0018 // duplicate 
#define cfgBASE_ADDR_4                                                                                  0x001c // duplicate 
#define cfgBASE_ADDR_5                                                                                  0x0020 // duplicate 
#define cfgBASE_ADDR_6                                                                                  0x0024 // duplicate 
#define cfgADAPTER_ID                                                                                   0x002c // duplicate 
#define cfgROM_BASE_ADDR                                                                                0x0030 // duplicate 
#define cfgCAP_PTR                                                                                      0x0034 // duplicate 
#define cfgINTERRUPT_LINE                                                                               0x003c // duplicate 
#define cfgINTERRUPT_PIN                                                                                0x003d // duplicate 
#define cfgMIN_GRANT                                                                                    0x003e // duplicate 
#define cfgMAX_LATENCY                                                                                  0x003f // duplicate 
#define cfgVENDOR_CAP_LIST                                                                              0x0048 // duplicate 
#define cfgADAPTER_ID_W                                                                                 0x004c // duplicate 
#define cfgPMI_CAP_LIST                                                                                 0x0050 // duplicate 
#define cfgPMI_CAP                                                                                      0x0052 // duplicate 
#define cfgPMI_STATUS_CNTL                                                                              0x0054 // duplicate 
#define cfgPCIE_CAP_LIST                                                                                0x0064 // duplicate 
#define cfgPCIE_CAP                                                                                     0x0066 // duplicate 
#define cfgDEVICE_CAP                                                                                   0x0068 // duplicate 
#define cfgDEVICE_CNTL                                                                                  0x006c // duplicate 
#define cfgDEVICE_STATUS                                                                                0x006e // duplicate 
#define cfgLINK_CAP                                                                                     0x0070 // duplicate 
#define cfgLINK_CNTL                                                                                    0x0074 // duplicate 
#define cfgLINK_STATUS                                                                                  0x0076 // duplicate 
#define cfgDEVICE_CAP2                                                                                  0x0088 // duplicate 
#define cfgDEVICE_CNTL2                                                                                 0x008c // duplicate 
#define cfgDEVICE_STATUS2                                                                               0x008e // duplicate 
#define cfgLINK_CAP2                                                                                    0x0090 // duplicate 
#define cfgLINK_CNTL2                                                                                   0x0094 // duplicate 
#define cfgLINK_STATUS2                                                                                 0x0096 // duplicate 
#define cfgSLOT_CAP2                                                                                    0x0098 // duplicate 
#define cfgSLOT_CNTL2                                                                                   0x009c // duplicate 
#define cfgSLOT_STATUS2                                                                                 0x009e // duplicate 
#define cfgMSI_CAP_LIST                                                                                 0x00a0 // duplicate 
#define cfgMSI_MSG_CNTL                                                                                 0x00a2 // duplicate 
#define cfgMSI_MSG_ADDR_LO                                                                              0x00a4 // duplicate 
#define cfgMSI_MSG_ADDR_HI                                                                              0x00a8 // duplicate 
#define cfgMSI_MSG_DATA                                                                                 0x00a8 // duplicate 
#define cfgMSI_MSG_DATA_64                                                                              0x00ac // duplicate 
#define cfgMSI_MASK                                                                                     0x00ac // duplicate 
#define cfgMSI_PENDING                                                                                  0x00b0 // duplicate 
#define cfgMSI_MASK_64                                                                                  0x00b0 // duplicate 
#define cfgMSI_PENDING_64                                                                               0x00b4 // duplicate 
#define cfgMSIX_CAP_LIST                                                                                0x00c0 // duplicate 
#define cfgMSIX_MSG_CNTL                                                                                0x00c2 // duplicate 
#define cfgMSIX_TABLE                                                                                   0x00c4 // duplicate 
#define cfgMSIX_PBA                                                                                     0x00c8 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                                            0x0100 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR                                                                     0x0104 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC1                                                                        0x0108 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC2                                                                        0x010c // duplicate 
#define cfgPCIE_VC_ENH_CAP_LIST                                                                         0x0110 // duplicate 
#define cfgPCIE_PORT_VC_CAP_REG1                                                                        0x0114 // duplicate 
#define cfgPCIE_PORT_VC_CAP_REG2                                                                        0x0118 // duplicate 
#define cfgPCIE_PORT_VC_CNTL                                                                            0x011c // duplicate 
#define cfgPCIE_PORT_VC_STATUS                                                                          0x011e // duplicate 
#define cfgPCIE_VC0_RESOURCE_CAP                                                                        0x0120 // duplicate 
#define cfgPCIE_VC0_RESOURCE_CNTL                                                                       0x0124 // duplicate 
#define cfgPCIE_VC0_RESOURCE_STATUS                                                                     0x012a // duplicate 
#define cfgPCIE_VC1_RESOURCE_CAP                                                                        0x012c // duplicate 
#define cfgPCIE_VC1_RESOURCE_CNTL                                                                       0x0130 // duplicate 
#define cfgPCIE_VC1_RESOURCE_STATUS                                                                     0x0136 // duplicate 
#define cfgPCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                                             0x0140 // duplicate 
#define cfgPCIE_DEV_SERIAL_NUM_DW1                                                                      0x0144 // duplicate 
#define cfgPCIE_DEV_SERIAL_NUM_DW2                                                                      0x0148 // duplicate 
#define cfgPCIE_ADV_ERR_RPT_ENH_CAP_LIST                                                                0x0150 // duplicate 
#define cfgPCIE_UNCORR_ERR_STATUS                                                                       0x0154 // duplicate 
#define cfgPCIE_UNCORR_ERR_MASK                                                                         0x0158 // duplicate 
#define cfgPCIE_UNCORR_ERR_SEVERITY                                                                     0x015c // duplicate 
#define cfgPCIE_CORR_ERR_STATUS                                                                         0x0160 // duplicate 
#define cfgPCIE_CORR_ERR_MASK                                                                           0x0164 // duplicate 
#define cfgPCIE_ADV_ERR_CAP_CNTL                                                                        0x0168 // duplicate 
#define cfgPCIE_HDR_LOG0                                                                                0x016c // duplicate 
#define cfgPCIE_HDR_LOG1                                                                                0x0170 // duplicate 
#define cfgPCIE_HDR_LOG2                                                                                0x0174 // duplicate 
#define cfgPCIE_HDR_LOG3                                                                                0x0178 // duplicate 
#define cfgPCIE_ROOT_ERR_CMD                                                                            0x017c // duplicate 
#define cfgPCIE_ROOT_ERR_STATUS                                                                         0x0180 // duplicate 
#define cfgPCIE_ERR_SRC_ID                                                                              0x0184 // duplicate 
#define cfgPCIE_TLP_PREFIX_LOG0                                                                         0x0188 // duplicate 
#define cfgPCIE_TLP_PREFIX_LOG1                                                                         0x018c // duplicate 
#define cfgPCIE_TLP_PREFIX_LOG2                                                                         0x0190 // duplicate 
#define cfgPCIE_TLP_PREFIX_LOG3                                                                         0x0194 // duplicate 
#define cfgPCIE_BAR_ENH_CAP_LIST                                                                        0x0200 // duplicate 
#define cfgPCIE_BAR1_CAP                                                                                0x0204 // duplicate 
#define cfgPCIE_BAR1_CNTL                                                                               0x0208 // duplicate 
#define cfgPCIE_BAR2_CAP                                                                                0x020c // duplicate 
#define cfgPCIE_BAR2_CNTL                                                                               0x0210 // duplicate 
#define cfgPCIE_BAR3_CAP                                                                                0x0214 // duplicate 
#define cfgPCIE_BAR3_CNTL                                                                               0x0218 // duplicate 
#define cfgPCIE_BAR4_CAP                                                                                0x021c // duplicate 
#define cfgPCIE_BAR4_CNTL                                                                               0x0220 // duplicate 
#define cfgPCIE_BAR5_CAP                                                                                0x0224 // duplicate 
#define cfgPCIE_BAR5_CNTL                                                                               0x0228 // duplicate 
#define cfgPCIE_BAR6_CAP                                                                                0x022c // duplicate 
#define cfgPCIE_BAR6_CNTL                                                                               0x0230 // duplicate 
#define cfgPCIE_PWR_BUDGET_ENH_CAP_LIST                                                                 0x0240 // duplicate 
#define cfgPCIE_PWR_BUDGET_DATA_SELECT                                                                  0x0244 // duplicate 
#define cfgPCIE_PWR_BUDGET_DATA                                                                         0x0248 // duplicate 
#define cfgPCIE_PWR_BUDGET_CAP                                                                          0x024c // duplicate 
#define cfgPCIE_DPA_ENH_CAP_LIST                                                                        0x0250 // duplicate 
#define cfgPCIE_DPA_CAP                                                                                 0x0254 // duplicate 
#define cfgPCIE_DPA_LATENCY_INDICATOR                                                                   0x0258 // duplicate 
#define cfgPCIE_DPA_STATUS                                                                              0x025c // duplicate 
#define cfgPCIE_DPA_CNTL                                                                                0x025e // duplicate 
#define cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_0                                                                0x0260 // duplicate 
#define cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_1                                                                0x0261 // duplicate 
#define cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_2                                                                0x0262 // duplicate 
#define cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_3                                                                0x0263 // duplicate 
#define cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_4                                                                0x0264 // duplicate 
#define cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_5                                                                0x0265 // duplicate 
#define cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_6                                                                0x0266 // duplicate 
#define cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_7                                                                0x0267 // duplicate 
#define cfgPCIE_SECONDARY_ENH_CAP_LIST                                                                  0x0270 // duplicate 
#define cfgPCIE_LINK_CNTL3                                                                              0x0274 // duplicate 
#define cfgPCIE_LANE_ERROR_STATUS                                                                       0x0278 // duplicate 
#define cfgPCIE_LANE_0_EQUALIZATION_CNTL                                                                0x027c // duplicate 
#define cfgPCIE_LANE_1_EQUALIZATION_CNTL                                                                0x027e // duplicate 
#define cfgPCIE_LANE_2_EQUALIZATION_CNTL                                                                0x0280 // duplicate 
#define cfgPCIE_LANE_3_EQUALIZATION_CNTL                                                                0x0282 // duplicate 
#define cfgPCIE_LANE_4_EQUALIZATION_CNTL                                                                0x0284 // duplicate 
#define cfgPCIE_LANE_5_EQUALIZATION_CNTL                                                                0x0286 // duplicate 
#define cfgPCIE_LANE_6_EQUALIZATION_CNTL                                                                0x0288 // duplicate 
#define cfgPCIE_LANE_7_EQUALIZATION_CNTL                                                                0x028a // duplicate 
#define cfgPCIE_LANE_8_EQUALIZATION_CNTL                                                                0x028c // duplicate 
#define cfgPCIE_LANE_9_EQUALIZATION_CNTL                                                                0x028e // duplicate 
#define cfgPCIE_LANE_10_EQUALIZATION_CNTL                                                               0x0290 // duplicate 
#define cfgPCIE_LANE_11_EQUALIZATION_CNTL                                                               0x0292 // duplicate 
#define cfgPCIE_LANE_12_EQUALIZATION_CNTL                                                               0x0294 // duplicate 
#define cfgPCIE_LANE_13_EQUALIZATION_CNTL                                                               0x0296 // duplicate 
#define cfgPCIE_LANE_14_EQUALIZATION_CNTL                                                               0x0298 // duplicate 
#define cfgPCIE_LANE_15_EQUALIZATION_CNTL                                                               0x029a // duplicate 
#define cfgPCIE_ACS_ENH_CAP_LIST                                                                        0x02a0 // duplicate 
#define cfgPCIE_ACS_CAP                                                                                 0x02a4 // duplicate 
#define cfgPCIE_ACS_CNTL                                                                                0x02a6 // duplicate 
#define cfgPCIE_ATS_ENH_CAP_LIST                                                                        0x02b0 // duplicate 
#define cfgPCIE_ATS_CAP                                                                                 0x02b4 // duplicate 
#define cfgPCIE_ATS_CNTL                                                                                0x02b6 // duplicate 
#define cfgPCIE_PAGE_REQ_ENH_CAP_LIST                                                                   0x02c0 // duplicate 
#define cfgPCIE_PAGE_REQ_CNTL                                                                           0x02c4 // duplicate 
#define cfgPCIE_PAGE_REQ_STATUS                                                                         0x02c6 // duplicate 
#define cfgPCIE_OUTSTAND_PAGE_REQ_CAPACITY                                                              0x02c8 // duplicate 
#define cfgPCIE_OUTSTAND_PAGE_REQ_ALLOC                                                                 0x02cc // duplicate 
#define cfgPCIE_PASID_ENH_CAP_LIST                                                                      0x02d0 // duplicate 
#define cfgPCIE_PASID_CAP                                                                               0x02d4 // duplicate 
#define cfgPCIE_PASID_CNTL                                                                              0x02d6 // duplicate 
#define cfgPCIE_TPH_REQR_ENH_CAP_LIST                                                                   0x02e0 // duplicate 
#define cfgPCIE_TPH_REQR_CAP                                                                            0x02e4 // duplicate 
#define cfgPCIE_TPH_REQR_CNTL                                                                           0x02e8 // duplicate 
#define cfgPCIE_MC_ENH_CAP_LIST                                                                         0x02f0 // duplicate 
#define cfgPCIE_MC_CAP                                                                                  0x02f4 // duplicate 
#define cfgPCIE_MC_CNTL                                                                                 0x02f6 // duplicate 
#define cfgPCIE_MC_ADDR0                                                                                0x02f8 // duplicate 
#define cfgPCIE_MC_ADDR1                                                                                0x02fc // duplicate 
#define cfgPCIE_MC_RCV0                                                                                 0x0300 // duplicate 
#define cfgPCIE_MC_RCV1                                                                                 0x0304 // duplicate 
#define cfgPCIE_MC_BLOCK_ALL0                                                                           0x0308 // duplicate 
#define cfgPCIE_MC_BLOCK_ALL1                                                                           0x030c // duplicate 
#define cfgPCIE_MC_BLOCK_UNTRANSLATED_0                                                                 0x0310 // duplicate 
#define cfgPCIE_MC_BLOCK_UNTRANSLATED_1                                                                 0x0314 // duplicate 
#define cfgPCIE_LTR_ENH_CAP_LIST                                                                        0x0320 // duplicate 
#define cfgPCIE_LTR_CAP                                                                                 0x0324 // duplicate 
#define cfgPCIE_ARI_ENH_CAP_LIST                                                                        0x0328 // duplicate 
#define cfgPCIE_ARI_CAP                                                                                 0x032c // duplicate 
#define cfgPCIE_ARI_CNTL                                                                                0x032e // duplicate 
#define cfgPCIE_SRIOV_ENH_CAP_LIST                                                                      0x0330 // duplicate 
#define cfgPCIE_SRIOV_CAP                                                                               0x0334 // duplicate 
#define cfgPCIE_SRIOV_CONTROL                                                                           0x0338 // duplicate 
#define cfgPCIE_SRIOV_STATUS                                                                            0x033a // duplicate 
#define cfgPCIE_SRIOV_INITIAL_VFS                                                                       0x033c // duplicate 
#define cfgPCIE_SRIOV_TOTAL_VFS                                                                         0x033e // duplicate 
#define cfgPCIE_SRIOV_NUM_VFS                                                                           0x0340 // duplicate 
#define cfgPCIE_SRIOV_FUNC_DEP_LINK                                                                     0x0342 // duplicate 
#define cfgPCIE_SRIOV_FIRST_VF_OFFSET                                                                   0x0344 // duplicate 
#define cfgPCIE_SRIOV_VF_STRIDE                                                                         0x0346 // duplicate 
#define cfgPCIE_SRIOV_VF_DEVICE_ID                                                                      0x034a // duplicate 
#define cfgPCIE_SRIOV_SUPPORTED_PAGE_SIZE                                                               0x034c // duplicate 
#define cfgPCIE_SRIOV_SYSTEM_PAGE_SIZE                                                                  0x0350 // duplicate 
#define cfgPCIE_SRIOV_VF_BASE_ADDR_0                                                                    0x0354 // duplicate 
#define cfgPCIE_SRIOV_VF_BASE_ADDR_1                                                                    0x0358 // duplicate 
#define cfgPCIE_SRIOV_VF_BASE_ADDR_2                                                                    0x035c // duplicate 
#define cfgPCIE_SRIOV_VF_BASE_ADDR_3                                                                    0x0360 // duplicate 
#define cfgPCIE_SRIOV_VF_BASE_ADDR_4                                                                    0x0364 // duplicate 
#define cfgPCIE_SRIOV_VF_BASE_ADDR_5                                                                    0x0368 // duplicate 
#define cfgPCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET                                                   0x036c // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV                                                     0x0400 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV                                                              0x0404 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW                                                 0x0408 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE                                                  0x040c // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS                                                  0x0410 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL                                                0x0414 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0                                                0x0418 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1                                                0x041c // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2                                                0x0420 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT                                                      0x0424 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB                                                     0x0428 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS                                                      0x042c // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB                                                       0x0430 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB                                                       0x0434 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB                                                       0x0438 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB                                                       0x043c // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB                                                       0x0440 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB                                                       0x0444 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB                                                       0x0448 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB                                                       0x044c // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB                                                       0x0450 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB                                                       0x0454 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB                                                      0x0458 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB                                                      0x045c // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB                                                      0x0460 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB                                                      0x0464 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB                                                      0x0468 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB                                                      0x046c // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW0                                                   0x0470 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW1                                                   0x0474 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW2                                                   0x0478 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW3                                                   0x047c // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW4                                                   0x0480 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW5                                                   0x0484 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW6                                                   0x0488 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW7                                                   0x048c // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW0                                                   0x0490 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW1                                                   0x0494 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW2                                                   0x0498 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW3                                                   0x049c // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW4                                                   0x04a0 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW5                                                   0x04a4 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW6                                                   0x04a8 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW7                                                   0x04ac // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW0                                                   0x04b0 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW1                                                   0x04b4 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW2                                                   0x04b8 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW3                                                   0x04bc // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW4                                                   0x04c0 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW5                                                   0x04c4 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW6                                                   0x04c8 // duplicate 
#define cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW7                                                   0x04cc // duplicate 


// addressBlock: bif_cfg_dev0_swds_bifcfgdecp
// base address: 0x0
#define mmSUB_BUS_NUMBER_LATENCY                                                                       0x0006 // duplicate 
#define mmSUB_BUS_NUMBER_LATENCY_BASE_IDX                                                              0
#define mmIO_BASE_LIMIT                                                                                0x0007 // duplicate 
#define mmIO_BASE_LIMIT_BASE_IDX                                                                       0
#define mmSECONDARY_STATUS                                                                             0x0007 // duplicate 
#define mmSECONDARY_STATUS_BASE_IDX                                                                    0
#define mmMEM_BASE_LIMIT                                                                               0x0008 // duplicate 
#define mmMEM_BASE_LIMIT_BASE_IDX                                                                      0
#define mmPREF_BASE_LIMIT                                                                              0x0009 // duplicate 
#define mmPREF_BASE_LIMIT_BASE_IDX                                                                     0
#define mmPREF_BASE_UPPER                                                                              0x000a // duplicate 
#define mmPREF_BASE_UPPER_BASE_IDX                                                                     0
#define mmPREF_LIMIT_UPPER                                                                             0x000b // duplicate 
#define mmPREF_LIMIT_UPPER_BASE_IDX                                                                    0
#define mmIO_BASE_LIMIT_HI                                                                             0x000c // duplicate 
#define mmIO_BASE_LIMIT_HI_BASE_IDX                                                                    0
#define mmIRQ_BRIDGE_CNTL                                                                              0x000f // duplicate 
#define mmIRQ_BRIDGE_CNTL_BASE_IDX                                                                     0
#define mmSLOT_CAP                                                                                     0x001b // duplicate 
#define mmSLOT_CAP_BASE_IDX                                                                            0
#define mmSLOT_CNTL                                                                                    0x001c // duplicate 
#define mmSLOT_CNTL_BASE_IDX                                                                           0
#define mmSLOT_STATUS                                                                                  0x001c // duplicate 
#define mmSLOT_STATUS_BASE_IDX                                                                         0
#define mmSSID_CAP_LIST                                                                                0x0030 // duplicate 
#define mmSSID_CAP_LIST_BASE_IDX                                                                       0
#define mmSSID_CAP                                                                                     0x0031 // duplicate 
#define mmSSID_CAP_BASE_IDX                                                                            0


// addressBlock: rcc_shadow_reg_shadowdec
// base address: 0x0
#define ixSHADOW_COMMAND                                                                               0x0004 // duplicate 
#define ixSHADOW_BASE_ADDR_1                                                                           0x0010 // duplicate 
#define ixSHADOW_BASE_ADDR_2                                                                           0x0014 // duplicate 
#define ixSHADOW_SUB_BUS_NUMBER_LATENCY                                                                0x0018 // duplicate 
#define ixSHADOW_IO_BASE_LIMIT                                                                         0x001c // duplicate 
#define ixSHADOW_MEM_BASE_LIMIT                                                                        0x0020 // duplicate 
#define ixSHADOW_PREF_BASE_LIMIT                                                                       0x0024 // duplicate 
#define ixSHADOW_PREF_BASE_UPPER                                                                       0x0028 // duplicate 
#define ixSHADOW_PREF_LIMIT_UPPER                                                                      0x002c // duplicate 
#define ixSHADOW_IO_BASE_LIMIT_HI                                                                      0x0030 // duplicate 
#define ixSHADOW_IRQ_BRIDGE_CNTL                                                                       0x003e // duplicate 
#define ixSUC_INDEX                                                                                    0x00e0 // duplicate 
#define ixSUC_DATA                                                                                     0x00e4 // duplicate 


// addressBlock: bif_bx_pf_SUMDEC
// base address: 0x0
#define ixSUM_INDEX                                                                                    0x00e0 // duplicate 
#define ixSUM_DATA                                                                                     0x00e4 // duplicate 


// addressBlock: gdc_GDCDEC
// base address: 0x1400000
#define mmA2S_CNTL_CL0                                                                                 0x4f0ab0 // duplicate 
#define mmA2S_CNTL_CL0_BASE_IDX                                                                        3
#define mmA2S_CNTL_CL1                                                                                 0x4f0ab1 // duplicate 
#define mmA2S_CNTL_CL1_BASE_IDX                                                                        3
#define mmA2S_CNTL_CL2                                                                                 0x4f0ab2 // duplicate 
#define mmA2S_CNTL_CL2_BASE_IDX                                                                        3
#define mmA2S_CNTL_CL3                                                                                 0x4f0ab3 // duplicate 
#define mmA2S_CNTL_CL3_BASE_IDX                                                                        3
#define mmA2S_CNTL_CL4                                                                                 0x4f0ab4 // duplicate 
#define mmA2S_CNTL_CL4_BASE_IDX                                                                        3
#define mmA2S_CNTL_SW0                                                                                 0x4f0ad0 // duplicate 
#define mmA2S_CNTL_SW0_BASE_IDX                                                                        3
#define mmA2S_CNTL_SW1                                                                                 0x4f0ad1 // duplicate 
#define mmA2S_CNTL_SW1_BASE_IDX                                                                        3
#define mmA2S_CNTL_SW2                                                                                 0x4f0ad2 // duplicate 
#define mmA2S_CNTL_SW2_BASE_IDX                                                                        3
#define mmNGDC_MGCG_CTRL                                                                               0x4f0ae0 // duplicate 
#define mmNGDC_MGCG_CTRL_BASE_IDX                                                                      3
#define mmA2S_MISC_CNTL                                                                                0x4f0ae1 // duplicate 
#define mmA2S_MISC_CNTL_BASE_IDX                                                                       3
#define mmNGDC_SDP_PORT_CTRL                                                                           0x4f0ae2 // duplicate 
#define mmNGDC_SDP_PORT_CTRL_BASE_IDX                                                                  3
#define mmNGDC_RESERVED_0                                                                              0x4f0aeb // duplicate 
#define mmNGDC_RESERVED_0_BASE_IDX                                                                     3
#define mmNGDC_RESERVED_1                                                                              0x4f0aec // duplicate 
#define mmNGDC_RESERVED_1_BASE_IDX                                                                     3
#define mmBIF_SDMA0_DOORBELL_RANGE                                                                     0x4f0af0 // duplicate 
#define mmBIF_SDMA0_DOORBELL_RANGE_BASE_IDX                                                            3
#define mmBIF_SDMA1_DOORBELL_RANGE                                                                     0x4f0af1 // duplicate 
#define mmBIF_SDMA1_DOORBELL_RANGE_BASE_IDX                                                            3
#define mmBIF_IH_DOORBELL_RANGE                                                                        0x4f0af2 // duplicate 
#define mmBIF_IH_DOORBELL_RANGE_BASE_IDX                                                               3
#define mmBIF_MMSCH0_DOORBELL_RANGE                                                                    0x4f0af3 // duplicate 
#define mmBIF_MMSCH0_DOORBELL_RANGE_BASE_IDX                                                           3
#define mmBIF_DOORBELL_FENCE_CNTL                                                                      0x4f0afe // duplicate 
#define mmBIF_DOORBELL_FENCE_CNTL_BASE_IDX                                                             3
#define mmS2A_MISC_CNTL                                                                                0x4f0aff // duplicate 
#define mmS2A_MISC_CNTL_BASE_IDX                                                                       3
#define mmA2S_CNTL2_SEC_CL0                                                                            0x4f0b00 // duplicate 
#define mmA2S_CNTL2_SEC_CL0_BASE_IDX                                                                   3
#define mmA2S_CNTL2_SEC_CL1                                                                            0x4f0b01 // duplicate 
#define mmA2S_CNTL2_SEC_CL1_BASE_IDX                                                                   3
#define mmA2S_CNTL2_SEC_CL2                                                                            0x4f0b02 // duplicate 
#define mmA2S_CNTL2_SEC_CL2_BASE_IDX                                                                   3
#define mmA2S_CNTL2_SEC_CL3                                                                            0x4f0b03 // duplicate 
#define mmA2S_CNTL2_SEC_CL3_BASE_IDX                                                                   3
#define mmA2S_CNTL2_SEC_CL4                                                                            0x4f0b04 // duplicate 
#define mmA2S_CNTL2_SEC_CL4_BASE_IDX                                                                   3


// addressBlock: nbif_sion_SIONDEC
// base address: 0x1400000
#define ixSION_CL0_RdRsp_BurstTarget_REG0                                                              0x1e000 
#define ixSION_CL0_RdRsp_BurstTarget_REG1                                                              0x1e004 
#define ixSION_CL0_RdRsp_TimeSlot_REG0                                                                 0x1e008 
#define ixSION_CL0_RdRsp_TimeSlot_REG1                                                                 0x1e00c 
#define ixSION_CL0_WrRsp_BurstTarget_REG0                                                              0x1e010 
#define ixSION_CL0_WrRsp_BurstTarget_REG1                                                              0x1e014 
#define ixSION_CL0_WrRsp_TimeSlot_REG0                                                                 0x1e018 
#define ixSION_CL0_WrRsp_TimeSlot_REG1                                                                 0x1e01c 
#define ixSION_CL0_Req_BurstTarget_REG0                                                                0x1e020 
#define ixSION_CL0_Req_BurstTarget_REG1                                                                0x1e024 
#define ixSION_CL0_Req_TimeSlot_REG0                                                                   0x1e028 
#define ixSION_CL0_Req_TimeSlot_REG1                                                                   0x1e02c 
#define ixSION_CL0_ReqPoolCredit_Alloc_REG0                                                            0x1e030 
#define ixSION_CL0_ReqPoolCredit_Alloc_REG1                                                            0x1e034 
#define ixSION_CL0_DataPoolCredit_Alloc_REG0                                                           0x1e038 
#define ixSION_CL0_DataPoolCredit_Alloc_REG1                                                           0x1e03c 
#define ixSION_CL0_RdRspPoolCredit_Alloc_REG0                                                          0x1e040 
#define ixSION_CL0_RdRspPoolCredit_Alloc_REG1                                                          0x1e044 
#define ixSION_CL0_WrRspPoolCredit_Alloc_REG0                                                          0x1e048 
#define ixSION_CL0_WrRspPoolCredit_Alloc_REG1                                                          0x1e04c 
#define ixSION_CL1_RdRsp_BurstTarget_REG0                                                              0x1e050 
#define ixSION_CL1_RdRsp_BurstTarget_REG1                                                              0x1e054 
#define ixSION_CL1_RdRsp_TimeSlot_REG0                                                                 0x1e058 
#define ixSION_CL1_RdRsp_TimeSlot_REG1                                                                 0x1e05c 
#define ixSION_CL1_WrRsp_BurstTarget_REG0                                                              0x1e060 
#define ixSION_CL1_WrRsp_BurstTarget_REG1                                                              0x1e064 
#define ixSION_CL1_WrRsp_TimeSlot_REG0                                                                 0x1e068 
#define ixSION_CL1_WrRsp_TimeSlot_REG1                                                                 0x1e06c 
#define ixSION_CL1_Req_BurstTarget_REG0                                                                0x1e070 
#define ixSION_CL1_Req_BurstTarget_REG1                                                                0x1e074 
#define ixSION_CL1_Req_TimeSlot_REG0                                                                   0x1e078 
#define ixSION_CL1_Req_TimeSlot_REG1                                                                   0x1e07c 
#define ixSION_CL1_ReqPoolCredit_Alloc_REG0                                                            0x1e080 
#define ixSION_CL1_ReqPoolCredit_Alloc_REG1                                                            0x1e084 
#define ixSION_CL1_DataPoolCredit_Alloc_REG0                                                           0x1e088 
#define ixSION_CL1_DataPoolCredit_Alloc_REG1                                                           0x1e08c 
#define ixSION_CL1_RdRspPoolCredit_Alloc_REG0                                                          0x1e090 
#define ixSION_CL1_RdRspPoolCredit_Alloc_REG1                                                          0x1e094 
#define ixSION_CL1_WrRspPoolCredit_Alloc_REG0                                                          0x1e098 
#define ixSION_CL1_WrRspPoolCredit_Alloc_REG1                                                          0x1e09c 
#define ixSION_CL2_RdRsp_BurstTarget_REG0                                                              0x1e0a0 
#define ixSION_CL2_RdRsp_BurstTarget_REG1                                                              0x1e0a4 
#define ixSION_CL2_RdRsp_TimeSlot_REG0                                                                 0x1e0a8 
#define ixSION_CL2_RdRsp_TimeSlot_REG1                                                                 0x1e0ac 
#define ixSION_CL2_WrRsp_BurstTarget_REG0                                                              0x1e0b0 
#define ixSION_CL2_WrRsp_BurstTarget_REG1                                                              0x1e0b4 
#define ixSION_CL2_WrRsp_TimeSlot_REG0                                                                 0x1e0b8 
#define ixSION_CL2_WrRsp_TimeSlot_REG1                                                                 0x1e0bc 
#define ixSION_CL2_Req_BurstTarget_REG0                                                                0x1e0c0 
#define ixSION_CL2_Req_BurstTarget_REG1                                                                0x1e0c4 
#define ixSION_CL2_Req_TimeSlot_REG0                                                                   0x1e0c8 
#define ixSION_CL2_Req_TimeSlot_REG1                                                                   0x1e0cc 
#define ixSION_CL2_ReqPoolCredit_Alloc_REG0                                                            0x1e0d0 
#define ixSION_CL2_ReqPoolCredit_Alloc_REG1                                                            0x1e0d4 
#define ixSION_CL2_DataPoolCredit_Alloc_REG0                                                           0x1e0d8 
#define ixSION_CL2_DataPoolCredit_Alloc_REG1                                                           0x1e0dc 
#define ixSION_CL2_RdRspPoolCredit_Alloc_REG0                                                          0x1e0e0 
#define ixSION_CL2_RdRspPoolCredit_Alloc_REG1                                                          0x1e0e4 
#define ixSION_CL2_WrRspPoolCredit_Alloc_REG0                                                          0x1e0e8 
#define ixSION_CL2_WrRspPoolCredit_Alloc_REG1                                                          0x1e0ec 
#define ixSION_CL3_RdRsp_BurstTarget_REG0                                                              0x1e0f0 
#define ixSION_CL3_RdRsp_BurstTarget_REG1                                                              0x1e0f4 
#define ixSION_CL3_RdRsp_TimeSlot_REG0                                                                 0x1e0f8 
#define ixSION_CL3_RdRsp_TimeSlot_REG1                                                                 0x1e0fc 
#define ixSION_CL3_WrRsp_BurstTarget_REG0                                                              0x1e100 
#define ixSION_CL3_WrRsp_BurstTarget_REG1                                                              0x1e104 
#define ixSION_CL3_WrRsp_TimeSlot_REG0                                                                 0x1e108 
#define ixSION_CL3_WrRsp_TimeSlot_REG1                                                                 0x1e10c 
#define ixSION_CL3_Req_BurstTarget_REG0                                                                0x1e110 
#define ixSION_CL3_Req_BurstTarget_REG1                                                                0x1e114 
#define ixSION_CL3_Req_TimeSlot_REG0                                                                   0x1e118 
#define ixSION_CL3_Req_TimeSlot_REG1                                                                   0x1e11c 
#define ixSION_CL3_ReqPoolCredit_Alloc_REG0                                                            0x1e120 
#define ixSION_CL3_ReqPoolCredit_Alloc_REG1                                                            0x1e124 
#define ixSION_CL3_DataPoolCredit_Alloc_REG0                                                           0x1e128 
#define ixSION_CL3_DataPoolCredit_Alloc_REG1                                                           0x1e12c 
#define ixSION_CL3_RdRspPoolCredit_Alloc_REG0                                                          0x1e130 
#define ixSION_CL3_RdRspPoolCredit_Alloc_REG1                                                          0x1e134 
#define ixSION_CL3_WrRspPoolCredit_Alloc_REG0                                                          0x1e138 
#define ixSION_CL3_WrRspPoolCredit_Alloc_REG1                                                          0x1e13c 
#define ixSION_CL4_RdRsp_BurstTarget_REG0                                                              0x1e140 
#define ixSION_CL4_RdRsp_BurstTarget_REG1                                                              0x1e144 
#define ixSION_CL4_RdRsp_TimeSlot_REG0                                                                 0x1e148 
#define ixSION_CL4_RdRsp_TimeSlot_REG1                                                                 0x1e14c 
#define ixSION_CL4_WrRsp_BurstTarget_REG0                                                              0x1e150 
#define ixSION_CL4_WrRsp_BurstTarget_REG1                                                              0x1e154 
#define ixSION_CL4_WrRsp_TimeSlot_REG0                                                                 0x1e158 
#define ixSION_CL4_WrRsp_TimeSlot_REG1                                                                 0x1e15c 
#define ixSION_CL4_Req_BurstTarget_REG0                                                                0x1e160 
#define ixSION_CL4_Req_BurstTarget_REG1                                                                0x1e164 
#define ixSION_CL4_Req_TimeSlot_REG0                                                                   0x1e168 
#define ixSION_CL4_Req_TimeSlot_REG1                                                                   0x1e16c 
#define ixSION_CL4_ReqPoolCredit_Alloc_REG0                                                            0x1e170 
#define ixSION_CL4_ReqPoolCredit_Alloc_REG1                                                            0x1e174 
#define ixSION_CL4_DataPoolCredit_Alloc_REG0                                                           0x1e178 
#define ixSION_CL4_DataPoolCredit_Alloc_REG1                                                           0x1e17c 
#define ixSION_CL4_RdRspPoolCredit_Alloc_REG0                                                          0x1e180 
#define ixSION_CL4_RdRspPoolCredit_Alloc_REG1                                                          0x1e184 
#define ixSION_CL4_WrRspPoolCredit_Alloc_REG0                                                          0x1e188 
#define ixSION_CL4_WrRspPoolCredit_Alloc_REG1                                                          0x1e18c 
#define ixSION_CL5_RdRsp_BurstTarget_REG0                                                              0x1e190 
#define ixSION_CL5_RdRsp_BurstTarget_REG1                                                              0x1e194 
#define ixSION_CL5_RdRsp_TimeSlot_REG0                                                                 0x1e198 
#define ixSION_CL5_RdRsp_TimeSlot_REG1                                                                 0x1e19c 
#define ixSION_CL5_WrRsp_BurstTarget_REG0                                                              0x1e1a0 
#define ixSION_CL5_WrRsp_BurstTarget_REG1                                                              0x1e1a4 
#define ixSION_CL5_WrRsp_TimeSlot_REG0                                                                 0x1e1a8 
#define ixSION_CL5_WrRsp_TimeSlot_REG1                                                                 0x1e1ac 
#define ixSION_CL5_Req_BurstTarget_REG0                                                                0x1e1b0 
#define ixSION_CL5_Req_BurstTarget_REG1                                                                0x1e1b4 
#define ixSION_CL5_Req_TimeSlot_REG0                                                                   0x1e1b8 
#define ixSION_CL5_Req_TimeSlot_REG1                                                                   0x1e1bc 
#define ixSION_CL5_ReqPoolCredit_Alloc_REG0                                                            0x1e1c0 
#define ixSION_CL5_ReqPoolCredit_Alloc_REG1                                                            0x1e1c4 
#define ixSION_CL5_DataPoolCredit_Alloc_REG0                                                           0x1e1c8 
#define ixSION_CL5_DataPoolCredit_Alloc_REG1                                                           0x1e1cc 
#define ixSION_CL5_RdRspPoolCredit_Alloc_REG0                                                          0x1e1d0 
#define ixSION_CL5_RdRspPoolCredit_Alloc_REG1                                                          0x1e1d4 
#define ixSION_CL5_WrRspPoolCredit_Alloc_REG0                                                          0x1e1d8 
#define ixSION_CL5_WrRspPoolCredit_Alloc_REG1                                                          0x1e1dc 
#define ixSION_CNTL_REG0                                                                               0x1e1e0 
#define ixSION_CNTL_REG1                                                                               0x1e1e4 


// addressBlock: syshub_mmreg_direct_syshubdirect
// base address: 0x1400000
#define ixSYSHUB_DS_CTRL_SOCCLK                                                                        0x10000 // duplicate 
#define ixSYSHUB_DS_CTRL2_SOCCLK                                                                       0x10004 // duplicate 
#define ixSYSHUB_BGEN_ENHANCEMENT_BYPASS_EN_SOCCLK                                                     0x10008 // duplicate 
#define ixSYSHUB_BGEN_ENHANCEMENT_IMM_EN_SOCCLK                                                        0x1000c // duplicate 
#define ixDMA_CLK0_SW0_SYSHUB_QOS_CNTL                                                                 0x10010 // duplicate 
#define ixDMA_CLK0_SW1_SYSHUB_QOS_CNTL                                                                 0x10014 // duplicate 
#define ixDMA_CLK0_SW0_CL0_CNTL                                                                        0x10018 // duplicate 
#define ixDMA_CLK0_SW0_CL1_CNTL                                                                        0x1001c // duplicate 
#define ixDMA_CLK0_SW0_CL2_CNTL                                                                        0x10020 // duplicate 
#define ixDMA_CLK0_SW0_CL3_CNTL                                                                        0x10024 // duplicate 
#define ixDMA_CLK0_SW0_CL4_CNTL                                                                        0x10028 // duplicate 
#define ixDMA_CLK0_SW0_CL5_CNTL                                                                        0x1002c // duplicate 
#define ixDMA_CLK0_SW1_CL0_CNTL                                                                        0x10030 // duplicate 
#define ixDMA_CLK0_SW2_CL0_CNTL                                                                        0x10034 // duplicate 
#define ixSYSHUB_CG_CNTL                                                                               0x10300 // duplicate 
#define ixSYSHUB_TRANS_IDLE                                                                            0x10308 // duplicate 
#define ixSYSHUB_HP_TIMER                                                                              0x1030c // duplicate 
#define ixSYSHUB_SCRATCH                                                                               0x10f00 // duplicate 
#define ixSYSHUB_DS_CTRL_SHUBCLK                                                                       0x11000 // duplicate 
#define ixSYSHUB_DS_CTRL2_SHUBCLK                                                                      0x11004 // duplicate 
#define ixSYSHUB_BGEN_ENHANCEMENT_BYPASS_EN_SHUBCLK                                                    0x11008 // duplicate 
#define ixSYSHUB_BGEN_ENHANCEMENT_IMM_EN_SHUBCLK                                                       0x1100c // duplicate 
#define ixDMA_CLK1_SW0_SYSHUB_QOS_CNTL                                                                 0x11010 // duplicate 
#define ixDMA_CLK1_SW1_SYSHUB_QOS_CNTL                                                                 0x11014 // duplicate 
#define ixDMA_CLK1_SW0_CL0_CNTL                                                                        0x11018 // duplicate 
#define ixDMA_CLK1_SW0_CL1_CNTL                                                                        0x1101c // duplicate 
#define ixDMA_CLK1_SW0_CL2_CNTL                                                                        0x11020 // duplicate 
#define ixDMA_CLK1_SW0_CL3_CNTL                                                                        0x11024 // duplicate 
#define ixDMA_CLK1_SW0_CL4_CNTL                                                                        0x11028 // duplicate 
#define ixDMA_CLK1_SW1_CL0_CNTL                                                                        0x1102c // duplicate 
#define ixDMA_CLK1_SW1_CL1_CNTL                                                                        0x11030 // duplicate 
#define ixDMA_CLK1_SW1_CL2_CNTL                                                                        0x11034 // duplicate 
#define ixDMA_CLK1_SW1_CL3_CNTL                                                                        0x11038 // duplicate 
#define ixDMA_CLK1_SW1_CL4_CNTL                                                                        0x1103c // duplicate 


// addressBlock: gdc_ras_gdc_ras_regblk
// base address: 0x1400000
#define ixGDC_RAS_LEAF0_CTRL                                                                           0x1f800 
#define ixGDC_RAS_LEAF1_CTRL                                                                           0x1f804 
#define ixGDC_RAS_LEAF2_CTRL                                                                           0x1f808 
#define ixGDC_RAS_LEAF3_CTRL                                                                           0x1f80c 
#define ixGDC_RAS_LEAF4_CTRL                                                                           0x1f810 
#define ixGDC_RAS_LEAF5_CTRL                                                                           0x1f814 


// addressBlock: gdc_rst_GDCRST_DEC
// base address: 0x1400000
#define ixSHUB_PF_FLR_RST                                                                              0x1f000 
#define ixSHUB_GFX_DRV_MODE1_RST                                                                       0x1f004 
#define ixSHUB_LINK_RESET                                                                              0x1f008 
#define ixSHUB_PF0_VF_FLR_RST                                                                          0x1f020 
#define ixSHUB_HARD_RST_CTRL                                                                           0x1f040 
#define ixSHUB_SOFT_RST_CTRL                                                                           0x1f044 
#define ixSHUB_SDP_PORT_RST                                                                            0x1f048 


// memoryMap:EP0F0Reg


// addressBlock: bif_bx_pf_SYSDEC
// base address: 0x0
#define mmSBIOS_SCRATCH_0                                                                              0x0048 // duplicate 
#define mmSBIOS_SCRATCH_0_BASE_IDX                                                                     0
#define mmSBIOS_SCRATCH_1                                                                              0x0049 // duplicate 
#define mmSBIOS_SCRATCH_1_BASE_IDX                                                                     0
#define mmSBIOS_SCRATCH_2                                                                              0x004a // duplicate 
#define mmSBIOS_SCRATCH_2_BASE_IDX                                                                     0
#define mmSBIOS_SCRATCH_3                                                                              0x004b // duplicate 
#define mmSBIOS_SCRATCH_3_BASE_IDX                                                                     0
#define mmBIOS_SCRATCH_0                                                                               0x004c // duplicate 
#define mmBIOS_SCRATCH_0_BASE_IDX                                                                      0
#define mmBIOS_SCRATCH_1                                                                               0x004d // duplicate 
#define mmBIOS_SCRATCH_1_BASE_IDX                                                                      0
#define mmBIOS_SCRATCH_2                                                                               0x004e // duplicate 
#define mmBIOS_SCRATCH_2_BASE_IDX                                                                      0
#define mmBIOS_SCRATCH_3                                                                               0x004f // duplicate 
#define mmBIOS_SCRATCH_3_BASE_IDX                                                                      0
#define mmBIOS_SCRATCH_4                                                                               0x0050 // duplicate 
#define mmBIOS_SCRATCH_4_BASE_IDX                                                                      0
#define mmBIOS_SCRATCH_5                                                                               0x0051 // duplicate 
#define mmBIOS_SCRATCH_5_BASE_IDX                                                                      0
#define mmBIOS_SCRATCH_6                                                                               0x0052 // duplicate 
#define mmBIOS_SCRATCH_6_BASE_IDX                                                                      0
#define mmBIOS_SCRATCH_7                                                                               0x0053 // duplicate 
#define mmBIOS_SCRATCH_7_BASE_IDX                                                                      0
#define mmBIOS_SCRATCH_8                                                                               0x0054 // duplicate 
#define mmBIOS_SCRATCH_8_BASE_IDX                                                                      0
#define mmBIOS_SCRATCH_9                                                                               0x0055 // duplicate 
#define mmBIOS_SCRATCH_9_BASE_IDX                                                                      0
#define mmBIOS_SCRATCH_10                                                                              0x0056 // duplicate 
#define mmBIOS_SCRATCH_10_BASE_IDX                                                                     0
#define mmBIOS_SCRATCH_11                                                                              0x0057 // duplicate 
#define mmBIOS_SCRATCH_11_BASE_IDX                                                                     0
#define mmBIOS_SCRATCH_12                                                                              0x0058 // duplicate 
#define mmBIOS_SCRATCH_12_BASE_IDX                                                                     0
#define mmBIOS_SCRATCH_13                                                                              0x0059 // duplicate 
#define mmBIOS_SCRATCH_13_BASE_IDX                                                                     0
#define mmBIOS_SCRATCH_14                                                                              0x005a // duplicate 
#define mmBIOS_SCRATCH_14_BASE_IDX                                                                     0
#define mmBIOS_SCRATCH_15                                                                              0x005b // duplicate 
#define mmBIOS_SCRATCH_15_BASE_IDX                                                                     0
#define mmBIF_RLC_INTR_CNTL                                                                            0x0060 // duplicate 
#define mmBIF_RLC_INTR_CNTL_BASE_IDX                                                                   0
#define mmBIF_VCE_INTR_CNTL                                                                            0x0061 // duplicate 
#define mmBIF_VCE_INTR_CNTL_BASE_IDX                                                                   0
#define mmBIF_UVD_INTR_CNTL                                                                            0x0062 // duplicate 
#define mmBIF_UVD_INTR_CNTL_BASE_IDX                                                                   0
#define mmGFX_MMIOREG_CAM_ADDR0                                                                        0x0080 // duplicate 
#define mmGFX_MMIOREG_CAM_ADDR0_BASE_IDX                                                               0
#define mmGFX_MMIOREG_CAM_REMAP_ADDR0                                                                  0x0081 // duplicate 
#define mmGFX_MMIOREG_CAM_REMAP_ADDR0_BASE_IDX                                                         0
#define mmGFX_MMIOREG_CAM_ADDR1                                                                        0x0082 // duplicate 
#define mmGFX_MMIOREG_CAM_ADDR1_BASE_IDX                                                               0
#define mmGFX_MMIOREG_CAM_REMAP_ADDR1                                                                  0x0083 // duplicate 
#define mmGFX_MMIOREG_CAM_REMAP_ADDR1_BASE_IDX                                                         0
#define mmGFX_MMIOREG_CAM_ADDR2                                                                        0x0084 // duplicate 
#define mmGFX_MMIOREG_CAM_ADDR2_BASE_IDX                                                               0
#define mmGFX_MMIOREG_CAM_REMAP_ADDR2                                                                  0x0085 // duplicate 
#define mmGFX_MMIOREG_CAM_REMAP_ADDR2_BASE_IDX                                                         0
#define mmGFX_MMIOREG_CAM_ADDR3                                                                        0x0086 // duplicate 
#define mmGFX_MMIOREG_CAM_ADDR3_BASE_IDX                                                               0
#define mmGFX_MMIOREG_CAM_REMAP_ADDR3                                                                  0x0087 // duplicate 
#define mmGFX_MMIOREG_CAM_REMAP_ADDR3_BASE_IDX                                                         0
#define mmGFX_MMIOREG_CAM_ADDR4                                                                        0x0088 // duplicate 
#define mmGFX_MMIOREG_CAM_ADDR4_BASE_IDX                                                               0
#define mmGFX_MMIOREG_CAM_REMAP_ADDR4                                                                  0x0089 // duplicate 
#define mmGFX_MMIOREG_CAM_REMAP_ADDR4_BASE_IDX                                                         0
#define mmGFX_MMIOREG_CAM_ADDR5                                                                        0x008a // duplicate 
#define mmGFX_MMIOREG_CAM_ADDR5_BASE_IDX                                                               0
#define mmGFX_MMIOREG_CAM_REMAP_ADDR5                                                                  0x008b // duplicate 
#define mmGFX_MMIOREG_CAM_REMAP_ADDR5_BASE_IDX                                                         0
#define mmGFX_MMIOREG_CAM_ADDR6                                                                        0x008c // duplicate 
#define mmGFX_MMIOREG_CAM_ADDR6_BASE_IDX                                                               0
#define mmGFX_MMIOREG_CAM_REMAP_ADDR6                                                                  0x008d // duplicate 
#define mmGFX_MMIOREG_CAM_REMAP_ADDR6_BASE_IDX                                                         0
#define mmGFX_MMIOREG_CAM_ADDR7                                                                        0x008e // duplicate 
#define mmGFX_MMIOREG_CAM_ADDR7_BASE_IDX                                                               0
#define mmGFX_MMIOREG_CAM_REMAP_ADDR7                                                                  0x008f // duplicate 
#define mmGFX_MMIOREG_CAM_REMAP_ADDR7_BASE_IDX                                                         0
#define mmGFX_MMIOREG_CAM_CNTL                                                                         0x0090 // duplicate 
#define mmGFX_MMIOREG_CAM_CNTL_BASE_IDX                                                                0
#define mmGFX_MMIOREG_CAM_ZERO_CPL                                                                     0x0091 // duplicate 
#define mmGFX_MMIOREG_CAM_ZERO_CPL_BASE_IDX                                                            0
#define mmGFX_MMIOREG_CAM_ONE_CPL                                                                      0x0092 // duplicate 
#define mmGFX_MMIOREG_CAM_ONE_CPL_BASE_IDX                                                             0
#define mmGFX_MMIOREG_CAM_PROGRAMMABLE_CPL                                                             0x0093 // duplicate 
#define mmGFX_MMIOREG_CAM_PROGRAMMABLE_CPL_BASE_IDX                                                    0


// addressBlock: bif_bx_pf_SYSPFVFDEC
// base address: 0x0
#define mmMM_INDEX                                                                                     0x0000 // duplicate 
#define mmMM_INDEX_BASE_IDX                                                                            0
#define mmMM_DATA                                                                                      0x0001 // duplicate 
#define mmMM_DATA_BASE_IDX                                                                             0
#define mmMM_INDEX_HI                                                                                  0x0006 // duplicate 
#define mmMM_INDEX_HI_BASE_IDX                                                                         0
#define mmSYSHUB_INDEX_OVLP                                                                            0x0008 // duplicate 
#define mmSYSHUB_INDEX_OVLP_BASE_IDX                                                                   0
#define mmSYSHUB_DATA_OVLP                                                                             0x0009 // duplicate 
#define mmSYSHUB_DATA_OVLP_BASE_IDX                                                                    0
#define mmPCIE_INDEX                                                                                   0x000c // duplicate 
#define mmPCIE_INDEX_BASE_IDX                                                                          0
#define mmPCIE_DATA                                                                                    0x000d // duplicate 
#define mmPCIE_DATA_BASE_IDX                                                                           0
#define mmPCIE_INDEX2                                                                                  0x000e // duplicate 
#define mmPCIE_INDEX2_BASE_IDX                                                                         0
#define mmPCIE_DATA2                                                                                   0x000f // duplicate 
#define mmPCIE_DATA2_BASE_IDX                                                                          0


// addressBlock: rcc_dwn_BIFDEC1
// base address: 0x0
#define mmDN_PCIE_RESERVED                                                                             0x0d60 // duplicate 
#define mmDN_PCIE_RESERVED_BASE_IDX                                                                    0
#define mmDN_PCIE_SCRATCH                                                                              0x0d61 // duplicate 
#define mmDN_PCIE_SCRATCH_BASE_IDX                                                                     0
#define mmDN_PCIE_CNTL                                                                                 0x0d63 // duplicate 
#define mmDN_PCIE_CNTL_BASE_IDX                                                                        0
#define mmDN_PCIE_CONFIG_CNTL                                                                          0x0d64 // duplicate 
#define mmDN_PCIE_CONFIG_CNTL_BASE_IDX                                                                 0
#define mmDN_PCIE_RX_CNTL2                                                                             0x0d65 // duplicate 
#define mmDN_PCIE_RX_CNTL2_BASE_IDX                                                                    0
#define mmDN_PCIE_BUS_CNTL                                                                             0x0d66 // duplicate 
#define mmDN_PCIE_BUS_CNTL_BASE_IDX                                                                    0
#define mmDN_PCIE_CFG_CNTL                                                                             0x0d67 // duplicate 
#define mmDN_PCIE_CFG_CNTL_BASE_IDX                                                                    0
#define mmDN_PCIE_STRAP_F0                                                                             0x0d68 // duplicate 
#define mmDN_PCIE_STRAP_F0_BASE_IDX                                                                    0
#define mmDN_PCIE_STRAP_MISC                                                                           0x0d69 // duplicate 
#define mmDN_PCIE_STRAP_MISC_BASE_IDX                                                                  0
#define mmDN_PCIE_STRAP_MISC2                                                                          0x0d6a // duplicate 
#define mmDN_PCIE_STRAP_MISC2_BASE_IDX                                                                 0


// addressBlock: rcc_dwnp_BIFDEC1
// base address: 0x0
#define mmPCIEP_RESERVED                                                                               0x0d6c // duplicate 
#define mmPCIEP_RESERVED_BASE_IDX                                                                      0
#define mmPCIEP_SCRATCH                                                                                0x0d6d // duplicate 
#define mmPCIEP_SCRATCH_BASE_IDX                                                                       0
#define mmPCIE_ERR_CNTL                                                                                0x0d6f // duplicate 
#define mmPCIE_ERR_CNTL_BASE_IDX                                                                       0
#define mmPCIE_RX_CNTL                                                                                 0x0d70 // duplicate 
#define mmPCIE_RX_CNTL_BASE_IDX                                                                        0
#define mmPCIE_LC_SPEED_CNTL                                                                           0x0d71 // duplicate 
#define mmPCIE_LC_SPEED_CNTL_BASE_IDX                                                                  0
#define mmPCIE_LC_CNTL2                                                                                0x0d72 // duplicate 
#define mmPCIE_LC_CNTL2_BASE_IDX                                                                       0
#define mmPCIEP_STRAP_MISC                                                                             0x0d73 // duplicate 
#define mmPCIEP_STRAP_MISC_BASE_IDX                                                                    0
#define mmLTR_MSG_INFO_FROM_EP                                                                         0x0d74 // duplicate 
#define mmLTR_MSG_INFO_FROM_EP_BASE_IDX                                                                0


// addressBlock: rcc_ep_BIFDEC1
// base address: 0x0
#define mmEP_PCIE_SCRATCH                                                                              0x0d43 // duplicate 
#define mmEP_PCIE_SCRATCH_BASE_IDX                                                                     0
#define mmEP_PCIE_CNTL                                                                                 0x0d45 // duplicate 
#define mmEP_PCIE_CNTL_BASE_IDX                                                                        0
#define mmEP_PCIE_INT_CNTL                                                                             0x0d46 // duplicate 
#define mmEP_PCIE_INT_CNTL_BASE_IDX                                                                    0
#define mmEP_PCIE_INT_STATUS                                                                           0x0d47 // duplicate 
#define mmEP_PCIE_INT_STATUS_BASE_IDX                                                                  0
#define mmEP_PCIE_RX_CNTL2                                                                             0x0d48 // duplicate 
#define mmEP_PCIE_RX_CNTL2_BASE_IDX                                                                    0
#define mmEP_PCIE_BUS_CNTL                                                                             0x0d49 // duplicate 
#define mmEP_PCIE_BUS_CNTL_BASE_IDX                                                                    0
#define mmEP_PCIE_CFG_CNTL                                                                             0x0d4a // duplicate 
#define mmEP_PCIE_CFG_CNTL_BASE_IDX                                                                    0
#define mmEP_PCIE_OBFF_CNTL                                                                            0x0d4b // duplicate 
#define mmEP_PCIE_OBFF_CNTL_BASE_IDX                                                                   0
#define mmEP_PCIE_TX_LTR_CNTL                                                                          0x0d4c // duplicate 
#define mmEP_PCIE_TX_LTR_CNTL_BASE_IDX                                                                 0
#define mmEP_PCIE_STRAP_MISC                                                                           0x0d4f // duplicate 
#define mmEP_PCIE_STRAP_MISC_BASE_IDX                                                                  0
#define mmEP_PCIE_STRAP_MISC2                                                                          0x0d50 // duplicate 
#define mmEP_PCIE_STRAP_MISC2_BASE_IDX                                                                 0
#define mmEP_PCIE_STRAP_PI                                                                             0x0d51 // duplicate 
#define mmEP_PCIE_STRAP_PI_BASE_IDX                                                                    0
#define mmEP_PCIE_F0_DPA_CAP                                                                           0x0d52 // duplicate 
#define mmEP_PCIE_F0_DPA_CAP_BASE_IDX                                                                  0
#define mmEP_PCIE_F0_DPA_LATENCY_INDICATOR                                                             0x0d53 // duplicate 
#define mmEP_PCIE_F0_DPA_LATENCY_INDICATOR_BASE_IDX                                                    0
#define mmEP_PCIE_F0_DPA_CNTL                                                                          0x0d53 // duplicate 
#define mmEP_PCIE_F0_DPA_CNTL_BASE_IDX                                                                 0
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0                                                             0x0d53 // duplicate 
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                                    0
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1                                                             0x0d54 // duplicate 
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                                    0
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2                                                             0x0d54 // duplicate 
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                                    0
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3                                                             0x0d54 // duplicate 
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                                    0
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4                                                             0x0d54 // duplicate 
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                                    0
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5                                                             0x0d55 // duplicate 
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                                    0
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6                                                             0x0d55 // duplicate 
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                                    0
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7                                                             0x0d55 // duplicate 
#define mmPCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                                    0
#define mmEP_PCIE_PME_CONTROL                                                                          0x0d55 // duplicate 
#define mmEP_PCIE_PME_CONTROL_BASE_IDX                                                                 0
#define mmEP_PCIEP_RESERVED                                                                            0x0d56 // duplicate 
#define mmEP_PCIEP_RESERVED_BASE_IDX                                                                   0
#define mmEP_PCIE_TX_CNTL                                                                              0x0d58 // duplicate 
#define mmEP_PCIE_TX_CNTL_BASE_IDX                                                                     0
#define mmEP_PCIE_TX_REQUESTER_ID                                                                      0x0d59 // duplicate 
#define mmEP_PCIE_TX_REQUESTER_ID_BASE_IDX                                                             0
#define mmEP_PCIE_ERR_CNTL                                                                             0x0d5a // duplicate 
#define mmEP_PCIE_ERR_CNTL_BASE_IDX                                                                    0
#define mmEP_PCIE_RX_CNTL                                                                              0x0d5b // duplicate 
#define mmEP_PCIE_RX_CNTL_BASE_IDX                                                                     0
#define mmEP_PCIE_LC_SPEED_CNTL                                                                        0x0d5c // duplicate 
#define mmEP_PCIE_LC_SPEED_CNTL_BASE_IDX                                                               0


// addressBlock: bif_bx_pf_BIFDEC1
// base address: 0x0
#define mmBIF_MM_INDACCESS_CNTL                                                                        0x0e06 // duplicate 
#define mmBIF_MM_INDACCESS_CNTL_BASE_IDX                                                               0
#define mmBUS_CNTL                                                                                     0x0e07 // duplicate 
#define mmBUS_CNTL_BASE_IDX                                                                            0
#define mmBIF_SCRATCH0                                                                                 0x0e08 // duplicate 
#define mmBIF_SCRATCH0_BASE_IDX                                                                        0
#define mmBIF_SCRATCH1                                                                                 0x0e09 // duplicate 
#define mmBIF_SCRATCH1_BASE_IDX                                                                        0
#define mmBX_RESET_EN                                                                                  0x0e0d // duplicate 
#define mmBX_RESET_EN_BASE_IDX                                                                         0
#define mmMM_CFGREGS_CNTL                                                                              0x0e0e // duplicate 
#define mmMM_CFGREGS_CNTL_BASE_IDX                                                                     0
#define mmBX_RESET_CNTL                                                                                0x0e10 // duplicate 
#define mmBX_RESET_CNTL_BASE_IDX                                                                       0
#define mmINTERRUPT_CNTL                                                                               0x0e11 // duplicate 
#define mmINTERRUPT_CNTL_BASE_IDX                                                                      0
#define mmINTERRUPT_CNTL2                                                                              0x0e12 // duplicate 
#define mmINTERRUPT_CNTL2_BASE_IDX                                                                     0
#define mmCLKREQB_PAD_CNTL                                                                             0x0e18 // duplicate 
#define mmCLKREQB_PAD_CNTL_BASE_IDX                                                                    0
#define mmCLKREQB_PERF_COUNTER                                                                         0x0e19 // duplicate 
#define mmCLKREQB_PERF_COUNTER_BASE_IDX                                                                0
#define mmBIF_CLK_CTRL                                                                                 0x0e1a // duplicate 
#define mmBIF_CLK_CTRL_BASE_IDX                                                                        0
#define mmBIF_FEATURES_CONTROL_MISC                                                                    0x0e1b // duplicate 
#define mmBIF_FEATURES_CONTROL_MISC_BASE_IDX                                                           0
#define mmBIF_DOORBELL_CNTL                                                                            0x0e1c // duplicate 
#define mmBIF_DOORBELL_CNTL_BASE_IDX                                                                   0
#define mmBIF_DOORBELL_INT_CNTL                                                                        0x0e1d // duplicate 
#define mmBIF_DOORBELL_INT_CNTL_BASE_IDX                                                               0
#define mmBIF_SLVARB_MODE                                                                              0x0e1e // duplicate 
#define mmBIF_SLVARB_MODE_BASE_IDX                                                                     0
#define mmBIF_FB_EN                                                                                    0x0e1f // duplicate 
#define mmBIF_FB_EN_BASE_IDX                                                                           0
#define mmBIF_BUSY_DELAY_CNTR                                                                          0x0e20 // duplicate 
#define mmBIF_BUSY_DELAY_CNTR_BASE_IDX                                                                 0
#define mmBIF_PERFMON_CNTL                                                                             0x0e21 // duplicate 
#define mmBIF_PERFMON_CNTL_BASE_IDX                                                                    0
#define mmBIF_PERFCOUNTER0_RESULT                                                                      0x0e22 // duplicate 
#define mmBIF_PERFCOUNTER0_RESULT_BASE_IDX                                                             0
#define mmBIF_PERFCOUNTER1_RESULT                                                                      0x0e23 // duplicate 
#define mmBIF_PERFCOUNTER1_RESULT_BASE_IDX                                                             0
#define mmBIF_MST_TRANS_PENDING_VF                                                                     0x0e29 // duplicate 
#define mmBIF_MST_TRANS_PENDING_VF_BASE_IDX                                                            0
#define mmBIF_SLV_TRANS_PENDING_VF                                                                     0x0e2a // duplicate 
#define mmBIF_SLV_TRANS_PENDING_VF_BASE_IDX                                                            0
#define mmBACO_CNTL                                                                                    0x0e2b // duplicate 
#define mmBACO_CNTL_BASE_IDX                                                                           0
#define mmBIF_BACO_EXIT_TIME0                                                                          0x0e2c // duplicate 
#define mmBIF_BACO_EXIT_TIME0_BASE_IDX                                                                 0
#define mmBIF_BACO_EXIT_TIMER1                                                                         0x0e2d // duplicate 
#define mmBIF_BACO_EXIT_TIMER1_BASE_IDX                                                                0
#define mmBIF_BACO_EXIT_TIMER2                                                                         0x0e2e // duplicate 
#define mmBIF_BACO_EXIT_TIMER2_BASE_IDX                                                                0
#define mmBIF_BACO_EXIT_TIMER3                                                                         0x0e2f // duplicate 
#define mmBIF_BACO_EXIT_TIMER3_BASE_IDX                                                                0
#define mmBIF_BACO_EXIT_TIMER4                                                                         0x0e30 // duplicate 
#define mmBIF_BACO_EXIT_TIMER4_BASE_IDX                                                                0
#define mmMEM_TYPE_CNTL                                                                                0x0e31 // duplicate 
#define mmMEM_TYPE_CNTL_BASE_IDX                                                                       0
#define mmSMU_BIF_VDDGFX_PWR_STATUS                                                                    0x0e33 // duplicate 
#define mmSMU_BIF_VDDGFX_PWR_STATUS_BASE_IDX                                                           0
#define mmBIF_VDDGFX_GFX0_LOWER                                                                        0x0e34 // duplicate 
#define mmBIF_VDDGFX_GFX0_LOWER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_GFX0_UPPER                                                                        0x0e35 // duplicate 
#define mmBIF_VDDGFX_GFX0_UPPER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_GFX1_LOWER                                                                        0x0e36 // duplicate 
#define mmBIF_VDDGFX_GFX1_LOWER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_GFX1_UPPER                                                                        0x0e37 // duplicate 
#define mmBIF_VDDGFX_GFX1_UPPER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_GFX2_LOWER                                                                        0x0e38 // duplicate 
#define mmBIF_VDDGFX_GFX2_LOWER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_GFX2_UPPER                                                                        0x0e39 // duplicate 
#define mmBIF_VDDGFX_GFX2_UPPER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_GFX3_LOWER                                                                        0x0e3a // duplicate 
#define mmBIF_VDDGFX_GFX3_LOWER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_GFX3_UPPER                                                                        0x0e3b // duplicate 
#define mmBIF_VDDGFX_GFX3_UPPER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_GFX4_LOWER                                                                        0x0e3c // duplicate 
#define mmBIF_VDDGFX_GFX4_LOWER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_GFX4_UPPER                                                                        0x0e3d // duplicate 
#define mmBIF_VDDGFX_GFX4_UPPER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_GFX5_LOWER                                                                        0x0e3e // duplicate 
#define mmBIF_VDDGFX_GFX5_LOWER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_GFX5_UPPER                                                                        0x0e3f // duplicate 
#define mmBIF_VDDGFX_GFX5_UPPER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_RSV1_LOWER                                                                        0x0e40 // duplicate 
#define mmBIF_VDDGFX_RSV1_LOWER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_RSV1_UPPER                                                                        0x0e41 // duplicate 
#define mmBIF_VDDGFX_RSV1_UPPER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_RSV2_LOWER                                                                        0x0e42 // duplicate 
#define mmBIF_VDDGFX_RSV2_LOWER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_RSV2_UPPER                                                                        0x0e43 // duplicate 
#define mmBIF_VDDGFX_RSV2_UPPER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_RSV3_LOWER                                                                        0x0e44 // duplicate 
#define mmBIF_VDDGFX_RSV3_LOWER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_RSV3_UPPER                                                                        0x0e45 // duplicate 
#define mmBIF_VDDGFX_RSV3_UPPER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_RSV4_LOWER                                                                        0x0e46 // duplicate 
#define mmBIF_VDDGFX_RSV4_LOWER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_RSV4_UPPER                                                                        0x0e47 // duplicate 
#define mmBIF_VDDGFX_RSV4_UPPER_BASE_IDX                                                               0
#define mmBIF_VDDGFX_FB_CMP                                                                            0x0e48 // duplicate 
#define mmBIF_VDDGFX_FB_CMP_BASE_IDX                                                                   0
#define mmBIF_DOORBELL_GBLAPER1_LOWER                                                                  0x0e49 // duplicate 
#define mmBIF_DOORBELL_GBLAPER1_LOWER_BASE_IDX                                                         0
#define mmBIF_DOORBELL_GBLAPER1_UPPER                                                                  0x0e4a // duplicate 
#define mmBIF_DOORBELL_GBLAPER1_UPPER_BASE_IDX                                                         0
#define mmBIF_DOORBELL_GBLAPER2_LOWER                                                                  0x0e4b // duplicate 
#define mmBIF_DOORBELL_GBLAPER2_LOWER_BASE_IDX                                                         0
#define mmBIF_DOORBELL_GBLAPER2_UPPER                                                                  0x0e4c // duplicate 
#define mmBIF_DOORBELL_GBLAPER2_UPPER_BASE_IDX                                                         0
#define mmREMAP_HDP_MEM_FLUSH_CNTL                                                                     0x0e4d // duplicate 
#define mmREMAP_HDP_MEM_FLUSH_CNTL_BASE_IDX                                                            0
#define mmREMAP_HDP_REG_FLUSH_CNTL                                                                     0x0e4e // duplicate 
#define mmREMAP_HDP_REG_FLUSH_CNTL_BASE_IDX                                                            0
#define mmBIF_RB_CNTL                                                                                  0x0e4f // duplicate 
#define mmBIF_RB_CNTL_BASE_IDX                                                                         0
#define mmBIF_RB_BASE                                                                                  0x0e50 // duplicate 
#define mmBIF_RB_BASE_BASE_IDX                                                                         0
#define mmBIF_RB_RPTR                                                                                  0x0e51 // duplicate 
#define mmBIF_RB_RPTR_BASE_IDX                                                                         0
#define mmBIF_RB_WPTR                                                                                  0x0e52 // duplicate 
#define mmBIF_RB_WPTR_BASE_IDX                                                                         0
#define mmBIF_RB_WPTR_ADDR_HI                                                                          0x0e53 // duplicate 
#define mmBIF_RB_WPTR_ADDR_HI_BASE_IDX                                                                 0
#define mmBIF_RB_WPTR_ADDR_LO                                                                          0x0e54 // duplicate 
#define mmBIF_RB_WPTR_ADDR_LO_BASE_IDX                                                                 0
#define mmMAILBOX_INDEX                                                                                0x0e55 // duplicate 
#define mmMAILBOX_INDEX_BASE_IDX                                                                       0
#define mmBIF_GPUIOV_RESET_NOTIFICATION                                                                0x0e62 // duplicate 
#define mmBIF_GPUIOV_RESET_NOTIFICATION_BASE_IDX                                                       0
#define mmBIF_UVD_GPUIOV_CFG_SIZE                                                                      0x0e63 // duplicate 
#define mmBIF_UVD_GPUIOV_CFG_SIZE_BASE_IDX                                                             0
#define mmBIF_VCE_GPUIOV_CFG_SIZE                                                                      0x0e64 // duplicate 
#define mmBIF_VCE_GPUIOV_CFG_SIZE_BASE_IDX                                                             0
#define mmBIF_GFX_SDMA_GPUIOV_CFG_SIZE                                                                 0x0e65 // duplicate 
#define mmBIF_GFX_SDMA_GPUIOV_CFG_SIZE_BASE_IDX                                                        0
#define mmBIF_GMI_WRR_WEIGHT                                                                           0x0e66 // duplicate 
#define mmBIF_GMI_WRR_WEIGHT_BASE_IDX                                                                  0
#define mmNBIF_STRAP_WRITE_CTRL                                                                        0x0e67 // duplicate 
#define mmNBIF_STRAP_WRITE_CTRL_BASE_IDX                                                               0
#define mmBIF_PERSTB_PAD_CNTL                                                                          0x0e68 // duplicate 
#define mmBIF_PERSTB_PAD_CNTL_BASE_IDX                                                                 0
#define mmBIF_PX_EN_PAD_CNTL                                                                           0x0e69 // duplicate 
#define mmBIF_PX_EN_PAD_CNTL_BASE_IDX                                                                  0
#define mmBIF_REFPADKIN_PAD_CNTL                                                                       0x0e6a // duplicate 
#define mmBIF_REFPADKIN_PAD_CNTL_BASE_IDX                                                              0
#define mmBIF_CLKREQB_PAD_CNTL                                                                         0x0e6b // duplicate 
#define mmBIF_CLKREQB_PAD_CNTL_BASE_IDX                                                                0


// addressBlock: rcc_pf_0_BIFDEC1
// base address: 0x0
#define mmRCC_BACO_CNTL_MISC                                                                           0x0da7 // duplicate 
#define mmRCC_BACO_CNTL_MISC_BASE_IDX                                                                  0
#define mmRCC_RESET_EN                                                                                 0x0da8 // duplicate 
#define mmRCC_RESET_EN_BASE_IDX                                                                        0
#define mmRCC_VDM_SUPPORT                                                                              0x0da9 // duplicate 
#define mmRCC_VDM_SUPPORT_BASE_IDX                                                                     0
#define mmRCC_PEER_REG_RANGE0                                                                          0x0dde // duplicate 
#define mmRCC_PEER_REG_RANGE0_BASE_IDX                                                                 0
#define mmRCC_PEER_REG_RANGE1                                                                          0x0ddf // duplicate 
#define mmRCC_PEER_REG_RANGE1_BASE_IDX                                                                 0
#define mmRCC_BUS_CNTL                                                                                 0x0de1 // duplicate 
#define mmRCC_BUS_CNTL_BASE_IDX                                                                        0
#define mmRCC_CONFIG_CNTL                                                                              0x0de2 // duplicate 
#define mmRCC_CONFIG_CNTL_BASE_IDX                                                                     0
#define mmRCC_CONFIG_F0_BASE                                                                           0x0de6 // duplicate 
#define mmRCC_CONFIG_F0_BASE_BASE_IDX                                                                  0
#define mmRCC_CONFIG_APER_SIZE                                                                         0x0de7 // duplicate 
#define mmRCC_CONFIG_APER_SIZE_BASE_IDX                                                                0
#define mmRCC_CONFIG_REG_APER_SIZE                                                                     0x0de8 // duplicate 
#define mmRCC_CONFIG_REG_APER_SIZE_BASE_IDX                                                            0
#define mmRCC_XDMA_LO                                                                                  0x0de9 // duplicate 
#define mmRCC_XDMA_LO_BASE_IDX                                                                         0
#define mmRCC_XDMA_HI                                                                                  0x0dea // duplicate 
#define mmRCC_XDMA_HI_BASE_IDX                                                                         0
#define mmRCC_FEATURES_CONTROL_MISC                                                                    0x0deb // duplicate 
#define mmRCC_FEATURES_CONTROL_MISC_BASE_IDX                                                           0
#define mmRCC_BUSNUM_CNTL1                                                                             0x0dec // duplicate 
#define mmRCC_BUSNUM_CNTL1_BASE_IDX                                                                    0
#define mmRCC_BUSNUM_LIST0                                                                             0x0ded // duplicate 
#define mmRCC_BUSNUM_LIST0_BASE_IDX                                                                    0
#define mmRCC_BUSNUM_LIST1                                                                             0x0dee // duplicate 
#define mmRCC_BUSNUM_LIST1_BASE_IDX                                                                    0
#define mmRCC_BUSNUM_CNTL2                                                                             0x0def // duplicate 
#define mmRCC_BUSNUM_CNTL2_BASE_IDX                                                                    0
#define mmRCC_CAPTURE_HOST_BUSNUM                                                                      0x0df0 // duplicate 
#define mmRCC_CAPTURE_HOST_BUSNUM_BASE_IDX                                                             0
#define mmRCC_HOST_BUSNUM                                                                              0x0df1 // duplicate 
#define mmRCC_HOST_BUSNUM_BASE_IDX                                                                     0
#define mmRCC_PEER0_FB_OFFSET_HI                                                                       0x0df2 // duplicate 
#define mmRCC_PEER0_FB_OFFSET_HI_BASE_IDX                                                              0
#define mmRCC_PEER0_FB_OFFSET_LO                                                                       0x0df3 // duplicate 
#define mmRCC_PEER0_FB_OFFSET_LO_BASE_IDX                                                              0
#define mmRCC_PEER1_FB_OFFSET_HI                                                                       0x0df4 // duplicate 
#define mmRCC_PEER1_FB_OFFSET_HI_BASE_IDX                                                              0
#define mmRCC_PEER1_FB_OFFSET_LO                                                                       0x0df5 // duplicate 
#define mmRCC_PEER1_FB_OFFSET_LO_BASE_IDX                                                              0
#define mmRCC_PEER2_FB_OFFSET_HI                                                                       0x0df6 // duplicate 
#define mmRCC_PEER2_FB_OFFSET_HI_BASE_IDX                                                              0
#define mmRCC_PEER2_FB_OFFSET_LO                                                                       0x0df7 // duplicate 
#define mmRCC_PEER2_FB_OFFSET_LO_BASE_IDX                                                              0
#define mmRCC_PEER3_FB_OFFSET_HI                                                                       0x0df8 // duplicate 
#define mmRCC_PEER3_FB_OFFSET_HI_BASE_IDX                                                              0
#define mmRCC_PEER3_FB_OFFSET_LO                                                                       0x0df9 // duplicate 
#define mmRCC_PEER3_FB_OFFSET_LO_BASE_IDX                                                              0
#define mmRCC_DEVFUNCNUM_LIST0                                                                         0x0dfa // duplicate 
#define mmRCC_DEVFUNCNUM_LIST0_BASE_IDX                                                                0
#define mmRCC_DEVFUNCNUM_LIST1                                                                         0x0dfb // duplicate 
#define mmRCC_DEVFUNCNUM_LIST1_BASE_IDX                                                                0
#define mmRCC_DEV0_LINK_CNTL                                                                           0x0dfd // duplicate 
#define mmRCC_DEV0_LINK_CNTL_BASE_IDX                                                                  0
#define mmRCC_CMN_LINK_CNTL                                                                            0x0dfe // duplicate 
#define mmRCC_CMN_LINK_CNTL_BASE_IDX                                                                   0
#define mmRCC_EP_REQUESTERID_RESTORE                                                                   0x0dff // duplicate 
#define mmRCC_EP_REQUESTERID_RESTORE_BASE_IDX                                                          0
#define mmRCC_LTR_LSWITCH_CNTL                                                                         0x0e00 // duplicate 
#define mmRCC_LTR_LSWITCH_CNTL_BASE_IDX                                                                0
#define mmRCC_MH_ARB_CNTL                                                                              0x0e01 // duplicate 
#define mmRCC_MH_ARB_CNTL_BASE_IDX                                                                     0


// addressBlock: rcc_pf_0_BIFDEC2
// base address: 0x0
#define mmGFXMSIX_VECT0_ADDR_LO                                                                        0x10800 // duplicate 
#define mmGFXMSIX_VECT0_ADDR_LO_BASE_IDX                                                               0
#define mmGFXMSIX_VECT0_ADDR_HI                                                                        0x10801 // duplicate 
#define mmGFXMSIX_VECT0_ADDR_HI_BASE_IDX                                                               0
#define mmGFXMSIX_VECT0_MSG_DATA                                                                       0x10802 // duplicate 
#define mmGFXMSIX_VECT0_MSG_DATA_BASE_IDX                                                              0
#define mmGFXMSIX_VECT0_CONTROL                                                                        0x10803 // duplicate 
#define mmGFXMSIX_VECT0_CONTROL_BASE_IDX                                                               0
#define mmGFXMSIX_VECT1_ADDR_LO                                                                        0x10804 // duplicate 
#define mmGFXMSIX_VECT1_ADDR_LO_BASE_IDX                                                               0
#define mmGFXMSIX_VECT1_ADDR_HI                                                                        0x10805 // duplicate 
#define mmGFXMSIX_VECT1_ADDR_HI_BASE_IDX                                                               0
#define mmGFXMSIX_VECT1_MSG_DATA                                                                       0x10806 // duplicate 
#define mmGFXMSIX_VECT1_MSG_DATA_BASE_IDX                                                              0
#define mmGFXMSIX_VECT1_CONTROL                                                                        0x10807 // duplicate 
#define mmGFXMSIX_VECT1_CONTROL_BASE_IDX                                                               0
#define mmGFXMSIX_VECT2_ADDR_LO                                                                        0x10808 // duplicate 
#define mmGFXMSIX_VECT2_ADDR_LO_BASE_IDX                                                               0
#define mmGFXMSIX_VECT2_ADDR_HI                                                                        0x10809 // duplicate 
#define mmGFXMSIX_VECT2_ADDR_HI_BASE_IDX                                                               0
#define mmGFXMSIX_VECT2_MSG_DATA                                                                       0x1080a // duplicate 
#define mmGFXMSIX_VECT2_MSG_DATA_BASE_IDX                                                              0
#define mmGFXMSIX_VECT2_CONTROL                                                                        0x1080b // duplicate 
#define mmGFXMSIX_VECT2_CONTROL_BASE_IDX                                                               0
#define mmGFXMSIX_PBA                                                                                  0x10c00 // duplicate 
#define mmGFXMSIX_PBA_BASE_IDX                                                                         0


// addressBlock: rcc_strap_BIFDEC1
// base address: 0x0
#define mmRCC_DEV0_PORT_STRAP0                                                                         0x0d27 // duplicate 
#define mmRCC_DEV0_PORT_STRAP0_BASE_IDX                                                                0
#define mmRCC_DEV0_PORT_STRAP1                                                                         0x0d28 // duplicate 
#define mmRCC_DEV0_PORT_STRAP1_BASE_IDX                                                                0
#define mmRCC_DEV0_PORT_STRAP2                                                                         0x0d29 // duplicate 
#define mmRCC_DEV0_PORT_STRAP2_BASE_IDX                                                                0
#define mmRCC_DEV0_PORT_STRAP3                                                                         0x0d2a // duplicate 
#define mmRCC_DEV0_PORT_STRAP3_BASE_IDX                                                                0
#define mmRCC_DEV0_PORT_STRAP4                                                                         0x0d2b // duplicate 
#define mmRCC_DEV0_PORT_STRAP4_BASE_IDX                                                                0
#define mmRCC_DEV0_PORT_STRAP5                                                                         0x0d2c // duplicate 
#define mmRCC_DEV0_PORT_STRAP5_BASE_IDX                                                                0
#define mmRCC_DEV0_PORT_STRAP6                                                                         0x0d2d // duplicate 
#define mmRCC_DEV0_PORT_STRAP6_BASE_IDX                                                                0
#define mmRCC_DEV0_PORT_STRAP7                                                                         0x0d2e // duplicate 
#define mmRCC_DEV0_PORT_STRAP7_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF0_STRAP0                                                                         0x0d2f // duplicate 
#define mmRCC_DEV0_EPF0_STRAP0_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF0_STRAP1                                                                         0x0d30 // duplicate 
#define mmRCC_DEV0_EPF0_STRAP1_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF0_STRAP13                                                                        0x0d31 // duplicate 
#define mmRCC_DEV0_EPF0_STRAP13_BASE_IDX                                                               0
#define mmRCC_DEV0_EPF0_STRAP2                                                                         0x0d32 // duplicate 
#define mmRCC_DEV0_EPF0_STRAP2_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF0_STRAP3                                                                         0x0d33 // duplicate 
#define mmRCC_DEV0_EPF0_STRAP3_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF0_STRAP4                                                                         0x0d34 // duplicate 
#define mmRCC_DEV0_EPF0_STRAP4_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF0_STRAP5                                                                         0x0d35 // duplicate 
#define mmRCC_DEV0_EPF0_STRAP5_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF0_STRAP8                                                                         0x0d36 // duplicate 
#define mmRCC_DEV0_EPF0_STRAP8_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF0_STRAP9                                                                         0x0d37 // duplicate 
#define mmRCC_DEV0_EPF0_STRAP9_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF1_STRAP0                                                                         0x0d38 // duplicate 
#define mmRCC_DEV0_EPF1_STRAP0_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF1_STRAP10                                                                        0x0d39 // duplicate 
#define mmRCC_DEV0_EPF1_STRAP10_BASE_IDX                                                               0
#define mmRCC_DEV0_EPF1_STRAP11                                                                        0x0d3a // duplicate 
#define mmRCC_DEV0_EPF1_STRAP11_BASE_IDX                                                               0
#define mmRCC_DEV0_EPF1_STRAP12                                                                        0x0d3b // duplicate 
#define mmRCC_DEV0_EPF1_STRAP12_BASE_IDX                                                               0
#define mmRCC_DEV0_EPF1_STRAP13                                                                        0x0d3c // duplicate 
#define mmRCC_DEV0_EPF1_STRAP13_BASE_IDX                                                               0
#define mmRCC_DEV0_EPF1_STRAP2                                                                         0x0d3d // duplicate 
#define mmRCC_DEV0_EPF1_STRAP2_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF1_STRAP3                                                                         0x0d3e // duplicate 
#define mmRCC_DEV0_EPF1_STRAP3_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF1_STRAP4                                                                         0x0d3f // duplicate 
#define mmRCC_DEV0_EPF1_STRAP4_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF1_STRAP5                                                                         0x0d40 // duplicate 
#define mmRCC_DEV0_EPF1_STRAP5_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF1_STRAP6                                                                         0x0d41 // duplicate 
#define mmRCC_DEV0_EPF1_STRAP6_BASE_IDX                                                                0
#define mmRCC_DEV0_EPF1_STRAP7                                                                         0x0d42 // duplicate 
#define mmRCC_DEV0_EPF1_STRAP7_BASE_IDX                                                                0


// addressBlock: bif_bx_pf_BIFPFVFDEC1
// base address: 0x0
#define mmBIF_BME_STATUS                                                                               0x0e0b // duplicate 
#define mmBIF_BME_STATUS_BASE_IDX                                                                      0
#define mmBIF_ATOMIC_ERR_LOG                                                                           0x0e0c // duplicate 
#define mmBIF_ATOMIC_ERR_LOG_BASE_IDX                                                                  0
#define mmDOORBELL_SELFRING_GPA_APER_BASE_HIGH                                                         0x0e13 // duplicate 
#define mmDOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                                                0
#define mmDOORBELL_SELFRING_GPA_APER_BASE_LOW                                                          0x0e14 // duplicate 
#define mmDOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                                                 0
#define mmDOORBELL_SELFRING_GPA_APER_CNTL                                                              0x0e15 // duplicate 
#define mmDOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                                     0
#define mmHDP_REG_COHERENCY_FLUSH_CNTL                                                                 0x0e16 // duplicate 
#define mmHDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                                        0
#define mmHDP_MEM_COHERENCY_FLUSH_CNTL                                                                 0x0e17 // duplicate 
#define mmHDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                                        0
#define mmGPU_HDP_FLUSH_REQ                                                                            0x0e26 // duplicate 
#define mmGPU_HDP_FLUSH_REQ_BASE_IDX                                                                   0
#define mmGPU_HDP_FLUSH_DONE                                                                           0x0e27 // duplicate 
#define mmGPU_HDP_FLUSH_DONE_BASE_IDX                                                                  0
#define mmBIF_TRANS_PENDING                                                                            0x0e28 // duplicate 
#define mmBIF_TRANS_PENDING_BASE_IDX                                                                   0
#define mmMAILBOX_MSGBUF_TRN_DW0                                                                       0x0e56 // duplicate 
#define mmMAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                                              0
#define mmMAILBOX_MSGBUF_TRN_DW1                                                                       0x0e57 // duplicate 
#define mmMAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                                              0
#define mmMAILBOX_MSGBUF_TRN_DW2                                                                       0x0e58 // duplicate 
#define mmMAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                                              0
#define mmMAILBOX_MSGBUF_TRN_DW3                                                                       0x0e59 // duplicate 
#define mmMAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                                              0
#define mmMAILBOX_MSGBUF_RCV_DW0                                                                       0x0e5a // duplicate 
#define mmMAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                                              0
#define mmMAILBOX_MSGBUF_RCV_DW1                                                                       0x0e5b // duplicate 
#define mmMAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                                              0
#define mmMAILBOX_MSGBUF_RCV_DW2                                                                       0x0e5c // duplicate 
#define mmMAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                                              0
#define mmMAILBOX_MSGBUF_RCV_DW3                                                                       0x0e5d // duplicate 
#define mmMAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                                              0
#define mmMAILBOX_CONTROL                                                                              0x0e5e // duplicate 
#define mmMAILBOX_CONTROL_BASE_IDX                                                                     0
#define mmMAILBOX_INT_CNTL                                                                             0x0e5f // duplicate 
#define mmMAILBOX_INT_CNTL_BASE_IDX                                                                    0
#define mmBIF_VMHV_MAILBOX                                                                             0x0e60 // duplicate 
#define mmBIF_VMHV_MAILBOX_BASE_IDX                                                                    0


// addressBlock: rcc_pf_0_BIFPFVFDEC1
// base address: 0x0
#define mmRCC_DOORBELL_APER_EN                                                                         0x0de0 // duplicate 
#define mmRCC_DOORBELL_APER_EN_BASE_IDX                                                                0
#define mmRCC_CONFIG_MEMSIZE                                                                           0x0de3 // duplicate 
#define mmRCC_CONFIG_MEMSIZE_BASE_IDX                                                                  0
#define mmRCC_CONFIG_RESERVED                                                                          0x0de4 // duplicate 
#define mmRCC_CONFIG_RESERVED_BASE_IDX                                                                 0
#define mmRCC_IOV_FUNC_IDENTIFIER                                                                      0x0de5 // duplicate 
#define mmRCC_IOV_FUNC_IDENTIFIER_BASE_IDX                                                             0


// addressBlock: syshub_mmreg_ind_syshubdec
// base address: 0x0
#define mmSYSHUB_INDEX                                                                                 0x0008 
#define mmSYSHUB_INDEX_BASE_IDX                                                                        0
#define mmSYSHUB_DATA                                                                                  0x0009 
#define mmSYSHUB_DATA_BASE_IDX                                                                         0


// addressBlock: rcc_strap_rcc_strap_internal
// base address: 0x10100000
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP0                                                        0x403c000 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP0_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP1                                                        0x403c001 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP1_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP2                                                        0x403c002 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP2_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP3                                                        0x403c003 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP3_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP4                                                        0x403c004 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP4_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP5                                                        0x403c005 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP5_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP6                                                        0x403c006 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP6_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP7                                                        0x403c007 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_PORT_STRAP7_BASE_IDX                                               3
#define mmRCC_DEV1_PORT_STRAP0                                                                         0x403c080 
#define mmRCC_DEV1_PORT_STRAP0_BASE_IDX                                                                3
#define mmRCC_DEV1_PORT_STRAP1                                                                         0x403c081 
#define mmRCC_DEV1_PORT_STRAP1_BASE_IDX                                                                3
#define mmRCC_DEV1_PORT_STRAP2                                                                         0x403c082 
#define mmRCC_DEV1_PORT_STRAP2_BASE_IDX                                                                3
#define mmRCC_DEV1_PORT_STRAP3                                                                         0x403c083 
#define mmRCC_DEV1_PORT_STRAP3_BASE_IDX                                                                3
#define mmRCC_DEV1_PORT_STRAP4                                                                         0x403c084 
#define mmRCC_DEV1_PORT_STRAP4_BASE_IDX                                                                3
#define mmRCC_DEV1_PORT_STRAP5                                                                         0x403c085 
#define mmRCC_DEV1_PORT_STRAP5_BASE_IDX                                                                3
#define mmRCC_DEV1_PORT_STRAP6                                                                         0x403c086 
#define mmRCC_DEV1_PORT_STRAP6_BASE_IDX                                                                3
#define mmRCC_DEV1_PORT_STRAP7                                                                         0x403c087 
#define mmRCC_DEV1_PORT_STRAP7_BASE_IDX                                                                3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP0                                                        0x403cc00 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP0_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP1                                                        0x403cc01 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP1_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP2                                                        0x403cc02 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP2_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP3                                                        0x403cc03 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP3_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP4                                                        0x403cc04 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP4_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP5                                                        0x403cc05 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP5_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP8                                                        0x403cc08 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP8_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP9                                                        0x403cc09 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP9_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP13                                                       0x403cc0d // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF0_STRAP13_BASE_IDX                                              3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP0                                                        0x403cc80 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP0_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP2                                                        0x403cc82 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP2_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP3                                                        0x403cc83 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP3_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP4                                                        0x403cc84 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP4_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP5                                                        0x403cc85 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP5_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP6                                                        0x403cc86 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP6_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP7                                                        0x403cc87 // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP7_BASE_IDX                                               3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP10                                                       0x403cc8a // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP10_BASE_IDX                                              3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP11                                                       0x403cc8b // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP11_BASE_IDX                                              3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP12                                                       0x403cc8c // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP12_BASE_IDX                                              3
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP13                                                       0x403cc8d // duplicate 
#define mmRCCSTRAPRCCSTRAP_RCC_DEV0_EPF1_STRAP13_BASE_IDX                                              3
#define mmRCC_DEV0_EPF2_STRAP0                                                                         0x403cd00 
#define mmRCC_DEV0_EPF2_STRAP0_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF2_STRAP2                                                                         0x403cd02 
#define mmRCC_DEV0_EPF2_STRAP2_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF2_STRAP3                                                                         0x403cd03 
#define mmRCC_DEV0_EPF2_STRAP3_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF2_STRAP4                                                                         0x403cd04 
#define mmRCC_DEV0_EPF2_STRAP4_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF2_STRAP5                                                                         0x403cd05 
#define mmRCC_DEV0_EPF2_STRAP5_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF2_STRAP6                                                                         0x403cd06 
#define mmRCC_DEV0_EPF2_STRAP6_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF2_STRAP13                                                                        0x403cd0d 
#define mmRCC_DEV0_EPF2_STRAP13_BASE_IDX                                                               3
#define mmRCC_DEV0_EPF3_STRAP0                                                                         0x403cd80 
#define mmRCC_DEV0_EPF3_STRAP0_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF3_STRAP2                                                                         0x403cd82 
#define mmRCC_DEV0_EPF3_STRAP2_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF3_STRAP3                                                                         0x403cd83 
#define mmRCC_DEV0_EPF3_STRAP3_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF3_STRAP4                                                                         0x403cd84 
#define mmRCC_DEV0_EPF3_STRAP4_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF3_STRAP5                                                                         0x403cd85 
#define mmRCC_DEV0_EPF3_STRAP5_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF3_STRAP6                                                                         0x403cd86 
#define mmRCC_DEV0_EPF3_STRAP6_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF3_STRAP13                                                                        0x403cd8d 
#define mmRCC_DEV0_EPF3_STRAP13_BASE_IDX                                                               3
#define mmRCC_DEV0_EPF4_STRAP0                                                                         0x403ce00 
#define mmRCC_DEV0_EPF4_STRAP0_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF4_STRAP2                                                                         0x403ce02 
#define mmRCC_DEV0_EPF4_STRAP2_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF4_STRAP3                                                                         0x403ce03 
#define mmRCC_DEV0_EPF4_STRAP3_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF4_STRAP4                                                                         0x403ce04 
#define mmRCC_DEV0_EPF4_STRAP4_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF4_STRAP5                                                                         0x403ce05 
#define mmRCC_DEV0_EPF4_STRAP5_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF4_STRAP6                                                                         0x403ce06 
#define mmRCC_DEV0_EPF4_STRAP6_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF4_STRAP13                                                                        0x403ce0d 
#define mmRCC_DEV0_EPF4_STRAP13_BASE_IDX                                                               3
#define mmRCC_DEV0_EPF5_STRAP0                                                                         0x403ce80 
#define mmRCC_DEV0_EPF5_STRAP0_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF5_STRAP2                                                                         0x403ce82 
#define mmRCC_DEV0_EPF5_STRAP2_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF5_STRAP3                                                                         0x403ce83 
#define mmRCC_DEV0_EPF5_STRAP3_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF5_STRAP4                                                                         0x403ce84 
#define mmRCC_DEV0_EPF5_STRAP4_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF5_STRAP5                                                                         0x403ce85 
#define mmRCC_DEV0_EPF5_STRAP5_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF5_STRAP6                                                                         0x403ce86 
#define mmRCC_DEV0_EPF5_STRAP6_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF5_STRAP13                                                                        0x403ce8d 
#define mmRCC_DEV0_EPF5_STRAP13_BASE_IDX                                                               3
#define mmRCC_DEV0_EPF6_STRAP0                                                                         0x403cf00 
#define mmRCC_DEV0_EPF6_STRAP0_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF6_STRAP2                                                                         0x403cf02 
#define mmRCC_DEV0_EPF6_STRAP2_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF6_STRAP3                                                                         0x403cf03 
#define mmRCC_DEV0_EPF6_STRAP3_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF6_STRAP4                                                                         0x403cf04 
#define mmRCC_DEV0_EPF6_STRAP4_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF6_STRAP5                                                                         0x403cf05 
#define mmRCC_DEV0_EPF6_STRAP5_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF6_STRAP6                                                                         0x403cf06 
#define mmRCC_DEV0_EPF6_STRAP6_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF6_STRAP13                                                                        0x403cf0d 
#define mmRCC_DEV0_EPF6_STRAP13_BASE_IDX                                                               3
#define mmRCC_DEV0_EPF7_STRAP0                                                                         0x403cf80 
#define mmRCC_DEV0_EPF7_STRAP0_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF7_STRAP2                                                                         0x403cf82 
#define mmRCC_DEV0_EPF7_STRAP2_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF7_STRAP3                                                                         0x403cf83 
#define mmRCC_DEV0_EPF7_STRAP3_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF7_STRAP4                                                                         0x403cf84 
#define mmRCC_DEV0_EPF7_STRAP4_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF7_STRAP5                                                                         0x403cf85 
#define mmRCC_DEV0_EPF7_STRAP5_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF7_STRAP6                                                                         0x403cf86 
#define mmRCC_DEV0_EPF7_STRAP6_BASE_IDX                                                                3
#define mmRCC_DEV0_EPF7_STRAP13                                                                        0x403cf8d 
#define mmRCC_DEV0_EPF7_STRAP13_BASE_IDX                                                               3
#define mmRCC_DEV1_EPF0_STRAP0                                                                         0x403d000 
#define mmRCC_DEV1_EPF0_STRAP0_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF0_STRAP2                                                                         0x403d002 
#define mmRCC_DEV1_EPF0_STRAP2_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF0_STRAP3                                                                         0x403d003 
#define mmRCC_DEV1_EPF0_STRAP3_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF0_STRAP4                                                                         0x403d004 
#define mmRCC_DEV1_EPF0_STRAP4_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF0_STRAP5                                                                         0x403d005 
#define mmRCC_DEV1_EPF0_STRAP5_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF0_STRAP6                                                                         0x403d006 
#define mmRCC_DEV1_EPF0_STRAP6_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF0_STRAP13                                                                        0x403d00d 
#define mmRCC_DEV1_EPF0_STRAP13_BASE_IDX                                                               3
#define mmRCC_DEV1_EPF1_STRAP0                                                                         0x403d080 
#define mmRCC_DEV1_EPF1_STRAP0_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF1_STRAP2                                                                         0x403d082 
#define mmRCC_DEV1_EPF1_STRAP2_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF1_STRAP3                                                                         0x403d083 
#define mmRCC_DEV1_EPF1_STRAP3_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF1_STRAP4                                                                         0x403d084 
#define mmRCC_DEV1_EPF1_STRAP4_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF1_STRAP5                                                                         0x403d085 
#define mmRCC_DEV1_EPF1_STRAP5_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF1_STRAP6                                                                         0x403d086 
#define mmRCC_DEV1_EPF1_STRAP6_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF1_STRAP13                                                                        0x403d08d 
#define mmRCC_DEV1_EPF1_STRAP13_BASE_IDX                                                               3
#define mmRCC_DEV1_EPF2_STRAP0                                                                         0x403d100 
#define mmRCC_DEV1_EPF2_STRAP0_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF2_STRAP2                                                                         0x403d102 
#define mmRCC_DEV1_EPF2_STRAP2_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF2_STRAP3                                                                         0x403d103 
#define mmRCC_DEV1_EPF2_STRAP3_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF2_STRAP4                                                                         0x403d104 
#define mmRCC_DEV1_EPF2_STRAP4_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF2_STRAP5                                                                         0x403d105 
#define mmRCC_DEV1_EPF2_STRAP5_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF2_STRAP6                                                                         0x403d106 
#define mmRCC_DEV1_EPF2_STRAP6_BASE_IDX                                                                3
#define mmRCC_DEV1_EPF2_STRAP13                                                                        0x403d10d 
#define mmRCC_DEV1_EPF2_STRAP13_BASE_IDX                                                               3


// addressBlock: bif_rst_bif_rst_regblk
// base address: 0x10100000
#define ixHARD_RST_CTRL                                                                                0x38000 
#define ixRSMU_SOFT_RST_CTRL                                                                           0x38004 
#define ixSELF_SOFT_RST                                                                                0x38008 
#define ixGFX_DRV_MODE1_RST_CTRL                                                                       0x3800c 
#define ixBIF_RST_MISC_CTRL                                                                            0x38010 
#define ixBIF_RST_MISC_CTRL2                                                                           0x38014 
#define ixBIF_RST_MISC_CTRL3                                                                           0x38018 
#define ixBIF_RST_GFXVF_FLR_IDLE                                                                       0x3801c 
#define ixDEV0_PF0_FLR_RST_CTRL                                                                        0x38020 
#define ixDEV0_PF1_FLR_RST_CTRL                                                                        0x38024 
#define ixDEV0_PF2_FLR_RST_CTRL                                                                        0x38028 
#define ixDEV0_PF3_FLR_RST_CTRL                                                                        0x3802c 
#define ixDEV0_PF4_FLR_RST_CTRL                                                                        0x38030 
#define ixDEV0_PF5_FLR_RST_CTRL                                                                        0x38034 
#define ixDEV0_PF6_FLR_RST_CTRL                                                                        0x38038 
#define ixDEV0_PF7_FLR_RST_CTRL                                                                        0x3803c 
#define ixBIF_INST_RESET_INTR_STS                                                                      0x38040 
#define ixBIF_PF_FLR_INTR_STS                                                                          0x38044 
#define ixBIF_D3HOTD0_INTR_STS                                                                         0x38048 
#define ixBIF_POWER_INTR_STS                                                                           0x38050 
#define ixBIF_PF_DSTATE_INTR_STS                                                                       0x38054 
#define ixBIF_PF0_VF_FLR_INTR_STS                                                                      0x38060 
#define ixBIF_INST_RESET_INTR_MASK                                                                     0x38080 
#define ixBIF_PF_FLR_INTR_MASK                                                                         0x38084 
#define ixBIF_D3HOTD0_INTR_MASK                                                                        0x38088 
#define ixBIF_POWER_INTR_MASK                                                                          0x38090 
#define ixBIF_PF_DSTATE_INTR_MASK                                                                      0x38094 
#define ixBIF_PF0_VF_FLR_INTR_MASK                                                                     0x380a0 
#define ixBIF_PF_FLR_RST                                                                               0x38100 
#define ixBIF_PF0_VF_FLR_RST                                                                           0x38120 
#define ixBIF_DEV0_PF0_DSTATE_VALUE                                                                    0x38140 
#define ixBIF_DEV0_PF1_DSTATE_VALUE                                                                    0x38144 
#define ixBIF_DEV0_PF2_DSTATE_VALUE                                                                    0x38148 
#define ixBIF_DEV0_PF3_DSTATE_VALUE                                                                    0x3814c 
#define ixBIF_DEV0_PF4_DSTATE_VALUE                                                                    0x38150 
#define ixBIF_DEV0_PF5_DSTATE_VALUE                                                                    0x38154 
#define ixBIF_DEV0_PF6_DSTATE_VALUE                                                                    0x38158 
#define ixBIF_DEV0_PF7_DSTATE_VALUE                                                                    0x3815c 
#define ixDEV0_PF0_D3HOTD0_RST_CTRL                                                                    0x381e0 
#define ixDEV0_PF1_D3HOTD0_RST_CTRL                                                                    0x381e4 
#define ixDEV0_PF2_D3HOTD0_RST_CTRL                                                                    0x381e8 
#define ixDEV0_PF3_D3HOTD0_RST_CTRL                                                                    0x381ec 
#define ixDEV0_PF4_D3HOTD0_RST_CTRL                                                                    0x381f0 
#define ixDEV0_PF5_D3HOTD0_RST_CTRL                                                                    0x381f4 
#define ixDEV0_PF6_D3HOTD0_RST_CTRL                                                                    0x381f8 
#define ixDEV0_PF7_D3HOTD0_RST_CTRL                                                                    0x381fc 
#define ixBIF_PORT0_DSTATE_VALUE                                                                       0x388c0 


// addressBlock: bif_misc_bif_misc_regblk
// base address: 0x10100000
#define ixMISC_SCRATCH                                                                                 0x3a000 
#define ixINTR_LINE_POLARITY                                                                           0x3a004 
#define ixINTR_LINE_ENABLE                                                                             0x3a008 
#define ixOUTSTANDING_VC_ALLOC                                                                         0x3a00c 
#define ixBIFC_MISC_CTRL0                                                                              0x3a010 
#define ixBIFC_MISC_CTRL1                                                                              0x3a014 
#define ixBIFC_BME_ERR_LOG                                                                             0x3a018 
#define ixBIFC_RCCBIH_BME_ERR_LOG                                                                      0x3a01c 
#define ixBIFC_DMA_ATTR_OVERRIDE_DEV0_F0_F1                                                            0x3a020 
#define ixBIFC_DMA_ATTR_OVERRIDE_DEV0_F2_F3                                                            0x3a024 
#define ixBIFC_DMA_ATTR_OVERRIDE_DEV0_F4_F5                                                            0x3a028 
#define ixBIFC_DMA_ATTR_OVERRIDE_DEV0_F6_F7                                                            0x3a02c 
#define ixNBIF_VWIRE_CTRL                                                                              0x3a040 
#define ixNBIF_SMN_VWR_VCHG_DIS_CTRL                                                                   0x3a044 
#define ixNBIF_SMN_VWR_VCHG_RST_CTRL0                                                                  0x3a048 
#define ixNBIF_SMN_VWR_VCHG_TRIG                                                                       0x3a050 
#define ixNBIF_SMN_VWR_WTRIG_CNTL                                                                      0x3a054 
#define ixNBIF_SMN_VWR_VCHG_DIS_CTRL_1                                                                 0x3a058 
#define ixNBIF_MGCG_CTRL                                                                               0x3a05c 
#define ixNBIF_DS_CTRL_LCLK                                                                            0x3a060 
#define ixSMN_MST_CNTL0                                                                                0x3a064 
#define ixSMN_MST_EP_CNTL1                                                                             0x3a068 
#define ixSMN_MST_EP_CNTL2                                                                             0x3a06c 
#define ixNBIF_SDP_VWR_VCHG_DIS_CTRL                                                                   0x3a070 
#define ixNBIF_SDP_VWR_VCHG_RST_CTRL0                                                                  0x3a074 
#define ixNBIF_SDP_VWR_VCHG_RST_CTRL1                                                                  0x3a078 
#define ixNBIF_SDP_VWR_VCHG_TRIG                                                                       0x3a07c 
#define ixBME_DUMMY_CNTL_0                                                                             0x3a098 
#define ixBIFC_THT_CNTL                                                                                0x3a09c 
#define ixBIFC_HSTARB_CNTL                                                                             0x3a0a0 
#define ixBIFC_GSI_CNTL                                                                                0x3a0a4 
#define ixBIFC_PCIEFUNC_CNTL                                                                           0x3a0a8 
#define ixBIFC_SDP_CNTL_0                                                                              0x3a0b0 
#define ixBIFC_PERF_CNTL_0                                                                             0x3a0c0 
#define ixBIFC_PERF_CNTL_1                                                                             0x3a0c4 
#define ixBIFC_PERF_CNT_MMIO_RD                                                                        0x3a0c8 
#define ixBIFC_PERF_CNT_MMIO_WR                                                                        0x3a0cc 
#define ixBIFC_PERF_CNT_DMA_RD                                                                         0x3a0d0 
#define ixBIFC_PERF_CNT_DMA_WR                                                                         0x3a0d4 
#define ixNBIF_REGIF_ERRSET_CTRL                                                                       0x3a0d8 
#define ixSMN_MST_EP_CNTL3                                                                             0x3a0f0 
#define ixSMN_MST_EP_CNTL4                                                                             0x3a0f4 
#define ixBIF_SELFRING_BUFFER_VID                                                                      0x3a100 
#define ixBIF_SELFRING_VECTOR_CNTL                                                                     0x3a104 


// addressBlock: bif_ras_bif_ras_regblk
// base address: 0x10100000
#define ixBIF_RAS_LEAF0_CTRL                                                                           0x39000 
#define ixBIF_RAS_LEAF1_CTRL                                                                           0x39004 
#define ixBIF_RAS_LEAF2_CTRL                                                                           0x39008 
#define ixBIF_RAS_MISC_CTRL                                                                            0x39100 
#define ixBIF_IOHUB_RAS_IH_CNTL                                                                        0x39ff8 
#define ixBIF_RAS_VWR_FROM_IOHUB                                                                       0x39ffc 


// addressBlock: rcc_pfc_amdgfx_RCCPFCDEC
// base address: 0x10134000
#define ixRCC_PFC_LTR_CNTL                                                                             0x0100 // duplicate 
#define ixRCC_PFC_PME_RESTORE                                                                          0x0104 // duplicate 
#define ixRCC_PFC_STICKY_RESTORE_0                                                                     0x0108 // duplicate 
#define ixRCC_PFC_STICKY_RESTORE_1                                                                     0x010c // duplicate 
#define ixRCC_PFC_STICKY_RESTORE_2                                                                     0x0110 // duplicate 
#define ixRCC_PFC_STICKY_RESTORE_3                                                                     0x0114 // duplicate 
#define ixRCC_PFC_STICKY_RESTORE_4                                                                     0x0118 // duplicate 
#define ixRCC_PFC_STICKY_RESTORE_5                                                                     0x011c // duplicate 
#define ixRCC_PFC_AUXPWR_CNTL                                                                          0x0120 // duplicate 


// addressBlock: rcc_pfc_amdgfxaz_RCCPFCDEC
// base address: 0x10134200
#define ixRCCPFCAMDGFXAZ_RCC_PFC_LTR_CNTL                                                              0x0100 // duplicate 
#define ixRCCPFCAMDGFXAZ_RCC_PFC_PME_RESTORE                                                           0x0104 // duplicate 
#define ixRCCPFCAMDGFXAZ_RCC_PFC_STICKY_RESTORE_0                                                      0x0108 // duplicate 
#define ixRCCPFCAMDGFXAZ_RCC_PFC_STICKY_RESTORE_1                                                      0x010c // duplicate 
#define ixRCCPFCAMDGFXAZ_RCC_PFC_STICKY_RESTORE_2                                                      0x0110 // duplicate 
#define ixRCCPFCAMDGFXAZ_RCC_PFC_STICKY_RESTORE_3                                                      0x0114 // duplicate 
#define ixRCCPFCAMDGFXAZ_RCC_PFC_STICKY_RESTORE_4                                                      0x0118 // duplicate 
#define ixRCCPFCAMDGFXAZ_RCC_PFC_STICKY_RESTORE_5                                                      0x011c // duplicate 
#define ixRCCPFCAMDGFXAZ_RCC_PFC_AUXPWR_CNTL                                                           0x0120 // duplicate 


// addressBlock: pciemsix_amdgfx_MSIXTDEC
// base address: 0x10170000
#define ixPCIEMSIX_VECT0_ADDR_LO                                                                       0x0000 
#define ixPCIEMSIX_VECT0_ADDR_HI                                                                       0x0004 
#define ixPCIEMSIX_VECT0_MSG_DATA                                                                      0x0008 
#define ixPCIEMSIX_VECT0_CONTROL                                                                       0x000c 
#define ixPCIEMSIX_VECT1_ADDR_LO                                                                       0x0010 
#define ixPCIEMSIX_VECT1_ADDR_HI                                                                       0x0014 
#define ixPCIEMSIX_VECT1_MSG_DATA                                                                      0x0018 
#define ixPCIEMSIX_VECT1_CONTROL                                                                       0x001c 
#define ixPCIEMSIX_VECT2_ADDR_LO                                                                       0x0020 
#define ixPCIEMSIX_VECT2_ADDR_HI                                                                       0x0024 
#define ixPCIEMSIX_VECT2_MSG_DATA                                                                      0x0028 
#define ixPCIEMSIX_VECT2_CONTROL                                                                       0x002c 
#define ixPCIEMSIX_VECT3_ADDR_LO                                                                       0x0030 
#define ixPCIEMSIX_VECT3_ADDR_HI                                                                       0x0034 
#define ixPCIEMSIX_VECT3_MSG_DATA                                                                      0x0038 
#define ixPCIEMSIX_VECT3_CONTROL                                                                       0x003c 
#define ixPCIEMSIX_VECT4_ADDR_LO                                                                       0x0040 
#define ixPCIEMSIX_VECT4_ADDR_HI                                                                       0x0044 
#define ixPCIEMSIX_VECT4_MSG_DATA                                                                      0x0048 
#define ixPCIEMSIX_VECT4_CONTROL                                                                       0x004c 
#define ixPCIEMSIX_VECT5_ADDR_LO                                                                       0x0050 
#define ixPCIEMSIX_VECT5_ADDR_HI                                                                       0x0054 
#define ixPCIEMSIX_VECT5_MSG_DATA                                                                      0x0058 
#define ixPCIEMSIX_VECT5_CONTROL                                                                       0x005c 
#define ixPCIEMSIX_VECT6_ADDR_LO                                                                       0x0060 
#define ixPCIEMSIX_VECT6_ADDR_HI                                                                       0x0064 
#define ixPCIEMSIX_VECT6_MSG_DATA                                                                      0x0068 
#define ixPCIEMSIX_VECT6_CONTROL                                                                       0x006c 
#define ixPCIEMSIX_VECT7_ADDR_LO                                                                       0x0070 
#define ixPCIEMSIX_VECT7_ADDR_HI                                                                       0x0074 
#define ixPCIEMSIX_VECT7_MSG_DATA                                                                      0x0078 
#define ixPCIEMSIX_VECT7_CONTROL                                                                       0x007c 
#define ixPCIEMSIX_VECT8_ADDR_LO                                                                       0x0080 
#define ixPCIEMSIX_VECT8_ADDR_HI                                                                       0x0084 
#define ixPCIEMSIX_VECT8_MSG_DATA                                                                      0x0088 
#define ixPCIEMSIX_VECT8_CONTROL                                                                       0x008c 
#define ixPCIEMSIX_VECT9_ADDR_LO                                                                       0x0090 
#define ixPCIEMSIX_VECT9_ADDR_HI                                                                       0x0094 
#define ixPCIEMSIX_VECT9_MSG_DATA                                                                      0x0098 
#define ixPCIEMSIX_VECT9_CONTROL                                                                       0x009c 
#define ixPCIEMSIX_VECT10_ADDR_LO                                                                      0x00a0 
#define ixPCIEMSIX_VECT10_ADDR_HI                                                                      0x00a4 
#define ixPCIEMSIX_VECT10_MSG_DATA                                                                     0x00a8 
#define ixPCIEMSIX_VECT10_CONTROL                                                                      0x00ac 
#define ixPCIEMSIX_VECT11_ADDR_LO                                                                      0x00b0 
#define ixPCIEMSIX_VECT11_ADDR_HI                                                                      0x00b4 
#define ixPCIEMSIX_VECT11_MSG_DATA                                                                     0x00b8 
#define ixPCIEMSIX_VECT11_CONTROL                                                                      0x00bc 
#define ixPCIEMSIX_VECT12_ADDR_LO                                                                      0x00c0 
#define ixPCIEMSIX_VECT12_ADDR_HI                                                                      0x00c4 
#define ixPCIEMSIX_VECT12_MSG_DATA                                                                     0x00c8 
#define ixPCIEMSIX_VECT12_CONTROL                                                                      0x00cc 
#define ixPCIEMSIX_VECT13_ADDR_LO                                                                      0x00d0 
#define ixPCIEMSIX_VECT13_ADDR_HI                                                                      0x00d4 
#define ixPCIEMSIX_VECT13_MSG_DATA                                                                     0x00d8 
#define ixPCIEMSIX_VECT13_CONTROL                                                                      0x00dc 
#define ixPCIEMSIX_VECT14_ADDR_LO                                                                      0x00e0 
#define ixPCIEMSIX_VECT14_ADDR_HI                                                                      0x00e4 
#define ixPCIEMSIX_VECT14_MSG_DATA                                                                     0x00e8 
#define ixPCIEMSIX_VECT14_CONTROL                                                                      0x00ec 
#define ixPCIEMSIX_VECT15_ADDR_LO                                                                      0x00f0 
#define ixPCIEMSIX_VECT15_ADDR_HI                                                                      0x00f4 
#define ixPCIEMSIX_VECT15_MSG_DATA                                                                     0x00f8 
#define ixPCIEMSIX_VECT15_CONTROL                                                                      0x00fc 
#define ixPCIEMSIX_VECT16_ADDR_LO                                                                      0x0100 
#define ixPCIEMSIX_VECT16_ADDR_HI                                                                      0x0104 
#define ixPCIEMSIX_VECT16_MSG_DATA                                                                     0x0108 
#define ixPCIEMSIX_VECT16_CONTROL                                                                      0x010c 
#define ixPCIEMSIX_VECT17_ADDR_LO                                                                      0x0110 
#define ixPCIEMSIX_VECT17_ADDR_HI                                                                      0x0114 
#define ixPCIEMSIX_VECT17_MSG_DATA                                                                     0x0118 
#define ixPCIEMSIX_VECT17_CONTROL                                                                      0x011c 
#define ixPCIEMSIX_VECT18_ADDR_LO                                                                      0x0120 
#define ixPCIEMSIX_VECT18_ADDR_HI                                                                      0x0124 
#define ixPCIEMSIX_VECT18_MSG_DATA                                                                     0x0128 
#define ixPCIEMSIX_VECT18_CONTROL                                                                      0x012c 
#define ixPCIEMSIX_VECT19_ADDR_LO                                                                      0x0130 
#define ixPCIEMSIX_VECT19_ADDR_HI                                                                      0x0134 
#define ixPCIEMSIX_VECT19_MSG_DATA                                                                     0x0138 
#define ixPCIEMSIX_VECT19_CONTROL                                                                      0x013c 
#define ixPCIEMSIX_VECT20_ADDR_LO                                                                      0x0140 
#define ixPCIEMSIX_VECT20_ADDR_HI                                                                      0x0144 
#define ixPCIEMSIX_VECT20_MSG_DATA                                                                     0x0148 
#define ixPCIEMSIX_VECT20_CONTROL                                                                      0x014c 
#define ixPCIEMSIX_VECT21_ADDR_LO                                                                      0x0150 
#define ixPCIEMSIX_VECT21_ADDR_HI                                                                      0x0154 
#define ixPCIEMSIX_VECT21_MSG_DATA                                                                     0x0158 
#define ixPCIEMSIX_VECT21_CONTROL                                                                      0x015c 
#define ixPCIEMSIX_VECT22_ADDR_LO                                                                      0x0160 
#define ixPCIEMSIX_VECT22_ADDR_HI                                                                      0x0164 
#define ixPCIEMSIX_VECT22_MSG_DATA                                                                     0x0168 
#define ixPCIEMSIX_VECT22_CONTROL                                                                      0x016c 
#define ixPCIEMSIX_VECT23_ADDR_LO                                                                      0x0170 
#define ixPCIEMSIX_VECT23_ADDR_HI                                                                      0x0174 
#define ixPCIEMSIX_VECT23_MSG_DATA                                                                     0x0178 
#define ixPCIEMSIX_VECT23_CONTROL                                                                      0x017c 
#define ixPCIEMSIX_VECT24_ADDR_LO                                                                      0x0180 
#define ixPCIEMSIX_VECT24_ADDR_HI                                                                      0x0184 
#define ixPCIEMSIX_VECT24_MSG_DATA                                                                     0x0188 
#define ixPCIEMSIX_VECT24_CONTROL                                                                      0x018c 
#define ixPCIEMSIX_VECT25_ADDR_LO                                                                      0x0190 
#define ixPCIEMSIX_VECT25_ADDR_HI                                                                      0x0194 
#define ixPCIEMSIX_VECT25_MSG_DATA                                                                     0x0198 
#define ixPCIEMSIX_VECT25_CONTROL                                                                      0x019c 
#define ixPCIEMSIX_VECT26_ADDR_LO                                                                      0x01a0 
#define ixPCIEMSIX_VECT26_ADDR_HI                                                                      0x01a4 
#define ixPCIEMSIX_VECT26_MSG_DATA                                                                     0x01a8 
#define ixPCIEMSIX_VECT26_CONTROL                                                                      0x01ac 
#define ixPCIEMSIX_VECT27_ADDR_LO                                                                      0x01b0 
#define ixPCIEMSIX_VECT27_ADDR_HI                                                                      0x01b4 
#define ixPCIEMSIX_VECT27_MSG_DATA                                                                     0x01b8 
#define ixPCIEMSIX_VECT27_CONTROL                                                                      0x01bc 
#define ixPCIEMSIX_VECT28_ADDR_LO                                                                      0x01c0 
#define ixPCIEMSIX_VECT28_ADDR_HI                                                                      0x01c4 
#define ixPCIEMSIX_VECT28_MSG_DATA                                                                     0x01c8 
#define ixPCIEMSIX_VECT28_CONTROL                                                                      0x01cc 
#define ixPCIEMSIX_VECT29_ADDR_LO                                                                      0x01d0 
#define ixPCIEMSIX_VECT29_ADDR_HI                                                                      0x01d4 
#define ixPCIEMSIX_VECT29_MSG_DATA                                                                     0x01d8 
#define ixPCIEMSIX_VECT29_CONTROL                                                                      0x01dc 
#define ixPCIEMSIX_VECT30_ADDR_LO                                                                      0x01e0 
#define ixPCIEMSIX_VECT30_ADDR_HI                                                                      0x01e4 
#define ixPCIEMSIX_VECT30_MSG_DATA                                                                     0x01e8 
#define ixPCIEMSIX_VECT30_CONTROL                                                                      0x01ec 
#define ixPCIEMSIX_VECT31_ADDR_LO                                                                      0x01f0 
#define ixPCIEMSIX_VECT31_ADDR_HI                                                                      0x01f4 
#define ixPCIEMSIX_VECT31_MSG_DATA                                                                     0x01f8 
#define ixPCIEMSIX_VECT31_CONTROL                                                                      0x01fc 


// addressBlock: pciemsix_amdgfx_MSIXPDEC
// base address: 0x10171000
#define ixPCIEMSIX_PBA                                                                                 0x0000 


// addressBlock: syshub_mmreg_ind_syshubind
// base address: 0x0
#define ixSYSHUBMMREGIND_SYSHUB_DS_CTRL_SOCCLK                                                         0x10000 // duplicate 
#define ixSYSHUBMMREGIND_SYSHUB_DS_CTRL2_SOCCLK                                                        0x10004 // duplicate 
#define ixSYSHUBMMREGIND_SYSHUB_BGEN_ENHANCEMENT_BYPASS_EN_SOCCLK                                      0x10008 // duplicate 
#define ixSYSHUBMMREGIND_SYSHUB_BGEN_ENHANCEMENT_IMM_EN_SOCCLK                                         0x1000c // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK0_SW0_SYSHUB_QOS_CNTL                                                  0x10010 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK0_SW1_SYSHUB_QOS_CNTL                                                  0x10014 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK0_SW0_CL0_CNTL                                                         0x10018 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK0_SW0_CL1_CNTL                                                         0x1001c // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK0_SW0_CL2_CNTL                                                         0x10020 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK0_SW0_CL3_CNTL                                                         0x10024 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK0_SW0_CL4_CNTL                                                         0x10028 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK0_SW0_CL5_CNTL                                                         0x1002c // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK0_SW1_CL0_CNTL                                                         0x10030 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK0_SW2_CL0_CNTL                                                         0x10034 // duplicate 
#define ixSYSHUBMMREGIND_SYSHUB_CG_CNTL                                                                0x10300 // duplicate 
#define ixSYSHUBMMREGIND_SYSHUB_TRANS_IDLE                                                             0x10308 // duplicate 
#define ixSYSHUBMMREGIND_SYSHUB_HP_TIMER                                                               0x1030c // duplicate 
#define ixSYSHUBMMREGIND_SYSHUB_SCRATCH                                                                0x10f00 // duplicate 
#define ixSYSHUBMMREGIND_SYSHUB_DS_CTRL_SHUBCLK                                                        0x11000 // duplicate 
#define ixSYSHUBMMREGIND_SYSHUB_DS_CTRL2_SHUBCLK                                                       0x11004 // duplicate 
#define ixSYSHUBMMREGIND_SYSHUB_BGEN_ENHANCEMENT_BYPASS_EN_SHUBCLK                                     0x11008 // duplicate 
#define ixSYSHUBMMREGIND_SYSHUB_BGEN_ENHANCEMENT_IMM_EN_SHUBCLK                                        0x1100c // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW0_SYSHUB_QOS_CNTL                                                  0x11010 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW1_SYSHUB_QOS_CNTL                                                  0x11014 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW0_CL0_CNTL                                                         0x11018 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW0_CL1_CNTL                                                         0x1101c // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW0_CL2_CNTL                                                         0x11020 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW0_CL3_CNTL                                                         0x11024 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW0_CL4_CNTL                                                         0x11028 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW1_CL0_CNTL                                                         0x1102c // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW1_CL1_CNTL                                                         0x11030 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW1_CL2_CNTL                                                         0x11034 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW1_CL3_CNTL                                                         0x11038 // duplicate 
#define ixSYSHUBMMREGIND_DMA_CLK1_SW1_CL4_CNTL                                                         0x1103c // duplicate 

#endif
