# Auto-generated by BabelAPI, do not modify.
"""
This namespace contains endpoints and data types for creating and managing
shared links.
"""

try:
    from . import babel_validators as bv
except (SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import babel_validators as bv

try:
    from . import (
        files,
    )
except ValueError:
    import files

class Visibility(object):
    """
    Who can access a shared link. The most open visibility is ``public``. The
    default depends on many aspects, such as team and user preferences and
    shared folder settings.

    :ivar public: Anyone who has received the link can access it. No login
        required.
    :ivar team_only: Only members of the same DfB (Dropbox for Business) team
        can access the link. Login is required.
    :ivar password: A link-specific password is required to access the link.
        Login is not required.
    :ivar team_and_password: Only members of the same DfB (Dropbox for Business)
        team who have the link-specific password can access the link.
    :ivar shared_folder_only: Only members of the shared folder containing the
        linked file can access the link. Login is required.
    :ivar other: An unknown restriction is in place.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    public = None
    # Attribute is overwritten below the class definition
    team_only = None
    # Attribute is overwritten below the class definition
    password = None
    # Attribute is overwritten below the class definition
    team_and_password = None
    # Attribute is overwritten below the class definition
    shared_folder_only = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_public(self):
        return self._tag == 'public'

    def is_team_only(self):
        return self._tag == 'team_only'

    def is_password(self):
        return self._tag == 'password'

    def is_team_and_password(self):
        return self._tag == 'team_and_password'

    def is_shared_folder_only(self):
        return self._tag == 'shared_folder_only'

    def is_other(self):
        return self._tag == 'other'

    def __repr__(self):
        return 'Visibility(%r)' % self._tag

class LinkMetadata(object):
    """
    Metadata for a shared link. This can be either a :class:`PathLinkMetadata`
    or :class:`CollectionLinkMetadata`.

    :ivar url: URL of the shared link.
    :ivar visibility: Who can access the link.
    :ivar expires: Expiration time, if set. By default the link won't expire.
    """

    __slots__ = [
        '_url_value',
        '_url_present',
        '_visibility_value',
        '_visibility_present',
        '_expires_value',
        '_expires_present',
    ]

    def __init__(self,
                 url=None,
                 visibility=None,
                 expires=None):
        self._url_value = None
        self._url_present = False
        self._visibility_value = None
        self._visibility_present = False
        self._expires_value = None
        self._expires_present = False
        if url is not None:
            self.url = url
        if visibility is not None:
            self.visibility = visibility
        if expires is not None:
            self.expires = expires

    @property
    def url(self):
        """
        URL of the shared link.

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    @property
    def visibility(self):
        """
        Who can access the link.

        :rtype: Visibility
        """
        if self._visibility_present:
            return self._visibility_value
        else:
            raise AttributeError("missing required field 'visibility'")

    @visibility.setter
    def visibility(self, val):
        self._visibility_validator.validate_type_only(val)
        self._visibility_value = val
        self._visibility_present = True

    @visibility.deleter
    def visibility(self):
        self._visibility_value = None
        self._visibility_present = False

    @property
    def expires(self):
        """
        Expiration time, if set. By default the link won't expire.

        :rtype: datetime.datetime
        """
        if self._expires_present:
            return self._expires_value
        else:
            return None

    @expires.setter
    def expires(self, val):
        if val is None:
            del self.expires
            return
        val = self._expires_validator.validate(val)
        self._expires_value = val
        self._expires_present = True

    @expires.deleter
    def expires(self):
        self._expires_value = None
        self._expires_present = False

    def __repr__(self):
        return 'LinkMetadata(url={!r}, visibility={!r}, expires={!r})'.format(
            self._url_value,
            self._visibility_value,
            self._expires_value,
        )

class PathLinkMetadata(LinkMetadata):
    """
    Metadata for a path-based shared link.

    :ivar path: Path in user's Dropbox.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    def __init__(self,
                 url=None,
                 visibility=None,
                 path=None,
                 expires=None):
        super(PathLinkMetadata, self).__init__(url,
                                               visibility,
                                               expires)
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        Path in user's Dropbox.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'PathLinkMetadata(url={!r}, visibility={!r}, path={!r}, expires={!r})'.format(
            self._url_value,
            self._visibility_value,
            self._path_value,
            self._expires_value,
        )

class CollectionLinkMetadata(LinkMetadata):
    """
    Metadata for a collection-based shared link.
    """

    __slots__ = [
    ]

    def __init__(self,
                 url=None,
                 visibility=None,
                 expires=None):
        super(CollectionLinkMetadata, self).__init__(url,
                                                     visibility,
                                                     expires)

    def __repr__(self):
        return 'CollectionLinkMetadata(url={!r}, visibility={!r}, expires={!r})'.format(
            self._url_value,
            self._visibility_value,
            self._expires_value,
        )

class GetSharedLinksArg(object):
    """
    Arguments for get_shared_links.

    :ivar path: See get_shared_links description.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    def __init__(self,
                 path=None):
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        See get_shared_links description.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            return None

    @path.setter
    def path(self, val):
        if val is None:
            del self.path
            return
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'GetSharedLinksArg(path={!r})'.format(
            self._path_value,
        )

class GetSharedLinksResult(object):
    """
    Result for get_shared_links.

    :ivar links: Shared links applicable to the path argument.
    """

    __slots__ = [
        '_links_value',
        '_links_present',
    ]

    def __init__(self,
                 links=None):
        self._links_value = None
        self._links_present = False
        if links is not None:
            self.links = links

    @property
    def links(self):
        """
        Shared links applicable to the path argument.

        :rtype: list of [LinkMetadata]
        """
        if self._links_present:
            return self._links_value
        else:
            raise AttributeError("missing required field 'links'")

    @links.setter
    def links(self, val):
        val = self._links_validator.validate(val)
        self._links_value = val
        self._links_present = True

    @links.deleter
    def links(self):
        self._links_value = None
        self._links_present = False

    def __repr__(self):
        return 'GetSharedLinksResult(links={!r})'.format(
            self._links_value,
        )

class GetSharedLinksError(object):

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def path(cls, val):
        return cls('path', val)

    def is_path(self):
        return self._tag == 'path'

    def is_other(self):
        return self._tag == 'other'

    def get_path(self):
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'GetSharedLinksError(%r)' % self._tag

class PendingUploadMode(object):
    """
    Flag to indicate pending upload default (for linking to not-yet-existing
    paths).

    :ivar file: Assume pending uploads are files.
    :ivar folder: Assume pending uploads are folders.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = None
    # Attribute is overwritten below the class definition
    file = None
    # Attribute is overwritten below the class definition
    folder = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_file(self):
        return self._tag == 'file'

    def is_folder(self):
        return self._tag == 'folder'

    def __repr__(self):
        return 'PendingUploadMode(%r)' % self._tag

class CreateSharedLinkArg(object):
    """
    Arguments for create_shared_link.

    :ivar path: The path to share.
    :ivar short_url: Whether to return a shortened URL.
    :ivar pending_upload: If it's okay to share a path that does not yet exist,
        set this to either 'file' or 'folder' to indicate whether to assume it's
        a file or folder.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_short_url_value',
        '_short_url_present',
        '_pending_upload_value',
        '_pending_upload_present',
    ]

    def __init__(self,
                 path=None,
                 short_url=None,
                 pending_upload=None):
        self._path_value = None
        self._path_present = False
        self._short_url_value = None
        self._short_url_present = False
        self._pending_upload_value = None
        self._pending_upload_present = False
        if path is not None:
            self.path = path
        if short_url is not None:
            self.short_url = short_url
        if pending_upload is not None:
            self.pending_upload = pending_upload

    @property
    def path(self):
        """
        The path to share.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def short_url(self):
        """
        Whether to return a shortened URL.

        :rtype: bool
        """
        if self._short_url_present:
            return self._short_url_value
        else:
            return False

    @short_url.setter
    def short_url(self, val):
        val = self._short_url_validator.validate(val)
        self._short_url_value = val
        self._short_url_present = True

    @short_url.deleter
    def short_url(self):
        self._short_url_value = None
        self._short_url_present = False

    @property
    def pending_upload(self):
        """
        If it's okay to share a path that does not yet exist, set this to either
        'file' or 'folder' to indicate whether to assume it's a file or folder.

        :rtype: PendingUploadMode
        """
        if self._pending_upload_present:
            return self._pending_upload_value
        else:
            return None

    @pending_upload.setter
    def pending_upload(self, val):
        if val is None:
            del self.pending_upload
            return
        self._pending_upload_validator.validate_type_only(val)
        self._pending_upload_value = val
        self._pending_upload_present = True

    @pending_upload.deleter
    def pending_upload(self):
        self._pending_upload_value = None
        self._pending_upload_present = False

    def __repr__(self):
        return 'CreateSharedLinkArg(path={!r}, short_url={!r}, pending_upload={!r})'.format(
            self._path_value,
            self._short_url_value,
            self._pending_upload_value,
        )

class CreateSharedLinkError(object):

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def path(cls, val):
        return cls('path', val)

    def is_path(self):
        return self._tag == 'path'

    def is_other(self):
        return self._tag == 'other'

    def get_path(self):
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'CreateSharedLinkError(%r)' % self._tag

class AccessType(object):
    """
    The access type fo this shared folder. Each type is associated with specific
    access permission.

    :ivar owner: The member is the owner of the shared folder. The user can both
        view and edit the shared folder.
    :ivar editor: The member can both view and edit the shared folder.
    :ivar viewer: The member can only view the shared folder.
    :ivar other: An unknown access type.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    owner = None
    # Attribute is overwritten below the class definition
    editor = None
    # Attribute is overwritten below the class definition
    viewer = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_owner(self):
        return self._tag == 'owner'

    def is_editor(self):
        return self._tag == 'editor'

    def is_viewer(self):
        return self._tag == 'viewer'

    def is_other(self):
        return self._tag == 'other'

    def __repr__(self):
        return 'AccessType(%r)' % self._tag

class SharedLinkPolicy(object):
    """
    Policy governing who can links be shared with.

    :ivar all: Links can be shared with anyone.
    :ivar members_only: Links can only be shared among members of the shared
        folder.
    :ivar other: An unknown shared link policy.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    all = None
    # Attribute is overwritten below the class definition
    members_only = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_all(self):
        return self._tag == 'all'

    def is_members_only(self):
        return self._tag == 'members_only'

    def is_other(self):
        return self._tag == 'other'

    def __repr__(self):
        return 'SharedLinkPolicy(%r)' % self._tag

class MembershipInfo(object):
    """
    The information about a member of the shared folder.

    :ivar access_type: This access type for this user member.
    """

    __slots__ = [
        '_access_type_value',
        '_access_type_present',
    ]

    def __init__(self,
                 access_type=None):
        self._access_type_value = None
        self._access_type_present = False
        if access_type is not None:
            self.access_type = access_type

    @property
    def access_type(self):
        """
        This access type for this user member.

        :rtype: AccessType
        """
        if self._access_type_present:
            return self._access_type_value
        else:
            raise AttributeError("missing required field 'access_type'")

    @access_type.setter
    def access_type(self, val):
        self._access_type_validator.validate_type_only(val)
        self._access_type_value = val
        self._access_type_present = True

    @access_type.deleter
    def access_type(self):
        self._access_type_value = None
        self._access_type_present = False

    def __repr__(self):
        return 'MembershipInfo(access_type={!r})'.format(
            self._access_type_value,
        )

class UserInfo(object):
    """
    The information about a user.

    :ivar account_id: The account ID of the user.
    :ivar display_name: The display name of the user.
    :ivar same_team: If the user is in the same team as current user.
    :ivar member_id: The member id of the user for the shared folder. This field
        will only present if same_team field is true.
    """

    __slots__ = [
        '_account_id_value',
        '_account_id_present',
        '_display_name_value',
        '_display_name_present',
        '_same_team_value',
        '_same_team_present',
        '_member_id_value',
        '_member_id_present',
    ]

    def __init__(self,
                 account_id=None,
                 display_name=None,
                 same_team=None,
                 member_id=None):
        self._account_id_value = None
        self._account_id_present = False
        self._display_name_value = None
        self._display_name_present = False
        self._same_team_value = None
        self._same_team_present = False
        self._member_id_value = None
        self._member_id_present = False
        if account_id is not None:
            self.account_id = account_id
        if display_name is not None:
            self.display_name = display_name
        if same_team is not None:
            self.same_team = same_team
        if member_id is not None:
            self.member_id = member_id

    @property
    def account_id(self):
        """
        The account ID of the user.

        :rtype: str
        """
        if self._account_id_present:
            return self._account_id_value
        else:
            raise AttributeError("missing required field 'account_id'")

    @account_id.setter
    def account_id(self, val):
        val = self._account_id_validator.validate(val)
        self._account_id_value = val
        self._account_id_present = True

    @account_id.deleter
    def account_id(self):
        self._account_id_value = None
        self._account_id_present = False

    @property
    def display_name(self):
        """
        The display name of the user.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            raise AttributeError("missing required field 'display_name'")

    @display_name.setter
    def display_name(self, val):
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    @property
    def same_team(self):
        """
        If the user is in the same team as current user.

        :rtype: bool
        """
        if self._same_team_present:
            return self._same_team_value
        else:
            raise AttributeError("missing required field 'same_team'")

    @same_team.setter
    def same_team(self, val):
        val = self._same_team_validator.validate(val)
        self._same_team_value = val
        self._same_team_present = True

    @same_team.deleter
    def same_team(self):
        self._same_team_value = None
        self._same_team_present = False

    @property
    def member_id(self):
        """
        The member id of the user for the shared folder. This field will only
        present if same_team field is true.

        :rtype: str
        """
        if self._member_id_present:
            return self._member_id_value
        else:
            return None

    @member_id.setter
    def member_id(self, val):
        if val is None:
            del self.member_id
            return
        val = self._member_id_validator.validate(val)
        self._member_id_value = val
        self._member_id_present = True

    @member_id.deleter
    def member_id(self):
        self._member_id_value = None
        self._member_id_present = False

    def __repr__(self):
        return 'UserInfo(account_id={!r}, display_name={!r}, same_team={!r}, member_id={!r})'.format(
            self._account_id_value,
            self._display_name_value,
            self._same_team_value,
            self._member_id_value,
        )

class UserMembershipInfo(MembershipInfo):
    """
    The information about a user member of the shared folder.

    :ivar user: The account information for the membership user.
    :ivar active: If this membership is active. When the field is false, it
        means the user has left the shared folder (but may still rejoin).
    """

    __slots__ = [
        '_user_value',
        '_user_present',
        '_active_value',
        '_active_present',
    ]

    def __init__(self,
                 access_type=None,
                 user=None,
                 active=None):
        super(UserMembershipInfo, self).__init__(access_type)
        self._user_value = None
        self._user_present = False
        self._active_value = None
        self._active_present = False
        if user is not None:
            self.user = user
        if active is not None:
            self.active = active

    @property
    def user(self):
        """
        The account information for the membership user.

        :rtype: UserInfo
        """
        if self._user_present:
            return self._user_value
        else:
            raise AttributeError("missing required field 'user'")

    @user.setter
    def user(self, val):
        self._user_validator.validate_type_only(val)
        self._user_value = val
        self._user_present = True

    @user.deleter
    def user(self):
        self._user_value = None
        self._user_present = False

    @property
    def active(self):
        """
        If this membership is active. When the field is false, it means the user
        has left the shared folder (but may still rejoin).

        :rtype: bool
        """
        if self._active_present:
            return self._active_value
        else:
            raise AttributeError("missing required field 'active'")

    @active.setter
    def active(self, val):
        val = self._active_validator.validate(val)
        self._active_value = val
        self._active_present = True

    @active.deleter
    def active(self):
        self._active_value = None
        self._active_present = False

    def __repr__(self):
        return 'UserMembershipInfo(access_type={!r}, user={!r}, active={!r})'.format(
            self._access_type_value,
            self._user_value,
            self._active_value,
        )

class GroupInfo(object):
    """
    The information about a group. Group is a way to manage a list of users  who
    need same access permission to the shared folder.

    :ivar display_name: The display name of the group.
    :ivar id: The ID of the group.
    :ivar member_count: The total number of member for this group.
    :ivar same_team: If all members of the group are in the same team as current
        user.
    """

    __slots__ = [
        '_display_name_value',
        '_display_name_present',
        '_id_value',
        '_id_present',
        '_member_count_value',
        '_member_count_present',
        '_same_team_value',
        '_same_team_present',
    ]

    def __init__(self,
                 display_name=None,
                 id=None,
                 member_count=None,
                 same_team=None):
        self._display_name_value = None
        self._display_name_present = False
        self._id_value = None
        self._id_present = False
        self._member_count_value = None
        self._member_count_present = False
        self._same_team_value = None
        self._same_team_present = False
        if display_name is not None:
            self.display_name = display_name
        if id is not None:
            self.id = id
        if member_count is not None:
            self.member_count = member_count
        if same_team is not None:
            self.same_team = same_team

    @property
    def display_name(self):
        """
        The display name of the group.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            raise AttributeError("missing required field 'display_name'")

    @display_name.setter
    def display_name(self, val):
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    @property
    def id(self):
        """
        The ID of the group.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def member_count(self):
        """
        The total number of member for this group.

        :rtype: long
        """
        if self._member_count_present:
            return self._member_count_value
        else:
            raise AttributeError("missing required field 'member_count'")

    @member_count.setter
    def member_count(self, val):
        val = self._member_count_validator.validate(val)
        self._member_count_value = val
        self._member_count_present = True

    @member_count.deleter
    def member_count(self):
        self._member_count_value = None
        self._member_count_present = False

    @property
    def same_team(self):
        """
        If all members of the group are in the same team as current user.

        :rtype: bool
        """
        if self._same_team_present:
            return self._same_team_value
        else:
            raise AttributeError("missing required field 'same_team'")

    @same_team.setter
    def same_team(self, val):
        val = self._same_team_validator.validate(val)
        self._same_team_value = val
        self._same_team_present = True

    @same_team.deleter
    def same_team(self):
        self._same_team_value = None
        self._same_team_present = False

    def __repr__(self):
        return 'GroupInfo(display_name={!r}, id={!r}, member_count={!r}, same_team={!r})'.format(
            self._display_name_value,
            self._id_value,
            self._member_count_value,
            self._same_team_value,
        )

class GroupMembershipInfo(MembershipInfo):
    """
    The information about a group member of the shared folder.

    :ivar group: The information about the membership group.
    """

    __slots__ = [
        '_group_value',
        '_group_present',
    ]

    def __init__(self,
                 access_type=None,
                 group=None):
        super(GroupMembershipInfo, self).__init__(access_type)
        self._group_value = None
        self._group_present = False
        if group is not None:
            self.group = group

    @property
    def group(self):
        """
        The information about the membership group.

        :rtype: GroupInfo
        """
        if self._group_present:
            return self._group_value
        else:
            raise AttributeError("missing required field 'group'")

    @group.setter
    def group(self, val):
        self._group_validator.validate_type_only(val)
        self._group_value = val
        self._group_present = True

    @group.deleter
    def group(self):
        self._group_value = None
        self._group_present = False

    def __repr__(self):
        return 'GroupMembershipInfo(access_type={!r}, group={!r})'.format(
            self._access_type_value,
            self._group_value,
        )

class SharedFolderMetadata(object):
    """
    The base type for shared folder metadata.

    :ivar path_lower: The lower-cased full path of this shared folder.
    :ivar name: The name of the this shared folder.
    :ivar id: The ID of the shared folder.
    :ivar access_type: Who can access this shared folder.
    :ivar shared_link_policy: Who links can be shared with.
    """

    __slots__ = [
        '_path_lower_value',
        '_path_lower_present',
        '_name_value',
        '_name_present',
        '_id_value',
        '_id_present',
        '_access_type_value',
        '_access_type_present',
        '_shared_link_policy_value',
        '_shared_link_policy_present',
    ]

    def __init__(self,
                 path_lower=None,
                 name=None,
                 id=None,
                 access_type=None,
                 shared_link_policy=None):
        self._path_lower_value = None
        self._path_lower_present = False
        self._name_value = None
        self._name_present = False
        self._id_value = None
        self._id_present = False
        self._access_type_value = None
        self._access_type_present = False
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False
        if path_lower is not None:
            self.path_lower = path_lower
        if name is not None:
            self.name = name
        if id is not None:
            self.id = id
        if access_type is not None:
            self.access_type = access_type
        if shared_link_policy is not None:
            self.shared_link_policy = shared_link_policy

    @property
    def path_lower(self):
        """
        The lower-cased full path of this shared folder.

        :rtype: str
        """
        if self._path_lower_present:
            return self._path_lower_value
        else:
            raise AttributeError("missing required field 'path_lower'")

    @path_lower.setter
    def path_lower(self, val):
        val = self._path_lower_validator.validate(val)
        self._path_lower_value = val
        self._path_lower_present = True

    @path_lower.deleter
    def path_lower(self):
        self._path_lower_value = None
        self._path_lower_present = False

    @property
    def name(self):
        """
        The name of the this shared folder.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    @property
    def id(self):
        """
        The ID of the shared folder.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def access_type(self):
        """
        Who can access this shared folder.

        :rtype: AccessType
        """
        if self._access_type_present:
            return self._access_type_value
        else:
            raise AttributeError("missing required field 'access_type'")

    @access_type.setter
    def access_type(self, val):
        self._access_type_validator.validate_type_only(val)
        self._access_type_value = val
        self._access_type_present = True

    @access_type.deleter
    def access_type(self):
        self._access_type_value = None
        self._access_type_present = False

    @property
    def shared_link_policy(self):
        """
        Who links can be shared with.

        :rtype: SharedLinkPolicy
        """
        if self._shared_link_policy_present:
            return self._shared_link_policy_value
        else:
            raise AttributeError("missing required field 'shared_link_policy'")

    @shared_link_policy.setter
    def shared_link_policy(self, val):
        self._shared_link_policy_validator.validate_type_only(val)
        self._shared_link_policy_value = val
        self._shared_link_policy_present = True

    @shared_link_policy.deleter
    def shared_link_policy(self):
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False

    def __repr__(self):
        return 'SharedFolderMetadata(path_lower={!r}, name={!r}, id={!r}, access_type={!r}, shared_link_policy={!r})'.format(
            self._path_lower_value,
            self._name_value,
            self._id_value,
            self._access_type_value,
            self._shared_link_policy_value,
        )

class BasicSharedFolderMetadata(SharedFolderMetadata):
    """
    The metadata which includes basic information about the shared folder.
    """

    __slots__ = [
    ]

    def __init__(self,
                 path_lower=None,
                 name=None,
                 id=None,
                 access_type=None,
                 shared_link_policy=None):
        super(BasicSharedFolderMetadata, self).__init__(path_lower,
                                                        name,
                                                        id,
                                                        access_type,
                                                        shared_link_policy)

    def __repr__(self):
        return 'BasicSharedFolderMetadata(path_lower={!r}, name={!r}, id={!r}, access_type={!r}, shared_link_policy={!r})'.format(
            self._path_lower_value,
            self._name_value,
            self._id_value,
            self._access_type_value,
            self._shared_link_policy_value,
        )

class FullSharedFolderMetadata(SharedFolderMetadata):
    """
    The full metadata for the shared folder which includes user and group
    membership.

    :ivar membership: The list of user members of the shared folder.
    :ivar groups: The list of group members of the shared folder.
    """

    __slots__ = [
        '_membership_value',
        '_membership_present',
        '_groups_value',
        '_groups_present',
    ]

    def __init__(self,
                 path_lower=None,
                 name=None,
                 id=None,
                 access_type=None,
                 shared_link_policy=None,
                 membership=None,
                 groups=None):
        super(FullSharedFolderMetadata, self).__init__(path_lower,
                                                       name,
                                                       id,
                                                       access_type,
                                                       shared_link_policy)
        self._membership_value = None
        self._membership_present = False
        self._groups_value = None
        self._groups_present = False
        if membership is not None:
            self.membership = membership
        if groups is not None:
            self.groups = groups

    @property
    def membership(self):
        """
        The list of user members of the shared folder.

        :rtype: list of [UserMembershipInfo]
        """
        if self._membership_present:
            return self._membership_value
        else:
            raise AttributeError("missing required field 'membership'")

    @membership.setter
    def membership(self, val):
        val = self._membership_validator.validate(val)
        self._membership_value = val
        self._membership_present = True

    @membership.deleter
    def membership(self):
        self._membership_value = None
        self._membership_present = False

    @property
    def groups(self):
        """
        The list of group members of the shared folder.

        :rtype: list of [GroupMembershipInfo]
        """
        if self._groups_present:
            return self._groups_value
        else:
            raise AttributeError("missing required field 'groups'")

    @groups.setter
    def groups(self, val):
        val = self._groups_validator.validate(val)
        self._groups_value = val
        self._groups_present = True

    @groups.deleter
    def groups(self):
        self._groups_value = None
        self._groups_present = False

    def __repr__(self):
        return 'FullSharedFolderMetadata(path_lower={!r}, name={!r}, id={!r}, access_type={!r}, shared_link_policy={!r}, membership={!r}, groups={!r})'.format(
            self._path_lower_value,
            self._name_value,
            self._id_value,
            self._access_type_value,
            self._shared_link_policy_value,
            self._membership_value,
            self._groups_value,
        )

class SharedFolderAccessError(object):
    """
    There is an error accessing the shared folder.

    :ivar invalid_id: This shared folder ID is invalid.
    :ivar not_member: The user is not a member of the shared folder thus cannot
        access it.
    :ivar has_left: The user has left the shared folder already thus is no
        longer able to access it.
    :ivar require_owner: The user needs to be the owner to access the shared
        folder.
    :ivar is_root: The folder is a root folder and cannot be shared.
    :ivar is_team_shared_folder: The folder is a team shared folder and the user
        cannot access it.
    :ivar is_app_folder: The folder is an app folder and cannot be shared.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = None
    # Attribute is overwritten below the class definition
    invalid_id = None
    # Attribute is overwritten below the class definition
    not_member = None
    # Attribute is overwritten below the class definition
    has_left = None
    # Attribute is overwritten below the class definition
    require_owner = None
    # Attribute is overwritten below the class definition
    is_root = None
    # Attribute is overwritten below the class definition
    is_team_shared_folder = None
    # Attribute is overwritten below the class definition
    is_app_folder = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_invalid_id(self):
        return self._tag == 'invalid_id'

    def is_not_member(self):
        return self._tag == 'not_member'

    def is_has_left(self):
        return self._tag == 'has_left'

    def is_require_owner(self):
        return self._tag == 'require_owner'

    def is_is_root(self):
        return self._tag == 'is_root'

    def is_is_team_shared_folder(self):
        return self._tag == 'is_team_shared_folder'

    def is_is_app_folder(self):
        return self._tag == 'is_app_folder'

    def __repr__(self):
        return 'SharedFolderAccessError(%r)' % self._tag

class GetSharedFolderArgs(object):
    """
    Arguments for get_shared_folder.

    :ivar id: The ID for the shared folder.
    :ivar include_membership: If include user and group membership information
        in the response.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_include_membership_value',
        '_include_membership_present',
    ]

    def __init__(self,
                 id=None,
                 include_membership=None):
        self._id_value = None
        self._id_present = False
        self._include_membership_value = None
        self._include_membership_present = False
        if id is not None:
            self.id = id
        if include_membership is not None:
            self.include_membership = include_membership

    @property
    def id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def include_membership(self):
        """
        If include user and group membership information in the response.

        :rtype: bool
        """
        if self._include_membership_present:
            return self._include_membership_value
        else:
            return True

    @include_membership.setter
    def include_membership(self, val):
        val = self._include_membership_validator.validate(val)
        self._include_membership_value = val
        self._include_membership_present = True

    @include_membership.deleter
    def include_membership(self):
        self._include_membership_value = None
        self._include_membership_present = False

    def __repr__(self):
        return 'GetSharedFolderArgs(id={!r}, include_membership={!r})'.format(
            self._id_value,
            self._include_membership_value,
        )

class ListSharedFoldersArgs(object):
    """
    Arguments for list_shared_folders.

    :ivar include_membership: If include user and group membership information
        in the response.
    """

    __slots__ = [
        '_include_membership_value',
        '_include_membership_present',
    ]

    def __init__(self,
                 include_membership=None):
        self._include_membership_value = None
        self._include_membership_present = False
        if include_membership is not None:
            self.include_membership = include_membership

    @property
    def include_membership(self):
        """
        If include user and group membership information in the response.

        :rtype: bool
        """
        if self._include_membership_present:
            return self._include_membership_value
        else:
            return False

    @include_membership.setter
    def include_membership(self, val):
        val = self._include_membership_validator.validate(val)
        self._include_membership_value = val
        self._include_membership_present = True

    @include_membership.deleter
    def include_membership(self):
        self._include_membership_value = None
        self._include_membership_present = False

    def __repr__(self):
        return 'ListSharedFoldersArgs(include_membership={!r})'.format(
            self._include_membership_value,
        )

class ListSharedFoldersResult(object):
    """
    Result for list_shared_folders.

    :ivar entries: List of all shared folders the authenticated user has access
        to.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
    ]

    def __init__(self,
                 entries=None):
        self._entries_value = None
        self._entries_present = False
        if entries is not None:
            self.entries = entries

    @property
    def entries(self):
        """
        List of all shared folders the authenticated user has access to.

        :rtype: list of [SharedFolderMetadata]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'ListSharedFoldersResult(entries={!r})'.format(
            self._entries_value,
        )

Visibility._public_validator = bv.Void()
Visibility._team_only_validator = bv.Void()
Visibility._password_validator = bv.Void()
Visibility._team_and_password_validator = bv.Void()
Visibility._shared_folder_only_validator = bv.Void()
Visibility._other_validator = bv.Void()
Visibility._tagmap = {
    'public': Visibility._public_validator,
    'team_only': Visibility._team_only_validator,
    'password': Visibility._password_validator,
    'team_and_password': Visibility._team_and_password_validator,
    'shared_folder_only': Visibility._shared_folder_only_validator,
    'other': Visibility._other_validator,
}

Visibility.public = Visibility('public')
Visibility.team_only = Visibility('team_only')
Visibility.password = Visibility('password')
Visibility.team_and_password = Visibility('team_and_password')
Visibility.shared_folder_only = Visibility('shared_folder_only')
Visibility.other = Visibility('other')

LinkMetadata._url_validator = bv.String()
LinkMetadata._visibility_validator = bv.Union(Visibility)
LinkMetadata._expires_validator = bv.Nullable(bv.Timestamp(u'%Y-%m-%dT%H:%M:%SZ'))
LinkMetadata._field_names_ = set([
    'url',
    'visibility',
    'expires',
])
LinkMetadata._all_field_names_ = LinkMetadata._field_names_
LinkMetadata._fields_ = [
    ('url', LinkMetadata._url_validator),
    ('visibility', LinkMetadata._visibility_validator),
    ('expires', LinkMetadata._expires_validator),
]
LinkMetadata._all_fields_ = LinkMetadata._fields_

LinkMetadata._tag_to_subtype_ = {
    (u'path',): bv.Struct(PathLinkMetadata),
    (u'collection',): bv.Struct(CollectionLinkMetadata),
}
LinkMetadata._pytype_to_tag_and_subtype_ = {
    PathLinkMetadata: ((u'path',), bv.Struct(PathLinkMetadata)),
    CollectionLinkMetadata: ((u'collection',), bv.Struct(CollectionLinkMetadata)),
}
LinkMetadata._is_catch_all_ = True

PathLinkMetadata._path_validator = bv.String()
PathLinkMetadata._field_names_ = set(['path'])
PathLinkMetadata._all_field_names_ = LinkMetadata._all_field_names_.union(PathLinkMetadata._field_names_)
PathLinkMetadata._fields_ = [('path', PathLinkMetadata._path_validator)]
PathLinkMetadata._all_fields_ = LinkMetadata._all_fields_ + PathLinkMetadata._fields_

CollectionLinkMetadata._field_names_ = set([])
CollectionLinkMetadata._all_field_names_ = LinkMetadata._all_field_names_.union(CollectionLinkMetadata._field_names_)
CollectionLinkMetadata._fields_ = []
CollectionLinkMetadata._all_fields_ = LinkMetadata._all_fields_ + CollectionLinkMetadata._fields_

GetSharedLinksArg._path_validator = bv.Nullable(bv.String())
GetSharedLinksArg._all_field_names_ = set(['path'])
GetSharedLinksArg._all_fields_ = [('path', GetSharedLinksArg._path_validator)]

GetSharedLinksResult._links_validator = bv.List(bv.StructTree(LinkMetadata))
GetSharedLinksResult._all_field_names_ = set(['links'])
GetSharedLinksResult._all_fields_ = [('links', GetSharedLinksResult._links_validator)]

GetSharedLinksError._path_validator = bv.Nullable(bv.String())
GetSharedLinksError._other_validator = bv.Void()
GetSharedLinksError._tagmap = {
    'path': GetSharedLinksError._path_validator,
    'other': GetSharedLinksError._other_validator,
}

GetSharedLinksError.other = GetSharedLinksError('other')

PendingUploadMode._file_validator = bv.Void()
PendingUploadMode._folder_validator = bv.Void()
PendingUploadMode._tagmap = {
    'file': PendingUploadMode._file_validator,
    'folder': PendingUploadMode._folder_validator,
}

PendingUploadMode.file = PendingUploadMode('file')
PendingUploadMode.folder = PendingUploadMode('folder')

CreateSharedLinkArg._path_validator = bv.String()
CreateSharedLinkArg._short_url_validator = bv.Boolean()
CreateSharedLinkArg._pending_upload_validator = bv.Nullable(bv.Union(PendingUploadMode))
CreateSharedLinkArg._all_field_names_ = set([
    'path',
    'short_url',
    'pending_upload',
])
CreateSharedLinkArg._all_fields_ = [
    ('path', CreateSharedLinkArg._path_validator),
    ('short_url', CreateSharedLinkArg._short_url_validator),
    ('pending_upload', CreateSharedLinkArg._pending_upload_validator),
]

CreateSharedLinkError._path_validator = bv.Union(files.LookupError)
CreateSharedLinkError._other_validator = bv.Void()
CreateSharedLinkError._tagmap = {
    'path': CreateSharedLinkError._path_validator,
    'other': CreateSharedLinkError._other_validator,
}

CreateSharedLinkError.other = CreateSharedLinkError('other')

AccessType._owner_validator = bv.Void()
AccessType._editor_validator = bv.Void()
AccessType._viewer_validator = bv.Void()
AccessType._other_validator = bv.Void()
AccessType._tagmap = {
    'owner': AccessType._owner_validator,
    'editor': AccessType._editor_validator,
    'viewer': AccessType._viewer_validator,
    'other': AccessType._other_validator,
}

AccessType.owner = AccessType('owner')
AccessType.editor = AccessType('editor')
AccessType.viewer = AccessType('viewer')
AccessType.other = AccessType('other')

SharedLinkPolicy._all_validator = bv.Void()
SharedLinkPolicy._members_only_validator = bv.Void()
SharedLinkPolicy._other_validator = bv.Void()
SharedLinkPolicy._tagmap = {
    'all': SharedLinkPolicy._all_validator,
    'members_only': SharedLinkPolicy._members_only_validator,
    'other': SharedLinkPolicy._other_validator,
}

SharedLinkPolicy.all = SharedLinkPolicy('all')
SharedLinkPolicy.members_only = SharedLinkPolicy('members_only')
SharedLinkPolicy.other = SharedLinkPolicy('other')

MembershipInfo._access_type_validator = bv.Union(AccessType)
MembershipInfo._all_field_names_ = set(['access_type'])
MembershipInfo._all_fields_ = [('access_type', MembershipInfo._access_type_validator)]

UserInfo._account_id_validator = bv.String(min_length=40, max_length=40)
UserInfo._display_name_validator = bv.String()
UserInfo._same_team_validator = bv.Boolean()
UserInfo._member_id_validator = bv.Nullable(bv.String())
UserInfo._all_field_names_ = set([
    'account_id',
    'display_name',
    'same_team',
    'member_id',
])
UserInfo._all_fields_ = [
    ('account_id', UserInfo._account_id_validator),
    ('display_name', UserInfo._display_name_validator),
    ('same_team', UserInfo._same_team_validator),
    ('member_id', UserInfo._member_id_validator),
]

UserMembershipInfo._user_validator = bv.Struct(UserInfo)
UserMembershipInfo._active_validator = bv.Boolean()
UserMembershipInfo._all_field_names_ = MembershipInfo._all_field_names_.union(set([
    'user',
    'active',
]))
UserMembershipInfo._all_fields_ = MembershipInfo._all_fields_ + [
    ('user', UserMembershipInfo._user_validator),
    ('active', UserMembershipInfo._active_validator),
]

GroupInfo._display_name_validator = bv.String()
GroupInfo._id_validator = bv.String()
GroupInfo._member_count_validator = bv.Int64()
GroupInfo._same_team_validator = bv.Boolean()
GroupInfo._all_field_names_ = set([
    'display_name',
    'id',
    'member_count',
    'same_team',
])
GroupInfo._all_fields_ = [
    ('display_name', GroupInfo._display_name_validator),
    ('id', GroupInfo._id_validator),
    ('member_count', GroupInfo._member_count_validator),
    ('same_team', GroupInfo._same_team_validator),
]

GroupMembershipInfo._group_validator = bv.Struct(GroupInfo)
GroupMembershipInfo._all_field_names_ = MembershipInfo._all_field_names_.union(set(['group']))
GroupMembershipInfo._all_fields_ = MembershipInfo._all_fields_ + [('group', GroupMembershipInfo._group_validator)]

SharedFolderMetadata._path_lower_validator = bv.String()
SharedFolderMetadata._name_validator = bv.String()
SharedFolderMetadata._id_validator = bv.String(pattern=u'[-_0-9a-zA-Z]+')
SharedFolderMetadata._access_type_validator = bv.Union(AccessType)
SharedFolderMetadata._shared_link_policy_validator = bv.Union(SharedLinkPolicy)
SharedFolderMetadata._field_names_ = set([
    'path_lower',
    'name',
    'id',
    'access_type',
    'shared_link_policy',
])
SharedFolderMetadata._all_field_names_ = SharedFolderMetadata._field_names_
SharedFolderMetadata._fields_ = [
    ('path_lower', SharedFolderMetadata._path_lower_validator),
    ('name', SharedFolderMetadata._name_validator),
    ('id', SharedFolderMetadata._id_validator),
    ('access_type', SharedFolderMetadata._access_type_validator),
    ('shared_link_policy', SharedFolderMetadata._shared_link_policy_validator),
]
SharedFolderMetadata._all_fields_ = SharedFolderMetadata._fields_

SharedFolderMetadata._tag_to_subtype_ = {
    (u'basic',): bv.Struct(BasicSharedFolderMetadata),
    (u'full',): bv.Struct(FullSharedFolderMetadata),
}
SharedFolderMetadata._pytype_to_tag_and_subtype_ = {
    BasicSharedFolderMetadata: ((u'basic',), bv.Struct(BasicSharedFolderMetadata)),
    FullSharedFolderMetadata: ((u'full',), bv.Struct(FullSharedFolderMetadata)),
}
SharedFolderMetadata._is_catch_all_ = False

BasicSharedFolderMetadata._field_names_ = set([])
BasicSharedFolderMetadata._all_field_names_ = SharedFolderMetadata._all_field_names_.union(BasicSharedFolderMetadata._field_names_)
BasicSharedFolderMetadata._fields_ = []
BasicSharedFolderMetadata._all_fields_ = SharedFolderMetadata._all_fields_ + BasicSharedFolderMetadata._fields_

FullSharedFolderMetadata._membership_validator = bv.List(bv.Struct(UserMembershipInfo))
FullSharedFolderMetadata._groups_validator = bv.List(bv.Struct(GroupMembershipInfo))
FullSharedFolderMetadata._field_names_ = set([
    'membership',
    'groups',
])
FullSharedFolderMetadata._all_field_names_ = SharedFolderMetadata._all_field_names_.union(FullSharedFolderMetadata._field_names_)
FullSharedFolderMetadata._fields_ = [
    ('membership', FullSharedFolderMetadata._membership_validator),
    ('groups', FullSharedFolderMetadata._groups_validator),
]
FullSharedFolderMetadata._all_fields_ = SharedFolderMetadata._all_fields_ + FullSharedFolderMetadata._fields_

SharedFolderAccessError._invalid_id_validator = bv.Void()
SharedFolderAccessError._not_member_validator = bv.Void()
SharedFolderAccessError._has_left_validator = bv.Void()
SharedFolderAccessError._require_owner_validator = bv.Void()
SharedFolderAccessError._is_root_validator = bv.Void()
SharedFolderAccessError._is_team_shared_folder_validator = bv.Void()
SharedFolderAccessError._is_app_folder_validator = bv.Void()
SharedFolderAccessError._tagmap = {
    'invalid_id': SharedFolderAccessError._invalid_id_validator,
    'not_member': SharedFolderAccessError._not_member_validator,
    'has_left': SharedFolderAccessError._has_left_validator,
    'require_owner': SharedFolderAccessError._require_owner_validator,
    'is_root': SharedFolderAccessError._is_root_validator,
    'is_team_shared_folder': SharedFolderAccessError._is_team_shared_folder_validator,
    'is_app_folder': SharedFolderAccessError._is_app_folder_validator,
}

SharedFolderAccessError.invalid_id = SharedFolderAccessError('invalid_id')
SharedFolderAccessError.not_member = SharedFolderAccessError('not_member')
SharedFolderAccessError.has_left = SharedFolderAccessError('has_left')
SharedFolderAccessError.require_owner = SharedFolderAccessError('require_owner')
SharedFolderAccessError.is_root = SharedFolderAccessError('is_root')
SharedFolderAccessError.is_team_shared_folder = SharedFolderAccessError('is_team_shared_folder')
SharedFolderAccessError.is_app_folder = SharedFolderAccessError('is_app_folder')

GetSharedFolderArgs._id_validator = bv.String(pattern=u'[-_0-9a-zA-Z]+')
GetSharedFolderArgs._include_membership_validator = bv.Boolean()
GetSharedFolderArgs._all_field_names_ = set([
    'id',
    'include_membership',
])
GetSharedFolderArgs._all_fields_ = [
    ('id', GetSharedFolderArgs._id_validator),
    ('include_membership', GetSharedFolderArgs._include_membership_validator),
]

ListSharedFoldersArgs._include_membership_validator = bv.Boolean()
ListSharedFoldersArgs._all_field_names_ = set(['include_membership'])
ListSharedFoldersArgs._all_fields_ = [('include_membership', ListSharedFoldersArgs._include_membership_validator)]

ListSharedFoldersResult._entries_validator = bv.List(bv.StructTree(SharedFolderMetadata))
ListSharedFoldersResult._all_field_names_ = set(['entries'])
ListSharedFoldersResult._all_fields_ = [('entries', ListSharedFoldersResult._entries_validator)]

