/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu Dec 10 07:06:49 EST 2020 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2cdft.native -fma -compact -variables 4 -pipeline-latency 4 -sign 1 -n 32 -dif -name hc2cbdft_32 -include rdft/scalar/hc2cb.h */

/*
 * This function contains 498 FP additions, 260 FP multiplications,
 * (or, 300 additions, 62 multiplications, 198 fused multiply/add),
 * 122 stack variables, 7 constants, and 128 memory accesses
 */
#include "rdft/scalar/hc2cb.h"

static void hc2cbdft_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 62, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E T3h, T4B, Tv, T3K, T6T, T8Y, T7i, T8L, T7f, T8X, T1G, T4Y, T1j, T4K, T2M;
	       E T4X, T6d, T8C, T66, T8o, T6M, T8K, T2P, T4L, T3o, T4C, T4q, T5q, T6C, T8p;
	       E T6z, T8B, TK, TZ, T10, T32, T39, T3L, T4t, T4E, T8t, T8F, T4w, T4F, T8w;
	       E T8E, T6l, T6E, T6s, T6F, T28, T51, T2R, T4P, T71, T90, T7k, T8P, T2z, T50;
	       E T2S, T4S, T78, T91, T7l, T8S;
	       {
		    E T16, T3l, T2H, T3m, T3, T6, T7, T2E, T13, Ta, Td, Te, T1c, T3j, T3i;
		    E T2J, T1h, T2K, Tt, T6Q, T6R, T1z, T1E, T6a, T6b, T3g, Tm, T6N, T6O, T1o;
		    E T1t, T67, T68, T3d, T4o, T4p;
		    {
			 E T14, T15, T2F, T2G;
			 T14 = Ip[0];
			 T15 = Im[WS(rs, 15)];
			 T16 = T14 + T15;
			 T3l = T14 - T15;
			 T2F = Ip[WS(rs, 8)];
			 T2G = Im[WS(rs, 7)];
			 T2H = T2F + T2G;
			 T3m = T2F - T2G;
			 {
			      E T1, T2, T4, T5;
			      T1 = Rp[0];
			      T2 = Rm[WS(rs, 15)];
			      T3 = T1 + T2;
			      T4 = Rp[WS(rs, 8)];
			      T5 = Rm[WS(rs, 7)];
			      T6 = T4 + T5;
			      T7 = T3 + T6;
			      T2E = T1 - T2;
			      T13 = T4 - T5;
			 }
		    }
		    {
			 E T19, T1a, T1b, T18, T1e, T1f, T1g, T1d;
			 {
			      E T8, T9, Tb, Tc;
			      T19 = Ip[WS(rs, 4)];
			      T1a = Im[WS(rs, 11)];
			      T1b = T19 + T1a;
			      T8 = Rp[WS(rs, 4)];
			      T9 = Rm[WS(rs, 11)];
			      Ta = T8 + T9;
			      T18 = T8 - T9;
			      T1e = Im[WS(rs, 3)];
			      T1f = Ip[WS(rs, 12)];
			      T1g = T1e + T1f;
			      Tb = Rm[WS(rs, 3)];
			      Tc = Rp[WS(rs, 12)];
			      Td = Tb + Tc;
			      T1d = Tb - Tc;
			 }
			 Te = Ta + Td;
			 T1c = T18 + T1b;
			 T3j = T1f - T1e;
			 T3i = T19 - T1a;
			 T2J = T18 - T1b;
			 T1h = T1d + T1g;
			 T2K = T1d - T1g;
		    }
		    {
			 E Tp, T1A, T1y, T3e, Ts, T1v, T1D, T3f;
			 {
			      E Tn, To, T1w, T1x;
			      Tn = Rm[WS(rs, 1)];
			      To = Rp[WS(rs, 14)];
			      Tp = Tn + To;
			      T1A = Tn - To;
			      T1w = Im[WS(rs, 1)];
			      T1x = Ip[WS(rs, 14)];
			      T1y = T1w + T1x;
			      T3e = T1x - T1w;
			 }
			 {
			      E Tq, Tr, T1B, T1C;
			      Tq = Rp[WS(rs, 6)];
			      Tr = Rm[WS(rs, 9)];
			      Ts = Tq + Tr;
			      T1v = Tq - Tr;
			      T1B = Ip[WS(rs, 6)];
			      T1C = Im[WS(rs, 9)];
			      T1D = T1B + T1C;
			      T3f = T1B - T1C;
			 }
			 Tt = Tp + Ts;
			 T6Q = T1A + T1D;
			 T6R = T1v + T1y;
			 T1z = T1v - T1y;
			 T1E = T1A - T1D;
			 T6a = Tp - Ts;
			 T6b = T3e - T3f;
			 T3g = T3e + T3f;
		    }
		    {
			 E Ti, T1p, T1n, T3b, Tl, T1k, T1s, T3c;
			 {
			      E Tg, Th, T1l, T1m;
			      Tg = Rp[WS(rs, 2)];
			      Th = Rm[WS(rs, 13)];
			      Ti = Tg + Th;
			      T1p = Tg - Th;
			      T1l = Ip[WS(rs, 2)];
			      T1m = Im[WS(rs, 13)];
			      T1n = T1l + T1m;
			      T3b = T1l - T1m;
			 }
			 {
			      E Tj, Tk, T1q, T1r;
			      Tj = Rp[WS(rs, 10)];
			      Tk = Rm[WS(rs, 5)];
			      Tl = Tj + Tk;
			      T1k = Tj - Tk;
			      T1q = Ip[WS(rs, 10)];
			      T1r = Im[WS(rs, 5)];
			      T1s = T1q + T1r;
			      T3c = T1q - T1r;
			 }
			 Tm = Ti + Tl;
			 T6N = T1p + T1s;
			 T6O = T1n - T1k;
			 T1o = T1k + T1n;
			 T1t = T1p - T1s;
			 T67 = Ti - Tl;
			 T68 = T3b - T3c;
			 T3d = T3b + T3c;
		    }
		    T3h = T3d + T3g;
		    T4B = Tm - Tt;
		    {
			 E Tf, Tu, T6P, T6S;
			 Tf = T7 + Te;
			 Tu = Tm + Tt;
			 Tv = Tf + Tu;
			 T3K = Tf - Tu;
			 T6P = FMA(KP414213562, T6O, T6N);
			 T6S = FMA(KP414213562, T6R, T6Q);
			 T6T = T6P - T6S;
			 T8Y = T6P + T6S;
		    }
		    {
			 E T7g, T7h, T7d, T7e;
			 T7g = FNMS(KP414213562, T6N, T6O);
			 T7h = FNMS(KP414213562, T6Q, T6R);
			 T7i = T7g + T7h;
			 T8L = T7h - T7g;
			 T7d = T2E + T2H;
			 T7e = T1c + T1h;
			 T7f = FNMS(KP707106781, T7e, T7d);
			 T8X = FMA(KP707106781, T7e, T7d);
		    }
		    {
			 E T1u, T1F, T17, T1i;
			 T1u = FMA(KP414213562, T1t, T1o);
			 T1F = FNMS(KP414213562, T1E, T1z);
			 T1G = T1u + T1F;
			 T4Y = T1F - T1u;
			 T17 = T13 + T16;
			 T1i = T1c - T1h;
			 T1j = FMA(KP707106781, T1i, T17);
			 T4K = FNMS(KP707106781, T1i, T17);
		    }
		    {
			 E T2I, T2L, T69, T6c;
			 T2I = T2E - T2H;
			 T2L = T2J + T2K;
			 T2M = FMA(KP707106781, T2L, T2I);
			 T4X = FNMS(KP707106781, T2L, T2I);
			 T69 = T67 - T68;
			 T6c = T6a + T6b;
			 T6d = T69 + T6c;
			 T8C = T69 - T6c;
		    }
		    {
			 E T64, T65, T6K, T6L;
			 T64 = T3 - T6;
			 T65 = T3j - T3i;
			 T66 = T64 + T65;
			 T8o = T64 - T65;
			 T6K = T16 - T13;
			 T6L = T2J - T2K;
			 T6M = FMA(KP707106781, T6L, T6K);
			 T8K = FNMS(KP707106781, T6L, T6K);
		    }
		    {
			 E T2N, T2O, T3k, T3n;
			 T2N = FNMS(KP414213562, T1o, T1t);
			 T2O = FMA(KP414213562, T1z, T1E);
			 T2P = T2N + T2O;
			 T4L = T2N - T2O;
			 T3k = T3i + T3j;
			 T3n = T3l + T3m;
			 T3o = T3k + T3n;
			 T4C = T3n - T3k;
		    }
		    T4o = T7 - Te;
		    T4p = T3g - T3d;
		    T4q = T4o + T4p;
		    T5q = T4o - T4p;
		    {
			 E T6A, T6B, T6x, T6y;
			 T6A = T67 + T68;
			 T6B = T6b - T6a;
			 T6C = T6A + T6B;
			 T8p = T6B - T6A;
			 T6x = Ta - Td;
			 T6y = T3l - T3m;
			 T6z = T6x + T6y;
			 T8B = T6y - T6x;
		    }
	       }
	       {
		    E TC, T6V, T6Y, T1M, T23, T6f, T6j, T31, TY, T6n, T6p, T2i, T2n, T2w, T35;
		    E T2v, TJ, T6g, T6i, T1R, T1W, T25, T2Y, T24, TR, T72, T75, T2d, T2u, T6m;
		    E T6q, T38;
		    {
			 E Ty, T1Z, T1L, T2Z, TB, T1I, T22, T30;
			 {
			      E Tw, Tx, T1J, T1K;
			      Tw = Rp[WS(rs, 1)];
			      Tx = Rm[WS(rs, 14)];
			      Ty = Tw + Tx;
			      T1Z = Tw - Tx;
			      T1J = Ip[WS(rs, 1)];
			      T1K = Im[WS(rs, 14)];
			      T1L = T1J + T1K;
			      T2Z = T1J - T1K;
			 }
			 {
			      E Tz, TA, T20, T21;
			      Tz = Rp[WS(rs, 9)];
			      TA = Rm[WS(rs, 6)];
			      TB = Tz + TA;
			      T1I = Tz - TA;
			      T20 = Ip[WS(rs, 9)];
			      T21 = Im[WS(rs, 6)];
			      T22 = T20 + T21;
			      T30 = T20 - T21;
			 }
			 TC = Ty + TB;
			 T6V = T1L - T1I;
			 T6Y = T1Z + T22;
			 T1M = T1I + T1L;
			 T23 = T1Z - T22;
			 T6f = Ty - TB;
			 T6j = T2Z - T30;
			 T31 = T2Z + T30;
		    }
		    {
			 E TU, T2e, T2h, T33, TX, T2j, T2m, T34;
			 {
			      E TS, TT, T2f, T2g;
			      TS = Rp[WS(rs, 3)];
			      TT = Rm[WS(rs, 12)];
			      TU = TS + TT;
			      T2e = TS - TT;
			      T2f = Ip[WS(rs, 3)];
			      T2g = Im[WS(rs, 12)];
			      T2h = T2f + T2g;
			      T33 = T2f - T2g;
			 }
			 {
			      E TV, TW, T2k, T2l;
			      TV = Rm[WS(rs, 4)];
			      TW = Rp[WS(rs, 11)];
			      TX = TV + TW;
			      T2j = TV - TW;
			      T2k = Im[WS(rs, 4)];
			      T2l = Ip[WS(rs, 11)];
			      T2m = T2k + T2l;
			      T34 = T2l - T2k;
			 }
			 TY = TU + TX;
			 T6n = T34 - T33;
			 T6p = TU - TX;
			 T2i = T2e + T2h;
			 T2n = T2j + T2m;
			 T2w = T2j - T2m;
			 T35 = T33 + T34;
			 T2v = T2e - T2h;
		    }
		    {
			 E TF, T1N, T1Q, T2W, TI, T1S, T1V, T2X;
			 {
			      E TD, TE, T1O, T1P;
			      TD = Rp[WS(rs, 5)];
			      TE = Rm[WS(rs, 10)];
			      TF = TD + TE;
			      T1N = TD - TE;
			      T1O = Ip[WS(rs, 5)];
			      T1P = Im[WS(rs, 10)];
			      T1Q = T1O + T1P;
			      T2W = T1O - T1P;
			 }
			 {
			      E TG, TH, T1T, T1U;
			      TG = Rm[WS(rs, 2)];
			      TH = Rp[WS(rs, 13)];
			      TI = TG + TH;
			      T1S = TG - TH;
			      T1T = Im[WS(rs, 2)];
			      T1U = Ip[WS(rs, 13)];
			      T1V = T1T + T1U;
			      T2X = T1U - T1T;
			 }
			 TJ = TF + TI;
			 T6g = T2X - T2W;
			 T6i = TF - TI;
			 T1R = T1N + T1Q;
			 T1W = T1S + T1V;
			 T25 = T1S - T1V;
			 T2Y = T2W + T2X;
			 T24 = T1N - T1Q;
		    }
		    {
			 E TN, T2q, T2c, T36, TQ, T29, T2t, T37;
			 {
			      E TL, TM, T2a, T2b;
			      TL = Rm[0];
			      TM = Rp[WS(rs, 15)];
			      TN = TL + TM;
			      T2q = TL - TM;
			      T2a = Im[0];
			      T2b = Ip[WS(rs, 15)];
			      T2c = T2a + T2b;
			      T36 = T2b - T2a;
			 }
			 {
			      E TO, TP, T2r, T2s;
			      TO = Rp[WS(rs, 7)];
			      TP = Rm[WS(rs, 8)];
			      TQ = TO + TP;
			      T29 = TO - TP;
			      T2r = Ip[WS(rs, 7)];
			      T2s = Im[WS(rs, 8)];
			      T2t = T2r + T2s;
			      T37 = T2r - T2s;
			 }
			 TR = TN + TQ;
			 T72 = T29 + T2c;
			 T75 = T2q + T2t;
			 T2d = T29 - T2c;
			 T2u = T2q - T2t;
			 T6m = TN - TQ;
			 T6q = T36 - T37;
			 T38 = T36 + T37;
		    }
		    {
			 E T4r, T4s, T8r, T8s;
			 TK = TC + TJ;
			 TZ = TR + TY;
			 T10 = TK + TZ;
			 T32 = T2Y + T31;
			 T39 = T35 + T38;
			 T3L = T39 - T32;
			 T4r = TC - TJ;
			 T4s = T31 - T2Y;
			 T4t = T4r - T4s;
			 T4E = T4r + T4s;
			 T8r = T6q - T6p;
			 T8s = T6m - T6n;
			 T8t = FMA(KP414213562, T8s, T8r);
			 T8F = FNMS(KP414213562, T8r, T8s);
			 {
			      E T4u, T4v, T8u, T8v;
			      T4u = TR - TY;
			      T4v = T38 - T35;
			      T4w = T4u + T4v;
			      T4F = T4v - T4u;
			      T8u = T6j - T6i;
			      T8v = T6f - T6g;
			      T8w = FNMS(KP414213562, T8v, T8u);
			      T8E = FMA(KP414213562, T8u, T8v);
			 }
		    }
		    {
			 E T6h, T6k, T6o, T6r;
			 T6h = T6f + T6g;
			 T6k = T6i + T6j;
			 T6l = FNMS(KP414213562, T6k, T6h);
			 T6E = FMA(KP414213562, T6h, T6k);
			 T6o = T6m + T6n;
			 T6r = T6p + T6q;
			 T6s = FMA(KP414213562, T6r, T6o);
			 T6F = FNMS(KP414213562, T6o, T6r);
			 {
			      E T1Y, T4O, T27, T4N, T1X, T26;
			      T1X = T1R - T1W;
			      T1Y = FMA(KP707106781, T1X, T1M);
			      T4O = FNMS(KP707106781, T1X, T1M);
			      T26 = T24 + T25;
			      T27 = FMA(KP707106781, T26, T23);
			      T4N = FNMS(KP707106781, T26, T23);
			      T28 = FMA(KP198912367, T27, T1Y);
			      T51 = FNMS(KP668178637, T4N, T4O);
			      T2R = FNMS(KP198912367, T1Y, T27);
			      T4P = FMA(KP668178637, T4O, T4N);
			 }
		    }
		    {
			 E T6X, T8O, T70, T8N, T6W, T6Z;
			 T6W = T25 - T24;
			 T6X = FNMS(KP707106781, T6W, T6V);
			 T8O = FMA(KP707106781, T6W, T6V);
			 T6Z = T1R + T1W;
			 T70 = FNMS(KP707106781, T6Z, T6Y);
			 T8N = FMA(KP707106781, T6Z, T6Y);
			 T71 = FMA(KP668178637, T70, T6X);
			 T90 = FNMS(KP198912367, T8N, T8O);
			 T7k = FNMS(KP668178637, T6X, T70);
			 T8P = FMA(KP198912367, T8O, T8N);
		    }
		    {
			 E T2p, T4R, T2y, T4Q, T2o, T2x;
			 T2o = T2i - T2n;
			 T2p = FMA(KP707106781, T2o, T2d);
			 T4R = FNMS(KP707106781, T2o, T2d);
			 T2x = T2v + T2w;
			 T2y = FMA(KP707106781, T2x, T2u);
			 T4Q = FNMS(KP707106781, T2x, T2u);
			 T2z = FNMS(KP198912367, T2y, T2p);
			 T50 = FMA(KP668178637, T4Q, T4R);
			 T2S = FMA(KP198912367, T2p, T2y);
			 T4S = FNMS(KP668178637, T4R, T4Q);
		    }
		    {
			 E T74, T8R, T77, T8Q, T73, T76;
			 T73 = T2v - T2w;
			 T74 = FNMS(KP707106781, T73, T72);
			 T8R = FMA(KP707106781, T73, T72);
			 T76 = T2i + T2n;
			 T77 = FNMS(KP707106781, T76, T75);
			 T8Q = FMA(KP707106781, T76, T75);
			 T78 = FMA(KP668178637, T77, T74);
			 T91 = FNMS(KP198912367, T8Q, T8R);
			 T7l = FNMS(KP668178637, T74, T77);
			 T8S = FMA(KP198912367, T8R, T8Q);
		    }
	       }
	       {
		    E T11, T3q, T3x, T3t, T3v, T3w, T3F, T2B, T3A, T2U, T3D, T2C, T3r, T3B, T3H;
		    E T2V, T3s, T2D;
		    {
			 E T3a, T3p, T3u, T12, T3z;
			 T11 = Tv + T10;
			 T3a = T32 + T39;
			 T3p = T3h + T3o;
			 T3q = T3a + T3p;
			 T3x = T3p - T3a;
			 T3u = Tv - T10;
			 T3t = W[30];
			 T3v = T3t * T3u;
			 T3w = W[31];
			 T3F = T3w * T3u;
			 {
			      E T1H, T2A, T2Q, T2T;
			      T1H = FMA(KP923879532, T1G, T1j);
			      T2A = T28 + T2z;
			      T2B = FMA(KP980785280, T2A, T1H);
			      T3A = FNMS(KP980785280, T2A, T1H);
			      T2Q = FMA(KP923879532, T2P, T2M);
			      T2T = T2R + T2S;
			      T2U = FMA(KP980785280, T2T, T2Q);
			      T3D = FNMS(KP980785280, T2T, T2Q);
			 }
			 T12 = W[0];
			 T2C = T12 * T2B;
			 T3r = T12 * T2U;
			 T3z = W[32];
			 T3B = T3z * T3A;
			 T3H = T3z * T3D;
		    }
		    T2D = W[1];
		    T2V = FMA(T2D, T2U, T2C);
		    T3s = FNMS(T2D, T2B, T3r);
		    Rp[0] = T11 - T2V;
		    Ip[0] = T3q + T3s;
		    Rm[0] = T11 + T2V;
		    Im[0] = T3s - T3q;
		    {
			 E T3y, T3G, T3E, T3I, T3C;
			 T3y = FNMS(T3w, T3x, T3v);
			 T3G = FMA(T3t, T3x, T3F);
			 T3C = W[33];
			 T3E = FMA(T3C, T3D, T3B);
			 T3I = FNMS(T3C, T3A, T3H);
			 Rp[WS(rs, 8)] = T3y - T3E;
			 Ip[WS(rs, 8)] = T3G + T3I;
			 Rm[WS(rs, 8)] = T3y + T3E;
			 Im[WS(rs, 8)] = T3I - T3G;
		    }
	       }
	       {
		    E T3R, T4b, T47, T49, T4a, T4j, T3J, T3N, T3O, T43, T3W, T4e, T41, T4h, T3X;
		    E T45, T4f, T4l;
		    {
			 E T3P, T3Q, T48, T3M, T3T, T4d;
			 T3P = TK - TZ;
			 T3Q = T3o - T3h;
			 T3R = T3P + T3Q;
			 T4b = T3Q - T3P;
			 T48 = T3K - T3L;
			 T47 = W[46];
			 T49 = T47 * T48;
			 T4a = W[47];
			 T4j = T4a * T48;
			 T3M = T3K + T3L;
			 T3J = W[14];
			 T3N = T3J * T3M;
			 T3O = W[15];
			 T43 = T3O * T3M;
			 {
			      E T3U, T3V, T3Z, T40;
			      T3U = FNMS(KP923879532, T1G, T1j);
			      T3V = T2R - T2S;
			      T3W = FMA(KP980785280, T3V, T3U);
			      T4e = FNMS(KP980785280, T3V, T3U);
			      T3Z = FNMS(KP923879532, T2P, T2M);
			      T40 = T2z - T28;
			      T41 = FMA(KP980785280, T40, T3Z);
			      T4h = FNMS(KP980785280, T40, T3Z);
			 }
			 T3T = W[16];
			 T3X = T3T * T3W;
			 T45 = T3T * T41;
			 T4d = W[48];
			 T4f = T4d * T4e;
			 T4l = T4d * T4h;
		    }
		    {
			 E T3S, T44, T42, T46, T3Y;
			 T3S = FNMS(T3O, T3R, T3N);
			 T44 = FMA(T3J, T3R, T43);
			 T3Y = W[17];
			 T42 = FMA(T3Y, T41, T3X);
			 T46 = FNMS(T3Y, T3W, T45);
			 Rp[WS(rs, 4)] = T3S - T42;
			 Ip[WS(rs, 4)] = T44 + T46;
			 Rm[WS(rs, 4)] = T3S + T42;
			 Im[WS(rs, 4)] = T46 - T44;
		    }
		    {
			 E T4c, T4k, T4i, T4m, T4g;
			 T4c = FNMS(T4a, T4b, T49);
			 T4k = FMA(T47, T4b, T4j);
			 T4g = W[49];
			 T4i = FMA(T4g, T4h, T4f);
			 T4m = FNMS(T4g, T4e, T4l);
			 Rp[WS(rs, 12)] = T4c - T4i;
			 Ip[WS(rs, 12)] = T4k + T4m;
			 Rm[WS(rs, 12)] = T4c + T4i;
			 Im[WS(rs, 12)] = T4m - T4k;
		    }
	       }
	       {
		    E T4H, T5d, T4n, T4z, T4A, T55, T59, T5b, T5c, T5l, T4U, T5g, T53, T5j, T4V;
		    E T57, T5h, T5n, T4D, T4G;
		    T4D = T4B + T4C;
		    T4G = T4E + T4F;
		    T4H = FMA(KP707106781, T4G, T4D);
		    T5d = FNMS(KP707106781, T4G, T4D);
		    {
			 E T4y, T5a, T4x, T4J, T5f;
			 T4x = T4t + T4w;
			 T4y = FMA(KP707106781, T4x, T4q);
			 T5a = FNMS(KP707106781, T4x, T4q);
			 T4n = W[6];
			 T4z = T4n * T4y;
			 T4A = W[7];
			 T55 = T4A * T4y;
			 T59 = W[38];
			 T5b = T59 * T5a;
			 T5c = W[39];
			 T5l = T5c * T5a;
			 {
			      E T4M, T4T, T4Z, T52;
			      T4M = FMA(KP923879532, T4L, T4K);
			      T4T = T4P - T4S;
			      T4U = FMA(KP831469612, T4T, T4M);
			      T5g = FNMS(KP831469612, T4T, T4M);
			      T4Z = FMA(KP923879532, T4Y, T4X);
			      T52 = T50 - T51;
			      T53 = FMA(KP831469612, T52, T4Z);
			      T5j = FNMS(KP831469612, T52, T4Z);
			 }
			 T4J = W[8];
			 T4V = T4J * T4U;
			 T57 = T4J * T53;
			 T5f = W[40];
			 T5h = T5f * T5g;
			 T5n = T5f * T5j;
		    }
		    {
			 E T4I, T56, T54, T58, T4W;
			 T4I = FNMS(T4A, T4H, T4z);
			 T56 = FMA(T4n, T4H, T55);
			 T4W = W[9];
			 T54 = FMA(T4W, T53, T4V);
			 T58 = FNMS(T4W, T4U, T57);
			 Rp[WS(rs, 2)] = T4I - T54;
			 Ip[WS(rs, 2)] = T56 + T58;
			 Rm[WS(rs, 2)] = T4I + T54;
			 Im[WS(rs, 2)] = T58 - T56;
		    }
		    {
			 E T5e, T5m, T5k, T5o, T5i;
			 T5e = FNMS(T5c, T5d, T5b);
			 T5m = FMA(T59, T5d, T5l);
			 T5i = W[41];
			 T5k = FMA(T5i, T5j, T5h);
			 T5o = FNMS(T5i, T5g, T5n);
			 Rp[WS(rs, 10)] = T5e - T5k;
			 Ip[WS(rs, 10)] = T5m + T5o;
			 Rm[WS(rs, 10)] = T5e + T5k;
			 Im[WS(rs, 10)] = T5o - T5m;
		    }
	       }
	       {
		    E T5x, T5R, T5p, T5t, T5u, T5J, T5N, T5P, T5Q, T5Z, T5C, T5U, T5H, T5X, T5D;
		    E T5L, T5V, T61, T5v, T5w;
		    T5v = T4C - T4B;
		    T5w = T4t - T4w;
		    T5x = FMA(KP707106781, T5w, T5v);
		    T5R = FNMS(KP707106781, T5w, T5v);
		    {
			 E T5s, T5O, T5r, T5z, T5T;
			 T5r = T4F - T4E;
			 T5s = FMA(KP707106781, T5r, T5q);
			 T5O = FNMS(KP707106781, T5r, T5q);
			 T5p = W[22];
			 T5t = T5p * T5s;
			 T5u = W[23];
			 T5J = T5u * T5s;
			 T5N = W[54];
			 T5P = T5N * T5O;
			 T5Q = W[55];
			 T5Z = T5Q * T5O;
			 {
			      E T5A, T5B, T5F, T5G;
			      T5A = FNMS(KP923879532, T4L, T4K);
			      T5B = T51 + T50;
			      T5C = FNMS(KP831469612, T5B, T5A);
			      T5U = FMA(KP831469612, T5B, T5A);
			      T5F = FNMS(KP923879532, T4Y, T4X);
			      T5G = T4P + T4S;
			      T5H = FNMS(KP831469612, T5G, T5F);
			      T5X = FMA(KP831469612, T5G, T5F);
			 }
			 T5z = W[24];
			 T5D = T5z * T5C;
			 T5L = T5z * T5H;
			 T5T = W[56];
			 T5V = T5T * T5U;
			 T61 = T5T * T5X;
		    }
		    {
			 E T5y, T5K, T5I, T5M, T5E;
			 T5y = FNMS(T5u, T5x, T5t);
			 T5K = FMA(T5p, T5x, T5J);
			 T5E = W[25];
			 T5I = FMA(T5E, T5H, T5D);
			 T5M = FNMS(T5E, T5C, T5L);
			 Rp[WS(rs, 6)] = T5y - T5I;
			 Ip[WS(rs, 6)] = T5K + T5M;
			 Rm[WS(rs, 6)] = T5y + T5I;
			 Im[WS(rs, 6)] = T5M - T5K;
		    }
		    {
			 E T5S, T60, T5Y, T62, T5W;
			 T5S = FNMS(T5Q, T5R, T5P);
			 T60 = FMA(T5N, T5R, T5Z);
			 T5W = W[57];
			 T5Y = FMA(T5W, T5X, T5V);
			 T62 = FNMS(T5W, T5U, T61);
			 Rp[WS(rs, 14)] = T5S - T5Y;
			 Ip[WS(rs, 14)] = T60 + T62;
			 Rm[WS(rs, 14)] = T5S + T5Y;
			 Im[WS(rs, 14)] = T62 - T60;
		    }
	       }
	       {
		    E T6H, T7x, T63, T6v, T6w, T7p, T7t, T7v, T7w, T7F, T7a, T7A, T7n, T7D, T7b;
		    E T7r, T7B, T7H;
		    {
			 E T6D, T6G, T6J, T7z;
			 T6D = FMA(KP707106781, T6C, T6z);
			 T6G = T6E + T6F;
			 T6H = FMA(KP923879532, T6G, T6D);
			 T7x = FNMS(KP923879532, T6G, T6D);
			 {
			      E T6u, T7u, T6e, T6t;
			      T6e = FMA(KP707106781, T6d, T66);
			      T6t = T6l + T6s;
			      T6u = FMA(KP923879532, T6t, T6e);
			      T7u = FNMS(KP923879532, T6t, T6e);
			      T63 = W[2];
			      T6v = T63 * T6u;
			      T6w = W[3];
			      T7p = T6w * T6u;
			      T7t = W[34];
			      T7v = T7t * T7u;
			      T7w = W[35];
			      T7F = T7w * T7u;
			 }
			 {
			      E T6U, T79, T7j, T7m;
			      T6U = FMA(KP923879532, T6T, T6M);
			      T79 = T71 - T78;
			      T7a = FMA(KP831469612, T79, T6U);
			      T7A = FNMS(KP831469612, T79, T6U);
			      T7j = FNMS(KP923879532, T7i, T7f);
			      T7m = T7k + T7l;
			      T7n = FMA(KP831469612, T7m, T7j);
			      T7D = FNMS(KP831469612, T7m, T7j);
			 }
			 T6J = W[4];
			 T7b = T6J * T7a;
			 T7r = T6J * T7n;
			 T7z = W[36];
			 T7B = T7z * T7A;
			 T7H = T7z * T7D;
		    }
		    {
			 E T6I, T7q, T7o, T7s, T7c;
			 T6I = FNMS(T6w, T6H, T6v);
			 T7q = FMA(T63, T6H, T7p);
			 T7c = W[5];
			 T7o = FMA(T7c, T7n, T7b);
			 T7s = FNMS(T7c, T7a, T7r);
			 Rp[WS(rs, 1)] = T6I - T7o;
			 Ip[WS(rs, 1)] = T7q + T7s;
			 Rm[WS(rs, 1)] = T6I + T7o;
			 Im[WS(rs, 1)] = T7s - T7q;
		    }
		    {
			 E T7y, T7G, T7E, T7I, T7C;
			 T7y = FNMS(T7w, T7x, T7v);
			 T7G = FMA(T7t, T7x, T7F);
			 T7C = W[37];
			 T7E = FMA(T7C, T7D, T7B);
			 T7I = FNMS(T7C, T7A, T7H);
			 Rp[WS(rs, 9)] = T7y - T7E;
			 Ip[WS(rs, 9)] = T7G + T7I;
			 Rm[WS(rs, 9)] = T7y + T7E;
			 Im[WS(rs, 9)] = T7I - T7G;
		    }
	       }
	       {
		    E T8H, T9d, T8n, T8z, T8A, T95, T99, T9b, T9c, T9l, T8U, T9g, T93, T9j, T8V;
		    E T97, T9h, T9n;
		    {
			 E T8D, T8G, T8J, T9f;
			 T8D = FMA(KP707106781, T8C, T8B);
			 T8G = T8E - T8F;
			 T8H = FMA(KP923879532, T8G, T8D);
			 T9d = FNMS(KP923879532, T8G, T8D);
			 {
			      E T8y, T9a, T8q, T8x;
			      T8q = FMA(KP707106781, T8p, T8o);
			      T8x = T8t - T8w;
			      T8y = FMA(KP923879532, T8x, T8q);
			      T9a = FNMS(KP923879532, T8x, T8q);
			      T8n = W[10];
			      T8z = T8n * T8y;
			      T8A = W[11];
			      T95 = T8A * T8y;
			      T99 = W[42];
			      T9b = T99 * T9a;
			      T9c = W[43];
			      T9l = T9c * T9a;
			 }
			 {
			      E T8M, T8T, T8Z, T92;
			      T8M = FMA(KP923879532, T8L, T8K);
			      T8T = T8P - T8S;
			      T8U = FMA(KP980785280, T8T, T8M);
			      T9g = FNMS(KP980785280, T8T, T8M);
			      T8Z = FNMS(KP923879532, T8Y, T8X);
			      T92 = T90 + T91;
			      T93 = FNMS(KP980785280, T92, T8Z);
			      T9j = FMA(KP980785280, T92, T8Z);
			 }
			 T8J = W[12];
			 T8V = T8J * T8U;
			 T97 = T8J * T93;
			 T9f = W[44];
			 T9h = T9f * T9g;
			 T9n = T9f * T9j;
		    }
		    {
			 E T8I, T96, T94, T98, T8W;
			 T8I = FNMS(T8A, T8H, T8z);
			 T96 = FMA(T8n, T8H, T95);
			 T8W = W[13];
			 T94 = FMA(T8W, T93, T8V);
			 T98 = FNMS(T8W, T8U, T97);
			 Rp[WS(rs, 3)] = T8I - T94;
			 Ip[WS(rs, 3)] = T96 + T98;
			 Rm[WS(rs, 3)] = T8I + T94;
			 Im[WS(rs, 3)] = T98 - T96;
		    }
		    {
			 E T9e, T9m, T9k, T9o, T9i;
			 T9e = FNMS(T9c, T9d, T9b);
			 T9m = FMA(T99, T9d, T9l);
			 T9i = W[45];
			 T9k = FMA(T9i, T9j, T9h);
			 T9o = FNMS(T9i, T9g, T9n);
			 Rp[WS(rs, 11)] = T9e - T9k;
			 Ip[WS(rs, 11)] = T9m + T9o;
			 Rm[WS(rs, 11)] = T9e + T9k;
			 Im[WS(rs, 11)] = T9o - T9m;
		    }
	       }
	       {
		    E T9x, T9R, T9p, T9t, T9u, T9J, T9N, T9P, T9Q, T9Z, T9C, T9U, T9H, T9X, T9D;
		    E T9L, T9V, Ta1;
		    {
			 E T9v, T9w, T9z, T9T;
			 T9v = FNMS(KP707106781, T8C, T8B);
			 T9w = T8w + T8t;
			 T9x = FNMS(KP923879532, T9w, T9v);
			 T9R = FMA(KP923879532, T9w, T9v);
			 {
			      E T9s, T9O, T9q, T9r;
			      T9q = FNMS(KP707106781, T8p, T8o);
			      T9r = T8E + T8F;
			      T9s = FNMS(KP923879532, T9r, T9q);
			      T9O = FMA(KP923879532, T9r, T9q);
			      T9p = W[26];
			      T9t = T9p * T9s;
			      T9u = W[27];
			      T9J = T9u * T9s;
			      T9N = W[58];
			      T9P = T9N * T9O;
			      T9Q = W[59];
			      T9Z = T9Q * T9O;
			 }
			 {
			      E T9A, T9B, T9F, T9G;
			      T9A = FNMS(KP923879532, T8L, T8K);
			      T9B = T91 - T90;
			      T9C = FMA(KP980785280, T9B, T9A);
			      T9U = FNMS(KP980785280, T9B, T9A);
			      T9F = FMA(KP923879532, T8Y, T8X);
			      T9G = T8P + T8S;
			      T9H = FNMS(KP980785280, T9G, T9F);
			      T9X = FMA(KP980785280, T9G, T9F);
			 }
			 T9z = W[28];
			 T9D = T9z * T9C;
			 T9L = T9z * T9H;
			 T9T = W[60];
			 T9V = T9T * T9U;
			 Ta1 = T9T * T9X;
		    }
		    {
			 E T9y, T9K, T9I, T9M, T9E;
			 T9y = FNMS(T9u, T9x, T9t);
			 T9K = FMA(T9p, T9x, T9J);
			 T9E = W[29];
			 T9I = FMA(T9E, T9H, T9D);
			 T9M = FNMS(T9E, T9C, T9L);
			 Rp[WS(rs, 7)] = T9y - T9I;
			 Ip[WS(rs, 7)] = T9K + T9M;
			 Rm[WS(rs, 7)] = T9y + T9I;
			 Im[WS(rs, 7)] = T9M - T9K;
		    }
		    {
			 E T9S, Ta0, T9Y, Ta2, T9W;
			 T9S = FNMS(T9Q, T9R, T9P);
			 Ta0 = FMA(T9N, T9R, T9Z);
			 T9W = W[61];
			 T9Y = FMA(T9W, T9X, T9V);
			 Ta2 = FNMS(T9W, T9U, Ta1);
			 Rp[WS(rs, 15)] = T9S - T9Y;
			 Ip[WS(rs, 15)] = Ta0 + Ta2;
			 Rm[WS(rs, 15)] = T9S + T9Y;
			 Im[WS(rs, 15)] = Ta2 - Ta0;
		    }
	       }
	       {
		    E T7R, T8b, T7J, T7N, T7O, T83, T87, T89, T8a, T8j, T7W, T8e, T81, T8h, T7X;
		    E T85, T8f, T8l;
		    {
			 E T7P, T7Q, T7T, T8d;
			 T7P = FNMS(KP707106781, T6C, T6z);
			 T7Q = T6l - T6s;
			 T7R = FMA(KP923879532, T7Q, T7P);
			 T8b = FNMS(KP923879532, T7Q, T7P);
			 {
			      E T7M, T88, T7K, T7L;
			      T7K = FNMS(KP707106781, T6d, T66);
			      T7L = T6F - T6E;
			      T7M = FMA(KP923879532, T7L, T7K);
			      T88 = FNMS(KP923879532, T7L, T7K);
			      T7J = W[18];
			      T7N = T7J * T7M;
			      T7O = W[19];
			      T83 = T7O * T7M;
			      T87 = W[50];
			      T89 = T87 * T88;
			      T8a = W[51];
			      T8j = T8a * T88;
			 }
			 {
			      E T7U, T7V, T7Z, T80;
			      T7U = FNMS(KP923879532, T6T, T6M);
			      T7V = T7k - T7l;
			      T7W = FMA(KP831469612, T7V, T7U);
			      T8e = FNMS(KP831469612, T7V, T7U);
			      T7Z = FMA(KP923879532, T7i, T7f);
			      T80 = T71 + T78;
			      T81 = FNMS(KP831469612, T80, T7Z);
			      T8h = FMA(KP831469612, T80, T7Z);
			 }
			 T7T = W[20];
			 T7X = T7T * T7W;
			 T85 = T7T * T81;
			 T8d = W[52];
			 T8f = T8d * T8e;
			 T8l = T8d * T8h;
		    }
		    {
			 E T7S, T84, T82, T86, T7Y;
			 T7S = FNMS(T7O, T7R, T7N);
			 T84 = FMA(T7J, T7R, T83);
			 T7Y = W[21];
			 T82 = FMA(T7Y, T81, T7X);
			 T86 = FNMS(T7Y, T7W, T85);
			 Rp[WS(rs, 5)] = T7S - T82;
			 Ip[WS(rs, 5)] = T84 + T86;
			 Rm[WS(rs, 5)] = T7S + T82;
			 Im[WS(rs, 5)] = T86 - T84;
		    }
		    {
			 E T8c, T8k, T8i, T8m, T8g;
			 T8c = FNMS(T8a, T8b, T89);
			 T8k = FMA(T87, T8b, T8j);
			 T8g = W[53];
			 T8i = FMA(T8g, T8h, T8f);
			 T8m = FNMS(T8g, T8e, T8l);
			 Rp[WS(rs, 13)] = T8c - T8i;
			 Ip[WS(rs, 13)] = T8k + T8m;
			 Rm[WS(rs, 13)] = T8c + T8i;
			 Im[WS(rs, 13)] = T8m - T8k;
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     { TW_FULL, 1, 32 },
     { TW_NEXT, 1, 0 }
};

static const hc2c_desc desc = { 32, "hc2cbdft_32", twinstr, &GENUS, { 300, 62, 198, 0 } };

void X(codelet_hc2cbdft_32) (planner *p) {
     X(khc2c_register) (p, hc2cbdft_32, &desc, HC2C_VIA_DFT);
}
#else

/* Generated by: ../../../genfft/gen_hc2cdft.native -compact -variables 4 -pipeline-latency 4 -sign 1 -n 32 -dif -name hc2cbdft_32 -include rdft/scalar/hc2cb.h */

/*
 * This function contains 498 FP additions, 208 FP multiplications,
 * (or, 404 additions, 114 multiplications, 94 fused multiply/add),
 * 102 stack variables, 7 constants, and 128 memory accesses
 */
#include "rdft/scalar/hc2cb.h"

static void hc2cbdft_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 62, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E Tf, T4a, T6h, T7Z, T6P, T8e, T1j, T4v, T2R, T4L, T5C, T7E, T6a, T7U, T3n;
	       E T4q, TZ, T38, T2p, T4B, T7M, T7R, T2y, T4C, T5Y, T63, T6C, T86, T4i, T4n;
	       E T6z, T85, TK, T31, T1Y, T4y, T7J, T7Q, T27, T4z, T5R, T62, T6v, T83, T4f;
	       E T4m, T6s, T82, Tu, T4p, T6o, T8f, T6M, T80, T1G, T4K, T2I, T4w, T5J, T7T;
	       E T67, T7F, T3g, T4b;
	       {
		    E T3, T2M, T16, T3k, T6, T13, T2P, T3l, Td, T3i, T1h, T2K, Ta, T3h, T1c;
		    E T2J;
		    {
			 E T1, T2, T2N, T2O;
			 T1 = Rp[0];
			 T2 = Rm[WS(rs, 15)];
			 T3 = T1 + T2;
			 T2M = T1 - T2;
			 {
			      E T14, T15, T4, T5;
			      T14 = Ip[0];
			      T15 = Im[WS(rs, 15)];
			      T16 = T14 + T15;
			      T3k = T14 - T15;
			      T4 = Rp[WS(rs, 8)];
			      T5 = Rm[WS(rs, 7)];
			      T6 = T4 + T5;
			      T13 = T4 - T5;
			 }
			 T2N = Ip[WS(rs, 8)];
			 T2O = Im[WS(rs, 7)];
			 T2P = T2N + T2O;
			 T3l = T2N - T2O;
			 {
			      E Tb, Tc, T1d, T1e, T1f, T1g;
			      Tb = Rm[WS(rs, 3)];
			      Tc = Rp[WS(rs, 12)];
			      T1d = Tb - Tc;
			      T1e = Im[WS(rs, 3)];
			      T1f = Ip[WS(rs, 12)];
			      T1g = T1e + T1f;
			      Td = Tb + Tc;
			      T3i = T1f - T1e;
			      T1h = T1d + T1g;
			      T2K = T1d - T1g;
			 }
			 {
			      E T8, T9, T18, T19, T1a, T1b;
			      T8 = Rp[WS(rs, 4)];
			      T9 = Rm[WS(rs, 11)];
			      T18 = T8 - T9;
			      T19 = Ip[WS(rs, 4)];
			      T1a = Im[WS(rs, 11)];
			      T1b = T19 + T1a;
			      Ta = T8 + T9;
			      T3h = T19 - T1a;
			      T1c = T18 + T1b;
			      T2J = T18 - T1b;
			 }
		    }
		    {
			 E T7, Te, T6f, T6g;
			 T7 = T3 + T6;
			 Te = Ta + Td;
			 Tf = T7 + Te;
			 T4a = T7 - Te;
			 T6f = T16 - T13;
			 T6g = KP707106781 * (T2J - T2K);
			 T6h = T6f + T6g;
			 T7Z = T6f - T6g;
		    }
		    {
			 E T6N, T6O, T17, T1i;
			 T6N = T2M + T2P;
			 T6O = KP707106781 * (T1c + T1h);
			 T6P = T6N - T6O;
			 T8e = T6O + T6N;
			 T17 = T13 + T16;
			 T1i = KP707106781 * (T1c - T1h);
			 T1j = T17 + T1i;
			 T4v = T17 - T1i;
		    }
		    {
			 E T2L, T2Q, T5A, T5B;
			 T2L = KP707106781 * (T2J + T2K);
			 T2Q = T2M - T2P;
			 T2R = T2L + T2Q;
			 T4L = T2Q - T2L;
			 T5A = T3 - T6;
			 T5B = T3i - T3h;
			 T5C = T5A + T5B;
			 T7E = T5A - T5B;
		    }
		    {
			 E T68, T69, T3j, T3m;
			 T68 = Ta - Td;
			 T69 = T3k - T3l;
			 T6a = T68 + T69;
			 T7U = T69 - T68;
			 T3j = T3h + T3i;
			 T3m = T3k + T3l;
			 T3n = T3j + T3m;
			 T4q = T3m - T3j;
		    }
	       }
	       {
		    E TR, T5S, T29, T2t, T2c, T5W, T2w, T37, TY, T5T, T5V, T2i, T2n, T2r, T34;
		    E T2q, T6A, T6B;
		    {
			 E TL, TM, TN, TO, TP, TQ;
			 TL = Rm[0];
			 TM = Rp[WS(rs, 15)];
			 TN = TL + TM;
			 TO = Rp[WS(rs, 7)];
			 TP = Rm[WS(rs, 8)];
			 TQ = TO + TP;
			 TR = TN + TQ;
			 T5S = TN - TQ;
			 T29 = TO - TP;
			 T2t = TL - TM;
		    }
		    {
			 E T2a, T2b, T35, T2u, T2v, T36;
			 T2a = Im[0];
			 T2b = Ip[WS(rs, 15)];
			 T35 = T2b - T2a;
			 T2u = Ip[WS(rs, 7)];
			 T2v = Im[WS(rs, 8)];
			 T36 = T2u - T2v;
			 T2c = T2a + T2b;
			 T5W = T35 - T36;
			 T2w = T2u + T2v;
			 T37 = T35 + T36;
		    }
		    {
			 E TU, T2e, T2h, T32, TX, T2j, T2m, T33;
			 {
			      E TS, TT, T2f, T2g;
			      TS = Rp[WS(rs, 3)];
			      TT = Rm[WS(rs, 12)];
			      TU = TS + TT;
			      T2e = TS - TT;
			      T2f = Ip[WS(rs, 3)];
			      T2g = Im[WS(rs, 12)];
			      T2h = T2f + T2g;
			      T32 = T2f - T2g;
			 }
			 {
			      E TV, TW, T2k, T2l;
			      TV = Rm[WS(rs, 4)];
			      TW = Rp[WS(rs, 11)];
			      TX = TV + TW;
			      T2j = TV - TW;
			      T2k = Im[WS(rs, 4)];
			      T2l = Ip[WS(rs, 11)];
			      T2m = T2k + T2l;
			      T33 = T2l - T2k;
			 }
			 TY = TU + TX;
			 T5T = T33 - T32;
			 T5V = TU - TX;
			 T2i = T2e + T2h;
			 T2n = T2j + T2m;
			 T2r = T2j - T2m;
			 T34 = T32 + T33;
			 T2q = T2e - T2h;
		    }
		    TZ = TR + TY;
		    T38 = T34 + T37;
		    {
			 E T2d, T2o, T7K, T7L;
			 T2d = T29 - T2c;
			 T2o = KP707106781 * (T2i - T2n);
			 T2p = T2d + T2o;
			 T4B = T2d - T2o;
			 T7K = T5S - T5T;
			 T7L = T5W - T5V;
			 T7M = FMA(KP382683432, T7K, KP923879532 * T7L);
			 T7R = FNMS(KP923879532, T7K, KP382683432 * T7L);
		    }
		    {
			 E T2s, T2x, T5U, T5X;
			 T2s = KP707106781 * (T2q + T2r);
			 T2x = T2t - T2w;
			 T2y = T2s + T2x;
			 T4C = T2x - T2s;
			 T5U = T5S + T5T;
			 T5X = T5V + T5W;
			 T5Y = FMA(KP923879532, T5U, KP382683432 * T5X);
			 T63 = FNMS(KP382683432, T5U, KP923879532 * T5X);
		    }
		    T6A = T2t + T2w;
		    T6B = KP707106781 * (T2i + T2n);
		    T6C = T6A - T6B;
		    T86 = T6B + T6A;
		    {
			 E T4g, T4h, T6x, T6y;
			 T4g = TR - TY;
			 T4h = T37 - T34;
			 T4i = T4g + T4h;
			 T4n = T4h - T4g;
			 T6x = KP707106781 * (T2q - T2r);
			 T6y = T29 + T2c;
			 T6z = T6x - T6y;
			 T85 = T6y + T6x;
		    }
	       }
	       {
		    E TC, T5L, T1I, T22, T1L, T5P, T25, T30, TJ, T5M, T5O, T1R, T1W, T20, T2X;
		    E T1Z, T6t, T6u;
		    {
			 E Tw, Tx, Ty, Tz, TA, TB;
			 Tw = Rp[WS(rs, 1)];
			 Tx = Rm[WS(rs, 14)];
			 Ty = Tw + Tx;
			 Tz = Rp[WS(rs, 9)];
			 TA = Rm[WS(rs, 6)];
			 TB = Tz + TA;
			 TC = Ty + TB;
			 T5L = Ty - TB;
			 T1I = Tz - TA;
			 T22 = Tw - Tx;
		    }
		    {
			 E T1J, T1K, T2Y, T23, T24, T2Z;
			 T1J = Ip[WS(rs, 1)];
			 T1K = Im[WS(rs, 14)];
			 T2Y = T1J - T1K;
			 T23 = Ip[WS(rs, 9)];
			 T24 = Im[WS(rs, 6)];
			 T2Z = T23 - T24;
			 T1L = T1J + T1K;
			 T5P = T2Y - T2Z;
			 T25 = T23 + T24;
			 T30 = T2Y + T2Z;
		    }
		    {
			 E TF, T1N, T1Q, T2V, TI, T1S, T1V, T2W;
			 {
			      E TD, TE, T1O, T1P;
			      TD = Rp[WS(rs, 5)];
			      TE = Rm[WS(rs, 10)];
			      TF = TD + TE;
			      T1N = TD - TE;
			      T1O = Ip[WS(rs, 5)];
			      T1P = Im[WS(rs, 10)];
			      T1Q = T1O + T1P;
			      T2V = T1O - T1P;
			 }
			 {
			      E TG, TH, T1T, T1U;
			      TG = Rm[WS(rs, 2)];
			      TH = Rp[WS(rs, 13)];
			      TI = TG + TH;
			      T1S = TG - TH;
			      T1T = Im[WS(rs, 2)];
			      T1U = Ip[WS(rs, 13)];
			      T1V = T1T + T1U;
			      T2W = T1U - T1T;
			 }
			 TJ = TF + TI;
			 T5M = T2W - T2V;
			 T5O = TF - TI;
			 T1R = T1N + T1Q;
			 T1W = T1S + T1V;
			 T20 = T1S - T1V;
			 T2X = T2V + T2W;
			 T1Z = T1N - T1Q;
		    }
		    TK = TC + TJ;
		    T31 = T2X + T30;
		    {
			 E T1M, T1X, T7H, T7I;
			 T1M = T1I + T1L;
			 T1X = KP707106781 * (T1R - T1W);
			 T1Y = T1M + T1X;
			 T4y = T1M - T1X;
			 T7H = T5L - T5M;
			 T7I = T5P - T5O;
			 T7J = FNMS(KP923879532, T7I, KP382683432 * T7H);
			 T7Q = FMA(KP923879532, T7H, KP382683432 * T7I);
		    }
		    {
			 E T21, T26, T5N, T5Q;
			 T21 = KP707106781 * (T1Z + T20);
			 T26 = T22 - T25;
			 T27 = T21 + T26;
			 T4z = T26 - T21;
			 T5N = T5L + T5M;
			 T5Q = T5O + T5P;
			 T5R = FNMS(KP382683432, T5Q, KP923879532 * T5N);
			 T62 = FMA(KP382683432, T5N, KP923879532 * T5Q);
		    }
		    T6t = T22 + T25;
		    T6u = KP707106781 * (T1R + T1W);
		    T6v = T6t - T6u;
		    T83 = T6u + T6t;
		    {
			 E T4d, T4e, T6q, T6r;
			 T4d = TC - TJ;
			 T4e = T30 - T2X;
			 T4f = T4d - T4e;
			 T4m = T4d + T4e;
			 T6q = T1L - T1I;
			 T6r = KP707106781 * (T1Z - T20);
			 T6s = T6q + T6r;
			 T82 = T6q - T6r;
		    }
	       }
	       {
		    E Ti, T3a, Tl, T3b, T1o, T1t, T6j, T6i, T5E, T5D, Tp, T3d, Ts, T3e, T1z;
		    E T1E, T6m, T6l, T5H, T5G;
		    {
			 E T1p, T1n, T1k, T1s;
			 {
			      E Tg, Th, T1l, T1m;
			      Tg = Rp[WS(rs, 2)];
			      Th = Rm[WS(rs, 13)];
			      Ti = Tg + Th;
			      T1p = Tg - Th;
			      T1l = Ip[WS(rs, 2)];
			      T1m = Im[WS(rs, 13)];
			      T1n = T1l + T1m;
			      T3a = T1l - T1m;
			 }
			 {
			      E Tj, Tk, T1q, T1r;
			      Tj = Rp[WS(rs, 10)];
			      Tk = Rm[WS(rs, 5)];
			      Tl = Tj + Tk;
			      T1k = Tj - Tk;
			      T1q = Ip[WS(rs, 10)];
			      T1r = Im[WS(rs, 5)];
			      T1s = T1q + T1r;
			      T3b = T1q - T1r;
			 }
			 T1o = T1k + T1n;
			 T1t = T1p - T1s;
			 T6j = T1p + T1s;
			 T6i = T1n - T1k;
			 T5E = T3a - T3b;
			 T5D = Ti - Tl;
		    }
		    {
			 E T1A, T1y, T1v, T1D;
			 {
			      E Tn, To, T1w, T1x;
			      Tn = Rm[WS(rs, 1)];
			      To = Rp[WS(rs, 14)];
			      Tp = Tn + To;
			      T1A = Tn - To;
			      T1w = Im[WS(rs, 1)];
			      T1x = Ip[WS(rs, 14)];
			      T1y = T1w + T1x;
			      T3d = T1x - T1w;
			 }
			 {
			      E Tq, Tr, T1B, T1C;
			      Tq = Rp[WS(rs, 6)];
			      Tr = Rm[WS(rs, 9)];
			      Ts = Tq + Tr;
			      T1v = Tq - Tr;
			      T1B = Ip[WS(rs, 6)];
			      T1C = Im[WS(rs, 9)];
			      T1D = T1B + T1C;
			      T3e = T1B - T1C;
			 }
			 T1z = T1v - T1y;
			 T1E = T1A - T1D;
			 T6m = T1A + T1D;
			 T6l = T1v + T1y;
			 T5H = T3d - T3e;
			 T5G = Tp - Ts;
		    }
		    {
			 E Tm, Tt, T6k, T6n;
			 Tm = Ti + Tl;
			 Tt = Tp + Ts;
			 Tu = Tm + Tt;
			 T4p = Tm - Tt;
			 T6k = FMA(KP382683432, T6i, KP923879532 * T6j);
			 T6n = FMA(KP382683432, T6l, KP923879532 * T6m);
			 T6o = T6k - T6n;
			 T8f = T6k + T6n;
		    }
		    {
			 E T6K, T6L, T1u, T1F;
			 T6K = FNMS(KP923879532, T6i, KP382683432 * T6j);
			 T6L = FNMS(KP923879532, T6l, KP382683432 * T6m);
			 T6M = T6K + T6L;
			 T80 = T6K - T6L;
			 T1u = FMA(KP923879532, T1o, KP382683432 * T1t);
			 T1F = FNMS(KP382683432, T1E, KP923879532 * T1z);
			 T1G = T1u + T1F;
			 T4K = T1F - T1u;
		    }
		    {
			 E T2G, T2H, T5F, T5I;
			 T2G = FNMS(KP382683432, T1o, KP923879532 * T1t);
			 T2H = FMA(KP382683432, T1z, KP923879532 * T1E);
			 T2I = T2G + T2H;
			 T4w = T2G - T2H;
			 T5F = T5D - T5E;
			 T5I = T5G + T5H;
			 T5J = KP707106781 * (T5F + T5I);
			 T7T = KP707106781 * (T5F - T5I);
		    }
		    {
			 E T65, T66, T3c, T3f;
			 T65 = T5D + T5E;
			 T66 = T5H - T5G;
			 T67 = KP707106781 * (T65 + T66);
			 T7F = KP707106781 * (T66 - T65);
			 T3c = T3a + T3b;
			 T3f = T3d + T3e;
			 T3g = T3c + T3f;
			 T4b = T3f - T3c;
		    }
	       }
	       {
		    E T11, T3s, T3p, T3u, T3K, T40, T3G, T3Y, T2T, T43, T3z, T3P, T2B, T45, T3x;
		    E T3T;
		    {
			 E Tv, T10, T3E, T3F;
			 Tv = Tf + Tu;
			 T10 = TK + TZ;
			 T11 = Tv + T10;
			 T3s = Tv - T10;
			 {
			      E T39, T3o, T3I, T3J;
			      T39 = T31 + T38;
			      T3o = T3g + T3n;
			      T3p = T39 + T3o;
			      T3u = T3o - T39;
			      T3I = TK - TZ;
			      T3J = T3n - T3g;
			      T3K = T3I + T3J;
			      T40 = T3J - T3I;
			 }
			 T3E = Tf - Tu;
			 T3F = T38 - T31;
			 T3G = T3E + T3F;
			 T3Y = T3E - T3F;
			 {
			      E T2S, T3N, T2F, T3O, T2D, T2E;
			      T2S = T2I + T2R;
			      T3N = T1j - T1G;
			      T2D = FNMS(KP195090322, T1Y, KP980785280 * T27);
			      T2E = FMA(KP195090322, T2p, KP980785280 * T2y);
			      T2F = T2D + T2E;
			      T3O = T2D - T2E;
			      T2T = T2F + T2S;
			      T43 = T3N - T3O;
			      T3z = T2S - T2F;
			      T3P = T3N + T3O;
			 }
			 {
			      E T1H, T3S, T2A, T3R, T28, T2z;
			      T1H = T1j + T1G;
			      T3S = T2R - T2I;
			      T28 = FMA(KP980785280, T1Y, KP195090322 * T27);
			      T2z = FNMS(KP195090322, T2y, KP980785280 * T2p);
			      T2A = T28 + T2z;
			      T3R = T2z - T28;
			      T2B = T1H + T2A;
			      T45 = T3S - T3R;
			      T3x = T1H - T2A;
			      T3T = T3R + T3S;
			 }
		    }
		    {
			 E T2U, T3q, T12, T2C;
			 T12 = W[0];
			 T2C = W[1];
			 T2U = FMA(T12, T2B, T2C * T2T);
			 T3q = FNMS(T2C, T2B, T12 * T2T);
			 Rp[0] = T11 - T2U;
			 Ip[0] = T3p + T3q;
			 Rm[0] = T11 + T2U;
			 Im[0] = T3q - T3p;
		    }
		    {
			 E T41, T47, T46, T48;
			 {
			      E T3X, T3Z, T42, T44;
			      T3X = W[46];
			      T3Z = W[47];
			      T41 = FNMS(T3Z, T40, T3X * T3Y);
			      T47 = FMA(T3Z, T3Y, T3X * T40);
			      T42 = W[48];
			      T44 = W[49];
			      T46 = FMA(T42, T43, T44 * T45);
			      T48 = FNMS(T44, T43, T42 * T45);
			 }
			 Rp[WS(rs, 12)] = T41 - T46;
			 Ip[WS(rs, 12)] = T47 + T48;
			 Rm[WS(rs, 12)] = T41 + T46;
			 Im[WS(rs, 12)] = T48 - T47;
		    }
		    {
			 E T3v, T3B, T3A, T3C;
			 {
			      E T3r, T3t, T3w, T3y;
			      T3r = W[30];
			      T3t = W[31];
			      T3v = FNMS(T3t, T3u, T3r * T3s);
			      T3B = FMA(T3t, T3s, T3r * T3u);
			      T3w = W[32];
			      T3y = W[33];
			      T3A = FMA(T3w, T3x, T3y * T3z);
			      T3C = FNMS(T3y, T3x, T3w * T3z);
			 }
			 Rp[WS(rs, 8)] = T3v - T3A;
			 Ip[WS(rs, 8)] = T3B + T3C;
			 Rm[WS(rs, 8)] = T3v + T3A;
			 Im[WS(rs, 8)] = T3C - T3B;
		    }
		    {
			 E T3L, T3V, T3U, T3W;
			 {
			      E T3D, T3H, T3M, T3Q;
			      T3D = W[14];
			      T3H = W[15];
			      T3L = FNMS(T3H, T3K, T3D * T3G);
			      T3V = FMA(T3H, T3G, T3D * T3K);
			      T3M = W[16];
			      T3Q = W[17];
			      T3U = FMA(T3M, T3P, T3Q * T3T);
			      T3W = FNMS(T3Q, T3P, T3M * T3T);
			 }
			 Rp[WS(rs, 4)] = T3L - T3U;
			 Ip[WS(rs, 4)] = T3V + T3W;
			 Rm[WS(rs, 4)] = T3L + T3U;
			 Im[WS(rs, 4)] = T3W - T3V;
		    }
	       }
	       {
		    E T7O, T8m, T7W, T8o, T8E, T8U, T8A, T8S, T8h, T8X, T8t, T8J, T89, T8Z, T8r;
		    E T8N;
		    {
			 E T7G, T7N, T8y, T8z;
			 T7G = T7E + T7F;
			 T7N = T7J + T7M;
			 T7O = T7G + T7N;
			 T8m = T7G - T7N;
			 {
			      E T7S, T7V, T8C, T8D;
			      T7S = T7Q + T7R;
			      T7V = T7T + T7U;
			      T7W = T7S + T7V;
			      T8o = T7V - T7S;
			      T8C = T7J - T7M;
			      T8D = T7U - T7T;
			      T8E = T8C + T8D;
			      T8U = T8D - T8C;
			 }
			 T8y = T7E - T7F;
			 T8z = T7R - T7Q;
			 T8A = T8y + T8z;
			 T8S = T8y - T8z;
			 {
			      E T8g, T8H, T8d, T8I, T8b, T8c;
			      T8g = T8e - T8f;
			      T8H = T7Z - T80;
			      T8b = FNMS(KP980785280, T82, KP195090322 * T83);
			      T8c = FNMS(KP980785280, T85, KP195090322 * T86);
			      T8d = T8b + T8c;
			      T8I = T8b - T8c;
			      T8h = T8d + T8g;
			      T8X = T8H - T8I;
			      T8t = T8g - T8d;
			      T8J = T8H + T8I;
			 }
			 {
			      E T81, T8L, T88, T8M, T84, T87;
			      T81 = T7Z + T80;
			      T8L = T8f + T8e;
			      T84 = FMA(KP195090322, T82, KP980785280 * T83);
			      T87 = FMA(KP195090322, T85, KP980785280 * T86);
			      T88 = T84 - T87;
			      T8M = T84 + T87;
			      T89 = T81 + T88;
			      T8Z = T8M + T8L;
			      T8r = T81 - T88;
			      T8N = T8L - T8M;
			 }
		    }
		    {
			 E T7X, T8j, T8i, T8k;
			 {
			      E T7D, T7P, T7Y, T8a;
			      T7D = W[10];
			      T7P = W[11];
			      T7X = FNMS(T7P, T7W, T7D * T7O);
			      T8j = FMA(T7P, T7O, T7D * T7W);
			      T7Y = W[12];
			      T8a = W[13];
			      T8i = FMA(T7Y, T89, T8a * T8h);
			      T8k = FNMS(T8a, T89, T7Y * T8h);
			 }
			 Rp[WS(rs, 3)] = T7X - T8i;
			 Ip[WS(rs, 3)] = T8j + T8k;
			 Rm[WS(rs, 3)] = T7X + T8i;
			 Im[WS(rs, 3)] = T8k - T8j;
		    }
		    {
			 E T8V, T91, T90, T92;
			 {
			      E T8R, T8T, T8W, T8Y;
			      T8R = W[58];
			      T8T = W[59];
			      T8V = FNMS(T8T, T8U, T8R * T8S);
			      T91 = FMA(T8T, T8S, T8R * T8U);
			      T8W = W[60];
			      T8Y = W[61];
			      T90 = FMA(T8W, T8X, T8Y * T8Z);
			      T92 = FNMS(T8Y, T8X, T8W * T8Z);
			 }
			 Rp[WS(rs, 15)] = T8V - T90;
			 Ip[WS(rs, 15)] = T91 + T92;
			 Rm[WS(rs, 15)] = T8V + T90;
			 Im[WS(rs, 15)] = T92 - T91;
		    }
		    {
			 E T8p, T8v, T8u, T8w;
			 {
			      E T8l, T8n, T8q, T8s;
			      T8l = W[42];
			      T8n = W[43];
			      T8p = FNMS(T8n, T8o, T8l * T8m);
			      T8v = FMA(T8n, T8m, T8l * T8o);
			      T8q = W[44];
			      T8s = W[45];
			      T8u = FMA(T8q, T8r, T8s * T8t);
			      T8w = FNMS(T8s, T8r, T8q * T8t);
			 }
			 Rp[WS(rs, 11)] = T8p - T8u;
			 Ip[WS(rs, 11)] = T8v + T8w;
			 Rm[WS(rs, 11)] = T8p + T8u;
			 Im[WS(rs, 11)] = T8w - T8v;
		    }
		    {
			 E T8F, T8P, T8O, T8Q;
			 {
			      E T8x, T8B, T8G, T8K;
			      T8x = W[26];
			      T8B = W[27];
			      T8F = FNMS(T8B, T8E, T8x * T8A);
			      T8P = FMA(T8B, T8A, T8x * T8E);
			      T8G = W[28];
			      T8K = W[29];
			      T8O = FMA(T8G, T8J, T8K * T8N);
			      T8Q = FNMS(T8K, T8J, T8G * T8N);
			 }
			 Rp[WS(rs, 7)] = T8F - T8O;
			 Ip[WS(rs, 7)] = T8P + T8Q;
			 Rm[WS(rs, 7)] = T8F + T8O;
			 Im[WS(rs, 7)] = T8Q - T8P;
		    }
	       }
	       {
		    E T4k, T4S, T4s, T4U, T5a, T5q, T56, T5o, T4N, T5t, T4Z, T5f, T4F, T5v, T4X;
		    E T5j;
		    {
			 E T4c, T4j, T54, T55;
			 T4c = T4a + T4b;
			 T4j = KP707106781 * (T4f + T4i);
			 T4k = T4c + T4j;
			 T4S = T4c - T4j;
			 {
			      E T4o, T4r, T58, T59;
			      T4o = KP707106781 * (T4m + T4n);
			      T4r = T4p + T4q;
			      T4s = T4o + T4r;
			      T4U = T4r - T4o;
			      T58 = KP707106781 * (T4f - T4i);
			      T59 = T4q - T4p;
			      T5a = T58 + T59;
			      T5q = T59 - T58;
			 }
			 T54 = T4a - T4b;
			 T55 = KP707106781 * (T4n - T4m);
			 T56 = T54 + T55;
			 T5o = T54 - T55;
			 {
			      E T4M, T5d, T4J, T5e, T4H, T4I;
			      T4M = T4K + T4L;
			      T5d = T4v - T4w;
			      T4H = FNMS(KP831469612, T4y, KP555570233 * T4z);
			      T4I = FMA(KP831469612, T4B, KP555570233 * T4C);
			      T4J = T4H + T4I;
			      T5e = T4H - T4I;
			      T4N = T4J + T4M;
			      T5t = T5d - T5e;
			      T4Z = T4M - T4J;
			      T5f = T5d + T5e;
			 }
			 {
			      E T4x, T5i, T4E, T5h, T4A, T4D;
			      T4x = T4v + T4w;
			      T5i = T4L - T4K;
			      T4A = FMA(KP555570233, T4y, KP831469612 * T4z);
			      T4D = FNMS(KP831469612, T4C, KP555570233 * T4B);
			      T4E = T4A + T4D;
			      T5h = T4D - T4A;
			      T4F = T4x + T4E;
			      T5v = T5i - T5h;
			      T4X = T4x - T4E;
			      T5j = T5h + T5i;
			 }
		    }
		    {
			 E T4t, T4P, T4O, T4Q;
			 {
			      E T49, T4l, T4u, T4G;
			      T49 = W[6];
			      T4l = W[7];
			      T4t = FNMS(T4l, T4s, T49 * T4k);
			      T4P = FMA(T4l, T4k, T49 * T4s);
			      T4u = W[8];
			      T4G = W[9];
			      T4O = FMA(T4u, T4F, T4G * T4N);
			      T4Q = FNMS(T4G, T4F, T4u * T4N);
			 }
			 Rp[WS(rs, 2)] = T4t - T4O;
			 Ip[WS(rs, 2)] = T4P + T4Q;
			 Rm[WS(rs, 2)] = T4t + T4O;
			 Im[WS(rs, 2)] = T4Q - T4P;
		    }
		    {
			 E T5r, T5x, T5w, T5y;
			 {
			      E T5n, T5p, T5s, T5u;
			      T5n = W[54];
			      T5p = W[55];
			      T5r = FNMS(T5p, T5q, T5n * T5o);
			      T5x = FMA(T5p, T5o, T5n * T5q);
			      T5s = W[56];
			      T5u = W[57];
			      T5w = FMA(T5s, T5t, T5u * T5v);
			      T5y = FNMS(T5u, T5t, T5s * T5v);
			 }
			 Rp[WS(rs, 14)] = T5r - T5w;
			 Ip[WS(rs, 14)] = T5x + T5y;
			 Rm[WS(rs, 14)] = T5r + T5w;
			 Im[WS(rs, 14)] = T5y - T5x;
		    }
		    {
			 E T4V, T51, T50, T52;
			 {
			      E T4R, T4T, T4W, T4Y;
			      T4R = W[38];
			      T4T = W[39];
			      T4V = FNMS(T4T, T4U, T4R * T4S);
			      T51 = FMA(T4T, T4S, T4R * T4U);
			      T4W = W[40];
			      T4Y = W[41];
			      T50 = FMA(T4W, T4X, T4Y * T4Z);
			      T52 = FNMS(T4Y, T4X, T4W * T4Z);
			 }
			 Rp[WS(rs, 10)] = T4V - T50;
			 Ip[WS(rs, 10)] = T51 + T52;
			 Rm[WS(rs, 10)] = T4V + T50;
			 Im[WS(rs, 10)] = T52 - T51;
		    }
		    {
			 E T5b, T5l, T5k, T5m;
			 {
			      E T53, T57, T5c, T5g;
			      T53 = W[22];
			      T57 = W[23];
			      T5b = FNMS(T57, T5a, T53 * T56);
			      T5l = FMA(T57, T56, T53 * T5a);
			      T5c = W[24];
			      T5g = W[25];
			      T5k = FMA(T5c, T5f, T5g * T5j);
			      T5m = FNMS(T5g, T5f, T5c * T5j);
			 }
			 Rp[WS(rs, 6)] = T5b - T5k;
			 Ip[WS(rs, 6)] = T5l + T5m;
			 Rm[WS(rs, 6)] = T5b + T5k;
			 Im[WS(rs, 6)] = T5m - T5l;
		    }
	       }
	       {
		    E T60, T6W, T6c, T6Y, T7e, T7u, T7a, T7s, T6R, T7x, T73, T7j, T6F, T7z, T71;
		    E T7n;
		    {
			 E T5K, T5Z, T78, T79;
			 T5K = T5C + T5J;
			 T5Z = T5R + T5Y;
			 T60 = T5K + T5Z;
			 T6W = T5K - T5Z;
			 {
			      E T64, T6b, T7c, T7d;
			      T64 = T62 + T63;
			      T6b = T67 + T6a;
			      T6c = T64 + T6b;
			      T6Y = T6b - T64;
			      T7c = T5R - T5Y;
			      T7d = T6a - T67;
			      T7e = T7c + T7d;
			      T7u = T7d - T7c;
			 }
			 T78 = T5C - T5J;
			 T79 = T63 - T62;
			 T7a = T78 + T79;
			 T7s = T78 - T79;
			 {
			      E T6Q, T7h, T6J, T7i, T6H, T6I;
			      T6Q = T6M + T6P;
			      T7h = T6h - T6o;
			      T6H = FNMS(KP555570233, T6s, KP831469612 * T6v);
			      T6I = FMA(KP555570233, T6z, KP831469612 * T6C);
			      T6J = T6H + T6I;
			      T7i = T6H - T6I;
			      T6R = T6J + T6Q;
			      T7x = T7h - T7i;
			      T73 = T6Q - T6J;
			      T7j = T7h + T7i;
			 }
			 {
			      E T6p, T7m, T6E, T7l, T6w, T6D;
			      T6p = T6h + T6o;
			      T7m = T6P - T6M;
			      T6w = FMA(KP831469612, T6s, KP555570233 * T6v);
			      T6D = FNMS(KP555570233, T6C, KP831469612 * T6z);
			      T6E = T6w + T6D;
			      T7l = T6D - T6w;
			      T6F = T6p + T6E;
			      T7z = T7m - T7l;
			      T71 = T6p - T6E;
			      T7n = T7l + T7m;
			 }
		    }
		    {
			 E T6d, T6T, T6S, T6U;
			 {
			      E T5z, T61, T6e, T6G;
			      T5z = W[2];
			      T61 = W[3];
			      T6d = FNMS(T61, T6c, T5z * T60);
			      T6T = FMA(T61, T60, T5z * T6c);
			      T6e = W[4];
			      T6G = W[5];
			      T6S = FMA(T6e, T6F, T6G * T6R);
			      T6U = FNMS(T6G, T6F, T6e * T6R);
			 }
			 Rp[WS(rs, 1)] = T6d - T6S;
			 Ip[WS(rs, 1)] = T6T + T6U;
			 Rm[WS(rs, 1)] = T6d + T6S;
			 Im[WS(rs, 1)] = T6U - T6T;
		    }
		    {
			 E T7v, T7B, T7A, T7C;
			 {
			      E T7r, T7t, T7w, T7y;
			      T7r = W[50];
			      T7t = W[51];
			      T7v = FNMS(T7t, T7u, T7r * T7s);
			      T7B = FMA(T7t, T7s, T7r * T7u);
			      T7w = W[52];
			      T7y = W[53];
			      T7A = FMA(T7w, T7x, T7y * T7z);
			      T7C = FNMS(T7y, T7x, T7w * T7z);
			 }
			 Rp[WS(rs, 13)] = T7v - T7A;
			 Ip[WS(rs, 13)] = T7B + T7C;
			 Rm[WS(rs, 13)] = T7v + T7A;
			 Im[WS(rs, 13)] = T7C - T7B;
		    }
		    {
			 E T6Z, T75, T74, T76;
			 {
			      E T6V, T6X, T70, T72;
			      T6V = W[34];
			      T6X = W[35];
			      T6Z = FNMS(T6X, T6Y, T6V * T6W);
			      T75 = FMA(T6X, T6W, T6V * T6Y);
			      T70 = W[36];
			      T72 = W[37];
			      T74 = FMA(T70, T71, T72 * T73);
			      T76 = FNMS(T72, T71, T70 * T73);
			 }
			 Rp[WS(rs, 9)] = T6Z - T74;
			 Ip[WS(rs, 9)] = T75 + T76;
			 Rm[WS(rs, 9)] = T6Z + T74;
			 Im[WS(rs, 9)] = T76 - T75;
		    }
		    {
			 E T7f, T7p, T7o, T7q;
			 {
			      E T77, T7b, T7g, T7k;
			      T77 = W[18];
			      T7b = W[19];
			      T7f = FNMS(T7b, T7e, T77 * T7a);
			      T7p = FMA(T7b, T7a, T77 * T7e);
			      T7g = W[20];
			      T7k = W[21];
			      T7o = FMA(T7g, T7j, T7k * T7n);
			      T7q = FNMS(T7k, T7j, T7g * T7n);
			 }
			 Rp[WS(rs, 5)] = T7f - T7o;
			 Ip[WS(rs, 5)] = T7p + T7q;
			 Rm[WS(rs, 5)] = T7f + T7o;
			 Im[WS(rs, 5)] = T7q - T7p;
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     { TW_FULL, 1, 32 },
     { TW_NEXT, 1, 0 }
};

static const hc2c_desc desc = { 32, "hc2cbdft_32", twinstr, &GENUS, { 404, 114, 94, 0 } };

void X(codelet_hc2cbdft_32) (planner *p) {
     X(khc2c_register) (p, hc2cbdft_32, &desc, HC2C_VIA_DFT);
}
#endif
