/* -*- buffer-read-only: t -*-
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/mk_invlists.pl from mph.pl.
 * Any changes made here will be lost!
 */

/* The precision to use in "%.*e" formats */
#define PL_E_FORMAT_PRECISION 2

#define MPH_VALt I16

/*
rows: 7016
seed: 1348825708
full length of keys: 98325
blob length: 9964
ref length: 56128
data size: 66092 (%67.22)
*/

STATIC const unsigned char mph_blob[] =
    "unifiedcanadianaboriginalsyllabicsextendedcjkcompatibilityideogra"
    "phssupplementarabicmathematicalalphabeticsymbolscombiningdiacriti"
    "calmarksforsymbolscombiningdiacriticalmarkssupplementmiscellaneou"
    "ssymbolsandpictographscombiningdiacriticalmarksextendedmiscellane"
    "ousmathematicalsymbolsamiscellaneousmathematicalsymbolsbsupplemen"
    "talmathematicaloperatorssupplementalsymbolsandpictographsegyptian"
    "hieroglyphformatcontrolsideographicdescriptioncharactersideograph"
    "icsymbolsandpunctuationmathematicalalphanumericsymbolscjkunifiedi"
    "deographsextensionacjkunifiedideographsextensionbcjkunifiedideogr"
    "aphsextensionccjkunifiedideographsextensiondcjkunifiedideographse"
    "xtensionecjkunifiedideographsextensionfcuneiformnumbersandpunctua"
    "tionenclosedalphanumericsupplementsymbolsandpictographsextendedae"
    "nclosedideographicsupplementmiscellaneoussymbolsandarrowsphonetic"
    "extensionssupplementsupplementaryprivateuseareaasupplementarypriv"
    "ateuseareabvariationselectorssupplementalphabeticpresentationform"
    "sancientgreekmusicalnotationenclosedcjklettersandmonthsopticalcha"
    "racterrecognitionprependedconcatenationmark=changeswhennfkccasefo"
    "lded=conditionaljapanesestarterdefaultignorablecodepoint=halfwidt"
    "handfullwidthformskatakanaphoneticextensionsconsonantinitialpostf"
    "ixedfullcompositionexclusion=superscriptsandsubscriptssymbolsandp"
    "ictographsextaarabicpresentationformsaarabicpresentationformsbcan"
    "onicalcombiningclass=cjksymbolsandpunctuationcombiningmarksforsym"
    "bolsconsonantsucceedingrephahighprivateusesurrogatesindicposition"
    "alcategory=supsymbolsandpictographsbyzantinemusicalsymbolsconsona"
    "ntprecedingrephageometricshapesextendedhangulcompatibilityjamolat"
    "inextendedadditionalshorthandformatcontrolssupplementalpunctuatio"
    "nbidipairedbrackettype=changeswhencasefolded=changeswhencasemappe"
    "d=changeswhenlowercased=changeswhentitlecased=changeswhenuppercas"
    "ed=cjkcompatideographssupcommonindicnumberformsdiacriticalsforsym"
    "bolsearlydynasticcuneiformindicsyllabiccategory=logicalorderexcep"
    "tion=miscellaneoustechnicalnoncharactercodepoint=spacingmodifierl"
    "etterstransportandmapsymbolscjkcompatibilityformscjkradicalssuppl"
    "ementcyrillicsupplementarygraphemeclusterbreak=hanifirohingyakinn"
    "ayainscriptionalparthianmeeteimayekextensionspopdirectionalisolat"
    "esinhalaarchaicnumbersyijinghexagramsymbolsanatolianhieroglyphsco"
    "nnectorpunctuationconsonantplaceholderconsonantwithstackerglagoli"
    "ticsupplementinscriptionalpahlavilefttorightembeddingnyiakengpuac"
    "huehmongpopdirectionalformatrighttoleftembeddingterminalpunctuati"
    "on=topandbottomandrightverticalorientation=ancientgreeknumbersbra"
    "hmijoiningnumberburushaskiyehbarreeconsonantheadlettercountingrod"
    "numeralsegyptianhieroglyphsenclosedalphanumsuphanguljamoextendeda"
    "hanguljamoextendedbhangulsyllabletype=idstrinaryoperator=lefttori"
    "ghtoverridemeroitichieroglyphsmodifiertonelettersmongoliansupplem"
    "entottomansiyaqnumbersrighttoleftoverridesundanesesupplementsuppl"
    "ementalarrowsasupplementalarrowsbsupplementalarrowscattachedabove"
    "rightcherokeesupplementcombininghalfmarksconsonantsubjoinedcoptic"
    "epactnumbersdecompositiontype=devanagariextendedethiopicsupplemen"
    "teuropeanterminatorfirststrongisolategeneralpunctuationgeorgiansu"
    "pplementidsbinaryoperator=initialpunctuationlatinextadditionallef"
    "ttorightisolateornamentaldingbatsparagraphseparatorpatternwhitesp"
    "ace=regionalindicator=righttoleftisolateruminumeralsymbolssmallka"
    "naextensiontaixuanjingsymbolstopandleftandrighttransformedrotated"
    "transformeduprightvariationselector=alchemicalsymbolsattachedbelo"
    "wleftcanadiansyllabicscaucasianalbanianconsonantprefixedcyrillice"
    "xtendedacyrillicextendedbcyrillicextendedcethiopicextendedaeurope"
    "anseparatorindicsiyaqnumbersletterlikesymbolsmanichaeandhamedhman"
    "ichaeanhundredmanichaeanthamedhscriptextensions=sentenceterminal="
    "smallformvariantssuttonsignwritingunifiedideograph=arabicsuppleme"
    "ntbopomofoextendedcantillationmarkcloseparenthesisclosepunctuatio"
    "ncypriotsyllabaryfinalpunctuationgeneralcategory=georgianextended"
    "halfandfullformshanifirohingyapahighpusurrogatesinvisiblestackerl"
    "atin1supplementlinearbideogramslinearbsyllabarymanichaeandalethma"
    "nichaeanlamedhmanichaeansamekhmanichaeantwentymiscmathsymbolsamis"
    "cmathsymbolsbmyanmarextendedamyanmarextendedbotherpunctuationsegm"
    "entseparatorsupmathoperatorssyllablemodifiersyriacsupplementtangu"
    "tcomponentsvowelindependentarabicextendedabamumsupplementboundary"
    "neutralbraillepatternscommonseparatorconsonantkillerconsonantmedi"
    "alcontingentbreakcontrolpicturescurrencysymbolsdashpunctuationdia"
    "criticalsextdiacriticalssupeastasianwidth=graphemeextend=hangulsy"
    "llablesimperialaramaiclowercaselettermanichaeanalephmanichaeangim"
    "elmanichaeansadhemanichaeanzayinmeroiticcursivemiscpictographsmod"
    "ifyingletternfkcquickcheck=nfkdquickcheck=oldnortharabianoldsouth"
    "arabianopenpunctuationregistershiftertamilsupplementtitlecaselett"
    "eruppercaselettervedicextensionsvisualorderleftzanabazarsquareanc"
    "ientsymbolsasciihexdigit=carriagereturncaseignorable=cjkcompatfor"
    "mscomplexcontextconsonantfinaleuropeannumbergeminationmarkgreekan"
    "dcoptichamzaonhehgoalhighsurrogateskanasupplementkangxiradicalsla"
    "tinextendedblatinextendedclatinextendeddlatinextendedemandatorybr"
    "eakmanichaeanayinmanichaeanbethmanichaeanfivemanichaeanhethmanich"
    "aeankaphmanichaeanqophmanichaeanreshmanichaeantethmanichaeanyodhm"
    "odifiersymbolnfcquickcheck=nfdquickcheck=nojoininggroupnonspacing"
    "markpatternsyntax=phoneticextsuppostfixnumericpsalterpahlaviquota"
    "tionmark=sentencebreak=spaceseparatorsuppunctuationtehmarbutagoal"
    "voweldependent1000000000000aegeannumbersbidimirrored=blockelement"
    "sbottomandleftconsonantdeaddecimalnumberenclosingmarkgraphemebase"
    "=greekextendediotasubscriptipaextensionsjoininggroup=kanaextended"
    "alineseparatorlowsurrogatesmalayalamlllamalayalamnnnamanichaeanme"
    "mmanichaeannunmanichaeanonemanichaeantawmanichaeantenmanichaeanwa"
    "wmayannumeralsmisctechnicalnotapplicablenumericvalue=prefixnumeri"
    "cverticalformsalphabeticpfarabicletterarabicnumberbidicontrol=bre"
    "aksymbolschesssymbolscyrillicextacyrillicextbcyrillicextcethiopic"
    "extaextendnumletfinalsemkathglueafterzwjgunjalagondihebrewletteri"
    "deographic=infixnumericjoincontrol=joiningtype=khmersymbolsletter"
    "numbermahjongtilesmalayalambhamalayalamllamalayalamngamalayalamnn"
    "amalayalamnyamalayalamssamalayalamttamanichaeanpemasaramgondimath"
    "alphanummendekikakuinoncanonicalnotreorderednumberjoinernumericty"
    "pe=oldhungarianotherneutralphaistosdiscplayingcardsrightjoiningtr"
    "ailingjamoxidcontinue=africannoonalphabetic=breakbeforecasedlette"
    "rdeprecated=dominotilesdoubleabovedoublebelowdoublequotedualjoini"
    "ngexclamationinseparableinseperablejoincausingkanavoicingkatakana"
    "extleadingjamoleftjoininglvtsyllablemalayalamjamalayalamramedefai"
    "drinmiscsymbolsmyanmarextamyanmarextbnandinagariotherletterothern"
    "umberothersymbolpahawhhmongrohingyayehsinglequotesoftdotted=soras"
    "ompengstraightwawsuperandsubsylotinagritopandrighttransparentyehw"
    "ithtailyisyllablesafricanfehafricanqafarabicextabasiclatinbelowri"
    "ghtbidiclass=boxdrawingbreakaftercjkstrokescompatjamodalathrishdi"
    "acritic=kharoshthiknottedhehlinebreak=lowercase=lvsyllablemiscarr"
    "owsnonjoiningnonstarteroldpersianoldsogdianoverstruckphoenicianpr"
    "esentin=purekillerreversedpesaurashtrasmallformssuparrowsasuparro"
    "wsbsuparrowscunassigneduppercase=warangcitiwordbreak=wordjoineryi"
    "radicals-5.00e-01aboveleftambiguousarabicpfaarabicpfbbhaiksukibre"
    "akbothemoticonsextender=inheritedkhudawadilatinextblatinextclatin"
    "extdmidlettermidnumletnabataeannewtailuenonjoinerolditalicoldperm"
    "icoldturkicpalmyrenepaucinhausamaritanscontinuesyriacwawvoweljamo"
    "wsegspacexidstart=1.00e-011.11e-011.25e-011.25e-021.43e-011.50e+0"
    "01.50e-011.56e-021.67e-011.88e-012.00e-012.50e+002.50e-012.50e-02"
    "200000003.12e-023.13e-023.13e-033.33e-013.50e+003.75e-013.75e-024"
    ".00e-014.17e-014.50e+004.69e-025.00e-025.50e+005.83e-016.00e-016."
    "25e-016.25e-026.25e-036.50e+006.67e-017.50e+007.50e-018.00e-018.3"
    "3e-018.33e-028.50e+008.75e-019.17e-01armenianavagrahabalinesebass"
    "avahbugineseduployanebasegazfarsiyehfractiongujaratigurmukhihirag"
    "anaisolatedjamoextajamoextbjavanesekanaextalinefeedmahajaninextli"
    "neradical=specialsswashkaftagbanwatifinaghtonemarkugariticaletter"
    "avestanbengalicjkextacjkextbcjkextccjkextdcjkextecjkextfcompex=de"
    "seretelbasanelymaicgranthagrbase=hanunoohyphen=kannadakayahliline"
    "aramakasarmandaicmarchenmultaninewlinenfkcqc=nfkdqc=noblocknobrea"
    "kolchikioletterosmanyaoverlaypatsyn=phagspascript=sharadashavians"
    "iddhamsoyombosuppuaasuppuabtagalogtaithamtaiviettibetantirhutauca"
    "sextunknownvisargawspace=zwspace216000300000400000432000500000600"
    "000700000800000900000alpha=bidic=bidim=block=carianccc103ccc107cc"
    "c118ccc122ccc129ccc130ccc132ccc133chakmacirclecwkcf=gothicgrext=h"
    "atranjoinc=kaithikanbunkhojkilamadhlepchalower=lycianlydiannarrow"
    "nchar=nfcqc=nfdqc=patws=qmark=rejangsterm=teluguthaanauideo=upper"
    "=viramawanchoyudhhe1/1601/32011/12adlamahex=alaphatermbatakbindub"
    "uhidccc14ccc15ccc16ccc17ccc18ccc19ccc20ccc21ccc22ccc23ccc24ccc25c"
    "cc26ccc27ccc28ccc29ccc30ccc31ccc32ccc33ccc34ccc35ccc36ccc84ccc91c"
    "ntrlcwcf=cwcm=dash=dografalseidsb=idst=inpc=insc=khaphlimbumath=m"
    "aybenuktanushuoghamoriyaosagerunictailetakrivssupxidc=xids=zhain-"
    "1/21/101/201/401/641/8010.011.011/212.113/215/217/23/163/203/643/"
    "805/127/12adlmage=aghbahomalefarmiarmnataratblavstbatkbhksblk=bpt"
    "=buhdcakmcansccc=cprtcwl=cwt=cwu=cyrldep=dia=dsrtfontgcb=gonggonm"
    "grekgujrguruhanohluwhmnghmnphst=kalikhmrkndakthilanalaoolatnlinal"
    "inblisuloe=medfmeemmercmiaomlymmroomteimymrnarbnbatnewankoonshuog"
    "amolckorkhoryaosgepcm=phlpphnxplrdprtiqaacqaaiqaphrjngrohgrunrsam"
    "rsarbscx=seensgnwshawshinshrdsogosyrctagstaletalutamltavttfngtglg"
    "thaitibttruev100v110v120v121vaiiwchowidexpeoxsuxyiiizainzanbzinhz"
    "yyyzzzz1/51/71/92/32/52022142182222242262282302322332342403.03.23"
    "/43/54/55.15.25/65/86.16.37.07/89.09/2bc=behci=di=dt=ea=ebgfsigaf"
    "gc=jg=jt=lb=lrelrilromimnsmnv=ocrpdfrehri=sd=smlsqrtahv20v21v30v3"
    "1v32v40v41v50v51v52v60v61v62v63v70v80v90vo=vs=wb=yes3839444546474"
    "849b2bkh2h3jljvkvl&l_vrxxzlzpzs_perl_problematic_locale_foldeds_i"
    "s_in_multi_char_fold_perl_folds_to_perl_charname__perl_non_finabe"
    "ginany_foldsquotemetaisxposixisposixblankprintishorizisxperlisper"
    "lisspaceisvertisuni";
/* mph_blob length: 9964 */

struct mph_struct {
    U16 seed2;
    U16 pfx;
    U16 sfx;
    U8  pfx_len;
    U8  sfx_len;
    MPH_VALt value;
};

#define MPH_RSHIFT 8
#define MPH_BUCKETS 7016

STATIC const U32 MPH_SEED1 = 0x5065726c;
STATIC const U32 MPH_FNV_CONST = 0x01000193;

/* The comments give the input key for the row it is in */
STATIC const struct mph_struct mph_table[MPH_BUCKETS] = {
  {     2,   184,  6948,   2,  10, UNI_MISCARROWS }   /* ismiscarrows */,
  {     1,  3671,  6027,  17,   5, UNI_KHMR }   /* scriptextensions=khmer */,
  {     0,  6472,  3470,   5,  14, UNI_INCAUCASIANALBANIAN }   /* incaucasianalbanian */,
  {    10,  9365,  2608,   4,  19, UNI_EGYP }   /* scx=egyptianhieroglyphs */,
  {     1,  9113,  7540,   4,   2, UNI_CCC__20 }   /* ccc=20 */,
  {     2,  3671,  4672,  17,  15, UNI_SARB }   /* scriptextensions=oldsoutharabian */,
  {     0,  6885,  1459,   3,  23, UNI_HIGHPUSURROGATES }   /* ishighprivateusesurrogates */,
  {    16,  5325,     0,  14,   0, UNI_qmark_values_index }   /* quotationmark= */,
  {     1,  9629,  8324,   3,   7, UNI_LB__XX }   /* lb=unknown */,
  {     4,  5760,  8981,  13,   4, UNI_NV__1_SLASH_40 }   /* numericvalue=1/40 */,
  {     6,  9093,  5907,   4,  12, UNI_ETHIOPICEXTA }   /* blk=ethiopicexta */,
  {     1,  1911,  3788,  22,  16, UNI_INSC__CANTILLATIONMARK }   /* indicsyllabiccategory=cantillationmark */,
  {     0,  8424,  5799,   6,  12, UNI_ALPHABETICPF }   /* block=alphabeticpf */,
  {    12,  3671,  8679,  17,   5, UNI_ADLM }   /* scriptextensions=adlam */,
  {     0,  9775,     0,   2,   0, UNI_ZL }   /* zl */,
  {     1,    42,     0,   3,   0, UNI_CJK }   /* cjk */,
  {     0,  5339,    49,  14,   2, UNI_SB__AT }   /* sentencebreak=at */,
  {     0,  5339,  8198,  14,   7, UNI_SB__LE }   /* sentencebreak=oletter */,
  {     1,  9093,  1618,   4,   4, UNI_JAMO }   /* blk=jamo */,
  {     1,  3671,  6051,  17,   4, UNI_MAHJ }   /* scriptextensions=mahj */,
  {     4,  8424,  9261,   6,   3, UNI_INMRO }   /* block=mro */,
  {     1,   132,     0,   2,   0, UNI_LM }   /* lm */,
  {     0,  3671,  4220,  17,   6, UNI_TANG }   /* scriptextensions=tangut */,
  {     0,  9623,  5669,   3,  13, UNI_JG__MANICHAEANONE }   /* jg=manichaeanone */,
  {     0,  9093,  5955,   4,  12, UNI_INGUNJALAGONDI }   /* blk=gunjalagondi */,
  {     6,  9903,  7128,   6,   4, UNI_XPOSIXWORD }   /* xposixword */,
  {     4,  2836,     0,   9,   0, UNI_SUND }   /* sundanese */,
  {     0,  9623,  1456,   3,   3, UNI_JG__HAH }   /* jg=hah */,
  {     0,  8424,    43,   7,  25, UNI_CJKCOMPATIDEOGRAPHS }   /* block=cjkcompatibilityideographs */,
  {     7,  8871,  1164,   3,   2, UNI_LB__LF }   /* sb=lf */,
  {     1,   184,  6646,   2,  11, UNI_HMNG }   /* ispahawhhmong */,
  {     2,  3671,  9217,  17,   4, UNI_LAO }   /* scriptextensions=laoo */,
  {     3,  3996,     0,  16,   0, UNI_LINEARBSYLLABARY }   /* linearbsyllabary */,
  {     4,   184,  5734,   2,  13, UNI_MISCTECHNICAL }   /* ismisctechnical */,
  {     3,  8954,  9734,   5,   3, UNI_XIDC }   /* xidc=yes */,
  {     1,  1154,     0,   3,   0, UNI_DEP }   /* dep */,
  {     3,   184,   779,   2,  22, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* isenclosedideographicsup */,
  {     0,  3671,  5967,  17,   6, UNI_HEBR }   /* scriptextensions=hebrew */,
  {    34,  9429,     0,   4,   0, UNI_TIBT }   /* tibt */,
  {     8,  7025,  9719,   3,   3, UNI_IN__8 }   /* in=v80 */,
  {     1,  8634,  9734,   6,   3, UNI_UIDEO }   /* uideo=yes */,
  {     1,  8520,   995,   6,   2, -UNI_JOINC }   /* joinc=no */,
  {     3,  2211,     0,  21,   0, UNI_SINHALAARCHAICNUMBERS }   /* sinhalaarchaicnumbers */,
  {     0,  8879,  2479,   5,   6, UNI_INPC__BOTTOM }   /* inpc=bottom */,
  {     1,   184,  1057,   2,  26, UNI_PCM }   /* isprependedconcatenationmark */,
  {     0,  6918,  1156,  10,   2, UNI_LB__PO }   /* linebreak=po */,
  {     0,  8886,  9181,   3,   4, UNI_HLUW }   /* sc=hluw */,
  {     2,  9365,  7788,   4,   8, UNI_BALI }   /* scx=balinese */,
  {     1,  9365,  9285,   4,   3, UNI_NKO }   /* scx=nko */,
  {     0,  4642,     0,  15,   0, UNI_nfkdqc_values_index }   /* nfkdquickcheck= */,
  {     0,   184,    43,   3,  25, UNI_CJKCOMPATIDEOGRAPHS }   /* iscjkcompatibilityideographs */,
  {     3,  2148,  2875,   3,  18, UNI_SUPARROWSB }   /* insupplementalarrowsb */,
  {     1,  1691,     1,  22,   1, UNI_BPT__N }   /* bidipairedbrackettype=n */,
  {     1,   184,  8079,   2,   7, UNI_GRAN }   /* isgrantha */,
  {     0,  7128,  1188,  10,   8, UNI_WB__KA }   /* wordbreak=katakana */,
  {     1,  9093,     0,   4,  34, UNI_UCAS }   /* blk=unifiedcanadianaboriginalsyllabics */,
  {     1,  3671,   689,  17,   9, UNI_XSUX }   /* scriptextensions=cuneiform */,
  {     3,  4705,  9430,   3,   3, UNI_TIBT }   /* istibt */,
  {     0,  1911,  2313,  22,  20, UNI_INSC__CONSONANTWITHSTACKER }   /* indicsyllabiccategory=consonantwithstacker */,
  {     8,  8886,  7239,   3,   9, UNI_SC__QAAI }   /* sc=inherited */,
  {     3,  8424,  4672,   6,  15, UNI_SARB }   /* block=oldsoutharabian */,
  {     0,  1497,  3228,  10,   8, UNI_Z }   /* category=separator */,
  {     0,  8892,     0,   4,   0, UNI_PHLI }   /* phli */,
  {     0,  7420,    26,   8,   1, UNI_IDS }   /* idstart=y */,
  {     1,  2930,     0,  18,   0, UNI_CHEROKEESUP }   /* cherokeesupplement */,
  {     2,  8424,   510,   7,  19, UNI_CJK }   /* block=cjkunifiedideographs */,
  {     1,  6003,     0,  11,   0, UNI_JOINC }   /* joincontrol */,
  {     1,  7025,  9581,   3,   3, UNI_IN__7 }   /* in=7.0 */,
  {     1,  6918,  9759,  10,   2, UNI_LB__H3 }   /* linebreak=h3 */,
  {     0,  8424,  8205,   6,   7, UNI_INOSMANYA }   /* block=osmanya */,
  {     0,  5760,  9747,  13,   2, UNI_NV__47 }   /* numericvalue=47 */,
  {     1,  6828,  2190,  10,  21, UNI_BC__PDI }   /* bidiclass=popdirectionalisolate */,
  {     2,  8514,     0,   4,   0, UNI_HATR }   /* hatr */,
  {     1,  9647,  8358,   3,   3, UNI_NV__300 }   /* nv=300 */,
  {     1,  8282,     0,   7,   0, UNI_TGLG }   /* tagalog */,
  {     4,  8886,  8430,   3,   4, UNI_CARI }   /* sc=cari */,
  {     2,  9605,  2493,   3,   4, UNI_DT__VERT }   /* dt=vert */,
  {     1,  5734,     0,  13,   0, UNI_MISCTECHNICAL }   /* misctechnical */,
  {     4,  8879,  6998,   5,  10, UNI_INPC__OVERSTRUCK }   /* inpc=overstruck */,
  {     3,  3671,  9053,  17,   4, UNI_AGHB }   /* scriptextensions=aghb */,
  {     2,  3236,  9734,  18,   3, UNI__PERL_PATWS }   /* patternwhitespace=yes */,
  {     0,  9608,  1162,   3,   9, UNI_EA__H }   /* ea=halfwidth */,
  {     1,  3671,  5955,  17,  12, UNI_GONG }   /* scriptextensions=gunjalagondi */,
  {     0,   184,  8699,   2,   5, UNI_BATK }   /* isbatak */,
  {     0,  7420,     0,   8,   0, UNI_ids_values_index }   /* idstart= */,
  {     0,  1362,  5409,  24,   2, UNI_CCC__10 }   /* canonicalcombiningclass=10 */,
  {     0,  8424,  6991,   6,   7, UNI_INSOGDIAN }   /* block=sogdian */,
  {     0,  8233,   689,   7,   9, UNI_XSUX }   /* script=cuneiform */,
  {     1,  9093,  1338,   4,  24, UNI_ARABICPFB }   /* blk=arabicpresentationformsb */,
  {     1,  1713,    26,  22,   1, UNI_CWCF }   /* changeswhencasefolded=y */,
  {     5,   184,    74,   2,   2, UNI_ME }   /* isme */,
  {     1,  9620,    24,   3,   1, UNI_L }   /* gc=l */,
  {     1,  4705,  2022,   3,  21, UNI_TRANSPORTANDMAP }   /* istransportandmapsymbols */,
  {     4,  7025,  9701,   3,   3, UNI_IN__5_DOT_2 }   /* in=v52 */,
  {     1,  2106,   406,  21,   7, UNI_GCB__CN }   /* graphemeclusterbreak=control */,
  {     1,  8233,  7788,   7,   8, UNI_BALI }   /* script=balinese */,
  {     0,  9909,  9322,   3,   3, UNI_PHNX }   /* isphnx */,
  {     0,  8886,  8502,   3,   4, UNI_GOTH }   /* sc=goth */,
  {     0,  3671,  1599,  17,   6, UNI_HANG }   /* scriptextensions=hangul */,
  {     2,  2148,  8269,   3,   6, UNI_SUPPUAA }   /* insuppuaa */,
  {     2,  9365,  9109,   4,   4, UNI_CANS }   /* scx=cans */,
  {     0,  8233,  8128,   7,   7, UNI_MAKA }   /* script=makasar */,
  {     0,  1497,  5487,   9,  13, UNI_XPOSIXDIGIT }   /* category=decimalnumber */,
  {     5,   184,  1154,   2,   3, UNI_DEP }   /* isdep */,
  {     1,   184,     7,   3,   1, UNI_XPOSIXCNTRL }   /* iscc */,
  {     6,  8424,    43,   7,   8, UNI_CJKCOMPAT }   /* block=cjkcompat */,
  {    10,  3868,   406,  16,   7, UNI_XPOSIXCNTRL }   /* generalcategory=control */,
  {     1,  8233,  9161,   7,   4, UNI_SC__GONM }   /* script=gonm */,
  {     3,  5760,  7571,  13,   2, UNI_NV__33 }   /* numericvalue=33 */,
  {     1,  3671,  7892,  17,   4, UNI_JAVA }   /* scriptextensions=java */,
  {     3,  5269,     3,  14,   1, -UNI_PATSYN }   /* patternsyntax=f */,
  {     0,  8886,  7844,   3,   8, UNI_SC__GUJR }   /* sc=gujarati */,
  {     2,  8886,  9165,   3,   4, UNI_SC__GREK }   /* sc=grek */,
  {     0,  6005,  8010,   3,   6, UNI_CJKEXTA }   /* incjkexta */,
  {     0,  8424,  7275,   6,   9, UNI_LATINEXTD }   /* block=latinextd */,
  {     1,  4447,    66,  15,   1, UNI_EA__H }   /* eastasianwidth=h */,
  {     1,  5339,     7,  15,   1, UNI_SB__SC }   /* sentencebreak=sc */,
  {     0,  2684,    24,  19,   1, UNI_GCB__L }   /* hangulsyllabletype=l */,
  {     1,  8163,    17,   8,   1, UNI_NFKCQC__N }   /* nfkcqc=no */,
  {     0,  8886,  9425,   3,   4, UNI_THAI }   /* sc=thai */,
  {     2,  8424,  7374,   6,   9, UNI_INSAMARITAN }   /* block=samaritan */,
  {     2,  8332,  7196,   4,   7, UNI_ARABICPFB }   /* isarabicpfb */,
  {     1,  6015,     0,  12,   0, UNI_jt_values_index }   /* joiningtype= */,
  {     3,  9623,  5931,   3,  12, UNI_JG__FINALSEMKATH }   /* jg=finalsemkath */,
  {     0,  9647,  8981,   3,   3, UNI_NV__1_SLASH_4 }   /* nv=1/4 */,
  {     2,  9365,  5955,   4,  12, UNI_GONG }   /* scx=gunjalagondi */,
  {     8,  8332,  3758,   4,  14, UNI_ARABICSUP }   /* isarabicsupplement */,
  {     0,  9659,   995,   3,   2, -UNI_RI }   /* ri=no */,
  {     1,    21,  8568,   2,   6, UNI_INLYDIAN }   /* inlydian */,
  {     4,   184,  8065,   2,   7, UNI_ELBA }   /* iselbasan */,
  {     1,  9647,  7508,   3,   8, UNI_NV__1_SLASH_5 }   /* nv=2.00e-01 */,
  {     5,  9093,  4975,   4,   7, UNI_KANASUP }   /* blk=kanasup */,
  {     0,  8233,  9065,   7,   4, UNI_ARMI }   /* script=armi */,
  {     3,  1136,     0,  26,   0, UNI_di_values_index }   /* defaultignorablecodepoint= */,
  {     3,  8499,     0,   2,   0, UNI_CF }   /* cf */,
  {     4,  3868,     0,  16,   0, UNI_gc_values_index }   /* generalcategory= */,
  {     9,  8240,     0,   7,   0, UNI_SHRD }   /* sharada */,
  {     1,  9093,  2589,   4,  11, UNI_COUNTINGROD }   /* blk=countingrod */,
  {     0,  6949,  4851,   4,  11, UNI_CI }   /* iscaseignorable */,
  {     1,   184,   570,   3,  29, UNI_CJKEXTC }   /* iscjkunifiedideographsextensionc */,
  {     1,  8886,  9249,   3,   4, UNI_MERC }   /* sc=merc */,
  {     1,    21,  9058,   3,   3, UNI_INAHOM }   /* inahom */,
  {     7,  9153,  5346,   4,   2, UNI_WB__EB }   /* gcb=eb */,
  {     2,  8233,  6602,   7,  11, UNI_SC__NAND }   /* script=nandinagari */,
  {     0,  9647,  9741,   3,   2, UNI_NV__44 }   /* nv=44 */,
  {     0,  1801,  9734,  22,   3, UNI_CWU }   /* changeswhenuppercased=yes */,
  {     0,  3951,  2704,   3,  17, UNI_IDST }   /* isidstrinaryoperator */,
  {     0,  8424,   328,   6,  21, UNI_MATHOPERATORS }   /* block=mathematicaloperators */,
  {     4,  2204,  4141,   3,  15, UNI_PO }   /* isotherpunctuation */,
  {     1,  8684,  9433,   5,   4, UNI_POSIXXDIGIT }   /* ahex=true */,
  {     2,  8886,  8699,   3,   5, UNI_BATK }   /* sc=batak */,
  {     2,  1773,     0,   5,   0, UNI_CASED }   /* cased */,
  {     3,   184,   690,   3,  15, UNI_CUNEIFORMNUMBERS }   /* iscuneiformnumbers */,
  {    18,  7018,  9566,  10,   3, UNI_IN__5_DOT_2 }   /* presentin=5.2 */,
  {     2,  3868,  1532,  16,   1, UNI_Z }   /* generalcategory=z */,
  {     4,  9599,    26,   3,   1, UNI_CI }   /* ci=y */,
  {     0,  2212,  3933,   3,  15, UNI_HIGHPUSURROGATES }   /* inhighpusurrogates */,
  {     0,  2589,     0,  19,   0, UNI_COUNTINGROD }   /* countingrodnumerals */,
  {     1,  9365,  2532,   4,   4, UNI_BRAH }   /* scx=brah */,
  {     2,  8233,  8310,   7,   4, UNI_SC__TIRH }   /* script=tirh */,
  {     1,  3868,  5199,  16,  14, UNI_SK }   /* generalcategory=modifiersymbol */,
  {     0,   184,  5835,   2,   5, UNI_BIDIC }   /* isbidic */,
  {     8,  8886,  8254,   3,   7, UNI_SIDD }   /* sc=siddham */,
  {     1,  8844,  8864,   5,   5, -UNI_CWCF }   /* cwcf=false */,
  {     0,   184,  3164,   2,   9, UNI_LATINEXTA }   /* islatinexta */,
  {     2,  9093,  6978,   4,  10, UNI_INOLDPERSIAN }   /* blk=oldpersian */,
  {    26,  8233,  9189,   7,   4, UNI_HMNP }   /* script=hmnp */,
  {     4,  1773,    36,   6,   1, UNI_CASED }   /* cased=t */,
  {     0,  8424,  2232,   6,  21, UNI_YIJING }   /* block=yijinghexagramsymbols */,
  {     1,  9113,  7555,   4,   2, UNI_CCC__23 }   /* ccc=23 */,
  {     3,  9057,     0,   4,   0, UNI_AHOM }   /* ahom */,
  {     5,  8886,  8079,   3,   4, UNI_SC__GRAN }   /* sc=gran */,
  {     0,  7018,  9005,  10,   4, UNI_IN__12_DOT_1 }   /* presentin=12.1 */,
  {     1,  8886,  9053,   3,   4, UNI_AGHB }   /* sc=aghb */,
  {     0,  8886,  7332,   3,   4, UNI_ITAL }   /* sc=ital */,
  {     0,   184,  3772,   2,   8, UNI_BOPO }   /* isbopomofo */,
  {     0,  9779,     0,   2,   0, UNI_ZS }   /* zs */,
  {     1,  8233,  9225,   7,   4, UNI_SC__LINA }   /* script=lina */,
  {     1,   184,    47,   2,   1, UNI_M }   /* ism */,
  {     1,  3110,     0,  18,   0, UNI_GEORGIANSUP }   /* georgiansupplement */,
  {     0,  2532,     0,   6,   0, UNI_BRAH }   /* brahmi */,
  {     0,  3671,  6646,  17,  11, UNI_HMNG }   /* scriptextensions=pahawhhmong */,
  {     0,  8879,  7009,   3,   9, UNI_INPHOENICIAN }   /* inphoenician */,
  {     1,   184,   400,   2,   6, UNI_CF }   /* isformat */,
  {     0,  7347,     0,   9,   0, UNI_ORKH }   /* oldturkic */,
  {     7,  8233,  2127,   7,  14, UNI_SC__ROHG }   /* script=hanifirohingya */,
  {     1,   697,     0,   2,   0, UNI_MN }   /* mn */,
  {     0,  6315,  8864,  12,   5, -UNI_XIDC }   /* xidcontinue=false */,
  {    11,  9909,  9318,   3,   3, UNI_PHLP }   /* isphlp */,
  {     4,  9629,  9154,   3,   2, UNI_LB__CB }   /* lb=cb */,
  {     5,  8424,  7118,   6,  10, UNI_INWARANGCITI }   /* block=warangciti */,
  {     0,  8634,    36,   6,   1, UNI_UIDEO }   /* uideo=t */,
  {     1,   184,  5435,   2,  12, UNI_BIDIM }   /* isbidimirrored */,
  {     1,  1243,  8864,  21,   5, -UNI_CE }   /* compositionexclusion=false */,
  {     3,  8886,  7356,   3,   4, UNI_PALM }   /* sc=palm */,
  {     2,  9605,  3852,   3,   5, UNI_DT__FIN }   /* dt=final */,
  {     0,  3671,  8568,  17,   6, UNI_LYDI }   /* scriptextensions=lydian */,
  {     0,  5435,     3,  13,   1, -UNI_BIDIM }   /* bidimirrored=f */,
  {     2,  6003,   995,  12,   2, -UNI_JOINC }   /* joincontrol=no */,
  {     8,  9365,  8924,   4,   5, UNI_ORYA }   /* scx=oriya */,
  {     1,  5339,   339,  14,   2, UNI_SB__LO }   /* sentencebreak=lo */,
  {     2,  5227,  9734,  14,   3, UNI_NFDQC__Y }   /* nfdquickcheck=yes */,
  {     1,  8550,     0,   4,   0, UNI_LEPC }   /* lepc */,
  {     0,  8568,     0,   4,   0, UNI_LYDI }   /* lydi */,
  {     2,  5565,  9671,  13,   3, UNI_JG__TAH }   /* joininggroup=tah */,
  {     0,  9113,  9524,   4,   3, UNI_CCC__L }   /* ccc=224 */,
  {     0,  4778,  1099,   3,   3, UNI_UCAS }   /* isucas */,
  {     0,  9731,  1164,   3,   2, UNI_LB__LF }   /* wb=lf */,
  {     1,  9093,  5031,   4,  14, UNI_LATINEXTD }   /* blk=latinextendedd */,
  {     2,  9629,  7176,   3,   9, UNI_LB__AI }   /* lb=ambiguous */,
  {     3,  3671,  3620,  17,   4, UNI_MANI }   /* scriptextensions=mani */,
  {     3,  3671,  6246,  17,   4, UNI_HUNG }   /* scriptextensions=hung */,
  {     0,  8886,  8550,   3,   6, UNI_LEPC }   /* sc=lepcha */,
  {     0,  9728,  9734,   3,   3, UNI_VS }   /* vs=yes */,
  {     2,  4705,  8311,   3,   3, UNI_TIRH }   /* istirh */,
  {     3,  8502,     0,   6,   0, UNI_GOTH }   /* gothic */,
  {     2,  9647,  7158,   3,   9, UNI_NV___MINUS_1_SLASH_2 }   /* nv=-5.00e-01 */,
  {     2,  9113,  2920,   4,   5, UNI_CCC__A }   /* ccc=above */,
  {     0,  9731,  5919,   3,  12, UNI_WB__EX }   /* wb=extendnumlet */,
  {     1,  8424,  4717,   6,   8, UNI_TAMILSUP }   /* block=tamilsup */,
  {     0,  9129,  9433,   4,   4, UNI_CWU }   /* cwu=true */,
  {     0,  1812,     0,   9,   0, UNI_XPOSIXUPPER }   /* uppercase */,
  {     0,  9647,  7596,   3,   8, UNI_NV__3_SLASH_80 }   /* nv=3.75e-02 */,
  {     4,  9173,     0,   4,   0, UNI_GURU }   /* guru */,
  {     1,  9365,  9205,   4,   4, UNI_KNDA }   /* scx=knda */,
  {     1,  3756,     0,   9,   0, UNI_ARABICSUP }   /* arabicsup */,
  {     0,  9647,  8394,   3,   6, UNI_NV__800000 }   /* nv=800000 */,
  {     0,  8556,  9433,   6,   4, UNI_XPOSIXLOWER }   /* lower=true */,
  {     0,  1691,     0,  22,   0, UNI_bpt_values_index }   /* bidipairedbrackettype= */,
  {     4,  8496,     1,   6,   1, -UNI_CWKCF }   /* cwkcf=n */,
  {     0,  9093,  2646,   4,  10, UNI_JAMO }   /* blk=hanguljamo */,
  {     5,  3671,  7956,  17,   4, UNI_TAGB }   /* scriptextensions=tagb */,
  {     2,  8233,  4582,   7,  15, UNI_MERC }   /* script=meroiticcursive */,
  {     1,  8233,  2837,   8,   8, UNI_SUND }   /* script=sundanese */,
  {     4,  9365,  9249,   4,   4, UNI_MERC }   /* scx=merc */,
  {    20,  7025,  7098,   3,  10, UNI_AGE__NA }   /* in=unassigned */,
  {     0,  9647,  9569,   3,   3, UNI_NV__5_SLASH_6 }   /* nv=5/6 */,
  {     0,  8170,  9734,   7,   3, UNI_DT__NONE }   /* nfkdqc=yes */,
  {     0,  9623,  5708,   3,  13, UNI_JG__MANICHAEANWAW }   /* jg=manichaeanwaw */,
  {     0,   117,   447,   3,  17, UNI_IDEOGRAPHICSYMBOLS }   /* inideographicsymbols */,
  {    15,  5760,  8364,  13,   2, UNI_NV__40 }   /* numericvalue=40 */,
  {     1,  3868,    27,  16,   2, UNI_LOWERCASELETTER }   /* generalcategory=ll */,
  {     3,  9647,  9037,   3,   4, UNI_NV__5_SLASH_12 }   /* nv=5/12 */,
  {     0,   184,  9349,   2,   4, UNI_ROHG }   /* isrohg */,
  {     2,  8424,  5311,   6,  14, UNI_INPSALTERPAHLAVI }   /* block=psalterpahlavi */,
  {     0,  8332,  1316,   4,  22, UNI_ARABICPFA }   /* isarabicpresentationformsa */,
  {     1,  1497,  7098,   9,  10, UNI_CN }   /* category=unassigned */,
  {     2,  9365,  9421,   4,   4, UNI_TGLG }   /* scx=tglg */,
  {     0,  5760,  7540,  13,   5, UNI_NV__20000 }   /* numericvalue=20000 */,
  {     6,  9097,  5678,   4,   4, UNI_BPT__N }   /* bpt=none */,
  {     7,  4778,   513,   3,  15, UNI_UIDEO }   /* isunifiedideograph */,
  {     1,   184,    43,   3,   2, UNI_CJK }   /* iscjk */,
  {     0,  3739,    36,  17,   1, UNI_UIDEO }   /* unifiedideograph=t */,
  {     3,  8424,  8310,   6,   7, UNI_INTIRHUTA }   /* block=tirhuta */,
  {     1,  9093,  8149,   4,   7, UNI_INMULTANI }   /* blk=multani */,
  {     4,  9365,  8310,   4,   4, UNI_TIRH }   /* scx=tirh */,
  {     4,  1497,  6635,   9,  11, UNI_SO }   /* category=othersymbol */,
  {     1,  6918,  6848,  10,  10, UNI_LB__BA }   /* linebreak=breakafter */,
  {     1,   184,  8052,   3,   5, UNI_COMPEX }   /* iscompex */,
  {     6,  8233,  7329,   7,   9, UNI_ITAL }   /* script=olditalic */,
  {     2,  9629,  5520,   3,   5, UNI_LB__EB }   /* lb=ebase */,
  {     0,  9093,   349,   4,  33, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* blk=supplementalsymbolsandpictographs */,
  {     1,  3128,     1,  18,   1, -UNI_IDSB }   /* idsbinaryoperator=n */,
  {     5,   184,  5513,   2,  12, UNI_GRBASE }   /* isgraphemebase */,
  {     6,  8233,  8079,   7,   4, UNI_SC__GRAN }   /* script=gran */,
  {     1,  2148,  8276,   3,   6, UNI_SUPPUAB }   /* insuppuab */,
  {     1,   184,  7788,   2,   8, UNI_BALI }   /* isbalinese */,
  {     0,  5213,    47,  14,   1, UNI_NFCQC__M }   /* nfcquickcheck=m */,
  {     0,  8886,  9481,   3,   4, UNI_ZANB }   /* sc=zanb */,
  {     0,  6918,  3248,  10,   5, UNI_LB__SP }   /* linebreak=space */,
  {     1,  9365,  6246,   4,   4, UNI_HUNG }   /* scx=hung */,
  {     0,   184,  1977,   2,  21, UNI__PERL_NCHAR }   /* isnoncharactercodepoint */,
  {     0,  9141,     0,   4,   0, UNI_dia_values_index }   /* dia= */,
  {     3,  6005,  8031,   3,   6, UNI_CJKEXTD }   /* incjkextd */,
  {     3,   184,  1846,   3,  21, UNI_INDICNUMBERFORMS }   /* iscommonindicnumberforms */,
  {     1,  6828,  3608,  10,   3, UNI_BC__RLI }   /* bidiclass=rli */,
  {     1,  6315,     0,  12,   0, UNI_xidc_values_index }   /* xidcontinue= */,
  {    16,  9602,     3,   3,   1, -UNI_DI }   /* di=f */,
  {     1,  5760,  7691,  13,   2, UNI_NV__36 }   /* numericvalue=36 */,
  {     4,  4492,     0,  15,   0, UNI_ARMI }   /* imperialaramaic */,
  {     0,  9605,  1279,   3,   3, UNI_DT__SUB }   /* dt=sub */,
  {     0,  2148,  7069,   3,   9, UNI_SUPARROWSA }   /* insuparrowsa */,
  {     0,   184,   983,   2,   5, UNI_GREK }   /* isgreek */,
  {     1,  8332,  7187,   4,   7, UNI_ARABICPFA }   /* isarabicpfa */,
  {     0,   598,     0,   2,   0, UNI_XPOSIXCNTRL }   /* cc */,
  {     2,  9093,  1823,   4,  22, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* blk=cjkcompatideographssup */,
  {     0,  7302,     0,   9,   0, UNI_NBAT }   /* nabataean */,
  {     1,  9623,  4028,   3,  16, UNI_JG__MANICHAEANLAMEDH }   /* jg=manichaeanlamedh */,
  {     4,  8233,  8699,   7,   5, UNI_BATK }   /* script=batak */,
  {    13,  8233,  9349,   7,   4, UNI_SC__ROHG }   /* script=rohg */,
  {     6,   184,  4204,   2,  16, UNI_SYRIACSUP }   /* issyriacsupplement */,
  {     0,  8899,    26,   5,   1, UNI_MATH }   /* math=y */,
  {     0,  8233,  9201,   7,   4, UNI_KHMR }   /* script=khmr */,
  {     0,  3739,  9433,  17,   4, UNI_UIDEO }   /* unifiedideograph=true */,
  {     5,  6828,     1,  11,   1, UNI_BC__BN }   /* bidiclass=bn */,
  {     5,  9623,  9341,   3,   4, UNI_JG__QAPH }   /* jg=qaph */,
  {     8,  8233,  8121,   7,   7, UNI_SC__LINA }   /* script=lineara */,
  {     0,  3243,     0,  10,   0, UNI_XPOSIXSPACE }   /* whitespace */,
  {     0,  1362,  8371,  24,   2, UNI_CCC__32 }   /* canonicalcombiningclass=32 */,
  {     0,    78,     0,   4,   0, UNI_ARAB }   /* arab */,
  {     1,  9593,   407,   3,   2, UNI_BC__ON }   /* bc=on */,
  {     5,  4826,     0,   8,   0, UNI_XPOSIXXDIGIT }   /* hexdigit */,
  {     1,  8424,  8502,   6,   6, UNI_INGOTHIC }   /* block=gothic */,
  {     0,  1362,  8473,  25,   5, UNI_CCC__132 }   /* canonicalcombiningclass=ccc132 */,
  {     0,  8424,  6988,   6,  10, UNI_INOLDSOGDIAN }   /* block=oldsogdian */,
  {     2,  8652,     0,   6,   0, UNI_WCHO }   /* wancho */,
  {     2,  8233,  3836,   7,   7, UNI_SC__CPRT }   /* script=cypriot */,
  {     0,  3671,  2837,  18,   3, UNI_SUND }   /* scriptextensions=sund */,
  {     0,  6338,     3,  11,   1, -UNI_XPOSIXALPHA }   /* alphabetic=f */,
  {     0,  5979,     0,  12,   0, UNI_ideo_values_index }   /* ideographic= */,
  {     0,  5565,  8658,  13,   4, UNI_JG__YUDH }   /* joininggroup=yudh */,
  {     1,   184,   600,   3,  29, UNI_CJKEXTD }   /* iscjkunifiedideographsextensiond */,
  {     1,  6005,    43,   3,   8, UNI_CJKCOMPAT }   /* incjkcompat */,
  {     0,  9093,  8514,   4,   6, UNI_INHATRAN }   /* blk=hatran */,
  {     1,  2204,  8925,   3,   4, UNI_ORYA }   /* isoriya */,
  {    12,  9093,  3773,   5,  15, UNI_BOPOMOFOEXT }   /* blk=bopomofoextended */,
  {     2,  6918,  9626,  10,   2, UNI_GCB__T }   /* linebreak=jt */,
  {     1,  9946,  2837,   3,   8, UNI_SUND }   /* issundanese */,
  {     0,  9647,  8364,   3,   6, UNI_NV__400000 }   /* nv=400000 */,
  {     0,  8886,  9389,   3,   4, UNI_SOGO }   /* sc=sogo */,
  {     0,  9113,  7435,   4,   2, UNI_CCC__11 }   /* ccc=11 */,
  {     1,  5760,  7158,  13,   9, UNI_NV___MINUS_1_SLASH_2 }   /* numericvalue=-5.00e-01 */,
  {     1,  9093,   779,   4,  29, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* blk=enclosedideographicsupplement */,
  {     0,  4762,     0,   8,   0, UNI_VEDICEXT }   /* vedicext */,
  {     0,   184,  7257,   2,   9, UNI_LATINEXTB }   /* islatinextb */,
  {     3,  9629,  6437,   3,  11, UNI_LB__EX }   /* lb=exclamation */,
  {     2,   184,  5367,   2,  14, UNI_SUPPUNCTUATION }   /* issuppunctuation */,
  {     0,  9365,  7118,   4,   4, UNI_WARA }   /* scx=wara */,
  {     7,  7018,  9551,  10,   3, UNI_IN__3_DOT_2 }   /* presentin=3.2 */,
  {     0,  9593,  4283,   4,  14, UNI_BC__BN }   /* bc=boundaryneutral */,
  {     1,  4267,     0,   8,   0, UNI_BAMUMSUP }   /* bamumsup */,
  {     2,  9365,  7995,   4,   7, UNI_AVST }   /* scx=avestan */,
  {     6,  9662,    26,   3,   1, UNI_SD }   /* sd=y */,
  {     3,  3671,  7356,  17,   9, UNI_PALM }   /* scriptextensions=palmyrene */,
  {     9,  9113,  7683,   4,   2, UNI_CCC__26 }   /* ccc=26 */,
  {     0,  9169,     0,   4,   0, UNI_GUJR }   /* gujr */,
  {     3,  9909,     0,  12,   0, UNI_POSIXBLANK }   /* isposixblank */,
  {     1,  7419,    36,   9,   1, UNI_XIDS }   /* xidstart=t */,
  {     0,  8233,  7008,   7,  10, UNI_PHNX }   /* script=phoenician */,
  {     1,  9153,    34,   4,   6, UNI_GCB__EX }   /* gcb=extend */,
  {     2,  9365,  2333,   4,   4, UNI_GLAG }   /* scx=glag */,
  {    12,  8233,  9229,   7,   4, UNI_SC__LINB }   /* script=linb */,
  {     2,   184,  2931,   3,  17, UNI_CHEROKEESUP }   /* ischerokeesupplement */,
  {     8,  8684,     1,   5,   1, -UNI_POSIXXDIGIT }   /* ahex=n */,
  {     0,  3671,  8002,  17,   7, UNI_BENG }   /* scriptextensions=bengali */,
  {     4,  8424,  8568,   6,   6, UNI_INLYDIAN }   /* block=lydian */,
  {     2,  8233,  8191,   7,   7, UNI_OLCK }   /* script=olchiki */,
  {     0,  3671,  1192,  17,   4, UNI_KANA }   /* scriptextensions=kana */,
  {     0,  9593,   835,   3,   2, UNI_BC__WS }   /* bc=ws */,
  {     1,   184,  3980,   2,  16, UNI_LINEARBIDEOGRAMS }   /* islinearbideograms */,
  {    13,  5325,    26,  14,   1, UNI_QMARK }   /* quotationmark=y */,
  {     0,  1773,    26,   6,   1, UNI_CASED }   /* cased=y */,
  {     0,  6316,    26,  11,   1, UNI_IDC }   /* idcontinue=y */,
  {     3,  9093,  2169,   4,  14, UNI_MEETEIMAYEKEXT }   /* blk=meeteimayekext */,
  {     2,  9365,  2006,   4,   4, UNI_MODI }   /* scx=modi */,
  {     2,  8233,  3984,   8,   3, UNI_SARB }   /* script=sarb */,
  {     5,  9935,  3248,   5,   5, UNI_XPOSIXSPACE }   /* xperlspace */,
  {     0,  9629,  6968,   3,  10, UNI_LB__NS }   /* lb=nonstarter */,
  {     1,  9141,   995,   4,   2, -UNI_DIA }   /* dia=no */,
  {     1,  1084,    26,  26,   1, UNI_CWKCF }   /* changeswhennfkccasefolded=y */,
  {    14,  9593,    32,   3,   2, UNI_BC__CS }   /* bc=cs */,
  {     0,  9093,  3290,   4,   4, UNI_RUMI }   /* blk=rumi */,
  {     8,  8886,   829,   4,   3, UNI_SC__KNDA }   /* sc=knda */,
  {     1,  4717,     0,   8,   0, UNI_TAMILSUP }   /* tamilsup */,
  {     1,  9946,  6992,   3,   3, UNI_SOGD }   /* issogd */,
  {     2,  1362,  8835,  25,   4, UNI_CCC__91 }   /* canonicalcombiningclass=ccc91 */,
  {     1,  7128,  5625,  10,   2, UNI_WB__ML }   /* wordbreak=ml */,
  {     3,  3002,  1279,  18,   3, UNI_DT__SUB }   /* decompositiontype=sub */,
  {     0,  3290,     0,   4,   0, UNI_RUMI }   /* rumi */,
  {     2,  1362,  6404,  24,  11, UNI_CCC__DB }   /* canonicalcombiningclass=doublebelow */,
  {     4,  3210,     0,   8,   0, UNI_DINGBATS }   /* dingbats */,
  {     5,  9365,  2127,   4,  14, UNI_ROHG }   /* scx=hanifirohingya */,
  {     2,  5760,  9037,  13,   4, UNI_NV__5_SLASH_12 }   /* numericvalue=5/12 */,
  {     5,  6567,   287,   6,  29, UNI_MISCMATHSYMBOLSB }   /* inmiscellaneousmathematicalsymbolsb */,
  {     0,  8412,  9734,   6,   3, UNI_BIDIC }   /* bidic=yes */,
  {     1,  9093,  1622,   4,  14, UNI_LATINEXTA }   /* blk=latinextendeda */,
  {     0,  3705,     0,  17,   0, UNI_SMALLFORMS }   /* smallformvariants */,
  {     1,  1362,  3441,  24,   9, UNI_CCC__BL }   /* canonicalcombiningclass=belowleft */,
  {     1,  7844,     0,   8,   0, UNI_GUJR }   /* gujarati */,
  {     8,  8233,  2532,   7,   6, UNI_BRAH }   /* script=brahmi */,
  {     0,  9465,     0,   4,   0, UNI_XPEO }   /* xpeo */,
  {     5,  6567,   206,   6,  11, UNI_MISCPICTOGRAPHS }   /* inmiscpictographs */,
  {     2,  9093,  7812,   4,   8, UNI_INDUPLOYAN }   /* blk=duployan */,
  {     0,  1924,     0,  10,   1, UNI_UPPERCASELETTER }   /* category=lu */,
  {    11,  3671,  7375,  18,   8, UNI_SAMR }   /* scriptextensions=samaritan */,
  {     1,  8424,  7365,   6,   9, UNI_INPAUCINHAU }   /* block=paucinhau */,
  {     1,  9623,  5073,   3,  14, UNI_JG__MANICHAEANAYIN }   /* jg=manichaeanayin */,
  {     2,  5339,   495,  14,   7, UNI_SB__NU }   /* sentencebreak=numeric */,
  {     0,  6768,  4994,   3,   9, UNI_YIRADICALS }   /* isyiradicals */,
  {     0,  2127,     0,   4,   0, UNI_HAN }   /* hani */,
  {     6,  8233,  9281,   7,   4, UNI_NEWA }   /* script=newa */,
  {     0,  3964,     0,  16,   0, UNI_LATIN1 }   /* latin1supplement */,
  {     2,  6828,     8,  10,   2, UNI_BC__AN }   /* bidiclass=an */,
  {     0,  8424,  8142,   6,   7, UNI_INMARCHEN }   /* block=marchen */,
  {     0,  8886,  9317,   3,   4, UNI_SC__PHLP }   /* sc=phlp */,
  {     0,  5809,     0,   2,   0, UNI_PF }   /* pf */,
  {     0,  8424,    43,   7,  35, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* block=cjkcompatibilityideographssupplement */,
  {     4,   184,  6279,   2,  12, UNI_PLAYINGCARDS }   /* isplayingcards */,
  {     0,  9093,  8016,   4,   7, UNI_CJKEXTB }   /* blk=cjkextb */,
  {     0,  2238,     0,   3,   0, UNI_XPOSIXXDIGIT }   /* hex */,
  {     0,  9623,  4562,   3,   5, UNI_JG__SADHE }   /* jg=sadhe */,
  {     6,  8886,  8128,   3,   4, UNI_MAKA }   /* sc=maka */,
  {     2,   184,  9333,   2,   4, UNI_COPT }   /* isqaac */,
  {     1,  9623,  8964,   3,   5, UNI_JG__ZHAIN }   /* jg=zhain */,
  {     1,  9593,  9653,   3,   3, UNI_BC__PDF }   /* bc=pdf */,
  {     2,  9093,  4717,   4,   5, UNI_INTAMIL }   /* blk=tamil */,
  {     0,  5565,  5669,  13,  13, UNI_JG__MANICHAEANONE }   /* joininggroup=manichaeanone */,
  {     8,  8879,  2473,   5,   3, UNI_INPC__TOP }   /* inpc=top */,
  {     6,  9731,   125,   3,   2, UNI_LB__CR }   /* wb=cr */,
  {     1,   184,  3552,   2,  16, UNI_ETHIOPICEXT }   /* isethiopicextended */,
  {     1,  6885,  1086,   3,   3, UNI_HANG }   /* ishang */,
  {     4,  8886,  1599,   3,   6, UNI_SC__HANG }   /* sc=hangul */,
  {     4,  8233,  9253,   7,   4, UNI_MIAO }   /* script=miao */,
  {     1,  3398,    26,  18,   1, UNI_VS }   /* variationselector=y */,
  {     0,  7018,  9701,  10,   3, UNI_IN__5_DOT_2 }   /* presentin=v52 */,
  {     1,  9608,  1174,   3,   9, UNI_EA__F }   /* ea=fullwidth */,
  {    12,  8960,    36,   4,   1, UNI_IDS }   /* ids=t */,
  {     0,  3671,  9277,  17,   4, UNI_NBAT }   /* scriptextensions=nbat */,
  {     0,  3671,  8502,  17,   4, UNI_GOTH }   /* scriptextensions=goth */,
  {     1,  3671,  9305,  17,   4, UNI_ORYA }   /* scriptextensions=orya */,
  {     1,  7221,     0,   9,   0, UNI_EMOTICONS }   /* emoticons */,
  {     3,  9629,   414,   3,  11, UNI_LB__ID }   /* lb=ideographic */,
  {     6,   512,     0,  16,   0, UNI_UIDEO }   /* unifiedideograph */,
  {    32,  3868,    32,  16,   2, UNI__PERL_SURROGATE }   /* generalcategory=cs */,
  {     0,  8418,    36,   6,   1, UNI_BIDIM }   /* bidim=t */,
  {     2,  3002,  2493,  18,   8, UNI_DT__VERT }   /* decompositiontype=vertical */,
  {     9,  6928,  8864,  10,   5, -UNI_XPOSIXLOWER }   /* lowercase=false */,
  {     2,  8849,    36,   5,   1, UNI_CWCM }   /* cwcm=t */,
  {     0,  5565,  6701,  13,  11, UNI_JG__STRAIGHTWAW }   /* joininggroup=straightwaw */,
  {     1,  9623,  4954,   3,   3, UNI_JG__HEH }   /* jg=heh */,
  {     0,   184,  3884,   2,  11, UNI_GEORGIANEXT }   /* isgeorgianext */,
  {     2,  8879,  6268,   3,   7, UNI_PHAISTOS }   /* inphaistos */,
  {     0,  8886,  7118,   3,   4, UNI_WARA }   /* sc=wara */,
  {     0,  6918,    83,  10,   2, UNI_LB__CM }   /* linebreak=cm */,
  {     3,   117,  1853,   4,  14, UNI_INDICNUMBERFORMS }   /* inindicnumberforms */,
  {     1,  1497,  4747,   9,  15, UNI_UPPERCASELETTER }   /* category=uppercaseletter */,
  {     0,  4961,     0,  14,   0, UNI_HIGHSURROGATES }   /* highsurrogates */,
  {     2,  8233,  9277,   7,   4, UNI_NBAT }   /* script=nbat */,
  {     2,  3518,     0,  17,   0, UNI_CYRILLICEXTB }   /* cyrillicextendedb */,
  {     9,  1911,  3948,  22,  16, UNI_INSC__INVISIBLESTACKER }   /* indicsyllabiccategory=invisiblestacker */,
  {     2,  3671,  9317,  17,   4, UNI_PHLP }   /* scriptextensions=phlp */,
  {     0,  5617,     0,   9,   0, UNI_MLYM }   /* malayalam */,
  {     6,  5760,  8669,  13,   5, UNI_NV__1_SLASH_320 }   /* numericvalue=1/320 */,
  {     0,  3868,  4687,  16,  15, UNI_PS }   /* generalcategory=openpunctuation */,
  {     9,  9093,  4172,   4,  16, UNI_SUPMATHOPERATORS }   /* blk=supmathoperators */,
  {     2,  9093,  8538,   4,   6, UNI_INKHOJKI }   /* blk=khojki */,
  {     1,  8635,  9433,   5,   4, UNI_IDEO }   /* ideo=true */,
  {     1,  4826,   995,   9,   2, -UNI_XPOSIXXDIGIT }   /* hexdigit=no */,
  {     0,  3671,  7356,  17,   4, UNI_PALM }   /* scriptextensions=palm */,
  {     4,  3671,  1085,  17,   4, UNI_HANG }   /* scriptextensions=hang */,
  {     4,  9093,  4863,   4,  14, UNI_CJKCOMPATFORMS }   /* blk=cjkcompatforms */,
  {     1,  9909,    62,   7,   5, UNI_POSIXGRAPH }   /* isposixgraph */,
  {     1,  3552,     0,  17,   0, UNI_ETHIOPICEXTA }   /* ethiopicextendeda */,
  {     0,  8939,     0,   5,   0, UNI_TALE }   /* taile */,
  {     0,  8424,  2931,   7,  17, UNI_CHEROKEESUP }   /* block=cherokeesupplement */,
  {     3,   184,   878,   2,  14, UNI_PUA }   /* isprivateusearea */,
  {     0,  8142,     0,   4,   0, UNI_MARC }   /* marc */,
  {     0,   183,     0,  34,   0, UNI_MISCPICTOGRAPHS }   /* miscellaneoussymbolsandpictographs */,
  {     2,  9113,  8832,   4,   2, UNI_CCC__84 }   /* ccc=84 */,
  {    13,  9093,  8142,   4,   7, UNI_INMARCHEN }   /* blk=marchen */,
  {     4,  3671,  8255,  18,   6, UNI_SIDD }   /* scriptextensions=siddham */,
  {     0,  4361,  3095,   5,  15, UNI_INPUNCTUATION }   /* ingeneralpunctuation */,
  {     4,  1362,  8822,  24,   2, UNI_CCC__35 }   /* canonicalcombiningclass=35 */,
  {     0,  6885,  2647,   3,   9, UNI_JAMO }   /* ishanguljamo */,
  {     1,  4076,     0,  16,   0, UNI_MISCMATHSYMBOLSA }   /* miscmathsymbolsa */,
  {     0,  9113,  7507,   4,   2, UNI_CCC__12 }   /* ccc=12 */,
  {     0,  8332,  8680,   3,   4, UNI_ADLM }   /* isadlam */,
  {     0,  8886,  4108,   3,   7, UNI_SC__MYMR }   /* sc=myanmar */,
  {     4,  9093,  1531,   5,  22, UNI_BYZANTINEMUSIC }   /* blk=byzantinemusicalsymbols */,
  {     0,  8424,  5721,   6,  13, UNI_MAYANNUMERALS }   /* block=mayannumerals */,
  {     0,  8598,    26,   6,   1, UNI__PERL_PATWS }   /* patws=y */,
  {    22,  3671,  6691,  18,  10, UNI_SORA }   /* scriptextensions=sorasompeng */,
  {     1,  9731,   108,   3,   2, UNI_WB__MB }   /* wb=mb */,
  {     1,  8338,    36,   7,   1, UNI_XPOSIXSPACE }   /* wspace=t */,
  {    19,  8233,  8502,   7,   4, UNI_GOTH }   /* script=goth */,
  {     1,  1362,  8451,  24,   3, UNI_CCC__118 }   /* canonicalcombiningclass=118 */,
  {     4,  9620,  2192,   3,   2, UNI_PD }   /* gc=pd */,
  {     3,  3671,  8894,  17,   4, UNI_LIMB }   /* scriptextensions=limb */,
  {     2,    21,  3964,   2,   6, UNI_LATIN1 }   /* inlatin1 */,
  {     0,  9093,  1668,   4,  23, UNI_SUPPUNCTUATION }   /* blk=supplementalpunctuation */,
  {     0,  8261,     0,   7,   0, UNI_SOYO }   /* soyombo */,
  {     6,  5760,  7492,  13,   8, UNI_NV__1_SLASH_6 }   /* numericvalue=1.67e-01 */,
  {     0,  8886,  7892,   3,   4, UNI_SC__JAVA }   /* sc=java */,
  {     0,  8424,  1314,   6,  24, UNI_ARABICPFA }   /* block=arabicpresentationformsa */,
  {     2,   184,  4124,   2,  16, UNI_MYANMAREXTB }   /* ismyanmarextendedb */,
  {     0,  9125,     0,   3,   0, UNI_CWT }   /* cwt */,
  {     2,   184,  7313,   3,   2, UNI_CWT }   /* iscwt */,
  {    16,  5565,  5171,  13,  14, UNI_JG__MANICHAEANTETH }   /* joininggroup=manichaeanteth */,
  {     2,  9623,  4060,   3,  16, UNI_JG__MANICHAEANTWENTY }   /* jg=manichaeantwenty */,
  {     0,  1497,  3820,   9,  16, UNI_PE }   /* category=closepunctuation */,
  {     0,   184,  5604,   2,  13, UNI_LOWSURROGATES }   /* islowsurrogates */,
  {     0,  8296,     0,   7,   0, UNI_TAVT }   /* taiviet */,
  {     6,  9113,  8455,   5,   5, UNI_CCC__122 }   /* ccc=ccc122 */,
  {     1,   184,  7374,   2,   9, UNI_SAMR }   /* issamaritan */,
  {     1,  9093,  8430,   4,   6, UNI_INCARIAN }   /* blk=carian */,
  {     1,  7018,  7548,  10,   3, UNI_IN__3_DOT_1 }   /* presentin=3.1 */,
  {     0,  8886,  9453,   3,   3, UNI_VAI }   /* sc=vai */,
  {     1,  8886,    78,   3,   6, UNI_SC__ARAB }   /* sc=arabic */,
  {     2,  8508,     1,   6,   1, -UNI_GREXT }   /* grext=n */,
  {    13,  8871,   112,   3,   2, UNI_SB__SC }   /* sb=sc */,
  {     1,  3002,   719,  18,   3, UNI_DT__ENC }   /* decompositiontype=enc */,
  {    11,  1136,   995,  26,   2, -UNI_DI }   /* defaultignorablecodepoint=no */,
  {     0,  9113,  8449,   5,   4, UNI_CCC__11 }   /* ccc=ccc11 */,
  {     1,  9113,  8464,   4,   2, UNI_CCC__29 }   /* ccc=29 */,
  {     0,  9593,    18,   3,   1, UNI_BC__R }   /* bc=r */,
  {     0,  5325,    36,  14,   1, UNI_QMARK }   /* quotationmark=t */,
  {     4,  1362,  9077,  24,   3, UNI_CCC__202 }   /* canonicalcombiningclass=atb */,
  {     0,  8233,  9317,   7,   4, UNI_SC__PHLP }   /* script=phlp */,
  {     8,  8424,  5526,   6,   8, UNI_GREEKEXT }   /* block=greekext */,
  {    13,  9620,    74,   3,   2, UNI_ME }   /* gc=me */,
  {     0,  1911,  6219,  22,  12, UNI_INSC__NUMBERJOINER }   /* indicsyllabiccategory=numberjoiner */,
  {     2,  9093,  3552,   4,  17, UNI_ETHIOPICEXTA }   /* blk=ethiopicextendeda */,
  {     0,  9623,  6123,   3,  12, UNI_JG__MALAYALAMSSA }   /* jg=malayalamssa */,
  {     1,  6246,     0,   4,   0, UNI_HUNG }   /* hung */,
  {     0,  3868,  4732,  16,  15, UNI_TITLE }   /* generalcategory=titlecaseletter */,
  {     2,  9629,   721,   3,   2, UNI_LB__CL }   /* lb=cl */,
  {     1,  9623,  5143,   3,  14, UNI_JG__MANICHAEANQOPH }   /* jg=manichaeanqoph */,
  {     0,   184,     2,   3,   1, UNI_CI }   /* isci */,
  {     2,  8424,  8679,   6,   5, UNI_INADLAM }   /* block=adlam */,
  {     8,   184,  3772,   2,  16, UNI_BOPOMOFOEXT }   /* isbopomofoextended */,
  {     8,  5435,     0,   5,   0, UNI_BIDIM }   /* bidim */,
  {     0,  3722,     0,  17,   0, UNI_SUTTONSIGNWRITING }   /* suttonsignwriting */,
  {     0,  8510,    26,   4,   1, UNI_EXT }   /* ext=y */,
  {     0,  8871,   339,   3,   2, UNI_SB__LO }   /* sb=lo */,
  {     0,   184,  9173,   2,   4, UNI_GURU }   /* isguru */,
  {     5,  6885,  1600,   3,  22, UNI_COMPATJAMO }   /* ishangulcompatibilityjamo */,
  {     1,  8886,  3110,   3,   8, UNI_SC__GEOR }   /* sc=georgian */,
  {     5,  9365,  9349,   4,   4, UNI_ROHG }   /* scx=rohg */,
  {     2,   184,  7078,   2,  10, UNI_SUPARROWSB }   /* issuparrowsb */,
  {     2,  8886,  1845,   3,   6, UNI_SC__ZYYY }   /* sc=common */,
  {     0,  5339,    72,  14,   2, UNI_SB__LE }   /* sentencebreak=le */,
  {     0,  8640,  9433,   6,   4, UNI_XPOSIXUPPER }   /* upper=true */,
  {     2,  9093,  3586,   4,  17, UNI_INDICSIYAQNUMBERS }   /* blk=indicsiyaqnumbers */,
  {     1,  9365,  8128,   4,   7, UNI_MAKA }   /* scx=makasar */,
  {     1,  7025,  5409,   3,   2, UNI_IN__10 }   /* in=10 */,
  {     2,  9093,  8135,   4,   7, UNI_INMANDAIC }   /* blk=mandaic */,
  {     0,  9093,  5003,   4,  14, UNI_LATINEXTB }   /* blk=latinextendedb */,
  {     0,  6567,   254,   6,  29, UNI_MISCMATHSYMBOLSA }   /* inmiscellaneousmathematicalsymbolsa */,
  {     6,  4717,     0,   5,   0, UNI_TAML }   /* tamil */,
  {     0,  8424,  3110,   6,   8, UNI_INGEORGIAN }   /* block=georgian */,
  {    17,  9623,  5381,   3,  10, UNI_JG__TEHMARBUTA }   /* jg=tehmarbuta */,
  {     1,  4778,  4748,   3,  14, UNI_UPPERCASELETTER }   /* isuppercaseletter */,
  {     3,  1362,  7763,  24,   2, UNI_CCC__19 }   /* canonicalcombiningclass=19 */,
  {     1,  8233,  7203,   7,   9, UNI_BHKS }   /* script=bhaiksuki */,
  {     0,  2106,  5520,  21,   5, UNI_WB__EB }   /* graphemeclusterbreak=ebase */,
  {     5,  9113,  8457,   4,   3, UNI_CCC__122 }   /* ccc=122 */,
  {     1,  8886,  9457,   3,   4, UNI_WCHO }   /* sc=wcho */,
  {     7,  3868,  4507,  16,  15, UNI_LOWERCASELETTER }   /* generalcategory=lowercaseletter */,
  {     1,  9093,  3416,   4,  17, UNI_ALCHEMICAL }   /* blk=alchemicalsymbols */,
  {     1,  5760,  8400,  13,   2, UNI_NV__90 }   /* numericvalue=90 */,
  {     4,  8332,  5423,   3,  12, UNI_AEGEANNUMBERS }   /* isaegeannumbers */,
  {     5,  5760,  7644,  13,   8, UNI_NV__11_SLASH_2 }   /* numericvalue=5.50e+00 */,
  {     0,  8424,  9253,   6,   4, UNI_INMIAO }   /* block=miao */,
  {     2,  6885,    34,   3,   2, UNI_XPOSIXXDIGIT }   /* ishex */,
  {     0,   382,     0,  32,   0, UNI_EGYPTIANHIEROGLYPHFORMATCONTROLS }   /* egyptianhieroglyphformatcontrols */,
  {     0,  8424,  3308,   6,  12, UNI_SMALLKANAEXT }   /* block=smallkanaext */,
  {     1,  8496,    36,   6,   1, UNI_CWKCF }   /* cwkcf=t */,
  {     1,  9397,     0,   4,   0, UNI_TAGS }   /* tags */,
  {     0,  4933,     0,  14,   0, UNI_INGREEK }   /* greekandcoptic */,
  {     8,  8844,     1,   5,   1, -UNI_CWCF }   /* cwcf=n */,
  {     0,   184,  9261,   2,   4, UNI_MRO }   /* ismroo */,
  {     2,  9365,  9169,   4,   4, UNI_GUJR }   /* scx=gujr */,
  {     0,  1362,  8352,  24,   3, UNI_CCC__216 }   /* canonicalcombiningclass=216 */,
  {     0,  9365,  7812,   4,   8, UNI_DUPL }   /* scx=duployan */,
  {     2,  8100,    36,   7,   1, UNI_HYPHEN }   /* hyphen=t */,
  {    16,  9623,  4038,   3,   3, UNI_JG__LAM }   /* jg=lam */,
  {     4,  1497,    45,   9,   2, UNI_CO }   /* category=co */,
  {     0,  8233,   493,   7,   3, UNI_SC__HAN }   /* script=han */,
  {     4,  3868,  4140,  16,   5, UNI_C }   /* generalcategory=other */,
  {     1,   184,  3964,   2,   9, UNI_LATIN1 }   /* islatin1sup */,
  {     1,  9049,  7508,   4,   3, UNI_AGE__2 }   /* age=2.0 */,
  {     2,  9620,   206,   3,   2, UNI_PI }   /* gc=pi */,
  {     0,  8424,  8065,   6,   7, UNI_INELBASAN }   /* block=elbasan */,
  {     4,  5325,  8864,  14,   5, -UNI_QMARK }   /* quotationmark=false */,
  {     3,  5513,     0,  13,   0, UNI_grbase_values_index }   /* graphemebase= */,
  {     1,  9113,    24,   4,   1, UNI_CCC__L }   /* ccc=l */,
  {     7,  7018,  9698,  10,   3, UNI_IN__5_DOT_1 }   /* presentin=v51 */,
  {     0,  1192,     0,   4,   0, UNI_KANA }   /* kana */,
  {     8,  8233,  9169,   7,   4, UNI_SC__GUJR }   /* script=gujr */,
  {     0,  1576,     0,  15,   0, UNI_GEOMETRICSHAPES }   /* geometricshapes */,
  {     4,  9629,  9757,   3,   2, UNI_LB__H2 }   /* lb=h2 */,
  {     1,  6003,    26,  12,   1, UNI_JOINC }   /* joincontrol=y */,
  {     1,  8960,    26,   4,   1, UNI_IDS }   /* ids=y */,
  {     0,  9093,  7329,   4,   9, UNI_INOLDITALIC }   /* blk=olditalic */,
  {     1,  9305,     0,   4,   0, UNI_ORYA }   /* orya */,
  {    11,  8959,  8864,   5,   5, -UNI_XIDS }   /* xids=false */,
  {    20,  5760,  8358,  13,   6, UNI_NV__300000 }   /* numericvalue=300000 */,
  {     0,  9623,  5171,   3,  14, UNI_JG__MANICHAEANTETH }   /* jg=manichaeanteth */,
  {     8,  9620,  9777,   3,   2, UNI_ZP }   /* gc=zp */,
  {     4,  9728,     3,   3,   1, -UNI_VS }   /* vs=f */,
  {     0,  6918,  4195,  10,   9, UNI_LB__EM }   /* linebreak=emodifier */,
  {     1,  8879,  2479,   5,  14, UNI_INPC__BOTTOMANDRIGHT }   /* inpc=bottomandright */,
  {     0,  9365,  7329,   4,   9, UNI_ITAL }   /* scx=olditalic */,
  {     0,  5721,     0,  13,   0, UNI_MAYANNUMERALS }   /* mayannumerals */,
  {     3,  3326,     0,  11,   0, UNI_TAIXUANJING }   /* taixuanjing */,
  {     2,  1362,     0,  24,   0, UNI_ccc_values_index }   /* canonicalcombiningclass= */,
  {     0,  8622,     0,   4,   0, UNI_TELU }   /* telu */,
  {     6,  4462,   995,  15,   2, -UNI_GREXT }   /* graphemeextend=no */,
  {     2,  7108,     0,  10,   0, UNI_upper_values_index }   /* uppercase= */,
  {    16,  3671,  3110,  17,   8, UNI_GEOR }   /* scriptextensions=georgian */,
  {     6,   184,  1955,   2,  22, UNI_MISCTECHNICAL }   /* ismiscellaneoustechnical */,
  {     0,  8233,  9321,   7,   4, UNI_PHNX }   /* script=phnx */,
  {     9,  9049,  9441,   4,   4, UNI_AGE__11 }   /* age=v110 */,
  {     8,  8233,  7311,   7,   9, UNI_TALU }   /* script=newtailue */,
  {     1,  6885,  1163,   3,  25, UNI_HALFANDFULLFORMS }   /* ishalfwidthandfullwidthforms */,
  {     2,  9113,  5410,   4,   1, UNI_CCC__0 }   /* ccc=0 */,
  {     0,  9093,  6580,   4,  11, UNI_MYANMAREXTA }   /* blk=myanmarexta */,
  {    10,  6918,  1110,  10,  26, UNI_LB__CJ }   /* linebreak=conditionaljapanesestarter */,
  {     1,  2453,   995,  20,   2, -UNI_TERM }   /* terminalpunctuation=no */,
  {     0,  8233,  7812,   7,   4, UNI_SC__DUPL }   /* script=dupl */,
  {     1,  8874,  8864,   5,   5, -UNI_IDST }   /* idst=false */,
  {     7,  9904,   467,   5,   5, UNI_POSIXPUNCT }   /* posixpunct */,
  {     0,  6885,  4994,   3,   3, UNI_HIRA }   /* ishira */,
  {     0,  8884,  1553,   5,  23, UNI_INSC__CONSONANTPRECEDINGREPHA }   /* insc=consonantprecedingrepha */,
  {     1,  6003,  9734,  12,   3, UNI_JOINC }   /* joincontrol=yes */,
  {     2,  8886,  2127,   3,   4, UNI_SC__HAN }   /* sc=hani */,
  {     0,  9365,  9225,   4,   4, UNI_LINA }   /* scx=lina */,
  {     3,  9629,  9755,   3,   2, UNI_LB__BK }   /* lb=bk */,
  {     0,  9093,   113,   4,  25, UNI_DIACRITICALS }   /* blk=combiningdiacriticalmarks */,
  {     0,  7025,  9445,   3,   4, UNI_IN__12 }   /* in=v120 */,
  {     1,  2106,  1057,  21,   7, UNI_GCB__PP }   /* graphemeclusterbreak=prepend */,
  {     7,  9297,     0,   4,   0, UNI_OLCK }   /* olck */,
  {     1,  3868,  9775,  16,   2, UNI_ZL }   /* generalcategory=zl */,
  {     1,  9093,  7078,   4,  10, UNI_SUPARROWSB }   /* blk=suparrowsb */,
  {     2,  9623,  7392,   3,   9, UNI_JG__SYRIACWAW }   /* jg=syriacwaw */,
  {     4,  8424,  2855,   6,  19, UNI_SUPARROWSA }   /* block=supplementalarrowsa */,
  {     4,  9365,  4205,   5,   5, UNI_SYRC }   /* scx=syriac */,
  {     0,  3671,  9285,  17,   3, UNI_NKO }   /* scriptextensions=nko */,
  {     1,  3254,  9734,  18,   3, UNI_RI }   /* regionalindicator=yes */,
  {    17,  5979,  8864,  12,   5, -UNI_IDEO }   /* ideographic=false */,
  {     1,  7812,     0,   8,   0, UNI_DUPL }   /* duployan */,
  {     5,  5760,  7540,  13,   3, UNI_NV__200 }   /* numericvalue=200 */,
  {     0,  9365,  9394,   5,   3, UNI_SYRC }   /* scx=syrc */,
  {     3,  7108,     1,  10,   1, -UNI_XPOSIXUPPER }   /* uppercase=n */,
  {     0,   184,  9285,   2,   4, UNI_NKO }   /* isnkoo */,
  {     0,   569,     0,  30,   0, UNI_CJKEXTC }   /* cjkunifiedideographsextensionc */,
  {     1,  1136,     3,  26,   1, -UNI_DI }   /* defaultignorablecodepoint=f */,
  {     2,  5591,     0,  13,   0, UNI_ZL }   /* lineseparator */,
  {     0,  5565,  9617,  13,   3, UNI_JG__GAF }   /* joininggroup=gaf */,
  {     3,  1977,     3,  22,   1, -UNI__PERL_NCHAR }   /* noncharactercodepoint=f */,
  {     1,   184,  3728,   2,  11, UNI_SGNW }   /* issignwriting */,
  {     1,  4821,  9734,  14,   3, UNI_POSIXXDIGIT }   /* asciihexdigit=yes */,
  {     2,  1536,   383,   3,  31, UNI_EGYPTIANHIEROGLYPHFORMATCONTROLS }   /* inegyptianhieroglyphformatcontrols */,
  {     0,  7025,  9674,   3,   3, UNI_IN__2 }   /* in=v20 */,
  {     2,  8424,  4220,   6,   6, UNI_INTANGUT }   /* block=tangut */,
  {     8,  8628,     0,   4,   0, UNI_THAA }   /* thaa */,
  {     8,  8424,  4373,   7,  14, UNI_CONTROLPICTURES }   /* block=controlpictures */,
  {     1,  8233,  8079,   7,   7, UNI_SC__GRAN }   /* script=grantha */,
  {    65,  9946,  6724,   3,   3, UNI_SYLO }   /* issylo */,
  {     1,  8233,  3020,   7,   4, UNI_SC__DEVA }   /* script=deva */,
  {     1,   184,  4108,   2,  16, UNI_MYANMAREXTA }   /* ismyanmarextendeda */,
  {     0,  9113,  7614,   4,   2, UNI_CCC__17 }   /* ccc=17 */,
  {    10,  5760,  8977,  13,   4, UNI_NV__1_SLASH_20 }   /* numericvalue=1/20 */,
  {     1,  9365,  6051,   4,   4, UNI_MAHJ }   /* scx=mahj */,
  {     0,  9781,  9883,   6,   9, UNI__PERL_ANY_FOLDS }   /* _perl_any_folds */,
  {     0,  1757,  9734,  22,   3, UNI_CWL }   /* changeswhenlowercased=yes */,
  {     1,  8886,  8205,   3,   7, UNI_OSMA }   /* sc=osmanya */,
  {     3,  8886,  2836,   3,   4, UNI_SUND }   /* sc=sund */,
  {     0,  6194,  3201,   3,  17, UNI_ORNAMENTALDINGBATS }   /* inornamentaldingbats */,
  {     0,  9365,  4672,   4,  15, UNI_SARB }   /* scx=oldsoutharabian */,
  {    14,  8424,  6646,   6,  11, UNI_INPAHAWHHMONG }   /* block=pahawhhmong */,
  {     2,  8219,     0,   6,   0, UNI_PATSYN }   /* patsyn */,
  {     0,  9093,  8924,   4,   5, UNI_INORIYA }   /* blk=oriya */,
  {     0,  9365,  9173,   4,   4, UNI_GURU }   /* scx=guru */,
  {     2,  9093,  3964,   4,   6, UNI_LATIN1 }   /* blk=latin1 */,
  {     1,  8510,    36,   4,   1, UNI_EXT }   /* ext=t */,
  {     2,  9113,  8715,   5,   4, UNI_CCC__14 }   /* ccc=ccc14 */,
  {     2,  7419,     1,   9,   1, -UNI_XIDS }   /* xidstart=n */,
  {     1,  1362,  1189,  24,   3, UNI_CCC__214 }   /* canonicalcombiningclass=ata */,
  {     5,  9093,  4298,   5,  14, UNI_BRAI }   /* blk=braillepatterns */,
  {     0,  9325,     0,   4,   0, UNI_MIAO }   /* plrd */,
  {     0,   184,  1387,   3,  23, UNI_CJKSYMBOLS }   /* iscjksymbolsandpunctuation */,
  {     4,  9137,  9734,   4,   3, UNI_DEP }   /* dep=yes */,
  {     0,  9125,  9433,   4,   4, UNI_CWT }   /* cwt=true */,
  {     1,  9629,   395,   3,   2, UNI_LB__GL }   /* lb=gl */,
  {     0,   184,  3254,   2,  17, UNI_RI }   /* isregionalindicator */,
  {     1,  8233,  7302,   7,   9, UNI_NBAT }   /* script=nabataean */,
  {     1,  1497,  1410,   9,  13, UNI_M }   /* category=combiningmark */,
  {     0,  6885,  2128,   3,   3, UNI_HAN }   /* ishani */,
  {     0,  1757,  9433,  22,   4, UNI_CWL }   /* changeswhenlowercased=true */,
  {     1,   184,  3837,   3,   6, UNI_CPRT }   /* iscypriot */,
  {     0,  3671,  9345,  17,   4, UNI_RJNG }   /* scriptextensions=rjng */,
  {    10,  3671,  9481,  17,   4, UNI_ZANB }   /* scriptextensions=zanb */,
  {     1,  8424,  4792,   6,  15, UNI_INZANABAZARSQUARE }   /* block=zanabazarsquare */,
  {     5,  9049,  7462,   4,   1, UNI_AGE__4 }   /* age=4 */,
  {     0,  5760,  7555,  13,   2, UNI_NV__23 }   /* numericvalue=23 */,
  {     4,  8886,  3980,   3,   7, UNI_SC__LINB }   /* sc=linearb */,
  {     6,  9365,  9485,   4,   4, UNI_QAAI }   /* scx=zinh */,
  {     0,  9921,     0,   5,   0, UNI_XPOSIXPRINT }   /* print */,
  {     2,   184,    18,   2,   2, UNI_RI }   /* isri */,
  {     3,    21,  7148,   2,  10, UNI_YIRADICALS }   /* inyiradicals */,
  {     6,  4705,    47,   5,   1, UNI_TERM }   /* isterm */,
  {     1,   184,  7068,   2,  10, UNI_SUPARROWSA }   /* issuparrowsa */,
  {     9,  1911,  4612,  22,  15, UNI_INSC__MODIFYINGLETTER }   /* indicsyllabiccategory=modifyingletter */,
  {     0,  5760,  8388,  13,   5, UNI_NV__70000 }   /* numericvalue=70000 */,
  {     1,  3671,  8107,  17,   7, UNI_KNDA }   /* scriptextensions=kannada */,
  {     0,  9365,  7956,   4,   8, UNI_TAGB }   /* scx=tagbanwa */,
  {     0,  5003,     0,  14,   0, UNI_LATINEXTB }   /* latinextendedb */,
  {     0,  1735,     3,  22,   1, -UNI_CWCM }   /* changeswhencasemapped=f */,
  {     4,  8149,     0,   4,   0, UNI_MULT }   /* mult */,
  {     2,  8424,  4267,   6,  15, UNI_BAMUMSUP }   /* block=bamumsupplement */,
  {     0,   184,  2169,   2,  21, UNI_MEETEIMAYEKEXT }   /* ismeeteimayekextensions */,
  {     8,  9097,   721,   4,   5, UNI_BPT__C }   /* bpt=close */,
  {     0,  5339,  1164,  14,   2, UNI_LB__LF }   /* sentencebreak=lf */,
  {     3,  6816,  1531,   3,  13, UNI_BYZANTINEMUSIC }   /* inbyzantinemusic */,
  {     0,  8332,    15,   4,   2, UNI_ARAB }   /* isarab */,
  {     5,  8219,     0,   7,   0, UNI_patsyn_values_index }   /* patsyn= */,
  {     2,  8424,  1576,   6,  23, UNI_GEOMETRICSHAPESEXT }   /* block=geometricshapesextended */,
  {     7,  8886,  2085,   3,   8, UNI_SC__CYRL }   /* sc=cyrillic */,
  {     1,    42,     0,   9,   0, UNI_CJKCOMPAT }   /* cjkcompat */,
  {     0,  5565,  9477,  13,   4, UNI_JG__ZAIN }   /* joininggroup=zain */,
  {     6,  9946,  7942,   4,   6, UNI_SPECIALS }   /* isspecials */,
  {     4,  1239,     3,  25,   1, -UNI_COMPEX }   /* fullcompositionexclusion=f */,
  {     3,  8086,     0,   6,   0, UNI_GRBASE }   /* grbase */,
  {     0,  2148,  4205,   3,   5, UNI_INSYRIAC }   /* insyriac */,
  {     0,    21,  2232,   2,   6, UNI_YIJING }   /* inyijing */,
  {     0,   316,     0,  33,   0, UNI_SUPMATHOPERATORS }   /* supplementalmathematicaloperators */,
  {     0,  9731,  5952,   3,   3, UNI_LB__ZWJ }   /* wb=zwj */,
  {     1,  9781,    25,  29,   1, UNI__PERL_PROBLEMATIC_LOCALE_FOLDS }   /* _perl_problematic_locale_folds */,
  {     7,  4124,     0,  16,   0, UNI_MYANMAREXTB }   /* myanmarextendedb */,
  {     8,  9093,  8030,   4,   7, UNI_CJKEXTD }   /* blk=cjkextd */,
  {     2,  1801,     1,  22,   1, -UNI_CWU }   /* changeswhenuppercased=n */,
  {     0,  1713,     0,  21,   0, UNI_CWCF }   /* changeswhencasefolded */,
  {     2,  8424,  3964,   6,  16, UNI_LATIN1 }   /* block=latin1supplement */,
  {     2,  9647,  8354,   3,   3, UNI_NV__600 }   /* nv=600 */,
  {     0,  1911,  1553,  22,  23, UNI_INSC__CONSONANTPRECEDINGREPHA }   /* indicsyllabiccategory=consonantprecedingrepha */,
  {     6,  8854,    26,   5,   1, UNI_DASH }   /* dash=y */,
  {     0,  9049,  9689,   4,   3, UNI_AGE__4 }   /* age=v40 */,
  {     0,  8233,  7356,   7,   4, UNI_PALM }   /* script=palm */,
  {     0,  9321,     0,   4,   0, UNI_PHNX }   /* phnx */,
  {     2,  6918,    58,  10,   2, UNI_LB__ID }   /* linebreak=id */,
  {     0,  8496,    26,   6,   1, UNI_CWKCF }   /* cwkcf=y */,
  {     0,  1668,     0,  23,   0, UNI_SUPPUNCTUATION }   /* supplementalpunctuation */,
  {     3,  9599,  9734,   3,   3, UNI_CI }   /* ci=yes */,
  {     0,  8934,     0,   5,   0, UNI_RUNR }   /* runic */,
  {     0,  2453,     0,  19,   0, UNI_TERM }   /* terminalpunctuation */,
  {     1,  4447,  8574,  15,   6, UNI_EA__NA }   /* eastasianwidth=narrow */,
  {    11,  9365,  9181,   4,   4, UNI_HLUW }   /* scx=hluw */,
  {     5,  2708,  7774,   4,   6, UNI_INARMENIAN }   /* inarmenian */,
  {     2,   184,  9337,   2,   4, UNI_QAAI }   /* isqaai */,
  {     0,  9093,  6382,   4,   6, UNI_DOMINO }   /* blk=domino */,
  {     1,  1536,  3039,   3,   7, UNI_INETHIOPIC }   /* inethiopic */,
  {     2,  9623,  5692,   3,   3, UNI_JG__TAW }   /* jg=taw */,
  {     0,  9599,  8864,   3,   5, -UNI_CI }   /* ci=false */,
  {     1,  9113,  7571,   4,   2, UNI_CCC__33 }   /* ccc=33 */,
  {     0,  2333,     0,  13,   0, UNI_GLAGOLITICSUP }   /* glagoliticsup */,
  {     0,  9731,   400,   3,   6, UNI_WB__FO }   /* wb=format */,
  {     0,  8233,  8107,   7,   7, UNI_SC__KNDA }   /* script=kannada */,
  {     0,  9401,     0,   4,   0, UNI_TALE }   /* tale */,
  {     0,  9365,  6646,   4,  11, UNI_HMNG }   /* scx=pahawhhmong */,
  {     1,  7018,  7668,  10,   3, UNI_IN__6_DOT_2 }   /* presentin=6.2 */,
  {     2,  8233,  2006,   7,   4, UNI_SC__MODI }   /* script=modi */,
  {     0,  8135,     0,   7,   0, UNI_MAND }   /* mandaic */,
  {     2,  8886,  2333,   3,  10, UNI_SC__GLAG }   /* sc=glagolitic */,
  {     0,  7900,     0,   8,   0, UNI_KANAEXTA }   /* kanaexta */,
  {     4,  9623,  5097,   3,   4, UNI_JG__BETH }   /* jg=beth */,
  {     8,  8424,  5872,   7,  11, UNI_CYRILLICEXTA }   /* block=cyrillicexta */,
  {     3,  9365,  8262,   5,   3, UNI_SOYO }   /* scx=soyo */,
  {     4,  5760,  8354,  13,   2, UNI_NV__60 }   /* numericvalue=60 */,
  {     1,  9629,  2368,   3,   2, UNI_LB__HL }   /* lb=hl */,
  {     0,  9093,  3756,   4,  16, UNI_ARABICSUP }   /* blk=arabicsupplement */,
  {     2,  8424,  5617,   6,   9, UNI_INMALAYALAM }   /* block=malayalam */,
  {     0,  8871,   495,   3,   2, UNI_SB__NU }   /* sb=nu */,
  {     5,  1911,  7780,  22,   8, UNI_INSC__AVAGRAHA }   /* indicsyllabiccategory=avagraha */,
  {     1,  8233,  8919,   7,   5, UNI_OGAM }   /* script=ogham */,
  {     9,  9605,    45,   3,   3, UNI_DT__COM }   /* dt=com */,
  {    12,  9623,  5241,   3,  14, UNI_JG__NOJOININGGROUP }   /* jg=nojoininggroup */,
  {     0,  3671,  9337,  17,   4, UNI_QAAI }   /* scriptextensions=qaai */,
  {     8,  8886,  8568,   3,   4, UNI_LYDI }   /* sc=lydi */,
  {     0,  5565,  6547,  13,  11, UNI_JG__MALAYALAMRA }   /* joininggroup=malayalamra */,
  {     3,   184,  8550,   2,   6, UNI_LEPC }   /* islepcha */,
  {     2,  9909,  4828,   7,   6, UNI_POSIXXDIGIT }   /* isposixxdigit */,
  {     0,  1851,     0,  16,   0, UNI_INDICNUMBERFORMS }   /* indicnumberforms */,
  {     0,  9113,  7495,   4,   1, UNI_CCC__7 }   /* ccc=7 */,
  {     5,  6316,     0,  11,   0, UNI_idc_values_index }   /* idcontinue= */,
  {     0,  8635,    26,   5,   1, UNI_IDEO }   /* ideo=y */,
  {     0,  5835,   995,  12,   2, -UNI_BIDIC }   /* bidicontrol=no */,
  {     1,    21,  9233,   2,   4, UNI_LISU }   /* inlisu */,
  {     0,  8886,  8622,   3,   6, UNI_SC__TELU }   /* sc=telugu */,
  {     1,  5760,  8674,  13,   5, UNI_NV__11_SLASH_12 }   /* numericvalue=11/12 */,
  {     0,  3671,  3984,  18,   3, UNI_SARB }   /* scriptextensions=sarb */,
  {     0,  5760,  9018,  13,   3, UNI_NV__7_SLASH_2 }   /* numericvalue=7/2 */,
  {     1,   184,  7804,   2,   8, UNI_BUGI }   /* isbuginese */,
  {     1,  5565,  4947,  13,  14, UNI_JG__HAMZAONHEHGOAL }   /* joininggroup=hamzaonhehgoal */,
  {     1,  9049,  9704,   4,   3, UNI_AGE__6 }   /* age=v60 */,
  {     1,  9333,     0,   4,   0, UNI_COPT }   /* qaac */,
  {     2,  4778,  3026,   3,   3, UNI_UGAR }   /* isugar */,
  {     2,  1911,     0,  22,   0, UNI_insc_values_index }   /* indicsyllabiccategory= */,
  {     1,  4172,     0,  16,   0, UNI_SUPMATHOPERATORS }   /* supmathoperators */,
  {     0,  9093,  4268,   5,  14, UNI_BAMUMSUP }   /* blk=bamumsupplement */,
  {     0,  9093,   283,   4,  33, UNI_MISCMATHSYMBOLSB }   /* blk=miscellaneousmathematicalsymbolsb */,
  {     1,  8424,  6558,   6,  11, UNI_INMEDEFAIDRIN }   /* block=medefaidrin */,
  {     9,  9647,  8989,   3,   3, UNI_NV__1_SLASH_8 }   /* nv=1/8 */,
  {     8,  6816,  5590,   3,   7, UNI_INBALINESE }   /* inbalinese */,
  {     2,  1362,    24,  24,   1, UNI_CCC__L }   /* canonicalcombiningclass=l */,
  {    16,  9093,    78,   4,  10, UNI_ARABICMATH }   /* blk=arabicmath */,
  {     0,   599,     0,  30,   0, UNI_CJKEXTD }   /* cjkunifiedideographsextensiond */,
  {     1,  6885,  7861,   3,   7, UNI_HIRA }   /* ishiragana */,
  {     0,  9365,  1085,   4,   4, UNI_HANG }   /* scx=hang */,
  {     3,  9909,    25,   3,   1, UNI_PS }   /* isps */,
  {     0,  8424,  7860,   6,   8, UNI_INHIRAGANA }   /* block=hiragana */,
  {     1,  9193,  7401,   4,   9, UNI_GCB__V }   /* hst=voweljamo */,
  {     1,  5760,  8985,  13,   3, UNI_NV__1_SLASH_6 }   /* numericvalue=1/6 */,
  {     0,  9093,  5283,   4,  14, UNI_PHONETICEXTSUP }   /* blk=phoneticextsup */,
  {     6,  3671,  9109,  17,   4, UNI_CANS }   /* scriptextensions=cans */,
  {     3,   184,    62,   2,   5, UNI_XPOSIXGRAPH }   /* isgraph */,
  {     1,  1497,   133,   9,   4, UNI_M }   /* category=mark */,
  {     0,   184,   218,   3,  32, UNI_DIACRITICALSEXT }   /* iscombiningdiacriticalmarksextended */,
  {     5,  9105,     0,   4,   0, UNI_CAKM }   /* cakm */,
  {     0,  9093,  2211,   4,   7, UNI_INSINHALA }   /* blk=sinhala */,
  {     2,  9093,  1599,   4,  23, UNI_COMPATJAMO }   /* blk=hangulcompatibilityjamo */,
  {     4,  3868,  6360,  16,  11, UNI_CASEDLETTER }   /* generalcategory=casedletter */,
  {     0,  9093,  5552,   4,  13, UNI_IPAEXT }   /* blk=ipaextensions */,
  {     4,  3948,   922,   3,  17, UNI_INVS }   /* invariationselectors */,
  {     0,  8424,   114,   7,  24, UNI_DIACRITICALS }   /* block=combiningdiacriticalmarks */,
  {     4,  5760,  7631,  13,   1, UNI_NV__9 }   /* numericvalue=9 */,
  {    13,  9647,  9506,   3,   3, UNI_NV__2_SLASH_3 }   /* nv=2/3 */,
  {     4,   184,  6569,   2,  11, UNI_MISCSYMBOLS }   /* ismiscsymbols */,
  {     3,  7128,  1767,  10,   2, UNI_WB__NL }   /* wordbreak=nl */,
  {     1,  9361,     0,   4,   0, UNI_SARB }   /* sarb */,
  {     0,   400,     0,   6,   0, UNI_CF }   /* format */,
  {     0,  1158,  4718,   3,   7, UNI_TAMILSUP }   /* intamilsup */,
  {     0,    21,  6027,   2,   5, UNI_INKHMER }   /* inkhmer */,
  {     0,  8886,  9385,   3,   4, UNI_SC__SHRD }   /* sc=shrd */,
  {     3,  5760,  9557,  13,   3, UNI_NV__3_SLASH_5 }   /* numericvalue=3/5 */,
  {     0,  3671,  9253,  17,   4, UNI_MIAO }   /* scriptextensions=miao */,
  {     0,  3671,  8093,  17,   7, UNI_HANO }   /* scriptextensions=hanunoo */,
  {     1,  8616,  8864,   6,   5, -UNI_STERM }   /* sterm=false */,
  {     0,  8869,  9433,   5,   4, UNI_IDSB }   /* idsb=true */,
  {     4,  5325,  9433,  14,   4, UNI_QMARK }   /* quotationmark=true */,
  {     0,  3002,  3370,  18,   3, UNI_DT__MED }   /* decompositiontype=med */,
  {     9,  9093,  6382,   4,  11, UNI_DOMINO }   /* blk=dominotiles */,
  {     0,  9620,  1257,   3,   2, UNI_UPPERCASELETTER }   /* gc=lu */,
  {     0,  8424,   837,   6,  28, UNI_PHONETICEXTSUP }   /* block=phoneticextensionssupplement */,
  {     2,  5513,     1,  13,   1, -UNI_GRBASE }   /* graphemebase=n */,
  {     1,   184,   779,   2,  29, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* isenclosedideographicsupplement */,
  {     6,  3772,     0,  16,   0, UNI_BOPOMOFOEXT }   /* bopomofoextended */,
  {     0,  9121,     1,   4,   1, -UNI_CWL }   /* cwl=n */,
  {    12,  6315,    36,  12,   1, UNI_XIDC }   /* xidcontinue=t */,
  {     2,  5492,     0,   5,   0, UNI_XPOSIXALNUM }   /* alnum */,
  {     1,  8424,  7078,   6,  10, UNI_SUPARROWSB }   /* block=suparrowsb */,
  {     1,  9113,  8730,   5,   4, UNI_CCC__17 }   /* ccc=ccc17 */,
  {     1,  8869,     1,   5,   1, -UNI_IDSB }   /* idsb=n */,
  {     1,  4462,  9433,  15,   4, UNI_GREXT }   /* graphemeextend=true */,
  {     0,  8424,  3092,   6,  18, UNI_INPUNCTUATION }   /* block=generalpunctuation */,
  {     1,  7025,  7668,   3,   3, UNI_IN__6_DOT_2 }   /* in=6.2 */,
  {     0,   184,  3631,   3,   3, UNI_CHAM }   /* ischam */,
  {     3,  8424,  7329,   6,   9, UNI_INOLDITALIC }   /* block=olditalic */,
  {     8,  9903,  1768,   6,   5, UNI_XPOSIXLOWER }   /* xposixlower */,
  {     0,  3251,     1,   3,   1, -UNI_CE }   /* ce=n */,
  {     5,  5760,  5409,  13,   9, UNI_NV__100000000 }   /* numericvalue=100000000 */,
  {     0,  5325,     1,  14,   1, -UNI_QMARK }   /* quotationmark=n */,
  {     1,  2703,    26,  19,   1, UNI_IDST }   /* idstrinaryoperator=y */,
  {     1,  9049,  7463,   4,   1, UNI_AGE__3 }   /* age=3 */,
  {     9,  8424,   893,   6,  28, UNI_SUPPUAB }   /* block=supplementaryprivateuseareab */,
  {     8,  8886,  2984,   3,   6, UNI_SC__COPT }   /* sc=coptic */,
  {     4,  3671,  7995,  17,   7, UNI_AVST }   /* scriptextensions=avestan */,
  {     0,  3671,  8610,  17,   6, UNI_RJNG }   /* scriptextensions=rejang */,
  {     5,  9093,   808,   4,  29, UNI_MISCARROWS }   /* blk=miscellaneoussymbolsandarrows */,
  {     1,  9659,    26,   3,   1, UNI_RI }   /* ri=y */,
  {     1,  3980,     0,  16,   0, UNI_LINEARBIDEOGRAMS }   /* linearbideograms */,
  {     5,  9093,  1845,   4,  22, UNI_INDICNUMBERFORMS }   /* blk=commonindicnumberforms */,
  {     2,  6171,     0,  12,   0, UNI_MATHALPHANUM }   /* mathalphanum */,
  {     2,  1410,     0,  24,   0, UNI_DIACRITICALSFORSYMBOLS }   /* combiningmarksforsymbols */,
  {     1,   184,   382,   2,   4, UNI_EGYP }   /* isegyp */,
  {     0,  9093,  3020,   4,  18, UNI_DEVANAGARIEXT }   /* blk=devanagariextended */,
  {     4,   749,     0,  30,   0, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* symbolsandpictographsextendeda */,
  {     8,  9093,  5449,   5,  12, UNI_BLOCKELEMENTS }   /* blk=blockelements */,
  {     6,   184,  3519,   3,  16, UNI_CYRILLICEXTB }   /* iscyrillicextendedb */,
  {     0,  5565,  3620,  13,  17, UNI_JG__MANICHAEANDHAMEDH }   /* joininggroup=manichaeandhamedh */,
  {     1,  9113,  9530,   4,   3, UNI_CCC__AL }   /* ccc=228 */,
  {     1,  9629,  9310,   3,   2, UNI_LB__SG }   /* lb=sg */,
  {     0,  6918,  5520,  10,   5, UNI_LB__EB }   /* linebreak=ebase */,
  {     5,  9623,  4552,   3,  15, UNI_JG__MANICHAEANSADHE }   /* jg=manichaeansadhe */,
  {     0,  3739,  9734,  17,   3, UNI_UIDEO }   /* unifiedideograph=yes */,
  {     1,  9153,  4797,   5,   2, UNI_WB__EB }   /* gcb=gaz */,
  {     0,  9909,  1768,   7,   5, UNI_POSIXLOWER }   /* isposixlower */,
  {     9,  8424,  9057,   6,   4, UNI_INAHOM }   /* block=ahom */,
  {     1,   184,  5884,   3,  11, UNI_CYRILLICEXTB }   /* iscyrillicextb */,
  {     1,  5565,  6909,  14,   9, UNI_JG__KNOTTEDHEH }   /* joininggroup=knottedheh */,
  {     1,  4108,     0,  16,   0, UNI_MYANMAREXTA }   /* myanmarextendeda */,
  {     3,  1084,   995,  26,   2, -UNI_CWKCF }   /* changeswhennfkccasefolded=no */,
  {     3,  5227,     0,  15,   0, UNI_DT__CAN }   /* nfdquickcheck=n */,
  {     0,   184,  8065,   2,   4, UNI_ELBA }   /* iselba */,
  {     0,  9093,  3469,   4,   4, UNI_UCAS }   /* blk=ucas */,
  {     0,  8086,  9734,   7,   3, UNI_GRBASE }   /* grbase=yes */,
  {    15,  8886,    78,   3,   4, UNI_SC__ARAB }   /* sc=arab */,
  {     3,  8854,     3,   5,   1, -UNI_DASH }   /* dash=f */,
  {     5,  8424,  6869,   7,   9, UNI_COMPATJAMO }   /* block=compatjamo */,
  {     0,  9093,  4124,   4,  16, UNI_MYANMAREXTB }   /* blk=myanmarextendedb */,
  {     1,  9365,  8107,   4,   7, UNI_KNDA }   /* scx=kannada */,
  {     8,  8424,  2021,   6,  22, UNI_TRANSPORTANDMAP }   /* block=transportandmapsymbols */,
  {     1,  1482,  4434,   4,  13, UNI_DIACRITICALSSUP }   /* indiacriticalssup */,
  {     0,  8886,  1622,   3,   5, UNI_SC__LATN }   /* sc=latin */,
  {     0,  1156,     0,   2,   0, UNI_PO }   /* po */,
  {     8,  9093,  2401,   4,   3, UNI_PUA }   /* blk=pua */,
  {     0,    21,   977,   3,  16, UNI_ANCIENTGREEKMUSIC }   /* inancientgreekmusic */,
  {     9,  5760,  8394,  13,   3, UNI_NV__800 }   /* numericvalue=800 */,
  {     1,  8884,  8909,   5,   5, UNI_INSC__NUKTA }   /* insc=nukta */,
  {     2,  9365,  2741,   4,   4, UNI_MERO }   /* scx=mero */,
  {     1,  8233,  9473,   7,   4, UNI_SC__YI }   /* script=yiii */,
  {     1,  8424,  6712,   6,  11, UNI_SUPERANDSUB }   /* block=superandsub */,
  {     3,  3002,  4351,  18,   6, UNI_DT__MED }   /* decompositiontype=medial */,
  {     0,  9093,  3980,   4,  16, UNI_LINEARBIDEOGRAMS }   /* blk=linearbideograms */,
  {     1,  8874,  9433,   5,   4, UNI_IDST }   /* idst=true */,
  {     0,  9620,  4140,   3,  16, UNI_PO }   /* gc=otherpunctuation */,
  {     1,  6194,  6989,   3,   9, UNI_INOLDSOGDIAN }   /* inoldsogdian */,
  {     0,  9089,     0,   4,   0, UNI_BHKS }   /* bhks */,
  {     0,  8886,  8072,   3,   7, UNI_ELYM }   /* sc=elymaic */,
  {     9,  1801,  9433,  22,   4, UNI_CWU }   /* changeswhenuppercased=true */,
  {     2,   878,     0,  14,   0, UNI_PUA }   /* privateusearea */,
  {     2,  5565,  6087,  13,  12, UNI_JG__MALAYALAMNGA }   /* joininggroup=malayalamnga */,
  {     0,  4462,     0,  15,   0, UNI_grext_values_index }   /* graphemeextend= */,
  {     2,  4826,    36,   9,   1, UNI_XPOSIXXDIGIT }   /* hexdigit=t */,
  {     4,  1779,     0,  22,   0, UNI_cwt_values_index }   /* changeswhentitlecased= */,
  {     4,  9093,   328,   4,  21, UNI_MATHOPERATORS }   /* blk=mathematicaloperators */,
  {     4,  9113,  8358,   4,   2, UNI_CCC__30 }   /* ccc=30 */,
  {    17,  7239,  5969,   4,   4, UNI_INHEBREW }   /* inhebrew */,
  {     1,  5760,  9572,  13,   3, UNI_NV__5_SLASH_8 }   /* numericvalue=5/8 */,
  {     0,  2106,     0,  21,   0, UNI_gcb_values_index }   /* graphemeclusterbreak= */,
  {    11,  9647,  8376,   3,   6, UNI_NV__500000 }   /* nv=500000 */,
  {     2,  3671,  8892,  17,   4, UNI_PHLI }   /* scriptextensions=phli */,
  {     1,  9093,  7852,   4,   8, UNI_INGURMUKHI }   /* blk=gurmukhi */,
  {     0,  9626,  6745,   3,  11, UNI_JT__T }   /* jt=transparent */,
  {     4,  8886,  6978,   3,  10, UNI_XPEO }   /* sc=oldpersian */,
  {     0,  9946,    47,   3,   1, UNI_SM }   /* issm */,
  {    11,  8424,  8562,   6,   6, UNI_INLYCIAN }   /* block=lycian */,
  {     2,  2457,  5802,   5,   9, UNI_ALPHABETICPF }   /* inalphabeticpf */,
  {     0,  3251,     0,   3,   0, UNI_ce_values_index }   /* ce= */,
  {     1,  6005,   150,   4,  33, UNI_DIACRITICALSSUP }   /* incombiningdiacriticalmarkssupplement */,
  {     1,  9113,  8646,   4,   6, UNI_CCC__9 }   /* ccc=virama */,
  {     0,  9093,  6492,   4,  11, UNI_KATAKANAEXT }   /* blk=katakanaext */,
  {     0,  3671,  9133,  17,   4, UNI_CYRL }   /* scriptextensions=cyrl */,
  {     9,   184,  5591,   2,  13, UNI_ZL }   /* islineseparator */,
  {     1,  9647,  5409,   3,   8, UNI_NV__10000000 }   /* nv=10000000 */,
  {     0,  3671,  9145,  17,   4, UNI_DSRT }   /* scriptextensions=dsrt */,
  {     8,  9864,   436,   7,   4, UNI__PERL_NCHAR }   /* _perl_nchar */,
  {    24,  9629,  1156,   3,   2, UNI_LB__PO }   /* lb=po */,
  {     0,  8424,   749,   6,  30, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* block=symbolsandpictographsextendeda */,
  {     1,  6828,  2013,  10,   3, UNI_BC__RLE }   /* bidiclass=rle */,
  {    15,   184,  9201,   2,   4, UNI_KHMR }   /* iskhmr */,
  {     0,  8635,    36,   5,   1, UNI_IDEO }   /* ideo=t */,
  {     0,  7025,  9722,   3,   3, UNI_IN__9 }   /* in=v90 */,
  {     0,  9909,  2495,   3,   3, UNI_PRTI }   /* isprti */,
  {     7,  8233,  2085,   7,   8, UNI_SC__CYRL }   /* script=cyrillic */,
  {     3,  9629,  2564,   3,   2, UNI_LB__BA }   /* lb=ba */,
  {     1,  9153,    73,   4,   2, UNI_WB__EB }   /* gcb=em */,
  {     0,  1158,  4221,   3,   5, UNI_INTANGUT }   /* intangut */,
  {     2,   184,  8502,   2,   6, UNI_GOTH }   /* isgothic */,
  {     1,  8424,  1162,   6,  26, UNI_HALFANDFULLFORMS }   /* block=halfwidthandfullwidthforms */,
  {     0,  5760,  8358,  13,   3, UNI_NV__300 }   /* numericvalue=300 */,
  {     0,  9946,     0,   7,   0, UNI_XPOSIXSPACE }   /* isspace */,
  {     0,  9093,  5578,   4,  13, UNI_KANAEXTA }   /* blk=kanaextendeda */,
  {     0,  4447,  1174,  15,   9, UNI_EA__F }   /* eastasianwidth=fullwidth */,
  {     3,  9093,  7356,   4,   9, UNI_PALM }   /* blk=palmyrene */,
  {     7,  9909,  1574,   3,   3, UNI_PHAG }   /* isphag */,
  {     1,  8424,  1576,   6,  15, UNI_GEOMETRICSHAPES }   /* block=geometricshapes */,
  {     4,   837,     0,  18,   0, UNI_PHONETICEXT }   /* phoneticextensions */,
  {     0,  9113,  7540,   4,   3, UNI_WB__EB }   /* ccc=200 */,
  {     0,  4241,  3022,   4,  16, UNI_DEVANAGARIEXT }   /* indevanagariextended */,
  {     2,  7420,  8864,   8,   5, -UNI_IDS }   /* idstart=false */,
  {     0,  8886,  9485,   3,   4, UNI_SC__QAAI }   /* sc=zinh */,
  {     2,  8886,  7804,   3,   8, UNI_SC__BUGI }   /* sc=buginese */,
  {     0,  9620,  4080,   3,  10, UNI_SM }   /* gc=mathsymbol */,
  {     1,  5835,    36,  12,   1, UNI_BIDIC }   /* bidicontrol=t */,
  {     3,  1713,  9433,  22,   4, UNI_CWCF }   /* changeswhencasefolded=true */,
  {     0,   184,  4975,   2,   7, UNI_KANASUP }   /* iskanasup */,
  {     2,  1458,     0,  24,   0, UNI_HIGHPUSURROGATES }   /* highprivateusesurrogates */,
  {     0,  9629,   495,   3,   2, UNI_LB__NU }   /* lb=nu */,
  {     1,  6679,     3,  11,   1, -UNI_SD }   /* softdotted=f */,
  {     4,  8332,  3417,   3,   9, UNI_ALCHEMICAL }   /* isalchemical */,
  {     9,  7230,     3,   9,   1, -UNI_EXT }   /* extender=f */,
  {    17,  8233,  1482,   8,   3, UNI_SC__SIND }   /* script=sind */,
  {     7,  7018,  9437,  10,   4, UNI_IN__10 }   /* presentin=v100 */,
  {     0,  2204,  4659,   4,  13, UNI_NARB }   /* isoldnortharabian */,
  {     8,  9623,  6097,   3,   5, UNI_JG__GAMAL }   /* jg=gamal */,
  {     0,  8233,  7375,   8,   8, UNI_SAMR }   /* script=samaritan */,
  {     4,  8424,   630,   7,  29, UNI_CJKEXTE }   /* block=cjkunifiedideographsextensione */,
  {     0,  9125,     3,   4,   1, -UNI_CWT }   /* cwt=f */,
  {     0,  9901,  7420,   3,   7, UNI_XIDS }   /* isxidstart */,
  {     1,  9365,  8628,   4,   6, UNI_THAA }   /* scx=thaana */,
  {     5,  3671,  8149,  17,   4, UNI_MULT }   /* scriptextensions=mult */,
  {     4,  5565,  1456,  13,   3, UNI_JG__HAH }   /* joininggroup=hah */,
  {    20,  5760,  7484,  13,   8, UNI_NV__1_SLASH_64 }   /* numericvalue=1.56e-02 */,
  {     8,  9623,   726,   3,   3, UNI_JG__DAL }   /* jg=dal */,
  {     0,  5565,  6123,  13,  12, UNI_JG__MALAYALAMSSA }   /* joininggroup=malayalamssa */,
  {     2,  5565,  4038,  13,   3, UNI_JG__LAM }   /* joininggroup=lam */,
  {     3,  7025,  9710,   3,   3, UNI_IN__6_DOT_2 }   /* in=v62 */,
  {    10,  3254,     1,  18,   1, -UNI_RI }   /* regionalindicator=n */,
  {     0,  9093,  6171,   4,  12, UNI_MATHALPHANUM }   /* blk=mathalphanum */,
  {     1,  9365,  8526,   4,   6, UNI_KTHI }   /* scx=kaithi */,
  {     0,  1497,  4387,   9,  14, UNI_SC }   /* category=currencysymbol */,
  {     0,  3671,  7329,  17,   9, UNI_ITAL }   /* scriptextensions=olditalic */,
  {     2,  9623,  5656,   3,  13, UNI_JG__MANICHAEANNUN }   /* jg=manichaeannun */,
  {     0,   184,  3020,   2,   4, UNI_DEVA }   /* isdeva */,
  {     0,  3552,     0,  16,   0, UNI_ETHIOPICEXT }   /* ethiopicextended */,
  {     5,  8884,  4236,   5,   5, UNI_INSC__VOWEL }   /* insc=vowel */,
  {     1,  3868,  8839,  16,   5, UNI_XPOSIXCNTRL }   /* generalcategory=cntrl */,
  {     0,  9365,  6602,   4,  11, UNI_NAND }   /* scx=nandinagari */,
  {     0,   184,  2949,   3,  17, UNI_HALFMARKS }   /* iscombininghalfmarks */,
  {     0,  4705,  4221,   3,  15, UNI_TANGUTCOMPONENTS }   /* istangutcomponents */,
  {     0,  8233,  4108,   7,   7, UNI_SC__MYMR }   /* script=myanmar */,
  {     1,   184,  8894,   2,   4, UNI_LIMB }   /* islimb */,
  {     1,  8233,  8892,   7,   4, UNI_PHLI }   /* script=phli */,
  {     2,   184,  4417,   2,  15, UNI_DIACRITICALSEXT }   /* isdiacriticalsext */,
  {     1,  5760,  7444,  13,   8, UNI_NV__1_SLASH_8 }   /* numericvalue=1.25e-01 */,
  {    10,  9623,   341,   3,   2, UNI_JG__PE }   /* jg=pe */,
  {     0,  8424,  7068,   6,  10, UNI_SUPARROWSA }   /* block=suparrowsa */,
  {     8,  3671,  5617,  17,   9, UNI_MLYM }   /* scriptextensions=malayalam */,
  {     5,  9946,    44,   3,   1, UNI_SK }   /* issk */,
  {     1,  8884,  2966,   5,  18, UNI_INSC__CONSONANTSUBJOINED }   /* insc=consonantsubjoined */,
  {     3,  1911,  4891,  22,  14, UNI_INSC__CONSONANTFINAL }   /* indicsyllabiccategory=consonantfinal */,
  {     0,  8886,  9169,   3,   4, UNI_SC__GUJR }   /* sc=gujr */,
  {    11,  7025,  9575,   3,   3, UNI_IN__6_DOT_1 }   /* in=6.1 */,
  {     1,  1362,  8765,  25,   4, UNI_CCC__24 }   /* canonicalcombiningclass=ccc24 */,
  {     2,   567,     0,   2,   0, UNI_NB }   /* nb */,
  {     0,  9093,  8652,   4,   6, UNI_INWANCHO }   /* blk=wancho */,
  {     2,  9365,  9297,   4,   4, UNI_OLCK }   /* scx=olck */,
  {     1,  2148,  4173,   3,  15, UNI_SUPMATHOPERATORS }   /* insupmathoperators */,
  {     0,   184,  2855,   2,  19, UNI_SUPARROWSA }   /* issupplementalarrowsa */,
  {     9,  9659,    36,   3,   1, UNI_RI }   /* ri=t */,
  {     1,  9923,  7966,   4,   6, UNI_INTIFINAGH }   /* intifinagh */,
  {     0,  8884,   698,   5,   6, UNI_INSC__NUMBER }   /* insc=number */,
  {     0,  6338,     0,  11,   0, UNI_alpha_values_index }   /* alphabetic= */,
  {     0,  7230,   995,   9,   2, -UNI_EXT }   /* extender=no */,
  {     2,  7025,  7631,   3,   1, UNI_IN__9 }   /* in=9 */,
  {     1,  9901,   467,   8,   5, UNI_XPOSIXPUNCT }   /* isxposixpunct */,
  {     0,  1779,    36,  22,   1, UNI_CWT }   /* changeswhentitlecased=t */,
  {     0,  5031,     0,  14,   0, UNI_LATINEXTD }   /* latinextendedd */,
  {     0,  2106,    24,  21,   1, UNI_GCB__L }   /* graphemeclusterbreak=l */,
  {     0,   184,  4402,   2,   4, UNI_DASH }   /* isdash */,
  {     0,  4849,  9734,  14,   3, UNI_CI }   /* caseignorable=yes */,
  {     1,  8886,  2006,   3,   4, UNI_SC__MODI }   /* sc=modi */,
  {     6,  5565,  6536,  13,  11, UNI_JG__MALAYALAMJA }   /* joininggroup=malayalamja */,
  {     1,  8100,     0,   6,   0, UNI_HYPHEN }   /* hyphen */,
  {     2,  9093,  3020,   4,  13, UNI_DEVANAGARIEXT }   /* blk=devanagariext */,
  {     1,  6918,  5773,  10,  13, UNI_LB__PR }   /* linebreak=prefixnumeric */,
  {     2,  9365,  8149,   4,   4, UNI_MULT }   /* scx=mult */,
  {     3,   184,  6159,   2,  12, UNI_GONM }   /* ismasaramgondi */,
  {     4,  8233,  5617,   7,   9, UNI_SC__MLYM }   /* script=malayalam */,
  {     0,  7108,   995,  10,   2, -UNI_XPOSIXUPPER }   /* uppercase=no */,
  {     0,  3671,  6648,  18,   3, UNI_SHAW }   /* scriptextensions=shaw */,
  {     6,   184,  2086,   3,  20, UNI_CYRILLICSUP }   /* iscyrillicsupplementary */,
  {     4,  9620,  5487,   3,  13, UNI_XPOSIXDIGIT }   /* gc=decimalnumber */,
  {     2,  6567,  1968,   6,   9, UNI_MISCTECHNICAL }   /* inmisctechnical */,
  {     8,  8233,  1085,   7,   4, UNI_SC__HANG }   /* script=hang */,
  {    12,  8871,   836,   3,   2, UNI_SB__SP }   /* sb=sp */,
  {     8,  6838,     0,  10,   0, UNI_BOXDRAWING }   /* boxdrawing */,
  {     1,  9599,   995,   3,   2, -UNI_CI }   /* ci=no */,
  {     9,  5835,     0,  11,   0, UNI_BIDIC }   /* bidicontrol */,
  {     2,  3671,  6898,  17,  10, UNI_KHAR }   /* scriptextensions=kharoshthi */,
  {     0,  8424,   878,   6,  10, UNI_PUA }   /* block=privateuse */,
  {     1,  5979,    26,  12,   1, UNI_IDEO }   /* ideographic=y */,
  {    18,  6194,  7339,   3,   8, UNI_INOLDPERMIC }   /* inoldpermic */,
  {     1,  1136,  9433,  26,   4, UNI_DI }   /* defaultignorablecodepoint=true */,
  {     0,  9093,  7266,   4,   9, UNI_LATINEXTC }   /* blk=latinextc */,
  {    10,  9049,  7724,   4,   3, UNI_AGE__8 }   /* age=8.0 */,
  {     8,  8009,     0,   7,   0, UNI_CJKEXTA }   /* cjkexta */,
  {     8,  9049,  7098,   4,  10, UNI_AGE__NA }   /* age=unassigned */,
  {     3,  1924,  4509,  11,  13, UNI_LOWERCASELETTER }   /* category=lowercaseletter */,
  {     0,  6918,    21,  10,   2, UNI_LB__IN }   /* linebreak=in */,
  {     8,  9365,  9217,   4,   3, UNI_LAO }   /* scx=lao */,
  {     2,  6918,  6437,  10,  11, UNI_LB__EX }   /* linebreak=exclamation */,
  {     4,  9623,  9061,   3,   4, UNI_JG__ALEF }   /* jg=alef */,
  {     1,  5085,  8130,   4,   5, UNI_INMAKASAR }   /* inmakasar */,
  {     0,  9647,  8822,   3,   2, UNI_NV__35 }   /* nv=35 */,
  {     1,  9365,  9417,   4,   4, UNI_TFNG }   /* scx=tfng */,
  {     0,  1536,  3039,   3,  17, UNI_ETHIOPICSUP }   /* inethiopicsupplement */,
  {     0,  9113,  2379,   4,   5, UNI_CCC__R }   /* ccc=right */,
  {     2,  8859,     0,   5,   0, UNI_DOGR }   /* dogra */,
  {     8,  8233,  8135,   7,   7, UNI_SC__MAND }   /* script=mandaic */,
  {     1,  6768,  9474,   3,   3, UNI_YI }   /* isyiii */,
  {     0,  1911,  5395,  22,  14, UNI_INSC__VOWELDEPENDENT }   /* indicsyllabiccategory=voweldependent */,
  {     4,  2665,     0,  19,   0, UNI_JAMOEXTB }   /* hanguljamoextendedb */,
  {     2,  2148,  6992,   3,   6, UNI_INSOGDIAN }   /* insogdian */,
  {     1,  8496,     0,   5,   0, UNI_CWKCF }   /* cwkcf */,
  {     8,  5760,  7446,  13,   2, UNI_NV__25 }   /* numericvalue=25 */,
  {     1,  9647,  7572,   3,   8, UNI_NV__1_SLASH_3 }   /* nv=3.33e-01 */,
  {     0,  9113,  8822,   4,   2, UNI_CCC__35 }   /* ccc=35 */,
  {     4,  9093,  8191,   4,   7, UNI_OLCK }   /* blk=olchiki */,
  {     4,  8424,  7980,   6,   8, UNI_INUGARITIC }   /* block=ugaritic */,
  {     1,  6005,  2044,   3,  20, UNI_CJKCOMPATFORMS }   /* incjkcompatibilityforms */,
  {     0,  9647,  7516,   3,   8, UNI_NV__5_SLASH_2 }   /* nv=2.50e+00 */,
  {     5,  6316,     3,  11,   1, -UNI_IDC }   /* idcontinue=f */,
  {     2,  5258,     0,  11,   0, UNI_MC }   /* spacingmark */,
  {     0,  9629,  3248,   3,   5, UNI_LB__SP }   /* lb=space */,
  {     2,   184,  2608,   2,  19, UNI_EGYP }   /* isegyptianhieroglyphs */,
  {     0,  3868,   995,  16,   2, UNI_NO }   /* generalcategory=no */,
  {     0,  9620,  6360,   3,  11, UNI_CASEDLETTER }   /* gc=casedletter */,
  {     3,  1911,  2532,  22,  19, UNI_INSC__BRAHMIJOININGNUMBER }   /* indicsyllabiccategory=brahmijoiningnumber */,
  {     1,  9365,  2779,   4,   9, UNI_MONG }   /* scx=mongolian */,
  {     1,  3671,  2741,  17,   4, UNI_MERO }   /* scriptextensions=mero */,
  {     0,  9113,  7631,   4,   1, UNI_CCC__9 }   /* ccc=9 */,
  {     4,  5565,  7038,  13,  10, UNI_JG__REVERSEDPE }   /* joininggroup=reversedpe */,
  {     3,  5760,  7700,  13,   8, UNI_NV__2_SLASH_3 }   /* numericvalue=6.67e-01 */,
  {     2,  8424,  2253,   6,  20, UNI_INANATOLIANHIEROGLYPHS }   /* block=anatolianhieroglyphs */,
  {     7,  9953,  4764,   4,   6, UNI_VEDICEXT }   /* isvedicext */,
  {     3,  9093,  2836,   4,  12, UNI_SUNDANESESUP }   /* blk=sundanesesup */,
  {     0,  2169,     0,  11,   0, UNI_MTEI }   /* meeteimayek */,
  {     1,  9093,  5786,   4,  13, UNI_VERTICALFORMS }   /* blk=verticalforms */,
  {     7,  8233,  9285,   7,   3, UNI_NKO }   /* script=nko */,
  {     0,  8424,  5031,   6,  14, UNI_LATINEXTD }   /* block=latinextendedd */,
  {     0,  8622,     0,   6,   0, UNI_TELU }   /* telugu */,
  {     0,  8424,  2006,   6,  15, UNI_MODIFIERLETTERS }   /* block=modifierletters */,
  {     1,  9647,  9001,   3,   4, UNI_NV__11_SLASH_2 }   /* nv=11/2 */,
  {     6,  1159,   495,   3,   7, UNI_NT__NU }   /* nt=numeric */,
  {     0,  9121,     0,   4,   0, UNI_cwl_values_index }   /* cwl= */,
  {     0,  9133,     0,   4,   0, UNI_CYRL }   /* cyrl */,
  {     6,  8424,   988,   6,   5, UNI_MUSIC }   /* block=music */,
  {     1,  5760,  9584,  13,   3, UNI_NV__7_SLASH_8 }   /* numericvalue=7/8 */,
  {     0,  2684,  6525,  19,   3, UNI_LB__H3 }   /* hangulsyllabletype=lvt */,
  {     9,  8849,  8864,   5,   5, -UNI_CWCM }   /* cwcm=false */,
  {     0,  3671,  8628,  17,   4, UNI_THAA }   /* scriptextensions=thaa */,
  {     0,  9093,  2779,   4,  19, UNI_MONGOLIANSUP }   /* blk=mongoliansupplement */,
  {     0,  4778,     1,   3,  41, UNI_UCASEXT }   /* isunifiedcanadianaboriginalsyllabicsextended */,
  {     0,  9909,     2,   3,   1, UNI_PI }   /* ispi */,
  {     2,  9365,  9233,   4,   4, UNI_LISU }   /* scx=lisu */,
  {     0,  9629,  7202,   3,   2, UNI_LB__BB }   /* lb=bb */,
  {     1,  9365,  2837,   5,   3, UNI_SUND }   /* scx=sund */,
  {     6,  8424,  4124,   6,  16, UNI_MYANMAREXTB }   /* block=myanmarextendedb */,
  {     2,  5760,  7460,  13,   8, UNI_NV__1_SLASH_7 }   /* numericvalue=1.43e-01 */,
  {     0,  1911,  4236,  22,  16, UNI_INSC__VOWELINDEPENDENT }   /* indicsyllabiccategory=vowelindependent */,
  {     0,  8424,  2211,   6,   7, UNI_INSINHALA }   /* block=sinhala */,
  {     1,   184,   690,   3,   8, UNI_XSUX }   /* iscuneiform */,
  {     0,  6567,   187,   6,  30, UNI_MISCPICTOGRAPHS }   /* inmiscellaneoussymbolsandpictographs */,
  {     2,  5760,  8989,  13,   3, UNI_NV__1_SLASH_8 }   /* numericvalue=1/8 */,
  {     1,  6918,  1472,  10,   9, UNI_LB__SG }   /* linebreak=surrogate */,
  {     2,  5760,  7463,  13,   1, UNI_NV__3 }   /* numericvalue=3 */,
  {     0,   921,     0,  18,   0, UNI_INVS }   /* variationselectors */,
  {     0,  9365,  4220,   4,   4, UNI_TANG }   /* scx=tang */,
  {     2,  9909,  4829,   7,   5, UNI_POSIXDIGIT }   /* isposixdigit */,
  {     1,  6828,  9653,  10,   3, UNI_BC__PDF }   /* bidiclass=pdf */,
  {     0,  9365,    78,   4,   4, UNI_ARAB }   /* scx=arab */,
  {     9,  4580,  6185,   4,  10, UNI_INMENDEKIKAKUI }   /* inmendekikakui */,
  {     0,  9731,   697,   3,   2, UNI_WB__MN }   /* wb=mn */,
  {     0,  8233,  7341,   7,   4, UNI_SC__PERM }   /* script=perm */,
  {     9,  9620,  3218,   3,  18, UNI_ZP }   /* gc=paragraphseparator */,
  {     2,  8886,  3728,   3,  11, UNI_SGNW }   /* sc=signwriting */,
  {     1,  8610,     0,   6,   0, UNI_RJNG }   /* rejang */,
  {     0,  6005,   219,   4,  31, UNI_DIACRITICALSEXT }   /* incombiningdiacriticalmarksextended */,
  {     9,  9629,  5325,   3,   9, UNI_LB__QU }   /* lb=quotation */,
  {     0,  8233,  9289,   7,   4, UNI_NSHU }   /* script=nshu */,
  {     0,  8424,  3884,   6,  16, UNI_GEORGIANEXT }   /* block=georgianextended */,
  {     1,  8424,   660,   7,  29, UNI_CJKEXTF }   /* block=cjkunifiedideographsextensionf */,
  {     2,  8424,  3502,   7,  16, UNI_CYRILLICEXTA }   /* block=cyrillicextendeda */,
  {    15,  8065,     0,   4,   0, UNI_ELBA }   /* elba */,
  {     2,  3671,  8894,  17,   5, UNI_LIMB }   /* scriptextensions=limbu */,
  {     3,  9620,  4687,   3,  15, UNI_PS }   /* gc=openpunctuation */,
  {     3,  9129,     0,   4,   0, UNI_cwu_values_index }   /* cwu= */,
  {     2,  9946,  8276,   3,   6, UNI_SUPPUAB }   /* issuppuab */,
  {     0,  1622,     0,   9,   0, UNI_LATINEXTE }   /* latinexte */,
  {     8,  8899,     1,   5,   1, -UNI_MATH }   /* math=n */,
  {     4,  5565,  9641,  13,   3, UNI_JG__MIM }   /* joininggroup=mim */,
  {     0,  5760,  8394,  13,   5, UNI_NV__80000 }   /* numericvalue=80000 */,
  {     3,   184,  1530,   2,  14, UNI_BYZANTINEMUSIC }   /* isbyzantinemusic */,
  {     2,  7025,  7507,   3,   4, UNI_IN__12 }   /* in=12.0 */,
  {     1,  9093,  2043,   4,  21, UNI_CJKCOMPATFORMS }   /* blk=cjkcompatibilityforms */,
  {     0,  9623,  5682,   3,  13, UNI_JG__MANICHAEANTAW }   /* jg=manichaeantaw */,
  {     0,  6005,  3837,   3,  15, UNI_CYPRIOTSYLLABARY }   /* incypriotsyllabary */,
  {     2,  8508,     0,   6,   0, UNI_grext_values_index }   /* grext= */,
  {     1,  8424,  4267,   6,   5, UNI_INBAMUM }   /* block=bamum */,
  {     0,  3254,  9433,  18,   4, UNI_RI }   /* regionalindicator=true */,
  {     8,  9946,  2837,   3,   3, UNI_SUND }   /* issund */,
  {     7,  1622,     0,   5,   0, UNI_LATN }   /* latin */,
  {     4,  9909,  6268,   3,   7, UNI_PHAISTOS }   /* isphaistos */,
  {     0,  7025,  9707,   3,   3, UNI_IN__6_DOT_1 }   /* in=v61 */,
  {     1,  9629,  7138,   3,  10, UNI_LB__WJ }   /* lb=wordjoiner */,
  {     5,  8586,     0,   7,   0, UNI_COMPEX }   /* nfcqc=n */,
  {     0,  8424,  8699,   6,   5, UNI_INBATAK }   /* block=batak */,
  {     2,  9593,     8,   3,   2, UNI_BC__AN }   /* bc=an */,
  {     1,  9629,   202,   3,   2, UNI_LB__SA }   /* lb=sa */,
  {     0,  5760,  7452,  13,   8, UNI_NV__1_SLASH_80 }   /* numericvalue=1.25e-02 */,
  {     6,  4705,  2221,   3,   3, UNI_THAI }   /* isthai */,
  {     0,  3671,  9117,  17,   4, UNI_CPRT }   /* scriptextensions=cprt */,
  {     2,  2106,    34,  21,   6, UNI_GCB__EX }   /* graphemeclusterbreak=extend */,
  {     1,  1713,     3,  22,   1, -UNI_CWCF }   /* changeswhencasefolded=f */,
  {     2,  5760,  8370,  13,   6, UNI_NV__432000 }   /* numericvalue=432000 */,
  {     1,  4618,  2335,   4,   8, UNI_INGLAGOLITIC }   /* inglagolitic */,
  {     4,  1362,  8780,  25,   4, UNI_CCC__27 }   /* canonicalcombiningclass=ccc27 */,
  {     7,  5760,  9017,  13,   4, UNI_NV__17_SLASH_2 }   /* numericvalue=17/2 */,
  {     2,   184,  5003,   2,  14, UNI_LATINEXTB }   /* islatinextendedb */,
  {     3,  9093,   509,   4,  20, UNI_CJK }   /* blk=cjkunifiedideographs */,
  {     0,  9093,     0,   4,  42, UNI_UCASEXT }   /* blk=unifiedcanadianaboriginalsyllabicsextended */,
  {     0,  8424,  8628,   6,   6, UNI_INTHAANA }   /* block=thaana */,
  {     8,    42,     0,  36,   0, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* cjkcompatibilityideographssupplement */,
  {     8,   184,  6183,   2,  12, UNI_MEND }   /* ismendekikakui */,
  {     4,  6005,  4388,   3,  14, UNI_CURRENCYSYMBOLS }   /* incurrencysymbols */,
  {     0,  5435,    36,  13,   1, UNI_BIDIM }   /* bidimirrored=t */,
  {     1,  1735,    26,  22,   1, UNI_CWCM }   /* changeswhencasemapped=y */,
  {     1,  1497,   406,   9,   7, UNI_XPOSIXCNTRL }   /* category=control */,
  {     1,  9093,  3020,   4,  10, UNI_INDEVANAGARI }   /* blk=devanagari */,
  {     0,  6005,  2086,   3,  17, UNI_CYRILLICSUP }   /* incyrillicsupplement */,
  {     8,  6828,  5811,  10,  12, UNI_BC__AL }   /* bidiclass=arabicletter */,
  {    14,  9946,  4205,   3,   5, UNI_SYRC }   /* issyriac */,
  {     0,  9365,  7239,   4,   9, UNI_QAAI }   /* scx=inherited */,
  {     0,  8233,  9293,   7,   4, UNI_OGAM }   /* script=ogam */,
  {     0,  1159,    11,   3,   2, UNI_NT__DI }   /* nt=di */,
  {     1,  6005,   630,   3,  29, UNI_CJKEXTE }   /* incjkunifiedideographsextensione */,
  {    10,  6005,  3631,   3,   3, UNI_INCHAM }   /* incham */,
  {     3,  3671,  3110,  17,   4, UNI_GEOR }   /* scriptextensions=geor */,
  {     3,  6558,     0,  11,   0, UNI_MEDF }   /* medefaidrin */,
  {     1,  6828,  3569,  10,  17, UNI_BC__ES }   /* bidiclass=europeanseparator */,
  {     0,  9605,  9665,   3,   3, UNI_DT__SML }   /* dt=sml */,
  {     1,  9485,     0,   4,   0, UNI_QAAI }   /* zinh */,
  {     0,  8634,     3,   6,   1, -UNI_UIDEO }   /* uideo=f */,
  {     1,  8954,  9433,   5,   4, UNI_XIDC }   /* xidc=true */,
  {     4,  1084,     1,  26,   1, -UNI_CWKCF }   /* changeswhennfkccasefolded=n */,
  {     0,  9909,   468,   3,   4, UNI_P }   /* ispunct */,
  {    16,  9365,  6988,   4,  10, UNI_SOGO }   /* scx=oldsogdian */,
  {     0,  4580,  4109,   3,  15, UNI_MYANMAREXTA }   /* inmyanmarextendeda */,
  {     0,  3671,  4582,  17,  15, UNI_MERC }   /* scriptextensions=meroiticcursive */,
  {     1,   184,  5255,   2,  14, UNI_MN }   /* isnonspacingmark */,
  {     1,  9093,  2646,   4,  19, UNI_JAMOEXTA }   /* blk=hanguljamoextendeda */,
  {     6,  8886,  8135,   3,   7, UNI_SC__MAND }   /* sc=mandaic */,
  {     4,  7018,  9677,  10,   3, UNI_IN__2_DOT_1 }   /* presentin=v21 */,
  {    20,  9113,  8481,   4,   3, UNI_WB__EB }   /* ccc=133 */,
  {    17,  3671,  9413,  17,   4, UNI_TAVT }   /* scriptextensions=tavt */,
  {     0,  8586,     0,   6,   0, UNI_nfcqc_values_index }   /* nfcqc= */,
  {     2,  8233,  8002,   7,   7, UNI_SC__BENG }   /* script=bengali */,
  {     2,  8016,     0,   7,   0, UNI_CJKEXTB }   /* cjkextb */,
  {     0,  9629,  4357,   3,  15, UNI_LB__CB }   /* lb=contingentbreak */,
  {     0,   414,     0,  11,   0, UNI_IDEO }   /* ideographic */,
  {    10,  8233,  8430,   7,   6, UNI_CARI }   /* script=carian */,
  {    11,  9365,  8484,   4,   6, UNI_CAKM }   /* scx=chakma */,
  {     1,  5760,  8664,  13,   4, UNI_NV__1_SLASH_16 }   /* numericvalue=1/16 */,
  {     0,  9093,  8296,   4,   7, UNI_INTAIVIET }   /* blk=taiviet */,
  {     2,  9193,     0,   4,   0, UNI_hst_values_index }   /* hst= */,
  {     4,  9193,  6525,   4,   3, UNI_LB__H3 }   /* hst=lvt */,
  {     1,  3688,   995,  17,   2, -UNI_STERM }   /* sentenceterminal=no */,
  {     1,  9623,  6327,   3,  11, UNI_JG__AFRICANNOON }   /* jg=africannoon */,
  {     2,  9647,  7558,   3,   2, UNI_NV__13 }   /* nv=13 */,
  {     0,  9365,  1622,   4,   5, UNI_LATN }   /* scx=latin */,
  {     0,  9901,  1812,   8,   5, UNI_XPOSIXUPPER }   /* isxposixupper */,
  {     1,   184,  8024,   3,   6, UNI_CJKEXTC }   /* iscjkextc */,
  {     0,  9647,  8358,   3,   2, UNI_NV__30 }   /* nv=30 */,
  {     0,   184,  9269,   2,   4, UNI_MYMR }   /* ismymr */,
  {     8,  8886,  8430,   3,   6, UNI_CARI }   /* sc=carian */,
  {    26,  9647,  8400,   3,   6, UNI_NV__900000 }   /* nv=900000 */,
  {     0,  8233,  9453,   7,   3, UNI_VAI }   /* script=vai */,
  {     0,  9365,  8514,   4,   6, UNI_HATR }   /* scx=hatran */,
  {     0,  8424,  5283,   6,  14, UNI_PHONETICEXTSUP }   /* block=phoneticextsup */,
  {     8,  8886,  7311,   3,   9, UNI_TALU }   /* sc=newtailue */,
  {     0,  9909,     6,   3,   1, UNI_PD }   /* ispd */,
  {     4,  8886,  9469,   3,   4, UNI_XSUX }   /* sc=xsux */,
  {     0,  9093,  4989,   4,   6, UNI_KANGXI }   /* blk=kangxi */,
  {     3,  2779,     0,  12,   0, UNI_MONGOLIANSUP }   /* mongoliansup */,
  {     8,  9093,  1030,   4,  27, UNI_OCR }   /* blk=opticalcharacterrecognition */,
  {     1,  2106,  5943,  21,  12, UNI_WB__EB }   /* graphemeclusterbreak=glueafterzwj */,
  {     0,  7025,  9689,   3,   3, UNI_IN__4 }   /* in=v40 */,
  {     0,  6918,  4357,  10,  15, UNI_LB__CB }   /* linebreak=contingentbreak */,
  {     1,  5760,  9014,  13,   3, UNI_NV__5_SLASH_2 }   /* numericvalue=5/2 */,
  {     2,  9909,  1812,   7,   5, UNI_POSIXUPPER }   /* isposixupper */,
  {     4,  8556,    26,   6,   1, UNI_XPOSIXLOWER }   /* lower=y */,
  {     3,  9647,  7724,   3,   8, UNI_NV__4_SLASH_5 }   /* nv=8.00e-01 */,
  {     0,  8424,  1955,   6,  22, UNI_MISCTECHNICAL }   /* block=miscellaneoustechnical */,
  {     8,  2703,  9734,  19,   3, UNI_IDST }   /* idstrinaryoperator=yes */,
  {     0,  8424,   719,   6,  30, UNI_ENCLOSEDALPHANUMSUP }   /* block=enclosedalphanumericsupplement */,
  {     1,  8233,  9329,   7,   4, UNI_PRTI }   /* script=prti */,
  {     0,  9909,  7009,   3,   9, UNI_PHNX }   /* isphoenician */,
  {     0,  9113,  8835,   5,   4, UNI_CCC__91 }   /* ccc=ccc91 */,
  {     2,  8424,  1506,   6,  24, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* block=supsymbolsandpictographs */,
  {     2,  9620,  3852,   3,  16, UNI_PF }   /* gc=finalpunctuation */,
  {     8,  8879,   838,   3,  10, UNI_PHONETICEXT }   /* inphoneticext */,
  {     1,  3671,  9089,  17,   4, UNI_BHKS }   /* scriptextensions=bhks */,
  {    18,  9605,  3852,   3,   3, UNI_DT__FIN }   /* dt=fin */,
  {     1,  6003,     0,  12,   0, UNI_joinc_values_index }   /* joincontrol= */,
  {     1,  8424,  1622,   6,  14, UNI_LATINEXTA }   /* block=latinextendeda */,
  {     0,  5565,  4954,  13,   3, UNI_JG__HEH }   /* joininggroup=heh */,
  {     0,  9093,  3200,   4,  18, UNI_ORNAMENTALDINGBATS }   /* blk=ornamentaldingbats */,
  {     2,  8406,    36,   6,   1, UNI_XPOSIXALPHA }   /* alpha=t */,
  {     2,  8424,  4108,   6,  16, UNI_MYANMAREXTA }   /* block=myanmarextendeda */,
  {     1,  1735,  8864,  22,   5, -UNI_CWCM }   /* changeswhencasemapped=false */,
  {     2,  8424,   570,   7,  29, UNI_CJKEXTC }   /* block=cjkunifiedideographsextensionc */,
  {     1,  4361,  3886,   4,  14, UNI_GEORGIANEXT }   /* ingeorgianextended */,
  {     4,  1757,  8864,  22,   5, -UNI_CWL }   /* changeswhenlowercased=false */,
  {     5,  9365,  9277,   4,   4, UNI_NBAT }   /* scx=nbat */,
  {     1,  9365,  8296,   4,   7, UNI_TAVT }   /* scx=taiviet */,
  {     1,  1497,  3852,   9,  16, UNI_PF }   /* category=finalpunctuation */,
  {     2,  6385,  2800,   4,  17, UNI_OTTOMANSIYAQNUMBERS }   /* inottomansiyaqnumbers */,
  {     1,  9093,  1531,   5,  13, UNI_BYZANTINEMUSIC }   /* blk=byzantinemusic */,
  {     3,  4108,     0,   7,   0, UNI_MYMR }   /* myanmar */,
  {     0,  3868,  1187,  16,   2, UNI_SK }   /* generalcategory=sk */,
  {    12,  8163,    26,   7,   1, UNI_NFKCQC__Y }   /* nfkcqc=y */,
  {     0,  8844,  9433,   5,   4, UNI_CWCF }   /* cwcf=true */,
  {     0,  9093,  5859,   4,  12, UNI_CHESSSYMBOLS }   /* blk=chesssymbols */,
  {     0,  5565,  5181,  13,   4, UNI_JG__TETH }   /* joininggroup=teth */,
  {    17,  2106,  1855,  21,   2, UNI_GCB__CN }   /* graphemeclusterbreak=cn */,
  {    11,  8332,  9058,   3,   3, UNI_AHOM }   /* isahom */,
  {     0,  7932,     3,   8,   1, -UNI_RADICAL }   /* radical=f */,
  {     1,  8233,  7338,   7,   9, UNI_SC__PERM }   /* script=oldpermic */,
  {     2,  8332,   833,   4,   4, UNI_ARROWS }   /* isarrows */,
  {    10,  5500,     0,  13,   0, UNI_ME }   /* enclosingmark */,
  {     0,  2106,   262,  21,   2, UNI_GCB__SM }   /* graphemeclusterbreak=sm */,
  {     0,  8886,  9321,   3,   4, UNI_PHNX }   /* sc=phnx */,
  {     0,  9620,  5255,   3,  14, UNI_MN }   /* gc=nonspacingmark */,
  {     2,  8107,     0,   7,   0, UNI_KNDA }   /* kannada */,
  {     1,  3868,    47,  16,   1, UNI_M }   /* generalcategory=m */,
  {    12,  9620,  4140,   3,   5, UNI_C }   /* gc=other */,
  {     2,  8424,  3326,   6,  18, UNI_TAIXUANJING }   /* block=taixuanjingsymbols */,
  {     3,  6338,    36,  11,   1, UNI_XPOSIXALPHA }   /* alphabetic=t */,
  {     2,  1497,  3146,   9,  18, UNI_PI }   /* category=initialpunctuation */,
  {     1,  8884,  5395,   5,  14, UNI_INSC__VOWELDEPENDENT }   /* insc=voweldependent */,
  {     0,  9629,   533,   3,   2, UNI_LB__NS }   /* lb=ns */,
  {     5,  7018,  7508,  10,   3, UNI_IN__2 }   /* presentin=2.0 */,
  {     1,  8424,  2006,   6,   4, UNI_INMODI }   /* block=modi */,
  {     0,  9365,  9305,   4,   4, UNI_ORYA }   /* scx=orya */,
  {    16,  6918,  5952,  10,   2, UNI_LB__ZW }   /* linebreak=zw */,
  {     8,  3671,  7956,  17,   8, UNI_TAGB }   /* scriptextensions=tagbanwa */,
  {     3,  9113,  5539,   4,  13, UNI_CCC__IS }   /* ccc=iotasubscript */,
  {     2,  5760,  5410,  13,   1, UNI_NV__0 }   /* numericvalue=0 */,
  {     0,  9113,  6818,   4,  10, UNI_CCC__BR }   /* ccc=belowright */,
  {     8,  9481,     0,   4,   0, UNI_ZANB }   /* zanb */,
  {    23,  8233,  9413,   7,   4, UNI_TAVT }   /* script=tavt */,
  {    23,  8886,  4672,   3,  15, UNI_SARB }   /* sc=oldsoutharabian */,
  {     0,  2204,  4688,   3,  14, UNI_PS }   /* isopenpunctuation */,
  {     0,  1159,     0,   3,   0, UNI_nt_values_index }   /* nt= */,
  {    16,  8233,  7980,   7,   4, UNI_UGAR }   /* script=ugar */,
  {     0,  9093,  9233,   4,   4, UNI_LISU }   /* blk=lisu */,
  {    12,  9946,  8269,   3,   6, UNI_SUPPUAA }   /* issuppuaa */,
  {     2,   184,  3688,   2,  16, UNI_STERM }   /* issentenceterminal */,
  {     1,  8424,  7812,   6,   8, UNI_INDUPLOYAN }   /* block=duployan */,
  {     0,   184,  2931,   3,   7, UNI_CHER }   /* ischerokee */,
  {     0,  3951,  1852,   3,  15, UNI_INDICNUMBERFORMS }   /* isindicnumberforms */,
  {     0,  1084,  9433,  26,   4, UNI_CWKCF }   /* changeswhennfkccasefolded=true */,
  {     1,  7018,     0,  10,   0, UNI_in_values_index }   /* presentin= */,
  {     8,  6828,  2413,  10,  20, UNI_BC__PDF }   /* bidiclass=popdirectionalformat */,
  {     0,  3671,  6724,  18,  10, UNI_SYLO }   /* scriptextensions=sylotinagri */,
  {     1,   878,     0,  10,   0, UNI_CO }   /* privateuse */,
  {     7,  8616,    26,   6,   1, UNI_STERM }   /* sterm=y */,
  {     2,  9153,  9773,   4,   2, UNI_GCB__XX }   /* gcb=xx */,
  {    13,  1497,  2273,   9,  20, UNI_PC }   /* category=connectorpunctuation */,
  {     2,  9113,  6481,   4,  11, UNI_CCC__8 }   /* ccc=kanavoicing */,
  {     0,   184,  1532,   2,   1, UNI_Z }   /* isz */,
  {     0,  9113,  3433,   4,  13, UNI_CCC__202 }   /* ccc=attachedbelow */,
  {     1,  1801,     0,  21,   0, UNI_CWU }   /* changeswhenuppercased */,
  {     9,  8886,  8149,   3,   7, UNI_SC__MULT }   /* sc=multani */,
  {     3,  3671,  7302,  17,   9, UNI_NBAT }   /* scriptextensions=nabataean */,
  {     0,    34,     0,   3,   0, UNI_EXT }   /* ext */,
  {     2,  8424,  4821,   6,   5, UNI_ASCII }   /* block=ascii */,
  {     1,  8685,  9734,   4,   3, UNI_XPOSIXXDIGIT }   /* hex=yes */,
  {     5,  9365,  3772,   4,   4, UNI_BOPO }   /* scx=bopo */,
  {     0,  1767,     0,   2,   0, UNI_NL }   /* nl */,
  {     1,  9365,  9257,   4,   4, UNI_MLYM }   /* scx=mlym */,
  {     1,  9620,   106,   3,   6, UNI_S }   /* gc=symbol */,
  {     3,  3002,  9668,  18,   3, UNI_DT__SQR }   /* decompositiontype=sqr */,
  {    16,  2703,     1,  19,   1, -UNI_IDST }   /* idstrinaryoperator=n */,
  {     3,  1362,  8755,  25,   4, UNI_CCC__22 }   /* canonicalcombiningclass=ccc22 */,
  {     0,  9113,  9533,   4,   3, UNI_CCC__A }   /* ccc=230 */,
  {     2,  6816,  6809,   3,   9, UNI_ASCII }   /* inbasiclatin */,
  {     1,  7025,  7159,   3,   3, UNI_IN__5 }   /* in=5.0 */,
  {     2,  9049,  7502,   4,   1, UNI_AGE__8 }   /* age=8 */,
  {     2,  9647,  9009,   3,   4, UNI_NV__13_SLASH_2 }   /* nv=13/2 */,
  {    11,  9620,  2273,   3,  20, UNI_PC }   /* gc=connectorpunctuation */,
  {     9,  8886,  2211,   3,   7, UNI_SC__SINH }   /* sc=sinhala */,
  {     2,    78,     0,  35,   0, UNI_ARABICMATH }   /* arabicmathematicalalphabeticsymbols */,
  {     3,  2493,  3362,  20,  18, UNI_VO__TR }   /* verticalorientation=transformedrotated */,
  {     1,  3868,  1036,  16,   2, UNI_CASEDLETTER }   /* generalcategory=lc */,
  {     0,  2493,   471,  20,   2, UNI_VO__TU }   /* verticalorientation=tu */,
  {     0,  8160,   721,   4,  28, UNI_ENCLOSEDALPHANUMSUP }   /* inenclosedalphanumericsupplement */,
  {     7,  7025,  7463,   3,   1, UNI_IN__3 }   /* in=3 */,
  {     0,  1239,   995,  25,   2, -UNI_COMPEX }   /* fullcompositionexclusion=no */,
  {     1,  9161,     0,   4,   0, UNI_GONM }   /* gonm */,
  {     9,  8844,    26,   5,   1, UNI_CWCF }   /* cwcf=y */,
  {     8,  9365,  8944,   4,   4, UNI_TAKR }   /* scx=takr */,
  {    10,  3243,     1,  11,   1, -UNI_XPOSIXSPACE }   /* whitespace=n */,
  {     5,  6918,   340,  10,   2, UNI_LB__OP }   /* linebreak=op */,
  {     0,  6567,  1959,   6,  18, UNI_MISCTECHNICAL }   /* inmiscellaneoustechnical */,
  {    10,  2169,     0,  14,   0, UNI_MEETEIMAYEKEXT }   /* meeteimayekext */,
  {     0,   184,  6492,   2,  11, UNI_KATAKANAEXT }   /* iskatakanaext */,
  {     6,   976,     0,  27,   0, UNI_ANCIENTGREEKMUSIC }   /* ancientgreekmusicalnotation */,
  {    42,  1362,  7539,  24,   2, UNI_CCC__22 }   /* canonicalcombiningclass=22 */,
  {     0,  6624,     0,  11,   0, UNI_NO }   /* othernumber */,
  {     0,  3868,  3227,  16,   9, UNI_Z }   /* generalcategory=separator */,
  {     0,  3200,     0,  18,   0, UNI_ORNAMENTALDINGBATS }   /* ornamentaldingbats */,
  {     5,   184,  7118,   2,   4, UNI_WARA }   /* iswara */,
  {     0,  9093,  6267,   4,  12, UNI_PHAISTOS }   /* blk=phaistosdisc */,
  {     3,  8886,  9253,   3,   4, UNI_MIAO }   /* sc=miao */,
  {     1,  1933,  9433,  22,   4, UNI_LOE }   /* logicalorderexception=true */,
  {     0,  9313,     0,   3,   0, UNI_PCM }   /* pcm */,
  {     0,  1243,     1,  21,   1, -UNI_CE }   /* compositionexclusion=n */,
  {     2,  9093,  4807,   4,  14, UNI_ANCIENTSYMBOLS }   /* blk=ancientsymbols */,
  {     1,  9365,  7049,   5,   3, UNI_SAUR }   /* scx=saur */,
  {     4,  1362,  8449,  25,   5, UNI_CCC__118 }   /* canonicalcombiningclass=ccc118 */,
  {     1,  9623,  6788,   3,  10, UNI_JG__AFRICANQAF }   /* jg=africanqaf */,
  {     2,   184,  5578,   2,  13, UNI_KANAEXTA }   /* iskanaextendeda */,
  {     0,  3671,  9225,  17,   4, UNI_LINA }   /* scriptextensions=lina */,
  {     1,  8886,  2984,   3,   4, UNI_SC__COPT }   /* sc=copt */,
  {     0,  8233,  7812,   7,   8, UNI_SC__DUPL }   /* script=duployan */,
  {     0,  8051,    36,   7,   1, UNI_COMPEX }   /* compex=t */,
  {     3,  8886,  9117,   3,   4, UNI_SC__CPRT }   /* sc=cprt */,
  {     0,  1779,  9734,  22,   3, UNI_CWT }   /* changeswhentitlecased=yes */,
  {    24,  3326,     0,  18,   0, UNI_TAIXUANJING }   /* taixuanjingsymbols */,
  {     9,  9946,  8262,   3,   3, UNI_SOYO }   /* issoyo */,
  {     9,  9647,  7571,   3,   2, UNI_NV__33 }   /* nv=33 */,
  {     0,  8233,  2393,   7,  20, UNI_HMNP }   /* script=nyiakengpuachuehmong */,
  {     2,  8424,  8121,   6,   7, UNI_INLINEARA }   /* block=lineara */,
  {     0,  2493,  3248,   4,   5, UNI_VERTSPACE }   /* vertspace */,
  {    10,  6015,     6,  12,   1, UNI_JT__D }   /* joiningtype=d */,
  {     5,  9608,  4290,   3,   7, UNI_EA__N }   /* ea=neutral */,
  {     1,  9623,  9656,   3,   3, UNI_JG__REH }   /* jg=reh */,
  {     8,  8424,  2779,   6,   9, UNI_INMONGOLIAN }   /* block=mongolian */,
  {     1,  9662,     3,   3,   1, -UNI_SD }   /* sd=f */,
  {     1,  3002,  7868,  18,   8, UNI_DT__ISO }   /* decompositiontype=isolated */,
  {     0,   184,  8031,   3,   6, UNI_CJKEXTD }   /* iscjkextd */,
  {     6,  9647,  7636,   3,   8, UNI_NV__1_SLASH_20 }   /* nv=5.00e-02 */,
  {     2,  1497,  5500,   9,  13, UNI_ME }   /* category=enclosingmark */,
  {     1,  8960,     3,   4,   1, -UNI_IDS }   /* ids=f */,
  {     1,  8233,  9045,   7,   4, UNI_SC__ADLM }   /* script=adlm */,
  {     1,  9365,  8248,   5,   6, UNI_SHAW }   /* scx=shavian */,
  {     0,  6371,     1,  11,   1, -UNI_DEP }   /* deprecated=n */,
  {    10,  9093,  8939,   4,   5, UNI_INTAILE }   /* blk=taile */,
  {     0,   184,  9273,   2,   4, UNI_NARB }   /* isnarb */,
  {     2,  8849,     3,   5,   1, -UNI_CWCM }   /* cwcm=f */,
  {     1,  2684,  6938,  19,  10, UNI_LB__H2 }   /* hangulsyllabletype=lvsyllable */,
  {     0,  8604,  9734,   6,   3, UNI_QMARK }   /* qmark=yes */,
  {     1,  9728,    26,   3,   1, UNI_VS }   /* vs=y */,
  {     3,  8233,  1573,   7,   4, UNI_SC__PHAG }   /* script=phag */,
  {     5,  5760,  9009,  13,   4, UNI_NV__13_SLASH_2 }   /* numericvalue=13/2 */,
  {     4,  3164,     0,  18,   0, UNI_LATINEXTADDITIONAL }   /* latinextadditional */,
  {     0,  8086,    26,   7,   1, UNI_GRBASE }   /* grbase=y */,
  {     9,  5760,  7659,  13,   2, UNI_NV__16 }   /* numericvalue=16 */,
  {     2,  8424,  8296,   6,   7, UNI_INTAIVIET }   /* block=taiviet */,
  {     0,  5604,     0,  13,   0, UNI_LOWSURROGATES }   /* lowsurrogates */,
  {     1,  6918,  7138,  10,  10, UNI_LB__WJ }   /* linebreak=wordjoiner */,
  {     8,  2148,  7941,   3,   7, UNI_SPECIALS }   /* inspecials */,
  {     1,  6828,    18,  10,   1, UNI_BC__R }   /* bidiclass=r */,
  {     1,  3671,  6159,  17,  12, UNI_GONM }   /* scriptextensions=masaramgondi */,
  {     1,  9365,  8310,   4,   7, UNI_TIRH }   /* scx=tirhuta */,
  {     0,  9923,  8305,   4,   5, UNI_INTIBETAN }   /* intibetan */,
  {     9,  1362,  8455,  25,   5, UNI_CCC__122 }   /* canonicalcombiningclass=ccc122 */,
  {     0,  9909,  8220,   3,   5, UNI_PATSYN }   /* ispatsyn */,
  {     8,  8886,  8894,   3,   4, UNI_SC__LIMB }   /* sc=limb */,
  {     0,  8556,     0,   6,   0, UNI_lower_values_index }   /* lower= */,
  {     3,  6949,   533,   4,   2, UNI_CANS }   /* iscans */,
  {     0,  3671,  1482,  18,   3, UNI_SIND }   /* scriptextensions=sind */,
  {     0,  5760,  9590,  13,   3, UNI_NV__9_SLASH_2 }   /* numericvalue=9/2 */,
  {     0,  5227,     0,  16,   0, UNI_DT__CAN }   /* nfdquickcheck=no */,
  {     1,  8886,  9421,   3,   4, UNI_SC__TGLG }   /* sc=tglg */,
  {     0,  9093,  2085,   4,  11, UNI_CYRILLICSUP }   /* blk=cyrillicsup */,
  {     2,  9365,  8121,   4,   7, UNI_LINA }   /* scx=lineara */,
  {     0,  9097,     1,   4,   1, UNI_BPT__N }   /* bpt=n */,
  {     0,  1911,  3484,  22,  17, UNI_INSC__CONSONANTPREFIXED }   /* indicsyllabiccategory=consonantprefixed */,
  {     0,  6051,     0,  12,   0, UNI_MAHJONG }   /* mahjongtiles */,
  {     0,  9093,  8275,   4,   7, UNI_SUPPUAB }   /* blk=suppuab */,
  {     1,  1497,     0,  10,   0, UNI_S }   /* category=s */,
  {     3,  6885,  9190,   3,   3, UNI_HMNP }   /* ishmnp */,
  {     0,  8233,  3620,   7,  10, UNI_SC__MANI }   /* script=manichaean */,
  {     0,  5760,  8394,  13,   2, UNI_NV__80 }   /* numericvalue=80 */,
  {     6,  8268,     0,   7,   0, UNI_SUPPUAA }   /* suppuaa */,
  {     2,  8886,  6602,   3,  11, UNI_SC__NAND }   /* sc=nandinagari */,
  {     0,  9093,  3773,   5,  10, UNI_BOPOMOFOEXT }   /* blk=bopomofoext */,
  {     2,  8886,  3620,   3,   4, UNI_SC__MANI }   /* sc=mani */,
  {     1,  8332,  9046,   3,   3, UNI_ADLM }   /* isadlm */,
  {     9,    21,  4975,   2,   7, UNI_KANASUP }   /* inkanasup */,
  {     0,  8886,  8919,   3,   5, UNI_OGAM }   /* sc=ogham */,
  {     0,  1158,  8228,   3,   3, UNI_TAGS }   /* intags */,
  {     0,  9953,  9454,   3,   3, UNI_VAI }   /* isvaii */,
  {     0,  6005,  4379,   9,   8, UNI_CONTROLPICTURES }   /* incontrolpictures */,
  {     4,  4204,     0,  16,   0, UNI_SYRIACSUP }   /* syriacsupplement */,
  {     0,  7108,  8864,  10,   5, -UNI_XPOSIXUPPER }   /* uppercase=false */,
  {     9,  8556,    36,   6,   1, UNI_XPOSIXLOWER }   /* lower=t */,
  {     1,   184,  4402,   2,  15, UNI_PD }   /* isdashpunctuation */,
  {     1,  9113,  8212,   4,   7, UNI_CCC__1 }   /* ccc=overlay */,
  {     0,  1362,  8443,  25,   5, UNI_CCC__107 }   /* canonicalcombiningclass=ccc107 */,
  {     0,  2127,     0,  14,   0, UNI_ROHG }   /* hanifirohingya */,
  {     7,  6005,  3536,   3,  16, UNI_CYRILLICEXTC }   /* incyrillicextendedc */,
  {     4,  5760,  8388,  13,   6, UNI_NV__700000 }   /* numericvalue=700000 */,
  {     1,  9629,  1767,   3,   2, UNI_LB__NL }   /* lb=nl */,
  {     0,    21,  2514,   3,  18, UNI_ANCIENTGREEKNUMBERS }   /* inancientgreeknumbers */,
  {     4,  9113,  8760,   5,   4, UNI_CCC__23 }   /* ccc=ccc23 */,
  {     1,  9731,  8156,   3,   7, UNI_WB__NL }   /* wb=newline */,
  {     2,  3671,  8255,  18,   3, UNI_SIDD }   /* scriptextensions=sidd */,
  {     0,  5339,  4140,  14,   5, UNI_SB__XX }   /* sentencebreak=other */,
  {     0,  5760,  7159,  13,   1, UNI_NV__5 }   /* numericvalue=5 */,
  {     0,   184,  3038,   2,   8, UNI_ETHI }   /* isethiopic */,
  {     2,  8338,     3,   7,   1, -UNI_XPOSIXSPACE }   /* wspace=f */,
  {     1,  1362,  2379,  24,   5, UNI_CCC__R }   /* canonicalcombiningclass=right */,
  {     0,  7266,     0,   9,   0, UNI_LATINEXTC }   /* latinextc */,
  {     2,  9153,    70,   4,   2, UNI_GCB__PP }   /* gcb=pp */,
  {     0,  9629,   125,   3,   2, UNI_LB__CR }   /* lb=cr */,
  {     0,  9365,  8135,   4,   7, UNI_MAND }   /* scx=mandaic */,
  {     0,  9647,  7540,   3,   3, UNI_NV__200 }   /* nv=200 */,
  {     8,  3688,     3,  17,   1, -UNI_STERM }   /* sentenceterminal=f */,
  {     7,   184,  2836,   2,  19, UNI_SUNDANESESUP }   /* issundanesesupplement */,
  {     0,  9725,  3373,   3,   7, UNI_VO__R }   /* vo=rotated */,
  {     8,  8233,  6978,   7,  10, UNI_XPEO }   /* script=oldpersian */,
  {     1,  6888,     1,  10,   1, -UNI_DIA }   /* diacritic=n */,
  {     0,  3398,  9433,  18,   4, UNI_VS }   /* variationselector=true */,
  {     1,  6828,  2373,  10,  11, UNI_BC__L }   /* bidiclass=lefttoright */,
  {    10,  7018,  9445,  10,   4, UNI_IN__12 }   /* presentin=v120 */,
  {     0,  5565,  6327,  13,  11, UNI_JG__AFRICANNOON }   /* joininggroup=africannoon */,
  {     0,  2148,  1265,   3,  24, UNI_SUPERANDSUB }   /* insuperscriptsandsubscripts */,
  {     9,  3671,  4297,  17,   4, UNI_BRAI }   /* scriptextensions=brai */,
  {     5,  3868,  1472,  16,   9, UNI__PERL_SURROGATE }   /* generalcategory=surrogate */,
  {     4,  8684,    26,   5,   1, UNI_POSIXXDIGIT }   /* ahex=y */,
  {     0,  8233,  2212,   8,   6, UNI_SC__SINH }   /* script=sinhala */,
  {     1,  8338,  9433,   7,   4, UNI_XPOSIXSPACE }   /* wspace=true */,
  {     0,   184,  2836,   2,  12, UNI_SUNDANESESUP }   /* issundanesesup */,
  {    18,  9593,  5823,   3,  12, UNI_BC__AN }   /* bc=arabicnumber */,
  {     0,  9093,  9285,   4,   3, UNI_INNKO }   /* blk=nko */,
  {     1,  9093,   949,   4,  27, UNI_ALPHABETICPF }   /* blk=alphabeticpresentationforms */,
  {     1,  9647,  9010,   3,   3, UNI_NV__3_SLASH_2 }   /* nv=3/2 */,
  {     1,  3836,     0,  16,   0, UNI_CYPRIOTSYLLABARY }   /* cypriotsyllabary */,
  {     0,  8233,  9109,   7,   4, UNI_CANS }   /* script=cans */,
  {     6,  3671,  8562,  17,   6, UNI_LYCI }   /* scriptextensions=lycian */,
  {     8,  9113,  8443,   5,   5, UNI_CCC__107 }   /* ccc=ccc107 */,
  {     3,  8886,  7341,   3,   4, UNI_SC__PERM }   /* sc=perm */,
  {     6,  8879,  3344,   5,  10, UNI_INPC__TOPANDLEFT }   /* inpc=topandleft */,
  {     0,  8886,  8894,   3,   5, UNI_SC__LIMB }   /* sc=limbu */,
  {     2,  1497,    44,  10,   1, UNI_SK }   /* category=sk */,
  {     1,  9049,  9437,   4,   4, UNI_AGE__10 }   /* age=v100 */,
  {     3,  8886,  4297,   3,   7, UNI_BRAI }   /* sc=braille */,
  {     3,  5565,  6063,  13,  12, UNI_JG__MALAYALAMBHA }   /* joininggroup=malayalambha */,
  {     0,  9365,  8939,   4,   5, UNI_TALE }   /* scx=taile */,
  {     1,  3110,     0,  11,   0, UNI_GEORGIANSUP }   /* georgiansup */,
  {     0,   184,  5031,   2,  14, UNI_LATINEXTD }   /* islatinextendedd */,
  {     1,  1264,     0,  25,   0, UNI_SUPERANDSUB }   /* superscriptsandsubscripts */,
  {     2,  3671,  8072,  17,   7, UNI_ELYM }   /* scriptextensions=elymaic */,
  {     5,  9623,  9596,   3,   3, UNI_JG__BEH }   /* jg=beh */,
  {     2,  7088,     0,  10,   0, UNI_SUPARROWSC }   /* suparrowsc */,
  {     8,  7025,  7487,   3,   1, UNI_IN__6 }   /* in=6 */,
  {     9,  6918,    18,  10,   2, UNI_RI }   /* linebreak=ri */,
  {     2,  7025,  9441,   3,   4, UNI_IN__11 }   /* in=v110 */,
  {     1,   184,  8121,   2,   7, UNI_LINA }   /* islineara */,
  {     2,  9647,  8394,   3,   4, UNI_NV__8000 }   /* nv=8000 */,
  {     3,  8424,  6602,   6,  11, UNI_INNANDINAGARI }   /* block=nandinagari */,
  {     5,  6005,   570,   3,  29, UNI_CJKEXTC }   /* incjkunifiedideographsextensionc */,
  {     3,  5565,  9061,  13,   4, UNI_JG__ALEF }   /* joininggroup=alef */,
  {     3,  6816,  1189,   3,   4, UNI_INBATAK }   /* inbatak */,
  {     0,  5565,  4522,  13,  15, UNI_JG__MANICHAEANALEPH }   /* joininggroup=manichaeanaleph */,
  {     0,  9129,     1,   4,   1, -UNI_CWU }   /* cwu=n */,
  {     4,  9365,  9453,   4,   3, UNI_VAI }   /* scx=vai */,
  {     0,  3868,   878,  16,  10, UNI_CO }   /* generalcategory=privateuse */,
  {     2,   184,  6591,   2,  11, UNI_MYANMAREXTB }   /* ismyanmarextb */,
  {     2,   184,  5353,   2,  14, UNI_ZS }   /* isspaceseparator */,
  {    13,  8424,  2741,   6,  19, UNI_MERO }   /* block=meroitichieroglyphs */,
  {     0,  2006,     0,  15,   0, UNI_MODIFIERLETTERS }   /* modifierletters */,
  {     0,  1362,  8782,  24,   2, UNI_CCC__27 }   /* canonicalcombiningclass=27 */,
  {     1,  9117,     0,   4,   0, UNI_CPRT }   /* cprt */,
  {     2,   184,  6712,   2,  11, UNI_SUPERANDSUB }   /* issuperandsub */,
  {     1,  8219,   995,   7,   2, -UNI_PATSYN }   /* patsyn=no */,
  {    11,   184,  3722,   2,  17, UNI_SUTTONSIGNWRITING }   /* issuttonsignwriting */,
  {     5,  9193,    36,   4,   1, UNI_GCB__T }   /* hst=t */,
  {     0,    21,  9217,   2,   3, UNI_INLAO }   /* inlao */,
  {    10,  9647,  7159,   3,   1, UNI_NV__5 }   /* nv=5 */,
  {     2,  9093,  3038,   4,  11, UNI_ETHIOPICSUP }   /* blk=ethiopicsup */,
  {     0,  9593,  4156,   3,  16, UNI_BC__S }   /* bc=segmentseparator */,
  {     1,  7025,  9680,   3,   3, UNI_IN__3 }   /* in=v30 */,
  {     1,  3671,  9221,  17,   4, UNI_LATN }   /* scriptextensions=latn */,
  {     0,  6315,     0,   4,   0, UNI_XIDC }   /* xidc */,
  {     0,  6005,  2931,   3,   7, UNI_INCHEROKEE }   /* incherokee */,
  {     1,  6918,   414,  10,  11, UNI_LB__ID }   /* linebreak=ideographic */,
  {     8,  8871,   495,   3,   7, UNI_SB__NU }   /* sb=numeric */,
  {     1,  9647,  8722,   3,   2, UNI_NV__15 }   /* nv=15 */,
  {     2,  4220,     0,  16,   0, UNI_TANGUTCOMPONENTS }   /* tangutcomponents */,
  {     8,  8418,  9734,   6,   3, UNI_BIDIM }   /* bidim=yes */,
  {     3,  5760,  8973,  13,   4, UNI_NV__1_SLASH_10 }   /* numericvalue=1/10 */,
  {     3,  5979,     1,  12,   1, -UNI_IDEO }   /* ideographic=n */,
  {    16,  8424,  1846,   7,  21, UNI_INDICNUMBERFORMS }   /* block=commonindicnumberforms */,
  {     0,  9365,  9321,   4,   4, UNI_PHNX }   /* scx=phnx */,
  {     0,  8869,   995,   5,   2, -UNI_IDSB }   /* idsb=no */,
  {     3,    21,  3996,   2,  16, UNI_LINEARBSYLLABARY }   /* inlinearbsyllabary */,
  {     8,  9093,  2836,   4,  19, UNI_SUNDANESESUP }   /* blk=sundanesesupplement */,
  {     0,  6918,  8100,  10,   2, UNI_LB__HY }   /* linebreak=hy */,
  {     0,  8510,     1,   4,   1, -UNI_EXT }   /* ext=n */,
  {     1,  8685,  9433,   4,   4, UNI_XPOSIXXDIGIT }   /* hex=true */,
  {     1,  9365,  7332,   4,   4, UNI_ITAL }   /* scx=ital */,
  {     0,   184,  2741,   2,  19, UNI_MERO }   /* ismeroitichieroglyphs */,
  {     5,  9647,  7159,   3,   8, UNI_NV__1_SLASH_2 }   /* nv=5.00e-01 */,
  {     1,  3951,     6,   3,   2, UNI_IDC }   /* isidc */,
  {     0,  5760,  8358,  13,   2, UNI_NV__30 }   /* numericvalue=30 */,
  {     0,   184,  4297,   2,  15, UNI_BRAI }   /* isbraillepatterns */,
  {     8,  9093,  6712,   4,  11, UNI_SUPERANDSUB }   /* blk=superandsub */,
  {     3,  9593,    23,   3,   2, UNI_BC__AL }   /* bc=al */,
  {     6,  7128,  7825,  10,   3, UNI_WB__EB }   /* wordbreak=gaz */,
  {     1,  9623,  5643,   3,  13, UNI_JG__MANICHAEANMEM }   /* jg=manichaeanmem */,
  {     0,  1911,  7972,  22,   8, UNI_INSC__TONEMARK }   /* indicsyllabiccategory=tonemark */,
  {     0,  3671,  9105,  17,   4, UNI_CAKM }   /* scriptextensions=cakm */,
  {     0,  9728,    36,   3,   1, UNI_VS }   /* vs=t */,
  {     1,  3671,  9417,  17,   4, UNI_TFNG }   /* scriptextensions=tfng */,
  {     3,  6928,     0,  10,   0, UNI_lower_values_index }   /* lowercase= */,
  {    18,  9623,  5695,   3,  13, UNI_JG__MANICHAEANTEN }   /* jg=manichaeanten */,
  {     2,  6005,  8485,   3,   5, UNI_INCHAKMA }   /* inchakma */,
  {     0,  4705,  4718,   3,  14, UNI_TAMILSUP }   /* istamilsupplement */,
  {     1,  5760,  8722,  13,   2, UNI_NV__15 }   /* numericvalue=15 */,
  {     0,  8954,     1,   5,   1, -UNI_XIDC }   /* xidc=n */,
  {     0,  6338,  8864,  11,   5, -UNI_XPOSIXALPHA }   /* alphabetic=false */,
  {     2,  9097,     7,   4,   1, UNI_BPT__C }   /* bpt=c */,
  {     3,  4361,  1578,   4,  13, UNI_GEOMETRICSHAPES }   /* ingeometricshapes */,
  {     0,  5760,  9013,  13,   4, UNI_NV__15_SLASH_2 }   /* numericvalue=15/2 */,
  {     3,  6885,  2128,   3,  13, UNI_ROHG }   /* ishanifirohingya */,
  {     0,  1497,  4829,   9,   5, UNI_XPOSIXDIGIT }   /* category=digit */,
  {     7,  1713,  9734,  22,   3, UNI_CWCF }   /* changeswhencasefolded=yes */,
  {     2,  9620,  1014,   3,   6, UNI_L }   /* gc=letter */,
  {     0,  4732,     0,  15,   0, UNI_TITLE }   /* titlecaseletter */,
  {     2,  3671,  9457,  17,   4, UNI_WCHO }   /* scriptextensions=wcho */,
  {     0,  9365,  7852,   4,   8, UNI_GURU }   /* scx=gurmukhi */,
  {     9,  4849,    26,  14,   1, UNI_CI }   /* caseignorable=y */,
  {     6,  9049,  9578,   4,   3, UNI_AGE__6_DOT_3 }   /* age=6.3 */,
  {    15,  9365,  6724,   5,   3, UNI_SYLO }   /* scx=sylo */,
  {     1,  9620,   878,   3,  10, UNI_CO }   /* gc=privateuse */,
  {     2,  9769,     0,   2,   0, UNI_CASEDLETTER }   /* l_ */,
  {     0,  2067,     0,   7,   0, UNI_RADICAL }   /* radical */,
  {     5,  1497,    48,   9,   1, UNI_P }   /* category=p */,
  {     0,    21,  5045,   2,  14, UNI_LATINEXTE }   /* inlatinextendede */,
  {     2,  2836,     0,   4,   0, UNI_SUND }   /* sund */,
  {     1,  8424,   878,   6,  14, UNI_PUA }   /* block=privateusearea */,
  {     0,  2106,  5952,  21,   3, UNI_LB__ZWJ }   /* graphemeclusterbreak=zwj */,
  {     4,  5085,  6173,   4,  10, UNI_MATHALPHANUM }   /* inmathalphanum */,
  {    64,  9093,  8919,   4,   5, UNI_INOGHAM }   /* blk=ogham */,
  {     2,  2148,  4205,   3,   8, UNI_SYRIACSUP }   /* insyriacsup */,
  {     0,  9620,   133,   3,   4, UNI_M }   /* gc=mark */,
  {     4,  9953,  3248,   6,   5, UNI_VERTSPACE }   /* isvertspace */,
  {     1,  9647,  8358,   3,   4, UNI_NV__3000 }   /* nv=3000 */,
  {     2,  8520,    26,   6,   1, UNI_JOINC }   /* joinc=y */,
  {     1,  9093,  6767,   4,  11, UNI_YISYLLABLES }   /* blk=yisyllables */,
  {     0,  9093,   921,   4,  28, UNI_VSSUP }   /* blk=variationselectorssupplement */,
  {     3,  9093,   599,   4,  30, UNI_CJKEXTD }   /* blk=cjkunifiedideographsextensiond */,
  {     2,  9365,  8859,   4,   4, UNI_DOGR }   /* scx=dogr */,
  {     0,  6918,  7212,  10,   9, UNI_LB__B2 }   /* linebreak=breakboth */,
  {     6,  9093,  5799,   4,  12, UNI_ALPHABETICPF }   /* blk=alphabeticpf */,
  {     0,   893,     0,  28,   0, UNI_SUPPUAB }   /* supplementaryprivateuseareab */,
  {    20,  3671,  7892,  17,   8, UNI_JAVA }   /* scriptextensions=javanese */,
  {     1,   117,  4493,   3,  14, UNI_INIMPERIALARAMAIC }   /* inimperialaramaic */,
  {     8,  9605,  2709,   3,   3, UNI_DT__NAR }   /* dt=nar */,
  {    14,  9093,  8622,   4,   6, UNI_INTELUGU }   /* blk=telugu */,
  {     0,  9093,  2608,   4,  19, UNI_INEGYPTIANHIEROGLYPHS }   /* blk=egyptianhieroglyphs */,
  {     0,  9049,  9695,   4,   3, UNI_AGE__5 }   /* age=v50 */,
  {    19,  1911,  4236,  22,   5, UNI_INSC__VOWEL }   /* indicsyllabiccategory=vowel */,
  {     0,  9365,  8255,   5,   6, UNI_SIDD }   /* scx=siddham */,
  {     3,  9093,    78,   4,   6, UNI_INARABIC }   /* blk=arabic */,
  {     0,  3671,  7788,  17,   4, UNI_BALI }   /* scriptextensions=bali */,
  {     2,  5269,     0,  13,   0, UNI_PATSYN }   /* patternsyntax */,
  {     4,  9113,  8765,   5,   4, UNI_CCC__24 }   /* ccc=ccc24 */,
  {     1,  8886,  3038,   3,   4, UNI_ETHI }   /* sc=ethi */,
  {     4,  3671,  4267,  17,   4, UNI_BAMU }   /* scriptextensions=bamu */,
  {     0,  8886,  8310,   3,   4, UNI_SC__TIRH }   /* sc=tirh */,
  {     1,  1362,  8445,  24,   3, UNI_CCC__107 }   /* canonicalcombiningclass=107 */,
  {     2,  6679,  9734,  11,   3, UNI_SD }   /* softdotted=yes */,
  {     4,  9093,  8240,   4,   7, UNI_INSHARADA }   /* blk=sharada */,
  {     0,  2204,  6636,   3,  10, UNI_SO }   /* isothersymbol */,
  {     1,  1691,   722,  23,   4, UNI_BPT__C }   /* bidipairedbrackettype=close */,
  {     2,  8233,  9465,   7,   4, UNI_XPEO }   /* script=xpeo */,
  {     3,  1362,  9542,  24,   3, UNI_CCC__DA }   /* canonicalcombiningclass=234 */,
  {     3,  1410,     0,  13,   0, UNI_M }   /* combiningmark */,
  {     4,  7025,  7159,   3,   1, UNI_IN__5 }   /* in=5 */,
  {    12,  9093,  7964,   4,   8, UNI_INTIFINAGH }   /* blk=tifinagh */,
  {     6,  9647,  8464,   3,   2, UNI_NV__29 }   /* nv=29 */,
  {     5,  9647,  8376,   3,   5, UNI_NV__50000 }   /* nv=50000 */,
  {    15,  9365,  3020,   4,   4, UNI_DEVA }   /* scx=deva */,
  {     2,  1057,     1,  27,   1, -UNI_PCM }   /* prependedconcatenationmark=n */,
  {     0,  7420,  9433,   8,   4, UNI_IDS }   /* idstart=true */,
  {     0,  8332,    80,   4,  33, UNI_ARABICMATH }   /* isarabicmathematicalalphabeticsymbols */,
  {     7,  9909,  3248,   7,   5, UNI_POSIXSPACE }   /* isposixspace */,
  {    10,  9137,    36,   4,   1, UNI_DEP }   /* dep=t */,
  {     1,  1933,    36,  22,   1, UNI_LOE }   /* logicalorderexception=t */,
  {     1,  5565,  2147,  13,   3, UNI_JG__AIN }   /* joininggroup=ain */,
  {     0,  5760,  8358,  13,   5, UNI_NV__30000 }   /* numericvalue=30000 */,
  {     0,  8233,  8628,   7,   6, UNI_SC__THAA }   /* script=thaana */,
  {     1,  5760,  7516,  13,   8, UNI_NV__5_SLASH_2 }   /* numericvalue=2.50e+00 */,
  {     0,  8424,  8914,   6,   5, UNI_INNUSHU }   /* block=nushu */,
  {     1,  4580,  2761,   3,  18, UNI_MODIFIERTONELETTERS }   /* inmodifiertoneletters */,
  {     1,  3951,   447,   3,  17, UNI_IDEOGRAPHICSYMBOLS }   /* isideographicsymbols */,
  {     3,  9365,  8093,   4,   7, UNI_HANO }   /* scx=hanunoo */,
  {     3,  9365,  8914,   4,   5, UNI_NSHU }   /* scx=nushu */,
  {     1,  5835,  9433,  12,   4, UNI_BIDIC }   /* bidicontrol=true */,
  {     1,  9647,  7659,   3,   2, UNI_NV__16 }   /* nv=16 */,
  {    20,  3236,     1,  18,   1, -UNI__PERL_PATWS }   /* patternwhitespace=n */,
  {     0,  9731,     0,   3,   0, UNI_wb_values_index }   /* wb= */,
  {     1,  8424,  2333,   6,  20, UNI_GLAGOLITICSUP }   /* block=glagoliticsupplement */,
  {     1,  5565,  6075,  13,  12, UNI_JG__MALAYALAMLLA }   /* joininggroup=malayalamlla */,
  {     1,  9049,  7612,   4,   3, UNI_AGE__4_DOT_1 }   /* age=4.1 */,
  {     8,  8879,   838,   3,  27, UNI_PHONETICEXTSUP }   /* inphoneticextensionssupplement */,
  {     1,  8160,   721,   4,  14, UNI_ENCLOSEDALPHANUM }   /* inenclosedalphanum */,
  {     1,  9093,  5883,   4,  12, UNI_CYRILLICEXTB }   /* blk=cyrillicextb */,
  {     0,  1362,  8785,  25,   4, UNI_CCC__28 }   /* canonicalcombiningclass=ccc28 */,
  {     0,  1536,  3553,   3,  16, UNI_ETHIOPICEXTA }   /* inethiopicextendeda */,
  {     0,  3248,  9734,   6,   3, UNI_XPOSIXSPACE }   /* space=yes */,
  {     6,  5760,  8364,  13,   5, UNI_NV__40000 }   /* numericvalue=40000 */,
  {     5,  3868,  9108,  16,   2, UNI_MC }   /* generalcategory=mc */,
  {     0,   184,  4267,   2,   4, UNI_BAMU }   /* isbamu */,
  {     4,  3002,  8184,  18,   7, UNI_DT__NB }   /* decompositiontype=nobreak */,
  {     0,    21,  8680,   3,   4, UNI_INADLAM }   /* inadlam */,
  {     4,  9365,   983,   4,   5, UNI_GREK }   /* scx=greek */,
  {     0,  3586,     0,  17,   0, UNI_INDICSIYAQNUMBERS }   /* indicsiyaqnumbers */,
  {     0,  1911,  8646,  22,   6, UNI_INSC__VIRAMA }   /* indicsyllabiccategory=virama */,
  {     0,  5565,  3654,  13,  17, UNI_JG__MANICHAEANTHAMEDH }   /* joininggroup=manichaeanthamedh */,
  {     1,  9093,   113,   4,  35, UNI_DIACRITICALSFORSYMBOLS }   /* blk=combiningdiacriticalmarksforsymbols */,
  {     4,  9049,  9716,   4,   3, UNI_AGE__7 }   /* age=v70 */,
  {     9,  8886,  7892,   3,   8, UNI_SC__JAVA }   /* sc=javanese */,
  {     4,  5565,  5073,  13,  14, UNI_JG__MANICHAEANAYIN }   /* joininggroup=manichaeanayin */,
  {     0,  8424,  6939,   6,   2, UNI_INVS }   /* block=vs */,
  {     3,  3868,  5255,  16,  14, UNI_MN }   /* generalcategory=nonspacingmark */,
  {     1,   184,  3980,   2,   7, UNI_LINB }   /* islinearb */,
  {     3,  8424,  3772,   6,  16, UNI_BOPOMOFOEXT }   /* block=bopomofoextended */,
  {     0,   184,  6580,   2,  11, UNI_MYANMAREXTA }   /* ismyanmarexta */,
  {     4,  9605,  8184,   3,   7, UNI_DT__NB }   /* dt=nobreak */,
  {     0,  8886,  9345,   3,   4, UNI_RJNG }   /* sc=rjng */,
  {     9,  8871,  9773,   3,   2, UNI_SB__XX }   /* sb=xx */,
  {     0,  9623,  3916,   3,  16, UNI_JG__HANIFIROHINGYAPA }   /* jg=hanifirohingyapa */,
  {     0,    21,  7892,   2,   8, UNI_INJAVANESE }   /* injavanese */,
  {     9,  8886,  2393,   3,  20, UNI_HMNP }   /* sc=nyiakengpuachuehmong */,
  {     2,  1362,  7603,  24,   2, UNI_CCC__24 }   /* canonicalcombiningclass=24 */,
  {     1,  4849,  8864,  14,   5, -UNI_CI }   /* caseignorable=false */,
  {     0,  9129,  9734,   4,   3, UNI_CWU }   /* cwu=yes */,
  {     8,  7956,     0,   4,   0, UNI_TAGB }   /* tagb */,
  {     1,  1239,    36,  25,   1, UNI_COMPEX }   /* fullcompositionexclusion=t */,
  {     4,  8233,  9425,   7,   4, UNI_THAI }   /* script=thai */,
  {     6,  9365,  9281,   4,   4, UNI_NEWA }   /* scx=newa */,
  {     3,  2212,  1165,   5,  23, UNI_HALFANDFULLFORMS }   /* inhalfwidthandfullwidthforms */,
  {     0,  9647,  7446,   3,   1, UNI_NV__2 }   /* nv=2 */,
  {     1,  9053,     0,   4,   0, UNI_AGHB }   /* aghb */,
  {     6,  9093,  1003,   4,  27, UNI_ENCLOSEDCJK }   /* blk=enclosedcjklettersandmonths */,
  {     1,  1243,    36,  21,   1, UNI_CE }   /* compositionexclusion=t */,
  {     1,  9629,  1110,   3,  26, UNI_LB__CJ }   /* lb=conditionaljapanesestarter */,
  {     0,  1924,    47,  10,   1, UNI_LM }   /* category=lm */,
  {     2,  8616,     0,   6,   0, UNI_sterm_values_index }   /* sterm= */,
  {     1,  7860,     0,   4,   0, UNI_HIRA }   /* hira */,
  {    28,  9647,  7668,   3,   8, UNI_NV__5_SLASH_8 }   /* nv=6.25e-01 */,
  {     1,  8929,     0,   5,   0, UNI_OSGE }   /* osage */,
  {     3,  8412,     1,   6,   1, -UNI_BIDIC }   /* bidic=n */,
  {     1,  9093,  1539,   4,  14, UNI_MUSIC }   /* blk=musicalsymbols */,
  {     2,  9413,     0,   4,   0, UNI_TAVT }   /* tavt */,
  {     0,  1362,  8730,  25,   4, UNI_CCC__17 }   /* canonicalcombiningclass=ccc17 */,
  {     3,  9647,  7723,   3,   2, UNI_NV__18 }   /* nv=18 */,
  {     1,  8233,  8058,   7,   7, UNI_DSRT }   /* script=deseret */,
  {     0,  9365,  9081,   4,   4, UNI_AVST }   /* scx=avst */,
  {     3,  8580,    26,   6,   1, UNI__PERL_NCHAR }   /* nchar=y */,
  {     0,  1482,  2479,  24,   6, UNI_INPC__BOTTOM }   /* indicpositionalcategory=bottom */,
  {     0,  1450,   986,   5,   2, UNI_INGREEK }   /* ingreek */,
  {     1,  4705,  8940,   3,   4, UNI_TALE }   /* istaile */,
  {     3,   184,  2393,   2,  20, UNI_HMNP }   /* isnyiakengpuachuehmong */,
  {     9,  1497,  6360,   9,  11, UNI_CASEDLETTER }   /* category=casedletter */,
  {     0,  9121,    36,   4,   1, UNI_CWL }   /* cwl=t */,
  {     5,  9093,  3110,   4,   8, UNI_INGEORGIAN }   /* blk=georgian */,
  {     9,  1482,  5461,  24,  13, UNI_INPC__BOTTOMANDLEFT }   /* indicpositionalcategory=bottomandleft */,
  {     1,  4447,  1162,  15,   9, UNI_EA__H }   /* eastasianwidth=halfwidth */,
  {     0,  3671,  7860,  17,   8, UNI_HIRA }   /* scriptextensions=hiragana */,
  {     5,  3671,  7008,  17,  10, UNI_PHNX }   /* scriptextensions=phoenician */,
  {     0,  9620,  9769,   3,   2, UNI_CASEDLETTER }   /* gc=l_ */,
  {     5,  9153,  5952,   4,   3, UNI_LB__ZWJ }   /* gcb=zwj */,
  {     0,  8233,  8142,   7,   7, UNI_MARC }   /* script=marchen */,
  {     4,  9365,     7,   4,  18, UNI_CANS }   /* scx=canadianaboriginal */,
  {     7,  3671,  2006,  17,   4, UNI_MODI }   /* scriptextensions=modi */,
  {     0,  3932,     0,  16,   0, UNI_HIGHPUSURROGATES }   /* highpusurrogates */,
  {     0,  8233,  9181,   7,   4, UNI_HLUW }   /* script=hluw */,
  {    25,  9093,  6569,   4,  11, UNI_MISCSYMBOLS }   /* blk=miscsymbols */,
  {     8,  5760,  7540,  13,   2, UNI_NV__20 }   /* numericvalue=20 */,
  {     2,  9093,  8502,   4,   6, UNI_INGOTHIC }   /* blk=gothic */,
  {     0,   184,  8859,   2,   5, UNI_DOGR }   /* isdogra */,
  {     0,  8233,  2608,   7,  19, UNI_EGYP }   /* script=egyptianhieroglyphs */,
  {     1,  6918,  8345,  10,   7, UNI_LB__ZW }   /* linebreak=zwspace */,
  {     0,  6279,     0,  12,   0, UNI_PLAYINGCARDS }   /* playingcards */,
  {     2,  5760,  5409,  13,   2, UNI_NV__10 }   /* numericvalue=10 */,
  {     0,  9113,  9077,   4,   3, UNI_CCC__202 }   /* ccc=atb */,
  {     0,    21,  4989,   2,   6, UNI_KANGXI }   /* inkangxi */,
  {     8,  9113,  3441,   4,   9, UNI_CCC__BL }   /* ccc=belowleft */,
  {     3,  6816,  2533,   3,   5, UNI_INBRAHMI }   /* inbrahmi */,
  {     0,  3671,  7118,  17,   4, UNI_WARA }   /* scriptextensions=wara */,
  {     8,  9629,    18,   3,   2, UNI_RI }   /* lb=ri */,
  {    16,  8233,  9485,   7,   4, UNI_SC__QAAI }   /* script=zinh */,
  {     9,  1773,  9734,   6,   3, UNI_CASED }   /* cased=yes */,
  {     2,  9093,  8247,   4,   7, UNI_SHAW }   /* blk=shavian */,
  {     2,  6679,     0,  11,   0, UNI_sd_values_index }   /* softdotted= */,
  {    22,   184,  8338,   2,   6, UNI_XPOSIXSPACE }   /* iswspace */,
  {     4,  8604,   995,   6,   2, -UNI_QMARK }   /* qmark=no */,
  {     9,  4705,  8283,   3,   6, UNI_TGLG }   /* istagalog */,
  {     0,  4580,  2262,  10,  11, UNI_MERO }   /* inmeroitichieroglyphs */,
  {     0,  9365,  3772,   4,   8, UNI_BOPO }   /* scx=bopomofo */,
  {     5,  9620,  1410,   3,  13, UNI_M }   /* gc=combiningmark */,
  {     0,   184,  6051,   2,   7, UNI_MAHJONG }   /* ismahjong */,
  {     0,  5760,  5409,  13,  13, UNI_NV__1000000000000 }   /* numericvalue=1000000000000 */,
  {     0,  9365,  9453,   4,   4, UNI_VAI }   /* scx=vaii */,
  {     1,  9365,  2930,   4,   4, UNI_CHER }   /* scx=cher */,
  {     4,  1482,  3344,  24,  10, UNI_INPC__TOPANDLEFT }   /* indicpositionalcategory=topandleft */,
  {     0,    42,     0,  26,   0, UNI_CJKCOMPATIDEOGRAPHS }   /* cjkcompatibilityideographs */,
  {     4,   184,  1768,   2,   5, UNI_XPOSIXLOWER }   /* islower */,
  {     8,  9731,  3254,   3,  17, UNI_RI }   /* wb=regionalindicator */,
  {    18,   184,  6558,   2,  11, UNI_MEDF }   /* ismedefaidrin */,
  {     0,  1823,     0,  19,   0, UNI_CJKCOMPATIDEOGRAPHS }   /* cjkcompatideographs */,
  {     0,  3671,  7332,  17,   4, UNI_ITAL }   /* scriptextensions=ital */,
  {     6,    24,     0,   1,   0, UNI_L }   /* l */,
  {     0,  9365,  2532,   4,   6, UNI_BRAH }   /* scx=brahmi */,
  {     0,  6816,  4298,   3,  14, UNI_BRAI }   /* inbraillepatterns */,
  {     0,  3671,    57,  17,   2, UNI_YI }   /* scriptextensions=yi */,
  {     0,  7128,  4140,  10,   5, UNI_WB__XX }   /* wordbreak=other */,
  {     1,  9093,   509,   4,  30, UNI_CJKEXTA }   /* blk=cjkunifiedideographsextensiona */,
  {     0,   184,  9345,   2,   4, UNI_RJNG }   /* isrjng */,
  {     4,   184,  2169,   2,  14, UNI_MEETEIMAYEKEXT }   /* ismeeteimayekext */,
  {     0,  6567,  4096,   6,  12, UNI_MISCMATHSYMBOLSB }   /* inmiscmathsymbolsb */,
  {     4,  5565,   341,  13,   2, UNI_JG__PE }   /* joininggroup=pe */,
  {     0,  1691,     0,  23,   0, UNI_BPT__C }   /* bidipairedbrackettype=c */,
  {     0,  2855,     0,  19,   0, UNI_SUPARROWSA }   /* supplementalarrowsa */,
  {     1,    21,  6027,   2,  12, UNI_KHMERSYMBOLS }   /* inkhmersymbols */,
  {    15,  5339,   721,  14,   5, UNI_SB__CL }   /* sentencebreak=close */,
  {     1,  8424,  4933,   6,  14, UNI_INGREEK }   /* block=greekandcoptic */,
  {     2,  8886,  9429,   3,   4, UNI_TIBT }   /* sc=tibt */,
  {     6,  9113,  8790,   5,   4, UNI_CCC__29 }   /* ccc=ccc29 */,
  {     0,  9647,  5409,   3,   6, UNI_NV__100000 }   /* nv=100000 */,
  {     8,  3671,  7964,  17,   8, UNI_TFNG }   /* scriptextensions=tifinagh */,
  {     3,  7025,  9548,   3,   3, UNI_IN__3 }   /* in=3.0 */,
  {     9,  8233,  7347,   7,   9, UNI_ORKH }   /* script=oldturkic */,
  {     2,  5760,  7740,  13,   8, UNI_NV__1_SLASH_12 }   /* numericvalue=8.33e-02 */,
  {     0,  3951,   447,   3,  31, UNI_IDEOGRAPHICSYMBOLS }   /* isideographicsymbolsandpunctuation */,
  {     3,  3671,  7049,  18,   9, UNI_SAUR }   /* scriptextensions=saurashtra */,
  {     0,  9093,  7185,   4,   9, UNI_ARABICPFA }   /* blk=arabicpfa */,
  {     1,  8424,  6492,   6,  11, UNI_KATAKANAEXT }   /* block=katakanaext */,
  {     0,  2148,  2837,   3,   8, UNI_INSUNDANESE }   /* insundanese */,
  {     0,  8424,  7796,   6,   8, UNI_INBASSAVAH }   /* block=bassavah */,
  {     0,  9620,    38,   3,   2, UNI_XPOSIXDIGIT }   /* gc=nd */,
  {     0,    21,  7257,   2,   9, UNI_LATINEXTB }   /* inlatinextb */,
  {     2,  9620,  8499,   3,   2, UNI_CF }   /* gc=cf */,
  {     1,  6679,     0,  10,   0, UNI_SD }   /* softdotted */,
  {     0,  8886,  9173,   3,   4, UNI_SC__GURU }   /* sc=guru */,
  {     2,  6005,   690,   3,  15, UNI_CUNEIFORMNUMBERS }   /* incuneiformnumbers */,
  {     0,  6918,   184,  10,   2, UNI_LB__IS }   /* linebreak=is */,
  {     2,  8424,  7940,   6,   8, UNI_SPECIALS }   /* block=specials */,
  {     0,  3688,     0,  17,   0, UNI_sterm_values_index }   /* sentenceterminal= */,
  {     8,  9647,  7683,   3,   2, UNI_NV__26 }   /* nv=26 */,
  {     0,  9647,  5409,   3,   3, UNI_NV__100 }   /* nv=100 */,
  {     3,  9620,   406,   3,   7, UNI_XPOSIXCNTRL }   /* gc=control */,
  {     1,  8093,     0,   7,   0, UNI_HANO }   /* hanunoo */,
  {     0,   184,  7796,   2,   4, UNI_BASS }   /* isbass */,
  {     2,   184,  1576,   2,  15, UNI_GEOMETRICSHAPES }   /* isgeometricshapes */,
  {     1,  9620,     7,   3,   1, UNI_C }   /* gc=c */,
  {     0,  8871,   400,   3,   6, UNI_SB__FO }   /* sb=format */,
  {     0,  8616,     1,   6,   1, -UNI_STERM }   /* sterm=n */,
  {     0,  9365,  8255,   5,   3, UNI_SIDD }   /* scx=sidd */,
  {     0,  9093,  8065,   4,   7, UNI_INELBASAN }   /* blk=elbasan */,
  {     0,  6816,  3773,   3,  15, UNI_BOPOMOFOEXT }   /* inbopomofoextended */,
  {     0,  3739,     3,  17,   1, -UNI_UIDEO }   /* unifiedideograph=f */,
  {     3,  7100,     0,   8,   0, UNI_ASSIGNED }   /* assigned */,
  {     9,  3671,  8430,  17,   6, UNI_CARI }   /* scriptextensions=carian */,
  {     7,  9093,  7772,   4,   8, UNI_INARMENIAN }   /* blk=armenian */,
  {    20,  9626,     6,   3,   1, UNI_JT__D }   /* jt=d */,
  {     1,  9623,  5125,   3,   4, UNI_JG__HETH }   /* jg=heth */,
  {     5,  1362,  8825,  25,   4, UNI_CCC__36 }   /* canonicalcombiningclass=ccc36 */,
  {     1,  8424,  3964,   6,   6, UNI_LATIN1 }   /* block=latin1 */,
  {     4,  7980,     0,   4,   0, UNI_UGAR }   /* ugar */,
  {     8,  5565,  5157,  13,  14, UNI_JG__MANICHAEANRESH }   /* joininggroup=manichaeanresh */,
  {     0,  1735,     0,  22,   0, UNI_cwcm_values_index }   /* changeswhencasemapped= */,
  {     4,  8233,  2779,   7,   9, UNI_SC__MONG }   /* script=mongolian */,
  {     1,  9093,  5871,   4,  12, UNI_CYRILLICEXTA }   /* blk=cyrillicexta */,
  {     0,  9593,  4905,   3,  14, UNI_BC__EN }   /* bc=europeannumber */,
  {     1,  8233,  7892,   7,   8, UNI_SC__JAVA }   /* script=javanese */,
  {     6,   184,  1768,   2,   9, UNI_XPOSIXLOWER }   /* islowercase */,
  {     6,  5760,  9737,  13,   2, UNI_NV__38 }   /* numericvalue=38 */,
  {     0,  9647,  8388,   3,   6, UNI_NV__700000 }   /* nv=700000 */,
  {     0,  9602,    36,   3,   1, UNI_DI }   /* di=t */,
  {     0,  9647,  7524,   3,   8, UNI_NV__1_SLASH_4 }   /* nv=2.50e-01 */,
  {    16,  9605,    68,   3,   3, UNI_DT__SUP }   /* dt=sup */,
  {     0,  8424,  2044,   7,  20, UNI_CJKCOMPATFORMS }   /* block=cjkcompatibilityforms */,
  {     0,  9647,  8388,   3,   5, UNI_NV__70000 }   /* nv=70000 */,
  {    13,  9593,     1,   4,   1, UNI_BC__BN }   /* bc=bn */,
  {     9,  9903,  9921,   6,   5, UNI_XPOSIXPRINT }   /* xposixprint */,
  {     5,  1362,  7495,  24,   1, UNI_CCC__7 }   /* canonicalcombiningclass=7 */,
  {     0,  8424,  2532,   6,   6, UNI_INBRAHMI }   /* block=brahmi */,
  {     9,  8886,  9085,   3,   4, UNI_BATK }   /* sc=batk */,
  {     0,  9620,  1029,   3,   2, UNI_SO }   /* gc=so */,
  {     0,  9093,  9397,   4,   4, UNI_TAGS }   /* blk=tags */,
  {     5,  9365,  3620,   4,  10, UNI_MANI }   /* scx=manichaean */,
  {     0,  1158,  8623,   3,   5, UNI_INTELUGU }   /* intelugu */,
  {     0,  9365,  8205,   4,   4, UNI_OSMA }   /* scx=osma */,
  {     2,  9365,  9133,   4,   4, UNI_CYRL }   /* scx=cyrl */,
  {    75,  9093,  6988,   4,  10, UNI_INOLDSOGDIAN }   /* blk=oldsogdian */,
  {     6,  9093,  8949,   4,   5, UNI_VSSUP }   /* blk=vssup */,
  {     0,  9093,  8610,   4,   6, UNI_INREJANG }   /* blk=rejang */,
  {     0,  9093,  4672,   4,  15, UNI_SARB }   /* blk=oldsoutharabian */,
  {     8,  8886,  8514,   3,   6, UNI_HATR }   /* sc=hatran */,
  {     1,  3671,  7844,  17,   8, UNI_GUJR }   /* scriptextensions=gujarati */,
  {     1,   184,  8610,   2,   6, UNI_RJNG }   /* isrejang */,
  {     0,  6885,  8094,   3,   6, UNI_HANO }   /* ishanunoo */,
  {     1,  9605,  3308,   3,   5, UNI_DT__SML }   /* dt=small */,
  {     3,  8886,  5955,   3,  12, UNI_SC__GONG }   /* sc=gunjalagondi */,
  {     6,  1508,     0,   2,   0, UNI_PS }   /* ps */,
  {     1,  9629,  3254,   3,  17, UNI_RI }   /* lb=regionalindicator */,
  {     0,  1362,  8464,  24,   2, UNI_CCC__29 }   /* canonicalcombiningclass=29 */,
  {     0,  7018,  9441,  10,   4, UNI_IN__11 }   /* presentin=v110 */,
  {     4,  1243,    26,  21,   1, UNI_CE }   /* compositionexclusion=y */,
  {     0,  9647,  5409,   3,  11, UNI_NV__10000000000 }   /* nv=10000000000 */,
  {     1,  3671,  8142,  17,   4, UNI_MARC }   /* scriptextensions=marc */,
  {     0,  7420,   995,   8,   2, -UNI_IDS }   /* idstart=no */,
  {    10,  9629,    73,   3,   2, UNI_LB__EM }   /* lb=em */,
  {     8,  3254,    36,  18,   1, UNI_RI }   /* regionalindicator=t */,
  {     1,  8424,  3756,   6,   9, UNI_ARABICSUP }   /* block=arabicsup */,
  {    21,  8058,     0,   7,   0, UNI_DSRT }   /* deseret */,
  {     2,  8592,     0,   6,   0, UNI_nfdqc_values_index }   /* nfdqc= */,
  {     0,  2703,  8864,  19,   5, -UNI_IDST }   /* idstrinaryoperator=false */,
  {     6,    11,     0,   2,   0, UNI_DI }   /* di */,
  {    13,  3772,     0,   4,   0, UNI_BOPO }   /* bopo */,
  {     8,  9647,  8388,   3,   2, UNI_NV__70 }   /* nv=70 */,
  {     3,  8849,     0,   4,   0, UNI_CWCM }   /* cwcm */,
  {     1,  5760,  5409,  13,  11, UNI_NV__10000000000 }   /* numericvalue=10000000000 */,
  {  1025,  6231,  5487,  12,   7, UNI_XPOSIXDIGIT }   /* numerictype=decimal */,
  {     3,  9093,  7884,   4,   8, UNI_JAMOEXTB }   /* blk=jamoextb */,
  {     5,  8424,  2401,   6,   3, UNI_PUA }   /* block=pua */,
  {     2,  4826,     3,   9,   1, -UNI_XPOSIXXDIGIT }   /* hexdigit=f */,
  {     0,  8886,  8254,   3,   4, UNI_SIDD }   /* sc=sidd */,
  {     0,  9093,  4492,   4,  15, UNI_INIMPERIALARAMAIC }   /* blk=imperialaramaic */,
  {     8,  9909,  9326,   3,   3, UNI_MIAO }   /* isplrd */,
  {     0,  9121,    26,   4,   1, UNI_CWL }   /* cwl=y */,
  {     1,  9093,  8289,   4,   7, UNI_INTAITHAM }   /* blk=taitham */,
  {     3,  8424,  3469,   6,   4, UNI_UCAS }   /* block=ucas */,
  {     0,  7018,  9707,  10,   3, UNI_IN__6_DOT_1 }   /* presentin=v61 */,
  {     2,  6888,     0,  10,   0, UNI_dia_values_index }   /* diacritic= */,
  {     1,  5565,    65,  15,   2, UNI_JG__KAPH }   /* joininggroup=kaph */,
  {     2,  3671,  8934,  17,   5, UNI_RUNR }   /* scriptextensions=runic */,
  {     5,  3868,  1855,  16,   2, UNI_CN }   /* generalcategory=cn */,
  {     0,  9093,  1645,   4,  23, UNI_SHORTHANDFORMATCONTROLS }   /* blk=shorthandformatcontrols */,
  {     1,  8233,  6724,   8,  10, UNI_SC__SYLO }   /* script=sylotinagri */,
  {    18,   184,  9225,   2,   4, UNI_LINA }   /* islina */,
  {     0,  4989,     0,  14,   0, UNI_KANGXI }   /* kangxiradicals */,
  {     4,  7128,     0,   4,   0, UNI_XPOSIXWORD }   /* word */,
  {     3,  9153,     0,   4,   0, UNI_gcb_values_index }   /* gcb= */,
  {     2,  9365,  5617,   4,   9, UNI_MLYM }   /* scx=malayalam */,
  {     2,  9647,     0,   3,   0, UNI_nv_values_index }   /* nv= */,
  {     3,  9623,  5185,   3,  14, UNI_JG__MANICHAEANYODH }   /* jg=manichaeanyodh */,
  {     1,  4821,     0,  14,   0, UNI_ahex_values_index }   /* asciihexdigit= */,
  {     2,  8233,  9185,   7,   4, UNI_HMNG }   /* script=hmng */,
  {     6,  1497,   698,   9,   6, UNI_N }   /* category=number */,
  {     0,  2212,  2960,   5,   6, UNI_HALFMARKS }   /* inhalfmarks */,
  {     1,  6918,   836,  10,   2, UNI_LB__SP }   /* linebreak=sp */,
  {     1,  6602,     0,   4,   0, UNI_NAND }   /* nand */,
  {     8,  1497,   467,   9,  11, UNI_P }   /* category=punctuation */,
  {     4,  6768,  2233,   3,   5, UNI_YIJING }   /* isyijing */,
  {     1,  9365,  1845,   4,   6, UNI_ZYYY }   /* scx=common */,
  {     0,   184,  6859,   3,   9, UNI_CJKSTROKES }   /* iscjkstrokes */,
  {     4,  1497,  1508,   9,   2, UNI_PS }   /* category=ps */,
  {    88,  9365,  2253,   4,  20, UNI_HLUW }   /* scx=anatolianhieroglyphs */,
  {     1,  8424,   349,   6,  33, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* block=supplementalsymbolsandpictographs */,
  {     1,    21,  7876,   2,   8, UNI_JAMOEXTA }   /* injamoexta */,
  {    12,  8233,  2333,   7,  10, UNI_SC__GLAG }   /* script=glagolitic */,
  {    10,   988,     0,   5,   0, UNI_MUSIC }   /* music */,
  {     1,  8163,    47,   7,   1, UNI_NFCQC__M }   /* nfkcqc=m */,
  {     0,  4826,  9734,   9,   3, UNI_XPOSIXXDIGIT }   /* hexdigit=yes */,
  {     0,   184,  1539,   2,  14, UNI_MUSIC }   /* ismusicalsymbols */,
  {     5,  8886,  8562,   3,   4, UNI_LYCI }   /* sc=lyci */,
  {     8,  3671,  8484,  17,   6, UNI_CAKM }   /* scriptextensions=chakma */,
  {     1,  3002,    68,  18,   3, UNI_DT__SUP }   /* decompositiontype=sup */,
  {     2,  6885,  6095,   3,   3, UNI_HMNG }   /* ishmng */,
  {     3,  9193,  6303,   4,  12, UNI_GCB__T }   /* hst=trailingjamo */,
  {     1,  2148,  8262,   3,   6, UNI_INSOYOMBO }   /* insoyombo */,
  {    16,  5435,  9433,  13,   4, UNI_BIDIM }   /* bidimirrored=true */,
  {     0,   184,  7884,   2,   8, UNI_JAMOEXTB }   /* isjamoextb */,
  {    11,  6828,  9635,  10,   3, UNI_BC__LRI }   /* bidiclass=lri */,
  {     1,  4705,  3327,   3,  17, UNI_TAIXUANJING }   /* istaixuanjingsymbols */,
  {     8,  8424,  3020,   6,  18, UNI_DEVANAGARIEXT }   /* block=devanagariextended */,
  {     2,  3671,  8058,  17,   7, UNI_DSRT }   /* scriptextensions=deseret */,
  {     3,  8233,  3467,   7,  17, UNI_AGHB }   /* script=caucasianalbanian */,
  {    16,  4705,  5624,   3,   3, UNI_TAML }   /* istaml */,
  {    10,  9049,  7548,   4,   3, UNI_AGE__3_DOT_1 }   /* age=3.1 */,
  {     0,  8886,  9301,   3,   4, UNI_ORKH }   /* sc=orkh */,
  {    65,  6567,  4080,   6,  12, UNI_MISCMATHSYMBOLSA }   /* inmiscmathsymbolsa */,
  {     1,  3836,     0,   7,   0, UNI_CPRT }   /* cypriot */,
  {     0,  6828,  5823,  10,  12, UNI_BC__AN }   /* bidiclass=arabicnumber */,
  {     1,  8233,  1146,   8,   3, UNI_SORA }   /* script=sora */,
  {     3,   184,  3620,   2,  10, UNI_MANI }   /* ismanichaean */,
  {     0,  5760,  9033,  13,   4, UNI_NV__3_SLASH_80 }   /* numericvalue=3/80 */,
  {     0,  9045,     0,   4,   0, UNI_ADLM }   /* adlm */,
  {     0,  9904,  8839,   5,   5, UNI_POSIXCNTRL }   /* posixcntrl */,
  {     1,  1779,  8864,  22,   5, -UNI_CWT }   /* changeswhentitlecased=false */,
  {     0,  9365,  9053,   4,   4, UNI_AGHB }   /* scx=aghb */,
  {     1,  3671,  3038,  17,   4, UNI_ETHI }   /* scriptextensions=ethi */,
  {     9,  1239,  9433,  25,   4, UNI_COMPEX }   /* fullcompositionexclusion=true */,
  {    16,  3398,     0,  18,   0, UNI_vs_values_index }   /* variationselector= */,
  {     1,   184,  1846,   3,   5, UNI_ZYYY }   /* iscommon */,
  {     3,  8233,  8205,   7,   4, UNI_OSMA }   /* script=osma */,
  {    17,  9093,  6602,   4,  11, UNI_INNANDINAGARI }   /* blk=nandinagari */,
  {     0,  9781,  7420,   6,   7, UNI__PERL_IDSTART }   /* _perl_idstart */,
  {    21,  3671,  8205,  17,   7, UNI_OSMA }   /* scriptextensions=osmanya */,
  {     8,  8871,  1768,   3,   5, UNI_SB__LO }   /* sb=lower */,
  {     5,  2212,  8095,   4,   5, UNI_INHANUNOO }   /* inhanunoo */,
  {     0,  9193,  5747,   4,  13, UNI_HST__NA }   /* hst=notapplicable */,
  {     2,   184,    43,   3,   8, UNI_CJKCOMPAT }   /* iscjkcompat */,
  {     0,  9647,  7555,   3,   2, UNI_NV__23 }   /* nv=23 */,
  {     4,  9365,  2393,   4,  20, UNI_HMNP }   /* scx=nyiakengpuachuehmong */,
  {    18,  5760,  8400,  13,   4, UNI_NV__9000 }   /* numericvalue=9000 */,
  {     0,  9125,   995,   4,   2, -UNI_CWT }   /* cwt=no */,
  {     1,    21,  3164,   2,   9, UNI_LATINEXTA }   /* inlatinexta */,
  {     2,  9605,  6195,   3,  12, UNI_DT__NONCANON }   /* dt=noncanonical */,
  {     1,   184,  8114,   2,   7, UNI_KALI }   /* iskayahli */,
  {     6,  7892,     0,   4,   0, UNI_JAVA }   /* java */,
  {     0,  6888,    26,  10,   1, UNI_DIA }   /* diacritic=y */,
  {     2,  8886,  9145,   3,   4, UNI_DSRT }   /* sc=dsrt */,
  {     1,  8424,  2985,   7,  17, UNI_COPTICEPACTNUMBERS }   /* block=copticepactnumbers */,
  {    17,  1779,   995,  22,   2, -UNI_CWT }   /* changeswhentitlecased=no */,
  {     1,  9113,  8735,   5,   4, UNI_CCC__18 }   /* ccc=ccc18 */,
  {    17,  1362,  8810,  25,   4, UNI_CCC__33 }   /* canonicalcombiningclass=ccc33 */,
  {     8,   184,  1506,   2,  24, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* issupsymbolsandpictographs */,
  {     0,  9093,  1410,   4,  24, UNI_DIACRITICALSFORSYMBOLS }   /* blk=combiningmarksforsymbols */,
  {     8,  9093,  6159,   4,  12, UNI_INMASARAMGONDI }   /* blk=masaramgondi */,
  {     2,  3739,    26,  17,   1, UNI_UIDEO }   /* unifiedideograph=y */,
  {     0,   184,  2169,   2,  11, UNI_MTEI }   /* ismeeteimayek */,
  {     1,  2798,     0,  19,   0, UNI_OTTOMANSIYAQNUMBERS }   /* ottomansiyaqnumbers */,
  {     2,  5085,  6053,   4,   5, UNI_MAHJONG }   /* inmahjong */,
  {     2,  3671,   493,  17,   3, UNI_HAN }   /* scriptextensions=han */,
  {     9,   184,   719,   2,  30, UNI_ENCLOSEDALPHANUMSUP }   /* isenclosedalphanumericsupplement */,
  {    16,  8418,     3,   6,   1, -UNI_BIDIM }   /* bidim=f */,
  {     0,  1362,  8437,  25,   4, UNI_CCC__10 }   /* canonicalcombiningclass=ccc10 */,
  {     1,  9129,    36,   4,   1, UNI_CWU }   /* cwu=t */,
  {     0,   117,  2150,   4,  19, UNI_ININSCRIPTIONALPARTHIAN }   /* ininscriptionalparthian */,
  {     8,  8424,  6159,   6,  12, UNI_INMASARAMGONDI }   /* block=masaramgondi */,
  {     0,  3248,  8864,   6,   5, -UNI_XPOSIXSPACE }   /* space=false */,
  {     8,  8684,   995,   5,   2, -UNI_POSIXXDIGIT }   /* ahex=no */,
  {     8,  9647,  8664,   3,   4, UNI_NV__1_SLASH_16 }   /* nv=1/16 */,
  {     1,  9421,     0,   4,   0, UNI_TGLG }   /* tglg */,
  {     0,  5269,     1,  14,   1, -UNI_PATSYN }   /* patternsyntax=n */,
  {     3,  6005,   115,   4,  33, UNI_DIACRITICALSFORSYMBOLS }   /* incombiningdiacriticalmarksforsymbols */,
  {     0,  5895,     0,  12,   0, UNI_CYRILLICEXTC }   /* cyrillicextc */,
  {     4,  9659,     3,   3,   1, -UNI_RI }   /* ri=f */,
  {    11,  3688,  9433,  17,   4, UNI_STERM }   /* sentenceterminal=true */,
  {     0,  8424,  6382,   6,   6, UNI_DOMINO }   /* block=domino */,
  {     8,  3868,    74,  16,   2, UNI_ME }   /* generalcategory=me */,
  {     3,  6051,     0,   7,   0, UNI_MAHJONG }   /* mahjong */,
  {     0,    21,  8894,   2,   5, UNI_INLIMBU }   /* inlimbu */,
  {     1,  5435,  8864,  13,   5, -UNI_BIDIM }   /* bidimirrored=false */,
  {     1,   983,     0,   5,   0, UNI_GREK }   /* greek */,
  {     4,  9629,  3804,   3,  16, UNI_LB__CP }   /* lb=closeparenthesis */,
  {     1,  8332,    29,   4,   4, UNI_ARAB }   /* isarabic */,
  {    11,  8598,  9433,   6,   4, UNI__PERL_PATWS }   /* patws=true */,
  {     1,  1855,     0,   2,   0, UNI_CN }   /* cn */,
  {     2,  9113,  3441,   4,   5, UNI_CCC__B }   /* ccc=below */,
  {     0,  9940,    47,   5,   1, UNI_PERM }   /* isperm */,
  {     1,  8886,  9277,   3,   4, UNI_NBAT }   /* sc=nbat */,
  {     2,  8886,  8628,   3,   4, UNI_SC__THAA }   /* sc=thaa */,
  {     0,  9365,  9481,   4,   4, UNI_ZANB }   /* scx=zanb */,
  {     0,  2106,   881,  21,   1, UNI_GCB__V }   /* graphemeclusterbreak=v */,
  {     0,  2204,  8206,   3,   6, UNI_OSMA }   /* isosmanya */,
  {     1,  8640,     1,   6,   1, -UNI_XPOSIXUPPER }   /* upper=n */,
  {     4,  8424,  2169,   6,  21, UNI_MEETEIMAYEKEXT }   /* block=meeteimayekextensions */,
  {     8,  3671,  9353,  17,   4, UNI_RUNR }   /* scriptextensions=runr */,
  {     1,  8886,  1481,   3,   4, UNI_SC__SIND }   /* sc=sind */,
  {     0,  7025,  9006,   3,   3, UNI_IN__2_DOT_1 }   /* in=2.1 */,
  {     0,  9093,  8058,   4,   7, UNI_DSRT }   /* blk=deseret */,
  {     1,  1530,     0,  14,   0, UNI_BYZANTINEMUSIC }   /* byzantinemusic */,
  {     1,  3671,  9394,  18,   3, UNI_SYRC }   /* scriptextensions=syrc */,
  {     0,  8871,    34,   3,   2, UNI_SB__EX }   /* sb=ex */,
  {     0,  9093,  8532,   4,   6, UNI_KANBUN }   /* blk=kanbun */,
  {     8,  3671,  3020,  17,   4, UNI_DEVA }   /* scriptextensions=deva */,
  {     9,  8424,     0,  12,   0, UNI_INCARIAN }   /* block=carian */,
  {     1,  6315,  9433,  12,   4, UNI_XIDC }   /* xidcontinue=true */,
  {     0,  6885,  5346,   3,   3, UNI_HEBR }   /* ishebr */,
  {    10,   184,  6371,   2,  10, UNI_DEP }   /* isdeprecated */,
  {     0,  9725,     0,   3,   0, UNI_vo_values_index }   /* vo= */,
  {     8,  8424,  4076,   6,  16, UNI_MISCMATHSYMBOLSA }   /* block=miscmathsymbolsa */,
  {     0,  9647,  9584,   3,   3, UNI_NV__7_SLASH_8 }   /* nv=7/8 */,
  {     0,  8886,  9269,   3,   4, UNI_SC__MYMR }   /* sc=mymr */,
  {     3,  9093,  9253,   4,   4, UNI_INMIAO }   /* blk=miao */,
  {     6,    21,  4808,   3,  13, UNI_ANCIENTSYMBOLS }   /* inancientsymbols */,
  {     1,  9620,  3146,   3,  18, UNI_PI }   /* gc=initialpunctuation */,
  {     1,  1362,  7167,  24,   9, UNI_CCC__AL }   /* canonicalcombiningclass=aboveleft */,
  {     4,  8424,  7892,   6,   8, UNI_INJAVANESE }   /* block=javanese */,
  {     9,  8886,  6991,   3,   4, UNI_SC__SOGD }   /* sc=sogd */,
  {     2,  8424,   976,   6,  27, UNI_ANCIENTGREEKMUSIC }   /* block=ancientgreekmusicalnotation */,
  {     4,  6918,  4687,  10,  15, UNI_LB__OP }   /* linebreak=openpunctuation */,
  {     0,   184,  9205,   2,   4, UNI_KNDA }   /* isknda */,
  {     0,  2148,  3723,   3,  16, UNI_SUTTONSIGNWRITING }   /* insuttonsignwriting */,
  {     8,  3671,  8079,  17,   4, UNI_GRAN }   /* scriptextensions=gran */,
  {     1,  9365,  9165,   4,   4, UNI_GREK }   /* scx=grek */,
  {    10,  3020,     0,   4,   0, UNI_DEVA }   /* deva */,
  {     3,  8899,    36,   5,   1, UNI_MATH }   /* math=t */,
  {     0,  9093,  7876,   4,   8, UNI_JAMOEXTA }   /* blk=jamoexta */,
  {     0,  9647,  8664,   3,   5, UNI_NV__1_SLASH_160 }   /* nv=1/160 */,
  {     2,   184,  8604,   2,   5, UNI_QMARK }   /* isqmark */,
  {     1,  5760,  5409,  13,   3, UNI_NV__100 }   /* numericvalue=100 */,
  {     0,  1472,     0,   9,   0, UNI__PERL_SURROGATE }   /* surrogate */,
  {     0,  8233,  7860,   7,   8, UNI_SC__HIRA }   /* script=hiragana */,
  {    21,  3254,    26,  18,   1, UNI_RI }   /* regionalindicator=y */,
  {     0,  8886,  9413,   3,   4, UNI_TAVT }   /* sc=tavt */,
  {     0,  9093,  6051,   4,   7, UNI_MAHJONG }   /* blk=mahjong */,
  {     0,  7419,    26,   9,   1, UNI_XIDS }   /* xidstart=y */,
  {     0,  6316,    36,  11,   1, UNI_IDC }   /* idcontinue=t */,
  {    13,   184,  4432,   2,  15, UNI_DIACRITICALSSUP }   /* isdiacriticalssup */,
  {    11,  9593,  5811,   3,  12, UNI_BC__AL }   /* bc=arabicletter */,
  {    17,  5339,   138,  14,   2, UNI_SB__FO }   /* sentencebreak=fo */,
  {     2,  9629,  7212,   3,   9, UNI_LB__B2 }   /* lb=breakboth */,
  {     4,  8424,  8177,   6,   7, UNI_NB }   /* block=noblock */,
  {     0,  8233,  7365,   7,   4, UNI_PAUC }   /* script=pauc */,
  {    17,   184,  1085,   3,  24, UNI_CWKCF }   /* ischangeswhennfkccasefolded */,
  {    12,  8233,  6646,   7,  11, UNI_HMNG }   /* script=pahawhhmong */,
  {     0,  9605,     7,   3,   3, UNI_DT__CAN }   /* dt=can */,
  {     2,  9125,     0,   4,   0, UNI_cwt_values_index }   /* cwt= */,
  {     9,  8424,  2086,   7,   7, UNI_INCYRILLIC }   /* block=cyrillic */,
  {     1,  3671,  2212,  18,   3, UNI_SINH }   /* scriptextensions=sinh */,
  {     1,  9946,  9390,   3,   3, UNI_SOGO }   /* issogo */,
  {     1,  9365,  7860,   4,   8, UNI_HIRA }   /* scx=hiragana */,
  {     0,  8233,  3620,   7,   4, UNI_SC__MANI }   /* script=mani */,
  {     0,   184,  7812,   2,   8, UNI_DUPL }   /* isduployan */,
  {     0,  8163,     0,   8,   0, UNI_NFKCQC__N }   /* nfkcqc=n */,
  {     2,  4821,     0,  13,   0, UNI_POSIXXDIGIT }   /* asciihexdigit */,
  {     0,  9903,  9916,   6,   5, UNI_XPOSIXBLANK }   /* xposixblank */,
  {     0,  6316,     0,  10,   0, UNI_IDC }   /* idcontinue */,
  {     0,  9599,  9433,   3,   4, UNI_CI }   /* ci=true */,
  {     0,  8424,  6569,   6,  11, UNI_MISCSYMBOLS }   /* block=miscsymbols */,
  {     0,  6816,  3773,   3,   7, UNI_INBOPOMOFO }   /* inbopomofo */,
  {     1,  8424,   316,   6,  33, UNI_SUPMATHOPERATORS }   /* block=supplementalmathematicaloperators */,
  {     7,  6194,  8930,   3,   4, UNI_INOSAGE }   /* inosage */,
  {     3,    21,  7884,   2,   8, UNI_JAMOEXTB }   /* injamoextb */,
  {     1,  9093,  1823,   4,  19, UNI_CJKCOMPATIDEOGRAPHS }   /* blk=cjkcompatideographs */,
  {     0,  8424,  5907,   6,  12, UNI_ETHIOPICEXTA }   /* block=ethiopicexta */,
  {     0,  2493,  3380,  20,  18, UNI_VO__TU }   /* verticalorientation=transformedupright */,
  {     1,  5435,     1,  13,   1, -UNI_BIDIM }   /* bidimirrored=n */,
  {     3,  8869,  9734,   5,   3, UNI_IDSB }   /* idsb=yes */,
  {    17,   184,   808,   2,  29, UNI_MISCARROWS }   /* ismiscellaneoussymbolsandarrows */,
  {     0,  9365,  8944,   4,   5, UNI_TAKR }   /* scx=takri */,
  {    16,  9909,     7,   3,   1, UNI_PC }   /* ispc */,
  {     0,   184,  7892,   2,   4, UNI_JAVA }   /* isjava */,
  {     0,   184,  3445,   3,   2, UNI_CWL }   /* iscwl */,
  {     0,  2957,     0,   9,   0, UNI_HALFMARKS }   /* halfmarks */,
  {     0,  8510,   995,   4,   2, -UNI_EXT }   /* ext=no */,
  {     1,  6828,  2373,  10,  20, UNI_BC__LRE }   /* bidiclass=lefttorightembedding */,
  {     4,  8886,  4492,   3,  15, UNI_ARMI }   /* sc=imperialaramaic */,
  {    23,  1362,  7614,  24,   2, UNI_CCC__17 }   /* canonicalcombiningclass=17 */,
  {     1,  2453,  9734,  20,   3, UNI_TERM }   /* terminalpunctuation=yes */,
  {    62,  6371,   995,  11,   2, -UNI_DEP }   /* deprecated=no */,
  {     0,  3868,  4402,  16,  15, UNI_PD }   /* generalcategory=dashpunctuation */,
  {     0,  4778,  7099,   3,   9, UNI_CN }   /* isunassigned */,
  {     8,  3671,  3772,  17,   8, UNI_BOPO }   /* scriptextensions=bopomofo */,
  {     1,   184,  8526,   2,   6, UNI_KTHI }   /* iskaithi */,
  {     3,  6005,   690,   3,   8, UNI_INCUNEIFORM }   /* incuneiform */,
  {     5,  6828,  3218,  10,  18, UNI_BC__B }   /* bidiclass=paragraphseparator */,
  {     2,  9365,  9189,   4,   4, UNI_HMNP }   /* scx=hmnp */,
  {     0,  4821,    26,  14,   1, UNI_POSIXXDIGIT }   /* asciihexdigit=y */,
  {     0,  8886,  7788,   3,   4, UNI_BALI }   /* sc=bali */,
  {     2,  1481,     0,   4,   0, UNI_SIND }   /* sind */,
  {    14,  8886,  9401,   3,   4, UNI_SC__TALE }   /* sc=tale */,
  {     1,  8886,  8924,   3,   5, UNI_SC__ORYA }   /* sc=oriya */,
  {     1,  2708,    80,   4,  33, UNI_ARABICMATH }   /* inarabicmathematicalalphabeticsymbols */,
  {     1,  5760,  8364,  13,   3, UNI_NV__400 }   /* numericvalue=400 */,
  {     2,   184,  6051,   2,   4, UNI_MAHJ }   /* ismahj */,
  {     0,  8233,  4297,   7,   4, UNI_BRAI }   /* script=brai */,
  {     2,  9113,  8479,   5,   5, UNI_WB__EB }   /* ccc=ccc133 */,
  {     3,  9093,  7248,   4,   9, UNI_INKHUDAWADI }   /* blk=khudawadi */,
  {     8,  9365,  7049,   5,   9, UNI_SAUR }   /* scx=saurashtra */,
  {     2,  9647,  7548,   3,   8, UNI_NV__1_SLASH_32 }   /* nv=3.12e-02 */,
  {     0,  9946,  8262,   3,   6, UNI_SOYO }   /* issoyombo */,
  {     1,  8886,  9161,   3,   4, UNI_SC__GONM }   /* sc=gonm */,
  {     1,   184,  5448,   2,  13, UNI_BLOCKELEMENTS }   /* isblockelements */,
  {     0,  9093,   719,   4,  30, UNI_ENCLOSEDALPHANUMSUP }   /* blk=enclosedalphanumericsupplement */,
  {     0,  1239,  8864,  25,   5, -UNI_COMPEX }   /* fullcompositionexclusion=false */,
  {     0,  8886,  7008,   3,  10, UNI_PHNX }   /* sc=phoenician */,
  {    14,  9141,  9734,   4,   3, UNI_DIA }   /* dia=yes */,
  {    12,  9647,  7540,   3,   2, UNI_NV__20 }   /* nv=20 */,
  {     4,  5760,  9749,  13,   2, UNI_NV__48 }   /* numericvalue=48 */,
  {     0,  9093,  4717,   4,  15, UNI_TAMILSUP }   /* blk=tamilsupplement */,
  {     0,   184,  1645,   2,  23, UNI_SHORTHANDFORMATCONTROLS }   /* isshorthandformatcontrols */,
  {     4,  8233,  4267,   7,   5, UNI_BAMU }   /* script=bamum */,
  {     1,  8424,  4297,   6,  15, UNI_BRAI }   /* block=braillepatterns */,
  {     1,  9953,  1696,   3,   2, UNI_VAI }   /* isvai */,
  {     2,  8418,     0,   6,   0, UNI_bidim_values_index }   /* bidim= */,
  {     0,  1362,  8795,  25,   4, UNI_CCC__30 }   /* canonicalcombiningclass=ccc30 */,
  {     1,  8884,  3484,   5,  17, UNI_INSC__CONSONANTPREFIXED }   /* insc=consonantprefixed */,
  {     0,  1713,    36,  22,   1, UNI_CWCF }   /* changeswhencasefolded=t */,
  {     4,  9049,  8993,   4,   4, UNI_AGE__10 }   /* age=10.0 */,
  {     3,  9113,  8805,   5,   4, UNI_CCC__32 }   /* ccc=ccc32 */,
  {     1,  6885,  4962,   3,  13, UNI_HIGHSURROGATES }   /* ishighsurrogates */,
  {     0,  6918,  9773,  10,   2, UNI_LB__XX }   /* linebreak=xx */,
  {     1,  2106,  7825,  21,   3, UNI_WB__EB }   /* graphemeclusterbreak=gaz */,
  {     3,    21,   977,   3,  26, UNI_ANCIENTGREEKMUSIC }   /* inancientgreekmusicalnotation */,
  {     2,    21,  7275,   2,   9, UNI_LATINEXTD }   /* inlatinextd */,
  {     3,  9113,    16,   4,   1, UNI_CCC__B }   /* ccc=b */,
  {     1,  6005,  2086,   3,  10, UNI_CYRILLICSUP }   /* incyrillicsup */,
  {     5,  8418,    26,   6,   1, UNI_BIDIM }   /* bidim=y */,
  {    17,  4462,     0,  14,   0, UNI_GREXT }   /* graphemeextend */,
  {     1,  3128,     3,  18,   1, -UNI_IDSB }   /* idsbinaryoperator=f */,
  {     1,  9365,  4792,   4,  15, UNI_ZANB }   /* scx=zanabazarsquare */,
  {     1,  1362,  8481,  24,   3, UNI_WB__EB }   /* canonicalcombiningclass=133 */,
  {     0,  8886,    57,   3,   2, UNI_SC__YI }   /* sc=yi */,
  {     0,  8955,     1,   4,   1, -UNI_IDC }   /* idc=n */,
  {    10,  3671,  8526,  17,   6, UNI_KTHI }   /* scriptextensions=kaithi */,
  {    14,  6005,  2931,   3,  10, UNI_CHEROKEESUP }   /* incherokeesup */,
  {     2,    21,  3290,   2,  18, UNI_RUMI }   /* inruminumeralsymbols */,
  {     0,  8424,  1867,   6,  22, UNI_DIACRITICALSFORSYMBOLS }   /* block=diacriticalsforsymbols */,
  {     0,  9237,  8864,   4,   5, -UNI_LOE }   /* loe=false */,
  {     0,  7018,  7487,  10,   1, UNI_IN__6 }   /* presentin=6 */,
  {     0,  3671,  2393,  17,  20, UNI_HMNP }   /* scriptextensions=nyiakengpuachuehmong */,
  {     0,  8051,     0,   6,   0, UNI_COMPEX }   /* compex */,
  {     0,  6885,  9182,   3,   3, UNI_HLUW }   /* ishluw */,
  {     1,  8424,  3164,   6,   9, UNI_LATINEXTA }   /* block=latinexta */,
  {     1,  9602,     1,   3,   1, -UNI_DI }   /* di=n */,
  {     2,  8879,  4777,   5,  15, UNI_LOE }   /* inpc=visualorderleft */,
  {     0,  1362,  7631,  24,   1, UNI_CCC__9 }   /* canonicalcombiningclass=9 */,
  {    18,  9593,  9614,   3,   3, UNI_BC__FSI }   /* bc=fsi */,
  {    19,  6005,  1847,   4,  20, UNI_INDICNUMBERFORMS }   /* incommonindicnumberforms */,
  {     0,  8233,  4220,   7,   4, UNI_TANG }   /* script=tang */,
  {     0,  8886,  7980,   3,   4, UNI_UGAR }   /* sc=ugar */,
  {     0,  3951,  6317,   3,   9, UNI_IDC }   /* isidcontinue */,
  {     0,  8424,  4172,   6,  16, UNI_SUPMATHOPERATORS }   /* block=supmathoperators */,
  {     6,  9647,  7716,   3,   8, UNI_NV__3_SLASH_4 }   /* nv=7.50e-01 */,
  {     1,  8871,  4140,   3,   5, UNI_SB__XX }   /* sb=other */,
  {     0,  8424,  7311,   6,   9, UNI_INNEWTAILUE }   /* block=newtailue */,
  {     0,  8886,  8550,   3,   4, UNI_LEPC }   /* sc=lepc */,
  {     0,  8886,  9281,   3,   4, UNI_NEWA }   /* sc=newa */,
  {     0,  8634,  8864,   6,   5, -UNI_UIDEO }   /* uideo=false */,
  {     0,  9093,  4792,   4,  15, UNI_INZANABAZARSQUARE }   /* blk=zanabazarsquare */,
  {     2,  3002,  8574,  18,   6, UNI_DT__NAR }   /* decompositiontype=narrow */,
  {    13,  7932,   995,   8,   2, -UNI_RADICAL }   /* radical=no */,
  {     9,  5269,  9734,  14,   3, UNI_PATSYN }   /* patternsyntax=yes */,
  {     2,  9647,  7628,   3,   8, UNI_NV__3_SLASH_64 }   /* nv=4.69e-02 */,
  {    10,  1977,    36,  22,   1, UNI__PERL_NCHAR }   /* noncharactercodepoint=t */,
  {     1,  8886,     8,   4,   3, UNI_SC__KANA }   /* sc=kana */,
  {    10,  8233,  7118,   7,  10, UNI_WARA }   /* script=warangciti */,
  {    10,  8634,   995,   6,   2, -UNI_UIDEO }   /* uideo=no */,
  {     2,  8424,  7772,   6,   8, UNI_INARMENIAN }   /* block=armenian */,
  {     1,  9093,  8310,   4,   7, UNI_INTIRHUTA }   /* blk=tirhuta */,
  {     1,  7194,     0,   9,   0, UNI_ARABICPFB }   /* arabicpfb */,
  {     8,  8233,  9401,   7,   4, UNI_SC__TALE }   /* script=tale */,
  {     0,  9647,  7631,   3,   1, UNI_NV__9 }   /* nv=9 */,
  {     1,  9946,  7049,   3,   3, UNI_SAUR }   /* issaur */,
  {    18,  8640,  9734,   6,   3, UNI_XPOSIXUPPER }   /* upper=yes */,
  {     7,   184,  9779,   2,   2, UNI_ZS }   /* iszs */,
  {     2,  3671,  8226,  17,   7, UNI_PHAG }   /* scriptextensions=phagspa */,
  {     1,  5760,  9500,  13,   3, UNI_NV__1_SLASH_7 }   /* numericvalue=1/7 */,
  {     0,  5269,     0,  14,   0, UNI_patsyn_values_index }   /* patternsyntax= */,
  {     0,  9605,     0,   3,   0, UNI_dt_values_index }   /* dt= */,
  {     2,  8886,  9065,   3,   4, UNI_ARMI }   /* sc=armi */,
  {     1,  7128,  1164,  10,   2, UNI_LB__LF }   /* wordbreak=lf */,
  {     9,  8709,     0,   5,   0, UNI_BUHD }   /* buhid */,
  {     1,  5760,  7676,  13,   8, UNI_NV__1_SLASH_16 }   /* numericvalue=6.25e-02 */,
  {     0,  6918,  9761,  10,   2, UNI_GCB__L }   /* linebreak=jl */,
  {     6,  9904,  9921,   5,   5, UNI_POSIXPRINT }   /* posixprint */,
  {     2,  5760,  5409,  13,   6, UNI_NV__100000 }   /* numericvalue=100000 */,
  {     0,  3951,  7421,   3,   6, UNI_IDS }   /* isidstart */,
  {     0,  9093,  8072,   4,   7, UNI_INELYMAIC }   /* blk=elymaic */,
  {     8,  8418,   995,   6,   2, -UNI_BIDIM }   /* bidim=no */,
  {     3,   184,  1780,   3,  20, UNI_CWT }   /* ischangeswhentitlecased */,
  {    12,  9093,  9650,   4,   3, UNI_OCR }   /* blk=ocr */,
  {     4,  9647,  8988,   3,   2, UNI_NV__41 }   /* nv=41 */,
  {     8,  7128,  2368,  10,   2, UNI_LB__HL }   /* wordbreak=hl */,
  {     9,  9153,  1164,   4,   2, UNI_LB__LF }   /* gcb=lf */,
  {     8,  8886,  8108,   4,   6, UNI_SC__KNDA }   /* sc=kannada */,
  {     0,  9113,  7763,   4,   2, UNI_CCC__19 }   /* ccc=19 */,
  {     1,  9647,  9029,   3,   4, UNI_NV__3_SLASH_64 }   /* nv=3/64 */,
  {     0,  2148,  7059,   3,   9, UNI_SMALLFORMS }   /* insmallforms */,
  {     2,  8684,     3,   5,   1, -UNI_POSIXXDIGIT }   /* ahex=f */,
  {    12,  9093,  2930,   4,  18, UNI_CHEROKEESUP }   /* blk=cherokeesupplement */,
  {     0,  5565,  5129,  13,  14, UNI_JG__MANICHAEANKAPH }   /* joininggroup=manichaeankaph */,
  {    17,  9093,  4252,   4,  15, UNI_ARABICEXTA }   /* blk=arabicextendeda */,
  {     5,  8233,  7980,   7,   8, UNI_UGAR }   /* script=ugaritic */,
  {     1,  8160,  2629,   4,  17, UNI_ENCLOSEDALPHANUMSUP }   /* inenclosedalphanumsup */,
  {     0,  9093,  1188,   4,  26, UNI_KATAKANAEXT }   /* blk=katakanaphoneticextensions */,
  {     0,  8869,     0,   5,   0, UNI_idsb_values_index }   /* idsb= */,
  {     1,  9093,  1576,   4,  23, UNI_GEOMETRICSHAPESEXT }   /* blk=geometricshapesextended */,
  {     3,  9605,  9461,   3,   4, UNI_EA__F }   /* dt=wide */,
  {     0,  5760,  7724,  13,   8, UNI_NV__4_SLASH_5 }   /* numericvalue=8.00e-01 */,
  {    20,  8508,    26,   6,   1, UNI_GREXT }   /* grext=y */,
  {     3,  9093,  8628,   4,   6, UNI_INTHAANA }   /* blk=thaana */,
  {     1,   184,  3852,   2,  16, UNI_PF }   /* isfinalpunctuation */,
  {     1,  9113,  9545,   4,   3, UNI_CCC__IS }   /* ccc=240 */,
  {     1,  8884,  7972,   5,   8, UNI_INSC__TONEMARK }   /* insc=tonemark */,
  {     1,  8886,  8859,   3,   4, UNI_SC__DOGR }   /* sc=dogr */,
  {     4,  9365,  8550,   4,   4, UNI_LEPC }   /* scx=lepc */,
  {     3,  6918,  4877,  10,  14, UNI_LB__SA }   /* linebreak=complexcontext */,
  {     0,  3671,  9213,  17,   4, UNI_LANA }   /* scriptextensions=lana */,
  {     1,  3671,  6724,  18,   3, UNI_SYLO }   /* scriptextensions=sylo */,
  {    11,  1768,     0,   5,   0, UNI_XPOSIXLOWER }   /* lower */,
  {     1,  5085,     0,  12,   0, UNI_INMANICHAEAN }   /* inmanichaean */,
  {     1,  7365,     0,   9,   0, UNI_PAUC }   /* paucinhau */,
  {     0,  8617,     0,   5,   0, UNI_term_values_index }   /* term= */,
  {    11,  9731,  5346,   3,   2, UNI_WB__EB }   /* wb=eb */,
  {     0,  8634,    26,   6,   1, UNI_UIDEO }   /* uideo=y */,
  {     0,  8424,  7203,   6,   9, UNI_INBHAIKSUKI }   /* block=bhaiksuki */,
  {     4,  4462,    36,  15,   1, UNI_GREXT }   /* graphemeextend=t */,
  {     0,  8233,  8205,   7,   7, UNI_OSMA }   /* script=osmanya */,
  {     1,  3671,  8205,  17,   4, UNI_OSMA }   /* scriptextensions=osma */,
  {     0,  9093,  8679,   4,   5, UNI_INADLAM }   /* blk=adlam */,
  {    10,  8705,  7814,   4,   6, UNI_INDUPLOYAN }   /* induployan */,
  {     0,  8424,  7844,   6,   8, UNI_INGUJARATI }   /* block=gujarati */,
  {    14,  9365,  9285,   4,   4, UNI_NKO }   /* scx=nkoo */,
  {    12,  9417,     0,   4,   0, UNI_TFNG }   /* tfng */,
  {    15,  8233,  4205,   8,   5, UNI_SC__SYRC }   /* script=syriac */,
  {     2,  4580,  2171,   4,  12, UNI_MEETEIMAYEKEXT }   /* inmeeteimayekext */,
  {     1,  3671,  2353,  17,  20, UNI_PHLI }   /* scriptextensions=inscriptionalpahlavi */,
  {     9,  9647,  7476,   3,   8, UNI_NV__3_SLASH_20 }   /* nv=1.50e-01 */,
  {     0,  9237,     3,   4,   1, -UNI_LOE }   /* loe=f */,
  {     8,  3671,  7311,  17,   9, UNI_TALU }   /* scriptextensions=newtailue */,
  {     1,  1362,  7507,  24,   2, UNI_CCC__12 }   /* canonicalcombiningclass=12 */,
  {     1,  8424,   114,   7,  34, UNI_DIACRITICALSFORSYMBOLS }   /* block=combiningdiacriticalmarksforsymbols */,
  {     0,  8886,  7048,   3,   4, UNI_SAUR }   /* sc=saur */,
  {     0,  8332,  3417,   3,  16, UNI_ALCHEMICAL }   /* isalchemicalsymbols */,
  {     1,  9233,     0,   4,   0, UNI_LISU }   /* lisu */,
  {     1,  2589,     0,  11,   0, UNI_COUNTINGROD }   /* countingrod */,
  {     3,  8886,  7356,   3,   9, UNI_PALM }   /* sc=palmyrene */,
  {     0,  1911,  1214,  22,   9, UNI_INSC__CONSONANT }   /* indicsyllabiccategory=consonant */,
  {     0,   184,  3996,   2,  16, UNI_LINEARBSYLLABARY }   /* islinearbsyllabary */,
  {     0,  9647,  7484,   3,   8, UNI_NV__1_SLASH_64 }   /* nv=1.56e-02 */,
  {     0,  9650,     0,   3,   0, UNI_OCR }   /* ocr */,
  {     1,  3951,  2149,   3,  20, UNI_PRTI }   /* isinscriptionalparthian */,
  {     9,  8899,  8864,   5,   5, -UNI_MATH }   /* math=false */,
  {     8,  1924,     0,  10,   0, UNI_L }   /* category=l */,
  {     0,  8871,     0,   3,   0, UNI_sb_values_index }   /* sb= */,
  {    20,  8424,  3038,   6,  11, UNI_ETHIOPICSUP }   /* block=ethiopicsup */,
  {     0,  9093,  5734,   4,  13, UNI_MISCTECHNICAL }   /* blk=misctechnical */,
  {     5,  7128,  6668,  10,  11, UNI_WB__SQ }   /* wordbreak=singlequote */,
  {    11,  7025,  7612,   3,   3, UNI_IN__4_DOT_1 }   /* in=4.1 */,
  {     0,  8424,   837,   6,  18, UNI_PHONETICEXT }   /* block=phoneticextensions */,
  {     9,  8849,  9734,   5,   3, UNI_CWCM }   /* cwcm=yes */,
  {     5,  3469,     0,   4,   0, UNI_UCAS }   /* ucas */,
  {     0,  5760,  9743,  13,   2, UNI_NV__45 }   /* numericvalue=45 */,
  {     5,  2930,     0,   8,   0, UNI_CHER }   /* cherokee */,
  {     6,  1362,  9512,  24,   3, UNI_CCC__202 }   /* canonicalcombiningclass=202 */,
  {     1,  9093,  2779,   4,   9, UNI_INMONGOLIAN }   /* blk=mongolian */,
  {    12,  9620,    45,   3,   2, UNI_CO }   /* gc=co */,
  {     5,  6194,  6244,   3,  11, UNI_INOLDHUNGARIAN }   /* inoldhungarian */,
  {     1,  8424,  3200,   6,  18, UNI_ORNAMENTALDINGBATS }   /* block=ornamentaldingbats */,
  {     0,  9620,   400,   3,   6, UNI_CF }   /* gc=format */,
  {     7,  3002,  9665,  18,   3, UNI_DT__SML }   /* decompositiontype=sml */,
  {    15,  5565,  5101,  13,  14, UNI_JG__MANICHAEANFIVE }   /* joininggroup=manichaeanfive */,
  {     0,  8424,  7995,   6,   7, UNI_INAVESTAN }   /* block=avestan */,
  {     1,  3002,  1362,  18,   9, UNI_DT__CAN }   /* decompositiontype=canonical */,
  {    17,  9113,  8800,   5,   4, UNI_CCC__31 }   /* ccc=ccc31 */,
  {     0,  8233,    57,   7,   2, UNI_SC__YI }   /* script=yi */,
  {     8,  1362,  8469,  24,   3, UNI_CCC__130 }   /* canonicalcombiningclass=130 */,
  {     2,  9093,  6243,   4,  12, UNI_INOLDHUNGARIAN }   /* blk=oldhungarian */,
  {    14,  1362,  9521,  24,   3, UNI_CCC__BR }   /* canonicalcombiningclass=222 */,
  {     2,  9593,   426,   3,   2, UNI_BC__ES }   /* bc=es */,
  {     3,  4747,     0,  15,   0, UNI_UPPERCASELETTER }   /* uppercaseletter */,
  {     5,  8275,     0,   7,   0, UNI_SUPPUAB }   /* suppuab */,
  {     3,  9473,     0,   4,   0, UNI_YI }   /* yiii */,
  {     6,   184,  3620,   2,   4, UNI_MANI }   /* ismani */,
  {     3,  9365,  2212,   5,   3, UNI_SINH }   /* scx=sinh */,
  {     7,  9093,  1188,   4,   8, UNI_INKATAKANA }   /* blk=katakana */,
  {     2,  9725,  3391,   3,   7, UNI_VO__U }   /* vo=upright */,
  {     0,  3671,  8114,  17,   7, UNI_KALI }   /* scriptextensions=kayahli */,
  {     5,  9113,     8,   4,   1, UNI_CCC__A }   /* ccc=a */,
  {     1,  6194,  4673,   3,  14, UNI_SARB }   /* inoldsoutharabian */,
  {     0,  8332,    97,   3,   9, UNI_XPOSIXALPHA }   /* isalphabetic */,
  {     9,  9285,     0,   3,   0, UNI_NKO }   /* nko */,
  {     2,  3671,  9177,  17,   4, UNI_HANO }   /* scriptextensions=hano */,
  {    17,  9113,  2920,   4,  10, UNI_CCC__AR }   /* ccc=aboveright */,
  {     0,  8886,  9109,   3,   4, UNI_CANS }   /* sc=cans */,
  {     0,  9113,  8830,   5,   4, UNI_CCC__84 }   /* ccc=ccc84 */,
  {     0,  8424,  7257,   6,   9, UNI_LATINEXTB }   /* block=latinextb */,
  {     0,  8424,  3900,   6,  16, UNI_HALFANDFULLFORMS }   /* block=halfandfullforms */,
  {    18,  8886,  2333,   3,   4, UNI_SC__GLAG }   /* sc=glag */,
  {     3,    21,  8538,   2,   6, UNI_INKHOJKI }   /* inkhojki */,
  {     0,  3671,  7347,  17,   9, UNI_ORKH }   /* scriptextensions=oldturkic */,
  {    15,  5760,  8802,  13,   2, UNI_NV__31 }   /* numericvalue=31 */,
  {     0,  9093,  1851,   4,  16, UNI_INDICNUMBERFORMS }   /* blk=indicnumberforms */,
  {     6,  9365,  7804,   4,   4, UNI_BUGI }   /* scx=bugi */,
  {    24,  9365,  9269,   4,   4, UNI_MYMR }   /* scx=mymr */,
  {     2,  4447,     1,  15,   1, UNI_EA__N }   /* eastasianwidth=n */,
  {     1,   133,     0,   4,   0, UNI_M }   /* mark */,
  {     1,  6005,  8024,   3,   6, UNI_CJKEXTC }   /* incjkextc */,
  {     0,  8617,     1,   5,   1, -UNI_TERM }   /* term=n */,
  {    12,  6005,   690,   3,  29, UNI_CUNEIFORMNUMBERS }   /* incuneiformnumbersandpunctuation */,
  {     5,  8886,  8142,   3,   4, UNI_MARC }   /* sc=marc */,
  {     0,  9093,  1576,   4,  18, UNI_GEOMETRICSHAPESEXT }   /* blk=geometricshapesext */,
  {     1,  9365,  8065,   4,   4, UNI_ELBA }   /* scx=elba */,
  {     1,  8886,  6159,   3,  12, UNI_SC__GONM }   /* sc=masaramgondi */,
  {     0,  8233,  8562,   7,   4, UNI_LYCI }   /* script=lyci */,
  {     1,  8233,  8514,   7,   6, UNI_HATR }   /* script=hatran */,
  {     1,   184,  4989,   2,   6, UNI_KANGXI }   /* iskangxi */,
  {     4,  1362,   184,  24,   2, UNI_CCC__IS }   /* canonicalcombiningclass=is */,
  {     1,   184,   510,   3,  29, UNI_CJKEXTA }   /* iscjkunifiedideographsextensiona */,
  {    22,  9647,  8985,   3,   3, UNI_NV__1_SLASH_6 }   /* nv=1/6 */,
  {     0,  4140,     0,   5,   0, UNI_C }   /* other */,
  {     1,  2148,  2212,   3,  20, UNI_SINHALAARCHAICNUMBERS }   /* insinhalaarchaicnumbers */,
  {     3,  8424,  1856,   6,  11, UNI_NUMBERFORMS }   /* block=numberforms */,
  {     4,  3671,  8241,  18,   6, UNI_SHRD }   /* scriptextensions=sharada */,
  {     1,  9093,  2333,   4,  10, UNI_INGLAGOLITIC }   /* blk=glagolitic */,
  {     3,  8072,     0,   4,   0, UNI_ELYM }   /* elym */,
  {     0,  9608,     8,   3,   1, UNI_EA__A }   /* ea=a */,
  {     0,  9946,  9386,   3,   3, UNI_SHRD }   /* isshrd */,
  {     0,  1362,    16,  24,   1, UNI_CCC__B }   /* canonicalcombiningclass=b */,
  {     3,  9623,  3654,   3,  17, UNI_JG__MANICHAEANTHAMEDH }   /* jg=manichaeanthamedh */,
  {     7,  9093,  3603,   4,  17, UNI_LETTERLIKESYMBOLS }   /* blk=letterlikesymbols */,
  {     0,   184,  2086,   3,   7, UNI_CYRL }   /* iscyrillic */,
  {     0,  1243,  9433,  21,   4, UNI_CE }   /* compositionexclusion=true */,
  {     0,  7185,     0,   9,   0, UNI_ARABICPFA }   /* arabicpfa */,
  {     0,  7419,  8864,   9,   5, -UNI_XIDS }   /* xidstart=false */,
  {    40,  7025,  7436,   3,   3, UNI_IN__1_DOT_1 }   /* in=1.1 */,
  {     1,  8424,   719,   6,  16, UNI_ENCLOSEDALPHANUM }   /* block=enclosedalphanum */,
  {     0,  9097,     0,   4,   0, UNI_bpt_values_index }   /* bpt= */,
  {     3,    21,  7118,   2,  10, UNI_INWARANGCITI }   /* inwarangciti */,
  {     0,  3128,  9433,  18,   4, UNI_IDSB }   /* idsbinaryoperator=true */,
  {     0,  8233,  9409,   7,   4, UNI_SC__TAML }   /* script=taml */,
  {     0,  9365,  9101,   4,   4, UNI_BUHD }   /* scx=buhd */,
  {    10,  8886,  9241,   3,   4, UNI_MEDF }   /* sc=medf */,
  {     0,  9623,  4567,   3,  15, UNI_JG__MANICHAEANZAYIN }   /* jg=manichaeanzayin */,
  {     6,  7018,  7159,  10,   3, UNI_IN__5 }   /* presentin=5.0 */,
  {     0,  3868,  1508,  16,   2, UNI_PS }   /* generalcategory=ps */,
  {     1,  3671,  9249,  17,   4, UNI_MERC }   /* scriptextensions=merc */,
  {     1,  8051,     3,   7,   1, -UNI_COMPEX }   /* compex=f */,
  {     0,  8424,  8924,   6,   5, UNI_INORIYA }   /* block=oriya */,
  {     0,  9623,  6756,   3,  11, UNI_JG__YEHWITHTAIL }   /* jg=yehwithtail */,
  {     1,  8496,     3,   6,   1, -UNI_CWKCF }   /* cwkcf=f */,
  {     0,  7128,    72,  10,   2, UNI_WB__LE }   /* wordbreak=le */,
  {     1,  9647,  9517,   3,   2, UNI_NV__42 }   /* nv=42 */,
  {     1,  7018,  9683,  10,   3, UNI_IN__3_DOT_1 }   /* presentin=v31 */,
  {     1,  9662,    36,   3,   1, UNI_SD }   /* sd=t */,
  {     0,  8114,     0,   7,   0, UNI_KALI }   /* kayahli */,
  {    19,  5760,  7556,  13,   8, UNI_NV__1_SLASH_32 }   /* numericvalue=3.13e-02 */,
  {     0,  2204,  7331,   4,   7, UNI_ITAL }   /* isolditalic */,
  {     1,  9093,  4220,   4,   6, UNI_INTANGUT }   /* blk=tangut */,
  {     3,  9113,  7459,   4,   2, UNI_CCC__21 }   /* ccc=21 */,
  {     5,  8424,  2760,   6,  19, UNI_MODIFIERTONELETTERS }   /* block=modifiertoneletters */,
  {     9,  9620,  1036,   3,   2, UNI_CASEDLETTER }   /* gc=lc */,
  {    18,  8424,  2513,   6,  19, UNI_ANCIENTGREEKNUMBERS }   /* block=ancientgreeknumbers */,
  {     3,  3671,  8914,  17,   5, UNI_NSHU }   /* scriptextensions=nushu */,
  {    77,  9153,  5944,   5,  11, UNI_WB__EB }   /* gcb=glueafterzwj */,
  {     3,  8886,  7964,   3,   8, UNI_TFNG }   /* sc=tifinagh */,
  {     0,  2684,     0,  19,   0, UNI_hst_values_index }   /* hangulsyllabletype= */,
  {     0,  8424,  2931,   7,   7, UNI_INCHEROKEE }   /* block=cherokee */,
  {     0,  8508,     3,   6,   1, -UNI_GREXT }   /* grext=f */,
  {    16,  3671,  8562,  17,   4, UNI_LYCI }   /* scriptextensions=lyci */,
  {     0,  9113,  4701,   4,   2, UNI_CCC__0 }   /* ccc=nr */,
  {    21,  6918,  5953,  10,   2, UNI_LB__WJ }   /* linebreak=wj */,
  {     2,  8616,     0,   5,   0, UNI_STERM }   /* sterm */,
  {    16,   184,     0,   3,   0, UNI_C }   /* isc */,
  {     1,  9623,  6536,   3,  11, UNI_JG__MALAYALAMJA }   /* jg=malayalamja */,
  {    16,  4361,  1578,   4,  21, UNI_GEOMETRICSHAPESEXT }   /* ingeometricshapesextended */,
  {    16,  8886,  9185,   3,   4, UNI_HMNG }   /* sc=hmng */,
  {    14,  1158,  2022,   3,  14, UNI_TRANSPORTANDMAP }   /* intransportandmap */,
  {    20,  8886,  9353,   3,   4, UNI_RUNR }   /* sc=runr */,
  {     1,  9093,  8107,   4,   7, UNI_INKANNADA }   /* blk=kannada */,
  {     5,  9093,  6316,   4,   3, UNI_INIDC }   /* blk=idc */,
  {    13,  3671,  8262,  18,   3, UNI_SOYO }   /* scriptextensions=soyo */,
  {     6,  9093,   878,   4,  10, UNI_PUA }   /* blk=privateuse */,
  {     4,  8924,     0,   5,   0, UNI_ORYA }   /* oriya */,
  {     5,  9620,  4507,   3,  15, UNI_LOWERCASELETTER }   /* gc=lowercaseletter */,
  {     3,  3948,   922,   3,  27, UNI_VSSUP }   /* invariationselectorssupplement */,
  {     0,  4705,  8304,   3,   6, UNI_TIBT }   /* istibetan */,
  {     1,  3671,  9085,  17,   4, UNI_BATK }   /* scriptextensions=batk */,
  {    30,  1497,     0,   9,   0, UNI_gc_values_index }   /* category= */,
  {     4,  8556,     3,   6,   1, -UNI_XPOSIXLOWER }   /* lower=f */,
  {     0,  7025,  9437,   3,   4, UNI_IN__10 }   /* in=v100 */,
  {     0,  5760,  8388,  13,   4, UNI_NV__7000 }   /* numericvalue=7000 */,
  {     0,  8233,  7332,   7,   4, UNI_ITAL }   /* script=ital */,
  {     1,  8886,  9285,   3,   3, UNI_NKO }   /* sc=nko */,
  {    17,  9605,  2204,   3,   3, UNI_DT__ISO }   /* dt=iso */,
  {     0,  9901,  6316,   3,   3, UNI_XIDC }   /* isxidc */,
  {     0,  9620,  6039,   3,  12, UNI_NL }   /* gc=letternumber */,
  {     0,  5269,   995,  14,   2, -UNI_PATSYN }   /* patternsyntax=no */,
  {     2,  9113,  9527,   4,   3, UNI_CCC__R }   /* ccc=226 */,
  {     0,  8051,     0,   7,   0, UNI_compex_values_index }   /* compex= */,
  {     0,  2148,  1669,   3,  22, UNI_SUPPUNCTUATION }   /* insupplementalpunctuation */,
  {     7,  8424,  6767,   6,  11, UNI_YISYLLABLES }   /* block=yisyllables */,
  {     2,  9731,  7284,   3,   9, UNI_WB__ML }   /* wb=midletter */,
  {    23,  8886,  7302,   3,   9, UNI_NBAT }   /* sc=nabataean */,
  {     0,  9365,  4946,   4,   4, UNI_CHAM }   /* scx=cham */,
  {    16,  1955,     0,  22,   0, UNI_MISCTECHNICAL }   /* miscellaneoustechnical */,
  {     0,  1362,  7435,  24,   2, UNI_CCC__11 }   /* canonicalcombiningclass=11 */,
  {     4,  9781,  6316,   6,   6, UNI__PERL_IDCONT }   /* _perl_idcont */,
  {    21,   184,  3884,   2,  16, UNI_GEORGIANEXT }   /* isgeorgianextended */,
  {     2,  1362,  6818,  24,  10, UNI_CCC__BR }   /* canonicalcombiningclass=belowright */,
  {     0,  3671,  6898,  17,   4, UNI_KHAR }   /* scriptextensions=khar */,
  {    17,  1691,    17,  22,   1, UNI_BPT__O }   /* bidipairedbrackettype=o */,
  {     6,  8854,    36,   5,   1, UNI_DASH }   /* dash=t */,
  {     0,  2142,    16,   3,   1, UNI_NB }   /* innb */,
  {     1,   184,  4092,   2,  16, UNI_MISCMATHSYMBOLSB }   /* ismiscmathsymbolsb */,
  {     0,  3671,  3467,  17,  17, UNI_AGHB }   /* scriptextensions=caucasianalbanian */,
  {     2,  5213,  8904,  14,   5, UNI_NFCQC__M }   /* nfcquickcheck=maybe */,
  {     0,   184,  3772,   2,  11, UNI_BOPOMOFOEXT }   /* isbopomofoext */,
  {     3,  9217,     0,   4,   0, UNI_LAO }   /* laoo */,
  {     3,  2148,  2856,   3,  18, UNI_SUPARROWSA }   /* insupplementalarrowsa */,
  {     1,  8233,  4672,   7,  15, UNI_SARB }   /* script=oldsoutharabian */,
  {     3,  9093,   183,   4,  20, UNI_MISCSYMBOLS }   /* blk=miscellaneoussymbols */,
  {     1,  9731,  7293,   3,   6, UNI_WB__MN }   /* wb=midnum */,
  {     3,  3868,  3852,  16,  16, UNI_PF }   /* generalcategory=finalpunctuation */,
  {     5,  2106,    18,  21,   2, UNI_RI }   /* graphemeclusterbreak=ri */,
  {     0,  8886,  9157,   3,   4, UNI_SC__GONG }   /* sc=gong */,
  {     1,  2204,  1031,   3,  26, UNI_OCR }   /* isopticalcharacterrecognition */,
  {     3,   184,  1239,   2,  24, UNI_COMPEX }   /* isfullcompositionexclusion */,
  {     8,  3293,     1,   3,  33, UNI_UCAS }   /* inunifiedcanadianaboriginalsyllabics */,
  {    10,  4778,  1813,   3,   8, UNI_XPOSIXUPPER }   /* isuppercase */,
  {     5,  9365,  7796,   4,   4, UNI_BASS }   /* scx=bass */,
  {     2,  9093,   893,   4,  28, UNI_SUPPUAB }   /* blk=supplementaryprivateuseareab */,
  {     0,  5760,  9745,  13,   2, UNI_NV__46 }   /* numericvalue=46 */,
  {     0,  9153,  7820,   4,   8, UNI_WB__EB }   /* gcb=ebasegaz */,
  {    11,  8233,   835,  10,   1, UNI_SHAW }   /* script=shaw */,
  {     2,  5760,  5409,  13,   4, UNI_NV__1000 }   /* numericvalue=1000 */,
  {     1,  8233,  5955,   7,  12, UNI_SC__GONG }   /* script=gunjalagondi */,
  {     1,  9728,     1,   3,   1, -UNI_VS }   /* vs=n */,
  {     0,  5760,  9001,  13,   4, UNI_NV__11_SLASH_2 }   /* numericvalue=11/2 */,
  {     2,   184,   567,   2,   2, UNI_NB }   /* isnb */,
  {    11,  9623,  7828,   3,   8, UNI_JG__FARSIYEH }   /* jg=farsiyeh */,
  {     0,  8233,  4267,   7,   4, UNI_BAMU }   /* script=bamu */,
  {     0,  2142,  9282,   3,   3, UNI_INNEWA }   /* innewa */,
  {     8,   184,  6183,   2,   4, UNI_MEND }   /* ismend */,
  {     0,  9383,  8242,   4,   5, UNI_INSHARADA }   /* insharada */,
  {     1,  8233,  8484,   7,   6, UNI_SC__CAKM }   /* script=chakma */,
  {     0,  5565,  6135,  13,  12, UNI_JG__MALAYALAMTTA }   /* joininggroup=malayalamtta */,
  {     0,  8219,  9433,   7,   4, UNI_PATSYN }   /* patsyn=true */,
  {    11,   184,  3705,   2,  17, UNI_SMALLFORMS }   /* issmallformvariants */,
  {     1,  9731,  7825,   3,   3, UNI_WB__EB }   /* wb=gaz */,
  {     0,  1159,  5678,   3,   4, UNI_NV__NAN }   /* nt=none */,
  {     0,  9647,  8674,   3,   5, UNI_NV__11_SLASH_12 }   /* nv=11/12 */,
  {     0,   184,  3210,   2,   8, UNI_DINGBATS }   /* isdingbats */,
  {     8,  5760,  7748,  13,   8, UNI_NV__17_SLASH_2 }   /* numericvalue=8.50e+00 */,
  {     0,  5085,  5723,   4,  11, UNI_MAYANNUMERALS }   /* inmayannumerals */,
  {     1,  5760,  9025,  13,   4, UNI_NV__3_SLASH_20 }   /* numericvalue=3/20 */,
  {    16,  7025,  9698,   3,   3, UNI_IN__5_DOT_1 }   /* in=v51 */,
  {     4,  9081,     0,   4,   0, UNI_AVST }   /* avst */,
  {     0,  8532,     0,   6,   0, UNI_KANBUN }   /* kanbun */,
  {     1,  8871,  7383,   3,   9, UNI_SB__SC }   /* sb=scontinue */,
  {     0,  9365,  8241,   5,   6, UNI_SHRD }   /* scx=sharada */,
  {     8,  9593,  2433,   3,  11, UNI_BC__R }   /* bc=righttoleft */,
  {     3,  9620,  9775,   3,   2, UNI_ZL }   /* gc=zl */,
  {     8,  8886,  7772,   3,   8, UNI_SC__ARMN }   /* sc=armenian */,
  {     0,  5760,  8817,  13,   2, UNI_NV__34 }   /* numericvalue=34 */,
  {    96,  8233,  9285,   7,   4, UNI_NKO }   /* script=nkoo */,
  {     2,  8424,  2393,   6,  20, UNI_INNYIAKENGPUACHUEHMONG }   /* block=nyiakengpuachuehmong */,
  {     0,  9647,  8400,   3,   2, UNI_NV__90 }   /* nv=90 */,
  {     1,  8954,    36,   5,   1, UNI_XIDC }   /* xidc=t */,
  {     0,  8635,     3,   5,   1, -UNI_IDEO }   /* ideo=f */,
  {     6,  6918,  7202,  10,   2, UNI_LB__BB }   /* linebreak=bb */,
  {     2,   446,     0,  18,   0, UNI_IDEOGRAPHICSYMBOLS }   /* ideographicsymbols */,
  {     2,  2148,  7089,   3,   9, UNI_SUPARROWSC }   /* insuparrowsc */,
  {     0,  8424,  8058,   6,   7, UNI_DSRT }   /* block=deseret */,
  {     3,  9049,  9587,   4,   3, UNI_AGE__9 }   /* age=9.0 */,
  {     0,  9725,   471,   3,   2, UNI_VO__TU }   /* vo=tu */,
  {     1,  9365,  8114,   4,   7, UNI_KALI }   /* scx=kayahli */,
  {     1,  8424,  1003,   6,  27, UNI_ENCLOSEDCJK }   /* block=enclosedcjklettersandmonths */,
  {     8,   184,  1867,   2,  12, UNI_DIACRITICALS }   /* isdiacriticals */,
  {     1,  6005,  8045,   3,   6, UNI_CJKEXTF }   /* incjkextf */,
  {    24,  9647,  8669,   3,   3, UNI_NV__1_SLASH_3 }   /* nv=1/3 */,
  {    82,  8424,  7356,   6,   9, UNI_PALM }   /* block=palmyrene */,
  {    22,  6679,    36,  11,   1, UNI_SD }   /* softdotted=t */,
  {    15,  4826,     0,   9,   0, UNI_hex_values_index }   /* hexdigit= */,
  {     0,  9093,  8929,   4,   5, UNI_INOSAGE }   /* blk=osage */,
  {     2,  6885,  4827,   3,   7, UNI_XPOSIXXDIGIT }   /* ishexdigit */,
  {     8,  5339,   495,  14,   2, UNI_SB__NU }   /* sentencebreak=nu */,
  {     4,  8879,   879,   3,  13, UNI_PUA }   /* inprivateusearea */,
  {     1,  5760,  7636,  13,   8, UNI_NV__1_SLASH_20 }   /* numericvalue=5.00e-02 */,
  {     7,  8886,  2779,   3,   9, UNI_SC__MONG }   /* sc=mongolian */,
  {     1,  1977,     1,  22,   1, -UNI__PERL_NCHAR }   /* noncharactercodepoint=n */,
  {     5,  9113,  8909,   4,   5, UNI_CCC__7 }   /* ccc=nukta */,
  {     8,  4863,     0,  14,   0, UNI_CJKCOMPATFORMS }   /* cjkcompatforms */,
  {     0,  8424,  3110,   6,  18, UNI_GEORGIANSUP }   /* block=georgiansupplement */,
  {     0,  8886,  6988,   3,  10, UNI_SOGO }   /* sc=oldsogdian */,
  {     2,   184,  9221,   2,   4, UNI_LATN }   /* islatn */,
  {    45,  1362,  8358,  24,   2, UNI_CCC__30 }   /* canonicalcombiningclass=30 */,
  {     7,  6567,   831,   6,   6, UNI_MISCARROWS }   /* inmiscarrows */,
  {     1,  1136,     1,  26,   1, -UNI_DI }   /* defaultignorablecodepoint=n */,
  {    17,  9623,  9617,   3,   3, UNI_JG__GAF }   /* jg=gaf */,
  {     0,  9469,     0,   4,   0, UNI_XSUX }   /* xsux */,
  {     0,  8233,  8128,   7,   4, UNI_MAKA }   /* script=maka */,
  {     0,  7128,   108,  10,   2, UNI_WB__MB }   /* wordbreak=mb */,
  {     1,  7108,     3,  10,   1, -UNI_XPOSIXUPPER }   /* uppercase=f */,
  {     1,   184,   540,   3,  29, UNI_CJKEXTB }   /* iscjkunifiedideographsextensionb */,
  {     1,  5760,  8376,  13,   4, UNI_NV__5000 }   /* numericvalue=5000 */,
  {     4,  1362,  9524,  24,   3, UNI_CCC__L }   /* canonicalcombiningclass=224 */,
  {     3,  9365,  7844,   4,   8, UNI_GUJR }   /* scx=gujarati */,
  {    73,  8424,    78,   6,   6, UNI_INARABIC }   /* block=arabic */,
  {     0,  7230,    36,   9,   1, UNI_EXT }   /* extender=t */,
  {     9,  8424,  8107,   6,   7, UNI_INKANNADA }   /* block=kannada */,
  {    17,  6918,  9763,  10,   2, UNI_GCB__V }   /* linebreak=jv */,
  {    23,  9093,  2513,   4,  19, UNI_ANCIENTGREEKNUMBERS }   /* blk=ancientgreeknumbers */,
  {     1,  8424,  6591,   6,  11, UNI_MYANMAREXTB }   /* block=myanmarextb */,
  {     0,  8233,  8289,   7,   7, UNI_LANA }   /* script=taitham */,
  {     0,  9365,  4297,   4,   4, UNI_BRAI }   /* scx=brai */,
  {     0,  8886,  3038,   3,   8, UNI_ETHI }   /* sc=ethiopic */,
  {     3,  9647,  9747,   3,   2, UNI_NV__47 }   /* nv=47 */,
  {     0,  5760,  7764,  13,   8, UNI_NV__11_SLASH_12 }   /* numericvalue=9.17e-01 */,
  {     1,   184,  5500,   2,  13, UNI_ME }   /* isenclosingmark */,
  {     9,  9113,  8461,   5,   5, UNI_CCC__129 }   /* ccc=ccc129 */,
  {    14,  8580,     0,   7,   0, -UNI__PERL_NCHAR }   /* nchar=n */,
  {     0,  3671,  9045,  17,   4, UNI_ADLM }   /* scriptextensions=adlm */,
  {     2,  8412,    26,   6,   1, UNI_BIDIC }   /* bidic=y */,
  {     0,  9623,  6852,   3,   3, UNI_JG__KAF }   /* jg=kaf */,
  {    11,  5760,  7524,  13,   8, UNI_NV__1_SLASH_4 }   /* numericvalue=2.50e-01 */,
  {   129,  9113,  7603,   4,   2, UNI_CCC__24 }   /* ccc=24 */,
  {     0,  4361,  3112,   4,  16, UNI_GEORGIANSUP }   /* ingeorgiansupplement */,
  {     1,  3254,     0,  17,   0, UNI_RI }   /* regionalindicator */,
  {     1,  8886,  7956,   3,   4, UNI_SC__TAGB }   /* sc=tagb */,
  {     8,   184,    27,   2,   2, UNI_LOWERCASELETTER }   /* isll */,
  {     7,  2142,  8190,   3,   2, UNI_INNKO }   /* innko */,
  {     3,  5565,  8890,  14,   4, UNI_JG__KHAPH }   /* joininggroup=khaph */,
  {     0,  3951,  4493,   3,  14, UNI_ARMI }   /* isimperialaramaic */,
  {    11,  4821,     0,   5,   0, UNI_ASCII }   /* ascii */,
  {     2,  9777,     0,   2,   0, UNI_ZP }   /* zp */,
  {     0,  9909,  9921,   7,   5, UNI_POSIXPRINT }   /* isposixprint */,
  {     0,  2212,  3903,   5,  13, UNI_HALFANDFULLFORMS }   /* inhalfandfullforms */,
  {     1,  9113,  8439,   4,   3, UNI_CCC__103 }   /* ccc=103 */,
  {     2,   184,     1,   2,   1, UNI_N }   /* isn */,
  {     0,  5435,     0,  13,   0, UNI_bidim_values_index }   /* bidimirrored= */,
  {     0,  9593,    24,   3,   1, UNI_BC__L }   /* bc=l */,
  {     1,  9731,  4140,   3,   5, UNI_WB__XX }   /* wb=other */,
  {     2,  9903,   467,   6,   5, UNI_XPOSIXPUNCT }   /* xposixpunct */,
  {     6,  9097,  4687,   4,   4, UNI_BPT__O }   /* bpt=open */,
  {     3,   184,   988,   2,   5, UNI_MUSIC }   /* ismusic */,
  {     1,  9365,  9405,   4,   4, UNI_TALU }   /* scx=talu */,
  {     2,  8886,  5967,   3,   4, UNI_HEBR }   /* sc=hebr */,
  {     9,  8685,    26,   4,   1, UNI_XPOSIXXDIGIT }   /* hex=y */,
  {     8,  1362,  5138,  24,   2, UNI_CCC__7 }   /* canonicalcombiningclass=nk */,
  {     4,  9901,  3248,   8,   5, UNI_XPOSIXSPACE }   /* isxposixspace */,
  {     3,  8424,  2065,   7,  20, UNI_CJKRADICALSSUP }   /* block=cjkradicalssupplement */,
  {     0,  7128,  8156,  10,   7, UNI_WB__NL }   /* wordbreak=newline */,
  {     2,  7374,     0,   9,   0, UNI_SAMR }   /* samaritan */,
  {     5,  8424,    78,   6,  10, UNI_ARABICMATH }   /* block=arabicmath */,
  {    21,  9093,  3620,   4,  10, UNI_INMANICHAEAN }   /* blk=manichaean */,
  {     0,  9049,  9719,   4,   3, UNI_AGE__8 }   /* age=v80 */,
  {     0,  8886,  9105,   3,   4, UNI_SC__CAKM }   /* sc=cakm */,
  {     1,  1735,     1,  22,   1, -UNI_CWCM }   /* changeswhencasemapped=n */,
  {     3,  9093,  8254,   4,   7, UNI_INSIDDHAM }   /* blk=siddham */,
  {     9,  9093,   382,   4,  32, UNI_EGYPTIANHIEROGLYPHFORMATCONTROLS }   /* blk=egyptianhieroglyphformatcontrols */,
  {     0,  1924,  9768,  10,   1, UNI_CASEDLETTER }   /* category=l& */,
  {     5,  8233,  9053,   7,   4, UNI_AGHB }   /* script=aghb */,
  {     4,  1239,     1,  25,   1, -UNI_COMPEX }   /* fullcompositionexclusion=n */,
  {    14,   184,  9289,   2,   4, UNI_NSHU }   /* isnshu */,
  {     0,  6231,    11,  12,   2, UNI_NT__DI }   /* numerictype=di */,
  {     1,  1482,  3344,  24,  18, UNI_INPC__TOPANDLEFTANDRIGHT }   /* indicpositionalcategory=topandleftandright */,
  {    36,   184,  8002,   2,   7, UNI_BENG }   /* isbengali */,
  {     1,  9629,   836,   3,   2, UNI_LB__SP }   /* lb=sp */,
  {     0,  4849,     0,  13,   0, UNI_CI }   /* caseignorable */,
  {     2,  4989,     0,   6,   0, UNI_KANGXI }   /* kangxi */,
  {     8,  6828,  9632,  10,   3, UNI_BC__LRE }   /* bidiclass=lre */,
  {     1,  9909,  8599,   3,   4, UNI__PERL_PATWS }   /* ispatws */,
  {     4,  6194,  7330,   3,   8, UNI_INOLDITALIC }   /* inolditalic */,
  {     0,  8879,  2473,   5,  12, UNI_INPC__TOPANDBOTTOM }   /* inpc=topandbottom */,
  {     8,  3671,  9289,  17,   4, UNI_NSHU }   /* scriptextensions=nshu */,
  {     0,  3948,    67,   3,   4, UNI_VSSUP }   /* invssup */,
  {     2,  3671,  4205,  18,   5, UNI_SYRC }   /* scriptextensions=syriac */,
  {     0,  3248,  9782,   5,   4, UNI_XPOSIXSPACE }   /* spaceperl */,
  {     1,  9620,  5258,   3,  11, UNI_MC }   /* gc=spacingmark */,
  {     0,  8955,    36,   4,   1, UNI_IDC }   /* idc=t */,
  {     1,  3671,  9257,  17,   4, UNI_MLYM }   /* scriptextensions=mlym */,
  {     1,  8635,  9734,   5,   3, UNI_IDEO }   /* ideo=yes */,
  {     7,     7,     0,   1,   0, UNI_C }   /* c */,
  {    20,  2192,     0,   2,   0, UNI_PD }   /* pd */,
  {     1,  9731,  9773,   3,   2, UNI_WB__XX }   /* wb=xx */,
  {     1,  6828,    23,  10,   2, UNI_BC__AL }   /* bidiclass=al */,
  {     0,  8955,    26,   4,   1, UNI_IDC }   /* idc=y */,
  {     2,  9093,  5526,   4,   8, UNI_GREEKEXT }   /* blk=greekext */,
  {     0,  1757,    36,  22,   1, UNI_CWL }   /* changeswhenlowercased=t */,
  {    12,  8886,  7788,   3,   8, UNI_BALI }   /* sc=balinese */,
  {     6,  9049,  9563,   4,   3, UNI_AGE__5_DOT_1 }   /* age=5.1 */,
  {     2,  9285,     0,   4,   0, UNI_NKO }   /* nkoo */,
  {     0,  9093,   865,   4,  28, UNI_SUPPUAA }   /* blk=supplementaryprivateuseareaa */,
  {     1,   184,  8550,   2,   4, UNI_LEPC }   /* islepc */,
  {     0,  9605,  5678,   3,   4, UNI_DT__NONE }   /* dt=none */,
  {     0,  2708,  3758,   4,   7, UNI_ARABICSUP }   /* inarabicsup */,
  {     1,   184,  7203,   2,   9, UNI_BHKS }   /* isbhaiksuki */,
  {     0,  5760,  7462,  13,   2, UNI_NV__43 }   /* numericvalue=43 */,
  {     0,  8424,  7964,   6,   8, UNI_INTIFINAGH }   /* block=tifinagh */,
  {     0,   184,  9085,   2,   4, UNI_BATK }   /* isbatk */,
  {     9,  1243,  9734,  21,   3, UNI_CE }   /* compositionexclusion=yes */,
  {     5,  3868,   339,  16,   2, UNI_LO }   /* generalcategory=lo */,
  {     1,  9620,  5809,   3,   2, UNI_PF }   /* gc=pf */,
  {     0,  9137,     3,   4,   1, -UNI_DEP }   /* dep=f */,
  {     0,   184,  3772,   2,   4, UNI_BOPO }   /* isbopo */,
  {     1,  7329,     0,   9,   0, UNI_ITAL }   /* olditalic */,
  {    40,  4241,  3022,   4,   8, UNI_INDEVANAGARI }   /* indevanagari */,
  {     1,  9629,  9763,   3,   2, UNI_GCB__V }   /* lb=jv */,
  {     0,  9093,  6809,   5,   9, UNI_ASCII }   /* blk=basiclatin */,
  {     1,  3756,     0,  16,   0, UNI_ARABICSUP }   /* arabicsupplement */,
  {     0,  9365,  5967,   4,   4, UNI_HEBR }   /* scx=hebr */,
  {     9,  9093,  6279,   4,  12, UNI_PLAYINGCARDS }   /* blk=playingcards */,
  {     1,  8233,  6554,   8,   3, UNI_SAMR }   /* script=samr */,
  {     1,  5339,  6318,  15,   8, UNI_SB__SC }   /* sentencebreak=scontinue */,
  {     0,  8233,  8002,   7,   4, UNI_SC__BENG }   /* script=beng */,
  {     4,  8332,  2254,   3,  19, UNI_HLUW }   /* isanatolianhieroglyphs */,
  {     0,  6885,  4478,   3,  14, UNI_INHANGUL }   /* ishangulsyllables */,
  {     0,  9904,    62,   5,   5, UNI_POSIXGRAPH }   /* posixgraph */,
  {     0,    11,     0,   3,   0, UNI_DIA }   /* dia */,
  {    13,   184,   339,   2,   2, UNI_LO }   /* islo */,
  {     5,  9093,  6267,   4,   8, UNI_PHAISTOS }   /* blk=phaistos */,
  {     5,  9141,     1,   4,   1, -UNI_DIA }   /* dia=n */,
  {     0,  2204,  9302,   3,   3, UNI_ORKH }   /* isorkh */,
  {     3,   217,     0,  33,   0, UNI_DIACRITICALSEXT }   /* combiningdiacriticalmarksextended */,
  {     7,  3868,   467,  16,   5, UNI_P }   /* generalcategory=punct */,
  {     0,  8886,     7,   3,  18, UNI_CANS }   /* sc=canadianaboriginal */,
  {     0,  7128,  5520,  10,   5, UNI_WB__EB }   /* wordbreak=ebase */,
  {    18,  1497,  4080,   9,  10, UNI_SM }   /* category=mathsymbol */,
  {     0,  9217,     0,   3,   0, UNI_LAO }   /* lao */,
  {     0,  5760,  9580,  13,   2, UNI_NV__37 }   /* numericvalue=37 */,
  {     4,  8886,  3467,   3,  17, UNI_AGHB }   /* sc=caucasianalbanian */,
  {     3,   184,    17,   3,   1, UNI_CO }   /* isco */,
  {     3,  4849,     1,  14,   1, -UNI_CI }   /* caseignorable=n */,
  {     2,  6918,  2564,  10,   2, UNI_LB__BA }   /* linebreak=ba */,
  {    15,  8424,   690,   7,  29, UNI_CUNEIFORMNUMBERS }   /* block=cuneiformnumbersandpunctuation */,
  {     1,  8886,  4267,   3,   5, UNI_BAMU }   /* sc=bamum */,
  {     2,   184,  1802,   3,  20, UNI_CWU }   /* ischangeswhenuppercased */,
  {     6,  3671,  9069,  17,   4, UNI_ARMN }   /* scriptextensions=armn */,
  {     3,  8954,    26,   5,   1, UNI_XIDC }   /* xidc=y */,
  {     0,  2684,  7401,  19,   9, UNI_GCB__V }   /* hangulsyllabletype=voweljamo */,
  {    70,  9629,  8345,   3,   7, UNI_LB__ZW }   /* lb=zwspace */,
  {     1,  5760,  7159,  13,   8, UNI_NV__1_SLASH_2 }   /* numericvalue=5.00e-01 */,
  {     0,  6005,  8038,   3,   6, UNI_CJKEXTE }   /* incjkexte */,
  {     0,  6679,    26,  11,   1, UNI_SD }   /* softdotted=y */,
  {     3,  9093,     0,   4,   0, UNI_blk_values_index }   /* blk= */,
  {     0,  7932,  9433,   8,   4, UNI_RADICAL }   /* radical=true */,
  {     0,  8424,  4297,   6,   7, UNI_BRAI }   /* block=braille */,
  {     1,  9365,  9065,   4,   4, UNI_ARMI }   /* scx=armi */,
  {     0,  8233,  4492,   7,  15, UNI_ARMI }   /* script=imperialaramaic */,
  {     0,  8424,  9217,   6,   3, UNI_INLAO }   /* block=lao */,
  {     0,  2930,     0,  11,   0, UNI_CHEROKEESUP }   /* cherokeesup */,
  {     0,  8502,     0,   4,   0, UNI_GOTH }   /* goth */,
  {     1,  1362,  7571,  24,   2, UNI_CCC__33 }   /* canonicalcombiningclass=33 */,
  {     4,  8051,   995,   7,   2, -UNI_COMPEX }   /* compex=no */,
  {     4,  1362,  8479,  25,   5, UNI_WB__EB }   /* canonicalcombiningclass=ccc133 */,
  {     0,  9093,   976,   4,  27, UNI_ANCIENTGREEKMUSIC }   /* blk=ancientgreekmusicalnotation */,
  {     0,  1536,  5908,   3,  11, UNI_ETHIOPICEXTA }   /* inethiopicexta */,
  {     0,  3671,  8149,  17,   7, UNI_MULT }   /* scriptextensions=multani */,
  {    64,  8418,  8864,   6,   5, -UNI_BIDIM }   /* bidim=false */,
  {     0,  1482,  2373,  24,   4, UNI_INPC__LEFT }   /* indicpositionalcategory=left */,
  {     0,  8191,     0,   7,   0, UNI_OLCK }   /* olchiki */,
  {     1,  8324,     0,   7,   0, UNI_ZZZZ }   /* unknown */,
  {     0,  5339,   400,  14,   6, UNI_SB__FO }   /* sentencebreak=format */,
  {    17,  9629,  5773,   3,  13, UNI_LB__PR }   /* lb=prefixnumeric */,
  {     0,  9093,  3038,   4,  18, UNI_ETHIOPICSUP }   /* blk=ethiopicsupplement */,
  {     0,   184,   328,   2,  21, UNI_MATHOPERATORS }   /* ismathematicaloperators */,
  {     0,  5760,  8970,  13,   3, UNI_NV__1_SLASH_2 }   /* numericvalue=1/2 */,
  {     3,  4642,     1,  15,   1, UNI_NFKDQC__N }   /* nfkdquickcheck=n */,
  {     2,  9365,  5967,   4,   6, UNI_HEBR }   /* scx=hebrew */,
  {     5,  9113,  1149,   4,   2, UNI_CCC__BL }   /* ccc=bl */,
  {     8,  8233,  8652,   7,   6, UNI_WCHO }   /* script=wancho */,
  {    10,  3868,   206,  16,   2, UNI_PI }   /* generalcategory=pi */,
  {     0,  9605,  9149,   3,   4, UNI_DT__FONT }   /* dt=font */,
  {     5,  8233,  6243,   7,  12, UNI_HUNG }   /* script=oldhungarian */,
  {     0,  8233,  6898,   7,   4, UNI_KHAR }   /* script=khar */,
  {     2,  8424,  6580,   6,  11, UNI_MYANMAREXTA }   /* block=myanmarexta */,
  {    19,  8424,  4432,   6,  15, UNI_DIACRITICALSSUP }   /* block=diacriticalssup */,
  {    10,  9365,  9333,   4,   4, UNI_COPT }   /* scx=qaac */,
  {     0,  9093,  3110,   4,  11, UNI_GEORGIANSUP }   /* blk=georgiansup */,
  {     0,  9113,  5409,   4,   2, UNI_CCC__10 }   /* ccc=10 */,
  {     0,  6885,  8515,   3,   5, UNI_HATR }   /* ishatran */,
  {     0,   184,  9233,   2,   4, UNI_LISU }   /* islisu */,
  {     7,  3236,     0,  18,   0, UNI_patws_values_index }   /* patternwhitespace= */,
  {     1,  9313,  9433,   4,   4, UNI_PCM }   /* pcm=true */,
  {     9,  9365,  9161,   4,   4, UNI_GONM }   /* scx=gonm */,
  {     2,  9121,     3,   4,   1, -UNI_CWL }   /* cwl=f */,
  {     0,  1057,    26,  27,   1, UNI_PCM }   /* prependedconcatenationmark=y */,
  {     1,  8886,  9329,   3,   4, UNI_PRTI }   /* sc=prti */,
  {     5,  9620,   132,   3,   2, UNI_LM }   /* gc=lm */,
  {     0,   184,  6382,   2,   6, UNI_DOMINO }   /* isdomino */,
  {     0,  9049,  9005,   4,   4, UNI_AGE__12_DOT_1 }   /* age=12.1 */,
  {     0,  3671,  2333,  17,   4, UNI_GLAG }   /* scriptextensions=glag */,
  {     1,  3671,  4297,  17,   7, UNI_BRAI }   /* scriptextensions=braille */,
  {     0,  9113,  8782,   4,   2, UNI_CCC__27 }   /* ccc=27 */,
  {     8,  9647,  8376,   3,   3, UNI_NV__500 }   /* nv=500 */,
  {     1,  8869,     3,   5,   1, -UNI_IDSB }   /* idsb=f */,
  {     0,  2142,  8178,   3,   6, UNI_NB }   /* innoblock */,
  {    10,  9093,  6723,   4,  11, UNI_INSYLOTINAGRI }   /* blk=sylotinagri */,
  {     0,  9093,   217,   4,  33, UNI_DIACRITICALSEXT }   /* blk=combiningdiacriticalmarksextended */,
  {    13,  4762,     0,  15,   0, UNI_VEDICEXT }   /* vedicextensions */,
  {     0,  7008,     0,  10,   0, UNI_PHNX }   /* phoenician */,
  {     1,  8233,  8262,   8,   6, UNI_SOYO }   /* script=soyombo */,
  {     0,  9093,  2589,   4,  19, UNI_COUNTINGROD }   /* blk=countingrodnumerals */,
  {     0,  1136,     0,  25,   0, UNI_DI }   /* defaultignorablecodepoint */,
  {    13,  8886,  8205,   3,   4, UNI_OSMA }   /* sc=osma */,
  {     1,  9647,  8977,   3,   4, UNI_NV__1_SLASH_20 }   /* nv=1/20 */,
  {    22,  2333,     0,  20,   0, UNI_GLAGOLITICSUP }   /* glagoliticsupplement */,
  {     1,  9593,    25,   3,   1, UNI_BC__S }   /* bc=s */,
  {     8,  8051,  8864,   7,   5, -UNI_COMPEX }   /* compex=false */,
  {     5,  1845,     0,   6,   0, UNI_ZYYY }   /* common */,
  {     1,   478,     0,  31,   0, UNI_MATHALPHANUM }   /* mathematicalalphanumericsymbols */,
  {     3,  1362,  2733,  24,   2, UNI_CCC__1 }   /* canonicalcombiningclass=ov */,
  {     2,  5760,  7747,  13,   2, UNI_NV__28 }   /* numericvalue=28 */,
  {     2,  8424,  5578,   6,  13, UNI_KANAEXTA }   /* block=kanaextendeda */,
  {     0,  9605,  8574,   3,   6, UNI_DT__NAR }   /* dt=narrow */,
  {    36,  9093,  2874,   4,  19, UNI_SUPARROWSB }   /* blk=supplementalarrowsb */,
  {     0,  6183,     0,  12,   0, UNI_MEND }   /* mendekikakui */,
  {     0,  3671,  8079,  17,   7, UNI_GRAN }   /* scriptextensions=grantha */,
  {     0,  8685,    36,   4,   1, UNI_XPOSIXXDIGIT }   /* hex=t */,
  {     0,  1141,     0,   2,   0, UNI_TITLE }   /* lt */,
  {     0,  8233,  7956,   7,   8, UNI_SC__TAGB }   /* script=tagbanwa */,
  {     2,  8886,  9225,   3,   4, UNI_SC__LINA }   /* sc=lina */,
  {    12,  1497,  5259,  10,  10, UNI_MC }   /* category=spacingmark */,
  {     0,  9623,  6099,   3,  12, UNI_JG__MALAYALAMNNA }   /* jg=malayalamnna */,
  {    11,  8233,  7796,   7,   4, UNI_BASS }   /* script=bass */,
  {     1,  9093,  7892,   4,   8, UNI_INJAVANESE }   /* blk=javanese */,
  {    10,  7932,  8864,   8,   5, -UNI_RADICAL }   /* radical=false */,
  {     2,  9602,  9734,   3,   3, UNI_DI }   /* di=yes */,
  {     0,  9623,  6147,   3,  12, UNI_JG__MANICHAEANPE }   /* jg=manichaeanpe */,
  {     0,  9113,  7539,   4,   3, UNI_CCC__B }   /* ccc=220 */,
  {     1,  8424,  1889,   6,  22, UNI_EARLYDYNASTICCUNEIFORM }   /* block=earlydynasticcuneiform */,
  {     0,  3868,  2273,  16,  20, UNI_PC }   /* generalcategory=connectorpunctuation */,
  {    16,  8424,  3469,   8,  15, UNI_INCAUCASIANALBANIAN }   /* block=caucasianalbanian */,
  {     3,    21,  8107,   2,   7, UNI_INKANNADA }   /* inkannada */,
  {     0,  1482,     9,  24,   2, UNI_INPC__NA }   /* indicpositionalcategory=na */,
  {     0,   698,     0,   6,   0, UNI_N }   /* number */,
  {     0,  1924,    36,  10,   1, UNI_TITLE }   /* category=lt */,
  {     0,  5760,  8969,  13,   4, UNI_NV___MINUS_1_SLASH_2 }   /* numericvalue=-1/2 */,
  {     0,  9365,  2148,   4,  21, UNI_PRTI }   /* scx=inscriptionalparthian */,
  {     1,  5760,  9560,  13,   3, UNI_NV__4_SLASH_5 }   /* numericvalue=4/5 */,
  {    83,  3671,  9241,  17,   4, UNI_MEDF }   /* scriptextensions=medf */,
  {     0,  7980,     0,   8,   0, UNI_UGAR }   /* ugaritic */,
  {     0,  5565,  6795,  13,   3, UNI_JG__QAF }   /* joininggroup=qaf */,
  {     0,  9731,   495,   3,   2, UNI_WB__NU }   /* wb=nu */,
  {     0,  9365,  9273,   4,   4, UNI_NARB }   /* scx=narb */,
  {     2,  2106,  5394,  21,   2, UNI_LB__H2 }   /* graphemeclusterbreak=lv */,
  {     4,  2948,     0,  18,   0, UNI_HALFMARKS }   /* combininghalfmarks */,
  {     0,  8233,  6027,   7,   5, UNI_KHMR }   /* script=khmer */,
  {     4,  9623,  4537,   3,  15, UNI_JG__MANICHAEANGIMEL }   /* jg=manichaeangimel */,
  {     0,  9623,  9671,   3,   3, UNI_JG__TAH }   /* jg=tah */,
  {     0,  2211,     0,   4,   0, UNI_SINH }   /* sinh */,
  {     0,  7230,  8864,   9,   5, -UNI_EXT }   /* extender=false */,
  {     8,  1497,  9779,   9,   2, UNI_ZS }   /* category=zs */,
  {     0,  8886,  2930,   3,   8, UNI_CHER }   /* sc=cherokee */,
  {    10,  9049,  9566,   4,   3, UNI_AGE__5_DOT_2 }   /* age=5.2 */,
  {     0,  4807,     0,  14,   0, UNI_ANCIENTSYMBOLS }   /* ancientsymbols */,
  {     4,  9113,    23,   4,   2, UNI_CCC__AL }   /* ccc=al */,
  {     0,  9605,  6195,   3,   8, UNI_DT__NONCANON }   /* dt=noncanon */,
  {     5,  9093,  8009,   4,   7, UNI_CJKEXTA }   /* blk=cjkexta */,
  {     0,  6015,     0,  12,   1, UNI_JT__U }   /* joiningtype=u */,
  {     0,  9901,  4829,   3,   5, UNI_XPOSIXXDIGIT }   /* isxdigit */,
  {     2,  7018,  9581,  10,   3, UNI_IN__7 }   /* presentin=7.0 */,
  {     1,  8886,  8079,   3,   7, UNI_SC__GRAN }   /* sc=grantha */,
  {    26,  8317,     0,   7,   0, UNI_UCASEXT }   /* ucasext */,
  {    10,  8886,  4717,   3,   5, UNI_SC__TAML }   /* sc=tamil */,
  {    10,  1536,  7223,   4,   7, UNI_EMOTICONS }   /* inemoticons */,
  {     0,  3671,  8859,  17,   5, UNI_DOGR }   /* scriptextensions=dogra */,
  {     0,  9647,  8370,   3,   6, UNI_NV__432000 }   /* nv=432000 */,
  {     0,  8233,  8255,   8,   3, UNI_SIDD }   /* script=sidd */,
  {     6,  6194,  1031,   3,  26, UNI_OCR }   /* inopticalcharacterrecognition */,
  {     3,  9113,  8755,   5,   4, UNI_CCC__22 }   /* ccc=ccc22 */,
  {     0,  9629,  5991,   3,  12, UNI_LB__IS }   /* lb=infixnumeric */,
  {     8,  5513,     0,  12,   0, UNI_GRBASE }   /* graphemebase */,
  {     7,  6928,     1,  10,   1, -UNI_XPOSIXLOWER }   /* lowercase=n */,
  {     6,  8233,    78,   7,   4, UNI_SC__ARAB }   /* script=arab */,
  {     0,  7018,  7436,  10,   3, UNI_IN__1_DOT_1 }   /* presentin=1.1 */,
  {     6,   184,   921,   2,  17, UNI_VS }   /* isvariationselector */,
  {     1,  9647,  8354,   3,   2, UNI_NV__60 }   /* nv=60 */,
  {     1,  9479,  4795,   5,  12, UNI_INZANABAZARSQUARE }   /* inzanabazarsquare */,
  {     1,  3671,  9405,  17,   4, UNI_TALU }   /* scriptextensions=talu */,
  {     0,  9909,   472,   3,   2, UNI_PUA }   /* ispua */,
  {     0,  3951,  2354,   3,  19, UNI_PHLI }   /* isinscriptionalpahlavi */,
  {     0,  9365,  9197,   4,   4, UNI_KALI }   /* scx=kali */,
  {     0,  9605,   567,   3,   2, UNI_DT__NB }   /* dt=nb */,
  {     3,  8310,     0,   4,   0, UNI_TIRH }   /* tirh */,
  {     0,  1014,     0,   6,   0, UNI_L }   /* letter */,
  {    16,  3251,  8864,   3,   5, -UNI_CE }   /* ce=false */,
  {     0,    21,  8550,   2,   6, UNI_INLEPCHA }   /* inlepcha */,
  {     4,  1622,     0,  23,   0, UNI_LATINEXTADDITIONAL }   /* latinextendedadditional */,
  {     1,  8233,  9390,   8,   3, UNI_SOGO }   /* script=sogo */,
  {     3,  6918,   721,  10,   2, UNI_LB__CL }   /* linebreak=cl */,
  {     2,  9093,  4204,   4,  16, UNI_SYRIACSUP }   /* blk=syriacsupplement */,
  {     0,  9093,  3326,   4,  11, UNI_TAIXUANJING }   /* blk=taixuanjing */,
  {     1,  9129,   995,   4,   2, -UNI_CWU }   /* cwu=no */,
  {     0,  9365,  9457,   4,   4, UNI_WCHO }   /* scx=wcho */,
  {    11,  3951,  2704,   3,   3, UNI_IDST }   /* isidst */,
  {    65,  9623,  9369,   3,   4, UNI_JG__SEEN }   /* jg=seen */,
  {     1,  2148,   350,   3,  32, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* insupplementalsymbolsandpictographs */,
  {     0,  9093,  3836,   4,  16, UNI_CYPRIOTSYLLABARY }   /* blk=cypriotsyllabary */,
  {    40,  5565,  2551,  13,  19, UNI_JG__BURUSHASKIYEHBARREE }   /* joininggroup=burushaskiyehbarree */,
  {    36,  8424,  3416,   6,  10, UNI_ALCHEMICAL }   /* block=alchemical */,
  {    14,  8886,  9177,   3,   4, UNI_SC__HANO }   /* sc=hano */,
  {     1,  8959,     0,   5,   0, UNI_xids_values_index }   /* xids= */,
  {     8,  5565,  5718,  13,   3, UNI_JG__WAW }   /* joininggroup=waw */,
  {     1,  9620,     1,   3,   1, UNI_N }   /* gc=n */,
  {    11,  9731,  2368,   3,   2, UNI_LB__HL }   /* wb=hl */,
  {     0,  8424,   983,   6,   5, UNI_INGREEK }   /* block=greek */,
  {     1,  3020,     0,  18,   0, UNI_DEVANAGARIEXT }   /* devanagariextended */,
  {    10,  6918,   395,  10,   2, UNI_LB__GL }   /* linebreak=gl */,
  {     0,   184,  4582,   2,  15, UNI_MERC }   /* ismeroiticcursive */,
  {     2,  8424,  1188,   6,   8, UNI_INKATAKANA }   /* block=katakana */,
  {     0,  7796,     0,   4,   0, UNI_BASS }   /* bass */,
  {     3,  8886,  8289,   3,   7, UNI_LANA }   /* sc=taitham */,
  {    16,  9093,  4597,   4,  15, UNI_MISCPICTOGRAPHS }   /* blk=miscpictographs */,
  {     1,  4849,  9433,  14,   4, UNI_CI }   /* caseignorable=true */,
  {     0,  8871,  3227,   3,   3, UNI_SB__SE }   /* sb=sep */,
  {     6,  9365,  9057,   4,   4, UNI_AHOM }   /* scx=ahom */,
  {     3,  5760,  5409,  13,   5, UNI_NV__10000 }   /* numericvalue=10000 */,
  {     3,  6194,  8206,   3,   6, UNI_INOSMANYA }   /* inosmanya */,
  {     1,  1362,  7691,  24,   2, UNI_CCC__36 }   /* canonicalcombiningclass=36 */,
  {     0,  2353,     0,  20,   0, UNI_PHLI }   /* inscriptionalpahlavi */,
  {     0,  3552,     0,  11,   0, UNI_ETHIOPICEXT }   /* ethiopicext */,
  {     0,  3535,     0,  17,   0, UNI_CYRILLICEXTC }   /* cyrillicextendedc */,
  {     0,  8635,  8864,   5,   5, -UNI_IDEO }   /* ideo=false */,
  {     1,   509,     0,  30,   0, UNI_CJKEXTA }   /* cjkunifiedideographsextensiona */,
  {     0,   184,   837,   2,  28, UNI_PHONETICEXTSUP }   /* isphoneticextensionssupplement */,
  {     0,  3290,     0,  18,   0, UNI_RUMI }   /* ruminumeralsymbols */,
  {    17,  9365,  9473,   4,   4, UNI_YI }   /* scx=yiii */,
  {     0,  5760,  8669,  13,   3, UNI_NV__1_SLASH_3 }   /* numericvalue=1/3 */,
  {     0,  3868,  3820,  16,  16, UNI_PE }   /* generalcategory=closepunctuation */,
  {     2,   184,  7088,   2,  10, UNI_SUPARROWSC }   /* issuparrowsc */,
  {    14,  9193,    24,   4,   1, UNI_GCB__L }   /* hst=l */,
  {    17,  9093,  8562,   4,   6, UNI_INLYCIAN }   /* blk=lycian */,
  {     0,  3002,  9149,  18,   4, UNI_DT__FONT }   /* decompositiontype=font */,
  {    10,  9141,  8864,   4,   5, -UNI_DIA }   /* dia=false */,
  {    11,  9593,  3056,   3,  18, UNI_BC__ET }   /* bc=europeanterminator */,
  {     0,  7230,     1,   9,   1, -UNI_EXT }   /* extender=n */,
  {     2,  3671,  8065,  17,   4, UNI_ELBA }   /* scriptextensions=elba */,
  {     1,  9365,  8002,   4,   4, UNI_BENG }   /* scx=beng */,
  {     5,   184,  9130,   3,   2, UNI_CWU }   /* iscwu */,
  {     0,    21,  8526,   2,   6, UNI_INKAITHI }   /* inkaithi */,
  {     4,  9125,     1,   4,   1, -UNI_CWT }   /* cwt=n */,
  {     1,  3868,     7,  16,   1, UNI_C }   /* generalcategory=c */,
  {     8,   435,     0,   5,   0, UNI__PERL_NCHAR }   /* nchar */,
  {     5,  9129,     0,   3,   0, UNI_CWU }   /* cwu */,
  {     0,  8886,  9273,   3,   4, UNI_NARB }   /* sc=narb */,
  {     3,  9113,  8722,   4,   2, UNI_CCC__15 }   /* ccc=15 */,
  {     0,  3671,  1188,  17,   8, UNI_KANA }   /* scriptextensions=katakana */,
  {     0,  8233,  8296,   7,   7, UNI_TAVT }   /* script=taiviet */,
  {     1,  9093,  1867,   4,  22, UNI_DIACRITICALSFORSYMBOLS }   /* blk=diacriticalsforsymbols */,
  {     0,  8884,  2532,   5,  19, UNI_INSC__BRAHMIJOININGNUMBER }   /* insc=brahmijoiningnumber */,
  {     0,  9365,  6159,   4,  12, UNI_GONM }   /* scx=masaramgondi */,
  {     2,  9113,     0,   4,   0, UNI_ccc_values_index }   /* ccc= */,
  {     0,  1362,    23,  24,   2, UNI_CCC__AL }   /* canonicalcombiningclass=al */,
  {     0,  8086,     3,   7,   1, -UNI_GRBASE }   /* grbase=f */,
  {     2,  9781,  1129,  33,   5, UNI__PERL_PROBLEMATIC_LOCALE_FOLDEDS_START }   /* _perl_problematic_locale_foldeds_start */,
  {     0,  9141,    36,   4,   1, UNI_DIA }   /* dia=t */,
  {     0,  3254,     3,  18,   1, -UNI_RI }   /* regionalindicator=f */,
  {     5,  3002,  2204,  18,   3, UNI_DT__ISO }   /* decompositiontype=iso */,
  {     0,  9849,  9878,  15,   5, UNI__PERL_CHARNAME_BEGIN }   /* _perl_charname_begin */,
  {    11,  9113,  8455,   5,   4, UNI_CCC__12 }   /* ccc=ccc12 */,
  {     5,  9093,  3900,   4,  16, UNI_HALFANDFULLFORMS }   /* blk=halfandfullforms */,
  {     0,  9093,  7048,   4,  10, UNI_INSAURASHTRA }   /* blk=saurashtra */,
  {     0,  9629,  6349,   3,  11, UNI_LB__BB }   /* lb=breakbefore */,
  {     1,  3671,  7852,  17,   8, UNI_GURU }   /* scriptextensions=gurmukhi */,
  {     4,  3884,     0,  11,   0, UNI_GEORGIANEXT }   /* georgianext */,
  {     0,  9365,  8514,   4,   4, UNI_HATR }   /* scx=hatr */,
  {    68,   779,     0,  22,   0, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* enclosedideographicsup */,
  {    16,  4477,     0,  15,   0, UNI_INHANGUL }   /* hangulsyllables */,
  {     0,  9946,     7,   3,   1, UNI_SC }   /* issc */,
  {     0,  9093,  3996,   4,  16, UNI_LINEARBSYLLABARY }   /* blk=linearbsyllabary */,
  {     0,  9647,  8358,   3,   6, UNI_NV__300000 }   /* nv=300000 */,
  {    29,  9189,     0,   4,   0, UNI_HMNP }   /* hmnp */,
  {     2,  8233,    78,   7,   6, UNI_SC__ARAB }   /* script=arabic */,
  {     0,  2204,  4141,   3,   4, UNI_C }   /* isother */,
  {     4,  9629,    83,   3,   2, UNI_LB__CM }   /* lb=cm */,
  {     3,  1497,   341,   9,   2, UNI_PE }   /* category=pe */,
  {    22,  2703,     0,   3,   0, UNI_IDS }   /* ids */,
  {     0,  9946,  2453,   3,   4, UNI_STERM }   /* issterm */,
  {     0,  8233,  9105,   7,   4, UNI_SC__CAKM }   /* script=cakm */,
  {     2,   976,     0,  17,   0, UNI_ANCIENTGREEKMUSIC }   /* ancientgreekmusic */,
  {     0,  9093,  2855,   4,  19, UNI_SUPARROWSA }   /* blk=supplementalarrowsa */,
  {    58,  9153,  5520,   4,   5, UNI_WB__EB }   /* gcb=ebase */,
  {     2,  9049,  9707,   4,   3, UNI_AGE__6_DOT_1 }   /* age=v61 */,
  {     0,  9599,     0,   3,   0, UNI_ci_values_index }   /* ci= */,
  {     0,  8884,  2570,   5,  19, UNI_INSC__CONSONANTHEADLETTER }   /* insc=consonantheadletter */,
  {     4,  5979,   995,  12,   2, -UNI_IDEO }   /* ideographic=no */,
  {     2,  8233,  3110,   7,   8, UNI_SC__GEOR }   /* script=georgian */,
  {    19,   921,     0,  28,   0, UNI_VSSUP }   /* variationselectorssupplement */,
  {     3,   184,  6898,   2,  10, UNI_KHAR }   /* iskharoshthi */,
  {     4,  7128,     0,  10,   0, UNI_wb_values_index }   /* wordbreak= */,
  {     1,  5565,  5666,  13,   3, UNI_JG__NUN }   /* joininggroup=nun */,
  {    34,  8233,  6691,   8,  10, UNI_SORA }   /* script=sorasompeng */,
  {     7,  9365,  7980,   4,   4, UNI_UGAR }   /* scx=ugar */,
  {     2,   184,  1576,   2,  23, UNI_GEOMETRICSHAPESEXT }   /* isgeometricshapesextended */,
  {     3,  8233,  3038,   7,   8, UNI_ETHI }   /* script=ethiopic */,
  {     1,  9049,  7487,   4,   1, UNI_AGE__6 }   /* age=6 */,
  {     9,  9093,  7900,   4,   8, UNI_KANAEXTA }   /* blk=kanaexta */,
  {     1,  8538,     0,   4,   0, UNI_KHOJ }   /* khoj */,
  {     9,  9153,    36,   4,   1, UNI_GCB__T }   /* gcb=t */,
  {     1,   184,  5721,   2,  13, UNI_MAYANNUMERALS }   /* ismayannumerals */,
  {     3,  8424,  2627,   6,  19, UNI_ENCLOSEDALPHANUMSUP }   /* block=enclosedalphanumsup */,
  {    14,  2984,     0,   6,   0, UNI_COPT }   /* coptic */,
  {     0,  8617,  8864,   5,   5, -UNI_TERM }   /* term=false */,
  {     0,  6918,  5943,  10,   4, UNI_LB__GL }   /* linebreak=glue */,
  {     2,   184,  7302,   2,   9, UNI_NBAT }   /* isnabataean */,
  {     6,  8142,     0,   7,   0, UNI_MARC }   /* marchen */,
  {    52,  9365,  8262,   5,   6, UNI_SOYO }   /* scx=soyombo */,
  {     8,  9273,     0,   4,   0, UNI_NARB }   /* narb */,
  {     1,  9365,  8562,   4,   4, UNI_LYCI }   /* scx=lyci */,
  {     1,  6567,     0,  13,   0, UNI_MISCSYMBOLS }   /* inmiscsymbols */,
  {    12,  9093,  7058,   4,  10, UNI_SMALLFORMS }   /* blk=smallforms */,
  {     7,  3868,  5487,  16,  13, UNI_XPOSIXDIGIT }   /* generalcategory=decimalnumber */,
  {     0,  7772,     0,   8,   0, UNI_ARMN }   /* armenian */,
  {     0,  3248,   995,   6,   2, -UNI_XPOSIXSPACE }   /* space=no */,
  {     0,  9365,  9229,   4,   4, UNI_LINB }   /* scx=linb */,
  {     2,  4267,     0,  15,   0, UNI_BAMUMSUP }   /* bamumsupplement */,
  {     0,  9093,  8044,   4,   7, UNI_CJKEXTF }   /* blk=cjkextf */,
  {     0,  3671,  2212,  18,   6, UNI_SINH }   /* scriptextensions=sinhala */,
  {     5,  3671,  8303,  17,   7, UNI_TIBT }   /* scriptextensions=tibetan */,
  {     0,  1645,     0,  23,   0, UNI_SHORTHANDFORMATCONTROLS }   /* shorthandformatcontrols */,
  {    61,  1497,  9777,   9,   2, UNI_ZP }   /* category=zp */,
  {     0,  8886,  9133,   3,   4, UNI_SC__CYRL }   /* sc=cyrl */,
  {     2,  8406,     0,   6,   0, UNI_alpha_values_index }   /* alpha= */,
  {     1,  5199,     0,  14,   0, UNI_SK }   /* modifiersymbol */,
  {     0,  9365,  9221,   4,   4, UNI_LATN }   /* scx=latn */,
  {     2,  9093,  8710,   5,   4, UNI_INBUHID }   /* blk=buhid */,
  {     3,  9049,  9006,   4,   3, UNI_AGE__2_DOT_1 }   /* age=2.1 */,
  {     1,  1362,  8832,  24,   2, UNI_CCC__84 }   /* canonicalcombiningclass=84 */,
  {     0,  8233,  8072,   7,   7, UNI_ELYM }   /* script=elymaic */,
  {     1,  5565,  9245,  13,   4, UNI_JG__MEEM }   /* joininggroup=meem */,
  {     1,  3852,     0,  16,   0, UNI_PF }   /* finalpunctuation */,
  {     2,  8233,  3772,   7,   4, UNI_SC__BOPO }   /* script=bopo */,
  {     9,  9093,  3308,   4,  12, UNI_SMALLKANAEXT }   /* blk=smallkanaext */,
  {    40,  8424,  3552,   6,  16, UNI_ETHIOPICEXT }   /* block=ethiopicextended */,
  {     0,  9365,  9469,   4,   4, UNI_XSUX }   /* scx=xsux */,
  {     0,  5565,  3637,  13,  17, UNI_JG__MANICHAEANHUNDRED }   /* joininggroup=manichaeanhundred */,
  {     1,  9365,  8622,   4,   4, UNI_TELU }   /* scx=telu */,
  {     0,  9946,  2212,   3,   3, UNI_SINH }   /* issinh */,
  {     1,  9623,  4012,   3,  16, UNI_JG__MANICHAEANDALETH }   /* jg=manichaeandaleth */,
  {     1,  9237,  9433,   4,   4, UNI_LOE }   /* loe=true */,
  {     1,  9620,  9779,   3,   2, UNI_ZS }   /* gc=zs */,
  {    16,  8233,  9165,   7,   4, UNI_SC__GREK }   /* script=grek */,
  {     0,  5565,  7948,  13,   8, UNI_JG__SWASHKAF }   /* joininggroup=swashkaf */,
  {     0,  8884,  3788,   5,  16, UNI_INSC__CANTILLATIONMARK }   /* insc=cantillationmark */,
  {     3,   184,  9209,   2,   4, UNI_KTHI }   /* iskthi */,
  {     1,  9365,  7338,   4,   9, UNI_PERM }   /* scx=oldpermic */,
  {    17,  9647,  7540,   3,   6, UNI_NV__200000 }   /* nv=200000 */,
  {     6,  6316,  9734,  11,   3, UNI_IDC }   /* idcontinue=yes */,
  {     3,  2064,     0,  21,   0, UNI_CJKRADICALSSUP }   /* cjkradicalssupplement */,
  {     1,   184,  2006,   2,  15, UNI_MODIFIERLETTERS }   /* ismodifierletters */,
  {     2,  8424,  8282,   6,   7, UNI_INTAGALOG }   /* block=tagalog */,
  {     3,  9365,  2984,   4,   6, UNI_COPT }   /* scx=coptic */,
  {    44,  8886,  9333,   3,   4, UNI_SC__COPT }   /* sc=qaac */,
  {    17,  3243,  8864,  11,   5, -UNI_XPOSIXSPACE }   /* whitespace=false */,
  {     1,  6828,    24,  10,   1, UNI_BC__L }   /* bidiclass=l */,
  {     2,  6888,  9734,  10,   3, UNI_DIA }   /* diacritic=yes */,
  {     3,  8424,   382,   6,  32, UNI_EGYPTIANHIEROGLYPHFORMATCONTROLS }   /* block=egyptianhieroglyphformatcontrols */,
  {     2,  3248,    36,   6,   1, UNI_XPOSIXSPACE }   /* space=t */,
  {    22,  9093,  6591,   4,  11, UNI_MYANMAREXTB }   /* blk=myanmarextb */,
  {     1,  8424,    78,   6,  35, UNI_ARABICMATH }   /* block=arabicmathematicalalphabeticsymbols */,
  {     0,  9629,  5346,   3,   2, UNI_LB__EB }   /* lb=eb */,
  {     1,   328,     0,  21,   0, UNI_MATHOPERATORS }   /* mathematicaloperators */,
  {     0,  8002,     0,   7,   0, UNI_BENG }   /* bengali */,
  {     1,   184,  9213,   2,   4, UNI_LANA }   /* islana */,
  {     0,  8424,  3837,   7,  15, UNI_CYPRIOTSYLLABARY }   /* block=cypriotsyllabary */,
  {     1,  9093,  5422,   4,  13, UNI_AEGEANNUMBERS }   /* blk=aegeannumbers */,
  {    11,  9113,  3969,   4,   1, UNI_CCC__1 }   /* ccc=1 */,
  {     0,  7128,  4195,  10,   9, UNI_WB__EB }   /* wordbreak=emodifier */,
  {     1,  9153,  6525,   4,   3, UNI_LB__H3 }   /* gcb=lvt */,
  {     0,  3868,  1156,  16,   2, UNI_PO }   /* generalcategory=po */,
  {     1,    21,  6492,   2,  11, UNI_KATAKANAEXT }   /* inkatakanaext */,
  {     0,  9049,  9710,   4,   3, UNI_AGE__6_DOT_2 }   /* age=v62 */,
  {     0,   184,  1003,   2,  11, UNI_ENCLOSEDCJK }   /* isenclosedcjk */,
  {    19,  9365,  1482,   5,   3, UNI_SIND }   /* scx=sind */,
  {     0,  8884,  1214,   5,  25, UNI_INSC__CONSONANTINITIALPOSTFIXED }   /* insc=consonantinitialpostfixed */,
  {     1,  9365,  2930,   4,   8, UNI_CHER }   /* scx=cherokee */,
  {     0,  5565,  5185,  13,  14, UNI_JG__MANICHAEANYODH }   /* joininggroup=manichaeanyodh */,
  {     2,   184,  3218,   2,  18, UNI_ZP }   /* isparagraphseparator */,
  {     3,  8886,  5242,   5,   2, UNI_SC__KHOJ }   /* sc=khoj */,
  {     0,  3243,  9734,  11,   3, UNI_XPOSIXSPACE }   /* whitespace=yes */,
  {    27,  9093,  7088,   4,  10, UNI_SUPARROWSC }   /* blk=suparrowsc */,
  {    13,  9093,   689,   4,  16, UNI_CUNEIFORMNUMBERS }   /* blk=cuneiformnumbers */,
  {     3,  8424,  5955,   6,  12, UNI_INGUNJALAGONDI }   /* block=gunjalagondi */,
  {     0,  2064,     0,  14,   0, UNI_CJKRADICALSSUP }   /* cjkradicalssup */,
  {     0,  1618,     0,   4,   0, UNI_JAMO }   /* jamo */,
  {     4,  7876,     0,   8,   0, UNI_JAMOEXTA }   /* jamoexta */,
  {     0,   414,     0,  32,   0, UNI_INIDC }   /* ideographicdescriptioncharacters */,
  {     0,  9093,  6991,   4,   7, UNI_INSOGDIAN }   /* blk=sogdian */,
  {     6,  8424,  2874,   6,  19, UNI_SUPARROWSB }   /* block=supplementalarrowsb */,
  {     3,  8233,  6602,   7,   4, UNI_SC__NAND }   /* script=nand */,
  {     3,  6816,  8004,   4,   5, UNI_INBENGALI }   /* inbengali */,
  {     8,  2453,     0,  20,   0, UNI_term_values_index }   /* terminalpunctuation= */,
  {     3,   539,     0,  30,   0, UNI_CJKEXTB }   /* cjkunifiedideographsextensionb */,
  {     1,  3671,  6988,  17,  10, UNI_SOGO }   /* scriptextensions=oldsogdian */,
  {    17,  4297,     0,  15,   0, UNI_BRAI }   /* braillepatterns */,
  {     1,  7956,     0,   8,   0, UNI_TAGB }   /* tagbanwa */,
  {    13,  6918,     0,  10,   0, UNI_lb_values_index }   /* linebreak= */,
  {     0,  1779,     3,  22,   1, -UNI_CWT }   /* changeswhentitlecased=f */,
  {     4,  3671,  8514,  17,   4, UNI_HATR }   /* scriptextensions=hatr */,
  {     1,   184,  9169,   2,   4, UNI_GUJR }   /* isgujr */,
  {    11,  9153,  4140,   4,   5, UNI_GCB__XX }   /* gcb=other */,
  {     2,  7025,  9677,   3,   3, UNI_IN__2_DOT_1 }   /* in=v21 */,
  {     4,  9141,    26,   4,   1, UNI_DIA }   /* dia=y */,
  {     1,  6828,   426,  10,   2, UNI_BC__ES }   /* bidiclass=es */,
  {     2,  4402,     0,   4,   0, UNI_DASH }   /* dash */,
  {     0,   184,  4297,   2,   4, UNI_BRAI }   /* isbrai */,
  {     3,  3671,  2984,  17,   6, UNI_COPT }   /* scriptextensions=coptic */,
  {     1,  9647,  7708,   3,   8, UNI_NV__15_SLASH_2 }   /* nv=7.50e+00 */,
  {     2,  9113,  7659,   4,   2, UNI_CCC__16 }   /* ccc=16 */,
  {     1,  5565,  5643,  13,  13, UNI_JG__MANICHAEANMEM }   /* joininggroup=manichaeanmem */,
  {    18,  5760,  7572,  13,   8, UNI_NV__1_SLASH_3 }   /* numericvalue=3.33e-01 */,
  {     0,  8899,     3,   5,   1, -UNI_MATH }   /* math=f */,
  {     0,  8844,     0,   5,   0, UNI_cwcf_values_index }   /* cwcf= */,
  {    33,  8418,  9433,   6,   4, UNI_BIDIM }   /* bidim=true */,
  {     4,   184,  2590,   3,  18, UNI_COUNTINGROD }   /* iscountingrodnumerals */,
  {     9,  9093,  4108,   4,   7, UNI_INMYANMAR }   /* blk=myanmar */,
  {     5,  9365,  9157,   4,   4, UNI_GONG }   /* scx=gong */,
  {     1,  9193,  6503,   4,  11, UNI_GCB__L }   /* hst=leadingjamo */,
  {    18,   184,  1003,   2,  27, UNI_ENCLOSEDCJK }   /* isenclosedcjklettersandmonths */,
  {     0,  8886,  2532,   3,   6, UNI_BRAH }   /* sc=brahmi */,
  {   128,  9605,  2493,   3,   8, UNI_DT__VERT }   /* dt=vertical */,
  {     0,  8424,  1599,   6,  23, UNI_COMPATJAMO }   /* block=hangulcompatibilityjamo */,
  {    16,  9113,  8720,   5,   4, UNI_CCC__15 }   /* ccc=ccc15 */,
  {     3,  8424,  9285,   6,   3, UNI_INNKO }   /* block=nko */,
  {     0,  7048,     0,  10,   0, UNI_SAUR }   /* saurashtra */,
  {     0,  8233,  7995,   7,   7, UNI_AVST }   /* script=avestan */,
  {     1,   184,  8497,   3,   4, UNI_CWKCF }   /* iscwkcf */,
  {     0,  9093,  3164,   4,  18, UNI_LATINEXTADDITIONAL }   /* blk=latinextadditional */,
  {     0,  2142,  6604,   4,   9, UNI_INNANDINAGARI }   /* innandinagari */,
  {     6,  9093,   446,   4,  32, UNI_IDEOGRAPHICSYMBOLS }   /* blk=ideographicsymbolsandpunctuation */,
  {     4,  3671,  7203,  17,   9, UNI_BHKS }   /* scriptextensions=bhaiksuki */,
  {     3,  9093,  6798,   4,  10, UNI_ARABICEXTA }   /* blk=arabicexta */,
  {     8,  4642,  9734,  15,   3, UNI_DT__NONE }   /* nfkdquickcheck=yes */,
  {     2,  6231,   495,  12,   2, UNI_NT__NU }   /* numerictype=nu */,
  {     2,   184,  5258,   2,  11, UNI_MC }   /* isspacingmark */,
  {     0,  9093,    42,   4,   9, UNI_CJKCOMPAT }   /* blk=cjkcompat */,
  {     1,   184,  4388,   3,  13, UNI_SC }   /* iscurrencysymbol */,
  {     0,  6472,  3452,   4,  15, UNI_UCAS }   /* incanadiansyllabics */,
  {    17,  1497,  5809,   9,   2, UNI_PF }   /* category=pf */,
  {     4,  9365,  7788,   4,   4, UNI_BALI }   /* scx=bali */,
  {     1,  9385,     0,   4,   0, UNI_SHRD }   /* shrd */,
  {     0,  5760,  7539,  13,   2, UNI_NV__22 }   /* numericvalue=22 */,
  {     0,  9605,  3370,   3,   3, UNI_DT__MED }   /* dt=med */,
  {     0,  9049,  7159,   4,   1, UNI_AGE__5 }   /* age=5 */,
  {     8,   184,  2333,   2,  20, UNI_GLAGOLITICSUP }   /* isglagoliticsupplement */,
  {     0,  2148,   750,   3,  29, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* insymbolsandpictographsextendeda */,
  {     0,   184,  2333,   2,  10, UNI_GLAG }   /* isglagolitic */,
  {     1,  8684,  8864,   5,   5, -UNI_POSIXXDIGIT }   /* ahex=false */,
  {     1,  8634,     1,   6,   1, -UNI_UIDEO }   /* uideo=n */,
  {     0,   184,   133,   2,   4, UNI_M }   /* ismark */,
  {     0,  1622,     0,  14,   0, UNI_LATINEXTA }   /* latinextendeda */,
  {     5,  3671,  8262,  18,   6, UNI_SOYO }   /* scriptextensions=soyombo */,
  {     3,  7018,  5409,  10,   2, UNI_IN__10 }   /* presentin=10 */,
  {    16,  9093,  8177,   4,   7, UNI_NB }   /* blk=noblock */,
  {     0,  3739,  8864,  17,   5, -UNI_UIDEO }   /* unifiedideograph=false */,
  {   135,  3236,     0,  17,   0, UNI__PERL_PATWS }   /* patternwhitespace */,
  {     2,  3671,  4946,  17,   4, UNI_CHAM }   /* scriptextensions=cham */,
  {     1,  9731,  4195,   3,   9, UNI_WB__EB }   /* wb=emodifier */,
  {     1,  8233,  8568,   7,   6, UNI_LYDI }   /* script=lydian */,
  {     0,  4580,  2007,   3,  14, UNI_MODIFIERLETTERS }   /* inmodifierletters */,
  {     3,  8233,  8934,   7,   5, UNI_RUNR }   /* script=runic */,
  {     0,  8261,     0,   4,   0, UNI_SOYO }   /* soyo */,
  {     2,   148,     0,  35,   0, UNI_DIACRITICALSSUP }   /* combiningdiacriticalmarkssupplement */,
  {     0,  9629,    25,   3,   2, UNI_LB__SY }   /* lb=sy */,
  {     0,  9365,  7916,   4,   8, UNI_MAHJ }   /* scx=mahajani */,
  {     0,  8233,  8324,   7,   7, UNI_ZZZZ }   /* script=unknown */,
  {    23,  1084,  9734,  26,   3, UNI_CWKCF }   /* changeswhennfkccasefolded=yes */,
  {     4,  8871,   138,   3,   2, UNI_SB__FO }   /* sb=fo */,
  {    18,  2148,  5368,   3,  13, UNI_SUPPUNCTUATION }   /* insuppunctuation */,
  {     0,  9121,  9734,   4,   3, UNI_CWL }   /* cwl=yes */,
  {     2,   184,  6723,   2,  11, UNI_SYLO }   /* issylotinagri */,
  {    19,  8879,  7366,   3,   8, UNI_INPAUCINHAU }   /* inpaucinhau */,
  {     9,  9229,     0,   4,   0, UNI_LINB }   /* linb */,
  {     1,  7025,  8997,   3,   4, UNI_IN__11 }   /* in=11.0 */,
  {     0,  6918,  3804,  10,  16, UNI_LB__CP }   /* linebreak=closeparenthesis */,
  {     6,  3951,  3129,   3,  16, UNI_IDSB }   /* isidsbinaryoperator */,
  {     2,  9049,  9692,   4,   3, UNI_AGE__4_DOT_1 }   /* age=v41 */,
  {     3,  9620,    47,   3,   1, UNI_M }   /* gc=m */,
  {     0,  9383,  8249,   4,   5, UNI_SHAW }   /* inshavian */,
  {     1,   184,  8562,   2,   4, UNI_LYCI }   /* islyci */,
  {     0,  8871,   125,   3,   2, UNI_LB__CR }   /* sb=cr */,
  {     1,  8886,  8892,   3,   4, UNI_PHLI }   /* sc=phli */,
  {     0,  8871,    69,   3,   2, UNI_SB__UP }   /* sb=up */,
  {     5,  8338,  9734,   7,   3, UNI_XPOSIXSPACE }   /* wspace=yes */,
  {     3,  3671,  8944,  17,   5, UNI_TAKR }   /* scriptextensions=takri */,
  {     0,   689,     0,  30,   0, UNI_CUNEIFORMNUMBERS }   /* cuneiformnumbersandpunctuation */,
  {     0,  6015,  6745,  12,  11, UNI_JT__T }   /* joiningtype=transparent */,
  {     1,  8424,  4961,   6,  14, UNI_HIGHSURROGATES }   /* block=highsurrogates */,
  {     0,  9605,  4801,   3,   6, UNI_DT__SQR }   /* dt=square */,
  {     8,  3020,     0,  13,   0, UNI_DEVANAGARIEXT }   /* devanagariext */,
  {     2,  8086,  9433,   7,   4, UNI_GRBASE }   /* grbase=true */,
  {    11,  1158,  8283,   3,   6, UNI_INTAGALOG }   /* intagalog */,
  {     0,  3868,    38,  16,   2, UNI_XPOSIXDIGIT }   /* generalcategory=nd */,
  {     2,  8424,  5884,   7,  11, UNI_CYRILLICEXTB }   /* block=cyrillicextb */,
  {   130,  8886,  1573,   3,   4, UNI_SC__PHAG }   /* sc=phag */,
  {     3,  9647,  9737,   3,   2, UNI_NV__38 }   /* nv=38 */,
  {     2,  1536,  8066,   3,   6, UNI_INELBASAN }   /* inelbasan */,
  {     3,  8886,  9325,   3,   4, UNI_MIAO }   /* sc=plrd */,
  {     4,  2204,  2799,   3,  18, UNI_OTTOMANSIYAQNUMBERS }   /* isottomansiyaqnumbers */,
  {     0,  9113,  8371,   4,   2, UNI_CCC__32 }   /* ccc=32 */,
  {     2,  1977,  9734,  22,   3, UNI__PERL_NCHAR }   /* noncharactercodepoint=yes */,
  {     2,  2204,  8193,   4,   5, UNI_OLCK }   /* isolchiki */,
  {     0,   689,     0,   9,   0, UNI_XSUX }   /* cuneiform */,
  {     6,  5565,  5381,  13,  14, UNI_JG__HAMZAONHEHGOAL }   /* joininggroup=tehmarbutagoal */,
  {     4,  8424,  2169,   6,  11, UNI_INMEETEIMAYEK }   /* block=meeteimayek */,
  {     3,  4580,  8150,   3,   6, UNI_INMULTANI }   /* inmultani */,
  {     0,  9093,  2148,   4,  21, UNI_ININSCRIPTIONALPARTHIAN }   /* blk=inscriptionalparthian */,
  {     0,  7018,  9575,  10,   3, UNI_IN__6_DOT_1 }   /* presentin=6.1 */,
  {     2,  3251,  9433,   3,   4, UNI_CE }   /* ce=true */,
  {     9,  9093,    42,   4,   3, UNI_CJK }   /* blk=cjk */,
  {     0,  9602,   995,   3,   2, -UNI_DI }   /* di=no */,
  {     0,  5339,    69,  14,   2, UNI_SB__UP }   /* sentencebreak=up */,
  {     2,  9365,  7892,   4,   4, UNI_JAVA }   /* scx=java */,
  {     0,  9093,  2169,   4,  11, UNI_INMEETEIMAYEK }   /* blk=meeteimayek */,
  {     0,  9265,     0,   4,   0, UNI_MTEI }   /* mtei */,
  {     0,  8886,  8914,   3,   5, UNI_NSHU }   /* sc=nushu */,
  {    23,  9731,  7988,   3,   7, UNI_WB__LE }   /* wb=aletter */,
  {     0,  9365,  7365,   4,   4, UNI_PAUC }   /* scx=pauc */,
  {     0,  8424,   183,   6,  34, UNI_MISCPICTOGRAPHS }   /* block=miscellaneoussymbolsandpictographs */,
  {     0,  6828,  9644,  10,   3, UNI_BC__NSM }   /* bidiclass=nsm */,
  {     4,  3739,     1,  17,   1, -UNI_UIDEO }   /* unifiedideograph=n */,
  {     0,  9373,     0,   4,   0, UNI_SGNW }   /* sgnw */,
  {     1,   184,  3964,   2,   6, UNI_LATIN1 }   /* islatin1 */,
  {    74,   250,     0,  33,   0, UNI_MISCMATHSYMBOLSA }   /* miscellaneousmathematicalsymbolsa */,
  {     1,  8233,  7118,   7,   4, UNI_WARA }   /* script=wara */,
  {     1,   406,     0,   7,   0, UNI_XPOSIXCNTRL }   /* control */,
  {    10,  9629,  5952,   3,   2, UNI_LB__ZW }   /* lb=zw */,
  {     0,  4361,  3112,   4,   9, UNI_GEORGIANSUP }   /* ingeorgiansup */,
  {     0,  8871,   721,   3,   5, UNI_SB__CL }   /* sb=close */,
  {     3,  1084,  8864,  26,   5, -UNI_CWKCF }   /* changeswhennfkccasefolded=false */,
  {     1,  1362,  8461,  25,   5, UNI_CCC__129 }   /* canonicalcombiningclass=ccc129 */,
  {     1,  9623,  5115,   3,  14, UNI_JG__MANICHAEANHETH }   /* jg=manichaeanheth */,
  {     1,  9647,  8400,   3,   5, UNI_NV__90000 }   /* nv=90000 */,
  {     5,    78,     0,  10,   0, UNI_ARABICMATH }   /* arabicmath */,
  {     5,  7932,     1,   8,   1, -UNI_RADICAL }   /* radical=n */,
  {     1,  8424,  8532,   6,   6, UNI_KANBUN }   /* block=kanbun */,
  {     0,  8424,  9453,   6,   3, UNI_INVAI }   /* block=vai */,
  {    17,  8233,  9265,   7,   4, UNI_MTEI }   /* script=mtei */,
  {     5,  8310,     0,   7,   0, UNI_TIRH }   /* tirhuta */,
  {     0,  8508,  9433,   6,   4, UNI_GREXT }   /* grext=true */,
  {     2,  8424,  7876,   6,   8, UNI_JAMOEXTA }   /* block=jamoexta */,
  {     0,  8954,  8864,   5,   5, -UNI_XIDC }   /* xidc=false */,
  {     0,  8424,  8114,   6,   7, UNI_KALI }   /* block=kayahli */,
  {     4,  5367,     0,  14,   0, UNI_SUPPUNCTUATION }   /* suppunctuation */,
  {    30,  9093,   250,   4,  33, UNI_MISCMATHSYMBOLSA }   /* blk=miscellaneousmathematicalsymbolsa */,
  {     0,  5760,  9029,  13,   4, UNI_NV__3_SLASH_64 }   /* numericvalue=3/64 */,
  {    18,  6885,  5968,   3,   5, UNI_HEBR }   /* ishebrew */,
  {     4,  3671,  3729,  18,  10, UNI_SGNW }   /* scriptextensions=signwriting */,
  {    12,  1497,   598,   9,   2, UNI_XPOSIXCNTRL }   /* category=cc */,
  {     0,  9093,  4204,   4,   9, UNI_SYRIACSUP }   /* blk=syriacsup */,
  {    16,  8886,  8065,   3,   4, UNI_ELBA }   /* sc=elba */,
  {     0,  9629,  1472,   3,   9, UNI_LB__SG }   /* lb=surrogate */,
  {     3,  3398,  8864,  18,   5, -UNI_VS }   /* variationselector=false */,
  {     0,  7118,     0,  10,   0, UNI_WARA }   /* warangciti */,
  {     2,  1029,     0,   2,   0, UNI_SO }   /* so */,
  {     4,  2148,  6724,   3,  10, UNI_INSYLOTINAGRI }   /* insylotinagri */,
  {     0,  8879,   472,   3,   2, UNI_PUA }   /* inpua */,
  {     1,  5760,  7612,  13,   8, UNI_NV__5_SLASH_12 }   /* numericvalue=4.17e-01 */,
  {    23,  5760,  9497,  13,   3, UNI_NV__1_SLASH_5 }   /* numericvalue=1/5 */,
  {     1,  3868,   112,  16,   2, UNI_SC }   /* generalcategory=sc */,
  {     0,  8886,  7329,   3,   9, UNI_ITAL }   /* sc=olditalic */,
  {    50,  8886,  9465,   3,   4, UNI_XPEO }   /* sc=xpeo */,
  {     0,  5565,  5936,  13,   7, UNI_JG__SEMKATH }   /* joininggroup=semkath */,
  {    12,  8886,  4220,   3,   4, UNI_TANG }   /* sc=tang */,
  {     0,  3671,  9165,  17,   4, UNI_GREK }   /* scriptextensions=grek */,
  {     1,  9049,  9674,   4,   3, UNI_AGE__2 }   /* age=v20 */,
  {     9,  3671,  8310,  17,   7, UNI_TIRH }   /* scriptextensions=tirhuta */,
  {    34,  9193,  6525,   4,  11, UNI_LB__H3 }   /* hst=lvtsyllable */,
  {     0,  5760,  7502,  13,   1, UNI_NV__8 }   /* numericvalue=8 */,
  {     8,  6768,     2,   3,   1, UNI_YI }   /* isyi */,
  {     1,  9093,  2211,   4,  21, UNI_SINHALAARCHAICNUMBERS }   /* blk=sinhalaarchaicnumbers */,
  {     0,  8424,  1576,   6,  18, UNI_GEOMETRICSHAPESEXT }   /* block=geometricshapesext */,
  {     4,  5760,  7468,  13,   8, UNI_NV__3_SLASH_2 }   /* numericvalue=1.50e+00 */,
  {    10,  8100,  9734,   7,   3, UNI_HYPHEN }   /* hyphen=yes */,
  {     0,    21,  8934,   2,   5, UNI_INRUNIC }   /* inrunic */,
  {     0,  3671,  8135,  17,   7, UNI_MAND }   /* scriptextensions=mandaic */,
  {     9,  8874,     1,   5,   1, -UNI_IDST }   /* idst=n */,
  {     2,  8955,  9433,   4,   4, UNI_IDC }   /* idc=true */,
  {     4,  1933,     3,  22,   1, -UNI_LOE }   /* logicalorderexception=f */,
  {     1,  9728,  8864,   3,   5, -UNI_VS }   /* vs=false */,
  {     1,  1497,  1474,  11,   7, UNI__PERL_SURROGATE }   /* category=surrogate */,
  {     1,   184,   698,   2,   6, UNI_N }   /* isnumber */,
  {     1,  1599,     0,   6,   0, UNI_HANG }   /* hangul */,
  {     0,  5565,  4954,  13,   7, UNI_JG__HEHGOAL }   /* joininggroup=hehgoal */,
  {     0,  9620,  1141,   3,   2, UNI_TITLE }   /* gc=lt */,
  {     0,  6231,  4829,  12,   5, UNI_NT__DI }   /* numerictype=digit */,
  {    35,  8684,    36,   5,   1, UNI_POSIXXDIGIT }   /* ahex=t */,
  {     0,  6315,  9734,  12,   3, UNI_XIDC }   /* xidcontinue=yes */,
  {     0,  3671,  9161,  17,   4, UNI_GONM }   /* scriptextensions=gonm */,
  {     3,   184,  2741,   2,   4, UNI_MERO }   /* ismero */,
  {     0,  5760,  7540,  13,   4, UNI_NV__2000 }   /* numericvalue=2000 */,
  {    57,  9593,  2013,   3,   3, UNI_BC__RLE }   /* bc=rle */,
  {    32,  9365,  7375,   5,   8, UNI_SAMR }   /* scx=samaritan */,
  {    19,  9620,    48,   3,   1, UNI_P }   /* gc=p */,
  {     5,  8233,  2984,   7,   6, UNI_SC__COPT }   /* script=coptic */,
  {     0,  1482,  6998,  24,  10, UNI_INPC__OVERSTRUCK }   /* indicpositionalcategory=overstruck */,
  {     0,  8424,  4252,   6,  15, UNI_ARABICEXTA }   /* block=arabicextendeda */,
  {     4,  8424,  7088,   6,  10, UNI_SUPARROWSC }   /* block=suparrowsc */,
  {    20,  7025,  9578,   3,   3, UNI_IN__6_DOT_3 }   /* in=6.3 */,
  {     8,  9313,  8864,   4,   5, -UNI_PCM }   /* pcm=false */,
  {     3,  8617,     0,   6,   0, UNI_TERM }   /* term=t */,
  {    12,  9731,  4801,   3,   2, UNI_WB__SQ }   /* wb=sq */,
  {     0,  9623,  3637,   3,  17, UNI_JG__MANICHAEANHUNDRED }   /* jg=manichaeanhundred */,
  {     4,  9365,  8628,   4,   4, UNI_THAA }   /* scx=thaa */,
  {     0,  2703,     3,  19,   1, -UNI_IDST }   /* idstrinaryoperator=f */,
  {     0,  5760,  8782,  13,   2, UNI_NV__27 }   /* numericvalue=27 */,
  {     0,  5435,     0,  12,   0, UNI_BIDIM }   /* bidimirrored */,
  {    49,  8886,  7860,   3,   8, UNI_SC__HIRA }   /* sc=hiragana */,
  {     0,  8424,  2021,   6,  15, UNI_TRANSPORTANDMAP }   /* block=transportandmap */,
  {     0,  4447,     9,  15,   2, UNI_EA__NA }   /* eastasianwidth=na */,
  {     0,  6005,  1824,   3,  18, UNI_CJKCOMPATIDEOGRAPHS }   /* incjkcompatideographs */,
  {     1,    38,     0,   2,   0, UNI_XPOSIXDIGIT }   /* nd */,
  {     0,  8332,   950,   3,  26, UNI_ALPHABETICPF }   /* isalphabeticpresentationforms */,
  {     4,  8424,  8072,   6,   7, UNI_INELYMAIC }   /* block=elymaic */,
  {     0,  5760,  9554,  13,   3, UNI_NV__3_SLASH_4 }   /* numericvalue=3/4 */,
  {     0,  9909,  9922,   3,   4, UNI_XPOSIXPRINT }   /* isprint */,
  {     1,  5565,     3,  15,   1, UNI_JG__KAF }   /* joininggroup=kaf */,
  {     1,  9623,  5139,   3,   4, UNI_JG__KAPH }   /* jg=kaph */,
  {     0,  6918,  5297,  10,  14, UNI_LB__PO }   /* linebreak=postfixnumeric */,
  {     8,  9365,  4108,   4,   7, UNI_MYMR }   /* scx=myanmar */,
  {     0,  3671,  7916,  17,   8, UNI_MAHJ }   /* scriptextensions=mahajani */,
  {     4,  8233,  3110,   7,   4, UNI_SC__GEOR }   /* script=geor */,
  {     2,  2836,     0,  12,   0, UNI_SUNDANESESUP }   /* sundanesesup */,
  {     2,  9237,    36,   4,   1, UNI_LOE }   /* loe=t */,
  {     5,  9093,   837,   4,  18, UNI_PHONETICEXT }   /* blk=phoneticextensions */,
  {     5,  9093,  4477,   4,  15, UNI_INHANGUL }   /* blk=hangulsyllables */,
  {     4,  9365,  2353,   4,  20, UNI_PHLI }   /* scx=inscriptionalpahlavi */,
  {     0,  3671,  2127,  17,  14, UNI_ROHG }   /* scriptextensions=hanifirohingya */,
  {    36,  9901,  4828,   8,   6, UNI_XPOSIXXDIGIT }   /* isxposixxdigit */,
  {     0,  9093,  3964,   4,   9, UNI_LATIN1 }   /* blk=latin1sup */,
  {     0,  8886,  8709,   3,   5, UNI_SC__BUHD }   /* sc=buhid */,
  {     1,  8886,  8296,   3,   7, UNI_TAVT }   /* sc=taiviet */,
  {     0,   184,  3536,   3,  16, UNI_CYRILLICEXTC }   /* iscyrillicextendedc */,
  {     7,   184,  7230,   2,   8, UNI_EXT }   /* isextender */,
  {     0,  9647,  7540,   3,   5, UNI_NV__20000 }   /* nv=20000 */,
  {     2,  1362,  9765,  24,   2, UNI_CCC__8 }   /* canonicalcombiningclass=kv */,
  {     2,   184,  5896,   3,  11, UNI_CYRILLICEXTC }   /* iscyrillicextc */,
  {     8,  9365,  2984,   4,   4, UNI_COPT }   /* scx=copt */,
  {    12,  8424,  3452,   8,  15, UNI_UCAS }   /* block=canadiansyllabics */,
  {     8,  8954,   995,   5,   2, -UNI_XIDC }   /* xidc=no */,
  {     0,  1085,     0,   4,   0, UNI_HANG }   /* hang */,
  {    11,   117,  2355,   4,  18, UNI_ININSCRIPTIONALPAHLAVI }   /* ininscriptionalpahlavi */,
  {    18,  1243,     3,  21,   1, -UNI_CE }   /* compositionexclusion=f */,
  {     0,  6828,  9614,  10,   3, UNI_BC__FSI }   /* bidiclass=fsi */,
  {     1,  9093,  1622,   4,   9, UNI_LATINEXTE }   /* blk=latinexte */,
  {    17,  8424,  8149,   6,   7, UNI_INMULTANI }   /* block=multani */,
  {     6,  8233,  9221,   7,   4, UNI_SC__LATN }   /* script=latn */,
  {     0,  3671,  3836,  17,   7, UNI_CPRT }   /* scriptextensions=cypriot */,
  {     2,  3671,  9197,  17,   4, UNI_KALI }   /* scriptextensions=kali */,
  {     0,  3772,     0,   8,   0, UNI_BOPO }   /* bopomofo */,
  {     5,  8886,  6555,   5,   2, UNI_KHMR }   /* sc=khmr */,
  {     0,  9626,     0,   3,   1, UNI_JT__U }   /* jt=u */,
  {     1,  8884,  5474,   5,  13, UNI_INSC__CONSONANTDEAD }   /* insc=consonantdead */,
  {     1,  6613,     0,  11,   0, UNI_LO }   /* otherletter */,
  {     8,  3951,  3587,   3,  16, UNI_INDICSIYAQNUMBERS }   /* isindicsiyaqnumbers */,
  {     0,  6015,    24,  12,   1, UNI_JT__L }   /* joiningtype=l */,
  {     0,  8100,     0,   7,   0, UNI_hyphen_values_index }   /* hyphen= */,
  {     0,  6003,  9433,  12,   4, UNI_JOINC }   /* joincontrol=true */,
  {     1,  8002,     0,   4,   0, UNI_BENG }   /* beng */,
  {     1,  9093,  2798,   4,  19, UNI_OTTOMANSIYAQNUMBERS }   /* blk=ottomansiyaqnumbers */,
  {     2,  9725,    18,   3,   1, UNI_VO__R }   /* vo=r */,
  {     4,  9313,     0,   4,   0, UNI_pcm_values_index }   /* pcm= */,
  {     1,  3671,  9261,  17,   3, UNI_MRO }   /* scriptextensions=mro */,
  {     0,  8233,  9453,   7,   4, UNI_VAI }   /* script=vaii */,
  {    19,  9608,     0,   3,   0, UNI_ea_values_index }   /* ea= */,
  {     0,  9093,  5721,   4,  13, UNI_MAYANNUMERALS }   /* blk=mayannumerals */,
  {     8,  9605,  8490,   3,   6, UNI_DT__ENC }   /* dt=circle */,
  {     0,   719,     0,  16,   0, UNI_ENCLOSEDALPHANUM }   /* enclosedalphanum */,
  {     0,  9093,  8128,   4,   7, UNI_INMAKASAR }   /* blk=makasar */,
  {     0,  8233,  9145,   7,   4, UNI_DSRT }   /* script=dsrt */,
  {     0,  9629,  5967,   3,  12, UNI_LB__HL }   /* lb=hebrewletter */,
  {     4,  8886,  3772,   3,   4, UNI_SC__BOPO }   /* sc=bopo */,
  {    10,  9365,  7772,   4,   8, UNI_ARMN }   /* scx=armenian */,
  {     1,  7230,  9734,   9,   3, UNI_EXT }   /* extender=yes */,
  {     2,  3671,  8919,  17,   5, UNI_OGAM }   /* scriptextensions=ogham */,
  {    32,  8849,     1,   5,   1, -UNI_CWCM }   /* cwcm=n */,
  {     0,  6885,  6247,   3,   3, UNI_HUNG }   /* ishung */,
  {     0,   184,   921,   2,  18, UNI_INVS }   /* isvariationselectors */,
  {     1,    21,  4975,   2,  14, UNI_KANASUP }   /* inkanasupplement */,
  {     1,  5760,  7588,  13,   8, UNI_NV__3_SLASH_8 }   /* numericvalue=3.75e-01 */,
  {     1,  8233,   983,   7,   5, UNI_SC__GREK }   /* script=greek */,
  {     3,  5760,  7620,  13,   8, UNI_NV__9_SLASH_2 }   /* numericvalue=4.50e+00 */,
  {    34,  2006,     0,  14,   0, UNI_LM }   /* modifierletter */,
  {     0,   184,  3092,   2,  18, UNI_INPUNCTUATION }   /* isgeneralpunctuation */,
  {     0,  6570,     0,   4,   0, UNI__PERL_SURROGATE }   /* iscs */,
  {     0,  8886,  8226,   3,   7, UNI_SC__PHAG }   /* sc=phagspa */,
  {     0,  7128,  6415,  10,  11, UNI_WB__DQ }   /* wordbreak=doublequote */,
  {     0,  8233,  1188,   7,   8, UNI_SC__KANA }   /* script=katakana */,
  {    32,  9629,  5059,   3,  14, UNI_LB__BK }   /* lb=mandatorybreak */,
  {     4,  9093,   183,   4,  34, UNI_MISCPICTOGRAPHS }   /* blk=miscellaneoussymbolsandpictographs */,
  {     5,  9629,    34,   3,   2, UNI_LB__EX }   /* lb=ex */,
  {    74,  8886,  9417,   3,   4, UNI_TFNG }   /* sc=tfng */,
  {     2,  9909,     0,   4,   0, UNI_PO }   /* ispo */,
  {     0,  9781,  8599,   7,   4, UNI__PERL_PATWS }   /* _perl_patws */,
  {     1,  9137,     0,   4,   0, UNI_dep_values_index }   /* dep= */,
  {    17,  2106,  7820,  21,   8, UNI_WB__EB }   /* graphemeclusterbreak=ebasegaz */,
  {     0,  8886,  2353,   3,  20, UNI_PHLI }   /* sc=inscriptionalpahlavi */,
  {     1,  4821,  9433,  14,   4, UNI_POSIXXDIGIT }   /* asciihexdigit=true */,
  {     0,  8886,   382,   3,   4, UNI_EGYP }   /* sc=egyp */,
  {     5,  8886,  2211,   3,   4, UNI_SC__SINH }   /* sc=sinh */,
  {     2,  5760,  7660,  13,   8, UNI_NV__3_SLASH_5 }   /* numericvalue=6.00e-01 */,
  {    20,  8233,  2984,   7,   4, UNI_SC__COPT }   /* script=copt */,
  {     2,  1243,     0,  21,   0, UNI_ce_values_index }   /* compositionexclusion= */,
  {    18,  8899,   995,   5,   2, -UNI_MATH }   /* math=no */,
  {    10,  9903,  5492,   6,   5, UNI_XPOSIXALNUM }   /* xposixalnum */,
  {     5,  9626,     0,   3,   0, UNI_jt_values_index }   /* jt= */,
  {     2,  8520,     1,   6,   1, -UNI_JOINC }   /* joinc=n */,
  {    12,  8233,  2169,   7,  11, UNI_MTEI }   /* script=meeteimayek */,
  {     7,  9093,  2930,   4,   8, UNI_INCHEROKEE }   /* blk=cherokee */,
  {     1,  9629,    42,   3,   2, UNI_LB__CJ }   /* lb=cj */,
  {    44,  1497,  8499,   9,   2, UNI_CF }   /* category=cf */,
  {     1,   106,     0,   6,   0, UNI_S }   /* symbol */,
  {     1,  6918,   202,  10,   2, UNI_LB__SA }   /* linebreak=sa */,
  {     1,  8424,  5526,   6,  13, UNI_GREEKEXT }   /* block=greekextended */,
  {     1,  9647,  9041,   3,   4, UNI_NV__7_SLASH_12 }   /* nv=7/12 */,
  {     0,  9647,  7556,   3,   8, UNI_NV__1_SLASH_32 }   /* nv=3.13e-02 */,
  {     1,  9365,  9289,   4,   4, UNI_NSHU }   /* scx=nshu */,
  {    32,  9909,  7366,   3,   8, UNI_PAUC }   /* ispaucinhau */,
  {     1,  8424,  8894,   6,   5, UNI_INLIMBU }   /* block=limbu */,
  {     0,  8086,     0,   7,   0, UNI_grbase_values_index }   /* grbase= */,
  {     0,  8844,     0,   4,   0, UNI_CWCF }   /* cwcf */,
  {     5,   184,  2590,   3,  10, UNI_COUNTINGROD }   /* iscountingrod */,
  {     0,  8332,   977,   3,  26, UNI_ANCIENTGREEKMUSIC }   /* isancientgreekmusicalnotation */,
  {    36,  8233,  9089,   7,   4, UNI_BHKS }   /* script=bhks */,
  {     0,  9153,  1855,   4,   2, UNI_GCB__CN }   /* gcb=cn */,
  {     0,  9623,     0,   3,   0, UNI_jg_values_index }   /* jg= */,
  {     0,  3868,   341,  16,   2, UNI_PE }   /* generalcategory=pe */,
  {    64,  8424,   600,   7,  29, UNI_CJKEXTD }   /* block=cjkunifiedideographsextensiond */,
  {     3,  7419,  9433,   9,   4, UNI_XIDS }   /* xidstart=true */,
  {    16,  1735,   995,  22,   2, -UNI_CWCM }   /* changeswhencasemapped=no */,
  {     1,  9093,  5367,   4,  14, UNI_SUPPUNCTUATION }   /* blk=suppunctuation */,
  {     0,  9093,    42,   4,  16, UNI_CJKCOMPAT }   /* blk=cjkcompatibility */,
  {     2,  1362,  8837,  24,   2, UNI_CCC__91 }   /* canonicalcombiningclass=91 */,
  {     2,  1057,   995,  27,   2, -UNI_PCM }   /* prependedconcatenationmark=no */,
  {     0,  9113,  8469,   4,   3, UNI_CCC__130 }   /* ccc=130 */,
  {     3,  7025,     0,   3,   0, UNI_in_values_index }   /* in= */,
  {     0,  9093,  3092,   4,  18, UNI_INPUNCTUATION }   /* blk=generalpunctuation */,
  {    49,  5339,     0,  16,   0, UNI_SB__SP }   /* sentencebreak=sp */,
  {     0,  8424,  8002,   6,   7, UNI_INBENGALI }   /* block=bengali */,
  {     2,  1573,     0,   4,   0, UNI_PHAG }   /* phag */,
  {     0,  8149,     0,   7,   0, UNI_MULT }   /* multani */,
  {     2,  9647,  8400,   3,   3, UNI_NV__900 }   /* nv=900 */,
  {     1,  9647,  7740,   3,   8, UNI_NV__1_SLASH_12 }   /* nv=8.33e-02 */,
  {     0,  6712,     0,  11,   0, UNI_SUPERANDSUB }   /* superandsub */,
  {    11,  3868,  2006,  16,  14, UNI_LM }   /* generalcategory=modifierletter */,
  {     1,  6828,  2433,  10,  11, UNI_BC__R }   /* bidiclass=righttoleft */,
  {     0,  6918,  7909,  11,   7, UNI_LB__LF }   /* linebreak=linefeed */,
  {     0,  9901,  4829,   8,   5, UNI_XPOSIXDIGIT }   /* isxposixdigit */,
  {     0,  9137,    26,   4,   1, UNI_DEP }   /* dep=y */,
  {     6,  9093,  2984,   4,  18, UNI_COPTICEPACTNUMBERS }   /* blk=copticepactnumbers */,
  {     0,  1362,  1700,  24,   2, UNI_CCC__DB }   /* canonicalcombiningclass=db */,
  {     5,  9365,  7356,   4,   9, UNI_PALM }   /* scx=palmyrene */,
  {    11,  8886,  8002,   3,   4, UNI_SC__BENG }   /* sc=beng */,
  {     3,   283,     0,  33,   0, UNI_MISCMATHSYMBOLSB }   /* miscellaneousmathematicalsymbolsb */,
  {     4,  9269,     0,   4,   0, UNI_MYMR }   /* mymr */,
  {     0,  7025,  9713,   3,   3, UNI_IN__6_DOT_3 }   /* in=v63 */,
  {     0,  9620,  9767,   3,   2, UNI_CASEDLETTER }   /* gc=l& */,
  {     2,  8617,    26,   5,   1, UNI_TERM }   /* term=y */,
  {     1,  9093,  8226,   4,   7, UNI_INPHAGSPA }   /* blk=phagspa */,
  {     0,  1757,   995,  22,   2, -UNI_CWL }   /* changeswhenlowercased=no */,
  {    34,  9193,   881,   4,   1, UNI_GCB__V }   /* hst=v */,
  {     2,  8886,  8934,   3,   5, UNI_RUNR }   /* sc=runic */,
  {     0,  5565,  6147,  13,  12, UNI_JG__MANICHAEANPE }   /* joininggroup=manichaeanpe */,
  {     2,  9623,  7038,   3,  10, UNI_JG__REVERSEDPE }   /* jg=reversedpe */,
  {     2,  9647,  8394,   3,   2, UNI_NV__80 }   /* nv=80 */,
  {     0,  7230,     0,   8,   0, UNI_EXT }   /* extender */,
  {     0,   184,   865,   2,  28, UNI_SUPPUAA }   /* issupplementaryprivateuseareaa */,
  {     0,  5760,  7603,  13,   2, UNI_NV__24 }   /* numericvalue=24 */,
  {    71,  6005,  1412,   4,  22, UNI_DIACRITICALSFORSYMBOLS }   /* incombiningmarksforsymbols */,
  {     1,   184,  2779,   2,  12, UNI_MONGOLIANSUP }   /* ismongoliansup */,
  {    58,  2703,     0,  19,   0, UNI_idst_values_index }   /* idstrinaryoperator= */,
  {    72,   184,  2874,   2,  19, UNI_SUPARROWSB }   /* issupplementalarrowsb */,
  {     1,  8424,  3020,   6,  10, UNI_INDEVANAGARI }   /* block=devanagari */,
  {     3,  1362,  8770,  25,   4, UNI_CCC__25 }   /* canonicalcombiningclass=ccc25 */,
  {     0,  9602,     0,   3,   0, UNI_di_values_index }   /* di= */,
  {     0,  8424,  6267,   6,  12, UNI_PHAISTOS }   /* block=phaistosdisc */,
  {     0,  7128,  7293,  10,   9, UNI_WB__MB }   /* wordbreak=midnumlet */,
  {     1,  9731,  7820,   3,   8, UNI_WB__EB }   /* wb=ebasegaz */,
  {     2,  4447,   835,  15,   1, UNI_EA__W }   /* eastasianwidth=w */,
  {     0,  9093,   988,   4,   5, UNI_MUSIC }   /* blk=music */,
  {    11,   184,  9217,   2,   4, UNI_LAO }   /* islaoo */,
  {     0,  8899,  9734,   5,   3, UNI_MATH }   /* math=yes */,
  {     6,  6949,  3452,   4,  15, UNI_UCAS }   /* iscanadiansyllabics */,
  {     0,  8424,  6051,   6,  12, UNI_MAHJONG }   /* block=mahjongtiles */,
  {     0,  1497,  4140,   9,   5, UNI_C }   /* category=other */,
  {     2,  2484,     0,   4,   0, UNI_MAND }   /* mand */,
  {     0,  6918,   878,  10,   2, UNI_LB__PR }   /* linebreak=pr */,
  {     1,  2684,  5394,  19,   2, UNI_LB__H2 }   /* hangulsyllabletype=lv */,
  {     3,  9129,     3,   4,   1, -UNI_CWU }   /* cwu=f */,
  {    84,  8424,   690,   7,   8, UNI_INCUNEIFORM }   /* block=cuneiform */,
  {     2,  3868,  3146,  16,  18, UNI_PI }   /* generalcategory=initialpunctuation */,
  {     1,  8886,  6183,   3,   4, UNI_MEND }   /* sc=mend */,
  {     0,  9093,  7257,   4,   9, UNI_LATINEXTB }   /* blk=latinextb */,
  {     0,  9728,  9433,   3,   4, UNI_VS }   /* vs=true */,
  {     0,   184,  3110,   2,   4, UNI_GEOR }   /* isgeor */,
  {     0,  9626,  6291,   3,  12, UNI_JT__R }   /* jt=rightjoining */,
  {     1,  9953,    25,   3,   1, UNI_VS }   /* isvs */,
  {     7,  2453,     1,  20,   1, -UNI_TERM }   /* terminalpunctuation=n */,
  {     8,  9093,  3290,   4,  18, UNI_RUMI }   /* blk=ruminumeralsymbols */,
  {     2,  8233,  9337,   7,   4, UNI_SC__QAAI }   /* script=qaai */,
  {     3,  1239,    26,  25,   1, UNI_COMPEX }   /* fullcompositionexclusion=y */,
  {     9,  7118,     0,   4,   0, UNI_WARA }   /* wara */,
  {     0,  1536,  3039,   3,  10, UNI_ETHIOPICSUP }   /* inethiopicsup */,
  {     0,  9620,  1508,   3,   2, UNI_PS }   /* gc=ps */,
  {     0,  8332,  3758,   4,   7, UNI_ARABICSUP }   /* isarabicsup */,
  {     1,  3038,     0,   4,   0, UNI_ETHI }   /* ethi */,
  {     0,  8424,   976,   6,  17, UNI_ANCIENTGREEKMUSIC }   /* block=ancientgreekmusic */,
  {     7,  1362,   726,  24,   2, UNI_CCC__DA }   /* canonicalcombiningclass=da */,
  {     0,  3868,   400,  16,   6, UNI_CF }   /* generalcategory=format */,
  {     0,  9731,  6668,   3,  11, UNI_WB__SQ }   /* wb=singlequote */,
  {     2,  9605,  1362,   3,   9, UNI_DT__CAN }   /* dt=canonical */,
  {    16,  8424,  2333,   6,  13, UNI_GLAGOLITICSUP }   /* block=glagoliticsup */,
  {    35,  5979,     3,  12,   1, -UNI_IDEO }   /* ideographic=f */,
  {     4,  9365,  6691,   5,  10, UNI_SORA }   /* scx=sorasompeng */,
  {     2,  8424,  8045,   7,   6, UNI_CJKEXTF }   /* block=cjkextf */,
  {     9,  1158,  3327,   3,  10, UNI_TAIXUANJING }   /* intaixuanjing */,
  {     0,  8233,  9217,   7,   4, UNI_LAO }   /* script=laoo */,
  {     1,  9281,     0,   4,   0, UNI_NEWA }   /* newa */,
  {     0,  9623,  6701,   3,  11, UNI_JG__STRAIGHTWAW }   /* jg=straightwaw */,
  {     0,  6039,     0,  12,   0, UNI_NL }   /* letternumber */,
  {     5,   184,  9237,   2,   3, UNI_LOE }   /* isloe */,
  {     0,  9946,  1473,   3,   8, UNI__PERL_SURROGATE }   /* issurrogate */,
  {     0,  9365,  9185,   4,   4, UNI_HMNG }   /* scx=hmng */,
  {     0,  9725,  3380,   3,  18, UNI_VO__TU }   /* vo=transformedupright */,
  {    16,  2148,  7375,   3,   8, UNI_INSAMARITAN }   /* insamaritan */,
  {     8,  2401,     0,   3,   0, UNI_PUA }   /* pua */,
  {     1,   184,  8010,   3,   6, UNI_CJKEXTA }   /* iscjkexta */,
  {    82,  3671,  7804,  17,   4, UNI_BUGI }   /* scriptextensions=bugi */,
  {     3,  9647,  7691,   3,   2, UNI_NV__36 }   /* nv=36 */,
  {     3,  1362,  8740,  25,   4, UNI_CCC__19 }   /* canonicalcombiningclass=ccc19 */,
  {     1,  8580,    36,   6,   1, UNI__PERL_NCHAR }   /* nchar=t */,
  {     0,  3951,  5553,   3,   5, UNI_IPAEXT }   /* isipaext */,
  {     8,  9903,  4829,   6,   5, UNI_XPOSIXDIGIT }   /* xposixdigit */,
  {     0,  9113,  8817,   4,   2, UNI_CCC__34 }   /* ccc=34 */,
  {     0,  9365,  9105,   4,   4, UNI_CAKM }   /* scx=cakm */,
  {     0,    96,     0,   5,   0, UNI_XPOSIXALPHA }   /* alpha */,
  {     0,  1362,  2912,  24,  18, UNI_CCC__216 }   /* canonicalcombiningclass=attachedaboveright */,
  {     3,  8233,  7796,   7,   8, UNI_BASS }   /* script=bassavah */,
  {     0,  6005,  2591,   4,   9, UNI_COUNTINGROD }   /* incountingrod */,
  {    19,  3868,  5809,  16,   2, UNI_PF }   /* generalcategory=pf */,
  {     1,  8424,  7008,   6,  10, UNI_INPHOENICIAN }   /* block=phoenician */,
  {     7,  8879,  5284,   3,  13, UNI_PHONETICEXTSUP }   /* inphoneticextsup */,
  {     0,  9093,  3932,   4,  16, UNI_HIGHPUSURROGATES }   /* blk=highpusurrogates */,
  {   104,  3293,  1099,   3,   3, UNI_UCAS }   /* inucas */,
  {     1,  8886,  9189,   3,   4, UNI_HMNP }   /* sc=hmnp */,
  {     1,  2148,  1290,   3,  24, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* insymbolsandpictographsexta */,
  {     0,  6194,  4658,   3,  14, UNI_NARB }   /* inoldnortharabian */,
  {     1,   184,  8485,   3,   5, UNI_CAKM }   /* ischakma */,
  {     0,  9093,  4933,   4,  14, UNI_INGREEK }   /* blk=greekandcoptic */,
  {    32,  2148,  3309,   3,  17, UNI_SMALLKANAEXT }   /* insmallkanaextension */,
  {     0,  8332,  4822,   3,  12, UNI_POSIXXDIGIT }   /* isasciihexdigit */,
  {     2,  8424,  5017,   6,  14, UNI_LATINEXTC }   /* block=latinextendedc */,
  {     6,  9365,  4297,   4,   7, UNI_BRAI }   /* scx=braille */,
  {     7,   184,  7221,   2,   9, UNI_EMOTICONS }   /* isemoticons */,
  {     1,  5448,     0,  13,   0, UNI_BLOCKELEMENTS }   /* blockelements */,
  {     0,  8954,     0,   5,   0, UNI_xidc_values_index }   /* xidc= */,
  {     0,  1576,     0,  23,   0, UNI_GEOMETRICSHAPESEXT }   /* geometricshapesextended */,
  {     5,  9093,  1856,   4,  11, UNI_NUMBERFORMS }   /* blk=numberforms */,
  {     2,  6918,  7176,  10,   9, UNI_LB__AI }   /* linebreak=ambiguous */,
  {     1,   184,  8072,   2,   4, UNI_ELYM }   /* iselym */,
  {     3,  8954,     3,   5,   1, -UNI_XIDC }   /* xidc=f */,
  {     0,  9049,  9722,   4,   3, UNI_AGE__9 }   /* age=v90 */,
  {    20,  8289,     0,   7,   0, UNI_LANA }   /* taitham */,
  {     7,  8424,  8038,   7,   6, UNI_CJKEXTE }   /* block=cjkexte */,
  {     6,  3948,  1696,   3,   2, UNI_INVAI }   /* invai */,
  {     0,  9365,  8430,   4,   4, UNI_CARI }   /* scx=cari */,
  {     0,  8424,  1824,   7,  21, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* block=cjkcompatideographssup */,
  {     0,  8424,  3020,   6,  13, UNI_DEVANAGARIEXT }   /* block=devanagariext */,
  {     0,   184,  4975,   2,  14, UNI_KANASUP }   /* iskanasupplement */,
  {     0,  9093,  3038,   4,   8, UNI_INETHIOPIC }   /* blk=ethiopic */,
  {     2,  4204,     0,   6,   0, UNI_SYRC }   /* syriac */,
  {     0,  8233,  6898,   7,  10, UNI_KHAR }   /* script=kharoshthi */,
  {     4,  6918,  5325,  10,   9, UNI_LB__QU }   /* linebreak=quotation */,
  {     0,  8604,    36,   6,   1, UNI_QMARK }   /* qmark=t */,
  {     0,  9365,  7980,   4,   8, UNI_UGAR }   /* scx=ugaritic */,
  {     2,  9901,  9916,   8,   5, UNI_XPOSIXBLANK }   /* isxposixblank */,
  {     3,  9093,  6898,   4,  10, UNI_INKHAROSHTHI }   /* blk=kharoshthi */,
  {     0,  3868,  1014,  16,   6, UNI_L }   /* generalcategory=letter */,
  {     2,  1362,  6393,  24,  11, UNI_CCC__DA }   /* canonicalcombiningclass=doubleabove */,
  {    10,  6918,  9310,  10,   2, UNI_LB__SG }   /* linebreak=sg */,
  {     0,  8233,  8072,   7,   4, UNI_ELYM }   /* script=elym */,
  {     7,  8424,  2590,   7,  10, UNI_COUNTINGROD }   /* block=countingrod */,
  {     0,  8233,  9493,   7,   4, UNI_ZZZZ }   /* script=zzzz */,
  {     0,  1482,     0,  24,   0, UNI_inpc_values_index }   /* indicpositionalcategory= */,
  {     1,  1158,  8297,   3,   6, UNI_INTAIVIET }   /* intaiviet */,
  {     3,  6828,  2192,  10,   3, UNI_BC__PDI }   /* bidiclass=pdi */,
  {     0,  8886,  8282,   3,   7, UNI_SC__TGLG }   /* sc=tagalog */,
  {    10,  9113,  2373,   4,   4, UNI_CCC__L }   /* ccc=left */,
  {     0,  2212,  7861,   3,   7, UNI_INHIRAGANA }   /* inhiragana */,
  {    10,  9153,  4195,   4,   9, UNI_WB__EB }   /* gcb=emodifier */,
  {     3,   184,   183,   2,  20, UNI_MISCSYMBOLS }   /* ismiscellaneoussymbols */,
  {     6,  9365,  8538,   4,   4, UNI_KHOJ }   /* scx=khoj */,
  {     3,  3236,   995,  18,   2, -UNI__PERL_PATWS }   /* patternwhitespace=no */,
  {    68,  8424,   510,   7,  29, UNI_CJKEXTA }   /* block=cjkunifiedideographsextensiona */,
  {     1,  8233,  7804,   7,   4, UNI_SC__BUGI }   /* script=bugi */,
  {     0,  9599,     1,   3,   1, -UNI_CI }   /* ci=n */,
  {     0,  4297,     0,   4,   0, UNI_BRAI }   /* brai */,
  {     0,  9629,  1696,   3,   2, UNI_LB__AI }   /* lb=ai */,
  {    13,  9093,  9425,   4,   4, UNI_INTHAI }   /* blk=thai */,
  {     1,  8886,  8261,   3,   7, UNI_SOYO }   /* sc=soyombo */,
  {     3,  5760,  7446,  13,   1, UNI_NV__2 }   /* numericvalue=2 */,
  {    36,  8338,    26,   7,   1, UNI_XPOSIXSPACE }   /* wspace=y */,
  {     0,  9365,  7892,   4,   8, UNI_JAVA }   /* scx=javanese */,
  {     6,  7275,     0,   9,   0, UNI_LATINEXTD }   /* latinextd */,
  {     0,  8424,  3519,   7,  16, UNI_CYRILLICEXTB }   /* block=cyrillicextendedb */,
  {     2,  1362,  2920,  24,   5, UNI_CCC__A }   /* canonicalcombiningclass=above */,
  {     0,  5760,  9010,  13,   3, UNI_NV__3_SLASH_2 }   /* numericvalue=3/2 */,
  {     2,  8424,  1289,   6,  25, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* block=symbolsandpictographsexta */,
  {     2,  8886,  3620,   3,  10, UNI_SC__MANI }   /* sc=manichaean */,
  {     0,  8874,    36,   5,   1, UNI_IDST }   /* idst=t */,
  {     1,  4826,  9433,   9,   4, UNI_XPOSIXXDIGIT }   /* hexdigit=true */,
  {     9,  9093,  8859,   4,   5, UNI_INDOGRA }   /* blk=dogra */,
  {     0,  9365,  8149,   4,   7, UNI_MULT }   /* scx=multani */,
  {     0,  9940,  3248,   6,   5, UNI_POSIXSPACE }   /* isperlspace */,
  {    22,  8332,  9054,   3,   3, UNI_AGHB }   /* isaghb */,
  {     0,  6051,     0,   4,   0, UNI_MAHJ }   /* mahj */,
  {    32,   184,  8017,   3,   6, UNI_CJKEXTB }   /* iscjkextb */,
  {     3,  9602,  9433,   3,   4, UNI_DI }   /* di=true */,
  {     1,   184,  6679,   2,  10, UNI_SD }   /* issoftdotted */,
  {     0,  9946,  9782,   7,   4, UNI_XPOSIXSPACE }   /* isspaceperl */,
  {     1,    21,  5578,   2,  13, UNI_KANAEXTA }   /* inkanaextendeda */,
  {     3,   184,  8850,   3,   3, UNI_CWCM }   /* iscwcm */,
  {     2,  8886,  9217,   3,   4, UNI_LAO }   /* sc=laoo */,
  {   130,   467,     0,   5,   0, UNI_P }   /* punct */,
  {     0,  8886,  8002,   3,   7, UNI_SC__BENG }   /* sc=bengali */,
  {    18,   184,  9489,   2,   4, UNI_ZYYY }   /* iszyyy */,
  {     0,  2106,    34,  21,   2, UNI_GCB__EX }   /* graphemeclusterbreak=ex */,
  {     0,  1933,     0,  22,   0, UNI_loe_values_index }   /* logicalorderexception= */,
  {   128,  8685,     0,   4,   0, UNI_hex_values_index }   /* hex= */,
  {     0,  8586,  9734,   6,   3, UNI_NFCQC__Y }   /* nfcqc=yes */,
  {     3,  9662,  9734,   3,   3, UNI_SD }   /* sd=yes */,
  {    77,  8592,  9734,   6,   3, UNI_NFDQC__Y }   /* nfdqc=yes */,
  {     4,  4657,     0,  15,   0, UNI_NARB }   /* oldnortharabian */,
  {     0,  4975,     0,  14,   0, UNI_KANASUP }   /* kanasupplement */,
  {     0,    58,     0,   4,   0, UNI_IDEO }   /* ideo */,
  {     3,  9647,  7436,   3,   8, UNI_NV__1_SLASH_9 }   /* nv=1.11e-01 */,
  {     0,  1362,  8745,  25,   4, UNI_CCC__20 }   /* canonicalcombiningclass=ccc20 */,
  {     4,  2703,   995,  19,   2, -UNI_IDST }   /* idstrinaryoperator=no */,
  {     0,  9608,  8574,   3,   6, UNI_EA__NA }   /* ea=narrow */,
  {     6,    21,  1188,   2,   8, UNI_INKATAKANA }   /* inkatakana */,
  {     0,   184,  1622,   2,  14, UNI_LATINEXTA }   /* islatinextendeda */,
  {     2,   184,  5199,   2,  14, UNI_SK }   /* ismodifiersymbol */,
  {     3,    21,  4822,   3,   4, UNI_ASCII }   /* inascii */,
  {     1,  3671,  9429,  17,   4, UNI_TIBT }   /* scriptextensions=tibt */,
  {     1,  9365,  6992,   5,   6, UNI_SOGD }   /* scx=sogdian */,
  {     0,  8086,  8864,   7,   5, -UNI_GRBASE }   /* grbase=false */,
  {     1,  8233,  8859,   7,   5, UNI_SC__DOGR }   /* script=dogra */,
  {     2,  4140,     0,  16,   0, UNI_PO }   /* otherpunctuation */,
  {     2,  9623,  4947,   3,  14, UNI_JG__HAMZAONHEHGOAL }   /* jg=hamzaonhehgoal */,
  {     5,  9602,    26,   3,   1, UNI_DI }   /* di=y */,
  {     1,  6005,   660,   3,  29, UNI_CJKEXTF }   /* incjkunifiedideographsextensionf */,
  {    11,  2684,   881,  19,   1, UNI_GCB__V }   /* hangulsyllabletype=v */,
  {     2,  9093,  4204,   4,   6, UNI_INSYRIAC }   /* blk=syriac */,
  {     3,  6885,  8101,   3,   5, UNI_HYPHEN }   /* ishyphen */,
  {    16,  8886,  7374,   3,   9, UNI_SAMR }   /* sc=samaritan */,
  {     0,   184,  8538,   2,   4, UNI_KHOJ }   /* iskhoj */,
  {     0,  8332,  5800,   3,  11, UNI_ALPHABETICPF }   /* isalphabeticpf */,
  {     0,  8886,  9261,   3,   3, UNI_MRO }   /* sc=mro */,
  {     1,  4705,  9418,   3,   3, UNI_TFNG }   /* istfng */,
  {     0,  9916,     0,   5,   0, UNI_XPOSIXBLANK }   /* blank */,
  {    20,  2148,  3706,   3,  16, UNI_SMALLFORMS }   /* insmallformvariants */,
  {    14,  9093,   779,   4,  22, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* blk=enclosedideographicsup */,
  {    15,    84,     0,   4,   0, UNI_MATH }   /* math */,
  {     0,   184,  9134,   3,   3, UNI_CYRL }   /* iscyrl */,
  {     4,  9620,  3227,   3,   9, UNI_Z }   /* gc=separator */,
  {    18,  8424,  8079,   6,   7, UNI_INGRANTHA }   /* block=grantha */,
  {     0,  4705,  3327,   3,  10, UNI_TAIXUANJING }   /* istaixuanjing */,
  {     0,  5760,  7508,  13,   8, UNI_NV__1_SLASH_5 }   /* numericvalue=2.00e-01 */,
  {     0,  8556,   995,   6,   2, -UNI_XPOSIXLOWER }   /* lower=no */,
  {     0,  3868,   598,  16,   2, UNI_XPOSIXCNTRL }   /* generalcategory=cc */,
  {     1,  9647,  9013,   3,   4, UNI_NV__15_SLASH_2 }   /* nv=15/2 */,
  {     4,  6005,  2591,   4,  17, UNI_COUNTINGROD }   /* incountingrodnumerals */,
  {     0,  8520,  9734,   6,   3, UNI_JOINC }   /* joinc=yes */,
  {     1,  9145,     0,   4,   0, UNI_DSRT }   /* dsrt */,
  {     1,  8037,     0,   7,   0, UNI_CJKEXTE }   /* cjkexte */,
  {     0,  8079,     0,   7,   0, UNI_GRAN }   /* grantha */,
  {    16,  8233,  2409,   7,   4, UNI_SC__MONG }   /* script=mong */,
  {     0,  3671,  9269,  17,   4, UNI_MYMR }   /* scriptextensions=mymr */,
  {    10,  9113,  1701,   4,   2, UNI_CCC__BR }   /* ccc=br */,
  {     0,  9647,  7652,   3,   8, UNI_NV__7_SLASH_12 }   /* nv=5.83e-01 */,
  {     0,  3671,  6602,  17,  11, UNI_NAND }   /* scriptextensions=nandinagari */,
  {     9,  8170,     0,   9,   0, UNI_NFKDQC__N }   /* nfkdqc=no */,
  {     5,  5565,  2561,  13,   3, UNI_JG__YEH }   /* joininggroup=yeh */,
  {     1,  9940,  7128,   6,   4, UNI_POSIXWORD }   /* isperlword */,
  {     0,  8412,     3,   6,   1, -UNI_BIDIC }   /* bidic=f */,
  {     0,  9620,  4732,   3,  15, UNI_TITLE }   /* gc=titlecaseletter */,
  {     1,  7018,  9674,  10,   3, UNI_IN__2 }   /* presentin=v20 */,
  {     2,  9593,  9635,   3,   3, UNI_BC__LRI }   /* bc=lri */,
  {     0,  8219,  9734,   7,   3, UNI_PATSYN }   /* patsyn=yes */,
  {     1,   184,   316,   2,  33, UNI_SUPMATHOPERATORS }   /* issupplementalmathematicaloperators */,
  {     0,  9647,  8802,   3,   2, UNI_NV__31 }   /* nv=31 */,
  {     1,  8424,  8093,   6,   7, UNI_INHANUNOO }   /* block=hanunoo */,
  {    29,  9093,  8526,   4,   6, UNI_INKAITHI }   /* blk=kaithi */,
  {     0,  9629,     0,   3,   0, UNI_lb_values_index }   /* lb= */,
  {     3,  5760,  7723,  13,   2, UNI_NV__18 }   /* numericvalue=18 */,
  {     5,  9647,  5409,   3,   2, UNI_NV__10 }   /* nv=10 */,
  {     2,  7025,  9692,   3,   3, UNI_IN__4_DOT_1 }   /* in=v41 */,
  {    40,   184,  1289,   2,  25, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* issymbolsandpictographsexta */,
  {     2,  3671,  7788,  17,   8, UNI_BALI }   /* scriptextensions=balinese */,
  {     0,  8424,   467,   6,  11, UNI_INPUNCTUATION }   /* block=punctuation */,
  {     4,  8177,     0,   7,   0, UNI_NB }   /* noblock */,
  {     2,  8586,  8904,   6,   5, UNI_NFCQC__M }   /* nfcqc=maybe */,
  {     2,  2204,  9306,   3,   3, UNI_ORYA }   /* isorya */,
  {     0,  9193,     9,   4,   2, UNI_HST__NA }   /* hst=na */,
  {    24,  8233,  6246,   7,   4, UNI_HUNG }   /* script=hung */,
  {    26,  8604,  9433,   6,   4, UNI_QMARK }   /* qmark=true */,
  {     0,  4778,     1,   3,  33, UNI_UCAS }   /* isunifiedcanadianaboriginalsyllabics */,
  {     4,  3671,  9333,  17,   4, UNI_COPT }   /* scriptextensions=qaac */,
  {     0,  9781,  9814,   6,  21, UNI__PERL_IS_IN_MULTI_CHAR_FOLD }   /* _perl_is_in_multi_char_fold */,
  {     0,  1338,     0,  24,   0, UNI_ARABICPFB }   /* arabicpresentationformsb */,
  {    21,  3951,   415,   3,  31, UNI_INIDC }   /* isideographicdescriptioncharacters */,
  {     2,  4507,     0,  15,   0, UNI_LOWERCASELETTER }   /* lowercaseletter */,
  {     1,  7128,  5952,  10,   3, UNI_LB__ZWJ }   /* wordbreak=zwj */,
  {     1,  9926,  3248,   7,   5, UNI_XPOSIXBLANK }   /* ishorizspace */,
  {     4,  8219,    26,   7,   1, UNI_PATSYN }   /* patsyn=y */,
  {     1,  9933,    17,   5,   1, UNI_XPEO }   /* isxpeo */,
  {     3,  8233,  8514,   7,   4, UNI_HATR }   /* script=hatr */,
  {     1,  2708,  7187,   4,   7, UNI_ARABICPFA }   /* inarabicpfa */,
  {     8,  8424,  3996,   6,  16, UNI_LINEARBSYLLABARY }   /* block=linearbsyllabary */,
  {     5,  1362,  4701,  24,   2, UNI_CCC__0 }   /* canonicalcombiningclass=nr */,
  {    22,  9093,  2779,   4,  12, UNI_MONGOLIANSUP }   /* blk=mongoliansup */,
  {     0,  8233,  8939,   7,   5, UNI_SC__TALE }   /* script=taile */,
  {     7,  1977,   995,  22,   2, -UNI__PERL_NCHAR }   /* noncharactercodepoint=no */,
  {     5,  7420,     0,   7,   0, UNI_IDS }   /* idstart */,
  {     3,  8424,  2779,   6,  12, UNI_MONGOLIANSUP }   /* block=mongoliansup */,
  {     0,  9782,  3248,   4,   5, UNI_POSIXSPACE }   /* perlspace */,
  {     0,  8955,  9734,   4,   3, UNI_IDC }   /* idc=yes */,
  {     0,  3671,  6554,  18,   3, UNI_SAMR }   /* scriptextensions=samr */,
  {     5,  3671,  8296,  17,   7, UNI_TAVT }   /* scriptextensions=taiviet */,
  {     0,  6828,   407,  10,   2, UNI_BC__ON }   /* bidiclass=on */,
  {     5,  9940,     0,   4,   0, UNI_PE }   /* ispe */,
  {    43,  8424,  7248,   6,   9, UNI_INKHUDAWADI }   /* block=khudawadi */,
  {     3,   493,     0,   3,   0, UNI_HAN }   /* han */,
  {     5,   184,  2333,   2,  13, UNI_GLAGOLITICSUP }   /* isglagoliticsup */,
  {    15,  1497,   107,  10,   5, UNI_S }   /* category=symbol */,
  {     0,  8233,  9101,   7,   4, UNI_SC__BUHD }   /* script=buhd */,
  {     0,  4705,  5768,   3,   3, UNI_TALU }   /* istalu */,
  {     1,  8520,    36,   6,   1, UNI_JOINC }   /* joinc=t */,
  {     0,  3671,  9169,  17,   4, UNI_GUJR }   /* scriptextensions=gujr */,
  {     0,  3728,     0,  11,   0, UNI_SGNW }   /* signwriting */,
  {     5,  8233,  9421,   7,   4, UNI_SC__TGLG }   /* script=tglg */,
  {     0,  8886,   493,   3,   3, UNI_SC__HAN }   /* sc=han */,
  {     0,  7932,    26,   8,   1, UNI_RADICAL }   /* radical=y */,
  {    20,  5760,  8382,  13,   6, UNI_NV__600000 }   /* numericvalue=600000 */,
  {    12,  3002,  7836,  18,   3, UNI_DT__FRA }   /* decompositiontype=fra */,
  {     3,  8424,   921,   6,  28, UNI_VSSUP }   /* block=variationselectorssupplement */,
  {    24,  4778,  1813,   3,   4, UNI_XPOSIXUPPER }   /* isupper */,
  {     8,  8424,   414,   6,  32, UNI_INIDC }   /* block=ideographicdescriptioncharacters */,
  {    10,  3868,    24,  16,   1, UNI_L }   /* generalcategory=l */,
  {    48,  3948,  4763,   3,   7, UNI_VEDICEXT }   /* invedicext */,
  {     4,  8424,  1622,   6,  23, UNI_LATINEXTADDITIONAL }   /* block=latinextendedadditional */,
  {     0,   184,  6003,   2,   5, UNI_JOINC }   /* isjoinc */,
  {     0,   184,  1188,   2,   8, UNI_KANA }   /* iskatakana */,
  {   115,  3868,   698,  16,   6, UNI_N }   /* generalcategory=number */,
  {    20,  8424,  3884,   6,  11, UNI_GEORGIANEXT }   /* block=georgianext */,
  {    33,  9904,  4828,   5,   6, UNI_POSIXXDIGIT }   /* posixxdigit */,
  {     6,  8424,   540,   7,  29, UNI_CJKEXTB }   /* block=cjkunifiedideographsextensionb */,
  {     0,  8886,  9089,   3,   4, UNI_BHKS }   /* sc=bhks */,
  {     8,  9113,  8750,   5,   4, UNI_CCC__21 }   /* ccc=ccc21 */,
  {    11,  5760,  7495,  13,   1, UNI_NV__7 }   /* numericvalue=7 */,
  {    11,  9093,    78,   4,  35, UNI_ARABICMATH }   /* blk=arabicmathematicalalphabeticsymbols */,
  {     0,  8424,  7347,   6,   9, UNI_INOLDTURKIC }   /* block=oldturkic */,
  {     9,  3671,  6243,  17,  12, UNI_HUNG }   /* scriptextensions=oldhungarian */,
  {    32,  3128,    36,  18,   1, UNI_IDSB }   /* idsbinaryoperator=t */,
  {   134,  9049,  8997,   4,   4, UNI_AGE__11 }   /* age=11.0 */,
  {     0,  8424,  7048,   6,  10, UNI_INSAURASHTRA }   /* block=saurashtra */,
  {     3,  9620,  1767,   3,   2, UNI_NL }   /* gc=nl */,
  {     1,  3164,     0,   9,   0, UNI_LATINEXTA }   /* latinexta */,
  {     0,  8879,  3350,   5,  12, UNI_INPC__LEFTANDRIGHT }   /* inpc=leftandright */,
  {     1,  9365,  8079,   4,   7, UNI_GRAN }   /* scx=grantha */,
  {     5,  9093,   467,   4,  11, UNI_INPUNCTUATION }   /* blk=punctuation */,
  {     1,   184,  3308,   2,  18, UNI_SMALLKANAEXT }   /* issmallkanaextension */,
  {     1,    42,     0,  16,   0, UNI_CJKCOMPAT }   /* cjkcompatibility */,
  {     1,  7018,  9692,  10,   3, UNI_IN__4_DOT_1 }   /* presentin=v41 */,
  {     1,  8424,  5967,   6,   6, UNI_INHEBREW }   /* block=hebrew */,
  {     4,  8424,   690,   7,  15, UNI_CUNEIFORMNUMBERS }   /* block=cuneiformnumbers */,
  {     3,  8424,  6316,   6,   3, UNI_INIDC }   /* block=idc */,
  {     0,  1790,     0,   9,   0, UNI_TITLE }   /* titlecase */,
  {     0,  3671,  7812,  17,   4, UNI_DUPL }   /* scriptextensions=dupl */,
  {    16,  1933,    26,  22,   1, UNI_LOE }   /* logicalorderexception=y */,
  {     0,  9365,  8430,   4,   6, UNI_CARI }   /* scx=carian */,
  {     0,  9946,  8255,   3,   6, UNI_SIDD }   /* issiddham */,
  {     0,  6316,   995,  11,   2, -UNI_IDC }   /* idcontinue=no */,
  {     0,  8616,     3,   6,   1, -UNI_STERM }   /* sterm=f */,
  {     0,  9365,  4657,   4,  15, UNI_NARB }   /* scx=oldnortharabian */,
  {     0,  8233,  8114,   7,   7, UNI_SC__KALI }   /* script=kayahli */,
  {     1,  8886,  3836,   3,   7, UNI_SC__CPRT }   /* sc=cypriot */,
  {     0,  8884,  4327,   5,  15, UNI_INSC__CONSONANTKILLER }   /* insc=consonantkiller */,
  {     1,  8424,  4204,   6,   6, UNI_INSYRIAC }   /* block=syriac */,
  {     5,  8886,  9101,   3,   4, UNI_SC__BUHD }   /* sc=buhd */,
  {     0,  1911,  7320,  22,   9, UNI_INSC__NONJOINER }   /* indicsyllabiccategory=nonjoiner */,
  {    12,   184,  9916,   2,   5, UNI_XPOSIXBLANK }   /* isblank */,
  {     0,  7341,     0,   4,   0, UNI_PERM }   /* perm */,
  {     1,  8424,  7804,   6,   8, UNI_INBUGINESE }   /* block=buginese */,
  {     3,  9647,  7470,   3,   2, UNI_NV__50 }   /* nv=50 */,
  {     3,  9662,     0,   3,   0, UNI_sd_values_index }   /* sd= */,
  {     4,  1911,  4188,  22,  16, UNI_INSC__SYLLABLEMODIFIER }   /* indicsyllabiccategory=syllablemodifier */,
  {     2,  9093,  4417,   4,  15, UNI_DIACRITICALSEXT }   /* blk=diacriticalsext */,
  {     3,  3948,  4763,   3,  14, UNI_VEDICEXT }   /* invedicextensions */,
  {     3,  1362,  8760,  25,   4, UNI_CCC__23 }   /* canonicalcombiningclass=ccc23 */,
  {     6,   184,  3020,   2,  10, UNI_DEVA }   /* isdevanagari */,
  {     0,  6918,   125,  10,   2, UNI_LB__CR }   /* linebreak=cr */,
  {    96,   184,  3290,   2,   4, UNI_RUMI }   /* isrumi */,
  {     0,  5269,  9433,  14,   4, UNI_PATSYN }   /* patternsyntax=true */,
  {     0,  4705,  8290,   3,   6, UNI_LANA }   /* istaitham */,
  {     0,  8685,     3,   4,   1, -UNI_XPOSIXXDIGIT }   /* hex=f */,
  {    33,   184,  6602,   2,  11, UNI_NAND }   /* isnandinagari */,
  {    29,  5311,     0,  14,   0, UNI_PHLP }   /* psalterpahlavi */,
  {     1,  8886,  3110,   3,   4, UNI_SC__GEOR }   /* sc=geor */,
  {     1,  9181,     0,   4,   0, UNI_HLUW }   /* hluw */,
  {     0,  1159,    39,   3,   2, UNI_XPOSIXDIGIT }   /* nt=de */,
  {     2,  9909,  7128,   7,   4, UNI_POSIXWORD }   /* isposixword */,
  {     1,  9593,  2413,   3,  20, UNI_BC__PDF }   /* bc=popdirectionalformat */,
  {     4,   184,    84,   2,   4, UNI_MATH }   /* ismath */,
  {     0,  6005,   510,   3,  29, UNI_CJKEXTA }   /* incjkunifiedideographsextensiona */,
  {     4,  5760,  8358,  13,   4, UNI_NV__3000 }   /* numericvalue=3000 */,
  {     0,   184,  9353,   2,   4, UNI_RUNR }   /* isrunr */,
  {   104,  8233,  2930,   7,   8, UNI_CHER }   /* script=cherokee */,
  {     0,  8424,   808,   6,  29, UNI_MISCARROWS }   /* block=miscellaneoussymbolsandarrows */,
  {     0,  3671,  8550,  17,   4, UNI_LEPC }   /* scriptextensions=lepc */,
  {     8,  5760,  9021,  13,   4, UNI_NV__3_SLASH_16 }   /* numericvalue=3/16 */,
  {     0,  9093,   446,   4,  18, UNI_IDEOGRAPHICSYMBOLS }   /* blk=ideographicsymbols */,
  {     2,  4946,     0,   4,   0, UNI_CHAM }   /* cham */,
  {    24,  9313,     3,   4,   1, -UNI_PCM }   /* pcm=f */,
  {     0,  9365,  2085,   4,   8, UNI_CYRL }   /* scx=cyrillic */,
  {    12,  3603,     0,  17,   0, UNI_LETTERLIKESYMBOLS }   /* letterlikesymbols */,
  {    12,  5339,  1768,  14,   5, UNI_SB__LO }   /* sentencebreak=lower */,
  {     9,  8886,  8514,   3,   4, UNI_HATR }   /* sc=hatr */,
  {    19,  8640,    26,   6,   1, UNI_XPOSIXUPPER }   /* upper=y */,
  {     1,  8886,  9221,   3,   4, UNI_SC__LATN }   /* sc=latn */,
  {     1,  9357,     0,   4,   0, UNI_SAMR }   /* samr */,
  {     1,  8233,  9333,   7,   4, UNI_SC__COPT }   /* script=qaac */,
  {     0,  9093,  5967,   4,   6, UNI_INHEBREW }   /* blk=hebrew */,
  {     2,  3243,     0,  11,   0, UNI_wspace_values_index }   /* whitespace= */,
  {     5,   184,  1933,   2,  21, UNI_LOE }   /* islogicalorderexception */,
  {     2,  8233,  9325,   7,   4, UNI_MIAO }   /* script=plrd */,
  {     1,  9647,  7495,   3,   1, UNI_NV__7 }   /* nv=7 */,
  {     9,  3671,  6558,  17,  11, UNI_MEDF }   /* scriptextensions=medefaidrin */,
  {     0,  9113,  8451,   4,   3, UNI_CCC__118 }   /* ccc=118 */,
  {    10,  9093,  8282,   4,   7, UNI_INTAGALOG }   /* blk=tagalog */,
  {     7,  8044,     0,   7,   0, UNI_CJKEXTF }   /* cjkextf */,
  {     0,  3251,  9734,   3,   3, UNI_CE }   /* ce=yes */,
  {     1,  8874,    26,   5,   1, UNI_IDST }   /* idst=y */,
  {     3,  8424,  4492,   6,  15, UNI_INIMPERIALARAMAIC }   /* block=imperialaramaic */,
  {     0,  9626,     0,   4,   0, UNI_JT__L }   /* jt=l */,
  {   130,  9113,  9539,   4,   3, UNI_CCC__DB }   /* ccc=233 */,
  {     1,  2984,     0,   4,   0, UNI_COPT }   /* copt */,
  {     1,  8944,     0,   5,   0, UNI_TAKR }   /* takri */,
  {     8,  8424,  8934,   6,   5, UNI_INRUNIC }   /* block=runic */,
  {     1,  3964,     0,   9,   0, UNI_LATIN1 }   /* latin1sup */,
  {     0,  9647,  7614,   3,   2, UNI_NV__17 }   /* nv=17 */,
  {     1,  9093,  6051,   4,  12, UNI_MAHJONG }   /* blk=mahjongtiles */,
  {    70,  5760,  8675,  13,   4, UNI_NV__1_SLASH_12 }   /* numericvalue=1/12 */,
  {     0,  3671,  2169,  17,  11, UNI_MTEI }   /* scriptextensions=meeteimayek */,
  {     1,  6939,     0,   2,   0, UNI_VS }   /* vs */,
  {     0,  3398,     3,  18,   1, -UNI_VS }   /* variationselector=f */,
  {     1,  9049,  7631,   4,   1, UNI_AGE__9 }   /* age=9 */,
  {     0,  6005,  5896,   3,  11, UNI_CYRILLICEXTC }   /* incyrillicextc */,
  {     5,  5760,  8394,  13,   4, UNI_NV__8000 }   /* numericvalue=8000 */,
  {     1,  8424,    43,   7,  15, UNI_CJKCOMPAT }   /* block=cjkcompatibility */,
  {     0,  7098,     0,  10,   0, UNI_CN }   /* unassigned */,
  {     8,   184,  2779,   2,  19, UNI_MONGOLIANSUP }   /* ismongoliansupplement */,
  {     3,  6159,     0,  12,   0, UNI_GONM }   /* masaramgondi */,
  {     0,  9647,  7612,   3,   8, UNI_NV__5_SLASH_12 }   /* nv=4.17e-01 */,
  {    48,  9365,  8892,   4,   4, UNI_PHLI }   /* scx=phli */,
  {     0,  9093,  8093,   4,   7, UNI_INHANUNOO }   /* blk=hanunoo */,
  {     0,  8424,   250,   6,  33, UNI_MISCMATHSYMBOLSA }   /* block=miscellaneousmathematicalsymbolsa */,
  {     0,  6005,  1824,   3,  21, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* incjkcompatideographssup */,
  {     0,  8886,  4220,   3,   6, UNI_TANG }   /* sc=tangut */,
  {     4,  8598,     0,   5,   0, UNI__PERL_PATWS }   /* patws */,
  {     0,  9365,  3980,   4,   7, UNI_LINB }   /* scx=linearb */,
  {     9,   184,  2086,   3,  17, UNI_CYRILLICSUP }   /* iscyrillicsupplement */,
  {     1,  2708,  7196,   4,   7, UNI_ARABICPFB }   /* inarabicpfb */,
  {     1,  9093,  6839,   5,   9, UNI_BOXDRAWING }   /* blk=boxdrawing */,
  {     0,  6723,     0,   4,   0, UNI_SYLO }   /* sylo */,
  {     6,   184,  4108,   2,   7, UNI_MYMR }   /* ismyanmar */,
  {     1,  9121,  9433,   4,   4, UNI_CWL }   /* cwl=true */,
  {     4,  2708,  6800,   4,   8, UNI_ARABICEXTA }   /* inarabicexta */,
  {     0,  8233,  2741,   7,  19, UNI_MERO }   /* script=meroitichieroglyphs */,
  {     1,  9605,   435,   4,   2, UNI_DT__ENC }   /* dt=enc */,
  {     0,  8914,     0,   5,   0, UNI_NSHU }   /* nushu */,
  {    48,   184,  1867,   2,  22, UNI_DIACRITICALSFORSYMBOLS }   /* isdiacriticalsforsymbols */,
  {     0,  1482,  6383,   3,  10, UNI_DOMINO }   /* indominotiles */,
  {     0,  5760,  7614,  13,   2, UNI_NV__17 }   /* numericvalue=17 */,
  {     0,  7356,     0,   9,   0, UNI_PALM }   /* palmyrene */,
  {     1,  9647,  8388,   3,   4, UNI_NV__7000 }   /* nv=7000 */,
  {     0,  1362,  7459,  24,   2, UNI_CCC__21 }   /* canonicalcombiningclass=21 */,
  {     1,  8879,  2473,   5,  20, UNI_INPC__TOPANDBOTTOMANDRIGHT }   /* inpc=topandbottomandright */,
  {     0,  8879,  5461,   5,  13, UNI_INPC__BOTTOMANDLEFT }   /* inpc=bottomandleft */,
  {     1,  9093,  3552,   4,  11, UNI_ETHIOPICEXT }   /* blk=ethiopicext */,
  {     8,  8219,    36,   7,   1, UNI_PATSYN }   /* patsyn=t */,
  {     3,  9629,    23,   3,   2, UNI_LB__AL }   /* lb=al */,
  {     0,   184,  8502,   2,   4, UNI_GOTH }   /* isgoth */,
  {     0,  8233,  8526,   7,   6, UNI_SC__KTHI }   /* script=kaithi */,
  {     0,  8586,    17,   7,   1, UNI_COMPEX }   /* nfcqc=no */,
  {     2,  3951,  3147,   3,  17, UNI_PI }   /* isinitialpunctuation */,
  {    10,   184,  2931,   3,  10, UNI_CHEROKEESUP }   /* ischerokeesup */,
  {     2,  4642,    26,  15,   1, UNI_DT__NONE }   /* nfkdquickcheck=y */,
  {     6,  8550,     0,   6,   0, UNI_LEPC }   /* lepcha */,
  {     1,  2148,  2837,   3,  18, UNI_SUNDANESESUP }   /* insundanesesupplement */,
  {     4,  8424,  1188,   6,  26, UNI_KATAKANAEXT }   /* block=katakanaphoneticextensions */,
  {     0,  4462,     3,  15,   1, -UNI_GREXT }   /* graphemeextend=f */,
  {     8,  3671,  4108,  17,   7, UNI_MYMR }   /* scriptextensions=myanmar */,
  {     2,   184,  6602,   2,   4, UNI_NAND }   /* isnand */,
  {     1,  2106,   125,  21,   2, UNI_LB__CR }   /* graphemeclusterbreak=cr */,
  {     0,  1159,  4829,   3,   5, UNI_NT__DI }   /* nt=digit */,
  {     0,  8233,     0,  14,   0, UNI_SC__SHRD }   /* script=sharada */,
  {     0,  8160,   721,   4,  19, UNI_ENCLOSEDALPHANUM }   /* inenclosedalphanumerics */,
  {     1,  9093,  2127,   4,  14, UNI_INHANIFIROHINGYA }   /* blk=hanifirohingya */,
  {    15,  5565,  4060,  13,  16, UNI_JG__MANICHAEANTWENTY }   /* joininggroup=manichaeantwenty */,
  {    16,  9365,  2741,   4,  19, UNI_MERO }   /* scx=meroitichieroglyphs */,
  {     8,  2703,     0,  18,   0, UNI_IDST }   /* idstrinaryoperator */,
  {     7,  8592,     1,   6,   1, UNI_DT__CAN }   /* nfdqc=n */,
  {     4,  3248,     0,   5,   0, UNI_XPOSIXSPACE }   /* space */,
  {     7,   112,     0,   2,   0, UNI_SC }   /* sc */,
  {    17,  9049,  9701,   4,   3, UNI_AGE__5_DOT_2 }   /* age=v52 */,
  {     1,  1158,  2022,   3,  21, UNI_TRANSPORTANDMAP }   /* intransportandmapsymbols */,
  {     0,  8233,  8430,   7,   4, UNI_CARI }   /* script=cari */,
  {     0,  9623,  6778,   3,  10, UNI_JG__AFRICANFEH }   /* jg=africanfeh */,
  {    24,  8424,  8929,   6,   5, UNI_INOSAGE }   /* block=osage */,
  {    25,  3868,  1029,  16,   2, UNI_SO }   /* generalcategory=so */,
  {     0,  4821,     1,  14,   1, -UNI_POSIXXDIGIT }   /* asciihexdigit=n */,
  {     0,  8424,  2836,   6,  19, UNI_SUNDANESESUP }   /* block=sundanesesupplement */,
  {    17,  6005,  3519,   3,  16, UNI_CYRILLICEXTB }   /* incyrillicextendedb */,
  {     0,  8424,  5367,   6,  14, UNI_SUPPUNCTUATION }   /* block=suppunctuation */,
  {     1,  8424,  8024,   7,   6, UNI_CJKEXTC }   /* block=cjkextc */,
  {     0,  8617,  9434,   6,   3, UNI_TERM }   /* term=true */,
  {     4,  3868,   697,  16,   2, UNI_MN }   /* generalcategory=mn */,
  {     0,  8871,  1129,   3,   2, UNI_SB__ST }   /* sb=st */,
  {     0,  5760,  7462,  13,   1, UNI_NV__4 }   /* numericvalue=4 */,
  {     0,  7257,     0,   9,   0, UNI_LATINEXTB }   /* latinextb */,
  {     0,  1362,  9536,  24,   3, UNI_CCC__AR }   /* canonicalcombiningclass=232 */,
  {     0,  8879,  8227,   3,   6, UNI_INPHAGSPA }   /* inphagspa */,
  {     2,  7025,  9587,   3,   3, UNI_IN__9 }   /* in=9.0 */,
  {     1,  9365,  3110,   4,   8, UNI_GEOR }   /* scx=georgian */,
  {     1,  9365,  3020,   4,  10, UNI_DEVA }   /* scx=devanagari */,
  {     0,  9365,  7804,   4,   8, UNI_BUGI }   /* scx=buginese */,
  {    17,  8233,  6724,   8,   3, UNI_SC__SYLO }   /* script=sylo */,
  {     0,  9365,  7248,   4,   9, UNI_SIND }   /* scx=khudawadi */,
  {     0,   184,  4297,   2,   7, UNI_BRAI }   /* isbraille */,
  {    14,  5760,  9033,  13,   3, UNI_NV__3_SLASH_8 }   /* numericvalue=3/8 */,
  {    24,   184,  2065,   3,  20, UNI_CJKRADICALSSUP }   /* iscjkradicalssupplement */,
  {     1,  1497,  5255,   9,  14, UNI_MN }   /* category=nonspacingmark */,
  {     9,  9049,  7436,   4,   3, UNI_IN__1_DOT_1 }   /* age=1.1 */,
  {     1,  7128,  5967,  10,  12, UNI_LB__HL }   /* wordbreak=hebrewletter */,
  {     2,  9647,  8669,   3,   4, UNI_NV__1_SLASH_32 }   /* nv=1/32 */,
  {     0,  9197,     0,   4,   0, UNI_KALI }   /* kali */,
  {     0,  2106,  5346,  21,   2, UNI_WB__EB }   /* graphemeclusterbreak=eb */,
  {     1,  5513,    26,  13,   1, UNI_GRBASE }   /* graphemebase=y */,
  {     0,  4705,  8228,   3,   3, UNI_TAGS }   /* istags */,
  {     0,  8424,  9281,   6,   4, UNI_INNEWA }   /* block=newa */,
  {     0,  6567,   812,   6,  25, UNI_MISCARROWS }   /* inmiscellaneoussymbolsandarrows */,
  {     0,  8879,     9,   5,   2, UNI_INPC__NA }   /* inpc=na */,
  {     0,  8886,  9045,   3,   4, UNI_SC__ADLM }   /* sc=adlm */,
  {     0,  9201,     0,   4,   0, UNI_KHMR }   /* khmr */,
  {     0,  3671,  9325,  17,   4, UNI_MIAO }   /* scriptextensions=plrd */,
  {     2,  8418,     1,   6,   1, -UNI_BIDIM }   /* bidim=n */,
  {    89,  8580,  9433,   6,   4, UNI__PERL_NCHAR }   /* nchar=true */,
  {     0,  9909,  6917,   3,   3, UNI_PHLI }   /* isphli */,
  {     0,  8879,   838,   3,  17, UNI_PHONETICEXT }   /* inphoneticextensions */,
  {     3,  1482,  4419,   4,  13, UNI_DIACRITICALSEXT }   /* indiacriticalsext */,
  {     8,   184,  4080,   2,  10, UNI_SM }   /* ismathsymbol */,
  {     0,  3671,  8289,  17,   7, UNI_LANA }   /* scriptextensions=taitham */,
  {     0,  8160,  1005,   4,  25, UNI_ENCLOSEDCJK }   /* inenclosedcjklettersandmonths */,
  {     0,  9113,  9542,   4,   3, UNI_CCC__DA }   /* ccc=234 */,
  {     0,  8424,  8939,   6,   5, UNI_INTAILE }   /* block=taile */,
  {     3,  9647,  9557,   3,   3, UNI_NV__3_SLASH_5 }   /* nv=3/5 */,
  {     0,  9093,  3467,   4,  17, UNI_INCAUCASIANALBANIAN }   /* blk=caucasianalbanian */,
  {     7,  7128,    73,  10,   2, UNI_WB__EB }   /* wordbreak=em */,
  {     2,  8886,  9453,   3,   4, UNI_VAI }   /* sc=vaii */,
  {   134,  9901,    96,   8,   5, UNI_XPOSIXALPHA }   /* isxposixalpha */,
  {     0,  8884,  6219,   5,  12, UNI_INSC__NUMBERJOINER }   /* insc=numberjoiner */,
  {    18,  8886,  7860,   3,   4, UNI_SC__HIRA }   /* sc=hira */,
  {     0,  3981,  1892,   5,  19, UNI_EARLYDYNASTICCUNEIFORM }   /* inearlydynasticcuneiform */,
  {     0,  8886,  8652,   3,   6, UNI_WCHO }   /* sc=wancho */,
  {     0,  9153,  1057,   4,   7, UNI_GCB__PP }   /* gcb=prepend */,
  {     1,   184,  6808,   2,  10, UNI_ASCII }   /* isbasiclatin */,
  {     0,  7025,  7495,   3,   1, UNI_IN__7 }   /* in=7 */,
  {     0,  9659,     1,   3,   1, -UNI_RI }   /* ri=n */,
  {     1,  8884,  2293,   5,  20, UNI_INSC__CONSONANTPLACEHOLDER }   /* insc=consonantplaceholder */,
  {     0,  3671,  2532,  17,   4, UNI_BRAH }   /* scriptextensions=brah */,
  {     0,  9365,  4582,   4,  15, UNI_MERC }   /* scx=meroiticcursive */,
  {     1,  9608,  7176,   3,   9, UNI_EA__A }   /* ea=ambiguous */,
  {     1,  6679,  9433,  11,   4, UNI_SD }   /* softdotted=true */,
  {    14,  1084,     0,  26,   0, UNI_cwkcf_values_index }   /* changeswhennfkccasefolded= */,
  {     8,  9629,   878,   3,   2, UNI_LB__PR }   /* lb=pr */,
  {     6,  1924,     7,  10,   1, UNI_CASEDLETTER }   /* category=lc */,
  {    13,  8886,  9349,   3,   4, UNI_SC__ROHG }   /* sc=rohg */,
  {     1,  1599,     0,  23,   0, UNI_COMPATJAMO }   /* hangulcompatibilityjamo */,
  {     4,  9093,   148,   4,  35, UNI_DIACRITICALSSUP }   /* blk=combiningdiacriticalmarkssupplement */,
  {     2,  9093,  7118,   4,  10, UNI_INWARANGCITI }   /* blk=warangciti */,
  {     1,  4705,  4733,   3,  14, UNI_TITLE }   /* istitlecaseletter */,
  {     0,  8640,     3,   6,   1, -UNI_XPOSIXUPPER }   /* upper=f */,
  {    14,  1362,  7683,  24,   2, UNI_CCC__26 }   /* canonicalcombiningclass=26 */,
  {    16,  9093,  2760,   4,  19, UNI_MODIFIERTONELETTERS }   /* blk=modifiertoneletters */,
  {     1,  1977,    26,  22,   1, UNI__PERL_NCHAR }   /* noncharactercodepoint=y */,
  {     1,  8233,  2127,   7,   4, UNI_SC__HAN }   /* script=hani */,
  {     0,  3671,  9209,  17,   4, UNI_KTHI }   /* scriptextensions=kthi */,
  {     1,   184,  5526,   2,  13, UNI_GREEKEXT }   /* isgreekextended */,
  {     1,  4267,     0,   5,   0, UNI_BAMU }   /* bamum */,
  {     7,  3688,  8864,  17,   5, -UNI_STERM }   /* sentenceterminal=false */,
  {     1,  9093,   659,   4,  30, UNI_CJKEXTF }   /* blk=cjkunifiedideographsextensionf */,
  {     0,  9093,  4076,   4,  16, UNI_MISCMATHSYMBOLSA }   /* blk=miscmathsymbolsa */,
  {     0,  1362,  6481,  24,  11, UNI_CCC__8 }   /* canonicalcombiningclass=kanavoicing */,
  {     0,  8233,  1622,   7,   5, UNI_SC__LATN }   /* script=latin */,
  {     2,  9647,  7462,   3,   1, UNI_NV__4 }   /* nv=4 */,
  {     7,  3671,  7365,  17,   9, UNI_PAUC }   /* scriptextensions=paucinhau */,
  {     0,  9153,  3254,   4,  17, UNI_RI }   /* gcb=regionalindicator */,
  {     1,  6828,  3074,  10,  18, UNI_BC__FSI }   /* bidiclass=firststrongisolate */,
  {     3,  3671,  9489,  17,   4, UNI_ZYYY }   /* scriptextensions=zyyy */,
  {     0,  8886,  9297,   3,   4, UNI_OLCK }   /* sc=olck */,
  {    20,  4705,  1257,   4,   2, UNI_TELU }   /* istelu */,
  {     2,  9113,  6404,   4,  11, UNI_CCC__DB }   /* ccc=doublebelow */,
  {     0,  1159,   495,   3,   2, UNI_NT__NU }   /* nt=nu */,
  {     0,  9629,  9753,   3,   2, UNI_LB__B2 }   /* lb=b2 */,
  {     0,  8886,  9489,   3,   4, UNI_SC__ZYYY }   /* sc=zyyy */,
  {     0,  9125,    26,   4,   1, UNI_CWT }   /* cwt=y */,
  {     1,  8871,    34,   3,   6, UNI_SB__EX }   /* sb=extend */,
  {     1,  9605,  1223,   3,   7, UNI_DT__INIT }   /* dt=initial */,
  {     0,  8424,  3722,   6,  17, UNI_SUTTONSIGNWRITING }   /* block=suttonsignwriting */,
  {     5,  9365,  9085,   4,   4, UNI_BATK }   /* scx=batk */,
  {     0,  8879,  6734,   5,  11, UNI_INPC__TOPANDRIGHT }   /* inpc=topandright */,
  {     0,    21,  8532,   2,   6, UNI_KANBUN }   /* inkanbun */,
  {     0,  9365,  7956,   4,   4, UNI_TAGB }   /* scx=tagb */,
  {     4,  3671,  8248,  18,   6, UNI_SHAW }   /* scriptextensions=shavian */,
  {    17,  6816,  7797,   3,   7, UNI_INBASSAVAH }   /* inbassavah */,
  {     2,  9405,     0,   4,   0, UNI_TALU }   /* talu */,
  {     0,  8424,   779,   6,  29, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* block=enclosedideographicsupplement */,
  {     2,  6767,     0,  11,   0, UNI_YISYLLABLES }   /* yisyllables */,
  {     0,  7018,  7631,  10,   1, UNI_IN__9 }   /* presentin=9 */,
  {     0,  7128,  1188,  10,   2, UNI_WB__KA }   /* wordbreak=ka */,
  {     0,  8508,    36,   6,   1, UNI_GREXT }   /* grext=t */,
  {     0,  9593,  9638,   3,   3, UNI_BC__LRO }   /* bc=lro */,
  {     0,   184,  8538,   2,   6, UNI_KHOJ }   /* iskhojki */,
  {     0,  8424,  8226,   6,   7, UNI_INPHAGSPA }   /* block=phagspa */,
  {     0,  8128,     0,   4,   0, UNI_MAKA }   /* maka */,
  {     7,  8879,  6280,   3,  11, UNI_PLAYINGCARDS }   /* inplayingcards */,
  {     0,  8424,  3620,   6,  10, UNI_INMANICHAEAN }   /* block=manichaean */,
  {     0,  1497,  2006,   9,  14, UNI_LM }   /* category=modifierletter */,
  {     1,  3671,  7338,  17,   9, UNI_PERM }   /* scriptextensions=oldpermic */,
  {     0,  9629,  6848,   3,  10, UNI_LB__BA }   /* lb=breakafter */,
  {     1,  9365,  7796,   4,   8, UNI_BASS }   /* scx=bassavah */,
  {     1,  5760,  7507,  13,   2, UNI_NV__12 }   /* numericvalue=12 */,
  {     0,   184,   382,   2,  32, UNI_EGYPTIANHIEROGLYPHFORMATCONTROLS }   /* isegyptianhieroglyphformatcontrols */,
  {     0,  3248,     3,   6,   1, -UNI_XPOSIXSPACE }   /* space=f */,
  {    28,  9731,  7410,   3,   9, UNI_WB__WSEGSPACE }   /* wb=wsegspace */,
  {     2,  9093,  9261,   4,   3, UNI_INMRO }   /* blk=mro */,
  {     1,  9049,  7660,   4,   3, UNI_AGE__6 }   /* age=6.0 */,
  {     1,  9904,  1768,   5,   5, UNI_POSIXLOWER }   /* posixlower */,
  {     1,  9141,  9433,   4,   4, UNI_DIA }   /* dia=true */,
  {     2,  8886,  9473,   3,   4, UNI_SC__YI }   /* sc=yiii */,
  {     0,  8233,  8924,   7,   5, UNI_SC__ORYA }   /* script=oriya */,
  {    26,  5085,  5619,   4,   7, UNI_INMALAYALAM }   /* inmalayalam */,
  {     5,  8233,  5311,   7,  14, UNI_SC__PHLP }   /* script=psalterpahlavi */,
  {    24,  5565,  5115,  13,  14, UNI_JG__MANICHAEANHETH }   /* joininggroup=manichaeanheth */,
  {     6,  9365,  9209,   4,   4, UNI_KTHI }   /* scx=kthi */,
  {    51,  2493,  3391,  20,   7, UNI_VO__U }   /* verticalorientation=upright */,
  {     2,    21,  5003,   2,  14, UNI_LATINEXTB }   /* inlatinextendedb */,
  {     5,  9093,  7860,   4,   8, UNI_INHIRAGANA }   /* blk=hiragana */,
  {     2,  9901,  9470,   3,   3, UNI_XSUX }   /* isxsux */,
  {    18,  8233,  2837,   8,   3, UNI_SUND }   /* script=sund */,
  {    18,  8886,  7852,   3,   8, UNI_SC__GURU }   /* sc=gurmukhi */,
  {     3,  3671,  2333,  17,  10, UNI_GLAG }   /* scriptextensions=glagolitic */,
  {     3,  4462,    26,  15,   1, UNI_GREXT }   /* graphemeextend=y */,
  {     3,  9623,  5129,   3,  14, UNI_JG__MANICHAEANKAPH }   /* jg=manichaeankaph */,
  {    14,  5085,  8138,   5,   4, UNI_INMANDAIC }   /* inmandaic */,
  {     1,  8424,  3326,   6,  11, UNI_TAIXUANJING }   /* block=taixuanjing */,
  {     6,  9623,  8658,   3,   6, UNI_JG__YUDHHE }   /* jg=yudhhe */,
  {     1,  8226,     0,   7,   0, UNI_PHAG }   /* phagspa */,
  {     0,  8424,  8538,   6,   6, UNI_INKHOJKI }   /* block=khojki */,
  {     1,  9365,  8128,   4,   4, UNI_MAKA }   /* scx=maka */,
  {     0,  9647,  8989,   3,   4, UNI_NV__1_SLASH_80 }   /* nv=1/80 */,
  {     0,  8424,  8859,   6,   5, UNI_INDOGRA }   /* block=dogra */,
  {     2,  3868,  8499,  16,   2, UNI_CF }   /* generalcategory=cf */,
  {     0,  8424,  5604,   6,  13, UNI_LOWSURROGATES }   /* block=lowsurrogates */,
  {     1,  7018,  9449,  10,   4, UNI_IN__12_DOT_1 }   /* presentin=v121 */,
  {     3,  3671,  4792,  17,  15, UNI_ZANB }   /* scriptextensions=zanabazarsquare */,
  {     0,  8424,  8254,   6,   7, UNI_INSIDDHAM }   /* block=siddham */,
  {    33,  9093,  6868,   4,  10, UNI_COMPATJAMO }   /* blk=compatjamo */,
  {     9,  1506,     0,  24,   0, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* supsymbolsandpictographs */,
  {    16,  3739,     0,  17,   0, UNI_uideo_values_index }   /* unifiedideograph= */,
  {     1,  5835,    26,  12,   1, UNI_BIDIC }   /* bidicontrol=y */,
  {     2,  8424,   283,   6,  33, UNI_MISCMATHSYMBOLSB }   /* block=miscellaneousmathematicalsymbolsb */,
  {     1,  1362,  8437,  25,   5, UNI_CCC__103 }   /* canonicalcombiningclass=ccc103 */,
  {     0,  9903,    96,   6,   5, UNI_XPOSIXALPHA }   /* xposixalpha */,
  {     0,  3243,   995,  11,   2, -UNI_XPOSIXSPACE }   /* whitespace=no */,
  {     1,  9093,   569,   4,  30, UNI_CJKEXTC }   /* blk=cjkunifiedideographsextensionc */,
  {     0,  3671,  7980,  17,   4, UNI_UGAR }   /* scriptextensions=ugar */,
  {   256,  9093,   567,   4,   2, UNI_NB }   /* blk=nb */,
  {    24,  9093,   749,   4,  30, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* blk=symbolsandpictographsextendeda */,
  {     1,  9365,  9493,   4,   4, UNI_ZZZZ }   /* scx=zzzz */,
  {     0,  2253,     0,  20,   0, UNI_HLUW }   /* anatolianhieroglyphs */,
  {     0,   184,  3164,   2,  18, UNI_LATINEXTADDITIONAL }   /* islatinextadditional */,
  {     1,    21,  5423,   3,  12, UNI_AEGEANNUMBERS }   /* inaegeannumbers */,
  {     0,  8424,  4108,   6,   7, UNI_INMYANMAR }   /* block=myanmar */,
  {     0,  6858,     0,  10,   0, UNI_CJKSTROKES }   /* cjkstrokes */,
  {     2,  8955,     3,   4,   1, -UNI_IDC }   /* idc=f */,
  {     1,  7025,  9551,   3,   3, UNI_IN__3_DOT_2 }   /* in=3.2 */,
  {     1,  9647,  7747,   3,   2, UNI_NV__28 }   /* nv=28 */,
  {     0,  1362,  6207,  24,  12, UNI_CCC__0 }   /* canonicalcombiningclass=notreordered */,
  {     3,  8233,  3772,   7,   8, UNI_SC__BOPO }   /* script=bopomofo */,
  {     0,  9365,  9201,   4,   4, UNI_KHMR }   /* scx=khmr */,
  {     1,  9113,  8780,   5,   4, UNI_CCC__27 }   /* ccc=ccc27 */,
  {     3,  7964,     0,   8,   0, UNI_TFNG }   /* tifinagh */,
  {     0,  3128,     0,  18,   0, UNI_idsb_values_index }   /* idsbinaryoperator= */,
  {     0,  9620,  6635,   3,  11, UNI_SO }   /* gc=othersymbol */,
  {     1,  4618,  2335,   4,  11, UNI_GLAGOLITICSUP }   /* inglagoliticsup */,
  {     0,  9317,     0,   4,   0, UNI_PHLP }   /* phlp */,
  {     0,  5979,  9433,  12,   4, UNI_IDEO }   /* ideographic=true */,
  {    43,  9153,  9611,   4,   3, UNI_WB__EB }   /* gcb=ebg */,
  {     2,   184,  7900,   2,   8, UNI_KANAEXTA }   /* iskanaexta */,
  {     0,  3002,  2493,  18,   4, UNI_DT__VERT }   /* decompositiontype=vert */,
  {     2,   184,  9277,   2,   4, UNI_NBAT }   /* isnbat */,
  {     2,  1801,     0,  22,   0, UNI_cwu_values_index }   /* changeswhenuppercased= */,
  {     0,  1933,  9734,  22,   3, UNI_LOE }   /* logicalorderexception=yes */,
  {    15,  6382,     0,   6,   0, UNI_DOMINO }   /* domino */,
  {     0,  5760,  7756,  13,   8, UNI_NV__7_SLASH_8 }   /* numericvalue=8.75e-01 */,
  {     2,  9946,  6554,   3,   3, UNI_SAMR }   /* issamr */,
  {     0,  9593,    37,   3,   2, UNI_BC__EN }   /* bc=en */,
  {     1,  8233,  8093,   7,   7, UNI_SC__HANO }   /* script=hanunoo */,
  {     0,  6949,   724,   4,   3, UNI_CASED }   /* iscased */,
  {     4,  9629,    21,   3,   2, UNI_LB__IN }   /* lb=in */,
  {    11,  8424,   183,   6,  20, UNI_MISCSYMBOLS }   /* block=miscellaneoussymbols */,
  {     3,  9093,   719,   4,  21, UNI_ENCLOSEDALPHANUM }   /* blk=enclosedalphanumerics */,
  {     4,  9647,  7492,   3,   8, UNI_NV__1_SLASH_6 }   /* nv=1.67e-01 */,
  {     3,  9093,  3722,   4,  17, UNI_SUTTONSIGNWRITING }   /* blk=suttonsignwriting */,
  {    80,  9069,     0,   4,   0, UNI_ARMN }   /* armn */,
  {     0,  9093,  5895,   4,  12, UNI_CYRILLICEXTC }   /* blk=cyrillicextc */,
  {     0,  1362,  8790,  25,   4, UNI_CCC__29 }   /* canonicalcombiningclass=ccc29 */,
  {     1,  1977,     0,  21,   0, UNI__PERL_NCHAR }   /* noncharactercodepoint */,
  {     0,  5565,  5241,  13,  14, UNI_JG__NOJOININGGROUP }   /* joininggroup=nojoininggroup */,
  {     4,   184,   749,   2,  30, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* issymbolsandpictographsextendeda */,
  {     0,  1362,  8720,  25,   4, UNI_CCC__15 }   /* canonicalcombiningclass=ccc15 */,
  {     0,  5513,  9433,  13,   4, UNI_GRBASE }   /* graphemebase=true */,
  {   113,   184,  9261,   2,   3, UNI_MRO }   /* ismro */,
  {     1,  4252,     0,  15,   0, UNI_ARABICEXTA }   /* arabicextendeda */,
  {     1,  4826,  8864,   9,   5, -UNI_XPOSIXXDIGIT }   /* hexdigit=false */,
  {     0,  9093,  7221,   4,   9, UNI_EMOTICONS }   /* blk=emoticons */,
  {     4,  5565,     5,  13,   1, UNI_JG__E }   /* joininggroup=e */,
  {     2,  1497,    17,  10,   1, UNI_SO }   /* category=so */,
  {     0,  9593,  3608,   3,   3, UNI_BC__RLI }   /* bc=rli */,
  {     3,  3671,  8121,  17,   7, UNI_LINA }   /* scriptextensions=lineara */,
  {     0,  2684,     9,  19,   2, UNI_HST__NA }   /* hangulsyllabletype=na */,
  {     0,  8424,  4717,   6,  15, UNI_TAMILSUP }   /* block=tamilsupplement */,
  {     8,  1362,  3969,  24,   1, UNI_CCC__1 }   /* canonicalcombiningclass=1 */,
  {     9,  8886,  2532,   3,   4, UNI_BRAH }   /* sc=brah */,
  {     1,    32,     0,   2,   0, UNI__PERL_SURROGATE }   /* cs */,
  {     0,  8424,  1645,   6,  23, UNI_SHORTHANDFORMATCONTROLS }   /* block=shorthandformatcontrols */,
  {     8,  8160,   781,   4,  27, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* inenclosedideographicsupplement */,
  {     2,  8886,  9393,   3,   4, UNI_SC__SYRC }   /* sc=syrc */,
  {    10,  1924,    24,  10,   1, UNI_LOWERCASELETTER }   /* category=ll */,
  {     0,  9647,  3969,   3,   1, UNI_NV__1 }   /* nv=1 */,
  {     0,  9093,  3326,   4,  18, UNI_TAIXUANJING }   /* blk=taixuanjingsymbols */,
  {     0,  8424,  1867,   6,  12, UNI_DIACRITICALS }   /* block=diacriticals */,
  {     8,   184,  8149,   2,   7, UNI_MULT }   /* ismultani */,
  {     0,  9620,  5199,   3,  14, UNI_SK }   /* gc=modifiersymbol */,
  {    24,  2703,  9433,  19,   4, UNI_IDST }   /* idstrinaryoperator=true */,
  {     1,  8886,  4792,   3,  15, UNI_ZANB }   /* sc=zanabazarsquare */,
  {     0,  2106,  5258,  21,  11, UNI_GCB__SM }   /* graphemeclusterbreak=spacingmark */,
  {     4,  5760,  8394,  13,   6, UNI_NV__800000 }   /* numericvalue=800000 */,
  {    14,  1497,   697,   9,   2, UNI_MN }   /* category=mn */,
  {     0,  6918,     3,  11,   1, UNI_LB__LF }   /* linebreak=lf */,
  {     8,  7128,   400,  10,   6, UNI_WB__FO }   /* wordbreak=format */,
  {     0,  8886,  8142,   3,   7, UNI_MARC }   /* sc=marchen */,
  {     0,  8424,  1387,   7,   9, UNI_CJKSYMBOLS }   /* block=cjksymbols */,
  {    16,  9093,  4092,   4,  16, UNI_MISCMATHSYMBOLSB }   /* blk=miscmathsymbolsb */,
  {     0,  7108,    36,  10,   1, UNI_XPOSIXUPPER }   /* uppercase=t */,
  {     0,  6567,   187,   6,  16, UNI_MISCSYMBOLS }   /* inmiscellaneoussymbols */,
  {     0,  5565,  5708,  13,  13, UNI_JG__MANICHAEANWAW }   /* joininggroup=manichaeanwaw */,
  {     3,  6918,   495,  10,   7, UNI_LB__NU }   /* linebreak=numeric */,
  {     4,  6808,     0,  10,   0, UNI_ASCII }   /* basiclatin */,
  {     3,  6338,  9433,  11,   4, UNI_XPOSIXALPHA }   /* alphabetic=true */,
  {     0,   184,  7812,   2,   4, UNI_DUPL }   /* isdupl */,
  {    24,  9647,  7676,   3,   8, UNI_NV__1_SLASH_16 }   /* nv=6.25e-02 */,
  {     0,  9137,  8864,   4,   5, -UNI_DEP }   /* dep=false */,
  {     1,  8424,  1539,   6,  14, UNI_MUSIC }   /* block=musicalsymbols */,
  {    40,  5526,     0,   8,   0, UNI_GREEKEXT }   /* greekext */,
  {     0,  8424,  8485,   7,   5, UNI_INCHAKMA }   /* block=chakma */,
  {    49,  8640,     0,   6,   0, UNI_upper_values_index }   /* upper= */,
  {     2,  2021,     0,  22,   0, UNI_TRANSPORTANDMAP }   /* transportandmapsymbols */,
  {     0,  3002,  1223,  18,   4, UNI_DT__INIT }   /* decompositiontype=init */,
  {     5,   184,  4762,   2,  15, UNI_VEDICEXT }   /* isvedicextensions */,
  {     2,  9647,  7764,   3,   8, UNI_NV__11_SLASH_12 }   /* nv=9.17e-01 */,
  {    13,  8886,  9357,   3,   4, UNI_SAMR }   /* sc=samr */,
  {     0,  8233,  7365,   7,   9, UNI_PAUC }   /* script=paucinhau */,
  {     0,  3671,     7,  17,  18, UNI_CANS }   /* scriptextensions=canadianaboriginal */,
  {     0,  9093,  7805,   5,   7, UNI_INBUGINESE }   /* blk=buginese */,
  {     1,  4627,     0,  16,   0, UNI_NFKCQC__N }   /* nfkcquickcheck=n */,
  {     9,  9647,  9751,   3,   2, UNI_NV__49 }   /* nv=49 */,
  {     1,  9237,   995,   4,   2, -UNI_LOE }   /* loe=no */,
  {     1,  4705,  9422,   3,   3, UNI_TGLG }   /* istglg */,
  {     1,  9365,  7341,   4,   4, UNI_PERM }   /* scx=perm */,
  {    12,  6928,   995,  10,   2, -UNI_XPOSIXLOWER }   /* lowercase=no */,
  {     1,  7018,  9713,  10,   3, UNI_IN__6_DOT_3 }   /* presentin=v63 */,
  {     2,  8233,  9261,   7,   4, UNI_MRO }   /* script=mroo */,
  {     0,  9647,  7763,   3,   2, UNI_NV__19 }   /* nv=19 */,
  {     1,  9629,   495,   3,   7, UNI_LB__NU }   /* lb=numeric */,
  {     0,   184,  4989,   2,  14, UNI_KANGXI }   /* iskangxiradicals */,
  {     1,  9093,   878,   4,  14, UNI_PUA }   /* blk=privateusearea */,
  {     5,  6918,    73,  10,   2, UNI_LB__EM }   /* linebreak=em */,
  {     1,  8412,  8864,   6,   5, -UNI_BIDIC }   /* bidic=false */,
  {    25,  8233,  8550,   7,   6, UNI_LEPC }   /* script=lepcha */,
  {    16,  3671,  9465,  17,   4, UNI_XPEO }   /* scriptextensions=xpeo */,
  {     2,  8332,    97,   3,   4, UNI_XPOSIXALPHA }   /* isalpha */,
  {    55,  3671,  9321,  17,   4, UNI_PHNX }   /* scriptextensions=phnx */,
  {     0,  9093,  2006,   4,   4, UNI_INMODI }   /* blk=modi */,
  {     0,  5760,  7435,  13,   2, UNI_NV__11 }   /* numericvalue=11 */,
  {     0,  9093,  2333,   4,  13, UNI_GLAGOLITICSUP }   /* blk=glagoliticsup */,
  {     0,  5422,     0,  13,   0, UNI_AEGEANNUMBERS }   /* aegeannumbers */,
  {     0,  8332,   697,   4,   2, UNI_ARMN }   /* isarmn */,
  {     0,  9108,     0,   2,   0, UNI_MC }   /* mc */,
  {     1,  2741,     0,  19,   0, UNI_MERO }   /* meroitichieroglyphs */,
  {     2,  9593,     0,   4,   0, UNI_BC__B }   /* bc=b */,
  {     0,  8233,  2484,   7,   4, UNI_SC__MAND }   /* script=mand */,
  {     3,  8886,  7980,   3,   8, UNI_UGAR }   /* sc=ugaritic */,
  {     1,  8424,  5734,   6,  13, UNI_MISCTECHNICAL }   /* block=misctechnical */,
  {     0,   184,  7916,   2,   8, UNI_MAHJ }   /* ismahajani */,
  {     2,  9365,  9145,   4,   4, UNI_DSRT }   /* scx=dsrt */,
  {     0,    21,  1622,   2,  14, UNI_LATINEXTA }   /* inlatinextendeda */,
  {     4,  5967,     0,   6,   0, UNI_HEBR }   /* hebrew */,
  {     1,  9093,  3416,   4,  10, UNI_ALCHEMICAL }   /* blk=alchemical */,
  {     1,  3671,  9157,  17,   4, UNI_GONG }   /* scriptextensions=gong */,
  {     2,  7788,     0,   8,   0, UNI_BALI }   /* balinese */,
  {     1,  9629,  8100,   3,   6, UNI_LB__HY }   /* lb=hyphen */,
  {    16,  9353,     0,   4,   0, UNI_RUNR }   /* runr */,
  {     4,  3671,  9390,  18,   3, UNI_SOGO }   /* scriptextensions=sogo */,
  {     0,  2085,     0,  21,   0, UNI_CYRILLICSUP }   /* cyrillicsupplementary */,
  {     1,  9237,     1,   4,   1, -UNI_LOE }   /* loe=n */,
  {     6,  8424,  1530,   6,  14, UNI_BYZANTINEMUSIC }   /* block=byzantinemusic */,
  {     0,  4580,  2780,   3,  18, UNI_MONGOLIANSUP }   /* inmongoliansupplement */,
  {    20,  4220,     0,   6,   0, UNI_TANG }   /* tangut */,
  {     0,  4580,   989,   3,   4, UNI_MUSIC }   /* inmusic */,
  {     0,  3671,  2148,  17,  21, UNI_PRTI }   /* scriptextensions=inscriptionalparthian */,
  {     9,  9623,  5666,   3,   3, UNI_JG__NUN }   /* jg=nun */,
  {     0,  8424,  7956,   6,   8, UNI_INTAGBANWA }   /* block=tagbanwa */,
  {     0,  9620,  6624,   3,  11, UNI_NO }   /* gc=othernumber */,
  {     0,  8424,  7916,   6,   8, UNI_INMAHAJANI }   /* block=mahajani */,
  {     0,  1136,  9734,  26,   3, UNI_DI }   /* defaultignorablecodepoint=yes */,
  {     0,  3884,     0,  16,   0, UNI_GEORGIANEXT }   /* georgianextended */,
  {     0,  8598,     3,   6,   1, -UNI__PERL_PATWS }   /* patws=f */,
  {     1,  9093,  3884,   4,  16, UNI_GEORGIANEXT }   /* blk=georgianextended */,
  {     0,  9093,  4268,   5,   4, UNI_INBAMUM }   /* blk=bamum */,
  {     0,  7338,     0,   9,   0, UNI_PERM }   /* oldpermic */,
  {    13,  8508,  9734,   6,   3, UNI_GREXT }   /* grext=yes */,
  {    97,  1497,    38,   9,   2, UNI_XPOSIXDIGIT }   /* category=nd */,
  {     9,  9647,  7692,   3,   8, UNI_NV__13_SLASH_2 }   /* nv=6.50e+00 */,
  {    21,  3671,  2532,  17,   6, UNI_BRAH }   /* scriptextensions=brahmi */,
  {    12,  6371,  9433,  11,   4, UNI_DEP }   /* deprecated=true */,
  {     0,  4821,    36,  14,   1, UNI_POSIXXDIGIT }   /* asciihexdigit=t */,
  {     1,  2874,     0,  19,   0, UNI_SUPARROWSB }   /* supplementalarrowsb */,
  {     8,  9365,  7347,   4,   9, UNI_ORKH }   /* scx=oldturkic */,
  {     0,   689,     0,  16,   0, UNI_CUNEIFORMNUMBERS }   /* cuneiformnumbers */,
  {     1,  6828,  4156,  10,  16, UNI_BC__S }   /* bidiclass=segmentseparator */,
  {     0,  1036,     0,   2,   0, UNI_CASEDLETTER }   /* lc */,
  {     1,  9113,  8785,   5,   4, UNI_CCC__28 }   /* ccc=ccc28 */,
  {     0,  3671,    78,  17,   6, UNI_ARAB }   /* scriptextensions=arabic */,
  {     0,  9647,  5409,   3,   4, UNI_NV__1000 }   /* nv=1000 */,
  {     1,  5760,  7732,  13,   8, UNI_NV__5_SLASH_6 }   /* numericvalue=8.33e-01 */,
  {     1,  2646,     0,  10,   0, UNI_JAMO }   /* hanguljamo */,
  {    20,  8233,  7248,   7,   9, UNI_SC__SIND }   /* script=khudawadi */,
  {     1,  1757,     3,  22,   1, -UNI_CWL }   /* changeswhenlowercased=f */,
  {     5,  3671,  9386,  18,   3, UNI_SHRD }   /* scriptextensions=shrd */,
  {     0,  9731,    73,   3,   2, UNI_WB__EB }   /* wb=em */,
  {     0,   184,  8128,   2,   7, UNI_MAKA }   /* ismakasar */,
  {     0,  9647,  7446,   3,   2, UNI_NV__25 }   /* nv=25 */,
  {     0,  1536,  2609,   3,  18, UNI_INEGYPTIANHIEROGLYPHS }   /* inegyptianhieroglyphs */,
  {     0,  9093,  7194,   4,   9, UNI_ARABICPFB }   /* blk=arabicpfb */,
  {     0,  8884,  2313,   5,  20, UNI_INSC__CONSONANTWITHSTACKER }   /* insc=consonantwithstacker */,
  {     2,  8233,  8226,   7,   7, UNI_SC__PHAG }   /* script=phagspa */,
  {    14,  9623,  6111,   3,  12, UNI_JG__MALAYALAMNYA }   /* jg=malayalamnya */,
  {    25,  9365,  9325,   4,   4, UNI_MIAO }   /* scx=plrd */,
  {     0,  4432,     0,  15,   0, UNI_DIACRITICALSSUP }   /* diacriticalssup */,
  {     1,    21,  7266,   2,   9, UNI_LATINEXTC }   /* inlatinextc */,
  {   131,   184,   995,   2,   2, UNI_NO }   /* isno */,
  {     0,  9647,  8973,   3,   4, UNI_NV__1_SLASH_10 }   /* nv=1/10 */,
  {     0,  4627,     0,  15,   0, UNI_nfkcqc_values_index }   /* nfkcquickcheck= */,
  {     0,  6816,  7204,   3,   8, UNI_INBHAIKSUKI }   /* inbhaiksuki */,
  {     0,  8233,  2930,   7,   4, UNI_CHER }   /* script=cher */,
  {     0,  3868,  1257,  16,   2, UNI_UPPERCASELETTER }   /* generalcategory=lu */,
  {    21,   117,  5553,   3,   5, UNI_IPAEXT }   /* inipaext */,
  {     4,   184,  9767,   2,   2, UNI_CASEDLETTER }   /* isl& */,
  {     1,  9626,  6470,   3,  11, UNI_JT__C }   /* jt=joincausing */,
  {     3,  6868,     0,  10,   0, UNI_COMPATJAMO }   /* compatjamo */,
  {     3,  1362,  8820,  25,   4, UNI_CCC__35 }   /* canonicalcombiningclass=ccc35 */,
  {     5,  9157,     0,   4,   0, UNI_GONG }   /* gong */,
  {     0,  7230,  9433,   9,   4, UNI_EXT }   /* extender=true */,
  {     0,  8959,     1,   5,   1, -UNI_XIDS }   /* xids=n */,
  {     0,  8884,  1434,   5,  24, UNI_INSC__CONSONANTSUCCEEDINGREPHA }   /* insc=consonantsucceedingrepha */,
  {     3,  1773,     0,   6,   0, UNI_cased_values_index }   /* cased= */,
  {     0,  8424,  2646,   6,  10, UNI_JAMO }   /* block=hanguljamo */,
  {     1,  9365,  4717,   4,   5, UNI_TAML }   /* scx=tamil */,
  {     8,  1362,  8725,  25,   4, UNI_CCC__16 }   /* canonicalcombiningclass=ccc16 */,
  {     2,  9620,  8839,   3,   5, UNI_XPOSIXCNTRL }   /* gc=cntrl */,
  {     0,  8617,     3,   5,   1, -UNI_TERM }   /* term=f */,
  {    26,  9365,  8303,   4,   7, UNI_TIBT }   /* scx=tibetan */,
  {     0,  8959,  9734,   5,   3, UNI_XIDS }   /* xids=yes */,
  {     1,  4447,     3,  15,   1, UNI_EA__F }   /* eastasianwidth=f */,
  {     0,  8424,  4717,   6,   5, UNI_INTAMIL }   /* block=tamil */,
  {     0,  5760,  9739,  13,   2, UNI_NV__39 }   /* numericvalue=39 */,
  {     0,  9365,  9089,   4,   4, UNI_BHKS }   /* scx=bhks */,
  {    21,  6003,     1,  12,   1, -UNI_JOINC }   /* joincontrol=n */,
  {     1,  5255,     0,  14,   0, UNI_MN }   /* nonspacingmark */,
  {     1,  8233,  9157,   7,   4, UNI_SC__GONG }   /* script=gong */,
  {     2,  2148,  2837,   3,  11, UNI_SUNDANESESUP }   /* insundanesesup */,
  {     9,  7018,  7463,  10,   1, UNI_IN__3 }   /* presentin=3 */,
  {     1,  3671,  1573,  17,   4, UNI_PHAG }   /* scriptextensions=phag */,
  {    11,   184,  2044,   3,  20, UNI_CJKCOMPATFORMS }   /* iscjkcompatibilityforms */,
  {     2,  3398,   995,  18,   2, -UNI_VS }   /* variationselector=no */,
  {     2,  9647,  7532,   3,   8, UNI_NV__1_SLASH_40 }   /* nv=2.50e-02 */,
  {     4,  3671,  3980,  17,   7, UNI_LINB }   /* scriptextensions=linearb */,
  {    40,  9153,    24,   4,   1, UNI_GCB__L }   /* gcb=l */,
  {     0,  8886,  6723,   3,  11, UNI_SC__SYLO }   /* sc=sylotinagri */,
  {     7,  9113,  9771,   4,   2, UNI_CCC__9 }   /* ccc=vr */,
  {     1,  9113,  1700,   4,   2, UNI_CCC__DB }   /* ccc=db */,
  {     0,  3254,     0,  18,   0, UNI_ri_values_index }   /* regionalindicator= */,
  {    16,    47,     0,   1,   0, UNI_M }   /* m */,
  {    16,  8884,  3948,   5,  16, UNI_INSC__INVISIBLESTACKER }   /* insc=invisiblestacker */,
  {     0,  9731,  1767,   3,   2, UNI_WB__NL }   /* wb=nl */,
  {     0,  9365,  2409,   4,   4, UNI_MONG }   /* scx=mong */,
  {     0,  5565,  4562,  13,   3, UNI_JG__SAD }   /* joininggroup=sad */,
  {     9,   184,  5955,   2,  12, UNI_GONG }   /* isgunjalagondi */,
  {     0,  5871,     0,  12,   0, UNI_CYRILLICEXTA }   /* cyrillicexta */,
  {     1,  1362,  7747,  24,   2, UNI_CCC__28 }   /* canonicalcombiningclass=28 */,
  {    33,  8303,     0,   7,   0, UNI_TIBT }   /* tibetan */,
  {     8,  3671,  9057,  17,   4, UNI_AHOM }   /* scriptextensions=ahom */,
  {     6,   184,   719,   2,  16, UNI_ENCLOSEDALPHANUM }   /* isenclosedalphanum */,
  {     1,  8424,  8944,   6,   5, UNI_INTAKRI }   /* block=takri */,
  {     3,  9909,  8839,   7,   5, UNI_POSIXCNTRL }   /* isposixcntrl */,
  {     1,  9365,  3110,   4,   4, UNI_GEOR }   /* scx=geor */,
  {     2,    18,     0,   2,   0, UNI_RI }   /* ri */,
  {     1,  8163,  8904,   7,   5, UNI_NFCQC__M }   /* nfkcqc=maybe */,
  {     8,  3002,  3308,  18,   5, UNI_DT__SML }   /* decompositiontype=small */,
  {    24,  7230,    26,   9,   1, UNI_EXT }   /* extender=y */,
  {     0,  8556,  8864,   6,   5, -UNI_XPOSIXLOWER }   /* lower=false */,
  {     0,  8233,  8303,   7,   7, UNI_TIBT }   /* script=tibetan */,
  {     5,  4705,  1791,   3,   4, UNI_TITLE }   /* istitle */,
  {    13,  8886,     0,   3,   0, UNI_sc_values_index }   /* sc= */,
  {     0,  6015,  6514,  12,  11, UNI_JT__L }   /* joiningtype=leftjoining */,
  {     3,  8051,     1,   7,   1, -UNI_COMPEX }   /* compex=n */,
  {     0,  9623,  5181,   3,   4, UNI_JG__TETH }   /* jg=teth */,
  {     1,  9659,  9734,   3,   3, UNI_RI }   /* ri=yes */,
  {     9,  4705,  2022,   3,  14, UNI_TRANSPORTANDMAP }   /* istransportandmap */,
  {     1,  3671,  7772,  17,   8, UNI_ARMN }   /* scriptextensions=armenian */,
  {     2,  4627,    47,  15,   1, UNI_NFCQC__M }   /* nfkcquickcheck=m */,
  {     2,  1924,  5592,  10,  12, UNI_ZL }   /* category=lineseparator */,
  {     6,  1362,  2920,  24,  10, UNI_CCC__AR }   /* canonicalcombiningclass=aboveright */,
  {     8,  6828,  3243,  10,  10, UNI_BC__WS }   /* bidiclass=whitespace */,
  {     1,  6828,  6255,  10,  12, UNI_BC__ON }   /* bidiclass=otherneutral */,
  {    33,  4778,  8318,   3,   6, UNI_UCASEXT }   /* isucasext */,
  {     2,  9623,  2561,   3,   9, UNI_JG__YEHBARREE }   /* jg=yehbarree */,
  {     0,  9365,  4267,   4,   5, UNI_BAMU }   /* scx=bamum */,
  {    26,  8424,  7338,   6,   9, UNI_INOLDPERMIC }   /* block=oldpermic */,
  {     0,  1911,  7028,  22,  10, UNI_INSC__PUREKILLER }   /* indicsyllabiccategory=purekiller */,
  {     0,   184,  3110,   2,   8, UNI_GEOR }   /* isgeorgian */,
  {    18,  3868,  9767,  16,   2, UNI_CASEDLETTER }   /* generalcategory=l& */,
  {    10,  2211,     0,   7,   0, UNI_SINH }   /* sinhala */,
  {     0,  3868,  5353,  16,  14, UNI_ZS }   /* generalcategory=spaceseparator */,
  {     2,  9093,  2836,   4,   9, UNI_INSUNDANESE }   /* blk=sundanese */,
  {     0,  8233,  8065,   7,   7, UNI_ELBA }   /* script=elbasan */,
  {     3,  8886,  8072,   3,   4, UNI_ELYM }   /* sc=elym */,
  {     0,  9623,  9381,   3,   4, UNI_JG__SHIN }   /* jg=shin */,
  {     1,  9049,     0,   4,   0, UNI_age_values_index }   /* age= */,
  {     3,  8869,    36,   5,   1, UNI_IDSB }   /* idsb=t */,
  {     2,  8879,  3344,   5,  18, UNI_INPC__TOPANDLEFTANDRIGHT }   /* inpc=topandleftandright */,
  {     6,  3951,    59,   3,   3, UNI_IDEO }   /* isideo */,
  {     0,   184,  8845,   3,   3, UNI_CWCF }   /* iscwcf */,
  {     0,  3671,  9409,  17,   4, UNI_TAML }   /* scriptextensions=taml */,
  {     0,  9093,  3450,   4,  17, UNI_UCAS }   /* blk=canadiansyllabics */,
  {     1,  8233,  8142,   7,   4, UNI_MARC }   /* script=marc */,
  {     1,  5565,  5087,  13,  14, UNI_JG__MANICHAEANBETH }   /* joininggroup=manichaeanbeth */,
  {     0,  6371,  8864,  11,   5, -UNI_DEP }   /* deprecated=false */,
  {    17,  9593,  9632,   3,   3, UNI_BC__LRE }   /* bc=lre */,
  {    26,  1757,     0,  21,   0, UNI_CWL }   /* changeswhenlowercased */,
  {     0,  1773,     1,   6,   1, -UNI_CASED }   /* cased=n */,
  {    48,  8424,  3290,   6,  18, UNI_RUMI }   /* block=ruminumeralsymbols */,
  {     0,  3868,    45,  16,   2, UNI_CO }   /* generalcategory=co */,
  {     3,  7804,     0,   4,   0, UNI_BUGI }   /* bugi */,
  {     0,  9731,   138,   3,   2, UNI_WB__FO }   /* wb=fo */,
  {     0,  9647,  9560,   3,   3, UNI_NV__4_SLASH_5 }   /* nv=4/5 */,
  {     3,  4204,     0,   9,   0, UNI_SYRIACSUP }   /* syriacsup */,
  {   139,  8886,  5311,   3,  14, UNI_SC__PHLP }   /* sc=psalterpahlavi */,
  {    36,  9365,  9409,   4,   4, UNI_TAML }   /* scx=taml */,
  {     3,  9049,  9449,   4,   4, UNI_AGE__12_DOT_1 }   /* age=v121 */,
  {     9,  8332,    80,   4,   8, UNI_ARABICMATH }   /* isarabicmath */,
  {     1,  8955,     0,   4,   0, UNI_idc_values_index }   /* idc= */,
  {     1,  6267,     0,   8,   0, UNI_PHAISTOS }   /* phaistos */,
  {     0,  1773,  8864,   6,   5, -UNI_CASED }   /* cased=false */,
  {     0,  8886,  6558,   3,  11, UNI_MEDF }   /* sc=medefaidrin */,
  {     1,  8496,  9734,   6,   3, UNI_CWKCF }   /* cwkcf=yes */,
  {    24,  7128,  4645,  10,   2, UNI_WB__DQ }   /* wordbreak=dq */,
  {     0,  8424,  7058,   6,  10, UNI_SMALLFORMS }   /* block=smallforms */,
  {    12,  1482,  2473,  24,   3, UNI_INPC__TOP }   /* indicpositionalcategory=top */,
  {     0,  9647,  5409,   3,   9, UNI_NV__100000000 }   /* nv=100000000 */,
  {     2,  6885,  3933,   3,  15, UNI_HIGHPUSURROGATES }   /* ishighpusurrogates */,
  {     3,  3671,  9493,  17,   4, UNI_ZZZZ }   /* scriptextensions=zzzz */,
  {     3,  8556,     1,   6,   1, -UNI_XPOSIXLOWER }   /* lower=n */,
  {     0,  8100,   995,   7,   2, -UNI_HYPHEN }   /* hyphen=no */,
  {     0,  2204,  6625,   3,  10, UNI_NO }   /* isothernumber */,
  {     0,  2204,  7340,   4,   7, UNI_PERM }   /* isoldpermic */,
  {     6,   184,  6039,   2,  12, UNI_NL }   /* isletternumber */,
  {    31,  5339,  8694,  14,   5, UNI_SB__AT }   /* sentencebreak=aterm */,
  {     0,  6828,  2433,  10,  20, UNI_BC__RLE }   /* bidiclass=righttoleftembedding */,
  {     0,  3243,  9433,  11,   4, UNI_XPOSIXSPACE }   /* whitespace=true */,
  {    16,  6918,  1767,  10,   2, UNI_LB__NL }   /* linebreak=nl */,
  {    10,   117,  3588,   4,  15, UNI_INDICSIYAQNUMBERS }   /* inindicsiyaqnumbers */,
  {     1,  1362,  8909,  24,   5, UNI_CCC__7 }   /* canonicalcombiningclass=nukta */,
  {    21,  8424,  1824,   7,  18, UNI_CJKCOMPATIDEOGRAPHS }   /* block=cjkcompatideographs */,
  {     0,  9049,  9548,   4,   3, UNI_AGE__3 }   /* age=3.0 */,
  {     2,  8496,  9433,   6,   4, UNI_CWKCF }   /* cwkcf=true */,
  {     0,  9093,  7956,   4,   8, UNI_INTAGBANWA }   /* blk=tagbanwa */,
  {    28,  1812,     0,   5,   0, UNI_XPOSIXUPPER }   /* upper */,
  {     1,  2204,  4674,   4,  13, UNI_SARB }   /* isoldsoutharabian */,
  {    16,  8233,  8610,   7,   6, UNI_RJNG }   /* script=rejang */,
  {     0,  8424,  6859,   7,   9, UNI_CJKSTROKES }   /* block=cjkstrokes */,
  {    35,  4580,     0,  17,   0, UNI_INMEROITICCURSIVE }   /* inmeroiticcursive */,
  {     5,  9593,   102,   3,   2, UNI_BC__ET }   /* bc=et */,
  {     0,  7420,     3,   8,   1, -UNI_IDS }   /* idstart=f */,
  {     1,  8884,  4702,   5,  15, UNI_INSC__REGISTERSHIFTER }   /* insc=registershifter */,
  {     0,  9647,  9572,   3,   3, UNI_NV__5_SLASH_8 }   /* nv=5/8 */,
  {    65,  8886,  8484,   3,   6, UNI_SC__CAKM }   /* sc=chakma */,
  {     0,  7018,  9704,  10,   3, UNI_IN__6 }   /* presentin=v60 */,
  {     7,  8424,  2086,   7,  17, UNI_CYRILLICSUP }   /* block=cyrillicsupplement */,
  {     1,  6371,     0,  11,   0, UNI_dep_values_index }   /* deprecated= */,
  {     1,  9365,  9301,   4,   4, UNI_ORKH }   /* scx=orkh */,
  {     5,  1530,     0,  23,   0, UNI_BYZANTINEMUSIC }   /* byzantinemusicalsymbols */,
  {     0,  9946,  9394,   3,   3, UNI_SYRC }   /* issyrc */,
  {     0,  9647,  8388,   3,   3, UNI_NV__700 }   /* nv=700 */,
  {     5,   184,  4267,   2,  15, UNI_BAMUMSUP }   /* isbamumsupplement */,
  {     4,  9113,  8740,   5,   4, UNI_CCC__19 }   /* ccc=ccc19 */,
  {     3,  3736,  7846,   4,   6, UNI_INGUJARATI }   /* ingujarati */,
  {     0,  9901,  5492,   8,   5, UNI_XPOSIXALNUM }   /* isxposixalnum */,
  {     0,  9647,  7539,   3,   2, UNI_NV__22 }   /* nv=22 */,
  {     0,   184,  2484,   2,   4, UNI_MAND }   /* ismand */,
  {     0,  3002,  8490,  18,   6, UNI_DT__ENC }   /* decompositiontype=circle */,
  {     0,  5565,  6120,  13,   3, UNI_JG__NYA }   /* joininggroup=nya */,
  {     2,  9365,  8709,   4,   5, UNI_BUHD }   /* scx=buhid */,
  {     1,  9113,  8815,   5,   4, UNI_CCC__34 }   /* ccc=ccc34 */,
  {     2,  8424,  2211,   6,  21, UNI_SINHALAARCHAICNUMBERS }   /* block=sinhalaarchaicnumbers */,
  {     1,  8886,  4582,   3,  15, UNI_MERC }   /* sc=meroiticcursive */,
  {     4,   184,   921,   2,  28, UNI_VSSUP }   /* isvariationselectorssupplement */,
  {    26,  1362,  8805,  25,   4, UNI_CCC__32 }   /* canonicalcombiningclass=ccc32 */,
  {     4,   184,  6690,   2,  11, UNI_SORA }   /* issorasompeng */,
  {    18,  8520,  8864,   6,   5, -UNI_JOINC }   /* joinc=false */,
  {     0,  7018,  8993,  10,   4, UNI_IN__10 }   /* presentin=10.0 */,
  {     1,  8886,  7365,   3,   9, UNI_PAUC }   /* sc=paucinhau */,
  {    40,  6768,  6768,   3,  10, UNI_YISYLLABLES }   /* isyisyllables */,
  {     0,  6315,     1,  12,   1, -UNI_XIDC }   /* xidcontinue=n */,
  {    37,  1158,  3327,   3,  17, UNI_TAIXUANJING }   /* intaixuanjingsymbols */,
  {    34,   184,  8568,   2,   6, UNI_LYDI }   /* islydian */,
  {     1,  9629,    58,   3,   2, UNI_LB__ID }   /* lb=id */,
  {    13,    57,     0,   2,   0, UNI_YI }   /* yi */,
  {     1,  8849,    26,   5,   1, UNI_CWCM }   /* cwcm=y */,
  {     3,  9647,  7580,   3,   8, UNI_NV__7_SLASH_2 }   /* nv=3.50e+00 */,
  {     1,   184,  5860,   3,  11, UNI_CHESSSYMBOLS }   /* ischesssymbols */,
  {     0,  8424,  2957,   6,   9, UNI_HALFMARKS }   /* block=halfmarks */,
  {     1,  1362,  8467,  25,   4, UNI_CCC__13 }   /* canonicalcombiningclass=ccc13 */,
  {     5,  8884,  4919,   5,  14, UNI_INSC__GEMINATIONMARK }   /* insc=geminationmark */,
  {   178,  1450,  3662,   4,   5, UNI_INGRANTHA }   /* ingrantha */,
  {     1,  8233,  7852,   7,   8, UNI_SC__GURU }   /* script=gurmukhi */,
  {     0,  8163,  9734,   7,   3, UNI_NFKCQC__Y }   /* nfkcqc=yes */,
  {     3,  8233,  3729,   8,  10, UNI_SGNW }   /* script=signwriting */,
  {     2,  8886,  8502,   3,   6, UNI_GOTH }   /* sc=gothic */,
  {     0,  1239,     0,  25,   0, UNI_compex_values_index }   /* fullcompositionexclusion= */,
  {     0,   184,  1141,   2,   2, UNI_TITLE }   /* islt */,
  {    17,  3951,  3129,   3,   3, UNI_IDSB }   /* isidsb */,
  {    16,  8635,     1,   5,   1, -UNI_IDEO }   /* ideo=n */,
  {     0,  4447,     8,  15,   1, UNI_EA__A }   /* eastasianwidth=a */,
  {     1,  9230,  5450,   4,  11, UNI_BLOCKELEMENTS }   /* inblockelements */,
  {     0,  8338,     0,   7,   0, UNI_wspace_values_index }   /* wspace= */,
  {    21,  1911,  4140,  22,   5, UNI_INSC__OTHER }   /* indicsyllabiccategory=other */,
  {     1,  1362,  8830,  25,   4, UNI_CCC__84 }   /* canonicalcombiningclass=ccc84 */,
  {    82,  8886,  8944,   3,   4, UNI_SC__TAKR }   /* sc=takr */,
  {     8,  9659,  9433,   3,   4, UNI_RI }   /* ri=true */,
  {     0,  8886,  4204,   3,   6, UNI_SC__SYRC }   /* sc=syriac */,
  {     4,  1539,     0,  14,   0, UNI_MUSIC }   /* musicalsymbols */,
  {     1,  8844,   995,   5,   2, -UNI_CWCF }   /* cwcf=no */,
  {     0,   978,     0,   2,   0, UNI_CI }   /* ci */,
  {     2,  6918,    23,  10,   2, UNI_LB__AL }   /* linebreak=al */,
  {     0,  8949,     0,   5,   0, UNI_VSSUP }   /* vssup */,
  {     0,  3671,  3620,  17,  10, UNI_MANI }   /* scriptextensions=manichaean */,
  {     4,  9113,   726,   4,   2, UNI_CCC__DA }   /* ccc=da */,
  {     0,   921,     0,  17,   0, UNI_VS }   /* variationselector */,
  {     2,  9365,  6027,   4,   5, UNI_KHMR }   /* scx=khmer */,
  {     1,  9647,  5409,   3,  13, UNI_NV__1000000000000 }   /* nv=1000000000000 */,
  {     1,  8233,  9257,   7,   4, UNI_SC__MLYM }   /* script=mlym */,
  {     0,  9113,  9515,   4,   3, UNI_CCC__214 }   /* ccc=214 */,
  {     9,   184,  7796,   2,   8, UNI_BASS }   /* isbassavah */,
  {     0,  8233,  7049,   8,   3, UNI_SAUR }   /* script=saur */,
  {     3,     0,     0,  34,   0, UNI_UCAS }   /* unifiedcanadianaboriginalsyllabics */,
  {     0,  9620,  1187,   3,   2, UNI_SK }   /* gc=sk */,
  {     1,  7018,  7612,  10,   3, UNI_IN__4_DOT_1 }   /* presentin=4.1 */,
  {     0,   184,  4829,   2,   5, UNI_XPOSIXDIGIT }   /* isdigit */,
  {    32,  8233,  4220,   7,   6, UNI_TANG }   /* script=tangut */,
  {    13,  9093,    42,   4,  36, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* blk=cjkcompatibilityideographssupplement */,
  {     1,   184,  6051,   2,  12, UNI_MAHJONG }   /* ismahjongtiles */,
  {    77,  8424,  5552,   6,  13, UNI_IPAEXT }   /* block=ipaextensions */,
  {     0,  6928,    26,  10,   1, UNI_XPOSIXLOWER }   /* lowercase=y */,
  {     0,  7108,    26,  10,   1, UNI_XPOSIXUPPER }   /* uppercase=y */,
  {    32,  1779,    26,  22,   1, UNI_CWT }   /* changeswhentitlecased=y */,
  {     0,   184,   837,   2,  18, UNI_PHONETICEXT }   /* isphoneticextensions */,
  {     2,  5565,  7828,  13,   8, UNI_JG__FARSIYEH }   /* joininggroup=farsiyeh */,
  {    32,   184,  8135,   2,   7, UNI_MAND }   /* ismandaic */,
  {    98,  5760,  8985,  13,   4, UNI_NV__1_SLASH_64 }   /* numericvalue=1/64 */,
  {    83,  8424,  9425,   6,   4, UNI_INTHAI }   /* block=thai */,
  {     1,  8424,  9650,   6,   3, UNI_OCR }   /* block=ocr */,
  {     0,  9049,  9683,   4,   3, UNI_AGE__3_DOT_1 }   /* age=v31 */,
  {     6,  1482,  1869,   4,  10, UNI_DIACRITICALS }   /* indiacriticals */,
  {    16,  9365,  7356,   4,   4, UNI_PALM }   /* scx=palm */,
  {   142,  9141,     3,   4,   1, -UNI_DIA }   /* dia=f */,
  {     0,  3868,  4747,  16,  15, UNI_UPPERCASELETTER }   /* generalcategory=uppercaseletter */,
  {     4,  1911,  6225,  22,   6, UNI_LB__ZWJ }   /* indicsyllabiccategory=joiner */,
  {     0,   184,  3020,   2,  13, UNI_DEVANAGARIEXT }   /* isdevanagariext */,
  {    19,  8430,     0,   6,   0, UNI_CARI }   /* carian */,
  {     0,  9365,  8002,   4,   7, UNI_BENG }   /* scx=bengali */,
  {     9,  9093,  2232,   4,  21, UNI_YIJING }   /* blk=yijinghexagramsymbols */,
  {    92,  9647,  9033,   3,   3, UNI_NV__3_SLASH_8 }   /* nv=3/8 */,
  {     0,  9647,  8382,   3,   5, UNI_NV__60000 }   /* nv=60000 */,
  {     0,  6885,     8,   3,   2, UNI_HAN }   /* ishan */,
  {     0,  8879,     0,   5,   0, UNI_inpc_values_index }   /* inpc= */,
  {     0,  5565,  4044,  13,  16, UNI_JG__MANICHAEANSAMEKH }   /* joininggroup=manichaeansamekh */,
  {     4,  8580,     3,   6,   1, -UNI__PERL_NCHAR }   /* nchar=f */,
  {     8,  8424,  4417,   6,  15, UNI_DIACRITICALSEXT }   /* block=diacriticalsext */,
  {     0,  2106,  9611,  21,   3, UNI_WB__EB }   /* graphemeclusterbreak=ebg */,
  {     6,  7128,  7284,  10,   9, UNI_WB__ML }   /* wordbreak=midletter */,
  {     2,   184,  3243,   2,  10, UNI_XPOSIXSPACE }   /* iswhitespace */,
  {     1,  8086,    36,   7,   1, UNI_GRBASE }   /* grbase=t */,
  {     1,  3671,  9485,  17,   4, UNI_QAAI }   /* scriptextensions=zinh */,
  {     0,  1362,  2373,  24,   4, UNI_CCC__L }   /* canonicalcombiningclass=left */,
  {     0,  8424,  1411,   7,  23, UNI_DIACRITICALSFORSYMBOLS }   /* block=combiningmarksforsymbols */,
  {     0,  6472,  3716,   4,   4, UNI_INCARIAN }   /* incarian */,
  {     4,   184,   719,   2,  21, UNI_ENCLOSEDALPHANUM }   /* isenclosedalphanumerics */,
  {     3,  2204,  6245,   4,  10, UNI_HUNG }   /* isoldhungarian */,
  {     0,  8869,    26,   5,   1, UNI_IDSB }   /* idsb=y */,
  {     1,  6885,  2958,   3,   8, UNI_HALFMARKS }   /* ishalfmarks */,
  {    36,  6918,    96,  10,  10, UNI_LB__AL }   /* linebreak=alphabetic */,
  {    64,  7852,     0,   8,   0, UNI_GURU }   /* gurmukhi */,
  {     0,  6816,  4268,   3,   4, UNI_INBAMUM }   /* inbamum */,
  {    29,  8839,     0,   5,   0, UNI_XPOSIXCNTRL }   /* cntrl */,
  {     0,  8424,  5552,   6,   6, UNI_IPAEXT }   /* block=ipaext */,
  {     0,  9629,  7909,   4,   7, UNI_LB__LF }   /* lb=linefeed */,
  {     0,  9093,  7204,   5,   8, UNI_INBHAIKSUKI }   /* blk=bhaiksuki */,
  {     0,   184,  4267,   2,   5, UNI_BAMU }   /* isbamum */,
  {     2,  2684,  6503,  19,  11, UNI_GCB__L }   /* hangulsyllabletype=leadingjamo */,
  {     0,  9620,  4402,   3,  15, UNI_PD }   /* gc=dashpunctuation */,
  {    11,    74,     0,   2,   0, UNI_ME }   /* me */,
  {     3,  9623,  5101,   3,  14, UNI_JG__MANICHAEANFIVE }   /* jg=manichaeanfive */,
  {     1,  8886,  9289,   3,   4, UNI_NSHU }   /* sc=nshu */,
  {     1,  2204,  8930,   3,   4, UNI_OSGE }   /* isosage */,
  {    16,  3868,  6039,  16,  12, UNI_NL }   /* generalcategory=letternumber */,
  {    20,  3671,  9349,  17,   4, UNI_ROHG }   /* scriptextensions=rohg */,
  {     2,   184,   114,   3,  34, UNI_DIACRITICALSFORSYMBOLS }   /* iscombiningdiacriticalmarksforsymbols */,
  {     1,   184,  9257,   2,   4, UNI_MLYM }   /* ismlym */,
  {     0,  9623,  5617,   3,  13, UNI_JG__MALAYALAMLLLA }   /* jg=malayalamllla */,
  {     3,  9620,  1472,   3,   9, UNI__PERL_SURROGATE }   /* gc=surrogate */,
  {    64,  1497,     1,   9,   1, UNI_N }   /* category=n */,
  {     0,  8424,  4267,   6,   8, UNI_BAMUMSUP }   /* block=bamumsup */,
  {    28,  2148,  2212,   3,   6, UNI_INSINHALA }   /* insinhala */,
  {     2,  2333,     0,   4,   0, UNI_GLAG }   /* glag */,
  {     3,  5339,     5,  15,   1, UNI_SB__SE }   /* sentencebreak=se */,
  {     1,  8959,   995,   5,   2, -UNI_XIDS }   /* xids=no */,
  {     0,  8960,     0,   4,   0, UNI_ids_values_index }   /* ids= */,
  {     1,  9093,  2169,   4,  21, UNI_MEETEIMAYEKEXT }   /* blk=meeteimayekextensions */,
  {     1,   122,     0,   9,   0, UNI_DIA }   /* diacritic */,
  {     0,  8520,     0,   6,   0, UNI_joinc_values_index }   /* joinc= */,
  {     1,  1362,  2912,  24,  13, UNI_CCC__214 }   /* canonicalcombiningclass=attachedabove */,
  {     4,  2148,  3309,   3,  11, UNI_SMALLKANAEXT }   /* insmallkanaext */,
  {     2,  1362,  7611,  24,   2, UNI_CCC__14 }   /* canonicalcombiningclass=14 */,
  {     3,  9365,  9390,   5,   3, UNI_SOGO }   /* scx=sogo */,
  {     0,  7860,     0,   8,   0, UNI_HIRA }   /* hiragana */,
  {    86,  8884,  4236,   5,  16, UNI_INSC__VOWELINDEPENDENT }   /* insc=vowelindependent */,
  {     0,  8233,  6051,   7,   4, UNI_SC__MAHJ }   /* script=mahj */,
  {    16,  8233,  3038,   7,   4, UNI_ETHI }   /* script=ethi */,
  {     1,  5835,     1,  12,   1, -UNI_BIDIC }   /* bidicontrol=n */,
  {     2,  6828,  3056,  10,  18, UNI_BC__ET }   /* bidiclass=europeanterminator */,
  {    20,  9093,  8303,   4,   7, UNI_INTIBETAN }   /* blk=tibetan */,
  {     1,  8233,  8250,  10,   4, UNI_SHAW }   /* script=shavian */,
  {     1,  6003,    36,  12,   1, UNI_JOINC }   /* joincontrol=t */,
  {     1,  9093,  4762,   4,  15, UNI_VEDICEXT }   /* blk=vedicextensions */,
  {     0,  4241,  3022,   4,  11, UNI_DEVANAGARIEXT }   /* indevanagariext */,
  {     0,  6005,  1387,   3,  23, UNI_CJKSYMBOLS }   /* incjksymbolsandpunctuation */,
  {     1,  8884,  4891,   5,  14, UNI_INSC__CONSONANTFINAL }   /* insc=consonantfinal */,
  {    12,  9093,  3518,   4,  17, UNI_CYRILLICEXTB }   /* blk=cyrillicextendedb */,
  {     2,  4447,  7176,  15,   9, UNI_EA__A }   /* eastasianwidth=ambiguous */,
  {     0,  3671,  8622,  17,   4, UNI_TELU }   /* scriptextensions=telu */,
  {    48,  9049,  7435,   4,   2, UNI_AGE__11 }   /* age=11 */,
  {     0,  6492,     0,  11,   0, UNI_KATAKANAEXT }   /* katakanaext */,
  {     5,  1536,  8073,   3,   6, UNI_INELYMAIC }   /* inelymaic */,
  {     0,  8205,     0,   4,   0, UNI_OSMA }   /* osma */,
  {     2,  9365,  7860,   4,   4, UNI_HIRA }   /* scx=hira */,
  {     0,  1362,  7540,  24,   3, UNI_WB__EB }   /* canonicalcombiningclass=200 */,
  {    14,   184,  8128,   2,   4, UNI_MAKA }   /* ismaka */,
  {     2,  8886,  6183,   3,  12, UNI_MEND }   /* sc=mendekikakui */,
  {     3,  9093,  7916,   4,   8, UNI_INMAHAJANI }   /* blk=mahajani */,
  {     8,  8233,  2532,   7,   4, UNI_BRAH }   /* script=brah */,
  {     0,  1497,   400,   9,   6, UNI_CF }   /* category=format */,
  {     0,  9093,  7347,   4,   9, UNI_INOLDTURKIC }   /* blk=oldturkic */,
  {     7,  9629,  6448,   3,  11, UNI_LB__IN }   /* lb=inseparable */,
  {     2,  3868,  4387,  16,  14, UNI_SC }   /* generalcategory=currencysymbol */,
  {     0,  9620,   698,   3,   6, UNI_N }   /* gc=number */,
  {     3,  8424,  2127,   6,  14, UNI_INHANIFIROHINGYA }   /* block=hanifirohingya */,
  {    20,  9113,  8810,   5,   4, UNI_CCC__33 }   /* ccc=ccc33 */,
  {     0,  5760,  8669,  13,   4, UNI_NV__1_SLASH_32 }   /* numericvalue=1/32 */,
  {    14,  5835,     0,  12,   0, UNI_bidic_values_index }   /* bidicontrol= */,
  {     1,  9137,     1,   4,   1, -UNI_DEP }   /* dep=n */,
  {     3,    21,  1622,   2,   9, UNI_LATINEXTE }   /* inlatinexte */,
  {    28,  9113,  8473,   5,   5, UNI_CCC__132 }   /* ccc=ccc132 */,
  {     0,  3002,   567,  18,   2, UNI_DT__NB }   /* decompositiontype=nb */,
  {     0,  1362,  8475,  24,   3, UNI_CCC__132 }   /* canonicalcombiningclass=132 */,
  {     0,  8580,    17,   7,   1, -UNI__PERL_NCHAR }   /* nchar=no */,
  {     5,  9593,  2722,   3,  19, UNI_BC__LRO }   /* bc=lefttorightoverride */,
  {     0,  2760,     0,  19,   0, UNI_MODIFIERTONELETTERS }   /* modifiertoneletters */,
  {     1,  8424,  6798,   6,  10, UNI_ARABICEXTA }   /* block=arabicexta */,
  {     0,  8233,  7239,   7,   9, UNI_SC__QAAI }   /* script=inherited */,
  {     3,  9365,    78,   4,   6, UNI_ARAB }   /* scx=arabic */,
  {     0,  8233,  9394,   8,   3, UNI_SC__SYRC }   /* script=syrc */,
  {     0,  8886,  8261,   3,   4, UNI_SOYO }   /* sc=soyo */,
  {    76,  9093,  1506,   4,  24, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* blk=supsymbolsandpictographs */,
  {     0,  8959,    36,   5,   1, UNI_XIDS }   /* xids=t */,
  {    16,  1801,   995,  22,   2, -UNI_CWU }   /* changeswhenuppercased=no */,
  {     3,  4705,  2456,   5,  16, UNI_TERM }   /* isterminalpunctuation */,
  {     0,  9093,  2957,   4,   9, UNI_HALFMARKS }   /* blk=halfmarks */,
  {     1,  1911,   698,  22,   6, UNI_INSC__NUMBER }   /* indicsyllabiccategory=number */,
  {     5,  9205,     0,   4,   0, UNI_KNDA }   /* knda */,
  {     1,  3671,  8709,  17,   5, UNI_BUHD }   /* scriptextensions=buhid */,
  {     0,  9901,  6316,   3,  10, UNI_XIDC }   /* isxidcontinue */,
  {     4,  8233,  8262,   8,   3, UNI_SOYO }   /* script=soyo */,
  {   156,  9623,  3620,   3,  17, UNI_JG__MANICHAEANDHAMEDH }   /* jg=manichaeandhamedh */,
  {     2,  4580,  4109,   3,   6, UNI_INMYANMAR }   /* inmyanmar */,
  {     1,  4849,     3,  14,   1, -UNI_CI }   /* caseignorable=f */,
  {     1,  8886,  4946,   3,   4, UNI_CHAM }   /* sc=cham */,
  {     2,  7018,  7159,  10,   1, UNI_IN__5 }   /* presentin=5 */,
  {    31,   184,  1999,   2,  22, UNI_MODIFIERLETTERS }   /* isspacingmodifierletters */,
  {     0,  5565,  4552,  13,  15, UNI_JG__MANICHAEANSADHE }   /* joininggroup=manichaeansadhe */,
  {     5,  9365,  8142,   4,   7, UNI_MARC }   /* scx=marchen */,
  {     9,  8332,  2238,   3,   3, UNI_POSIXXDIGIT }   /* isahex */,
  {   258,  9946,  3984,   3,   3, UNI_SARB }   /* issarb */,
  {     4,  7365,     0,   4,   0, UNI_PAUC }   /* pauc */,
  {     1,  9093,  2006,   4,  15, UNI_MODIFIERLETTERS }   /* blk=modifierletters */,
  {     0,  1362,  7502,  24,   1, UNI_CCC__8 }   /* canonicalcombiningclass=8 */,
  {     0,  2106,  4140,  21,   5, UNI_GCB__XX }   /* graphemeclusterbreak=other */,
  {     0,  8635,     0,   5,   0, UNI_ideo_values_index }   /* ideo= */,
  {     2,   184,  1714,   3,  20, UNI_CWCF }   /* ischangeswhencasefolded */,
  {    26,  3820,     0,  16,   0, UNI_PE }   /* closepunctuation */,
  {     4,   184,  7892,   2,   8, UNI_JAVA }   /* isjavanese */,
  {     0,  3671,  2127,  17,   4, UNI_HAN }   /* scriptextensions=hani */,
  {     0,  6231,  5678,  12,   4, UNI_NV__NAN }   /* numerictype=none */,
  {     7,  9093,  2333,   4,  20, UNI_GLAGOLITICSUP }   /* blk=glagoliticsupplement */,
  {     1,  9113,  9077,   4,   4, UNI_WB__EB }   /* ccc=atbl */,
  {     1,  8424,  4175,   6,  13, UNI_MATHOPERATORS }   /* block=mathoperators */,
  {    33,  1911,  4327,  22,  15, UNI_INSC__CONSONANTKILLER }   /* indicsyllabiccategory=consonantkiller */,
  {     0,  6918,  6349,  10,  11, UNI_LB__BB }   /* linebreak=breakbefore */,
  {     1,  9093,  4582,   4,  15, UNI_INMEROITICCURSIVE }   /* blk=meroiticcursive */,
  {    10,  1801,  8864,  22,   5, -UNI_CWU }   /* changeswhenuppercased=false */,
  {     1,  2627,     0,  19,   0, UNI_ENCLOSEDALPHANUMSUP }   /* enclosedalphanumsup */,
  {     1,  8886,  2253,   3,  20, UNI_HLUW }   /* sc=anatolianhieroglyphs */,
  {     3,  2457,   952,   5,  24, UNI_ALPHABETICPF }   /* inalphabeticpresentationforms */,
  {     9,  8894,     0,   4,   0, UNI_LIMB }   /* limb */,
  {     6,  4580,  1540,   3,  13, UNI_MUSIC }   /* inmusicalsymbols */,
  {     7,  3671,  9173,  17,   4, UNI_GURU }   /* scriptextensions=guru */,
  {     1,  8879,  5312,   3,  13, UNI_INPSALTERPAHLAVI }   /* inpsalterpahlavi */,
  {     3,  9647,  7502,   3,   1, UNI_NV__8 }   /* nv=8 */,
  {     1,  9623,  6785,   3,   2, UNI_JG__FE }   /* jg=fe */,
  {     1,  9647,  8364,   3,   2, UNI_NV__40 }   /* nv=40 */,
  {     1,   184,  6003,   2,  11, UNI_JOINC }   /* isjoincontrol */,
  {     0,  9647,  7604,   3,   8, UNI_NV__2_SLASH_5 }   /* nv=4.00e-01 */,
  {     1,  8412,    36,   6,   1, UNI_BIDIC }   /* bidic=t */,
  {     1,  9049,  9686,   4,   3, UNI_AGE__3_DOT_2 }   /* age=v32 */,
  {     0,  9365,  9489,   4,   4, UNI_ZYYY }   /* scx=zyyy */,
  {     2,  5760,  7540,  13,   8, UNI_NV__20000000 }   /* numericvalue=20000000 */,
  {     0,  3868,  5258,  16,  11, UNI_MC }   /* generalcategory=spacingmark */,
  {     0,  5269,  8864,  14,   5, -UNI_PATSYN }   /* patternsyntax=false */,
  {     1,  3620,     0,  10,   0, UNI_MANI }   /* manichaean */,
  {     2,  8886,  8310,   3,   7, UNI_SC__TIRH }   /* sc=tirhuta */,
  {     0,  2708,   833,   4,   4, UNI_ARROWS }   /* inarrows */,
  {     0,  1482,  2379,  24,   5, UNI_INPC__RIGHT }   /* indicpositionalcategory=right */,
  {     0,  5193,     0,   3,   0, UNI_ANY }   /* any */,
  {     3,  9909,   879,   3,   9, UNI_CO }   /* isprivateuse */,
  {     3,  1924,  1015,  10,   5, UNI_L }   /* category=letter */,
  {     0,  9113,  7723,   4,   2, UNI_CCC__18 }   /* ccc=18 */,
  {     0,   184,  1622,   2,   9, UNI_LATINEXTE }   /* islatinexte */,
  {    21,  9365,  8538,   4,   6, UNI_KHOJ }   /* scx=khojki */,
  {     0,  8424,  2169,   6,  14, UNI_MEETEIMAYEKEXT }   /* block=meeteimayekext */,
  {     1,   184,  9777,   2,   2, UNI_ZP }   /* iszp */,
  {     3,  3293,  8318,   3,   6, UNI_UCASEXT }   /* inucasext */,
  {     4,  2204,  6614,   3,  10, UNI_LO }   /* isotherletter */,
  {     3,  9093,  1386,   4,  10, UNI_CJKSYMBOLS }   /* blk=cjksymbols */,
  {     0,  8886,  6723,   3,   4, UNI_SC__SYLO }   /* sc=sylo */,
  {     2,  5760,  7684,  13,   8, UNI_NV__1_SLASH_160 }   /* numericvalue=6.25e-03 */,
  {     0,  9093,  6027,   4,  12, UNI_KHMERSYMBOLS }   /* blk=khmersymbols */,
  {     1,  5760,  8664,  13,   5, UNI_NV__1_SLASH_160 }   /* numericvalue=1/160 */,
  {     5,  9620,   467,   3,  11, UNI_P }   /* gc=punctuation */,
  {     4,  9647,  1219,   3,   3, UNI_NV__NAN }   /* nv=nan */,
  {    12,  5955,     0,  12,   0, UNI_GONG }   /* gunjalagondi */,
  {     3,  6888,   995,  10,   2, -UNI_DIA }   /* diacritic=no */,
  {     0,   184,  6027,   2,  12, UNI_KHMERSYMBOLS }   /* iskhmersymbols */,
  {    47,  9629,  5943,   3,   4, UNI_LB__GL }   /* lb=glue */,
  {     0,  8051,  9734,   7,   3, UNI_COMPEX }   /* compex=yes */,
  {     1,  8604,  8864,   6,   5, -UNI_QMARK }   /* qmark=false */,
  {     3,   184,   122,   2,   9, UNI_DIA }   /* isdiacritic */,
  {     2,  7148,     0,  10,   0, UNI_YIRADICALS }   /* yiradicals */,
  {     5,  1158,  2221,   3,   3, UNI_INTHAI }   /* inthai */,
  {     4,  6918,  5991,  10,  12, UNI_LB__IS }   /* linebreak=infixnumeric */,
  {    80,  9093,   478,   4,  31, UNI_MATHALPHANUM }   /* blk=mathematicalalphanumericsymbols */,
  {     4,  6918,  6448,  10,  11, UNI_LB__IN }   /* linebreak=inseparable */,
  {     0,  3248,  9433,   6,   4, UNI_XPOSIXSPACE }   /* space=true */,
  {     0,  8424,  3038,   6,  18, UNI_ETHIOPICSUP }   /* block=ethiopicsupplement */,
  {     0,  9365,  8289,   4,   7, UNI_LANA }   /* scx=taitham */,
  {     1,  6918,  5059,  10,  14, UNI_LB__BK }   /* linebreak=mandatorybreak */,
  {     7,  9623,  5087,   3,  14, UNI_JG__MANICHAEANBETH }   /* jg=manichaeanbeth */,
  {     0,  2106,  6525,  21,   3, UNI_LB__H3 }   /* graphemeclusterbreak=lvt */,
  {    11,  9093,  4432,   4,  15, UNI_DIACRITICALSSUP }   /* blk=diacriticalssup */,
  {   129,  1497,     7,   9,   1, UNI_C }   /* category=c */,
  {     0,  2453,     0,   4,   0, UNI_TERM }   /* term */,
  {     0,  8556,  9734,   6,   3, UNI_XPOSIXLOWER }   /* lower=yes */,
  {     5,  9365,  8622,   4,   6, UNI_TELU }   /* scx=telugu */,
  {     0,    27,     0,   2,   0, UNI_LOWERCASELETTER }   /* ll */,
  {     0,  8871,    72,   3,   2, UNI_SB__LE }   /* sb=le */,
  {     0,    21,  3980,   2,  16, UNI_LINEARBIDEOGRAMS }   /* inlinearbideograms */,
  {   144,  8233,  8538,   7,   4, UNI_SC__KHOJ }   /* script=khoj */,
  {    37,  9365,  7302,   4,   9, UNI_NBAT }   /* scx=nabataean */,
  {     5,  8233,  6558,   7,  11, UNI_MEDF }   /* script=medefaidrin */,
  {    72,  4175,     0,  13,   0, UNI_MATHOPERATORS }   /* mathoperators */,
  {     6,  8874,  9734,   5,   3, UNI_IDST }   /* idst=yes */,
  {     0,  6918,    25,  10,   2, UNI_LB__SY }   /* linebreak=sy */,
  {     0,  8484,     0,   6,   0, UNI_CAKM }   /* chakma */,
  {     0,  8233,  9469,   7,   4, UNI_XSUX }   /* script=xsux */,
  {     1,  8412,  9433,   6,   4, UNI_BIDIC }   /* bidic=true */,
  {     4,  8886,  2836,   3,   9, UNI_SUND }   /* sc=sundanese */,
  {   243,  8886,  9293,   3,   4, UNI_OGAM }   /* sc=ogam */,
  {     0,  2085,     0,  11,   0, UNI_CYRILLICSUP }   /* cyrillicsup */,
  {    26,  8886,  3772,   3,   8, UNI_SC__BOPO }   /* sc=bopomofo */,
  {     1,  1801,    26,  22,   1, UNI_CWU }   /* changeswhenuppercased=y */,
  {     5,  1362,  7558,  24,   2, UNI_CCC__13 }   /* canonicalcombiningclass=13 */,
  {     0,  3671,  1622,  17,   5, UNI_LATN }   /* scriptextensions=latin */,
  {     1,    21,  3964,   2,   9, UNI_LATIN1 }   /* inlatin1sup */,
  {     4,  3736,  5958,   5,   9, UNI_INGUNJALAGONDI }   /* ingunjalagondi */,
  {     0,  2204,   125,   3,   2, UNI_OCR }   /* isocr */,
  {   104,  1757,    26,  22,   1, UNI_CWL }   /* changeswhenlowercased=y */,
  {     1,   184,  8072,   2,   7, UNI_ELYM }   /* iselymaic */,
  {    17,  1999,     0,  22,   0, UNI_MODIFIERLETTERS }   /* spacingmodifierletters */,
  {     0,  9093,   689,   4,  30, UNI_CUNEIFORMNUMBERS }   /* blk=cuneiformnumbersandpunctuation */,
  {     2,  4821,   995,  14,   2, -UNI_POSIXXDIGIT }   /* asciihexdigit=no */,
  {     0,  9093,  2627,   4,  19, UNI_ENCLOSEDALPHANUMSUP }   /* blk=enclosedalphanumsup */,
  {     2,  3110,     0,   8,   0, UNI_GEOR }   /* georgian */,
  {     0,  2684,  6525,  19,  11, UNI_LB__H3 }   /* hangulsyllabletype=lvtsyllable */,
  {     0,  6768,  2233,   3,  20, UNI_YIJING }   /* isyijinghexagramsymbols */,
  {     0,  8424,  4477,   6,  15, UNI_INHANGUL }   /* block=hangulsyllables */,
  {     1,  9647,  9014,   3,   3, UNI_NV__5_SLASH_2 }   /* nv=5/2 */,
  {     0,  9093,  3501,   4,  17, UNI_CYRILLICEXTA }   /* blk=cyrillicextendeda */,
  {     0,  8871,  8616,   3,   5, UNI_SB__ST }   /* sb=sterm */,
  {     2,  8562,     0,   4,   0, UNI_LYCI }   /* lyci */,
  {     1,  2148,  2894,   3,  18, UNI_SUPARROWSC }   /* insupplementalarrowsc */,
  {     1,  6918,  9757,  10,   2, UNI_LB__H2 }   /* linebreak=h2 */,
  {     2,  9049,  7507,   4,   2, UNI_AGE__12 }   /* age=12 */,
  {     6,  9605,  7836,   3,   8, UNI_DT__FRA }   /* dt=fraction */,
  {     1,  3002,  9461,  18,   4, UNI_EA__F }   /* decompositiontype=wide */,
  {     0,  9365,  1573,   4,   4, UNI_PHAG }   /* scx=phag */,
  {    23,  8100,     1,   7,   1, -UNI_HYPHEN }   /* hyphen=n */,
  {     0,  8886,  8622,   3,   4, UNI_SC__TELU }   /* sc=telu */,
  {     0,  1162,     0,  26,   0, UNI_HALFANDFULLFORMS }   /* halfwidthandfullwidthforms */,
  {     1,   184,  8086,   2,   6, UNI_GRBASE }   /* isgrbase */,
  {     0,  8634,  9433,   6,   4, UNI_UIDEO }   /* uideo=true */,
  {     1,  8424,  4975,   6,   7, UNI_KANASUP }   /* block=kanasup */,
  {    16,  1757,     0,  22,   0, UNI_cwl_values_index }   /* changeswhenlowercased= */,
  {     2,   184,    38,   2,   2, UNI_XPOSIXDIGIT }   /* isnd */,
  {     3,  2148,  8255,   3,   6, UNI_INSIDDHAM }   /* insiddham */,
  {   281,  3038,     0,  11,   0, UNI_ETHIOPICSUP }   /* ethiopicsup */,
  {     1,  9093,  4762,   4,   8, UNI_VEDICEXT }   /* blk=vedicext */,
  {     1,  9209,     0,   4,   0, UNI_KTHI }   /* kthi */,
  {     1,  5760,  1219,  13,   3, UNI_NV__NAN }   /* numericvalue=nan */,
  {     1,  9093,  7995,   4,   7, UNI_INAVESTAN }   /* blk=avestan */,
  {     0,  6027,     0,   5,   0, UNI_KHMR }   /* khmer */,
  {     8,  5760,  8364,  13,   4, UNI_NV__4000 }   /* numericvalue=4000 */,
  {     2,  3900,     0,  16,   0, UNI_HALFANDFULLFORMS }   /* halfandfullforms */,
  {     0,  2148,  2000,   3,  21, UNI_MODIFIERLETTERS }   /* inspacingmodifierletters */,
  {     2,  9389,     0,   4,   0, UNI_SOGO }   /* sogo */,
  {     2,  5760,  9741,  13,   2, UNI_NV__44 }   /* numericvalue=44 */,
  {    39,  1801,    36,  22,   1, UNI_CWU }   /* changeswhenuppercased=t */,
  {     0,  8959,    26,   5,   1, UNI_XIDS }   /* xids=y */,
  {    32,  2106,    73,  21,   2, UNI_WB__EB }   /* graphemeclusterbreak=em */,
  {    22,  3736,  7854,   4,   6, UNI_INGURMUKHI }   /* ingurmukhi */,
  {     0,  4361,  1578,   4,  16, UNI_GEOMETRICSHAPESEXT }   /* ingeometricshapesext */,
  {     3,  5760,  8400,  13,   6, UNI_NV__900000 }   /* numericvalue=900000 */,
  {     0,  3951,  1278,   3,   2, UNI_IDS }   /* isids */,
  {    17,  9365,  8919,   4,   5, UNI_OGAM }   /* scx=ogham */,
  {     0,  9782,  7128,   4,   4, UNI_POSIXWORD }   /* perlword */,
  {     4,  8886,  2164,   4,   3, UNI_SC__KTHI }   /* sc=kthi */,
  {     0,  9293,     0,   4,   0, UNI_OGAM }   /* ogam */,
  {     8,  9904,  3248,   5,   5, UNI_POSIXSPACE }   /* posixspace */,
  {    64,  9731,  4645,   3,   2, UNI_WB__DQ }   /* wb=dq */,
  {     0,  7128,  5346,  10,   2, UNI_WB__EB }   /* wordbreak=eb */,
  {   132,  5760,  8371,  13,   2, UNI_NV__32 }   /* numericvalue=32 */,
  {     0,    78,     0,   6,   0, UNI_ARAB }   /* arabic */,
  {     3,  9093,  1458,   4,  24, UNI_HIGHPUSURROGATES }   /* blk=highprivateusesurrogates */,
  {   139,  8886,  1085,   3,   4, UNI_SC__HANG }   /* sc=hang */,
  {     0,  9365,  8859,   4,   5, UNI_DOGR }   /* scx=dogra */,
  {     0,  9647,  8354,   3,   4, UNI_NV__6000 }   /* nv=6000 */,
  {     1,  3671,  8538,  17,   6, UNI_KHOJ }   /* scriptextensions=khojki */,
  {    61,  8424,  1622,   6,   9, UNI_LATINEXTE }   /* block=latinexte */,
  {     0,  9647,  7644,   3,   8, UNI_NV__11_SLASH_2 }   /* nv=5.50e+00 */,
  {     0,  3951,   415,   3,  10, UNI_IDEO }   /* isideographic */,
  {   128,  8886,  7812,   3,   8, UNI_SC__DUPL }   /* sc=duployan */,
  {     0,  3243,    26,  11,   1, UNI_XPOSIXSPACE }   /* whitespace=y */,
  {     1,  9901,  1768,   8,   5, UNI_XPOSIXLOWER }   /* isxposixlower */,
  {     0,  9093,   837,   4,  11, UNI_PHONETICEXT }   /* blk=phoneticext */,
  {     1,  9093,  3210,   4,   8, UNI_DINGBATS }   /* blk=dingbats */,
  {     0,  9623,  6334,   3,   4, UNI_JG__NOON }   /* jg=noon */,
  {     0,  9647,  9497,   3,   3, UNI_NV__1_SLASH_5 }   /* nv=1/5 */,
  {     6,  6005,  1031,   4,   4, UNI_INCOPTIC }   /* incoptic */,
  {     9,  3868,  4080,  16,  10, UNI_SM }   /* generalcategory=mathsymbol */,
  {     6,  6005,  2065,   3,  20, UNI_CJKRADICALSSUP }   /* incjkradicalssupplement */,
  {    22,  9593,  4312,   3,  15, UNI_BC__CS }   /* bc=commonseparator */,
  {     4,  9313,    36,   4,   1, UNI_PCM }   /* pcm=t */,
  {     0,  8424,  8128,   6,   7, UNI_INMAKASAR }   /* block=makasar */,
  {     2,  6602,     0,  11,   0, UNI_NAND }   /* nandinagari */,
  {   144,  1497,  8839,   9,   5, UNI_XPOSIXCNTRL }   /* category=cntrl */,
  {    27,  6243,     0,  12,   0, UNI_HUNG }   /* oldhungarian */,
  {     0,   184,  7248,   2,   9, UNI_SIND }   /* iskhudawadi */,
  {   131,   184,  3038,   2,  11, UNI_ETHIOPICSUP }   /* isethiopicsup */,
  {     0,  9629,  7924,   3,   8, UNI_LB__NL }   /* lb=nextline */,
  {     0,  2708,    29,   4,   4, UNI_INARABIC }   /* inarabic */,
  {     0,  1362,     8,  24,   1, UNI_CCC__A }   /* canonicalcombiningclass=a */,
  {     0,  9093,  4821,   4,   5, UNI_ASCII }   /* blk=ascii */,
  {     6,  2142,  8915,   3,   4, UNI_INNUSHU }   /* innushu */,
  {     1,  5760,  7564,  13,   8, UNI_NV__1_SLASH_320 }   /* numericvalue=3.13e-03 */,
  {     0,  9365,  6724,   5,  10, UNI_SYLO }   /* scx=sylotinagri */,
  {   160,  2148,  7079,   3,   9, UNI_SUPARROWSB }   /* insuparrowsb */,
  {     7,   184,  7048,   2,  10, UNI_SAUR }   /* issaurashtra */,
  {     3,  8496,  8864,   6,   5, -UNI_CWKCF }   /* cwkcf=false */,
  {     0,  8859,     0,   4,   0, UNI_DOGR }   /* dogr */,
  {     1,  9093,  3705,   4,  17, UNI_SMALLFORMS }   /* blk=smallformvariants */,
  {     3,  1713,  8864,  22,   5, -UNI_CWCF }   /* changeswhencasefolded=false */,
  {     0,  2930,     0,   4,   0, UNI_CHER }   /* cher */,
  {     2,  5760,  8354,  13,   3, UNI_NV__600 }   /* numericvalue=600 */,
  {     0,  7356,     0,   4,   0, UNI_PALM }   /* palm */,
  {     3,  1362,  9527,  24,   3, UNI_CCC__R }   /* canonicalcombiningclass=226 */,
  {     1,  1691,  4687,  22,   4, UNI_BPT__O }   /* bidipairedbrackettype=open */,
  {    16,  3038,     0,   8,   0, UNI_ETHI }   /* ethiopic */,
  {     5,  7018,  9563,  10,   3, UNI_IN__5_DOT_1 }   /* presentin=5.1 */,
  {    13,  8424,  7852,   6,   8, UNI_INGURMUKHI }   /* block=gurmukhi */,
  {     0,  9365,  1599,   4,   6, UNI_HANG }   /* scx=hangul */,
  {     1,  8233,  1135,   9,   2, UNI_SC__SHRD }   /* script=shrd */,
  {     1,  9647,  9743,   3,   2, UNI_NV__45 }   /* nv=45 */,
  {   292,  1924,  6040,  10,  11, UNI_NL }   /* category=letternumber */,
  {     0,  7018,  9686,  10,   3, UNI_IN__3_DOT_2 }   /* presentin=v32 */,
  {     1,  6949,  6362,   4,   9, UNI_CASEDLETTER }   /* iscasedletter */,
  {     3,  1497,  4402,   9,  15, UNI_PD }   /* category=dashpunctuation */,
  {     0,  9629,  9773,   3,   2, UNI_LB__XX }   /* lb=xx */,
  {     2,  8233,  9133,   7,   4, UNI_SC__CYRL }   /* script=cyrl */,
  {     0,   184,  1530,   2,  23, UNI_BYZANTINEMUSIC }   /* isbyzantinemusicalsymbols */,
  {     0,  6015,  6470,  12,  11, UNI_JT__C }   /* joiningtype=joincausing */,
  {     0,  4598,  1132,   4,   2, UNI_CPRT }   /* iscprt */,
  {    21,  6928,  9433,  10,   4, UNI_XPOSIXLOWER }   /* lowercase=true */,
  {     0,  2212,  2648,   4,   8, UNI_JAMO }   /* inhanguljamo */,
  {     2,  6005,   510,   3,  19, UNI_CJK }   /* incjkunifiedideographs */,
  {     5,  4627,    17,  16,   1, UNI_NFKCQC__N }   /* nfkcquickcheck=no */,
  {     2,  9113,  7539,   4,   2, UNI_CCC__22 }   /* ccc=22 */,
  {    48,  8086,     1,   7,   1, -UNI_GRBASE }   /* grbase=n */,
  {     0,  3671,  9309,  17,   4, UNI_OSGE }   /* scriptextensions=osge */,
  {    15,  7018,  7507,  10,   4, UNI_IN__12 }   /* presentin=12.0 */,
  {     1,   184,    24,   2,   1, UNI_L }   /* isl */,
  {    16,    21,  2232,   2,  21, UNI_YIJING }   /* inyijinghexagramsymbols */,
  {     0,  8424,  4807,   6,  14, UNI_ANCIENTSYMBOLS }   /* block=ancientsymbols */,
  {     0,  1084,     0,  25,   0, UNI_CWKCF }   /* changeswhennfkccasefolded */,
  {     8,  1911,  8704,  22,   5, UNI_INSC__BINDU }   /* indicsyllabiccategory=bindu */,
  {    11,  8604,     3,   6,   1, -UNI_QMARK }   /* qmark=f */,
  {     0,  9731,  1188,   3,   2, UNI_WB__KA }   /* wb=ka */,
  {     2,  9365,  8652,   4,   6, UNI_WCHO }   /* scx=wancho */,
  {     4,  6828,  2817,  10,  19, UNI_BC__RLO }   /* bidiclass=righttoleftoverride */,
  {    18,  8899,     0,   5,   0, UNI_math_values_index }   /* math= */,
  {     0,  8219,     3,   7,   1, -UNI_PATSYN }   /* patsyn=f */,
  {     0,  9946,  8248,   3,   6, UNI_SHAW }   /* isshavian */,
  {     0,  1768,     0,   9,   0, UNI_XPOSIXLOWER }   /* lowercase */,
  {     4,  8406,     1,   6,   1, -UNI_XPOSIXALPHA }   /* alpha=n */,
  {     1,  6635,     0,  11,   0, UNI_SO }   /* othersymbol */,
  {     0,  9093,  7008,   4,  10, UNI_INPHOENICIAN }   /* blk=phoenician */,
  {     3,   719,     0,  30,   0, UNI_ENCLOSEDALPHANUMSUP }   /* enclosedalphanumericsupplement */,
  {     2,  3671,  8699,  17,   5, UNI_BATK }   /* scriptextensions=batak */,
  {     1,  8886,  9309,   3,   4, UNI_OSGE }   /* sc=osge */,
  {   191,  2703,    36,  19,   1, UNI_IDST }   /* idstrinaryoperator=t */,
  {    24,  6928,  9734,  10,   3, UNI_XPOSIXLOWER }   /* lowercase=yes */,
  {   276,   339,     0,   2,   0, UNI_LO }   /* lo */,
  {     0,  8894,     0,   5,   0, UNI_LIMB }   /* limbu */,
  {     1,  3671,  2930,  17,   8, UNI_CHER }   /* scriptextensions=cherokee */,
  {     2,  3092,     0,  18,   0, UNI_INPUNCTUATION }   /* generalpunctuation */,
  {     0,   184,  8142,   2,   7, UNI_MARC }   /* ismarchen */,
  {     4,  3671,  6602,  17,   4, UNI_NAND }   /* scriptextensions=nand */,
  {    30,  9946,  3730,   3,   3, UNI_SGNW }   /* issgnw */,
  {     1,  3236,     3,  18,   1, -UNI__PERL_PATWS }   /* patternwhitespace=f */,
  {     4,  1239,     0,  24,   0, UNI_COMPEX }   /* fullcompositionexclusion */,
  {     0,  6918,  5952,  10,   3, UNI_LB__ZWJ }   /* linebreak=zwj */,
  {     6,  9237,     0,   3,   0, UNI_LOE }   /* loe */,
  {     2,  9647,  9021,   3,   4, UNI_NV__3_SLASH_16 }   /* nv=3/16 */,
  {    57,  5835,  9734,  12,   3, UNI_BIDIC }   /* bidicontrol=yes */,
  {     0,  8338,   995,   7,   2, -UNI_XPOSIXSPACE }   /* wspace=no */,
  {     5,  9093,  5045,   4,  14, UNI_LATINEXTE }   /* blk=latinextendede */,
  {     4,  9113,  3433,   4,  17, UNI_WB__EB }   /* ccc=attachedbelowleft */,
  {     0,  8886,  9409,   3,   4, UNI_SC__TAML }   /* sc=taml */,
  {    16,  9731,    72,   3,   2, UNI_WB__LE }   /* wb=le */,
  {     0,  9113,  8837,   4,   2, UNI_CCC__91 }   /* ccc=91 */,
  {    73,   184,  8652,   2,   6, UNI_WCHO }   /* iswancho */,
  {     0,  8424,  1458,   6,  24, UNI_HIGHPUSURROGATES }   /* block=highprivateusesurrogates */,
  {     0,   184,  9197,   2,   4, UNI_KALI }   /* iskali */,
  {     0,  9647,  7620,   3,   8, UNI_NV__9_SLASH_2 }   /* nv=4.50e+00 */,
  {     0,  8960,   995,   4,   2, -UNI_IDS }   /* ids=no */,
  {     1,  9623,  6547,   3,  11, UNI_JG__MALAYALAMRA }   /* jg=malayalamra */,
  {    64,  9647,  7588,   3,   8, UNI_NV__3_SLASH_8 }   /* nv=3.75e-01 */,
  {     5,  9365,  9213,   4,   4, UNI_LANA }   /* scx=lana */,
  {     0,  5213,    17,  15,   1, UNI_COMPEX }   /* nfcquickcheck=no */,
  {     0,   184,  4076,   2,  16, UNI_MISCMATHSYMBOLSA }   /* ismiscmathsymbolsa */,
  {     2,   184,    43,   3,  15, UNI_CJKCOMPAT }   /* iscjkcompatibility */,
  {    33,  9623,  8658,   3,   4, UNI_JG__YUDH }   /* jg=yudh */,
  {     0,  6315,   995,  12,   2, -UNI_XIDC }   /* xidcontinue=no */,
  {     1,  8233,  9489,   7,   4, UNI_SC__ZYYY }   /* script=zyyy */,
  {     1,  8233,  8628,   7,   4, UNI_SC__THAA }   /* script=thaa */,
  {     0,  5565,  8689,  13,   5, UNI_JG__ALAPH }   /* joininggroup=alaph */,
  {     1,  9493,     0,   4,   0, UNI_ZZZZ }   /* zzzz */,
  {     1,  8233,  9217,   7,   3, UNI_LAO }   /* script=lao */,
  {     0,  9365,  6558,   4,  11, UNI_MEDF }   /* scx=medefaidrin */,
  {     3,  9489,     0,   4,   0, UNI_ZYYY }   /* zyyy */,
  {     0,  1362,  9771,  24,   2, UNI_CCC__9 }   /* canonicalcombiningclass=vr */,
  {     4,  5979,  9734,  12,   3, UNI_IDEO }   /* ideographic=yes */,
  {     0,  2148,  1507,   3,  23, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* insupsymbolsandpictographs */,
  {     1,  6828,     0,  10,   0, UNI_bc_values_index }   /* bidiclass= */,
  {   324,  8233,  8709,   7,   5, UNI_SC__BUHD }   /* script=buhid */,
  {     4,  6015,    18,  12,   1, UNI_JT__R }   /* joiningtype=r */,
  {     0,  3688,    26,  17,   1, UNI_STERM }   /* sentenceterminal=y */,
  {     6,  5760,  8988,  13,   2, UNI_NV__41 }   /* numericvalue=41 */,
  {     1,  5565,  6657,  13,  11, UNI_JG__ROHINGYAYEH }   /* joininggroup=rohingyayeh */,
  {     2,  3868,   132,  16,   2, UNI_LM }   /* generalcategory=lm */,
  {     3,  8424,  8135,   6,   7, UNI_INMANDAIC }   /* block=mandaic */,
  {     1,  9662,  8864,   3,   5, -UNI_SD }   /* sd=false */,
  {     1,  8424,  1003,   6,  11, UNI_ENCLOSEDCJK }   /* block=enclosedcjk */,
  {    63,  9629,  9626,   3,   2, UNI_GCB__T }   /* lb=jt */,
  {     0,  9093,  6858,   4,  10, UNI_CJKSTROKES }   /* blk=cjkstrokes */,
  {    66,  9593,  3182,   3,  18, UNI_BC__LRI }   /* bc=lefttorightisolate */,
  {    50,  3671,  8191,  17,   7, UNI_OLCK }   /* scriptextensions=olchiki */,
  {     2,  1911,  5474,  22,  13, UNI_INSC__CONSONANTDEAD }   /* indicsyllabiccategory=consonantdead */,
  {     5,  8170,     0,   8,   0, UNI_NFKDQC__N }   /* nfkdqc=n */,
  {     0,  9365,  9317,   4,   4, UNI_PHLP }   /* scx=phlp */,
  {    42,  4462,  9734,  15,   3, UNI_GREXT }   /* graphemeextend=yes */,
  {     0,  9093,  6558,   4,  11, UNI_INMEDEFAIDRIN }   /* blk=medefaidrin */,
  {     0,  9365,  4220,   4,   6, UNI_TANG }   /* scx=tangut */,
  {     1,  8886,  1189,   4,   7, UNI_SC__KANA }   /* sc=katakana */,
  {     0,  9409,     0,   4,   0, UNI_TAML }   /* taml */,
  {     0,  7025,  9695,   3,   3, UNI_IN__5 }   /* in=v50 */,
  {     4,   184,   132,   2,   2, UNI_LM }   /* islm */,
  {     0,  5213,     0,  15,   0, UNI_COMPEX }   /* nfcquickcheck=n */,
  {     1,  9623,  6063,   3,  12, UNI_JG__MALAYALAMBHA }   /* jg=malayalambha */,
  {     3,  8332,  1340,   4,  22, UNI_ARABICPFB }   /* isarabicpresentationformsb */,
  {     0,  8886,  7203,   3,   9, UNI_BHKS }   /* sc=bhaiksuki */,
  {     2,  9620,  5353,   3,  14, UNI_ZS }   /* gc=spaceseparator */,
  {     8,  7018,  9719,  10,   3, UNI_IN__8 }   /* presentin=v80 */,
  {     0,  9365,   493,   4,   3, UNI_HAN }   /* scx=han */,
  {     9,  9113,  7167,   4,   9, UNI_CCC__AL }   /* ccc=aboveleft */,
  {     0,  1243,   995,  21,   2, -UNI_CE }   /* compositionexclusion=no */,
  {     2,  8879,   879,   3,   9, UNI_PUA }   /* inprivateuse */,
  {     9,  1482,  1869,   4,  20, UNI_DIACRITICALSFORSYMBOLS }   /* indiacriticalsforsymbols */,
  {     0,  1497,  6624,   9,  11, UNI_NO }   /* category=othernumber */,
  {     3,  9365,  8226,   4,   7, UNI_PHAG }   /* scx=phagspa */,
  {     6,  5760,  8822,  13,   2, UNI_NV__35 }   /* numericvalue=35 */,
  {     0,  9647,  8364,   3,   5, UNI_NV__40000 }   /* nv=40000 */,
  {     2,  3671,  3020,  17,  10, UNI_DEVA }   /* scriptextensions=devanagari */,
  {     0,  8424,  1387,   7,  23, UNI_CJKSYMBOLS }   /* block=cjksymbolsandpunctuation */,
  {    10,  9365,  3984,   5,   3, UNI_SARB }   /* scx=sarb */,
  {     1,  8886,  7995,   3,   7, UNI_AVST }   /* sc=avestan */,
  {    34,  8538,     0,   6,   0, UNI_KHOJ }   /* khojki */,
  {     5,  3243,    36,  11,   1, UNI_XPOSIXSPACE }   /* whitespace=t */,
  {     1,  5552,     0,   6,   0, UNI_IPAEXT }   /* ipaext */,
  {     0,  3251,    36,   3,   1, UNI_CE }   /* ce=t */,
  {     1,   184,  2211,   2,  21, UNI_SINHALAARCHAICNUMBERS }   /* issinhalaarchaicnumbers */,
  {     0,  8233,  7844,   7,   8, UNI_SC__GUJR }   /* script=gujarati */,
  {    72,   184,    11,   2,   2, UNI_DI }   /* isdi */,
  {     0,  9129,  8864,   4,   5, -UNI_CWU }   /* cwu=false */,
  {   135,  9129,    26,   4,   1, UNI_CWU }   /* cwu=y */,
  {     1,  9647,  8970,   3,   3, UNI_NV__1_SLASH_2 }   /* nv=1/2 */,
  {     0,  1362,  8646,  24,   6, UNI_CCC__9 }   /* canonicalcombiningclass=virama */,
  {     0,  9337,     0,   4,   0, UNI_QAAI }   /* qaai */,
  {     9,  8233,  8679,   7,   5, UNI_SC__ADLM }   /* script=adlam */,
  {     1,  9093,  7311,   4,   9, UNI_INNEWTAILUE }   /* blk=newtailue */,
  {   195,   184,  2409,   2,   4, UNI_MONG }   /* ismong */,
  {     2,   184,  9481,   2,   4, UNI_ZANB }   /* iszanb */,
  {     2,  9623,  6075,   3,  12, UNI_JG__MALAYALAMLLA }   /* jg=malayalamlla */,
  {     2,  5760,  8400,  13,   5, UNI_NV__90000 }   /* numericvalue=90000 */,
  {     0,  4387,     0,  14,   0, UNI_SC }   /* currencysymbol */,
  {     1,  4580,  2780,   3,  11, UNI_MONGOLIANSUP }   /* inmongoliansup */,
  {     0,  9901,  7128,   8,   4, UNI_XPOSIXWORD }   /* isxposixword */,
  {     0,  1362,  8802,  24,   2, UNI_CCC__31 }   /* canonicalcombiningclass=31 */,
  {     0,  4627,    26,  15,   1, UNI_NFKCQC__Y }   /* nfkcquickcheck=y */,
  {     1,  8233,  3980,   7,   7, UNI_SC__LINB }   /* script=linearb */,
  {     1,  9620,     0,   3,   0, UNI_gc_values_index }   /* gc= */,
  {    55,  1779,     1,  22,   1, -UNI_CWT }   /* changeswhentitlecased=n */,
  {     1,  3002,  1223,  18,   7, UNI_DT__INIT }   /* decompositiontype=initial */,
  {     1,  9345,     0,   4,   0, UNI_RJNG }   /* rjng */,
  {     3,  7128,  5943,  10,  12, UNI_WB__EB }   /* wordbreak=glueafterzwj */,
  {     2,  1536,  3553,   3,  10, UNI_ETHIOPICEXT }   /* inethiopicext */,
  {     1,   184,  1576,   2,  18, UNI_GEOMETRICSHAPESEXT }   /* isgeometricshapesext */,
  {     8,  9647,  9018,   3,   3, UNI_NV__7_SLASH_2 }   /* nv=7/2 */,
  {     0,  1497,  4732,   9,  15, UNI_TITLE }   /* category=titlecaseletter */,
  {     0,  8424,  3964,   6,   9, UNI_LATIN1 }   /* block=latin1sup */,
  {     2,  1362,  3433,  24,  13, UNI_CCC__202 }   /* canonicalcombiningclass=attachedbelow */,
  {     0,  1845,     0,  22,   0, UNI_INDICNUMBERFORMS }   /* commonindicnumberforms */,
  {     0,  8886,  8115,   4,   6, UNI_SC__KALI }   /* sc=kayahli */,
  {     1,  1158,  4718,   3,  14, UNI_TAMILSUP }   /* intamilsupplement */,
  {     1,  8233,  8149,   7,   7, UNI_SC__MULT }   /* script=multani */,
  {     1,  5760,  5409,  13,   8, UNI_NV__10000000 }   /* numericvalue=10000000 */,
  {     0,   184,  7266,   2,   9, UNI_LATINEXTC }   /* islatinextc */,
  {   242,  9365,  3836,   4,   7, UNI_CPRT }   /* scx=cypriot */,
  {     0,  9647,  9745,   3,   2, UNI_NV__46 }   /* nv=46 */,
  {     1,   184,  1758,   3,  20, UNI_CWL }   /* ischangeswhenlowercased */,
  {     0,  5565,   726,  13,   3, UNI_JG__DAL }   /* joininggroup=dal */,
  {     0,  8874,     0,   5,   0, UNI_idst_values_index }   /* idst= */,
  {     5,  2148,  7049,   3,   9, UNI_INSAURASHTRA }   /* insaurashtra */,
  {     0,  9647,  9017,   3,   4, UNI_NV__17_SLASH_2 }   /* nv=17/2 */,
  {     1,  5760,  7532,  13,   8, UNI_NV__1_SLASH_40 }   /* numericvalue=2.50e-02 */,
  {    67,  9620,   339,   3,   2, UNI_LO }   /* gc=lo */,
  {     4,  9113,  7446,   4,   2, UNI_CCC__25 }   /* ccc=25 */,
  {     0,  9093,  2021,   4,  22, UNI_TRANSPORTANDMAP }   /* blk=transportandmapsymbols */,
  {     0,   184,  3552,   2,  17, UNI_ETHIOPICEXTA }   /* isethiopicextendeda */,
  {     4,  6918,  3820,  10,  16, UNI_LB__CL }   /* linebreak=closepunctuation */,
  {     3,  6371,    36,  11,   1, UNI_DEP }   /* deprecated=t */,
  {     0,  8886,  6646,   3,  11, UNI_HMNG }   /* sc=pahawhhmong */,
  {    14,  9093,  5590,   5,   7, UNI_INBALINESE }   /* blk=balinese */,
  {     3,  3671,  8568,  17,   4, UNI_LYDI }   /* scriptextensions=lydi */,
  {     0,  3671,  8652,  17,   6, UNI_WCHO }   /* scriptextensions=wancho */,
  {     0,  8617,   995,   5,   2, -UNI_TERM }   /* term=no */,
  {     8,  8424,   567,   6,   2, UNI_NB }   /* block=nb */,
  {     0,  6828,  4905,  10,  14, UNI_BC__EN }   /* bidiclass=europeannumber */,
  {     0,  8886,  7338,   3,   9, UNI_SC__PERM }   /* sc=oldpermic */,
  {     1,  9453,     0,   4,   0, UNI_VAI }   /* vaii */,
  {     3,   184,  7804,   2,   4, UNI_BUGI }   /* isbugi */,
  {     0,  5552,     0,  13,   0, UNI_IPAEXT }   /* ipaextensions */,
  {     3,  9093,  4975,   4,  14, UNI_KANASUP }   /* blk=kanasupplement */,
  {     6,  5565,  5617,  13,  13, UNI_JG__MALAYALAMLLLA }   /* joininggroup=malayalamllla */,
  {     0,  3671,  9421,  17,   4, UNI_TGLG }   /* scriptextensions=tglg */,
  {     0,  8233,  8502,   7,   6, UNI_GOTH }   /* script=gothic */,
  {     0,  9093,  1999,   4,  22, UNI_MODIFIERLETTERS }   /* blk=spacingmodifierletters */,
  {     7,  9946,     6,   3,   1, UNI_SD }   /* issd */,
  {     0,  2779,     0,  19,   0, UNI_MONGOLIANSUP }   /* mongoliansupplement */,
  {     2,  7812,     0,   4,   0, UNI_DUPL }   /* dupl */,
  {     0,   184,  2779,   2,   9, UNI_MONG }   /* ismongolian */,
  {     0,  4705,  8624,   4,   4, UNI_TELU }   /* istelugu */,
  {     7,  9659,     0,   3,   0, UNI_ri_values_index }   /* ri= */,
  {   515,  8886,  2930,   3,   4, UNI_CHER }   /* sc=cher */,
  {     6,   117,     6,   3,   2, UNI_INIDC }   /* inidc */,
  {     0,  9113,  7558,   4,   2, UNI_CCC__13 }   /* ccc=13 */,
  {     2,   184,  8142,   2,   4, UNI_MARC }   /* ismarc */,
  {     0,  8065,     0,   7,   0, UNI_ELBA }   /* elbasan */,
  {     0,  8406,   995,   6,   2, -UNI_XPOSIXALPHA }   /* alpha=no */,
  {     0,  9093,  1576,   4,  15, UNI_GEOMETRICSHAPES }   /* blk=geometricshapes */,
  {    49,  1933,     1,  22,   1, -UNI_LOE }   /* logicalorderexception=n */,
  {     0,  8424,  6243,   6,  12, UNI_INOLDHUNGARIAN }   /* block=oldhungarian */,
  {     8,   184,  8177,   2,   7, UNI_NB }   /* isnoblock */,
  {     5,   184,   630,   3,  29, UNI_CJKEXTE }   /* iscjkunifiedideographsextensione */,
  {     1,  8424,  3416,   6,  17, UNI_ALCHEMICAL }   /* block=alchemicalsymbols */,
  {    34,  9725,  3362,   3,  18, UNI_VO__TR }   /* vo=transformedrotated */,
  {     0,  2085,     0,  18,   0, UNI_CYRILLICSUP }   /* cyrillicsupplement */,
  {     0,  9093,  3110,   4,  18, UNI_GEORGIANSUP }   /* blk=georgiansupplement */,
  {    73,  8424,  1030,   7,   5, UNI_INCOPTIC }   /* block=coptic */,
  {     1,  9113,  9521,   4,   3, UNI_CCC__BR }   /* ccc=222 */,
  {     0,  8886,  7118,   3,  10, UNI_WARA }   /* sc=warangciti */,
  {     1,  3868,  3218,  16,  18, UNI_ZP }   /* generalcategory=paragraphseparator */,
  {     0,  6828,  5603,  10,   3, UNI_BC__RLO }   /* bidiclass=rlo */,
  {     1,  3868,  5591,  16,  13, UNI_ZL }   /* generalcategory=lineseparator */,
  {    84,  1362,  8212,  24,   7, UNI_CCC__1 }   /* canonicalcombiningclass=overlay */,
  {     0,  7128,  4801,  10,   2, UNI_WB__SQ }   /* wordbreak=sq */,
  {     0,   184,  1622,   2,  23, UNI_LATINEXTADDITIONAL }   /* islatinextendedadditional */,
  {     0,  6003,     0,   5,   0, UNI_JOINC }   /* joinc */,
  {     9,  4297,     0,   7,   0, UNI_BRAI }   /* braille */,
  {     0,  2142,  7304,   4,   7, UNI_INNABATAEAN }   /* innabataean */,
  {     2,  8424,  3772,   6,  11, UNI_BOPOMOFOEXT }   /* block=bopomofoext */,
  {   145,  8886,  6690,   3,   4, UNI_SORA }   /* sc=sora */,
  {    54,  8424,  7900,   6,   8, UNI_KANAEXTA }   /* block=kanaexta */,
  {     5,  1188,     0,  26,   0, UNI_KATAKANAEXT }   /* katakanaphoneticextensions */,
  {     5,  2106,  9773,  21,   2, UNI_GCB__XX }   /* graphemeclusterbreak=xx */,
  {    28,  6005,  1387,   3,   9, UNI_CJKSYMBOLS }   /* incjksymbols */,
  {     2,   341,     0,   2,   0, UNI_PE }   /* pe */,
  {     1,  9629,  5952,   3,   3, UNI_LB__ZWJ }   /* lb=zwj */,
  {     0,  9049,  7159,   4,   3, UNI_AGE__5 }   /* age=5.0 */,
  {     1,  4705,  8945,   3,   4, UNI_TAKR }   /* istakri */,
  {    11,  9093,  8023,   4,   7, UNI_CJKEXTC }   /* blk=cjkextc */,
  {     5,  5979,    36,  12,   1, UNI_IDEO }   /* ideographic=t */,
  {    34,  9629,  4687,   3,  15, UNI_LB__OP }   /* lb=openpunctuation */,
  {     1,  9620,  4387,   3,  14, UNI_SC }   /* gc=currencysymbol */,
  {     0,  9629,   340,   3,   2, UNI_LB__OP }   /* lb=op */,
  {     0,  8562,     0,   6,   0, UNI_LYCI }   /* lycian */,
  {     4,   184,   837,   2,  11, UNI_PHONETICEXT }   /* isphoneticext */,
  {     6,  6885,  3901,   3,  15, UNI_HALFANDFULLFORMS }   /* ishalfandfullforms */,
  {    98,  5565,  5682,  13,  13, UNI_JG__MANICHAEANTAW }   /* joininggroup=manichaeantaw */,
  {     0,  8886,  7365,   3,   4, UNI_PAUC }   /* sc=pauc */,
  {     4,  9365,  6602,   4,   4, UNI_NAND }   /* scx=nand */,
  {     2,  5760,  9517,  13,   2, UNI_NV__42 }   /* numericvalue=42 */,
  {    71,  9620,   341,   3,   2, UNI_PE }   /* gc=pe */,
  {     0,  9946,  6992,   3,   6, UNI_SOGD }   /* issogdian */,
  {     1,  6888,    36,  10,   1, UNI_DIA }   /* diacritic=t */,
  {     1,  3671,  7812,  17,   8, UNI_DUPL }   /* scriptextensions=duployan */,
  {    27,  9365,     0,   4,   0, UNI_scx_values_index }   /* scx= */,
  {    12,   184,  8562,   2,   6, UNI_LYCI }   /* islycian */,
  {    39,  9193,  5394,   4,   2, UNI_LB__H2 }   /* hst=lv */,
  {     0,  9602,  8864,   3,   5, -UNI_DI }   /* di=false */,
  {     2,  4597,     0,  15,   0, UNI_MISCPICTOGRAPHS }   /* miscpictographs */,
  {     0,  8233,  9417,   7,   4, UNI_TFNG }   /* script=tfng */,
  {    16,   184,  8894,   2,   5, UNI_LIMB }   /* islimbu */,
  {     1,  8580,  8864,   6,   5, -UNI__PERL_NCHAR }   /* nchar=false */,
  {     0,  4267,     0,   4,   0, UNI_BAMU }   /* bamu */,
  {     2,  5760,  7716,  13,   8, UNI_NV__3_SLASH_4 }   /* numericvalue=7.50e-01 */,
  {     2,  6591,     0,  11,   0, UNI_MYANMAREXTB }   /* myanmarextb */,
  {     1,  3248,    26,   6,   1, UNI_XPOSIXSPACE }   /* space=y */,
  {     0,  6005,  2986,   4,  16, UNI_COPTICEPACTNUMBERS }   /* incopticepactnumbers */,
  {     0,  3128,  9734,  18,   3, UNI_IDSB }   /* idsbinaryoperator=yes */,
  {     0,   184,  2627,   2,  19, UNI_ENCLOSEDALPHANUMSUP }   /* isenclosedalphanumsup */,
  {     2,  7796,     0,   8,   0, UNI_BASS }   /* bassavah */,
  {     0,  8233,  3020,   7,  10, UNI_SC__DEVA }   /* script=devanagari */,
  {    12,  8424,  4204,   6,  16, UNI_SYRIACSUP }   /* block=syriacsupplement */,
  {     0,  6918,  6968,  10,  10, UNI_LB__NS }   /* linebreak=nonstarter */,
  {     0,  5760,  8376,  13,   6, UNI_NV__500000 }   /* numericvalue=500000 */,
  {    24,  1362,  3441,  24,   5, UNI_CCC__B }   /* canonicalcombiningclass=below */,
  {    32,  6918,    42,  10,   2, UNI_LB__CJ }   /* linebreak=cj */,
  {     0,  6015,    36,  12,   1, UNI_JT__T }   /* joiningtype=t */,
  {     0,  7128,    34,  10,   2, UNI_WB__EX }   /* wordbreak=ex */,
  {   256,  3948,    25,   3,   1, UNI_INVS }   /* invs */,
  {     2,   184,  3837,   3,  15, UNI_CYPRIOTSYLLABARY }   /* iscypriotsyllabary */,
  {     1,  7018,  7724,  10,   3, UNI_IN__8 }   /* presentin=8.0 */,
  {     0,  5565,  4562,  13,   5, UNI_JG__SADHE }   /* joininggroup=sadhe */,
  {   128,  2708,  3758,   4,  14, UNI_ARABICSUP }   /* inarabicsupplement */,
  {     1,  8233,  4297,   7,   7, UNI_BRAI }   /* script=braille */,
  {     0,  9093,  2232,   4,   6, UNI_YIJING }   /* blk=yijing */,
  {     0,   184,     1,   3,   1, UNI_CN }   /* iscn */,
  {   160,  6828,    37,  10,   2, UNI_BC__EN }   /* bidiclass=en */,
  {   129,  9093,  2085,   4,   8, UNI_INCYRILLIC }   /* blk=cyrillic */,
  {     0,  9093,  2948,   4,  18, UNI_HALFMARKS }   /* blk=combininghalfmarks */,
  {     4,  9365,  9425,   4,   4, UNI_THAI }   /* scx=thai */,
  {     3,  9781,  9892,   6,   9, UNI__PERL_QUOTEMETA }   /* _perl_quotemeta */,
  {   132,  3501,     0,  17,   0, UNI_CYRILLICEXTA }   /* cyrillicextendeda */,
  {     2,  9608,     3,   3,   1, UNI_EA__F }   /* ea=f */,
  {   129,    21,  8114,   2,   7, UNI_KALI }   /* inkayahli */,
  {     0,  6567,  4951,   4,   2, UNI_INMIAO }   /* inmiao */,
  {     5,  9457,     0,   4,   0, UNI_WCHO }   /* wcho */,
  {     0,  9593,  2373,   3,  11, UNI_BC__L }   /* bc=lefttoright */,
  {     0,  5565,  9596,  13,   3, UNI_JG__BEH }   /* joininggroup=beh */,
  {     4,  1188,     0,   8,   0, UNI_KANA }   /* katakana */,
  {    38,  8886,  8929,   3,   5, UNI_OSGE }   /* sc=osage */,
  {     1,  9093,  8114,   4,   7, UNI_KALI }   /* blk=kayahli */,
  {     0,  6918,   533,  10,   2, UNI_LB__NS }   /* linebreak=ns */,
  {     0,  8424,  2353,   6,  20, UNI_ININSCRIPTIONALPAHLAVI }   /* block=inscriptionalpahlavi */,
  {     0,  9093,  8934,   4,   5, UNI_INRUNIC }   /* blk=runic */,
  {     0,  1362,  8817,  24,   2, UNI_CCC__34 }   /* canonicalcombiningclass=34 */,
  {   113,  8233,  9069,   7,   4, UNI_SC__ARMN }   /* script=armn */,
  {   202,  4092,     0,  16,   0, UNI_MISCMATHSYMBOLSB }   /* miscmathsymbolsb */,
  {     0,  8406,  9734,   6,   3, UNI_XPOSIXALPHA }   /* alpha=yes */,
  {     1,  1362,  8467,  25,   5, UNI_CCC__130 }   /* canonicalcombiningclass=ccc130 */,
  {     9,  3671,  2930,  17,   4, UNI_CHER }   /* scriptextensions=cher */,
  {     0,  9623,  8689,   3,   5, UNI_JG__ALAPH }   /* jg=alaph */,
  {     0,  4462,  8864,  15,   5, -UNI_GREXT }   /* graphemeextend=false */,
  {     0,  1362,  9530,  24,   3, UNI_CCC__AL }   /* canonicalcombiningclass=228 */,
  {   301,  9093,  8568,   4,   6, UNI_INLYDIAN }   /* blk=lydian */,
  {     1,  9623,  5718,   3,   3, UNI_JG__WAW }   /* jg=waw */,
  {     0,   184,   660,   3,  29, UNI_CJKEXTF }   /* iscjkunifiedideographsextensionf */,
  {    72,  5578,     0,  13,   0, UNI_KANAEXTA }   /* kanaextendeda */,
  {   129,  9113,  8445,   4,   3, UNI_CCC__107 }   /* ccc=107 */,
  {     8,  6231,    39,  12,   2, UNI_XPOSIXDIGIT }   /* numerictype=de */,
  {     0,  9365,    57,   4,   2, UNI_YI }   /* scx=yi */,
  {    28,  7128,   697,  10,   2, UNI_WB__MN }   /* wordbreak=mn */,
  {     2,  8170,     0,   7,   0, UNI_nfkdqc_values_index }   /* nfkdqc= */,
  {     1,  1289,     0,  25,   0, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* symbolsandpictographsexta */,
  {     6,  2204,  9310,   3,   3, UNI_OSGE }   /* isosge */,
  {     6,   184,  1030,   3,   3, UNI_COPT }   /* iscopt */,
  {     5,  8424,  1338,   6,  24, UNI_ARABICPFB }   /* block=arabicpresentationformsb */,
  {    90,  9093,  1622,   4,  23, UNI_LATINEXTADDITIONAL }   /* blk=latinextendedadditional */,
  {    19,  9623,  2127,   3,  21, UNI_JG__HANIFIROHINGYAKINNAYA }   /* jg=hanifirohingyakinnaya */,
  {    20,  3293,     1,   3,  41, UNI_UCASEXT }   /* inunifiedcanadianaboriginalsyllabicsextended */,
  {    73,  6005,  5860,   3,  11, UNI_CHESSSYMBOLS }   /* inchesssymbols */,
  {     3,  7128,   495,  10,   2, UNI_WB__NU }   /* wordbreak=nu */,
  {   104,  5760,  8388,  13,   3, UNI_NV__700 }   /* numericvalue=700 */,
  {    46,  8874,     3,   5,   1, -UNI_IDST }   /* idst=f */,
  {     1,  6816,  1531,   3,  22, UNI_BYZANTINEMUSIC }   /* inbyzantinemusicalsymbols */,
  {     0,  8886,  8527,   4,   5, UNI_SC__KTHI }   /* sc=kaithi */,
  {     0,  9093,  4220,   4,  16, UNI_TANGUTCOMPONENTS }   /* blk=tangutcomponents */,
  {     0,  5435,    26,  13,   1, UNI_BIDIM }   /* bidimirrored=y */,
  {     1,  2232,     0,   6,   0, UNI_YIJING }   /* yijing */,
  {     3,  9620,    27,   3,   2, UNI_LOWERCASELETTER }   /* gc=ll */,
  {     1,  3671,  7796,  17,   8, UNI_BASS }   /* scriptextensions=bassavah */,
  {     3,  1911,  2293,  22,  20, UNI_INSC__CONSONANTPLACEHOLDER }   /* indicsyllabiccategory=consonantplaceholder */,
  {     0,  4717,     0,  15,   0, UNI_TAMILSUP }   /* tamilsupplement */,
  {    19,  9093,  6646,   4,  11, UNI_INPAHAWHHMONG }   /* blk=pahawhhmong */,
  {    51,  9113,  7747,   4,   2, UNI_CCC__28 }   /* ccc=28 */,
  {     0,  9113,  8437,   5,   4, UNI_CCC__10 }   /* ccc=ccc10 */,
  {     0,  8424,   921,   6,  18, UNI_INVS }   /* block=variationselectors */,
  {     5,  2409,     0,   4,   0, UNI_MONG }   /* mong */,
  {     1,  3254,   995,  18,   2, -UNI_RI }   /* regionalindicator=no */,
  {     0,  1977,     0,  22,   0, UNI_nchar_values_index }   /* noncharactercodepoint= */,
  {     2,   184,  1824,   3,  21, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* iscjkcompatideographssup */,
  {     1,  8424,  6171,   6,  12, UNI_MATHALPHANUM }   /* block=mathalphanum */,
  {     4,  8884,     0,   5,   0, UNI_insc_values_index }   /* insc= */,
  {     0,  9593,  2190,   3,  21, UNI_BC__PDI }   /* bc=popdirectionalisolate */,
  {    14,  9647,  7700,   3,   8, UNI_NV__2_SLASH_3 }   /* nv=6.67e-01 */,
  {    24,  8424,  6267,   6,   8, UNI_PHAISTOS }   /* block=phaistos */,
  {     0,  8424,  8240,   6,   7, UNI_INSHARADA }   /* block=sharada */,
  {     3,  9093,  2893,   4,  19, UNI_SUPARROWSC }   /* blk=supplementalarrowsc */,
  {    12,   184,  8058,   2,   7, UNI_DSRT }   /* isdeseret */,
  {     4,  9383,  1647,   4,  21, UNI_SHORTHANDFORMATCONTROLS }   /* inshorthandformatcontrols */,
  {    19,  6918,  9753,  10,   2, UNI_LB__B2 }   /* linebreak=b2 */,
  {     4,  8886,  8939,   3,   5, UNI_SC__TALE }   /* sc=taile */,
  {     0,  3671,  9101,  17,   4, UNI_BUHD }   /* scriptextensions=buhd */,
  {     7,  9365,  7118,   4,  10, UNI_WARA }   /* scx=warangciti */,
  {   139,  8886,  6246,   3,   4, UNI_HUNG }   /* sc=hung */,
  {     0,  8886,  9229,   3,   4, UNI_SC__LINB }   /* sc=linb */,
  {     8,  9731,    34,   3,   2, UNI_WB__EX }   /* wb=ex */,
  {     0,  9959,  8326,   4,   5, UNI_ZZZZ }   /* isunknown */,
  {    49,  1257,     0,   2,   0, UNI_UPPERCASELETTER }   /* lu */,
  {     1,  8886,  9213,   3,   4, UNI_LANA }   /* sc=lana */,
  {     2,  4580,   393,   3,   2, UNI_INMRO }   /* inmro */,
  {     5,  1158,  8290,   3,   6, UNI_INTAITHAM }   /* intaitham */,
  {   322,  8086,   995,   7,   2, -UNI_GRBASE }   /* grbase=no */,
  {     9,  3620,     0,   4,   0, UNI_MANI }   /* mani */,
  {    23,  7332,     0,   4,   0, UNI_ITAL }   /* ital */,
  {     0,  8233,  8282,   7,   7, UNI_SC__TGLG }   /* script=tagalog */,
  {     0,  9593,  3074,   3,  18, UNI_BC__FSI }   /* bc=firststrongisolate */,
  {     0,   184,  1192,   2,   4, UNI_KANA }   /* iskana */,
  {     0,  8886,  6901,   6,   7, UNI_KHAR }   /* sc=kharoshthi */,
  {     0,  7025,  7435,   3,   2, UNI_IN__11 }   /* in=11 */,
  {     4,  5085,  4177,   4,  11, UNI_MATHOPERATORS }   /* inmathoperators */,
  {    27,  9093,  5017,   4,  14, UNI_LATINEXTC }   /* blk=latinextendedc */,
  {    65,  3128,     0,  17,   0, UNI_IDSB }   /* idsbinaryoperator */,
  {     0,  9093,  2064,   4,  14, UNI_CJKRADICALSSUP }   /* blk=cjkradicalssup */,
  {    33,  9121,  8864,   4,   5, -UNI_CWL }   /* cwl=false */,
  {     3,  5213,  9734,  14,   3, UNI_NFCQC__Y }   /* nfcquickcheck=yes */,
  {     0,  1362,  7723,  24,   2, UNI_CCC__18 }   /* canonicalcombiningclass=18 */,
  {     0,  6005,   115,   4,  23, UNI_DIACRITICALS }   /* incombiningdiacriticalmarks */,
  {     0,   184,  1030,   3,   5, UNI_COPT }   /* iscoptic */,
  {     0,  8233,  9233,   7,   4, UNI_LISU }   /* script=lisu */,
  {     0,  8412,   995,   6,   2, -UNI_BIDIC }   /* bidic=no */,
  {     6,  3671,  8929,  17,   5, UNI_OSGE }   /* scriptextensions=osage */,
  {    11,  2106,    70,  21,   2, UNI_GCB__PP }   /* graphemeclusterbreak=pp */,
  {    66,  9909,   468,   3,  10, UNI_P }   /* ispunctuation */,
  {    15,  9177,     0,   4,   0, UNI_HANO }   /* hano */,
  {     1,  9093,  3308,   4,  18, UNI_SMALLKANAEXT }   /* blk=smallkanaextension */,
  {    11,  6194,  6979,   3,   9, UNI_INOLDPERSIAN }   /* inoldpersian */,
  {     7,  9608,  9461,   3,   4, UNI_EA__W }   /* ea=wide */,
  {     2,  8233,  9081,   7,   4, UNI_AVST }   /* script=avst */,
  {     2,  6005,  2950,   4,  16, UNI_HALFMARKS }   /* incombininghalfmarks */,
  {   144,    21,  8562,   2,   6, UNI_INLYCIAN }   /* inlycian */,
  {     3,  3671,  9301,  17,   4, UNI_ORKH }   /* scriptextensions=orkh */,
  {     0,  5760,  8376,  13,   3, UNI_NV__500 }   /* numericvalue=500 */,
  {     0,  5085,   330,   4,  19, UNI_MATHOPERATORS }   /* inmathematicaloperators */,
  {     1,  9647,  7756,   3,   8, UNI_NV__7_SLASH_8 }   /* nv=8.75e-01 */,
  {     9,  9093,   689,   4,   9, UNI_INCUNEIFORM }   /* blk=cuneiform */,
  {     2,  8332,  9082,   3,   3, UNI_AVST }   /* isavst */,
  {     1,  9313,   995,   4,   2, -UNI_PCM }   /* pcm=no */,
  {     0,  9623,    87,   3,   2, UNI_JG__HE }   /* jg=he */,
  {    21,  6828,  4284,  12,  13, UNI_BC__BN }   /* bidiclass=boundaryneutral */,
  {     3,  1779,     0,  21,   0, UNI_CWT }   /* changeswhentitlecased */,
  {     0,  3671,  9473,  17,   4, UNI_YI }   /* scriptextensions=yiii */,
  {    33,  6948,     0,  10,   0, UNI_MISCARROWS }   /* miscarrows */,
  {   268,    21,  7248,   2,   9, UNI_INKHUDAWADI }   /* inkhudawadi */,
  {    38,  5565,  9656,  13,   3, UNI_JG__REH }   /* joininggroup=reh */,
  {    24,  8233,  8944,   7,   5, UNI_SC__TAKR }   /* script=takri */,
  {    66,  8886,  6243,   3,  12, UNI_HUNG }   /* sc=oldhungarian */,
  {     0,     0,     0,  42,   0, UNI_UCASEXT }   /* unifiedcanadianaboriginalsyllabicsextended */,
  {     0,  9153,   881,   4,   1, UNI_GCB__V }   /* gcb=v */,
  {     0,  8233,  4946,   7,   4, UNI_CHAM }   /* script=cham */,
  {     0,  9093,  1162,   4,  26, UNI_HALFANDFULLFORMS }   /* blk=halfwidthandfullwidthforms */,
  {     1,  8424,  8303,   6,   7, UNI_INTIBETAN }   /* block=tibetan */,
  {    66,  8685,   995,   4,   2, -UNI_XPOSIXXDIGIT }   /* hex=no */,
  {    65,  9629,  9759,   3,   2, UNI_LB__H3 }   /* lb=h3 */,
  {    13,  7916,     0,   8,   0, UNI_MAHJ }   /* mahajani */,
  {   184,  9731,    18,   3,   2, UNI_RI }   /* wb=ri */,
  {     2,   184,  3603,   2,  17, UNI_LETTERLIKESYMBOLS }   /* isletterlikesymbols */,
  {     0,  4778,    58,   3,   4, UNI_UIDEO }   /* isuideo */,
  {   289,  8640,   995,   6,   2, -UNI_XPOSIXUPPER }   /* upper=no */,
  {     0,  9933,  3248,   7,   5, UNI_XPOSIXSPACE }   /* isxperlspace */,
  {     0,  4627,  8904,  15,   5, UNI_NFCQC__M }   /* nfkcquickcheck=maybe */,
  {     0,  9093,   831,   4,   6, UNI_ARROWS }   /* blk=arrows */,
  {     1,  9113,  2733,   4,   2, UNI_CCC__1 }   /* ccc=ov */,
  {     1,  7058,     0,  10,   0, UNI_SMALLFORMS }   /* smallforms */,
  {     1,   184,  1036,   2,   2, UNI_CASEDLETTER }   /* islc */,
  {     1,  2204,  3201,   3,  17, UNI_ORNAMENTALDINGBATS }   /* isornamentaldingbats */,
  {    14,  4387,     0,  15,   0, UNI_CURRENCYSYMBOLS }   /* currencysymbols */,
  {     0,  9623,  6120,   3,   3, UNI_JG__NYA }   /* jg=nya */,
  {     0,  6231,     0,  12,   0, UNI_nt_values_index }   /* numerictype= */,
  {    12,  8604,     0,   5,   0, UNI_QMARK }   /* qmark */,
  {    38,   184,  2274,   3,  19, UNI_PC }   /* isconnectorpunctuation */,
  {     1,  9647,  8981,   3,   4, UNI_NV__1_SLASH_40 }   /* nv=1/40 */,
  {     2,  9349,     0,   4,   0, UNI_ROHG }   /* rohg */,
  {     3,  9903,    62,   6,   5, UNI_XPOSIXGRAPH }   /* xposixgraph */,
  {    42,  8886,  6690,   3,  11, UNI_SORA }   /* sc=sorasompeng */,
  {     0,  6828,     0,  11,   0, UNI_BC__B }   /* bidiclass=b */,
  {    59,  9093,  9217,   4,   3, UNI_INLAO }   /* blk=lao */,
  {     0,  8424,  2590,   7,  18, UNI_COUNTINGROD }   /* block=countingrodnumerals */,
  {     5,  8233,  8894,   7,   4, UNI_SC__LIMB }   /* script=limb */,
  {     4,   184,  5283,   2,  14, UNI_PHONETICEXTSUP }   /* isphoneticextsup */,
  {     0,  9365,  8699,   4,   5, UNI_BATK }   /* scx=batak */,
  {     0,  3671,  4267,  17,   5, UNI_BAMU }   /* scriptextensions=bamum */,
  {     1,  3248,     0,   6,   0, UNI_wspace_values_index }   /* space= */,
  {     2,  9093,   719,   4,  16, UNI_ENCLOSEDALPHANUM }   /* blk=enclosedalphanum */,
  {     0,  8424,  8550,   6,   6, UNI_INLEPCHA }   /* block=lepcha */,
  {     1,  9623,  5936,   3,   7, UNI_JG__SEMKATH }   /* jg=semkath */,
  {     1,  5339,  1059,  15,   2, UNI_SB__SE }   /* sentencebreak=sep */,
  {     0,  8854,  9433,   5,   4, UNI_DASH }   /* dash=true */,
  {    26,  2148,     0,  21,   0, UNI_PRTI }   /* inscriptionalparthian */,
  {     2,  8886,  8859,   3,   5, UNI_SC__DOGR }   /* sc=dogra */,
  {     0,  5565,  6099,  13,  12, UNI_JG__MALAYALAMNNA }   /* joininggroup=malayalamnna */,
  {     1,  3671,  2085,  17,   8, UNI_CYRL }   /* scriptextensions=cyrillic */,
  {     0,  7025,  9449,   3,   4, UNI_IN__12_DOT_1 }   /* in=v121 */,
  {     1,  3671,  8944,  17,   4, UNI_TAKR }   /* scriptextensions=takr */,
  {     0,  9365,  6183,   4,  12, UNI_MEND }   /* scx=mendekikakui */,
  {    79,  8332,  2393,   3,   2, UNI_ANY }   /* isany */,
  {     5,  8520,     3,   6,   1, -UNI_JOINC }   /* joinc=f */,
  {     0,  9093,  7068,   4,  10, UNI_SUPARROWSA }   /* blk=suparrowsa */,
  {    18,  3671,  9233,  17,   4, UNI_LISU }   /* scriptextensions=lisu */,
  {     0,   184,  7844,   2,   8, UNI_GUJR }   /* isgujarati */,
  {     3,   184,  7852,   2,   8, UNI_GURU }   /* isgurmukhi */,
  {    64,  1497,  1855,   9,   2, UNI_CN }   /* category=cn */,
  {     2,  3671,  2779,  17,   9, UNI_MONG }   /* scriptextensions=mongolian */,
  {    24,  4672,     0,  15,   0, UNI_SARB }   /* oldsoutharabian */,
  {     1,  9153,  5258,   4,  11, UNI_GCB__SM }   /* gcb=spacingmark */,
  {     0,  8955,  8864,   4,   5, -UNI_IDC }   /* idc=false */,
  {     6,  9365,  6898,   4,   4, UNI_KHAR }   /* scx=khar */,
  {     0,  3671,  7860,  17,   4, UNI_HIRA }   /* scriptextensions=hira */,
  {    12,  9365,  7365,   4,   9, UNI_PAUC }   /* scx=paucinhau */,
  {     1,  8424,  3210,   6,   8, UNI_DINGBATS }   /* block=dingbats */,
  {    16,  8424,   218,   7,  32, UNI_DIACRITICALSEXT }   /* block=combiningdiacriticalmarksextended */,
  {   128,  6194,   125,   3,   2, UNI_OCR }   /* inocr */,
  {    24,  3002,  5678,  18,   4, UNI_DT__NONE }   /* decompositiontype=none */,
  {     1,  1497,  1844,   9,   2, UNI_PC }   /* category=pc */,
  {     0,   184,  9089,   2,   4, UNI_BHKS }   /* isbhks */,
  {     7,  5325,  9734,  14,   3, UNI_QMARK }   /* quotationmark=yes */,
  {     0,  9093,  5552,   4,   6, UNI_IPAEXT }   /* blk=ipaext */,
  {     0,  9620,  4829,   3,   5, UNI_XPOSIXDIGIT }   /* gc=digit */,
  {     0,  1497,  3218,   9,  18, UNI_ZP }   /* category=paragraphseparator */,
  {    40,   184,  9775,   2,   2, UNI_ZL }   /* iszl */,
  {     0,  8424,  3980,   6,  16, UNI_LINEARBIDEOGRAMS }   /* block=linearbideograms */,
  {     0,  9623,  7948,   3,   8, UNI_JG__SWASHKAF }   /* jg=swashkaf */,
  {     1,  4627,  9734,  15,   3, UNI_NFKCQC__Y }   /* nfkcquickcheck=yes */,
  {     0,  8233,  2333,   7,   4, UNI_SC__GLAG }   /* script=glag */,
  {     1,  8406,  8864,   6,   5, -UNI_XPOSIXALPHA }   /* alpha=false */,
  {    39,  3038,     0,  18,   0, UNI_ETHIOPICSUP }   /* ethiopicsupplement */,
  {     2,  4582,     0,  15,   0, UNI_MERC }   /* meroiticcursive */,
  {     6,   184,  6869,   3,   9, UNI_COMPATJAMO }   /* iscompatjamo */,
  {     0,  8871,    33,   3,   2, UNI_SB__SE }   /* sb=se */,
  {     5,  9113,  7611,   4,   2, UNI_CCC__14 }   /* ccc=14 */,
  {     0,  5339,    34,  14,   2, UNI_SB__EX }   /* sentencebreak=ex */,
  {     1,  3671,  5311,  17,  14, UNI_PHLP }   /* scriptextensions=psalterpahlavi */,
  {     1,  1497,   878,   9,  10, UNI_CO }   /* category=privateuse */,
  {     0,  7025,  7724,   3,   3, UNI_IN__8 }   /* in=8.0 */,
  {     0,  6828,   835,  10,   2, UNI_BC__WS }   /* bidiclass=ws */,
  {    24,   184,  5907,   2,  12, UNI_ETHIOPICEXTA }   /* isethiopicexta */,
  {     3,  7128,  9773,  10,   2, UNI_WB__XX }   /* wordbreak=xx */,
  {     1,  9365,  9353,   4,   4, UNI_RUNR }   /* scx=runr */,
  {     0,  8424,   837,   6,  11, UNI_PHONETICEXT }   /* block=phoneticext */,
  {     0,  9113,  8467,   5,   4, UNI_CCC__13 }   /* ccc=ccc13 */,
  {     0,  3398,  9734,  18,   3, UNI_VS }   /* variationselector=yes */,
  {     0,  3416,     0,  17,   0, UNI_ALCHEMICAL }   /* alchemicalsymbols */,
  {    27,  8233,  1845,   7,   6, UNI_SC__ZYYY }   /* script=common */,
  {     1,  8616,     0,   7,   0, UNI_STERM }   /* sterm=t */,
  {     0,    21,  3418,   4,   8, UNI_ALCHEMICAL }   /* inalchemical */,
  {    36,  8886,  8121,   3,   7, UNI_SC__LINA }   /* sc=lineara */,
  {    16,  7018,  9695,  10,   3, UNI_IN__5 }   /* presentin=v50 */,
  {     0,  8424,     0,   6,  42, UNI_UCASEXT }   /* block=unifiedcanadianaboriginalsyllabicsextended */,
  {     0,  8233,  8859,   7,   4, UNI_SC__DOGR }   /* script=dogr */,
  {    24,  5513,  8864,  13,   5, -UNI_GRBASE }   /* graphemebase=false */,
  {    43,  8424,  7788,   6,   8, UNI_INBALINESE }   /* block=balinese */,
  {     1,  8886,  7812,   3,   4, UNI_SC__DUPL }   /* sc=dupl */,
  {     1,  9093,   414,   4,  32, UNI_INIDC }   /* blk=ideographicdescriptioncharacters */,
  {     7,  8886,  9361,   3,   4, UNI_SARB }   /* sc=sarb */,
  {     0,  4705,  7957,   3,   3, UNI_TAGB }   /* istagb */,
  {     0,  9049,  7495,   4,   1, UNI_AGE__7 }   /* age=7 */,
  {     4,  8233,  9345,   7,   4, UNI_RJNG }   /* script=rjng */,
  {    11,  6580,     0,  11,   0, UNI_MYANMAREXTA }   /* myanmarexta */,
  {     3,  1497,  2192,   9,   2, UNI_PD }   /* category=pd */,
  {     3,  9365,  9117,   4,   4, UNI_CPRT }   /* scx=cprt */,
  {     5,  1790,     0,   5,   0, UNI_TITLE }   /* title */,
  {     0,  5835,     0,   5,   0, UNI_BIDIC }   /* bidic */,
  {     2,  7018,  9548,  10,   3, UNI_IN__3 }   /* presentin=3.0 */,
  {     0,  3868,  6635,  16,  11, UNI_SO }   /* generalcategory=othersymbol */,
  {     0,  9629,  4631,   3,   2, UNI_LB__QU }   /* lb=qu */,
  {    32,  8430,     0,   4,   0, UNI_CARI }   /* cari */,
  {    13,  8338,  8864,   7,   5, -UNI_XPOSIXSPACE }   /* wspace=false */,
  {     2,  7018,  7507,  10,   2, UNI_IN__12 }   /* presentin=12 */,
  {     1,   184,  8709,   2,   5, UNI_BUHD }   /* isbuhid */,
  {    13,  9731,  7293,   3,   9, UNI_WB__MB }   /* wb=midnumlet */,
  {    28,  1136,  8864,  26,   5, -UNI_DI }   /* defaultignorablecodepoint=false */,
  {    14,  8219,  8864,   7,   5, -UNI_PATSYN }   /* patsyn=false */,
  {    68,  1867,     0,  22,   0, UNI_DIACRITICALSFORSYMBOLS }   /* diacriticalsforsymbols */,
  {     0,  9365,  8072,   4,   7, UNI_ELYM }   /* scx=elymaic */,
  {     1,  5017,     0,  14,   0, UNI_LATINEXTC }   /* latinextendedc */,
  {     0,  9237,    26,   4,   1, UNI_LOE }   /* loe=y */,
  {     0,  8886,  9217,   3,   3, UNI_LAO }   /* sc=lao */,
  {     0,  9365,  2212,   5,   6, UNI_SINH }   /* scx=sinhala */,
  {     3,  7025,  7507,   3,   2, UNI_IN__12 }   /* in=12 */,
  {     0,  8586,    26,   6,   1, UNI_NFCQC__Y }   /* nfcqc=y */,
  {    11,  9093,  8261,   4,   7, UNI_INSOYOMBO }   /* blk=soyombo */,
  {     0,  8424,  2148,   6,  21, UNI_ININSCRIPTIONALPARTHIAN }   /* block=inscriptionalparthian */,
  {     1,   184,  1411,   3,  23, UNI_DIACRITICALSFORSYMBOLS }   /* iscombiningmarksforsymbols */,
  {     1,  9313,  9734,   4,   3, UNI_PCM }   /* pcm=yes */,
  {     1,  8233,  9269,   7,   4, UNI_SC__MYMR }   /* script=mymr */,
  {     0,  1158,  4718,   3,   4, UNI_INTAMIL }   /* intamil */,
  {     0,  8233,  9173,   7,   4, UNI_SC__GURU }   /* script=guru */,
  {     1,  3868,  1410,  16,  13, UNI_M }   /* generalcategory=combiningmark */,
  {     0,   184,  8508,   2,   5, UNI_GREXT }   /* isgrext */,
  {    84,  1713,     0,  22,   0, UNI_cwcf_values_index }   /* changeswhencasefolded= */,
  {   281,  2453,     3,  20,   1, -UNI_TERM }   /* terminalpunctuation=f */,
  {     0,  1450,  2178,   5,   5, UNI_GREEKEXT }   /* ingreekext */,
  {     0,  8424,  2646,   6,  19, UNI_JAMOEXTA }   /* block=hanguljamoextendeda */,
  {     0,  7420,    36,   8,   1, UNI_IDS }   /* idstart=t */,
  {     1,  4642,   995,  15,   2, UNI_NFKDQC__N }   /* nfkdquickcheck=no */,
  {    72,  9093,  8037,   4,   7, UNI_CJKEXTE }   /* blk=cjkexte */,
  {     1,  8051,    26,   7,   1, UNI_COMPEX }   /* compex=y */,
  {     5,  7419,     0,   4,   0, UNI_XIDS }   /* xids */,
  {     0,  1844,     0,   2,   0, UNI_PC }   /* pc */,
  {     4,  1362,  9515,  24,   3, UNI_CCC__214 }   /* canonicalcombiningclass=214 */,
  {     0,    21,  8652,   2,   6, UNI_INWANCHO }   /* inwancho */,
  {    46,  8886,  9405,   3,   4, UNI_TALU }   /* sc=talu */,
  {     0,  8635,   995,   5,   2, -UNI_IDEO }   /* ideo=no */,
  {    14,    21,  3603,   2,  17, UNI_LETTERLIKESYMBOLS }   /* inletterlikesymbols */,
  {    84,  9093,   837,   4,  28, UNI_PHONETICEXTSUP }   /* blk=phoneticextensionssupplement */,
  {     0,  5339,   721,  14,   2, UNI_SB__CL }   /* sentencebreak=cl */,
  {     9,  5565,  2561,  13,   9, UNI_JG__YEHBARREE }   /* joininggroup=yehbarree */,
  {    51,  8580,     0,   6,   0, UNI_nchar_values_index }   /* nchar= */,
  {     0,  8424,  8275,   6,   7, UNI_SUPPUAB }   /* block=suppuab */,
  {     2,  6005,  4864,   3,  13, UNI_CJKCOMPATFORMS }   /* incjkcompatforms */,
  {     1,  9620,  1156,   3,   2, UNI_PO }   /* gc=po */,
  {     6,  3002,  4801,  18,   6, UNI_DT__SQR }   /* decompositiontype=square */,
  {   194,   262,     0,   2,   0, UNI_SM }   /* sm */,
  {     1,  3671,  2837,  18,   8, UNI_SUND }   /* scriptextensions=sundanese */,
  {     0,   184,  4792,   2,  15, UNI_ZANB }   /* iszanabazarsquare */,
  {     1,  9365,  9265,   4,   4, UNI_MTEI }   /* scx=mtei */,
  {    44,  3398,    36,  18,   1, UNI_VS }   /* variationselector=t */,
  {    37,  8233,  7964,   7,   8, UNI_TFNG }   /* script=tifinagh */,
  {    13,  3772,     0,  11,   0, UNI_BOPOMOFOEXT }   /* bopomofoext */,
  {     3,   467,     0,  11,   0, UNI_P }   /* punctuation */,
  {    31,  9647,  8364,   3,   4, UNI_NV__4000 }   /* nv=4000 */,
  {    71,   184,   435,   2,   5, UNI__PERL_NCHAR }   /* isnchar */,
  {    16,   184,  8840,   3,   4, UNI_XPOSIXCNTRL }   /* iscntrl */,
  {     0,  3671,  8924,  17,   5, UNI_ORYA }   /* scriptextensions=oriya */,
  {    10,  6690,     0,  11,   0, UNI_SORA }   /* sorasompeng */,
  {     8,  8886,  9493,   3,   4, UNI_ZZZZ }   /* sc=zzzz */,
  {    24,  7018,  9578,  10,   3, UNI_IN__6_DOT_3 }   /* presentin=6.3 */,
  {   139,  6918,  8100,  10,   6, UNI_LB__HY }   /* linebreak=hyphen */,
  {     0,  8424,  2798,   6,  19, UNI_OTTOMANSIYAQNUMBERS }   /* block=ottomansiyaqnumbers */,
  {     3,  9647,  8352,   3,   6, UNI_NV__216000 }   /* nv=216000 */,
  {     1,  2106,  3254,  21,  17, UNI_RI }   /* graphemeclusterbreak=regionalindicator */,
  {     0,  9365,  6243,   4,  12, UNI_HUNG }   /* scx=oldhungarian */,
  {     3,  9647,  8394,   3,   3, UNI_NV__800 }   /* nv=800 */,
  {    27,  9093,  5311,   4,  14, UNI_INPSALTERPAHLAVI }   /* blk=psalterpahlavi */,
  {     3,  9946,   107,   3,   5, UNI_S }   /* issymbol */,
  {    66,  9093,  2984,   4,   6, UNI_INCOPTIC }   /* blk=coptic */,
  {     0,  9093,  5617,   4,   9, UNI_INMALAYALAM }   /* blk=malayalam */,
  {     0,  8854,     0,   5,   0, UNI_dash_values_index }   /* dash= */,
  {     0,  9093,  3552,   4,  16, UNI_ETHIOPICEXT }   /* blk=ethiopicextended */,
  {     4,   184,  2065,   3,  13, UNI_CJKRADICALSSUP }   /* iscjkradicalssup */,
  {     1,  9049,  7507,   4,   4, UNI_AGE__12 }   /* age=12.0 */,
  {     0,  9253,     0,   4,   0, UNI_MIAO }   /* miao */,
  {    40,  8886,  8568,   3,   6, UNI_LYDI }   /* sc=lydian */,
  {     0,  8233,  9305,   7,   4, UNI_SC__ORYA }   /* script=orya */,
  {     0,  3671,  8538,  17,   4, UNI_KHOJ }   /* scriptextensions=khoj */,
  {     0,  4447,  9461,  15,   4, UNI_EA__W }   /* eastasianwidth=wide */,
  {    27,  3671,  9065,  17,   4, UNI_ARMI }   /* scriptextensions=armi */,
  {     0,  9093,  3756,   4,   9, UNI_ARABICSUP }   /* blk=arabicsup */,
  {     0,  8424,  2893,   6,  19, UNI_SUPARROWSC }   /* block=supplementalarrowsc */,
  {     0,   184,  1411,   3,  12, UNI_M }   /* iscombiningmark */,
  {     1,  6015,  6291,  12,  12, UNI_JT__R }   /* joiningtype=rightjoining */,
  {     0,  9393,     0,   4,   0, UNI_SYRC }   /* syrc */,
  {     0,  8332,  7774,   4,   6, UNI_ARMN }   /* isarmenian */,
  {     0,  5565,  8658,  13,   6, UNI_JG__YUDHHE }   /* joininggroup=yudhhe */,
  {     1,  9093,  7980,   4,   8, UNI_INUGARITIC }   /* blk=ugaritic */,
  {     1,  9647,  9503,   3,   3, UNI_NV__1_SLASH_9 }   /* nv=1/9 */,
  {     5,  9049,  9713,   4,   3, UNI_AGE__6_DOT_3 }   /* age=v63 */,
  {     0,  6918,   495,  10,   2, UNI_LB__NU }   /* linebreak=nu */,
  {     1,  6885,  2647,   3,  18, UNI_JAMOEXTA }   /* ishanguljamoextendeda */,
  {     0,  9365,  3038,   4,   4, UNI_ETHI }   /* scx=ethi */,
  {     3,  1532,     0,   1,   0, UNI_Z }   /* z */,
  {    29,  9365,  9069,   4,   4, UNI_ARMN }   /* scx=armn */,
  {     0,    21,  6767,   2,  11, UNI_YISYLLABLES }   /* inyisyllables */,
  {     0,  9953,    67,   3,   4, UNI_VSSUP }   /* isvssup */,
  {   101,  9365,  2484,   4,   4, UNI_MAND }   /* scx=mand */,
  {     0,  9093,  8003,   5,   6, UNI_INBENGALI }   /* blk=bengali */,
  {     1,  8886,  2741,   3,  19, UNI_MERO }   /* sc=meroitichieroglyphs */,
  {    36,  8233,  9261,   7,   3, UNI_MRO }   /* script=mro */,
  {   135,  9093,  2253,   4,  20, UNI_INANATOLIANHIEROGLYPHS }   /* blk=anatolianhieroglyphs */,
  {     0,  9647,  8394,   3,   5, UNI_NV__80000 }   /* nv=80000 */,
  {     1,  7239,     0,   9,   0, UNI_QAAI }   /* inherited */,
  {     8,  9093,  7302,   4,   9, UNI_INNABATAEAN }   /* blk=nabataean */,
  {     3,  2021,     0,  15,   0, UNI_TRANSPORTANDMAP }   /* transportandmap */,
  {   144,   184,  6382,   2,  11, UNI_DOMINO }   /* isdominotiles */,
  {     0,   629,     0,  30,   0, UNI_CJKEXTE }   /* cjkunifiedideographsextensione */,
  {     1,   184,  4597,   2,  15, UNI_MISCPICTOGRAPHS }   /* ismiscpictographs */,
  {     0,  9647,  7748,   3,   8, UNI_NV__17_SLASH_2 }   /* nv=8.50e+00 */,
  {     0,  6828,   102,  10,   2, UNI_BC__ET }   /* bidiclass=et */,
  {     3,  9365,  8610,   4,   6, UNI_RJNG }   /* scx=rejang */,
  {     4,  5565,  3916,  13,  16, UNI_JG__HANIFIROHINGYAPA }   /* joininggroup=hanifirohingyapa */,
  {     0,   184,  7788,   2,   4, UNI_BALI }   /* isbali */,
  {     2,  6338,     1,  11,   1, -UNI_XPOSIXALPHA }   /* alphabetic=n */,
  {     1,   184,  2985,   3,  17, UNI_COPTICEPACTNUMBERS }   /* iscopticepactnumbers */,
  {     2,  9049,  9581,   4,   3, UNI_AGE__7 }   /* age=7.0 */,
  {     0,  8233,  2212,   8,   3, UNI_SC__SINH }   /* script=sinh */,
  {     1,  7884,     0,   8,   0, UNI_JAMOEXTB }   /* jamoextb */,
  {     0,  8233,  7049,   8,   9, UNI_SAUR }   /* script=saurashtra */,
  {     0,  1497,  4687,   9,  15, UNI_PS }   /* category=openpunctuation */,
  {     0,   184,  2532,   2,   4, UNI_BRAH }   /* isbrah */,
  {     4,  5835,  8864,  12,   5, -UNI_BIDIC }   /* bidicontrol=false */,
  {     4,  8424,  7302,   6,   9, UNI_INNABATAEAN }   /* block=nabataean */,
  {     0,  9093,   921,   4,  18, UNI_INVS }   /* blk=variationselectors */,
  {     4,  9093,  9057,   4,   4, UNI_INAHOM }   /* blk=ahom */,
  {   230,  3671,  3772,  17,   4, UNI_BOPO }   /* scriptextensions=bopo */,
  {     0,  3671,     0,  17,   0, UNI_scx_values_index }   /* scriptextensions= */,
  {     2,  8424,  4975,   6,  14, UNI_KANASUP }   /* block=kanasupplement */,
  {     1,    21,  5604,   2,  13, UNI_LOWSURROGATES }   /* inlowsurrogates */,
  {     0,  9599,     3,   3,   1, -UNI_CI }   /* ci=f */,
  {     9,  9093,  1003,   4,  11, UNI_ENCLOSEDCJK }   /* blk=enclosedcjk */,
  {     3,  3254,  8864,  18,   5, -UNI_RI }   /* regionalindicator=false */,
  {   134,  9093,  8894,   4,   5, UNI_INLIMBU }   /* blk=limbu */,
  {     0,  8886,  8191,   3,   7, UNI_OLCK }   /* sc=olchiki */,
  {     6,  9623,  6087,   3,  12, UNI_JG__MALAYALAMNGA }   /* jg=malayalamnga */,
  {     5,  9093,  6939,   4,   2, UNI_INVS }   /* blk=vs */,
  {     2,  9113,  8725,   5,   4, UNI_CCC__16 }   /* ccc=ccc16 */,
  {     3,  9093,  6027,   4,   5, UNI_INKHMER }   /* blk=khmer */,
  {     2,  3671,  7118,  17,  10, UNI_WARA }   /* scriptextensions=warangciti */,
  {    15,  8160,   781,   4,  20, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* inenclosedideographicsup */,
  {     0,  3671,  8324,  17,   7, UNI_ZZZZ }   /* scriptextensions=unknown */,
  {     3,  9365,  6898,   4,  10, UNI_KHAR }   /* scx=kharoshthi */,
  {   321,  9909,     0,   3,   0, UNI_P }   /* isp */,
  {     1,  4705,  9414,   3,   3, UNI_TAVT }   /* istavt */,
  {    40,  9093,  8944,   4,   5, UNI_INTAKRI }   /* blk=takri */,
  {     2,  6885,  1363,   3,   3, UNI_HANO }   /* ishano */,
  {     0,  2212,  2021,   4,   4, UNI_INHATRAN }   /* inhatran */,
  {    12,  7995,     0,   7,   0, UNI_AVST }   /* avestan */,
  {    48,  9909,  5492,   7,   5, UNI_POSIXALNUM }   /* isposixalnum */,
  {     0,  6949,  3469,   4,  15, UNI_AGHB }   /* iscaucasianalbanian */,
  {    38,  9647,  9025,   3,   4, UNI_NV__3_SLASH_20 }   /* nv=3/20 */,
  {     0,   184,  4175,   2,  13, UNI_MATHOPERATORS }   /* ismathoperators */,
  {    29,  5760,  7459,  13,   2, UNI_NV__21 }   /* numericvalue=21 */,
  {     3,  1497,   206,   9,   2, UNI_PI }   /* category=pi */,
  {     0,  9946,    17,   3,   1, UNI_SO }   /* isso */,
  {     0,   184,  5786,   2,  13, UNI_VERTICALFORMS }   /* isverticalforms */,
  {     2,  8960,  9433,   4,   4, UNI_IDS }   /* ids=true */,
  {     4,  9093,  7148,   4,  10, UNI_YIRADICALS }   /* blk=yiradicals */,
  {     0,  9049,  7446,   4,   1, UNI_AGE__2 }   /* age=2 */,
  {     4,  4447,     0,  15,   0, UNI_ea_values_index }   /* eastasianwidth= */,
  {     2,  8051,  9433,   7,   4, UNI_COMPEX }   /* compex=true */,
  {     0,   509,     0,  20,   0, UNI_CJK }   /* cjkunifiedideographs */,
  {     2,  8424,   865,   6,  28, UNI_SUPPUAA }   /* block=supplementaryprivateuseareaa */,
  {     0,  7018,  7435,  10,   2, UNI_IN__11 }   /* presentin=11 */,
  {     3,  8886,  9261,   3,   4, UNI_MRO }   /* sc=mroo */,
  {    17,  9093,    42,   4,  26, UNI_CJKCOMPATIDEOGRAPHS }   /* blk=cjkcompatibilityideographs */,
  {     0,  8884,  2768,   5,  10, UNI_INSC__TONELETTER }   /* insc=toneletter */,
  {    12,  9767,     0,   2,   0, UNI_CASEDLETTER }   /* l& */,
  {     0,  5565,  8964,  13,   5, UNI_JG__ZHAIN }   /* joininggroup=zhain */,
  {     1,  9959,  1152,   5,   4, UNI_ANY }   /* isunicode */,
  {     0,  9093,  7844,   4,   8, UNI_INGUJARATI }   /* blk=gujarati */,
  {     0,   184,  3502,   3,  16, UNI_CYRILLICEXTA }   /* iscyrillicextendeda */,
  {   273,  6194,  8192,   3,   6, UNI_OLCK }   /* inolchiki */,
  {     7,   184,  8107,   2,   7, UNI_KNDA }   /* iskannada */,
  {    36,  9093,  1867,   4,  12, UNI_DIACRITICALS }   /* blk=diacriticals */,
  {     2,  9125,  8864,   4,   5, -UNI_CWT }   /* cwt=false */,
  {   129,  1933,   995,  22,   2, -UNI_LOE }   /* logicalorderexception=no */,
  {     2,  9093,  4268,   5,   7, UNI_BAMUMSUP }   /* blk=bamumsup */,
  {     4,  9365,  7812,   4,   4, UNI_DUPL }   /* scx=dupl */,
  {    24,  9113,  8463,   4,   3, UNI_CCC__129 }   /* ccc=129 */,
  {     1,  8640,    36,   6,   1, UNI_XPOSIXUPPER }   /* upper=t */,
  {     1,  8424,  4220,   6,  16, UNI_TANGUTCOMPONENTS }   /* block=tangutcomponents */,
  {    88,  8424,  7148,   6,  10, UNI_YIRADICALS }   /* block=yiradicals */,
  {     1,  3671,  2484,  17,   4, UNI_MAND }   /* scriptextensions=mand */,
  {     0,  8233,  7892,   7,   4, UNI_SC__JAVA }   /* script=java */,
  {    16,  9620,    32,   3,   2, UNI__PERL_SURROGATE }   /* gc=cs */,
  {     2,  8424,   779,   6,  22, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* block=enclosedideographicsup */,
  {     5,  8424,  2665,   6,  19, UNI_JAMOEXTB }   /* block=hanguljamoextendedb */,
  {     0,  9225,     0,   4,   0, UNI_LINA }   /* lina */,
  {     1,  4705,  8297,   3,   6, UNI_TAVT }   /* istaiviet */,
  {     0,  4705,  7965,   3,   7, UNI_TFNG }   /* istifinagh */,
  {     0,  1386,     0,  10,   0, UNI_CJKSYMBOLS }   /* cjksymbols */,
  {     0,  8424,  6948,   6,  10, UNI_MISCARROWS }   /* block=miscarrows */,
  {     0,  8510,     0,   4,   0, UNI_ext_values_index }   /* ext= */,
  {     0,  6918,  2368,  10,   2, UNI_LB__HL }   /* linebreak=hl */,
  {     0,  9093,  4108,   4,  16, UNI_MYANMAREXTA }   /* blk=myanmarextendeda */,
  {    32,  9365,  1146,   5,   3, UNI_SORA }   /* scx=sora */,
  {     1,  7128,   495,  10,   7, UNI_WB__NU }   /* wordbreak=numeric */,
  {     0,  9093,  7797,   5,   7, UNI_INBASSAVAH }   /* blk=bassavah */,
  {     1,  8424,   446,   6,  18, UNI_IDEOGRAPHICSYMBOLS }   /* block=ideographicsymbols */,
  {    12,  9623,  6785,   3,   3, UNI_JG__FEH }   /* jg=feh */,
  {    35,  3671,    78,  17,   4, UNI_ARAB }   /* scriptextensions=arab */,
  {     7,  8886,  2608,   3,  19, UNI_EGYP }   /* sc=egyptianhieroglyphs */,
  {     0,  9365,  9413,   4,   4, UNI_TAVT }   /* scx=tavt */,
  {     1,  6798,     0,  10,   0, UNI_ARABICEXTA }   /* arabicexta */,
  {    41,  9623,  9641,   3,   3, UNI_JG__MIM }   /* jg=mim */,
  {    32,  8424,  8268,   6,   7, UNI_SUPPUAA }   /* block=suppuaa */,
  {     0,  4402,     0,  15,   0, UNI_PD }   /* dashpunctuation */,
  {     0,  9629,    96,   3,  10, UNI_LB__AL }   /* lb=alphabetic */,
  {     0,  9365,  9429,   4,   4, UNI_TIBT }   /* scx=tibt */,
  {     3,  9647,  8376,   3,   4, UNI_NV__5000 }   /* nv=5000 */,
  {     1,  8568,     0,   6,   0, UNI_LYDI }   /* lydian */,
  {     2,  9647,  9739,   3,   2, UNI_NV__39 }   /* nv=39 */,
  {     0,  8899,  9433,   5,   4, UNI_MATH }   /* math=true */,
  {     6,  3868,  4140,  16,  16, UNI_PO }   /* generalcategory=otherpunctuation */,
  {   298,   184,  9217,   2,   3, UNI_LAO }   /* islao */,
  {     0,  8160,  1005,   4,   9, UNI_ENCLOSEDCJK }   /* inenclosedcjk */,
  {     0,  9365,  4267,   4,   4, UNI_BAMU }   /* scx=bamu */,
  {     2,  9731,  9611,   3,   3, UNI_WB__EB }   /* wb=ebg */,
  {     0,  7018,  7660,  10,   3, UNI_IN__6 }   /* presentin=6.0 */,
  {     3,  8510,  8864,   4,   5, -UNI_EXT }   /* ext=false */,
  {    14,  8233,  9481,   7,   4, UNI_ZANB }   /* script=zanb */,
  {     0,  8886,  7804,   3,   4, UNI_SC__BUGI }   /* sc=bugi */,
  {     0,  5085,  6161,   4,  10, UNI_INMASARAMGONDI }   /* inmasaramgondi */,
  {     0,  8616,   995,   6,   2, -UNI_STERM }   /* sterm=no */,
  {     1,  5085,   480,   4,  29, UNI_MATHALPHANUM }   /* inmathematicalalphanumericsymbols */,
  {     1,  1911,  8331,  22,   7, UNI_INSC__VISARGA }   /* indicsyllabiccategory=visarga */,
  {     0,  6888,  9433,  10,   4, UNI_DIA }   /* diacritic=true */,
  {     0,  5339,   125,  14,   2, UNI_LB__CR }   /* sentencebreak=cr */,
  {     4,  8886,  3020,   3,   4, UNI_SC__DEVA }   /* sc=deva */,
  {     1,  8233,  6992,   8,   3, UNI_SC__SOGD }   /* script=sogd */,
  {     0,   184,   149,   3,  34, UNI_DIACRITICALSSUP }   /* iscombiningdiacriticalmarkssupplement */,
  {     0,  8205,     0,   7,   0, UNI_OSMA }   /* osmanya */,
  {     7,  8424,  2065,   7,  13, UNI_CJKRADICALSSUP }   /* block=cjkradicalssup */,
  {    30,  2513,     0,  19,   0, UNI_ANCIENTGREEKNUMBERS }   /* ancientgreeknumbers */,
  {    49,  9608,     9,   3,   2, UNI_EA__NA }   /* ea=na */,
  {    12,  9626,  6515,   4,  10, UNI_JT__L }   /* jt=leftjoining */,
  {     2,  7048,     0,   4,   0, UNI_SAUR }   /* saur */,
  {   274,  6005,    43,   3,  15, UNI_CJKCOMPAT }   /* incjkcompatibility */,
  {     0,  8886,  2202,   4,   3, UNI_SC__KALI }   /* sc=kali */,
  {     0,  9623,  5381,   3,  14, UNI_JG__HAMZAONHEHGOAL }   /* jg=tehmarbutagoal */,
  {     0,  9623,  9245,   3,   4, UNI_JG__MEEM }   /* jg=meem */,
  {     0,  9593,  2817,   3,  19, UNI_BC__RLO }   /* bc=righttoleftoverride */,
  {     1,  6816,  6839,   3,   9, UNI_BOXDRAWING }   /* inboxdrawing */,
  {     0,  9093,  7365,   4,   9, UNI_INPAUCINHAU }   /* blk=paucinhau */,
  {     5,  3002,    45,  18,   3, UNI_DT__COM }   /* decompositiontype=com */,
  {     0,   184,  9281,   2,   4, UNI_NEWA }   /* isnewa */,
  {     9,  2684,  5747,  19,  13, UNI_HST__NA }   /* hangulsyllabletype=notapplicable */,
  {     2,  9093,  2741,   4,  19, UNI_MERO }   /* blk=meroitichieroglyphs */,
  {    10,   184,    43,   3,  35, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* iscjkcompatibilityideographssupplement */,
  {     0,  8233,  9213,   7,   4, UNI_LANA }   /* script=lana */,
  {     4,  8424,  1530,   6,  23, UNI_BYZANTINEMUSIC }   /* block=byzantinemusicalsymbols */,
  {     1,  8332,    27,   3,   2, UNI_ALL }   /* isall */,
  {     1,  1536,  3553,   3,  15, UNI_ETHIOPICEXT }   /* inethiopicextended */,
  {    12,  5967,     0,   4,   0, UNI_HEBR }   /* hebr */,
  {     8,  8424,  7884,   6,   8, UNI_JAMOEXTB }   /* block=jamoextb */,
  {     1,  9365,  3620,   4,   4, UNI_MANI }   /* scx=mani */,
  {     0,  5339,     0,  14,   0, UNI_sb_values_index }   /* sentencebreak= */,
  {     3,  8424,  5896,   7,  11, UNI_CYRILLICEXTC }   /* block=cyrillicextc */,
  {    84,  6885,  2666,   3,  18, UNI_JAMOEXTB }   /* ishanguljamoextendedb */,
  {     0,  1084,    36,  26,   1, UNI_CWKCF }   /* changeswhennfkccasefolded=t */,
  {     0,  5565,  6334,  13,   4, UNI_JG__NOON }   /* joininggroup=noon */,
  {     0,  9365,   382,   4,   4, UNI_EGYP }   /* scx=egyp */,
  {     0,  1362,    18,  24,   1, UNI_CCC__R }   /* canonicalcombiningclass=r */,
  {     7,  9153,    18,   4,   2, UNI_RI }   /* gcb=ri */,
  {     1,  8424,  2608,   6,  19, UNI_INEGYPTIANHIEROGLYPHS }   /* block=egyptianhieroglyphs */,
  {     1,  8684,     0,   5,   0, UNI_ahex_values_index }   /* ahex= */,
  {     0,  3293,  7981,   3,   7, UNI_INUGARITIC }   /* inugaritic */,
  {     0,  9261,     0,   4,   0, UNI_MRO }   /* mroo */,
  {     0,   184,  3227,   2,   9, UNI_Z }   /* isseparator */,
  {     0,   659,     0,  30,   0, UNI_CJKEXTF }   /* cjkunifiedideographsextensionf */,
  {     0,  9365,  2127,   4,   4, UNI_HAN }   /* scx=hani */,
  {     2,  8424,  6027,   6,  12, UNI_KHMERSYMBOLS }   /* block=khmersymbols */,
  {     5,  5760,  8981,  13,   3, UNI_NV__1_SLASH_4 }   /* numericvalue=1/4 */,
  {     0,  9153,  5394,   4,   2, UNI_LB__H2 }   /* gcb=lv */,
  {     0,  8233,  2253,   7,  20, UNI_HLUW }   /* script=anatolianhieroglyphs */,
  {     0,  9049,  9677,   4,   3, UNI_AGE__2_DOT_1 }   /* age=v21 */,
  {     1,  6316,  8864,  11,   5, -UNI_IDC }   /* idcontinue=false */,
  {     0,  3868,  1844,  16,   2, UNI_PC }   /* generalcategory=pc */,
  {     0,  6918,  4835,  10,  14, UNI_LB__CR }   /* linebreak=carriagereturn */,
  {     1,  9113,  8802,   4,   2, UNI_CCC__31 }   /* ccc=31 */,
  {     4,  8871,  8198,   3,   7, UNI_SB__LE }   /* sb=oletter */,
  {     0,  9620,  7098,   3,  10, UNI_CN }   /* gc=unassigned */,
  {     0,  9153,   262,   4,   2, UNI_GCB__SM }   /* gcb=sm */,
  {     1,  9121,     0,   3,   0, UNI_CWL }   /* cwl */,
  {     0,  9629,  4835,   3,  14, UNI_LB__CR }   /* lb=carriagereturn */,
  {     0,  9365,  9337,   4,   4, UNI_QAAI }   /* scx=qaai */,
  {     0,   117,   415,   3,  31, UNI_INIDC }   /* inideographicdescriptioncharacters */,
  {    89,   184,  5435,   2,   5, UNI_BIDIM }   /* isbidim */,
  {     1,  8886,  9265,   3,   4, UNI_MTEI }   /* sc=mtei */,
  {     0,  9647,  9509,   3,   3, UNI_NV__2_SLASH_5 }   /* nv=2/5 */,
  {     0,  9093,  4657,   4,  15, UNI_NARB }   /* blk=oldnortharabian */,
  {     0,  4826,    26,   9,   1, UNI_XPOSIXXDIGIT }   /* hexdigit=y */,
  {     0,  5760,  5409,  13,   7, UNI_NV__1000000 }   /* numericvalue=1000000 */,
  {    12,  3128,   995,  18,   2, -UNI_IDSB }   /* idsbinaryoperator=no */,
  {     0,  1003,     0,  27,   0, UNI_ENCLOSEDCJK }   /* enclosedcjklettersandmonths */,
  {     0,   184,  5872,   3,  11, UNI_CYRILLICEXTA }   /* iscyrillicexta */,
  {     0,  9093,  4387,   4,  15, UNI_CURRENCYSYMBOLS }   /* blk=currencysymbols */,
  {     2,  5565,  6788,  13,  10, UNI_JG__AFRICANQAF }   /* joininggroup=africanqaf */,
  {     7,   184,  2532,   2,   6, UNI_BRAH }   /* isbrahmi */,
  {    25,   831,     0,   6,   0, UNI_ARROWS }   /* arrows */,
  {     0,  9904,  1812,   5,   5, UNI_POSIXUPPER }   /* posixupper */,
  {     0,  8406,  9433,   6,   4, UNI_XPOSIXALPHA }   /* alpha=true */,
  {     2,  4849,    36,  14,   1, UNI_CI }   /* caseignorable=t */,
  {     0,  3128,  8864,  18,   5, -UNI_IDSB }   /* idsbinaryoperator=false */,
  {    32,  9946,     0,   3,   0, UNI_S }   /* iss */,
  {     0,  4618,  2335,   4,  18, UNI_GLAGOLITICSUP }   /* inglagoliticsupplement */,
  {    96,  8233,  7860,   7,   4, UNI_SC__HIRA }   /* script=hira */,
  {     2,  9620,    25,   3,   1, UNI_S }   /* gc=s */,
  {     3,  7025,  7660,   3,   3, UNI_IN__6 }   /* in=6.0 */,
  {     3,  3964,     0,   6,   0, UNI_LATIN1 }   /* latin1 */,
  {     1,  8424,  4864,   7,  13, UNI_CJKCOMPATFORMS }   /* block=cjkcompatforms */,
  {     0,  3671,  9205,  17,   4, UNI_KNDA }   /* scriptextensions=knda */,
  {     0,  8886,  8149,   3,   4, UNI_SC__MULT }   /* sc=mult */,
  {    97,  8424,  8191,   6,   7, UNI_OLCK }   /* block=olchiki */,
  {     3,  9093,  4961,   4,  14, UNI_HIGHSURROGATES }   /* blk=highsurrogates */,
  {     0,  5760,  7683,  13,   2, UNI_NV__26 }   /* numericvalue=26 */,
  {     2,  5565,  9381,  13,   4, UNI_JG__SHIN }   /* joininggroup=shin */,
  {     1,  5565,  7392,  13,   9, UNI_JG__SYRIACWAW }   /* joininggroup=syriacwaw */,
  {     1,  6885,  1600,   3,   5, UNI_HANG }   /* ishangul */,
  {    56,  1713,   995,  22,   2, -UNI_CWCF }   /* changeswhencasefolded=no */,
  {     4,  9093,  7374,   4,   9, UNI_INSAMARITAN }   /* blk=samaritan */,
  {     1,  8424,  3308,   6,  18, UNI_SMALLKANAEXT }   /* block=smallkanaextension */,
  {     0,   184,  8568,   2,   4, UNI_LYDI }   /* islydi */,
  {     0,  1362,  1701,  24,   2, UNI_CCC__BR }   /* canonicalcombiningclass=br */,
  {    20,  8685,     1,   4,   1, -UNI_XPOSIXXDIGIT }   /* hex=n */,
  {     0,  6949,     9,   4,  16, UNI_CANS }   /* iscanadianaboriginal */,
  {     0,  7788,     0,   4,   0, UNI_BALI }   /* bali */,
  {   244,  8233,  4657,   7,  15, UNI_NARB }   /* script=oldnortharabian */,
  {    10,   184,  1387,   3,   9, UNI_CJKSYMBOLS }   /* iscjksymbols */,
  {     0,  8886,  8128,   3,   7, UNI_MAKA }   /* sc=makasar */,
  {     1,  7025,  7502,   3,   1, UNI_IN__8 }   /* in=8 */,
  {     0,  5045,     0,  14,   0, UNI_LATINEXTE }   /* latinextendede */,
  {     0,  3236,    26,  18,   1, UNI__PERL_PATWS }   /* patternwhitespace=y */,
  {    34,  8233,     0,   7,   0, UNI_sc_values_index }   /* script= */,
  {     6,  9904,  7128,   5,   4, UNI_POSIXWORD }   /* posixword */,
  {     0,   184,  2931,   3,   3, UNI_CHER }   /* ischer */,
  {   326,   184,   510,   3,  19, UNI_CJK }   /* iscjkunifiedideographs */,
  {     0,  9946,  8241,   3,   6, UNI_SHRD }   /* issharada */,
  {     2,  3002,  3852,  18,   3, UNI_DT__FIN }   /* decompositiontype=fin */,
  {    26,  9629,  5297,   3,  14, UNI_LB__PO }   /* lb=postfixnumeric */,
  {     0,  8424,  5786,   6,  13, UNI_VERTICALFORMS }   /* block=verticalforms */,
  {     2,  8424,  9233,   6,   4, UNI_LISU }   /* block=lisu */,
  {     1,  3002,  6195,  18,  12, UNI_DT__NONCANON }   /* decompositiontype=noncanonical */,
  {     0,  9623,     5,   3,   1, UNI_JG__E }   /* jg=e */,
  {     0,  3180,     0,   3,   0, UNI_ALL }   /* all */,
  {    56,  9313,     1,   4,   1, -UNI_PCM }   /* pcm=n */,
  {     0,  8424,  6898,   6,  10, UNI_INKHAROSHTHI }   /* block=kharoshthi */,
  {     0,  7108,  9433,  10,   4, UNI_XPOSIXUPPER }   /* uppercase=true */,
  {     4,  3671,  9285,  17,   4, UNI_NKO }   /* scriptextensions=nkoo */,
  {     0,  8100,  8864,   7,   5, -UNI_HYPHEN }   /* hyphen=false */,
  {     2,  8886,  2148,   3,  21, UNI_PRTI }   /* sc=inscriptionalparthian */,
  {   261,  8844,     3,   5,   1, -UNI_CWCF }   /* cwcf=f */,
  {     4,  8424,  6838,   6,  10, UNI_BOXDRAWING }   /* block=boxdrawing */,
  {     0,  8886,  8610,   3,   6, UNI_RJNG }   /* sc=rejang */,
  {     0,   206,     0,   2,   0, UNI_PI }   /* pi */,
  {     0,   184,   183,   2,  34, UNI_MISCPICTOGRAPHS }   /* ismiscellaneoussymbolsandpictographs */,
  {    36,  9093,  7275,   4,   9, UNI_LATINEXTD }   /* blk=latinextd */,
  {     0,  9185,     0,   4,   0, UNI_HMNG }   /* hmng */,
  {     1,  7128,  7988,  10,   7, UNI_WB__LE }   /* wordbreak=aletter */,
  {    33,  3398,     1,  18,   1, -UNI_VS }   /* variationselector=n */,
  {     0,  9237,     0,   4,   0, UNI_loe_values_index }   /* loe= */,
  {     0,  8424,  3631,   7,   3, UNI_INCHAM }   /* block=cham */,
  {     0,  7420,  9734,   8,   3, UNI_IDS }   /* idstart=yes */,
  {    39,  6928,    36,  10,   1, UNI_XPOSIXLOWER }   /* lowercase=t */,
  {     0,  8886,    18,   6,   1, UNI_KHAR }   /* sc=khar */,
  {     0,  1482,  3212,   4,   6, UNI_DINGBATS }   /* indingbats */,
  {     0,  6015,     7,  12,   1, UNI_JT__C }   /* joiningtype=c */,
  {    12,  3868,  6613,  16,  11, UNI_LO }   /* generalcategory=otherletter */,
  {     0,  9626,    36,   3,   1, UNI_JT__T }   /* jt=t */,
  {     0,  2212,  4479,   4,  13, UNI_INHANGUL }   /* inhangulsyllables */,
  {    12,  5085,  6053,   4,  10, UNI_MAHJONG }   /* inmahjongtiles */,
  {     0,  3818,     0,  18,   0, UNI_PE }   /* isclosepunctuation */,
  {     0,  9647,  7428,   3,   8, UNI_NV__1_SLASH_10 }   /* nv=1.00e-01 */,
  {     0,  8871,  8694,   3,   5, UNI_SB__AT }   /* sb=aterm */,
  {    33,  9647,  8817,   3,   2, UNI_NV__34 }   /* nv=34 */,
  {     0,  9593,  5255,   3,  14, UNI_BC__NSM }   /* bc=nonspacingmark */,
  {     0,  9623,  8889,   3,   5, UNI_JG__KHAPH }   /* jg=khaph */,
  {     0,  8871,    49,   3,   2, UNI_SB__AT }   /* sb=at */,
  {    10,  9623,  2551,   3,  19, UNI_JG__BURUSHASKIYEHBARREE }   /* jg=burushaskiyehbarree */,
  {     0,  8424,  8622,   6,   6, UNI_INTELUGU }   /* block=telugu */,
  {     0,  1497,  5354,  10,  13, UNI_ZS }   /* category=spaceseparator */,
  {     0,  6690,     0,   4,   0, UNI_SORA }   /* sora */,
  {     0,  1362,  8463,  24,   3, UNI_CCC__129 }   /* canonicalcombiningclass=129 */,
  {     1,  8233,  9429,   7,   4, UNI_TIBT }   /* script=tibt */,
  {     0,  8424,  2949,   7,  17, UNI_HALFMARKS }   /* block=combininghalfmarks */,
  {     0,  9093,  8484,   4,   6, UNI_INCHAKMA }   /* blk=chakma */,
  {     0,  9647,  7540,   3,   8, UNI_NV__20000000 }   /* nv=20000000 */,
  {    32,  5760,  9569,  13,   3, UNI_NV__5_SLASH_6 }   /* numericvalue=5/6 */,
  {     0,   184,  5269,   2,  13, UNI_PATSYN }   /* ispatternsyntax */,
  {     1,  5760,  8364,  13,   6, UNI_NV__400000 }   /* numericvalue=400000 */,
  {    16,  1158,  8629,   3,   5, UNI_INTHAANA }   /* inthaana */,
  {     0,  9113,  7691,   4,   2, UNI_CCC__36 }   /* ccc=36 */,
  {     0,  1057,    36,  27,   1, UNI_PCM }   /* prependedconcatenationmark=t */,
  {     3,   113,     0,  35,   0, UNI_DIACRITICALSFORSYMBOLS }   /* combiningdiacriticalmarksforsymbols */,
  {     1,  5760,  7596,  13,   8, UNI_NV__3_SLASH_80 }   /* numericvalue=3.75e-02 */,
  {     0,  9728,     0,   3,   0, UNI_vs_values_index }   /* vs= */,
  {     0,  5760,  8352,  13,   6, UNI_NV__216000 }   /* numericvalue=216000 */,
  {    77,    21,  8121,   2,   7, UNI_INLINEARA }   /* inlineara */,
  {     1,  7018,  9716,  10,   3, UNI_IN__7 }   /* presentin=v70 */,
  {     5,  6828,  3272,  10,  18, UNI_BC__RLI }   /* bidiclass=righttoleftisolate */,
  {     0,  4821,  8864,  14,   5, -UNI_POSIXXDIGIT }   /* asciihexdigit=false */,
  {     1,  2204,  8920,   3,   4, UNI_OGAM }   /* isogham */,
  {    17,  9113,  9765,   4,   2, UNI_CCC__8 }   /* ccc=kv */,
  {     6,  1911,  2966,  22,  18, UNI_INSC__CONSONANTSUBJOINED }   /* indicsyllabiccategory=consonantsubjoined */,
  {     0,   184,  5487,   2,  13, UNI_XPOSIXDIGIT }   /* isdecimalnumber */,
  {     0,  6005,  6859,   3,   9, UNI_CJKSTROKES }   /* incjkstrokes */,
  {    32,  4462,     1,  15,   1, -UNI_GREXT }   /* graphemeextend=n */,
  {    23,  8233,  6183,   7,   4, UNI_MEND }   /* script=mend */,
  {   210,  8424,  5045,   6,  14, UNI_LATINEXTE }   /* block=latinextendede */,
  {     1,  9113,  7502,   4,   1, UNI_CCC__8 }   /* ccc=8 */,
  {   144,   779,     0,  29,   0, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* enclosedideographicsupplement */,
  {     1,  8424,  3552,   6,  17, UNI_ETHIOPICEXTA }   /* block=ethiopicextendeda */,
  {   144,  1482,  4777,  24,  15, UNI_LOE }   /* indicpositionalcategory=visualorderleft */,
  {    12,  1497,  1532,   9,   1, UNI_Z }   /* category=z */,
  {    28,  9647,  5409,   3,   5, UNI_NV__10000 }   /* nv=10000 */,
  {     5,  6816,  4268,   3,  14, UNI_BAMUMSUP }   /* inbamumsupplement */,
  {     4,     7,     0,  18,   0, UNI_CANS }   /* canadianaboriginal */,
  {     0,  9365,  6648,   5,   3, UNI_SHAW }   /* scx=shaw */,
  {     0,  5565,  5692,  13,   3, UNI_JG__TAW }   /* joininggroup=taw */,
  {     0,  6918,  8324,  10,   7, UNI_LB__XX }   /* linebreak=unknown */,
  {    68,  9365,  9261,   4,   3, UNI_MRO }   /* scx=mro */,
  {    15,    48,     0,   1,   0, UNI_P }   /* p */,
  {    48,  8849,  9433,   5,   4, UNI_CWCM }   /* cwcm=true */,
  {     0,  9901,    62,   8,   5, UNI_XPOSIXGRAPH }   /* isxposixgraph */,
  {     1,  5565,  4537,  13,  15, UNI_JG__MANICHAEANGIMEL }   /* joininggroup=manichaeangimel */,
  {   366,  3868,   106,  16,   6, UNI_S }   /* generalcategory=symbol */,
  {     0,  9113,  9512,   4,   3, UNI_CCC__202 }   /* ccc=202 */,
  {    68,  3948,  5787,   3,  12, UNI_VERTICALFORMS }   /* inverticalforms */,
  {     0,  8598,    36,   6,   1, UNI__PERL_PATWS }   /* patws=t */,
  {     0,  5760,  9503,  13,   3, UNI_NV__1_SLASH_9 }   /* numericvalue=1/9 */,
  {     1,  9903,  1812,   6,   5, UNI_XPOSIXUPPER }   /* xposixupper */,
  {     0,  9113,  9073,   4,   4, UNI_CCC__216 }   /* ccc=atar */,
  {   257,  1187,     0,   2,   0, UNI_SK }   /* sk */,
  {     0,  9647,  7564,   3,   8, UNI_NV__1_SLASH_320 }   /* nv=3.13e-03 */,
  {     2,  6918,  1410,  10,  13, UNI_LB__CM }   /* linebreak=combiningmark */,
  {     2,  9623,  4044,   3,  16, UNI_JG__MANICHAEANSAMEKH }   /* jg=manichaeansamekh */,
  {     6,  2273,     0,  20,   0, UNI_PC }   /* connectorpunctuation */,
  {     6,  1159,  5487,   3,   7, UNI_XPOSIXDIGIT }   /* nt=decimal */,
  {     8,  9425,     0,   4,   0, UNI_THAI }   /* thai */,
  {     0,  5565,  4567,  13,  15, UNI_JG__MANICHAEANZAYIN }   /* joininggroup=manichaeanzayin */,
  {    13,  9093,   976,   4,  17, UNI_ANCIENTGREEKMUSIC }   /* blk=ancientgreekmusic */,
  {     0,  4821,     3,  14,   1, -UNI_POSIXXDIGIT }   /* asciihexdigit=f */,
  {     3,  5565,  4028,  13,  16, UNI_JG__MANICHAEANLAMEDH }   /* joininggroup=manichaeanlamedh */,
  {     2,  5435,   995,  13,   2, -UNI_BIDIM }   /* bidimirrored=no */,
  {     0,  3146,     0,  18,   0, UNI_PI }   /* initialpunctuation */,
  {   402,  3868,  2192,  16,   2, UNI_PD }   /* generalcategory=pd */,
  {     1,  9623,  6135,   3,  12, UNI_JG__MALAYALAMTTA }   /* jg=malayalamtta */,
  {    74,   117,   447,   3,  31, UNI_IDEOGRAPHICSYMBOLS }   /* inideographicsymbolsandpunctuation */,
  {    65,  9647,  7540,   3,   4, UNI_NV__2000 }   /* nv=2000 */,
  {    85,  6991,     0,   7,   0, UNI_SOGD }   /* sogdian */,
  {    18,  1497,  6613,   9,  11, UNI_LO }   /* category=otherletter */,
  {     2,  3671,  1146,  18,   3, UNI_SORA }   /* scriptextensions=sora */,
  {     0,  3671,   382,  17,   4, UNI_EGYP }   /* scriptextensions=egyp */,
  {     3,  8884,  8704,   5,   5, UNI_INSC__BINDU }   /* insc=bindu */,
  {    35,  9647,  7732,   3,   8, UNI_NV__5_SLASH_6 }   /* nv=8.33e-01 */,
  {     0,  2212,  2667,   4,  17, UNI_JAMOEXTB }   /* inhanguljamoextendedb */,
  {     8,   184,  9249,   2,   4, UNI_MERC }   /* ismerc */,
  {     0,  5760,  7580,  13,   8, UNI_NV__7_SLASH_2 }   /* numericvalue=3.50e+00 */,
  {     0,  9093,  7940,   4,   8, UNI_SPECIALS }   /* blk=specials */,
  {   152,  7025,  9005,   3,   4, UNI_IN__12_DOT_1 }   /* in=12.1 */,
  {   311,  9365,  8894,   4,   5, UNI_LIMB }   /* scx=limbu */,
  {   145,  1362,    78,  24,   2, UNI_CCC__AR }   /* canonicalcombiningclass=ar */,
  {     2,  9093,  2021,   4,  15, UNI_TRANSPORTANDMAP }   /* blk=transportandmap */,
  {     0,  7419,     3,   9,   1, -UNI_XIDS }   /* xidstart=f */,
  {     6,  3671,   983,  17,   5, UNI_GREK }   /* scriptextensions=greek */,
  {    46,  3671,  7239,  17,   9, UNI_QAAI }   /* scriptextensions=inherited */,
  {     0,  7025,  9704,   3,   3, UNI_IN__6 }   /* in=v60 */,
  {     0,  4580,  2171,   4,   9, UNI_INMEETEIMAYEK }   /* inmeeteimayek */,
  {    25,  9623,  5157,   3,  14, UNI_JG__MANICHAEANRESH }   /* jg=manichaeanresh */,
  {     4,  3671,  2984,  17,   4, UNI_COPT }   /* scriptextensions=copt */,
  {     0,  4580,  4125,   3,  15, UNI_MYANMAREXTB }   /* inmyanmarextendedb */,
  {    10,  9946,  1482,   3,   3, UNI_SIND }   /* issind */,
  {     0,  5565,  6756,  13,  11, UNI_JG__YEHWITHTAIL }   /* joininggroup=yehwithtail */,
  {     8,  1911,  4342,  22,  15, UNI_INSC__CONSONANTMEDIAL }   /* indicsyllabiccategory=consonantmedial */,
  {     0,  3868,  6624,  16,  11, UNI_NO }   /* generalcategory=othernumber */,
  {     0,   184,  3552,   2,  11, UNI_ETHIOPICEXT }   /* isethiopicext */,
  {     0,   184,  9285,   2,   3, UNI_NKO }   /* isnko */,
  {    39,  6360,     0,  11,   0, UNI_CASEDLETTER }   /* casedletter */,
  {     0,  9629,   184,   3,   2, UNI_LB__IS }   /* lb=is */,
  {     0,  1911,  4919,  22,  14, UNI_INSC__GEMINATIONMARK }   /* indicsyllabiccategory=geminationmark */,
  {     0,  6988,     0,  10,   0, UNI_SOGO }   /* oldsogdian */,
  {     1,   184,  5017,   2,  14, UNI_LATINEXTC }   /* islatinextendedc */,
  {     2,  1362,  8775,  25,   4, UNI_CCC__26 }   /* canonicalcombiningclass=ccc26 */,
  {     5,  1482,  2479,  24,  14, UNI_INPC__BOTTOMANDRIGHT }   /* indicpositionalcategory=bottomandright */,
  {     2,  1497,  1156,   9,   2, UNI_PO }   /* category=po */,
  {     0,  9093,  1264,   4,  25, UNI_SUPERANDSUB }   /* blk=superscriptsandsubscripts */,
  {    24,   117,  5553,   3,  12, UNI_IPAEXT }   /* inipaextensions */,
  {     2,   184,   893,   2,  28, UNI_SUPPUAB }   /* issupplementaryprivateuseareab */,
  {    37,  1497,  9108,   9,   2, UNI_MC }   /* category=mc */,
  {     0,  7932,     0,   8,   0, UNI_radical_values_index }   /* radical= */,
  {     0,   382,     0,   4,   0, UNI_EGYP }   /* egyp */,
  {     0,  4361,  3112,   4,   6, UNI_INGEORGIAN }   /* ingeorgian */,
  {     0,  5085,  7918,   4,   6, UNI_INMAHAJANI }   /* inmahajani */,
  {     0,  1924,  9770,  10,   1, UNI_CASEDLETTER }   /* category=l_ */,
  {   145,  2684,    36,  19,   1, UNI_GCB__T }   /* hangulsyllabletype=t */,
  {     0,  9193,  6938,   4,  10, UNI_LB__H2 }   /* hst=lvsyllable */,
  {     1,  3236,    36,  18,   1, UNI__PERL_PATWS }   /* patternwhitespace=t */,
  {    25,  7248,     0,   9,   0, UNI_SIND }   /* khudawadi */,
  {     0,  9049,     9,   4,   2, UNI_AGE__NA }   /* age=na */,
  {    20,  8886,  8303,   3,   7, UNI_TIBT }   /* sc=tibetan */,
  {     9,  6816,  7805,   3,   7, UNI_INBUGINESE }   /* inbuginese */,
  {   192,  6005,   600,   3,  29, UNI_CJKEXTD }   /* incjkunifiedideographsextensiond */,
  {     0,  9605,    45,   3,   6, UNI_DT__COM }   /* dt=compat */,
  {     4,  3671,  7796,  17,   4, UNI_BASS }   /* scriptextensions=bass */,
  {     1,  8233,  8310,   7,   7, UNI_SC__TIRH }   /* script=tirhuta */,
  {     0,   184,  9101,   2,   4, UNI_BUHD }   /* isbuhd */,
  {    32,  8424,  1599,   6,   6, UNI_INHANGUL }   /* block=hangul */,
  {   320,  2204,  6980,   4,   8, UNI_XPEO }   /* isoldpersian */,
  {     0,  2148,   317,   3,  32, UNI_SUPMATHOPERATORS }   /* insupplementalmathematicaloperators */,
  {     0,  2142,  7312,   3,   8, UNI_INNEWTAILUE }   /* innewtailue */,
  {     1,  8424,  1264,   6,  25, UNI_SUPERANDSUB }   /* block=superscriptsandsubscripts */,
  {     0,  9093,  2665,   4,  19, UNI_JAMOEXTB }   /* blk=hanguljamoextendedb */,
  {     0,  8424,  8526,   6,   6, UNI_INKAITHI }   /* block=kaithi */,
  {     1,  9213,     0,   4,   0, UNI_LANA }   /* lana */,
  {     5,  8332,  6800,   4,   8, UNI_ARABICEXTA }   /* isarabicexta */,
  {     0,  5565,  4012,  13,  16, UNI_JG__MANICHAEANDALETH }   /* joininggroup=manichaeandaleth */,
  {   158,  3671,  9281,  17,   4, UNI_NEWA }   /* scriptextensions=newa */,
  {     0,   837,     0,  11,   0, UNI_PHONETICEXT }   /* phoneticext */,
  {     0,  4372,     0,  15,   0, UNI_CONTROLPICTURES }   /* controlpictures */,
  {     4,  8233,  4792,   7,  15, UNI_ZANB }   /* script=zanabazarsquare */,
  {     1,  8424,  3705,   6,  17, UNI_SMALLFORMS }   /* block=smallformvariants */,
  {     0,  1801,     3,  22,   1, -UNI_CWU }   /* changeswhenuppercased=f */,
  {     1,  8023,     0,   7,   0, UNI_CJKEXTC }   /* cjkextc */,
  {   384,  8424,  7221,   6,   9, UNI_EMOTICONS }   /* block=emoticons */,
  {     4,  9093,  3164,   4,   9, UNI_LATINEXTA }   /* blk=latinexta */,
  {    58,  4580,  2007,   3,   3, UNI_INMODI }   /* inmodi */,
  {     0,  8100,    26,   7,   1, UNI_HYPHEN }   /* hyphen=y */,
  {     0,  8424,  8261,   6,   7, UNI_INSOYOMBO }   /* block=soyombo */,
  {    14,  3251,     3,   3,   1, -UNI_CE }   /* ce=f */,
  {     1,  9113,  8475,   4,   3, UNI_CCC__132 }   /* ccc=132 */,
  {    92,  9301,     0,   4,   0, UNI_ORKH }   /* orkh */,
  {    27,  9093,  2393,   4,  20, UNI_INNYIAKENGPUACHUEHMONG }   /* blk=nyiakengpuachuehmong */,
  {     0,  9365,  9045,   4,   4, UNI_ADLM }   /* scx=adlm */,
  {     2,    21,  8610,   2,   6, UNI_INREJANG }   /* inrejang */,
  {     2,  8233,  9249,   7,   4, UNI_MERC }   /* script=merc */,
  {     0,  9629,  6459,   3,  11, UNI_LB__IN }   /* lb=inseperable */,
  {     2,  9365,  8191,   4,   7, UNI_OLCK }   /* scx=olchiki */,
  {     0,  9647,  7507,   3,   2, UNI_NV__12 }   /* nv=12 */,
  {     4,  8628,     0,   6,   0, UNI_THAA }   /* thaana */,
  {    40,  1362,  8735,  25,   4, UNI_CCC__18 }   /* canonicalcombiningclass=ccc18 */,
  {     0,  8412,     0,   6,   0, UNI_bidic_values_index }   /* bidic= */,
  {    58,  9647,  9580,   3,   2, UNI_NV__37 }   /* nv=37 */,
  {    20,   184,  2893,   2,  19, UNI_SUPARROWSC }   /* issupplementalarrowsc */,
  {     0,  9593,  3272,   3,  18, UNI_BC__RLI }   /* bc=righttoleftisolate */,
  {     1,  1691,  5678,  22,   4, UNI_BPT__N }   /* bidipairedbrackettype=none */,
  {     5,  1362,  8750,  25,   4, UNI_CCC__21 }   /* canonicalcombiningclass=ccc21 */,
  {     0,  1773,   995,   6,   2, -UNI_CASED }   /* cased=no */,
  {     3,  7128,    34,  10,   6, UNI_WB__EXTEND }   /* wordbreak=extend */,
  {     0,  8424,  7194,   6,   9, UNI_ARABICPFB }   /* block=arabicpfb */,
  {    30,  3002,  3852,  18,   5, UNI_DT__FIN }   /* decompositiontype=final */,
  {     0,  6918,    34,  10,   2, UNI_LB__EX }   /* linebreak=ex */,
  {     0,  6828,  5255,  10,  14, UNI_BC__NSM }   /* bidiclass=nonspacingmark */,
  {     3,    21,  2254,   3,  19, UNI_INANATOLIANHIEROGLYPHS }   /* inanatolianhieroglyphs */,
  {    11,  8332,  4822,   3,   4, UNI_ASCII }   /* isascii */,
  {    38,  1362,  9073,  24,   4, UNI_CCC__216 }   /* canonicalcombiningclass=atar */,
  {     0,   184,  9769,   2,   2, UNI_CASEDLETTER }   /* isl_ */,
  {     0,  8424,  6051,   6,   7, UNI_MAHJONG }   /* block=mahjong */,
  {     0,  6005,  2086,   3,  20, UNI_CYRILLICSUP }   /* incyrillicsupplementary */,
  {     0,  8886,  9337,   3,   4, UNI_SC__QAAI }   /* sc=qaai */,
  {     4,  9731,   495,   3,   7, UNI_WB__NU }   /* wb=numeric */,
  {    65,  4705,  4718,   3,   4, UNI_TAML }   /* istamil */,
  {    17,  6949,   987,   4,   2, UNI_CAKM }   /* iscakm */,
  {     2,  3671,  9329,  17,   4, UNI_PRTI }   /* scriptextensions=prti */,
  {     1,  3248,     1,   6,   1, -UNI_XPOSIXSPACE }   /* space=n */,
  {     0,  6316,  9433,  11,   4, UNI_IDC }   /* idcontinue=true */,
  {     1,  4080,     0,  10,   0, UNI_SM }   /* mathsymbol */,
  {    32,  6005,  2931,   3,  17, UNI_CHEROKEESUP }   /* incherokeesupplement */,
  {     2,  9629,  5953,   3,   2, UNI_LB__WJ }   /* lb=wj */,
  {     1,   719,     0,  21,   0, UNI_ENCLOSEDALPHANUM }   /* enclosedalphanumerics */,
  {     0,  2232,     0,  21,   0, UNI_YIJING }   /* yijinghexagramsymbols */,
  {    45,  9731,  1188,   3,   8, UNI_WB__KA }   /* wb=katakana */,
  {     0,  8424,   446,   6,  32, UNI_IDEOGRAPHICSYMBOLS }   /* block=ideographicsymbolsandpunctuation */,
  {     0,  9309,     0,   4,   0, UNI_OSGE }   /* osge */,
  {     1,  3450,     0,  17,   0, UNI_UCAS }   /* canadiansyllabics */,
  {     0,  9620,  9108,   3,   2, UNI_MC }   /* gc=mc */,
  {     1,  9085,     0,   4,   0, UNI_BATK }   /* batk */,
  {    64,  8424,  5003,   6,  14, UNI_LATINEXTB }   /* block=latinextendedb */,
  {   225,  3671,  7248,  17,   9, UNI_SIND }   /* scriptextensions=khudawadi */,
  {    18,  8604,    26,   6,   1, UNI_QMARK }   /* qmark=y */,
  {    16,  7230,     0,   9,   0, UNI_ext_values_index }   /* extender= */,
  {     4,  8960,  8864,   4,   5, -UNI_IDS }   /* ids=false */,
  {     2,  8424,  3110,   6,  11, UNI_GEORGIANSUP }   /* block=georgiansup */,
  {     1,  2703,     0,   4,   0, UNI_IDST }   /* idst */,
  {     0,  8424,  4762,   6,  15, UNI_VEDICEXT }   /* block=vedicextensions */,
  {   209,  5760,  7436,  13,   8, UNI_NV__1_SLASH_9 }   /* numericvalue=1.11e-01 */,
  {     0,  1911,  1434,  22,  24, UNI_INSC__CONSONANTSUCCEEDINGREPHA }   /* indicsyllabiccategory=consonantsucceedingrepha */,
  {     5,  5526,     0,  13,   0, UNI_GREEKEXT }   /* greekextended */,
  {     0,  6194,  8925,   3,   4, UNI_INORIYA }   /* inoriya */,
  {     0,  3671,  8310,  17,   4, UNI_TIRH }   /* scriptextensions=tirh */,
  {    21,   184,  9493,   2,   4, UNI_ZZZZ }   /* iszzzz */,
  {    12,  9620,  3820,   3,  16, UNI_PE }   /* gc=closepunctuation */,
  {    68,  3236,  8864,  18,   5, -UNI__PERL_PATWS }   /* patternwhitespace=false */,
  {     0,  3671,  6183,  17,   4, UNI_MEND }   /* scriptextensions=mend */,
  {   257,  1866,     0,   2,   0, UNI_SD }   /* sd */,
  {     0,  9365,  9177,   4,   4, UNI_HANO }   /* scx=hano */,
  {     0,  9093,  4717,   4,   8, UNI_TAMILSUP }   /* blk=tamilsup */,
  {     0,  5760,  7500,  13,   8, UNI_NV__3_SLASH_16 }   /* numericvalue=1.88e-01 */,
  {     1,  1362,  3433,  24,  17, UNI_WB__EB }   /* canonicalcombiningclass=attachedbelowleft */,
  {     0,  2532,     0,   4,   0, UNI_BRAH }   /* brah */,
  {    11,    21,  3164,   2,  18, UNI_LATINEXTADDITIONAL }   /* inlatinextadditional */,
  {     1,  7018,  9006,  10,   3, UNI_IN__2_DOT_1 }   /* presentin=2.1 */,
  {     0,  8886,  2127,   3,  14, UNI_SC__ROHG }   /* sc=hanifirohingya */,
  {     5,  3002,  2709,  18,   3, UNI_DT__NAR }   /* decompositiontype=nar */,
  {     0,  9731,  5625,   3,   2, UNI_WB__ML }   /* wb=ml */,
  {     0,  9093,  2064,   4,  21, UNI_CJKRADICALSSUP }   /* blk=cjkradicalssupplement */,
  {     0,  5760,  7604,  13,   8, UNI_NV__2_SLASH_5 }   /* numericvalue=4.00e-01 */,
  {     1,  1497,   995,   9,   2, UNI_NO }   /* category=no */,
  {     1,  8424,  5448,   6,  13, UNI_BLOCKELEMENTS }   /* block=blockelements */,
  {     1,  8424,   149,   7,  34, UNI_DIACRITICALSSUP }   /* block=combiningdiacriticalmarkssupplement */,
  {    24,  8424,  8031,   7,   6, UNI_CJKEXTD }   /* block=cjkextd */,
  {    44,  5760,  3969,  13,   1, UNI_NV__1 }   /* numericvalue=1 */,
  {    24,  3868,     1,  16,   1, UNI_N }   /* generalcategory=n */,
  {     0,    21,  7996,   3,   6, UNI_INAVESTAN }   /* inavestan */,
  {     3,  8424,    43,   7,   2, UNI_CJK }   /* block=cjk */,
  {   419,  8424,  8709,   6,   5, UNI_INBUHID }   /* block=buhid */,
  {    12,  9629,  5847,   3,  12, UNI_LB__SY }   /* lb=breaksymbols */,
  {     0,  8424,  3756,   6,  16, UNI_ARABICSUP }   /* block=arabicsupplement */,
  {    74,  5565,  5143,  13,  14, UNI_JG__MANICHAEANQOPH }   /* joininggroup=manichaeanqoph */,
  {     0,  8424,  3536,   7,  16, UNI_CYRILLICEXTC }   /* block=cyrillicextendedc */,
  {     3,  8634,     0,   6,   0, UNI_uideo_values_index }   /* uideo= */,
  {     0,  3688,     0,  16,   0, UNI_STERM }   /* sentenceterminal */,
  {     3,  1482,    61,   3,   4, UNI_INDOGRA }   /* indogra */,
  {     0,  9453,     0,   3,   0, UNI_VAI }   /* vai */,
  {     0,  5565,  8544,  13,   6, UNI_JG__LAMADH }   /* joininggroup=lamadh */,
  {    22,  3739,   995,  17,   2, -UNI_UIDEO }   /* unifiedideograph=no */,
  {     0,  5760,  9509,  13,   3, UNI_NV__2_SLASH_5 }   /* numericvalue=2/5 */,
  {     0,    21,  3418,   4,  15, UNI_ALCHEMICAL }   /* inalchemicalsymbols */,
  {   266,  5760,  7708,  13,   8, UNI_NV__15_SLASH_2 }   /* numericvalue=7.50e+00 */,
  {    36,  5513,     3,  13,   1, -UNI_GRBASE }   /* graphemebase=f */,
  {     0,  4580,  6560,   4,   9, UNI_INMEDEFAIDRIN }   /* inmedefaidrin */,
  {     4,  8424,  4388,   7,  14, UNI_CURRENCYSYMBOLS }   /* block=currencysymbols */,
  {     8,   184,  4933,   2,  14, UNI_INGREEK }   /* isgreekandcoptic */,
  {     0,  8844,  9734,   5,   3, UNI_CWCF }   /* cwcf=yes */,
  {     8,  4361,  3886,   4,   9, UNI_GEORGIANEXT }   /* ingeorgianext */,
  {    10,   184,  6171,   2,  12, UNI_MATHALPHANUM }   /* ismathalphanum */,
  {     2,  8424,  9397,   6,   4, UNI_TAGS }   /* block=tags */,
  {     5,  9923,  8312,   4,   5, UNI_INTIRHUTA }   /* intirhuta */,
  {    26,  5565,  6785,  13,   3, UNI_JG__FEH }   /* joininggroup=feh */,
  {     1,  6918,   958,  10,   2, UNI_LB__CP }   /* linebreak=cp */,
  {    29,   184,  2006,   2,   4, UNI_MODI }   /* ismodi */,
  {     8,   995,     0,   2,   0, UNI_NO }   /* no */,
  {     1,  5325,     3,  14,   1, -UNI_QMARK }   /* quotationmark=f */,
  {     0,    25,     0,   1,   0, UNI_S }   /* s */,
  {     3,  9093,  1889,   4,  22, UNI_EARLYDYNASTICCUNEIFORM }   /* blk=earlydynasticcuneiform */,
  {     1,    21,  6898,   2,  10, UNI_INKHAROSHTHI }   /* inkharoshthi */,
  {     0,   184,  6838,   2,  10, UNI_BOXDRAWING }   /* isboxdrawing */,
  {     3,  9113,  8437,   5,   5, UNI_CCC__103 }   /* ccc=ccc103 */,
  {   170,  9113,    18,   4,   1, UNI_CCC__R }   /* ccc=r */,
  {     1,  5269,    26,  14,   1, UNI_PATSYN }   /* patternsyntax=y */,
  {     0,  6816,  8710,   3,   4, UNI_INBUHID }   /* inbuhid */,
  {     0,  9101,     0,   4,   0, UNI_BUHD }   /* buhd */,
  {     0,  9093,  8079,   4,   7, UNI_INGRANTHA }   /* blk=grantha */,
  {    25,  3671,  7804,  17,   8, UNI_BUGI }   /* scriptextensions=buginese */,
  {     9,  7025,  9563,   3,   3, UNI_IN__5_DOT_1 }   /* in=5.1 */,
  {     9,  6888,  8864,  10,   5, -UNI_DIA }   /* diacritic=false */,
  {    15,  8424,  3772,   6,   8, UNI_INBOPOMOFO }   /* block=bopomofo */,
  {    52,  9725,     0,   3,   1, UNI_VO__U }   /* vo=u */,
  {     3,  7128,  7820,  10,   8, UNI_WB__EB }   /* wordbreak=ebasegaz */,
  {     3,  8233,  9273,   7,   4, UNI_NARB }   /* script=narb */,
  {     2,  9289,     0,   4,   0, UNI_NSHU }   /* nshu */,
  {     0,  7025,  7446,   3,   1, UNI_IN__2 }   /* in=2 */,
  {   192,  8424,  4204,   6,   9, UNI_SYRIACSUP }   /* block=syriacsup */,
  {     0,  2493,   409,  20,   2, UNI_VO__TR }   /* verticalorientation=tr */,
  {     0,  3671,  4657,  17,  15, UNI_NARB }   /* scriptextensions=oldnortharabian */,
  {     0,  9911,     0,  10,   0, UNI_POSIXBLANK }   /* posixblank */,
  {    43,  8886,  9233,   3,   4, UNI_LISU }   /* sc=lisu */,
  {     2,  8886,  5617,   3,   9, UNI_SC__MLYM }   /* sc=malayalam */,
  {     0,  7128,   138,  10,   2, UNI_WB__FO }   /* wordbreak=fo */,
  {     5,  6027,     0,  12,   0, UNI_KHMERSYMBOLS }   /* khmersymbols */,
  {     0,  8233,  9085,   7,   4, UNI_BATK }   /* script=batk */,
  {    38,  2148,  4205,   3,  15, UNI_SYRIACSUP }   /* insyriacsupplement */,
  {     3,  9593,  2433,   3,  20, UNI_BC__RLE }   /* bc=righttoleftembedding */,
  {     0,   446,     0,  32,   0, UNI_IDEOGRAPHICSYMBOLS }   /* ideographicsymbolsandpunctuation */,
  {     2,   184,   407,   3,   6, UNI_XPOSIXCNTRL }   /* iscontrol */,
  {   257,  7128,   125,  10,   2, UNI_LB__CR }   /* wordbreak=cr */,
  {     0,  3467,     0,  17,   0, UNI_AGHB }   /* caucasianalbanian */,
  {     1,   184,  1136,   2,  25, UNI_DI }   /* isdefaultignorablecodepoint */,
  {    31,  8586,    47,   6,   1, UNI_NFCQC__M }   /* nfcqc=m */,
  {     0,  2212,  2648,   4,  17, UNI_JAMOEXTA }   /* inhanguljamoextendeda */,
  {    19,   184,  9265,   2,   4, UNI_MTEI }   /* ismtei */,
  {     3,  8332,  4254,   4,  13, UNI_ARABICEXTA }   /* isarabicextendeda */,
  {    16,  8884,  4188,   5,  16, UNI_INSC__SYLLABLEMODIFIER }   /* insc=syllablemodifier */,
  {     8,  8424,  3164,   6,  18, UNI_LATINEXTADDITIONAL }   /* block=latinextadditional */,
  {     7,  2106,  1164,  21,   2, UNI_LB__LF }   /* graphemeclusterbreak=lf */,
  {     6,  9093,  6690,   4,  11, UNI_INSORASOMPENG }   /* blk=sorasompeng */,
  {     3,  8128,     0,   7,   0, UNI_MAKA }   /* makasar */,
  {     4,  8233,  9405,   7,   4, UNI_TALU }   /* script=talu */,
  {   165,  8871,   721,   3,   2, UNI_SB__CL }   /* sb=cl */,
  {     0,  1362,  7555,  24,   2, UNI_CCC__23 }   /* canonicalcombiningclass=23 */,
  {    76,  7932,  9734,   8,   3, UNI_RADICAL }   /* radical=yes */,
  {     1,  9731,  5967,   3,  12, UNI_LB__HL }   /* wb=hebrewletter */,
  {    10,  8030,     0,   7,   0, UNI_CJKEXTD }   /* cjkextd */,
  {   188,  9626,    18,   3,   1, UNI_JT__R }   /* jt=r */,
  {     0,  3671,  9229,  17,   4, UNI_LINB }   /* scriptextensions=linb */,
  {     0,  8886,  4657,   3,  15, UNI_NARB }   /* sc=oldnortharabian */,
  {     8,  8233,     7,   7,  18, UNI_CANS }   /* script=canadianaboriginal */,
  {     1,  9093,  1599,   4,   6, UNI_INHANGUL }   /* blk=hangul */,
  {     0,  1362,  9518,  24,   3, UNI_CCC__BL }   /* canonicalcombiningclass=218 */,
  {     1,  8886,  8065,   3,   7, UNI_ELBA }   /* sc=elbasan */,
  {     0,  8598,  8864,   6,   5, -UNI__PERL_PATWS }   /* patws=false */,
  {    74,  9901,  9921,   8,   5, UNI_XPOSIXPRINT }   /* isxposixprint */,
  {     0,  9647,  8371,   3,   2, UNI_NV__32 }   /* nv=32 */,
  {    39,  8598,   995,   6,   2, -UNI__PERL_PATWS }   /* patws=no */,
  {   107,  6005,  5872,   3,  11, UNI_CYRILLICEXTA }   /* incyrillicexta */,
  {     6,  3671,  9217,  17,   3, UNI_LAO }   /* scriptextensions=lao */,
  {     0,  9647,  7435,   3,   2, UNI_NV__11 }   /* nv=11 */,
  {     0,  5565,  6785,  13,   2, UNI_JG__FE }   /* joininggroup=fe */,
  {     0,  5760,  7763,  13,   2, UNI_NV__19 }   /* numericvalue=19 */,
  {     0,  3671,  9401,  17,   4, UNI_TALE }   /* scriptextensions=tale */,
  {     0,   184,  5311,   2,  14, UNI_PHLP }   /* ispsalterpahlavi */,
  {     0,  8919,     0,   5,   0, UNI_OGAM }   /* ogham */,
  {     0,  9629,  8100,   3,   2, UNI_LB__HY }   /* lb=hy */,
  {     0,  9647,  8669,   3,   5, UNI_NV__1_SLASH_320 }   /* nv=1/320 */,
  {     8,  5565,  5695,  13,  13, UNI_JG__MANICHAEANTEN }   /* joininggroup=manichaeanten */,
  {     0,  3671,  8939,  17,   5, UNI_TALE }   /* scriptextensions=taile */,
  {     0,  1911,  1214,  22,  25, UNI_INSC__CONSONANTINITIALPOSTFIXED }   /* indicsyllabiccategory=consonantinitialpostfixed */,
  {     6,  3671,  2741,  17,  19, UNI_MERO }   /* scriptextensions=meroitichieroglyphs */,
  {     3,  8424,  3552,   6,  11, UNI_ETHIOPICEXT }   /* block=ethiopicext */,
  {     0,  6978,     0,  10,   0, UNI_XPEO }   /* oldpersian */,
  {     0,  8886,  8628,   3,   6, UNI_SC__THAA }   /* sc=thaana */,
  {     1,   184,  7118,   2,  10, UNI_WARA }   /* iswarangciti */,
  {   262,  1314,     0,  24,   0, UNI_ARABICPFA }   /* arabicpresentationformsa */,
  {     0,  5213,    26,  14,   1, UNI_NFCQC__Y }   /* nfcquickcheck=y */,
  {     0,  3671,  8128,  17,   4, UNI_MAKA }   /* scriptextensions=maka */,
  {     0,  6828,    25,  10,   1, UNI_BC__S }   /* bidiclass=s */,
  {     0,  8526,     0,   6,   0, UNI_KTHI }   /* kaithi */,
  {   162,  8886,  7347,   3,   9, UNI_ORKH }   /* sc=oldturkic */,
  {     0,  8580,  9734,   6,   3, UNI__PERL_NCHAR }   /* nchar=yes */,
  {    65,  8886,   497,   5,   3, UNI_KHMR }   /* sc=khmer */,
  {     0,  9365,  9465,   4,   4, UNI_XPEO }   /* scx=xpeo */,
  {     3,  3416,     0,  10,   0, UNI_ALCHEMICAL }   /* alchemical */,
  {     1,  8233,  9209,   7,   4, UNI_SC__KTHI }   /* script=kthi */,
  {     0,  8886,  9373,   3,   4, UNI_SGNW }   /* sc=sgnw */,
  {     0,  9909,     3,   3,   1, UNI_PF }   /* ispf */,
  {     0,  8424,  8610,   6,   6, UNI_INREJANG }   /* block=rejang */,
  {     4,  3868,   262,  16,   2, UNI_SM }   /* generalcategory=sm */,
  {   358,  2708,  4254,   4,  13, UNI_ARABICEXTA }   /* inarabicextendeda */,
  {     0,  5513,   995,  13,   2, -UNI_GRBASE }   /* graphemebase=no */,
  {   144,  8879,  6268,   3,  11, UNI_PHAISTOS }   /* inphaistosdisc */,
  {     1,  9365,  3467,   4,  17, UNI_AGHB }   /* scx=caucasianalbanian */,
  {     8,  9365,  9241,   4,   4, UNI_MEDF }   /* scx=medf */,
  {     1,  8424,  8317,   6,   7, UNI_UCASEXT }   /* block=ucasext */,
  {     1,  9620,   697,   3,   2, UNI_MN }   /* gc=mn */,
  {     0,  9097,    17,   4,   1, UNI_BPT__O }   /* bpt=o */,
  {     4,   184,  4507,   2,  15, UNI_LOWERCASELETTER }   /* islowercaseletter */,
  {     0,  8424,  7185,   6,   9, UNI_ARABICPFA }   /* block=arabicpfa */,
  {   104,  8955,   995,   4,   2, -UNI_IDC }   /* idc=no */,
  {   177,  6679,     1,  11,   1, -UNI_SD }   /* softdotted=n */,
  {     2,  2493,  3373,  20,   7, UNI_VO__R }   /* verticalorientation=rotated */,
  {    11,  9093,  8268,   4,   7, UNI_SUPPUAA }   /* blk=suppuaa */,
  {   112,  1889,     0,  22,   0, UNI_EARLYDYNASTICCUNEIFORM }   /* earlydynasticcuneiform */,
  {    44,  4447,  4290,  15,   7, UNI_EA__N }   /* eastasianwidth=neutral */,
  {    10,  9629,  4877,   3,  14, UNI_LB__SA }   /* lb=complexcontext */,
  {     2,  9864,  9839,  14,   7, UNI__PERL_NON_FINAL_FOLDS }   /* _perl_non_final_folds */,
  {     2,  8886,  8944,   3,   5, UNI_SC__TAKR }   /* sc=takri */,
  {     2,  1911,  4702,  22,  15, UNI_INSC__REGISTERSHIFTER }   /* indicsyllabiccategory=registershifter */,
  {     1,    21,  3290,   2,   4, UNI_RUMI }   /* inrumi */,
  {    22,  8424,  3932,   6,  16, UNI_HIGHPUSURROGATES }   /* block=highpusurrogates */,
  {     3,  9593,  9644,   3,   3, UNI_BC__NSM }   /* bc=nsm */,
  {     1,  1362,  9533,  24,   3, UNI_CCC__A }   /* canonicalcombiningclass=230 */,
  {     0,  5760,  7540,  13,   6, UNI_NV__200000 }   /* numericvalue=200000 */,
  {    19,  5760,  7487,  13,   1, UNI_NV__6 }   /* numericvalue=6 */,
  {     1,  4705,  8311,   3,   6, UNI_TIRH }   /* istirhuta */,
  {     0,  8424,  8010,   7,   6, UNI_CJKEXTA }   /* block=cjkexta */,
  {     0,  7311,     0,   9,   0, UNI_TALU }   /* newtailue */,
  {   177,  1497,  1767,   9,   2, UNI_NL }   /* category=nl */,
  {     2,  3671,  7980,  17,   8, UNI_UGAR }   /* scriptextensions=ugaritic */,
  {     0,  4705,  4718,   3,   7, UNI_TAMILSUP }   /* istamilsup */,
  {     0,  8424,  2931,   7,  10, UNI_CHEROKEESUP }   /* block=cherokeesup */,
  {    42,  8496,   995,   6,   2, -UNI_CWKCF }   /* cwkcf=no */,
  {    35,  6949,     2,   5,   1, UNI_CARI }   /* iscari */,
  {     1,  9093,  1289,   4,  25, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* blk=symbolsandpictographsexta */,
  {    42,  9593,  3218,   3,  18, UNI_BC__B }   /* bc=paragraphseparator */,
  {     0,   184,  8859,   2,   4, UNI_DOGR }   /* isdogr */,
  {     0,  8871,  1812,   3,   5, UNI_SB__UP }   /* sb=upper */,
  {     0,  9113,  8745,   5,   4, UNI_CCC__20 }   /* ccc=ccc20 */,
  {   167,  8424,  4582,   6,  15, UNI_INMEROITICCURSIVE }   /* block=meroiticcursive */,
  {     2,  3671,  7049,  18,   3, UNI_SAUR }   /* scriptextensions=saur */,
  {     8,  9647,  8400,   3,   4, UNI_NV__9000 }   /* nv=9000 */,
  {     0,  7018,  9689,  10,   3, UNI_IN__4 }   /* presentin=v40 */,
  {     2,  1362,  8439,  24,   3, UNI_CCC__103 }   /* canonicalcombiningclass=103 */,
  {    39,  9605,  1223,   3,   4, UNI_DT__INIT }   /* dt=init */,
  {     0,  1757,     1,  22,   1, -UNI_CWL }   /* changeswhenlowercased=n */,
  {     0,  5487,     0,  13,   0, UNI_XPOSIXDIGIT }   /* decimalnumber */,
  {    57,  9901,  8839,   8,   5, UNI_XPOSIXCNTRL }   /* isxposixcntrl */,
  {     0,  4705,  8945,   3,   3, UNI_TAKR }   /* istakr */,
  {     1,  8332,  7996,   3,   6, UNI_AVST }   /* isavestan */,
  {   128,  9620,   995,   3,   2, UNI_NO }   /* gc=no */,
  {     0,  8886,  7916,   3,   8, UNI_SC__MAHJ }   /* sc=mahajani */,
  {   252,  6003,     3,  12,   1, -UNI_JOINC }   /* joincontrol=f */,
  {   194,   184,   114,   3,  24, UNI_DIACRITICALS }   /* iscombiningdiacriticalmarks */,
  {     0,  7419,   995,   9,   2, -UNI_XIDS }   /* xidstart=no */,
  {    19,  8424,  2836,   6,  12, UNI_SUNDANESESUP }   /* block=sundanesesup */,
  {     1,  9277,     0,   4,   0, UNI_NBAT }   /* nbat */,
  {     1,  9605,  1264,   3,   5, UNI_DT__SUP }   /* dt=super */,
  {     2,  9647,  8364,   3,   3, UNI_NV__400 }   /* nv=400 */,
  {     6,  9113,  5138,   4,   2, UNI_CCC__7 }   /* ccc=nk */,
  {     2,  9593,  5603,   3,   3, UNI_BC__RLO }   /* bc=rlo */,
  {     0,  4829,     0,   5,   0, UNI_XPOSIXDIGIT }   /* digit */,
  {     0,  6194,  7348,   3,   8, UNI_INOLDTURKIC }   /* inoldturkic */,
  {   126,  1482,  6734,  24,  11, UNI_INPC__TOPANDRIGHT }   /* indicpositionalcategory=topandright */,
  {    29,  5339,  1812,  14,   5, UNI_SB__UP }   /* sentencebreak=upper */,
  {     0,  9113,   184,   4,   2, UNI_CCC__IS }   /* ccc=is */,
  {    22,  9647,  7468,   3,   8, UNI_NV__3_SLASH_2 }   /* nv=1.50e+00 */,
  {    71,  6315,    26,  12,   1, UNI_XIDC }   /* xidcontinue=y */,
  {     1,  8424,  8949,   6,   5, UNI_VSSUP }   /* block=vssup */,
  {   321,  9257,     0,   4,   0, UNI_MLYM }   /* mlym */,
  {     0,  3671,  8622,  17,   6, UNI_TELU }   /* scriptextensions=telugu */,
  {     0,  3671,  8142,  17,   7, UNI_MARC }   /* scriptextensions=marchen */,
  {     0,  9620,  1532,   3,   1, UNI_Z }   /* gc=z */,
  {    19,  8886,  9285,   3,   4, UNI_NKO }   /* sc=nkoo */,
  {   265,  7940,     0,   8,   0, UNI_SPECIALS }   /* specials */,
  {     8,  7025,  9566,   3,   3, UNI_IN__5_DOT_2 }   /* in=5.2 */,
  {   167,  2708,  1340,   4,  22, UNI_ARABICPFB }   /* inarabicpresentationformsb */,
  {     2,  2204,   262,   3,   3, UNI_OSMA }   /* isosma */,
  {   312,   184,  5045,   2,  14, UNI_LATINEXTE }   /* islatinextendede */,
  {     5,  3671,  2409,  17,   4, UNI_MONG }   /* scriptextensions=mong */,
  {     0,   184,    11,   2,   3, UNI_DIA }   /* isdia */,
  {     0,  9093,  2353,   4,  20, UNI_ININSCRIPTIONALPAHLAVI }   /* blk=inscriptionalpahlavi */,
  {     1,  6646,     0,  11,   0, UNI_HMNG }   /* pahawhhmong */,
  {    41,  7078,     0,  10,   0, UNI_SUPARROWSB }   /* suparrowsb */,
  {     0,  6371,     0,  10,   0, UNI_DEP }   /* deprecated */,
  {     3,  8233,  8562,   7,   6, UNI_LYCI }   /* script=lycian */,
  {   136,  8233,  3730,   8,   3, UNI_SGNW }   /* script=sgnw */,
  {     3,  8959,     3,   5,   1, -UNI_XIDS }   /* xids=f */,
  {     0,  7128,  7293,  10,   6, UNI_WB__MN }   /* wordbreak=midnum */,
  {     1,  8424,  1618,   6,   4, UNI_JAMO }   /* block=jamo */,
  {     2,  8604,     0,   6,   0, UNI_qmark_values_index }   /* qmark= */,
  {   198,  8508,  8864,   6,   5, -UNI_GREXT }   /* grext=false */,
  {    16,  4849,     0,  14,   0, UNI_ci_values_index }   /* caseignorable= */,
  {     2,  2984,     0,  18,   0, UNI_COPTICEPACTNUMBERS }   /* copticepactnumbers */,
  {     1,  6005,   540,   3,  29, UNI_CJKEXTB }   /* incjkunifiedideographsextensionb */,
  {     0,  1735,    36,  22,   1, UNI_CWCM }   /* changeswhencasemapped=t */,
  {   128,  1243,     0,  20,   0, UNI_CE }   /* compositionexclusion */,
  {     0,  5565,  5381,  13,  10, UNI_JG__TEHMARBUTA }   /* joininggroup=tehmarbuta */,
  {     5,  6003,  8864,  12,   5, -UNI_JOINC }   /* joincontrol=false */,
  {   146,  9365,  7203,   4,   9, UNI_BHKS }   /* scx=bhaiksuki */,
  {   771,  9731,    34,   3,   6, UNI_WB__EXTEND }   /* wb=extend */,
  {     7,  2106,    36,  21,   1, UNI_GCB__T }   /* graphemeclusterbreak=t */,
  {    72,  5227,     0,  14,   0, UNI_nfdqc_values_index }   /* nfdquickcheck= */,
  {     7,   184,  5835,   2,  11, UNI_BIDIC }   /* isbidicontrol */,
  {     0,   184,  1618,   2,   4, UNI_JAMO }   /* isjamo */,
  {    81,  8233,  9177,   7,   4, UNI_SC__HANO }   /* script=hano */,
  {     2,  8854,  8864,   5,   5, -UNI_DASH }   /* dash=false */,
  {     0,  1497,    74,   9,   2, UNI_ME }   /* category=me */,
  {   203,  1362,  7540,  24,   2, UNI_CCC__20 }   /* canonicalcombiningclass=20 */,
  {   324,  5283,     0,  14,   0, UNI_PHONETICEXTSUP }   /* phoneticextsup */,
  {     2,  8233,  7772,   7,   8, UNI_SC__ARMN }   /* script=armenian */,
  {   265,  9620,  4747,   3,  15, UNI_UPPERCASELETTER }   /* gc=uppercaseletter */,
  {   324,  2204,  6097,   3,   3, UNI_OGAM }   /* isogam */,
  {     0,  9647,  7487,   3,   1, UNI_NV__6 }   /* nv=6 */,
  {   120,   808,     0,  29,   0, UNI_MISCARROWS }   /* miscellaneoussymbolsandarrows */,
  {    30,  7025,  9683,   3,   3, UNI_IN__3_DOT_1 }   /* in=v31 */,
  {   204,  5565,  6111,  13,  12, UNI_JG__MALAYALAMNYA }   /* joininggroup=malayalamnya */,
  {     0,  8886,  8540,   5,   4, UNI_SC__KHOJ }   /* sc=khojki */,
  {     0,  8424,   719,   6,  21, UNI_ENCLOSEDALPHANUM }   /* block=enclosedalphanumerics */,
  {     0,  4687,     0,  15,   0, UNI_PS }   /* openpunctuation */,
  {     2,  8699,     0,   5,   0, UNI_BATK }   /* batak */,
  {     1,  9093,  9281,   4,   4, UNI_INNEWA }   /* blk=newa */,
  {     0,  1779,  9433,  22,   4, UNI_CWT }   /* changeswhentitlecased=true */,
  {     0,  3671,  8065,  17,   7, UNI_ELBA }   /* scriptextensions=elbasan */,
  {     0,  8886,  9257,   3,   4, UNI_SC__MLYM }   /* sc=mlym */,
  {     0,  9647,  7611,   3,   2, UNI_NV__14 }   /* nv=14 */,
  {     0,  9093,  5604,   4,  13, UNI_LOWSURROGATES }   /* blk=lowsurrogates */,
  {     8,  2453,  8864,  20,   5, -UNI_TERM }   /* terminalpunctuation=false */,
  {     3,   184,  1736,   3,  20, UNI_CWCM }   /* ischangeswhencasemapped */,
  {   276,  9909,  3468,   3,   3, UNI_PAUC }   /* ispauc */,
  {   578,  9629,  9761,   3,   2, UNI_GCB__L }   /* lb=jl */,
  {    46,  9221,     0,   4,   0, UNI_LATN }   /* latn */,
  {     1,   184,  9457,   2,   4, UNI_WCHO }   /* iswcho */,
  {     0,  5269,    36,  14,   1, UNI_PATSYN }   /* patternsyntax=t */,
  {     0,  4705,  1791,   3,   8, UNI_TITLE }   /* istitlecase */,
  {     5,  8598,     1,   6,   1, -UNI__PERL_PATWS }   /* patws=n */,
  {     2,  6005,  5884,   3,  11, UNI_CYRILLICEXTB }   /* incyrillicextb */,
  {   153,  9113,  9536,   4,   3, UNI_CCC__AR }   /* ccc=232 */,
  {     9,   184,  2760,   2,  19, UNI_MODIFIERTONELETTERS }   /* ismodifiertoneletters */,
  {   179,  8884,  1214,   5,   9, UNI_INSC__CONSONANT }   /* insc=consonant */,
  {   259,  6949,    12,   5,   3, UNI_CARI }   /* iscarian */,
  {     0,  1362,  8457,  24,   3, UNI_CCC__122 }   /* canonicalcombiningclass=122 */,
  {   265,  9647,  5409,   3,   7, UNI_NV__1000000 }   /* nv=1000000 */,
  {   546,  6316,     1,  11,   1, -UNI_IDC }   /* idcontinue=n */,
  {     0,  8424,  8514,   6,   6, UNI_INHATRAN }   /* block=hatran */,
  {     0,  8233,  9241,   7,   4, UNI_MEDF }   /* script=medf */,
  {     0,  6918,  5346,  10,   2, UNI_LB__EB }   /* linebreak=eb */,
  {     0,  1933,     0,  21,   0, UNI_LOE }   /* logicalorderexception */,
  {     3,  8886,  8562,   3,   6, UNI_LYCI }   /* sc=lycian */,
  {     0,  8424,  3586,   6,  17, UNI_INDICSIYAQNUMBERS }   /* block=indicsiyaqnumbers */,
  {    81,  8510,  9433,   4,   4, UNI_EXT }   /* ext=true */,
  {   194,  8886,  6602,   3,   4, UNI_SC__NAND }   /* sc=nand */,
  {     0,  9365,  8079,   4,   4, UNI_GRAN }   /* scx=gran */,
  {   392,  5760,  7476,  13,   8, UNI_NV__3_SLASH_20 }   /* numericvalue=1.50e-01 */,
  {     0,  9365,  6554,   5,   3, UNI_SAMR }   /* scx=samr */,
  {     5,  3868,  5500,  16,  13, UNI_ME }   /* generalcategory=enclosingmark */,
  {   129,  1773,     3,   6,   1, -UNI_CASED }   /* cased=f */,
  {     3,  9153,    34,   4,   2, UNI_GCB__EX }   /* gcb=ex */,
  {    74,  8886,  2169,   3,  11, UNI_MTEI }   /* sc=meeteimayek */,
  {     2,  9109,     0,   4,   0, UNI_CANS }   /* cans */,
  {   323,  3671,  6992,  18,   3, UNI_SOGD }   /* scriptextensions=sogd */,
  {     0,    21,  5031,   2,  14, UNI_LATINEXTD }   /* inlatinextendedd */,
  {   298,  1933,  8864,  22,   5, -UNI_LOE }   /* logicalorderexception=false */,
  {   218,  9049,  7668,   4,   3, UNI_AGE__6_DOT_2 }   /* age=6.2 */,
  {     1,  9329,     0,   4,   0, UNI_PRTI }   /* prti */,
  {    86,  9903,  3248,   6,   5, UNI_XPOSIXSPACE }   /* xposixspace */,
  {     1,  8233,  8894,   7,   5, UNI_SC__LIMB }   /* script=limbu */,
  {   140,  9365,  8568,   4,   4, UNI_LYDI }   /* scx=lydi */,
  {     0,  9113,  6393,   4,  11, UNI_CCC__DA }   /* ccc=doubleabove */,
  {    14,  3868,  9779,  16,   2, UNI_ZS }   /* generalcategory=zs */,
  {     2,  2493,     0,  20,   1, UNI_VO__U }   /* verticalorientation=u */,
  {     0,  9901,  2703,   3,   3, UNI_XIDS }   /* isxids */,
  {     0,  3671,  2253,  17,  20, UNI_HLUW }   /* scriptextensions=anatolianhieroglyphs */,
  {     0,  8233,  8914,   7,   5, UNI_NSHU }   /* script=nushu */,
  {     0,  3671,  9425,  17,   4, UNI_THAI }   /* scriptextensions=thai */,
  {   769,   184,  4864,   3,  13, UNI_CJKCOMPATFORMS }   /* iscjkcompatforms */,
  {     0,  8616,  9434,   7,   3, UNI_STERM }   /* sterm=true */,
  {     3,  8959,  9433,   5,   4, UNI_XIDS }   /* xids=true */,
  {     0,  8233,  9457,   7,   4, UNI_WCHO }   /* script=wcho */,
  {     0,  5760,  7611,  13,   2, UNI_NV__14 }   /* numericvalue=14 */,
  {     0,  9629,   958,   3,   2, UNI_LB__CP }   /* lb=cp */,
  {   369,  9049,  9698,   4,   3, UNI_AGE__5_DOT_1 }   /* age=v51 */,
  {     0,  3002,  6195,  18,   8, UNI_DT__NONCANON }   /* decompositiontype=noncanon */,
  {   290,  9365,  8324,   4,   7, UNI_ZZZZ }   /* scx=unknown */,
  {     0,    21,  7900,   2,   8, UNI_KANAEXTA }   /* inkanaexta */,
  {   164,  1977,  8864,  22,   5, -UNI__PERL_NCHAR }   /* noncharactercodepoint=false */,
  {    20,  9365,  6992,   5,   3, UNI_SOGD }   /* scx=sogd */,
  {     6,  9623,  4522,   3,  15, UNI_JG__MANICHAEANALEPH }   /* jg=manichaeanaleph */,
  {     0,  8508,     0,   5,   0, UNI_GREXT }   /* grext */,
  {     1,  9835,  9819,  14,  11, UNI__PERL_FOLDS_TO_MULTI_CHAR }   /* _perl_folds_to_multi_char */,
  {     1,  8424,  4989,   6,  14, UNI_KANGXI }   /* block=kangxiradicals */,
  {     1,  3671,  9265,  17,   4, UNI_MTEI }   /* scriptextensions=mtei */,
  {    91,   865,     0,  28,   0, UNI_SUPPUAA }   /* supplementaryprivateuseareaa */,
  {     1,    21,  1618,   2,   4, UNI_JAMO }   /* injamo */,
  {     5,  1911,  8909,  22,   5, UNI_INSC__NUKTA }   /* indicsyllabiccategory=nukta */,
  {    35,  5565,  5630,  13,  13, UNI_JG__MALAYALAMNNNA }   /* joininggroup=malayalamnnna */,
  {     0,  6338,    26,  11,   1, UNI_XPOSIXALPHA }   /* alphabetic=y */,
  {    35,  8886,  9057,   3,   4, UNI_AHOM }   /* sc=ahom */,
  {   128,  7420,     1,   8,   1, -UNI_IDS }   /* idstart=n */,
  {     0,  6338,  9734,  11,   3, UNI_XPOSIXALPHA }   /* alphabetic=yes */,
  {    60,   184,   349,   2,  33, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* issupplementalsymbolsandpictographs */,
  {   135,  6005,  3502,   3,  16, UNI_CYRILLICEXTA }   /* incyrillicextendeda */,
  {     0,  8424,  3603,   6,  17, UNI_LETTERLIKESYMBOLS }   /* block=letterlikesymbols */,
  {    32,  9113,  8770,   5,   4, UNI_CCC__25 }   /* ccc=ccc25 */,
  {     0,  6828,  2722,  10,  19, UNI_BC__LRO }   /* bidiclass=lefttorightoverride */,
  {     0,  8424,  1999,   6,  22, UNI_MODIFIERLETTERS }   /* block=spacingmodifierletters */,
  {     0,  8424,  8017,   7,   6, UNI_CJKEXTB }   /* block=cjkextb */,
  {     0,  9093,  4175,   4,  13, UNI_MATHOPERATORS }   /* blk=mathoperators */,
  {     0,  6015,  6426,  12,  11, UNI_JT__D }   /* joiningtype=dualjoining */,
  {     0,  9365,  8562,   4,   6, UNI_LYCI }   /* scx=lycian */,
  {     0,  8634,     0,   5,   0, UNI_UIDEO }   /* uideo */,
  {     0,  6816,  4268,   3,   7, UNI_BAMUMSUP }   /* inbamumsup */,
  {     1,  1362,  9539,  24,   3, UNI_CCC__DB }   /* canonicalcombiningclass=233 */,
  {     0,  1239,  9734,  25,   3, UNI_COMPEX }   /* fullcompositionexclusion=yes */,
  {     0,   184,  4172,   2,  16, UNI_SUPMATHOPERATORS }   /* issupmathoperators */,
  {   146,  5339,  2453,  15,   4, UNI_SB__ST }   /* sentencebreak=sterm */,
  {     0,  8617,  9734,   5,   3, UNI_TERM }   /* term=yes */,
  {     5,  2148,  6713,   3,  10, UNI_SUPERANDSUB }   /* insuperandsub */,
  {     0,  6267,     0,  12,   0, UNI_PHAISTOS }   /* phaistosdisc */,
  {     0,  9605,  7868,   3,   8, UNI_DT__ISO }   /* dt=isolated */,
  {     0,  2204,  7349,   4,   7, UNI_ORKH }   /* isoldturkic */,
  {   423,  9113,  8449,   5,   5, UNI_CCC__118 }   /* ccc=ccc118 */,
  {     0,  3671,  8002,  17,   4, UNI_BENG }   /* scriptextensions=beng */,
  {     0,  9593,  2192,   3,   3, UNI_BC__PDI }   /* bc=pdi */,
  {     0,  8233,  7788,   7,   4, UNI_BALI }   /* script=bali */,
  {     0,  1713,     1,  22,   1, -UNI_CWCF }   /* changeswhencasefolded=n */,
  {    30,  9365,  8679,   4,   5, UNI_ADLM }   /* scx=adlam */,
  {     0,  6005,    43,   3,  35, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* incjkcompatibilityideographssupplement */,
  {   196,  3002,  1264,  18,   5, UNI_DT__SUP }   /* decompositiontype=super */,
  {     0,  4705,  8629,   3,   5, UNI_THAA }   /* isthaana */,
  {   110,   184,  8532,   2,   6, UNI_KANBUN }   /* iskanbun */,
  {     0,  6315,     3,  12,   1, -UNI_XIDC }   /* xidcontinue=f */,
  {     7,  3002,  7836,  18,   8, UNI_DT__FRA }   /* decompositiontype=fraction */,
  {   128,   184,    34,   2,   3, UNI_EXT }   /* isext */,
  {     0,  3671,  2608,  17,  19, UNI_EGYP }   /* scriptextensions=egyptianhieroglyphs */,
  {     3,  3868,  4829,  16,   5, UNI_XPOSIXDIGIT }   /* generalcategory=digit */,
  {    16,   837,     0,  28,   0, UNI_PHONETICEXTSUP }   /* phoneticextensionssupplement */,
  {     1,  2204,  1704,   4,   2, UNI_OLCK }   /* isolck */,
  {   162,  3002,     0,  18,   0, UNI_dt_values_index }   /* decompositiontype= */,
  {     0,  8424,  5860,   7,  11, UNI_CHESSSYMBOLS }   /* block=chesssymbols */,
  {    60,  9647,  9554,   3,   3, UNI_NV__3_SLASH_4 }   /* nv=3/4 */,
  {     3,  5760,  9506,  13,   3, UNI_NV__2_SLASH_3 }   /* numericvalue=2/3 */,
  {     1,  9249,     0,   4,   0, UNI_MERC }   /* merc */,
  {     0,  2708,  1316,   4,  22, UNI_ARABICPFA }   /* inarabicpresentationformsa */,
  {    23,  3218,     0,  18,   0, UNI_ZP }   /* paragraphseparator */,
  {     0,  9365,  9309,   4,   4, UNI_OSGE }   /* scx=osge */,
  {    35,  9365,  3038,   4,   8, UNI_ETHI }   /* scx=ethiopic */,
  {     0,  8849,     0,   5,   0, UNI_cwcm_values_index }   /* cwcm= */,
  {     8,  9049,  7604,   4,   3, UNI_AGE__4 }   /* age=4.0 */,
  {    13,  3671,  8072,  17,   4, UNI_ELYM }   /* scriptextensions=elym */,
  {     6,   184,  5526,   2,   8, UNI_GREEKEXT }   /* isgreekext */,
  {     0,  7068,     0,  10,   0, UNI_SUPARROWSA }   /* suparrowsa */,
  {     5,  3868,  1767,  16,   2, UNI_NL }   /* generalcategory=nl */,
  {     0,  9629,  3820,   3,  16, UNI_LB__CL }   /* lb=closepunctuation */,
  {    16,  8424,  6279,   6,  12, UNI_PLAYINGCARDS }   /* block=playingcards */,
  {     0,  7018,  9722,  10,   3, UNI_IN__9 }   /* presentin=v90 */,
  {     0,  7018,  7502,  10,   1, UNI_IN__8 }   /* presentin=8 */,
  {    14,   184,  3236,   2,  17, UNI__PERL_PATWS }   /* ispatternwhitespace */,
  {    77,  8886,  9305,   3,   4, UNI_SC__ORYA }   /* sc=orya */,
  {     0,  8854,  9734,   5,   3, UNI_DASH }   /* dash=yes */,
  {     0,  1497,    47,  10,   1, UNI_SM }   /* category=sm */,
  {     0,  9662,  9433,   3,   4, UNI_SD }   /* sd=true */,
  {   147,  6015,  6958,  12,  10, UNI_JT__U }   /* joiningtype=nonjoining */,
  {     0,  9620,  5591,   3,  13, UNI_ZL }   /* gc=lineseparator */,
  {     0,  5565,  6097,  13,   5, UNI_JG__GAMAL }   /* joininggroup=gamal */,
  {     1,  9365,  8894,   4,   4, UNI_LIMB }   /* scx=limb */,
  {     8,  8424,  5422,   6,  13, UNI_AEGEANNUMBERS }   /* block=aegeannumbers */,
  {     0,  1362,  7446,  24,   2, UNI_CCC__25 }   /* canonicalcombiningclass=25 */,
  {     2,  2453,     0,  21,   0, UNI_TERM }   /* terminalpunctuation=t */,
  {     3,  7025,  7462,   3,   1, UNI_IN__4 }   /* in=4 */,
  {     5,  9647,  7463,   3,   1, UNI_NV__3 }   /* nv=3 */,
  {     3,  5339,    36,  15,   1, UNI_SB__ST }   /* sentencebreak=st */,
  {     0,  1158,  7957,   3,   7, UNI_INTAGBANWA }   /* intagbanwa */,
  {     2,  8424,  2333,   6,  10, UNI_INGLAGOLITIC }   /* block=glagolitic */,
  {   259,  9365,  9217,   4,   4, UNI_LAO }   /* scx=laoo */,
  {     2,  9113,    78,   4,   2, UNI_CCC__AR }   /* ccc=ar */,
  {    13,    96,     0,  10,   0, UNI_XPOSIXALPHA }   /* alphabetic */,
  {     0,  7025,  9686,   3,   3, UNI_IN__3_DOT_2 }   /* in=v32 */,
  {   168,  8233,  8538,   7,   6, UNI_SC__KHOJ }   /* script=khojki */,
  {     2,  8886,  7796,   3,   4, UNI_BASS }   /* sc=bass */,
  {     0,  9623,  4954,   3,   7, UNI_JG__HEHGOAL }   /* jg=hehgoal */,
  {   132,  6828,  3182,  10,  18, UNI_BC__LRI }   /* bidiclass=lefttorightisolate */,
  {     4,  9946,  1146,   3,   3, UNI_SORA }   /* issora */,
  {     0,  9620,   112,   3,   2, UNI_SC }   /* gc=sc */,
  {   576,  8424,  3038,   6,   8, UNI_INETHIOPIC }   /* block=ethiopic */,
  {     2,  8424,   478,   6,  31, UNI_MATHALPHANUM }   /* block=mathematicalalphanumericsymbols */,
  {     0,  9261,     0,   3,   0, UNI_MRO }   /* mro */,
  {     0,  9365,  8550,   4,   6, UNI_LEPC }   /* scx=lepcha */,
  {    74,  8684,     0,   4,   0, UNI_POSIXXDIGIT }   /* ahex */,
  {   151,   184,  8045,   3,   6, UNI_CJKEXTF }   /* iscjkextf */,
  {    21,  8233,  8622,   7,   6, UNI_SC__TELU }   /* script=telugu */,
  {     1,  3671,  8128,  17,   7, UNI_MAKA }   /* scriptextensions=makasar */,
  {    39,  9093,   629,   4,  30, UNI_CJKEXTE }   /* blk=cjkunifiedideographsextensione */,
  {   212,  6231,   495,  12,   7, UNI_NT__NU }   /* numerictype=numeric */,
  {     0,  2646,     0,  19,   0, UNI_JAMOEXTA }   /* hanguljamoextendeda */,
  {    43,   184,  3110,   2,  11, UNI_GEORGIANSUP }   /* isgeorgiansup */,
  {     2,   184,  3964,   2,  16, UNI_LATIN1 }   /* islatin1supplement */,
  {     1,  5760,  7470,  13,   2, UNI_NV__50 }   /* numericvalue=50 */,
  {   304,  8163,     0,   7,   0, UNI_nfkcqc_values_index }   /* nfkcqc= */,
  {   147,  9365,  7311,   4,   9, UNI_TALU }   /* scx=newtailue */,
  {     0,  7419,     0,   8,   0, UNI_XIDS }   /* xidstart */,
  {     3,  2212,  1601,   4,   4, UNI_INHANGUL }   /* inhangul */,
  {     0,   184,  9157,   2,   4, UNI_GONG }   /* isgong */,
  {     1,  8854,   995,   5,   2, -UNI_DASH }   /* dash=no */,
  {     0,  5760,  8354,  13,   4, UNI_NV__6000 }   /* numericvalue=6000 */,
  {     1,  9093,  5526,   4,  13, UNI_GREEKEXT }   /* blk=greekextended */,
  {     0,   184,  6267,   2,  12, UNI_PHAISTOS }   /* isphaistosdisc */,
  {    25,  8886,  7048,   3,  10, UNI_SAUR }   /* sc=saurashtra */,
  {     4,  4705,  8629,   3,   3, UNI_THAA }   /* isthaa */,
  {     0,  8233,  8255,   8,   6, UNI_SIDD }   /* script=siddham */,
  {    36,  9620,  6613,   3,  11, UNI_LO }   /* gc=otherletter */,
  {     0,  8170,    26,   7,   1, UNI_DT__NONE }   /* nfkdqc=y */,
  {   139,  6918,  5847,  10,  12, UNI_LB__SY }   /* linebreak=breaksymbols */,
  {     0,  9647,  8985,   3,   4, UNI_NV__1_SLASH_64 }   /* nv=1/64 */,
  {     0,  8254,     0,   4,   0, UNI_SIDD }   /* sidd */,
  {   528,   184,  2086,   3,  10, UNI_CYRILLICSUP }   /* iscyrillicsup */,
  {    28,  5760,  8382,  13,   5, UNI_NV__60000 }   /* numericvalue=60000 */,
  {    12,   184,   250,   2,  33, UNI_MISCMATHSYMBOLSA }   /* ismiscellaneousmathematicalsymbolsa */,
  {     0,  8884,  7028,   5,  10, UNI_INSC__PUREKILLER }   /* insc=purekiller */,
  {    73,  5760,  7558,  13,   2, UNI_NV__13 }   /* numericvalue=13 */,
  {     3,  6338,   995,  11,   2, -UNI_XPOSIXALPHA }   /* alphabetic=no */,
  {     0,  9365,  4492,   4,  15, UNI_ARMI }   /* scx=imperialaramaic */,
  {   512,  3671,  8859,  17,   4, UNI_DOGR }   /* scriptextensions=dogr */,
  {    89,  9647,  8358,   3,   5, UNI_NV__30000 }   /* nv=30000 */,
  {    64,  8254,     0,   7,   0, UNI_SIDD }   /* siddham */,
  {     1,  9093,  4298,   5,   6, UNI_BRAI }   /* blk=braille */,
  {   134,  8424,  4989,   6,   6, UNI_KANGXI }   /* block=kangxi */,
  {     0,   113,     0,  25,   0, UNI_DIACRITICALS }   /* combiningdiacriticalmarks */,
  {   404,  9049,  9575,   4,   3, UNI_AGE__6_DOT_1 }   /* age=6.1 */,
  {     9,   184,  4462,   2,  14, UNI_GREXT }   /* isgraphemeextend */,
  {   256,  9365,  9401,   4,   4, UNI_TALE }   /* scx=tale */,
  {     4,    21,  5017,   2,  14, UNI_LATINEXTC }   /* inlatinextendedc */,
  {     8,  7128,  7411,  11,   8, UNI_WB__WSEGSPACE }   /* wordbreak=wsegspace */,
  {   513,  5213,     0,  14,   0, UNI_nfcqc_values_index }   /* nfcquickcheck= */,
  {     0,   184,  5325,   2,  13, UNI_QMARK }   /* isquotationmark */,
  {     0,   184,  7311,   2,   9, UNI_TALU }   /* isnewtailue */,
  {     0,  5907,     0,  12,   0, UNI_ETHIOPICEXTA }   /* ethiopicexta */,
  {   138,  2493,    18,  20,   1, UNI_VO__R }   /* verticalorientation=r */,
  {   514,  3868,  9777,  16,   2, UNI_ZP }   /* generalcategory=zp */,
  {   714,  8944,     0,   4,   0, UNI_TAKR }   /* takr */,
  {     0,  3671,  9293,  17,   4, UNI_OGAM }   /* scriptextensions=ogam */,
  {     0,  1362,  9545,  24,   3, UNI_CCC__IS }   /* canonicalcombiningclass=240 */,
  {     0,  9647,  7660,   3,   8, UNI_NV__3_SLASH_5 }   /* nv=6.00e-01 */,
  {   129,  8886,  2484,   3,   4, UNI_SC__MAND }   /* sc=mand */,
  {   249,  9659,  8864,   3,   5, -UNI_RI }   /* ri=false */,
  {   787,  1497,    32,   9,   2, UNI__PERL_SURROGATE }   /* category=cs */,
  {     0,  8233,  9205,   7,   4, UNI_SC__KNDA }   /* script=knda */,
  {     1,  8424,  3290,   6,   4, UNI_RUMI }   /* block=rumi */,
  {    99,  7419,     0,   9,   0, UNI_xids_values_index }   /* xidstart= */,
  {    12,  9237,  9734,   4,   3, UNI_LOE }   /* loe=yes */,
  {   327,  8598,  9734,   6,   3, UNI__PERL_PATWS }   /* patws=yes */,
  {   648,  1977,  9433,  22,   4, UNI__PERL_NCHAR }   /* noncharactercodepoint=true */,
  {     0,  9093,  8317,   4,   7, UNI_UCASEXT }   /* blk=ucasext */,
  {     0,  5339,    34,  14,   6, UNI_SB__EX }   /* sentencebreak=extend */,
  {   318,  8520,  9433,   6,   4, UNI_JOINC }   /* joinc=true */,
  {     0,  5835,     3,  12,   1, -UNI_BIDIC }   /* bidicontrol=f */,
  {     2,  9093,   539,   4,  30, UNI_CJKEXTB }   /* blk=cjkunifiedideographsextensionb */,
  {     0,  9593,     0,   3,   0, UNI_bc_values_index }   /* bc= */,
  {    96,   184,  9241,   2,   4, UNI_MEDF }   /* ismedf */,
  {    24,  5353,     0,  14,   0, UNI_ZS }   /* spaceseparator */,
  {     4,  9909,  8227,   3,   6, UNI_PHAG }   /* isphagspa */,
  {     0,  8332,  4808,   3,  13, UNI_ANCIENTSYMBOLS }   /* isancientsymbols */,
  {    24,  3002,    45,  18,   6, UNI_DT__COM }   /* decompositiontype=compat */,
  {     3,  2708,    80,   4,   8, UNI_ARABICMATH }   /* inarabicmath */,
  {     7,  9623,  8544,   3,   6, UNI_JG__LAMADH }   /* jg=lamadh */,
  {    69,  8879,  7357,   3,   8, UNI_PALM }   /* inpalmyrene */,
  {     0,  2148,   866,   3,  27, UNI_SUPPUAA }   /* insupplementaryprivateuseareaa */,
  {     1,  6005,  2086,   3,   7, UNI_INCYRILLIC }   /* incyrillic */,
  {     0,  9113,  8775,   5,   4, UNI_CCC__26 }   /* ccc=ccc26 */,
  {    91,  9647,  9033,   3,   4, UNI_NV__3_SLASH_80 }   /* nv=3/80 */,
  {     1,  6569,     0,  11,   0, UNI_MISCSYMBOLS }   /* miscsymbols */,
  {     3,   184,  2333,   2,   4, UNI_GLAG }   /* isglag */,
  {    21,  8960,  9734,   4,   3, UNI_IDS }   /* ids=yes */,
  {     0,  7025,  7548,   3,   3, UNI_IN__3_DOT_1 }   /* in=3.1 */,
  {     1,  8233,  1599,   7,   6, UNI_SC__HANG }   /* script=hangul */,
  {    13,  1911,  2768,  22,  10, UNI_INSC__TONELETTER }   /* indicsyllabiccategory=toneletter */,
  {   284,  9647,  7460,   3,   8, UNI_NV__1_SLASH_7 }   /* nv=1.43e-01 */,
  {   111,  6679,  8864,  11,   5, -UNI_SD }   /* softdotted=false */,
  {   222,  9647,  8782,   3,   2, UNI_NV__27 }   /* nv=27 */,
  {   149,   184,  1264,   2,  25, UNI_SUPERANDSUB }   /* issuperscriptsandsubscripts */,
  {   279,  8424,  8919,   6,   5, UNI_INOGHAM }   /* block=ogham */,
  {     0,  4849,   995,  14,   2, -UNI_CI }   /* caseignorable=no */,
  {   260,   184,  4388,   3,  14, UNI_CURRENCYSYMBOLS }   /* iscurrencysymbols */,
  {    10,  9728,   995,   3,   2, -UNI_VS }   /* vs=no */,
  {     0,  3868,  9769,  16,   2, UNI_CASEDLETTER }   /* generalcategory=l_ */,
  {     1,  5760,  7428,  13,   8, UNI_NV__1_SLASH_10 }   /* numericvalue=1.00e-01 */,
  {     0,  2779,     0,   9,   0, UNI_MONG }   /* mongolian */,
  {     1,   184,  8038,   3,   6, UNI_CJKEXTE }   /* iscjkexte */,
  {     2,  2148,  6691,   3,  10, UNI_INSORASOMPENG }   /* insorasompeng */,
  {   641,  9365,  8934,   4,   5, UNI_RUNR }   /* scx=runic */,
  {     0,  5760,  8376,  13,   5, UNI_NV__50000 }   /* numericvalue=50000 */,
  {    64,  8233,  9309,   7,   4, UNI_OSGE }   /* script=osge */,
  {     0,  9365,  2333,   4,  10, UNI_GLAG }   /* scx=glagolitic */,
  {     0,  9626,  6958,   3,  10, UNI_JT__U }   /* jt=nonjoining */,
  {   130,  9623,  6908,   3,  10, UNI_JG__KNOTTEDHEH }   /* jg=knottedheh */,
  {   809,  3671,  9261,  17,   4, UNI_MRO }   /* scriptextensions=mroo */,
  {     0,  8424,  6027,   6,   5, UNI_INKHMER }   /* block=khmer */,
  {     1,  3671,  4220,  17,   4, UNI_TANG }   /* scriptextensions=tang */,
  {   780,  3671,  8282,  17,   7, UNI_TGLG }   /* scriptextensions=tagalog */,
  {     0,   184,  4373,   3,  14, UNI_CONTROLPICTURES }   /* iscontrolpictures */,
  {     0,  9904,  5492,   5,   5, UNI_POSIXALNUM }   /* posixalnum */,
  {     0,  9093,  9453,   4,   3, UNI_INVAI }   /* blk=vai */,
  {  1571,  1362,  8715,  25,   4, UNI_CCC__14 }   /* canonicalcombiningclass=ccc14 */,
  {     0,  8886,   983,   3,   5, UNI_SC__GREK }   /* sc=greek */,
  {     0,  9647,  8675,   3,   4, UNI_NV__1_SLASH_12 }   /* nv=1/12 */,
  {     2,   349,     0,  33,   0, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* supplementalsymbolsandpictographs */,
  {     4,  2142,  2394,   3,  19, UNI_INNYIAKENGPUACHUEHMONG }   /* innyiakengpuachuehmong */,
  {    34,  9647,  9590,   3,   3, UNI_NV__9_SLASH_2 }   /* nv=9/2 */,
  {  1320,  7128,  5919,  10,  12, UNI_WB__EX }   /* wordbreak=extendnumlet */,
  {     2,  8233,  8550,   7,   4, UNI_LEPC }   /* script=lepc */,
  {   210,  8886,  6991,   3,   7, UNI_SC__SOGD }   /* sc=sogdian */,
  {     6,  9365,  8058,   4,   7, UNI_DSRT }   /* scx=deseret */,
  {     0,   184,   283,   2,  33, UNI_MISCMATHSYMBOLSB }   /* ismiscellaneousmathematicalsymbolsb */,
  {     0,  8884,  4612,   5,  15, UNI_INSC__MODIFYINGLETTER }   /* insc=modifyingletter */,
  {     0,  3671,  9201,  17,   4, UNI_KHMR }   /* scriptextensions=khmr */,
  {   520,  3951,   325,   3,   3, UNI_ITAL }   /* isital */,
  {     9,  9623,  2561,   3,   3, UNI_JG__YEH }   /* jg=yeh */,
  {   416,  3868,  7098,  16,  10, UNI_CN }   /* generalcategory=unassigned */,
  {     0,  9377,     0,   4,   0, UNI_SHAW }   /* shaw */,
  {    11,  5760,  7692,  13,   8, UNI_NV__13_SLASH_2 }   /* numericvalue=6.50e+00 */,
  {     0,  6816,  4298,   3,   6, UNI_BRAI }   /* inbraille */,
  {    41,  3243,     3,  11,   1, -UNI_XPOSIXSPACE }   /* whitespace=f */,
  {    56,  9093,  2085,   4,  18, UNI_CYRILLICSUP }   /* blk=cyrillicsupplement */,
  {  1400,  1362,  5410,  24,   1, UNI_CCC__0 }   /* canonicalcombiningclass=0 */,
  {    17,  6918,  1696,  10,   2, UNI_LB__AI }   /* linebreak=ai */,
  {     1,  8233,  8568,   7,   4, UNI_LYDI }   /* script=lydi */,
  {   771,  3671,  9273,  17,   4, UNI_NARB }   /* scriptextensions=narb */,
  {     0,  4417,     0,  15,   0, UNI_DIACRITICALSEXT }   /* diacriticalsext */,
  {    44,  9608,   835,   3,   1, UNI_EA__W }   /* ea=w */,
  {     0,  8514,     0,   6,   0, UNI_HATR }   /* hatran */,
  {     0,  3671,  9081,  17,   4, UNI_AVST }   /* scriptextensions=avst */,
  {    22,  2453,    26,  20,   1, UNI_TERM }   /* terminalpunctuation=y */,
  {     0,  5565,  9369,  13,   4, UNI_JG__SEEN }   /* joininggroup=seen */,
  {     0,  8233,  6988,   7,  10, UNI_SOGO }   /* script=oldsogdian */,
  {     2,  6918,  5967,  10,  12, UNI_LB__HL }   /* linebreak=hebrewletter */,
  {    50,  8886,  4297,   3,   4, UNI_BRAI }   /* sc=brai */,
  {     2,  5760,  8400,  13,   3, UNI_NV__900 }   /* numericvalue=900 */,
  {     3,  9623,  5630,   3,  13, UNI_JG__MALAYALAMNNNA }   /* jg=malayalamnnna */,
  {     1,  9909,    83,   3,   2, UNI_PCM }   /* ispcm */,
  {     0,  1136,    26,  26,   1, UNI_DI }   /* defaultignorablecodepoint=y */,
  {     1,  1924,     0,  11,   0, UNI_LO }   /* category=lo */,
  {     3,  8233,  9297,   7,   4, UNI_OLCK }   /* script=olck */,
  {     3,  7892,     0,   8,   0, UNI_JAVA }   /* javanese */,
  {    73,  6828,    32,  10,   2, UNI_BC__CS }   /* bidiclass=cs */,
  {     0,  8886,  2741,   3,   4, UNI_MERO }   /* sc=mero */,
  {   782,  9647,  7684,   3,   8, UNI_NV__1_SLASH_160 }   /* nv=6.25e-03 */,
  {     0,  9365,  8205,   4,   7, UNI_OSMA }   /* scx=osmanya */,
  {     0,  9647,  5410,   3,   1, UNI_NV__0 }   /* nv=0 */,
  {    19,  8508,   995,   6,   2, -UNI_GREXT }   /* grext=no */,
  {     1,  3671,  6978,  17,  10, UNI_XPEO }   /* scriptextensions=oldpersian */,
  {   545,  1158,  4221,   3,  15, UNI_TANGUTCOMPONENTS }   /* intangutcomponents */,
  {    74,  3020,     0,  10,   0, UNI_DEVA }   /* devanagari */,
  {   515,  9113,  1189,   4,   3, UNI_CCC__214 }   /* ccc=ata */,
  {     0,  8854,     1,   5,   1, -UNI_DASH }   /* dash=n */,
  {   404,  1158,  8945,   3,   4, UNI_INTAKRI }   /* intakri */,
  {   513,  9153,   125,   4,   2, UNI_LB__CR }   /* gcb=cr */,
  {     4,  8886,  9081,   3,   4, UNI_AVST }   /* sc=avst */,
  {   304,  8233,  2741,   7,   4, UNI_MERO }   /* script=mero */,
  {     0,  9605,  7836,   3,   3, UNI_DT__FRA }   /* dt=fra */,
  {     0,   184,  1668,   2,  23, UNI_SUPPUNCTUATION }   /* issupplementalpunctuation */,
  {     0,  1497,  5199,   9,  14, UNI_SK }   /* category=modifiersymbol */,
  {    40,  9647,  9749,   3,   2, UNI_NV__48 }   /* nv=48 */,
  {   440,  5325,   995,  14,   2, -UNI_QMARK }   /* quotationmark=no */,
  {     1,  3671,  4492,  17,  15, UNI_ARMI }   /* scriptextensions=imperialaramaic */,
  {     0,  8424,  6382,   6,  11, UNI_DOMINO }   /* block=dominotiles */,
  {     0,   184,  8079,   2,   4, UNI_GRAN }   /* isgran */,
  {     0,  8960,     1,   4,   1, -UNI_IDS }   /* ids=n */,
  {  1550,  8233,  9353,   7,   4, UNI_RUNR }   /* script=runr */,
  {     2,  5760,  8464,  13,   2, UNI_NV__29 }   /* numericvalue=29 */,
  {    50,  9662,     1,   3,   1, -UNI_SD }   /* sd=n */,
  {     1,  7018,  9710,  10,   3, UNI_IN__6_DOT_2 }   /* presentin=v62 */,
  {     0,  9909,   131,   3,   3, UNI_PALM }   /* ispalm */,
  {     0,  3671,  9189,  17,   4, UNI_HMNP }   /* scriptextensions=hmnp */,
  {     0,   184,  9229,   2,   4, UNI_LINB }   /* islinb */,
  {     1,  8233,  8149,   7,   4, UNI_SC__MULT }   /* script=mult */,
  {  1230,   184,  8914,   2,   5, UNI_NSHU }   /* isnushu */,
  {     0,   184,  2067,   2,   7, UNI_RADICAL }   /* isradical */,
  {   386,  3671,  8514,  17,   6, UNI_HATR }   /* scriptextensions=hatran */,
  {     0,  8233,  4717,   7,   5, UNI_SC__TAML }   /* script=tamil */,
  {   162,  9065,     0,   4,   0, UNI_ARMI }   /* armi */,
  {    33,  8884,  4342,   5,  15, UNI_INSC__CONSONANTMEDIAL }   /* insc=consonantmedial */,
  {     0,  8406,    26,   6,   1, UNI_XPOSIXALPHA }   /* alpha=y */,
  {     1,  6371,     3,  11,   1, -UNI_DEP }   /* deprecated=f */,
  {     0,  1362,  1149,  24,   2, UNI_CCC__BL }   /* canonicalcombiningclass=bl */,
  {     0,  5786,     0,  13,   0, UNI_VERTICALFORMS }   /* verticalforms */,
  {     0,  9121,   995,   4,   2, -UNI_CWL }   /* cwl=no */,
  {     1,  5565,  6878,  13,  10, UNI_JG__DALATHRISH }   /* joininggroup=dalathrish */,
  {     0,  8233,  9301,   7,   4, UNI_ORKH }   /* script=orkh */,
  {     0,  9620,  5500,   3,  13, UNI_ME }   /* gc=enclosingmark */,
  {     5,  4975,     0,   7,   0, UNI_KANASUP }   /* kanasup */,
  {     0,  9093,  2085,   4,  21, UNI_CYRILLICSUP }   /* blk=cyrillicsupplementary */,
  {   275,  3227,     0,   9,   0, UNI_Z }   /* separator */,
  {     0,  9137,  9433,   4,   4, UNI_DEP }   /* dep=true */,
  {  1297,  9365,  1188,   4,   8, UNI_KANA }   /* scx=katakana */,
  {    12,  9593,  2373,   3,  20, UNI_BC__LRE }   /* bc=lefttorightembedding */,
  {  1314,  9904,    96,   5,   5, UNI_POSIXALPHA }   /* posixalpha */,
  {     3,  8886,  8247,   3,   7, UNI_SHAW }   /* sc=shavian */,
  {   138,  9365,  8929,   4,   5, UNI_OSGE }   /* scx=osage */,
  {     8,  8424,  4762,   6,   8, UNI_VEDICEXT }   /* block=vedicext */,
  {     0,  5565,  5097,  13,   4, UNI_JG__BETH }   /* joininggroup=beth */,
  {   156,  9909,   467,   7,   5, UNI_POSIXPUNCT }   /* isposixpunct */,
  {     1,  5859,     0,  12,   0, UNI_CHESSSYMBOLS }   /* chesssymbols */,
  {     0,  4778,  7981,   3,   7, UNI_UGAR }   /* isugaritic */,
  {   177,   184,  7876,   2,   8, UNI_JAMOEXTA }   /* isjamoexta */,
  {     0,  8233,  8944,   7,   4, UNI_SC__TAKR }   /* script=takr */,
  {     3,  8233,   382,   7,   4, UNI_EGYP }   /* script=egyp */,
  {     0,  8496,     0,   6,   0, UNI_cwkcf_values_index }   /* cwkcf= */,
  {     3,   184,  7058,   2,  10, UNI_SMALLFORMS }   /* issmallforms */,
  {     3,  8510,  9734,   4,   3, UNI_EXT }   /* ext=yes */,
  {     0,  4792,     0,  15,   0, UNI_ZANB }   /* zanabazarsquare */,
  {     2,  7419,  9734,   9,   3, UNI_XIDS }   /* xidstart=yes */,
  {     0,  6885,  2431,   3,   3, UNI_HATR }   /* ishatr */,
  {     0,  2006,     0,   4,   0, UNI_MODI }   /* modi */,
  {    29,  9647,  7444,   3,   8, UNI_NV__1_SLASH_8 }   /* nv=1.25e-01 */,
  {     1,  6183,     0,   4,   0, UNI_MEND }   /* mend */,
  {     0,  3671,  9453,  17,   3, UNI_VAI }   /* scriptextensions=vai */,
  {   694,  1084,     3,  26,   1, -UNI_CWKCF }   /* changeswhennfkccasefolded=f */,
  {     0,  9049,  9551,   4,   3, UNI_AGE__3_DOT_2 }   /* age=3.2 */,
  {     0,  8884,  8331,   5,   7, UNI_INSC__VISARGA }   /* insc=visarga */,
  {     0,  3308,     0,  12,   0, UNI_SMALLKANAEXT }   /* smallkanaext */,
  {     0,  7018,  7098,  10,  10, UNI_AGE__NA }   /* presentin=unassigned */,
  {     2,  9125,  9734,   4,   3, UNI_CWT }   /* cwt=yes */,
  {     0,  3671,  8550,  17,   6, UNI_LEPC }   /* scriptextensions=lepcha */,
  {     1,  3868,   133,  16,   4, UNI_M }   /* generalcategory=mark */,
  {     0,  3868,   467,  16,  11, UNI_P }   /* generalcategory=punctuation */,
  {     3,  9946,  2212,   3,   6, UNI_SINH }   /* issinhala */,
  {  1356,  2893,     0,  19,   0, UNI_SUPARROWSC }   /* supplementalarrowsc */,
  {   849,  8079,     0,   4,   0, UNI_GRAN }   /* gran */,
  {     2,  9365,  9253,   4,   4, UNI_MIAO }   /* scx=miao */,
  {     1,  2148,   894,   3,  27, UNI_SUPPUAB }   /* insupplementaryprivateuseareab */,
  {     0,  8592,   995,   6,   2, UNI_DT__CAN }   /* nfdqc=no */,
  {    17,  5760,  7628,  13,   8, UNI_NV__3_SLASH_64 }   /* numericvalue=4.69e-02 */,
  {   518,  8100,  9433,   7,   4, UNI_HYPHEN }   /* hyphen=true */,
  {     3,  9593,  6255,   3,  12, UNI_BC__ON }   /* bc=otherneutral */,
  {     2,  8233,  6183,   7,  12, UNI_MEND }   /* script=mendekikakui */,
  {    41,  9093,  8121,   4,   7, UNI_INLINEARA }   /* blk=lineara */,
  {   162,  9137,   995,   4,   2, -UNI_DEP }   /* dep=no */,
  {     0,  9647,  7603,   3,   2, UNI_NV__24 }   /* nv=24 */,
  {  1287,  8100,     3,   7,   1, -UNI_HYPHEN }   /* hyphen=f */,
  {     1,  8338,     1,   7,   1, -UNI_XPOSIXSPACE }   /* wspace=n */,
  {     1,   184,  3020,   2,  18, UNI_DEVANAGARIEXT }   /* isdevanagariextended */,
  {     0,  9623,  9477,   3,   4, UNI_JG__ZAIN }   /* jg=zain */,
  {     0,   184,  2006,   2,  14, UNI_LM }   /* ismodifierletter */,
  {    13,  9113,  8825,   5,   4, UNI_CCC__36 }   /* ccc=ccc36 */,
  {   284,  9365,  5311,   4,  14, UNI_PHLP }   /* scx=psalterpahlavi */,
  {    83,  9093,  4946,   4,   4, UNI_INCHAM }   /* blk=cham */,
  {     0,  8332,  5493,   3,   4, UNI_XPOSIXALNUM }   /* isalnum */,
  {     0,  3688,     1,  17,   1, -UNI_STERM }   /* sentenceterminal=n */,
  {     2,   184,  1767,   2,   2, UNI_NL }   /* isnl */,
  {    36,  9365,  2169,   4,  11, UNI_MTEI }   /* scx=meeteimayek */,
  {     4,  7018,  9587,  10,   3, UNI_IN__9 }   /* presentin=9.0 */,
  {     3,  6888,     3,  10,   1, -UNI_DIA }   /* diacritic=f */,
  {   266,    21,  1188,   2,  26, UNI_KATAKANAEXT }   /* inkatakanaphoneticextensions */,
  {     7,  9365,  3729,   5,  10, UNI_SGNW }   /* scx=signwriting */,
  {   303,  9365,  3730,   5,   3, UNI_SGNW }   /* scx=sgnw */,
  {     9,  1362,  8815,  25,   4, UNI_CCC__34 }   /* canonicalcombiningclass=ccc34 */,
  {   818,   184,  3308,   2,  12, UNI_SMALLKANAEXT }   /* issmallkanaext */,
  {     2,   184,   697,   2,   2, UNI_MN }   /* ismn */,
  {     3,   184,  8934,   2,   5, UNI_RUNR }   /* isrunic */,
  {     4,   184,  4267,   2,   8, UNI_BAMUMSUP }   /* isbamumsup */,
  {    14,  9093,  3964,   4,  16, UNI_LATIN1 }   /* blk=latin1supplement */,
  {     0,  1057,  8864,  27,   5, -UNI_PCM }   /* prependedconcatenationmark=false */,
  {     1,  8886,  7956,   3,   8, UNI_SC__TAGB }   /* sc=tagbanwa */,
  {     0,  3868,  1141,  16,   2, UNI_TITLE }   /* generalcategory=lt */,
  {   859,  8886,  8058,   3,   7, UNI_DSRT }   /* sc=deseret */,
  {     3,  1362,  8449,  25,   4, UNI_CCC__11 }   /* canonicalcombiningclass=ccc11 */,
  {     0,  4220,     0,   4,   0, UNI_TANG }   /* tang */,
  {     0,  5565,  5931,  13,  12, UNI_JG__FINALSEMKATH }   /* joininggroup=finalsemkath */,
  {   821,  5565,    87,  13,   2, UNI_JG__HE }   /* joininggroup=he */,
  {  1090,   184,  9485,   2,   4, UNI_QAAI }   /* iszinh */,
  {     7,  8424,  6723,   6,  11, UNI_INSYLOTINAGRI }   /* block=sylotinagri */,
  {  1066,   183,     0,  20,   0, UNI_MISCSYMBOLS }   /* miscellaneoussymbols */,
  {     0,     1,     0,   1,   0, UNI_N }   /* n */,
  {     8,  8884,  6225,   5,   6, UNI_LB__ZWJ }   /* insc=joiner */,
  {  1544,  8424,   949,   6,  27, UNI_ALPHABETICPF }   /* block=alphabeticpresentationforms */,
  {    25,   184,  1856,   2,  11, UNI_NUMBERFORMS }   /* isnumberforms */,
  {     1,  9623,  4562,   3,   3, UNI_JG__SAD }   /* jg=sad */,
  {    10,  5883,     0,  12,   0, UNI_CYRILLICEXTB }   /* cyrillicextb */,
  {     4,  1497,     7,  10,   1, UNI_SC }   /* category=sc */,
  {     0,  9623,  6657,   3,  11, UNI_JG__ROHINGYAYEH }   /* jg=rohingyayeh */,
  {     3,  7018,  7446,  10,   1, UNI_IN__2 }   /* presentin=2 */,
  {    74,  3688,  9734,  17,   3, UNI_STERM }   /* sentenceterminal=yes */,
  {    16,  9093,  1386,   4,  24, UNI_CJKSYMBOLS }   /* blk=cjksymbolsandpunctuation */,
  {   161,  9165,     0,   4,   0, UNI_GREK }   /* grek */,
  {    20,  6005,  6870,   4,   8, UNI_COMPATJAMO }   /* incompatjamo */,
  {     0,    45,     0,   2,   0, UNI_CO }   /* co */,
  {    50,  8233,  8065,   7,   4, UNI_ELBA }   /* script=elba */,
  {     0,  9620,  1844,   3,   2, UNI_PC }   /* gc=pc */,
  {     1,  9365,  8072,   4,   4, UNI_ELYM }   /* scx=elym */,
  {     1,  9608,    66,   3,   1, UNI_EA__H }   /* ea=h */,
  {    32,  9365,  9345,   4,   4, UNI_RJNG }   /* scx=rjng */,
  {     0,  2212,  4962,   3,  13, UNI_HIGHSURROGATES }   /* inhighsurrogates */,
  {     0,  6382,     0,  11,   0, UNI_DOMINO }   /* dominotiles */,
  {     8,  4241,  8060,   4,   5, UNI_DSRT }   /* indeseret */,
  {   137,  9620,   262,   3,   2, UNI_SM }   /* gc=sm */,
  {     0,  9593,  3569,   3,  17, UNI_BC__ES }   /* bc=europeanseparator */,
  {     0,  9113,  8352,   4,   3, UNI_CCC__216 }   /* ccc=216 */,
  {     3,  8424,   831,   6,   6, UNI_ARROWS }   /* block=arrows */,
  {     0,   184,  3038,   2,  18, UNI_ETHIOPICSUP }   /* isethiopicsupplement */,
  {     0,  9946,  8255,   3,   3, UNI_SIDD }   /* issidd */,
  {     9,  8879,  2373,   5,   4, UNI_INPC__LEFT }   /* inpc=left */,
  {     0,  8844,    36,   5,   1, UNI_CWCF }   /* cwcf=t */,
  {     0,  7025,  7508,   3,   3, UNI_IN__2 }   /* in=2.0 */,
  {     0,  1735,  9433,  22,   4, UNI_CWCM }   /* changeswhencasemapped=true */,
  {     1,   184,  6027,   2,   5, UNI_KHMR }   /* iskhmer */,
  {     0,  7128,  3254,  10,  17, UNI_RI }   /* wordbreak=regionalindicator */,
  {     0,  1136,    36,  26,   1, UNI_DI }   /* defaultignorablecodepoint=t */,
  {     0,  8640,  8864,   6,   5, -UNI_XPOSIXUPPER }   /* upper=false */,
  {    28,  9113,  2912,   4,  18, UNI_CCC__216 }   /* ccc=attachedaboveright */,
  {    20,  9365,  9329,   4,   4, UNI_PRTI }   /* scx=prti */,
  {     1,  1482,  2473,  24,  12, UNI_INPC__TOPANDBOTTOM }   /* indicpositionalcategory=topandbottom */,
  {     0,  3671,  9469,  17,   4, UNI_XSUX }   /* scriptextensions=xsux */,
  {     1,  3671,  3038,  17,   8, UNI_ETHI }   /* scriptextensions=ethiopic */,
  {     3,  8424,  8652,   6,   6, UNI_INWANCHO }   /* block=wancho */,
  {     0,  6928,     3,  10,   1, -UNI_XPOSIXLOWER }   /* lowercase=f */,
  {     0,  9093,  1955,   4,  22, UNI_MISCTECHNICAL }   /* blk=miscellaneoustechnical */,
  {   546,  2212,  1601,   4,  21, UNI_COMPATJAMO }   /* inhangulcompatibilityjamo */,
  {    30,  4580,  6581,   3,  10, UNI_MYANMAREXTA }   /* inmyanmarexta */,
  {     0,  9903,  4828,   6,   6, UNI_XPOSIXXDIGIT }   /* xposixxdigit */,
  {     1,  1735,     0,  21,   0, UNI_CWCM }   /* changeswhencasemapped */,
  {     0,  8849,   995,   5,   2, -UNI_CWCM }   /* cwcm=no */,
  {  1843,  1773,  9433,   6,   4, UNI_CASED }   /* cased=true */,
  {     0,  8424,  4092,   6,  16, UNI_MISCMATHSYMBOLSB }   /* block=miscmathsymbolsb */,
  {   606,  5799,     0,  12,   0, UNI_ALPHABETICPF }   /* alphabeticpf */,
  {   890,  3868,    25,  16,   1, UNI_S }   /* generalcategory=s */,
  {   641,  8510,     3,   4,   1, -UNI_EXT }   /* ext=f */,
  {     3,  8332,  7101,   3,   7, UNI_ASSIGNED }   /* isassigned */,
  {    50,  7025,  9716,   3,   3, UNI_IN__7 }   /* in=v70 */,
  {     0,  5565,  5125,  13,   4, UNI_JG__HETH }   /* joininggroup=heth */,
  {   640,  8233,  6159,   7,  12, UNI_SC__GONM }   /* script=masaramgondi */,
  {    72,  9629,  4195,   3,   9, UNI_LB__EM }   /* lb=emodifier */,
  {     2,   184,  9161,   2,   4, UNI_GONM }   /* isgonm */,
  {     0,  9093,  3773,   5,   7, UNI_INBOPOMOFO }   /* blk=bopomofo */,
  {     0,  5435,  9734,  13,   3, UNI_BIDIM }   /* bidimirrored=yes */,
  {    12,   184,  1188,   2,  26, UNI_KATAKANAEXT }   /* iskatakanaphoneticextensions */,
  {  1057,  4580,  2171,   4,  19, UNI_MEETEIMAYEKEXT }   /* inmeeteimayekextensions */,
  {     0,  9093,  4989,   4,  14, UNI_KANGXI }   /* blk=kangxiradicals */,
  {     0,  3671,  6183,  17,  12, UNI_MEND }   /* scriptextensions=mendekikakui */,
  {    13,  6371,    26,  11,   1, UNI_DEP }   /* deprecated=y */,
  {     0,  3671,  9181,  17,   4, UNI_HLUW }   /* scriptextensions=hluw */,
  {     0,  9365,  6183,   4,   4, UNI_MEND }   /* scx=mend */,
  {    20,  9093,   983,   4,   5, UNI_INGREEK }   /* blk=greek */,
  {     0,  5565,  2127,  13,  21, UNI_JG__HANIFIROHINGYAKINNAYA }   /* joininggroup=hanifirohingyakinnaya */,
  {     0,  8233,  9197,   7,   4, UNI_SC__KALI }   /* script=kali */,
  {     0,  1003,     0,  11,   0, UNI_ENCLOSEDCJK }   /* enclosedcjk */,
  {     1,  8886,  8324,   3,   7, UNI_ZZZZ }   /* sc=unknown */,
  {     4,   184,  5617,   2,   9, UNI_MLYM }   /* ismalayalam */,
  {     0,  5565,  9341,  13,   4, UNI_JG__QAPH }   /* joininggroup=qaph */,
  {     0,  9365,  8065,   4,   7, UNI_ELBA }   /* scx=elbasan */,
  {   164,  3671,  3730,  18,   3, UNI_SGNW }   /* scriptextensions=sgnw */,
  {     1,  1867,     0,  12,   0, UNI_DIACRITICALS }   /* diacriticals */,
  {     1,  9365,   689,   4,   9, UNI_XSUX }   /* scx=cuneiform */,
  {     0,  8874,   995,   5,   2, -UNI_IDST }   /* idst=no */,
  {  3628,  9365,  7964,   4,   8, UNI_TFNG }   /* scx=tifinagh */,
  {     1,  1576,     0,  18,   0, UNI_GEOMETRICSHAPESEXT }   /* geometricshapesext */,
  {     0,  8219,     1,   7,   1, -UNI_PATSYN }   /* patsyn=n */,
  {  1301,  8406,     3,   6,   1, -UNI_XPOSIXALPHA }   /* alpha=f */,
  {    12,    21,  1622,   2,  23, UNI_LATINEXTADDITIONAL }   /* inlatinextendedadditional */,
  {     0,  8886,  8679,   3,   5, UNI_SC__ADLM }   /* sc=adlam */,
  {     0,  7932,    36,   8,   1, UNI_RADICAL }   /* radical=t */,
  {     0,  6316,     0,   3,   0, UNI_IDC }   /* idc */,
  {   278,  8604,     1,   6,   1, -UNI_QMARK }   /* qmark=n */,
  {     2,  9049,  9445,   4,   4, UNI_AGE__12 }   /* age=v120 */,
  {     0,  8332,   977,   3,  16, UNI_ANCIENTGREEKMUSIC }   /* isancientgreekmusic */,
  {   440,  8424,  6978,   6,  10, UNI_INOLDPERSIAN }   /* block=oldpersian */,
  {   520,  9781,  1472,   6,   9, UNI__PERL_SURROGATE }   /* _perl_surrogate */,
  {   739,  6918,  4631,  10,   2, UNI_LB__QU }   /* linebreak=qu */,
  {     0,  8233,  7804,   7,   8, UNI_SC__BUGI }   /* script=buginese */,
  {     2,  6371,  9734,  11,   3, UNI_DEP }   /* deprecated=yes */,
  {  2049,  9909,    96,   7,   5, UNI_POSIXALPHA }   /* isposixalpha */,
  {     2,  9365,  8502,   4,   6, UNI_GOTH }   /* scx=gothic */,
  {     0,  1057,     0,  26,   0, UNI_PCM }   /* prependedconcatenationmark */,
  {     1,  9731,  6415,   3,  11, UNI_WB__DQ }   /* wb=doublequote */,
  {     1,  3671,  1845,  17,   6, UNI_ZYYY }   /* scriptextensions=common */,
  {     0,  6828,  9638,  10,   3, UNI_BC__LRO }   /* bidiclass=lro */,
  {     3,  5085,  8144,   4,   5, UNI_INMARCHEN }   /* inmarchen */,
  {   161,   184,  1824,   3,  18, UNI_CJKCOMPATIDEOGRAPHS }   /* iscjkcompatideographs */,
  {   523,  2142,  1857,   3,  10, UNI_NUMBERFORMS }   /* innumberforms */,
  {     0,  3671,  9453,  17,   4, UNI_VAI }   /* scriptextensions=vaii */,
  {     0,  8233,  2353,   7,  20, UNI_PHLI }   /* script=inscriptionalpahlavi */,
  {     3,  1497,  4140,   9,  16, UNI_PO }   /* category=otherpunctuation */,
  {   768,  9647,  7452,   3,   8, UNI_NV__1_SLASH_80 }   /* nv=1.25e-02 */,
  {  2090,  1362,  7659,  24,   2, UNI_CCC__16 }   /* canonicalcombiningclass=16 */,
  {   644,  8879,  2379,   5,   5, UNI_INPC__RIGHT }   /* inpc=right */,
  {   130,  9093,  3884,   4,  11, UNI_GEORGIANEXT }   /* blk=georgianext */,
  {    14,  8424,  2779,   6,  19, UNI_MONGOLIANSUP }   /* block=mongoliansupplement */,
  {     0,  9365,  7008,   4,  10, UNI_PHNX }   /* scx=phoenician */,
  {   269,  8886,  9377,   3,   4, UNI_SHAW }   /* sc=shaw */,
  {  2117,  8886,  8240,   3,   7, UNI_SC__SHRD }   /* sc=sharada */,
  {     0,   184,  7128,   2,   4, UNI_XPOSIXWORD }   /* isword */,
  {     0,  8121,     0,   7,   0, UNI_LINA }   /* lineara */,
  {     0,   184,  6898,   2,   4, UNI_KHAR }   /* iskhar */,
  {     0,  5227,    26,  14,   1, UNI_NFDQC__Y }   /* nfdquickcheck=y */,
  {     0,  8424,     0,   6,   0, UNI_blk_values_index }   /* block= */,
  {    98,  8233,  6992,   8,   6, UNI_SC__SOGD }   /* script=sogdian */,
  {   776,  7108,  9734,  10,   3, UNI_XPOSIXUPPER }   /* uppercase=yes */,
  {     0,  5339,  9773,  14,   2, UNI_SB__XX }   /* sentencebreak=xx */,
  {     3,  8884,  7780,   5,   8, UNI_INSC__AVAGRAHA }   /* insc=avagraha */,
  {  2952,  4705,  4221,   3,   5, UNI_TANG }   /* istangut */,
  {     0,  3671,  7365,  17,   4, UNI_PAUC }   /* scriptextensions=pauc */,
  {     0,  9093,  7338,   4,   9, UNI_INOLDPERMIC }   /* blk=oldpermic */,
  {     0,  9093,  2533,   5,   5, UNI_INBRAHMI }   /* blk=brahmi */,
  {     0,  6918,  3254,  10,  17, UNI_RI }   /* linebreak=regionalindicator */,
  {     0,  5760,  7652,  13,   8, UNI_NV__7_SLASH_12 }   /* numericvalue=5.83e-01 */,
  {     4,  8233,  9057,   7,   4, UNI_AHOM }   /* script=ahom */,
  {   150,  9647,  7459,   3,   2, UNI_NV__21 }   /* nv=21 */,
  {     0,   184,  9165,   2,   4, UNI_GREK }   /* isgrek */,
  {     3,  5760,  9751,  13,   2, UNI_NV__49 }   /* numericvalue=49 */,
  {  2025,  8247,     0,   7,   0, UNI_SHAW }   /* shavian */,
  {     0,  9113,  8467,   5,   5, UNI_CCC__130 }   /* ccc=ccc130 */,
  {   310,  2085,     0,   8,   0, UNI_CYRL }   /* cyrillic */,
  {     4,  5565,  6778,  13,  10, UNI_JG__AFRICANFEH }   /* joininggroup=africanfeh */,
  {     0,  4705,  7957,   3,   7, UNI_TAGB }   /* istagbanwa */,
  {     0,   184,  1014,   2,   6, UNI_L }   /* isletter */,
  {     0,  1057,     3,  27,   1, -UNI_PCM }   /* prependedconcatenationmark=f */,
  {     0,  9731,  5943,   3,  12, UNI_WB__EB }   /* wb=glueafterzwj */,
  {   208,  1823,     0,  22,   0, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* cjkcompatideographssup */,
  {  4219,  1362,  8800,  25,   4, UNI_CCC__31 }   /* canonicalcombiningclass=ccc31 */,
  {     0,   184,  9108,   2,   2, UNI_MC }   /* ismc */,
  {     0,  1057,     0,  27,   0, UNI_pcm_values_index }   /* prependedconcatenationmark= */,
  {     0,  5760,  9041,  13,   4, UNI_NV__7_SLASH_12 }   /* numericvalue=7/12 */,
  {   118,  9113,  8820,   5,   4, UNI_CCC__35 }   /* ccc=ccc35 */,
  {   208,  6991,     0,   4,   0, UNI_SOGD }   /* sogd */,
  {     0,  8233,  7956,   7,   4, UNI_SC__TAGB }   /* script=tagb */,
  {     6,  8233,  8622,   7,   4, UNI_SC__TELU }   /* script=telu */,
  {  1603,  4828,     0,   6,   0, UNI_XPOSIXXDIGIT }   /* xdigit */,
  {     1,   184,  3290,   2,  18, UNI_RUMI }   /* isruminumeralsymbols */,
  {     0,  8424,  8247,   6,   7, UNI_SHAW }   /* block=shavian */,
  {     0,  3128,    26,  18,   1, UNI_IDSB }   /* idsbinaryoperator=y */,
  {     4,   184,  1257,   2,   2, UNI_UPPERCASELETTER }   /* islu */,
  {     1,  3671,  4717,  17,   5, UNI_TAML }   /* scriptextensions=tamil */,
  {     0,  5760,  7548,  13,   8, UNI_NV__1_SLASH_32 }   /* numericvalue=3.12e-02 */,
  {     4,  8684,  9734,   5,   3, UNI_POSIXXDIGIT }   /* ahex=yes */,
  {     2,  8233,  1192,   7,   4, UNI_SC__KANA }   /* script=kana */,
  {     8,  2212,  2129,   4,  12, UNI_INHANIFIROHINGYA }   /* inhanifirohingya */,
  {  3440,  6194,  8920,   3,   4, UNI_INOGHAM }   /* inogham */,
  {   169,  8886,  8093,   3,   7, UNI_SC__HANO }   /* sc=hanunoo */,
  {    11,  8424,  1030,   6,  27, UNI_OCR }   /* block=opticalcharacterrecognition */,
  {     1,  8424,  6808,   6,  10, UNI_ASCII }   /* block=basiclatin */,
  {     4,  6918,  7924,  10,   8, UNI_LB__NL }   /* linebreak=nextline */,
  {  4359,  9365,  8502,   4,   4, UNI_GOTH }   /* scx=goth */,
  {     8,  8879,  6647,   3,  10, UNI_INPAHAWHHMONG }   /* inpahawhhmong */,
  {   137,  9946,  4205,   3,   8, UNI_SYRIACSUP }   /* issyriacsup */,
  {     0,  9725,   409,   3,   2, UNI_VO__TR }   /* vo=tr */,
  {     0,  7018,  7495,  10,   1, UNI_IN__7 }   /* presentin=7 */,
  {     3,   184,  1244,   3,  19, UNI_CE }   /* iscompositionexclusion */,
  {  1155,  9620,   598,   3,   2, UNI_XPOSIXCNTRL }   /* gc=cc */,
  {    30,  1362,  8455,  25,   4, UNI_CCC__12 }   /* canonicalcombiningclass=ccc12 */,
  {  2329,  6918,  9755,  10,   2, UNI_LB__BK }   /* linebreak=bk */,
  {   265,   184,  1622,   2,   5, UNI_LATN }   /* islatin */,
  {     0,  3002,     7,  18,   3, UNI_DT__CAN }   /* decompositiontype=can */,
  {    14,  1158,  8940,   3,   4, UNI_INTAILE }   /* intaile */,
  {  1047,  8424,  6690,   6,  11, UNI_INSORASOMPENG }   /* block=sorasompeng */,
  {    10,  1735,  9734,  22,   3, UNI_CWCM }   /* changeswhencasemapped=yes */,
  {  4353,  9365,  2837,   5,   8, UNI_SUND }   /* scx=sundanese */,
  {     0,  2333,     0,  10,   0, UNI_GLAG }   /* glagolitic */,
  {     0,  9946,  6648,   3,   3, UNI_SHAW }   /* isshaw */,
  {    68,  2204,  6990,   4,   8, UNI_SOGO }   /* isoldsogdian */,
  {     2,  3671,  8628,  17,   6, UNI_THAA }   /* scriptextensions=thaana */,
  {    18,  9313,    26,   4,   1, UNI_PCM }   /* pcm=y */,
  {     0,  1057,  9734,  27,   3, UNI_PCM }   /* prependedconcatenationmark=yes */,
  {     4,  6005,    43,   3,  25, UNI_CJKCOMPATIDEOGRAPHS }   /* incjkcompatibilityideographs */,
  {     0,  7128,  9611,  10,   3, UNI_WB__EB }   /* wordbreak=ebg */,
  {    29,  9620,   467,   3,   5, UNI_P }   /* gc=punct */,
  {     0,  8424,  4657,   6,  15, UNI_NARB }   /* block=oldnortharabian */,
  {    67,   184,     0,   4,   0, UNI_CE }   /* isce */,
  {     3,  1386,     0,  24,   0, UNI_CJKSYMBOLS }   /* cjksymbolsandpunctuation */,
  {     0,  8233,  8929,   7,   5, UNI_OSGE }   /* script=osage */,
  {     0,  8886,  6051,   3,   4, UNI_SC__MAHJ }   /* sc=mahj */,
  {     0,  6918,  6459,  10,  11, UNI_LB__IN }   /* linebreak=inseperable */,
  {  4104,  8424,  4597,   6,  15, UNI_MISCPICTOGRAPHS }   /* block=miscpictographs */,
  {     0,  7018,  7604,  10,   3, UNI_IN__4 }   /* presentin=4.0 */,
  {     0,  9365,  9386,   5,   3, UNI_SHRD }   /* scx=shrd */,
  {     5,  2212,  1459,   3,  23, UNI_HIGHPUSURROGATES }   /* inhighprivateusesurrogates */,
  {  2166,  8424,  1851,   6,  16, UNI_INDICNUMBERFORMS }   /* block=indicnumberforms */,
  {  3073,  6005,  2065,   3,  13, UNI_CJKRADICALSSUP }   /* incjkradicalssup */,
  {     2,  9153,   406,   4,   7, UNI_GCB__CN }   /* gcb=control */,
  {     3,  9049,  9680,   4,   3, UNI_AGE__3 }   /* age=v30 */,
  {     0,  8072,     0,   7,   0, UNI_ELYM }   /* elymaic */,
  {     0,  1497,  9775,   9,   2, UNI_ZL }   /* category=zl */,
  {     3,  8886,  5967,   3,   6, UNI_HEBR }   /* sc=hebrew */,
  {     1,  9626,     7,   3,   1, UNI_JT__C }   /* jt=c */,
  {    53,  2043,     0,  21,   0, UNI_CJKCOMPATFORMS }   /* cjkcompatibilityforms */,
  {  5324,  2836,     0,  19,   0, UNI_SUNDANESESUP }   /* sundanesesupplement */,
  {  2272,  9626,  6426,   3,  11, UNI_JT__D }   /* jt=dualjoining */,
  {     0,  3868,    48,  16,   1, UNI_P }   /* generalcategory=p */,
  {  1115,  9623,  6878,   3,  10, UNI_JG__DALATHRISH }   /* jg=dalathrish */,
  {     0,  9365,  6978,   4,  10, UNI_XPEO }   /* scx=oldpersian */,
  {     4,  8886,  9069,   3,   4, UNI_SC__ARMN }   /* sc=armn */,
  {  4272,   184,  8002,   2,   4, UNI_BENG }   /* isbeng */,
  {   288,  7804,     0,   8,   0, UNI_BUGI }   /* buginese */,
  {     0,  9620,  2006,   3,  14, UNI_LM }   /* gc=modifierletter */,
  {     0,  9731,  5520,   3,   5, UNI_WB__EB }   /* wb=ebase */,
  {     1,  8424,  8289,   6,   7, UNI_INTAITHAM }   /* block=taitham */,
  {     0,  3671,  5967,  17,   4, UNI_HEBR }   /* scriptextensions=hebr */,
  {  4105,  8338,     0,   6,   0, UNI_XPOSIXSPACE }   /* wspace */,
  {     0,  1856,     0,  11,   0, UNI_NUMBERFORMS }   /* numberforms */,
  {  1162,  9113,  2912,   4,  13, UNI_CCC__214 }   /* ccc=attachedabove */,
  {  6164,  1362,  5539,  24,  13, UNI_CCC__IS }   /* canonicalcombiningclass=iotasubscript */,
  {   214,  8869,  8864,   5,   5, -UNI_IDSB }   /* idsb=false */,
  {     5,  8886,  2409,   3,   4, UNI_SC__MONG }   /* sc=mong */,
  {     7,  9093,  4372,   4,  15, UNI_CONTROLPICTURES }   /* blk=controlpictures */,
  {     0,  9365,  8282,   4,   7, UNI_TGLG }   /* scx=tagalog */,
  {    11,  5760,  7668,  13,   8, UNI_NV__5_SLASH_8 }   /* numericvalue=6.25e-01 */,
  {    25,  8233,  5967,   7,   4, UNI_HEBR }   /* script=hebr */,
  {     4,  7018,  8997,  10,   4, UNI_IN__11 }   /* presentin=11.0 */,
  {     0,  8424,  6183,   6,  12, UNI_INMENDEKIKAKUI }   /* block=mendekikakui */,
  {     1,  5513,  9734,  13,   3, UNI_GRBASE }   /* graphemebase=yes */,
  {     0,  3671,  8430,  17,   4, UNI_CARI }   /* scriptextensions=cari */,
  {     9,  8886,  7250,   5,   7, UNI_SC__SIND }   /* sc=khudawadi */,
  {     7,  1057,  9433,  27,   4, UNI_PCM }   /* prependedconcatenationmark=true */,
  {     0,  9093,   316,   4,  33, UNI_SUPMATHOPERATORS }   /* blk=supplementalmathematicaloperators */,
  {     0,  5760,  8388,  13,   2, UNI_NV__70 }   /* numericvalue=70 */,
  {  2048,  1450,  4936,   5,  11, UNI_INGREEK }   /* ingreekandcoptic */,
  {  1571,  8332,   183,   4,   2, UNI_ARMI }   /* isarmi */,
  {     1,  9093,  8550,   4,   6, UNI_INLEPCHA }   /* blk=lepcha */,
  {     0,   184,   690,   3,  29, UNI_CUNEIFORMNUMBERS }   /* iscuneiformnumbersandpunctuation */,
  {     0,  9093,  2930,   4,  11, UNI_CHEROKEESUP }   /* blk=cherokeesup */,
  {    21,  1482,  2473,  24,  20, UNI_INPC__TOPANDBOTTOMANDRIGHT }   /* indicpositionalcategory=topandbottomandright */,
  {    65,  9623,  2147,   3,   3, UNI_JG__AIN }   /* jg=ain */,
  {  1589,  8886,  4267,   3,   4, UNI_BAMU }   /* sc=bamu */,
  {     0,  1482,  3350,  24,  12, UNI_INPC__LEFTANDRIGHT }   /* indicpositionalcategory=leftandright */,
  {   150,  6315,     0,  11,   0, UNI_XIDC }   /* xidcontinue */,
  {     1,    62,     0,   5,   0, UNI_XPOSIXGRAPH }   /* graph */,
  {  4565,  5325,     0,  13,   0, UNI_QMARK }   /* quotationmark */,
  {    17,  8886,  7796,   3,   8, UNI_BASS }   /* sc=bassavah */,
  {     8,  8598,     0,   6,   0, UNI_patws_values_index }   /* patws= */,
  {   265,  8679,     0,   5,   0, UNI_ADLM }   /* adlam */,
  {     6,  1497,    47,   9,   1, UNI_M }   /* category=m */,
  {     0,  3236,  9433,  18,   4, UNI__PERL_PATWS }   /* patternwhitespace=true */,
  {    16,  7025,  8993,   3,   4, UNI_IN__10 }   /* in=10.0 */,
  {     0,  9365,  8568,   4,   6, UNI_LYDI }   /* scx=lydian */,
  {     0,  8424,  2086,   7,  10, UNI_CYRILLICSUP }   /* block=cyrillicsup */,
  {     0,   184,  8149,   2,   4, UNI_MULT }   /* ismult */,
  {     4,  3128,     0,   4,   0, UNI_IDSB }   /* idsb */,
  {     1,  3671,  6992,  18,   6, UNI_SOGD }   /* scriptextensions=sogdian */,
  {    36,  6898,     0,   4,   0, UNI_KHAR }   /* khar */,
  {     0,  9605,  4351,   3,   6, UNI_DT__MED }   /* dt=medial */,
  {     0,  8424,  2836,   6,   9, UNI_INSUNDANESE }   /* block=sundanese */,
  {  6039,  9647,  7500,   3,   8, UNI_NV__3_SLASH_16 }   /* nv=1.88e-01 */,
  {  3205,  4705,  4023,   3,   3, UNI_TALE }   /* istale */,
  {  1706,  7025,  7604,   3,   3, UNI_IN__4 }   /* in=4.0 */,
  {    12,   184,  9253,   2,   4, UNI_MIAO }   /* ismiao */,
  {     0,  3110,     0,   4,   0, UNI_GEOR }   /* geor */,
  {     0,  9365,  9293,   4,   4, UNI_OGAM }   /* scx=ogam */,
  {     3,  9849,  6318,  15,   8, UNI__PERL_CHARNAME_CONTINUE }   /* _perl_charname_continue */,
  {   268,  1362,  8722,  24,   2, UNI_CCC__15 }   /* canonicalcombiningclass=15 */,
  {     0,  8424,  1668,   6,  23, UNI_SUPPUNCTUATION }   /* block=supplementalpunctuation */,
  {    10,   949,     0,  27,   0, UNI_ALPHABETICPF }   /* alphabeticpresentationforms */,
  {     0,  9113,  6207,   4,  12, UNI_CCC__0 }   /* ccc=notreordered */,
  {  1056,  8592,    26,   6,   1, UNI_NFDQC__Y }   /* nfdqc=y */,
  {    10,  8886,  3020,   3,  10, UNI_SC__DEVA }   /* sc=devanagari */,
  {     0,  3980,     0,   7,   0, UNI_LINB }   /* linearb */,
  {     1,  9629,  1410,   3,  13, UNI_LB__CM }   /* lb=combiningmark */,
  {     1,   184,  9145,   2,   4, UNI_DSRT }   /* isdsrt */,
  {     0,  9093,  3535,   4,  17, UNI_CYRILLICEXTC }   /* blk=cyrillicextendedc */,
  {     0,  4705,  1086,   3,   3, UNI_TANG }   /* istang */,
  {   119,  5760,     0,  13,   0, UNI_nv_values_index }   /* numericvalue= */,
  {     0,  3671,  8502,  17,   6, UNI_GOTH }   /* scriptextensions=gothic */,
  {  3459,  9093,  8205,   4,   7, UNI_INOSMANYA }   /* blk=osmanya */,
  {   180,  9662,   995,   3,   2, -UNI_SD }   /* sd=no */,
  {     2,  9049,  5409,   4,   2, UNI_AGE__10 }   /* age=10 */,
  {     0,  9049,  9441,   4,   3, UNI_IN__1_DOT_1 }   /* age=v11 */,
  {     1,  1450,  5529,   5,  10, UNI_GREEKEXT }   /* ingreekextended */,
  {     0,  4580,  2780,   3,   8, UNI_INMONGOLIAN }   /* inmongolian */,
  {    34,  9093,  1189,   5,   4, UNI_INBATAK }   /* blk=batak */,
  {  1168,  9365,  9261,   4,   4, UNI_MRO }   /* scx=mroo */,
  {     0,  9093,  8914,   4,   5, UNI_INNUSHU }   /* blk=nushu */,
  {  2562,  2684,  6303,  19,  12, UNI_GCB__T }   /* hangulsyllabletype=trailingjamo */,
  {     0,  6723,     0,  11,   0, UNI_SYLO }   /* sylotinagri */,
  {  7075,  9093,  6948,   4,  10, UNI_MISCARROWS }   /* blk=miscarrows */,
  {     0,  9365,  1192,   4,   4, UNI_KANA }   /* scx=kana */,
  {     5,  3951,  7240,   3,   8, UNI_QAAI }   /* isinherited */,
  {     0,  2608,     0,  19,   0, UNI_EGYP }   /* egyptianhieroglyphs */,
  {   258,  3308,     0,  18,   0, UNI_SMALLKANAEXT }   /* smallkanaextension */,
  {     1,  8424,  2232,   6,   6, UNI_YIJING }   /* block=yijing */,
  {  6181,  5565,     0,  13,   0, UNI_jg_values_index }   /* joininggroup= */,
  {   528,  9093,  6183,   4,  12, UNI_INMENDEKIKAKUI }   /* blk=mendekikakui */,
  {  1291,  3688,    36,  17,   1, UNI_STERM }   /* sentenceterminal=t */,
  {     1,  8233,  7916,   7,   8, UNI_SC__MAHJ }   /* script=mahajani */,
  {  5844,  9241,     0,   4,   0, UNI_MEDF }   /* medf */,
  {     5,  9647,  8969,   3,   4, UNI_NV___MINUS_1_SLASH_2 }   /* nv=-1/2 */,
  {  2697,  3251,   995,   3,   2, -UNI_CE }   /* ce=no */,
  {     0,  9113,  8795,   5,   4, UNI_CCC__30 }   /* ccc=ccc30 */,
  {     3,  8233,  5967,   7,   6, UNI_HEBR }   /* script=hebrew */,
  {     0,  9093,  1314,   4,  24, UNI_ARABICPFA }   /* blk=arabicpresentationformsa */,
  {     5,  3671,  9297,  17,   4, UNI_OLCK }   /* scriptextensions=olck */,
  {     0,  5513,    36,  13,   1, UNI_GRBASE }   /* graphemebase=t */,
  {     0,  6816,  3773,   3,  10, UNI_BOPOMOFOEXT }   /* inbopomofoext */,
  {  2379,  6828,  4312,  10,  15, UNI_BC__CS }   /* bidiclass=commonseparator */,
  {  3202,  9605,  9668,   3,   3, UNI_DT__SQR }   /* dt=sqr */,
  {     1,  3671,  7341,  17,   4, UNI_PERM }   /* scriptextensions=perm */,
  {     0,  8884,  7320,   5,   9, UNI_INSC__NONJOINER }   /* insc=nonjoiner */,
  {    28,   184,  3038,   2,   4, UNI_ETHI }   /* isethi */,
  {     0,  6679,   995,  11,   2, -UNI_SD }   /* softdotted=no */,
  {  2089,  9623,  6795,   3,   3, UNI_JG__QAF }   /* jg=qaf */,
  {     2,  2106,  4195,  21,   9, UNI_WB__EB }   /* graphemeclusterbreak=emodifier */,
  {  2306,  6918,  9154,  10,   2, UNI_LB__CB }   /* linebreak=cb */,
  {  1683,  6005,    43,   3,   2, UNI_CJK }   /* incjk */,
  {    15,   184,     3,   3,   1, UNI_CF }   /* iscf */,
  {  5203,  8233,  7356,   7,   9, UNI_PALM }   /* script=palmyrene */,
  {     0,  6005,  8017,   3,   6, UNI_CJKEXTB }   /* incjkextb */,
  {  2089,  2453,  9434,  21,   3, UNI_TERM }   /* terminalpunctuation=true */,
  {     0,  5565,  5656,  13,  13, UNI_JG__MANICHAEANNUN }   /* joininggroup=manichaeannun */,
  {     0,  9620,  1855,   3,   2, UNI_CN }   /* gc=cn */,
  {   712,  7018,  7462,  10,   1, UNI_IN__4 }   /* presentin=4 */,
  {  1045,  8233,  2148,   7,  21, UNI_PRTI }   /* script=inscriptionalparthian */,
  {  3209,  1362,  9077,  24,   4, UNI_WB__EB }   /* canonicalcombiningclass=atbl */,
  {     0,  2741,     0,   4,   0, UNI_MERO }   /* mero */,
  {     4,  9608,     1,   3,   1, UNI_EA__N }   /* ea=n */,
  {   198,    21,  4989,   2,  14, UNI_KANGXI }   /* inkangxiradicals */,
  {     1,  8233,  9117,   7,   4, UNI_SC__CPRT }   /* script=cprt */,
  {     0,  8424,  7266,   6,   9, UNI_LATINEXTC }   /* block=latinextc */,
  {     3,  7203,     0,   9,   0, UNI_BHKS }   /* bhaiksuki */,
  {     1,  8332,  2514,   3,  18, UNI_ANCIENTGREEKNUMBERS }   /* isancientgreeknumbers */,
  {     2,  8424,  2086,   7,  20, UNI_CYRILLICSUP }   /* block=cyrillicsupplementary */,
  {   705,  3251,    26,   3,   1, UNI_CE }   /* ce=y */,
  {    30,  8935,  1153,   4,   3, UNI_ANY }   /* unicode */,
  {     0,  5760,  8989,  13,   4, UNI_NV__1_SLASH_80 }   /* numericvalue=1/80 */,
  {  2053,   184,   478,   2,  31, UNI_MATHALPHANUM }   /* ismathematicalalphanumericsymbols */,
  {  1046,   186,     0,   2,   0, UNI_CE }   /* ce */,
  {  3082,  8616,  9734,   6,   3, UNI_STERM }   /* sterm=yes */,
  {     3,  2393,     0,  20,   0, UNI_HMNP }   /* nyiakengpuachuehmong */,
  {    20,  7128,    18,  10,   2, UNI_RI }   /* wordbreak=ri */,
  {    12,  9647,  9500,   3,   3, UNI_NV__1_SLASH_7 }   /* nv=1/7 */,
  {  3076,  9647,  8382,   3,   6, UNI_NV__600000 }   /* nv=600000 */,
  {  2200,  9113,  9518,   4,   3, UNI_CCC__BL }   /* ccc=218 */,
  {   129,  9903,  8839,   6,   5, UNI_XPOSIXCNTRL }   /* xposixcntrl */,
  {  7824,  9904,  4829,   5,   5, UNI_POSIXDIGIT }   /* posixdigit */,
  {     8,  1030,     0,  27,   0, UNI_OCR }   /* opticalcharacterrecognition */,
  {     0,  6898,     0,  10,   0, UNI_KHAR }   /* kharoshthi */,
  {  3078,  2169,     0,  21,   0, UNI_MEETEIMAYEKEXT }   /* meeteimayekextensions */,
  {     0,  8886,   689,   3,   9, UNI_XSUX }   /* sc=cuneiform */,
  {     0,  1911,  2570,  22,  19, UNI_INSC__CONSONANTHEADLETTER }   /* indicsyllabiccategory=consonantheadletter */,
  {  2474,    21,  3964,   2,  16, UNI_LATIN1 }   /* inlatin1supplement */,
  {     2,  9909,  7357,   3,   8, UNI_PALM }   /* ispalmyrene */,
  {     2,   184,  3110,   2,  18, UNI_GEORGIANSUP }   /* isgeorgiansupplement */,
  {  2069,  9593,  3243,   3,  10, UNI_BC__WS }   /* bc=whitespace */,
  {     0,   119,  8503,   3,   5, UNI_INGOTHIC }   /* ingothic */,
  {   586,  9365,  8142,   4,   4, UNI_MARC }   /* scx=marc */,
  {     0,  1482,  6383,   3,   5, UNI_DOMINO }   /* indomino */,
  {  5270,  1497,   467,   9,   5, UNI_P }   /* category=punct */,
  {   520,  2493,     0,  20,   0, UNI_vo_values_index }   /* verticalorientation= */,
  {     1,  8879,   468,   3,  10, UNI_INPUNCTUATION }   /* inpunctuation */,
  {     0,  8884,  8646,   5,   6, UNI_INSC__VIRAMA }   /* insc=virama */,
  {     0,  8884,  4140,   5,   5, UNI_INSC__OTHER }   /* insc=other */,
  {     0,  3951,  5553,   3,  12, UNI_IPAEXT }   /* isipaextensions */,
  {     0,  7018,  9680,  10,   3, UNI_IN__3 }   /* presentin=v30 */,
  {     0,  9125,    36,   4,   1, UNI_CWT }   /* cwt=t */,
  {     0,  8685,  8864,   4,   5, -UNI_XPOSIXXDIGIT }   /* hex=false */,
  {    18,  1362,  7539,  24,   3, UNI_CCC__B }   /* canonicalcombiningclass=220 */,
  {  7433,  9599,    36,   3,   1, UNI_CI }   /* ci=t */,
  {     0,  9629,     3,   4,   1, UNI_LB__LF }   /* lb=lf */,
  {  1046,   184,  7275,   2,   9, UNI_LATINEXTD }   /* islatinextd */,
  {     0,  8424,     0,   6,  34, UNI_UCAS }   /* block=unifiedcanadianaboriginalsyllabics */,
  {  2390,  9647,  7462,   3,   2, UNI_NV__43 }   /* nv=43 */,
  {     0,   184,  1889,   2,  22, UNI_EARLYDYNASTICCUNEIFORM }   /* isearlydynasticcuneiform */,
  {    14,  4826,     1,   9,   1, -UNI_XPOSIXXDIGIT }   /* hexdigit=n */,
  {    51,  3671,  9185,  17,   4, UNI_HMNG }   /* scriptextensions=hmng */,
  {  3883,  9928,  3248,   5,   5, UNI_XPOSIXBLANK }   /* horizspace */,
  {   870,  4580,  6592,   3,  10, UNI_MYANMAREXTB }   /* inmyanmarextb */
};

MPH_VALt match_uniprop( const unsigned char * const key, const U16 key_len ) {
    const unsigned char * ptr= key;
    const unsigned char * ptr_end= key + key_len;
    U32 h= MPH_SEED1;
    U32 s;
    U32 n;
    do {
        h ^= *ptr;
        h *= MPH_FNV_CONST;
    } while ( ++ptr < ptr_end );
    n= h % MPH_BUCKETS;
    s = mph_table[n].seed2;
    if (s) {
        h= (h >> MPH_RSHIFT) ^ s;
        n = h % MPH_BUCKETS;
        if (
            ( mph_table[n].pfx_len + mph_table[n].sfx_len == key_len ) &&
            ( memcmp(mph_blob + mph_table[n].pfx, key, mph_table[n].pfx_len) == 0 ) &&
            ( !mph_table[n].sfx_len || memcmp(mph_blob + mph_table[n].sfx,
                key + mph_table[n].pfx_len, mph_table[n].sfx_len) == 0 )
        ) {
            return mph_table[n].value;
        }
    }
    return 0;
}

/* Generated from:
 * d34c77b7e7a94986cc82056919f4ffc1503b73091561e16bd8ef145ac0fd04c5 lib/Unicode/UCD.pm
 * 5e91b649379ec79af7cfb6b09410a24557cba4c6d733cd0a2b8a78a1448736d2 lib/unicore/ArabicShaping.txt
 * f5feb19cd084b2b1568fbc0f94f4b4b54941406e7fb36c7570f8352fd5022dbe lib/unicore/BidiBrackets.txt
 * e6cbd8ffe94f2e0fbfa6695d6c06c1e72eef7d3aa93cb6329d111285198b5e62 lib/unicore/BidiMirroring.txt
 * a28b205afe8625fffdb6544a5fe14cf02b91493d9900f07820fa2102a17548f7 lib/unicore/Blocks.txt
 * 9c772627c6ee77eea6a17b42927b8ee28ca05dc65d6a511062104baaf3d12294 lib/unicore/CaseFolding.txt
 * abc8394c5bde62453118b00c1c5842160a04d7fffb2e829ee5426b846596d081 lib/unicore/CompositionExclusions.txt
 * 2fc081011d8fabaf7cf4937732dd5a6d6a57e492c43f3adfeded513387ee0ec3 lib/unicore/DAge.txt
 * a6eb7a8671fb532fbd88c37fd7b20b5b2e7dbfc8b121f74c14abe2947db0da68 lib/unicore/DCoreProperties.txt
 * 92dcdda84142194a1596f22180fcdf8c0e7f86897f09cc9203c7dc636c549f5f lib/unicore/DNormalizationProps.txt
 * 904500178b2e752635bef27aaed3a2a3718a100bce35ff96b3890be7a8315d8f lib/unicore/EastAsianWidth.txt
 * 1989b03d93023d8f5cc33eebf0d2ea80c8bd8f8c97843059ea039acb582c2078 lib/unicore/EmojiData.txt
 * d7930c2a7318e66b4ba756d5e5b41fbc586c2ad43d450ae9d320a758510bae2e lib/unicore/EquivalentUnifiedIdeograph.txt
 * 8606af08712a8c18fe268d418e2e5a87eddee6e190cce4c2d5a76b4fadf035e8 lib/unicore/HangulSyllableType.txt
 * 49a1bf18b048454154881f6a8a605b5e2fc73e85fcc4df1cb26d52e8c2aeb9bf lib/unicore/IndicPositionalCategory.txt
 * 1b6f3ef6e00e5b2e2a93d2d3c954ca1cce368599c5f11874cd0f0ce222d4637b lib/unicore/IndicSyllabicCategory.txt
 * 285c5c1ae458bc3ccd6a1398a94d2d67ce6bc1d7fc0f098762836050345e9434 lib/unicore/Jamo.txt
 * 961f842fc70b5afd1d82c6645e68c10d1f701382aed38ae38cb2ff27f671903c lib/unicore/LineBreak.txt
 * ff61a0687d2f32c0dd1094254b8bde967883b43c2d4d50fd17531d498e41ab2c lib/unicore/NameAliases.txt
 * d3eb9a288ebeaf9de1237989f490705e287b6f610b59d2459fb1b7c2d8e39c39 lib/unicore/NamedSequences.txt
 * d30d3ee430cf3527449d024954f053e419fa4aa2246eb59e5cd8d621af0c4b3f lib/unicore/PropList.txt
 * efce54f7c715a332c19b3d14c6a0eea30c6cde91caf6ff0d21c755be933736f4 lib/unicore/PropValueAliases.txt
 * d3cc3f9f0b6a8f0b7ef1d6ef202675426c28f4a75de01fc69ed977a93a00982b lib/unicore/PropertyAliases.txt
 * 3746848c181b5dbc1e614dfac9b8a5e3568e6525c693ac14e692ac55dec57e91 lib/unicore/ScriptExtensions.txt
 * e6313a8edfd24f36c7a006fbcf1d1b7245b5dd009c6dde80441f0da08b822c43 lib/unicore/Scripts.txt
 * 817ce2e9edca8e075a153f54b8f3b020345e37652cd2bda9b1495c366af17e7e lib/unicore/SpecialCasing.txt
 * 93ab1acd8fd9d450463b50ae77eab151a7cda48f98b25b56baed8070f80fc936 lib/unicore/UnicodeData.txt
 * ec5ba64af58297a46de17848eb984d2b231adb304de92e9d0d3befdbf9dc2551 lib/unicore/VerticalOrientation.txt
 * 95bd55cf803b93eb0b4990cf0e1d70ede263b36412d9c6921fd6f15cef058961 lib/unicore/auxiliary/GCBTest.txt
 * 39d73448fd257e6082f83ddf4c8bf6feb191e85dc8fc56b1a8512482de5e3dea lib/unicore/auxiliary/GraphemeBreakProperty.txt
 * f385e70f79f5959ae66d64b00f4bda39db6cef78e5363a0cdd88db46eafc6c8f lib/unicore/auxiliary/LBTest.txt
 * 7d6c909af97d0ab545a132d412f6e4e65c7eb5158514a7feb9bf00bcd05875f9 lib/unicore/auxiliary/SBTest.txt
 * c47d674ef4170c46185bf56f7a4c6627f65f012295e0994f7dc4aea51f8fd8cf lib/unicore/auxiliary/SentenceBreakProperty.txt
 * 3e3320bbbe775de7f1a0b9a30021eb949116a9b05cb461c90596c5ecf1743831 lib/unicore/auxiliary/WBTest.txt
 * f221f89fe3bb3becc00de726d5694c4b7f464c316baff6d339b2ff3900bcb96c lib/unicore/auxiliary/WordBreakProperty.txt
 * db2c41c618bab54b00e58223ad11cec550f9b9fd1a471de236e660da92fe4870 lib/unicore/extracted/DBidiClass.txt
 * fecd8a1c49935d794c4c1012f4158aa536a13049a4c10d01aaf7b5f90f3b2cbc lib/unicore/extracted/DBinaryProperties.txt
 * db6f38fb4aa8b9181b5e6a9f320de9d5c2c9b5687116a619b3cb90138b025e0b lib/unicore/extracted/DCombiningClass.txt
 * 2524f69c175831fd84bfbaf13ea37992f41db167d728c51b1d0002c1d0b130b0 lib/unicore/extracted/DDecompositionType.txt
 * 16852301d54ae59b5cfe0daa6b8e17fb688ed055d59b2a5a11eaafc650cc9d30 lib/unicore/extracted/DEastAsianWidth.txt
 * 78f898b988049a5bea5039cea6ffe87a92596859ac660a6c438519b512fe2ee6 lib/unicore/extracted/DGeneralCategory.txt
 * 33441692403901287c834f96bd33b671133a6f74e2732c61a497608b9e434932 lib/unicore/extracted/DJoinGroup.txt
 * a792ac5ef602e3bace679cc96d7491701dcdb73d81c782253de88fdcc5e70e50 lib/unicore/extracted/DJoinType.txt
 * 78e2600e24fa7d5ab62117de50b382f8b31b08401c37a0782c38dacb340b64e7 lib/unicore/extracted/DLineBreak.txt
 * 1bde4ad73e271c6349fbd1972e54f38bba5cc1900c28f678e79b9e8909b31793 lib/unicore/extracted/DNumType.txt
 * 6278722699123f3890e4b1cc42011e96d8960e4958a3b93484361530983d2611 lib/unicore/extracted/DNumValues.txt
 * b3d90fc23817ea4e33e9a90107c0a6c7b23314efd5712905ed172624d5524693 lib/unicore/mktables
 * a712c758275b460d18fa77a26ed3589689bb3f69dcc1ea99b913e32db92a5cd2 lib/unicore/version
 * 2680b9254eb236c5c090f11b149605043e8c8433661b96efc4a42fb4709342a5 regen/charset_translations.pl
 * 03e51b0f07beebd5da62ab943899aa4934eee1f792fa27c1fb638c33bf4ac6ea regen/mk_PL_charclass.pl
 * eeb419293bc4fed3c653e3f41c9b7a889019e2134dc892b7bf669ccdcbeb869b regen/mk_invlists.pl
 * c56b78df81e0f96632246052d71580b212546ca02ba4075158965e11d892f21e regen/mph.pl
 * ex: set ro: */
