/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBRequest.h"

#include "DOMError.h"
#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "IDBAny.h"
#include "IDBRequest.h"
#include "IDBTransaction.h"
#include "JSDOMBinding.h"
#include "JSDOMError.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSIDBAny.h"
#include "JSIDBTransaction.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSIDBRequestTableValues[] =
{
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestResult), (intptr_t)0, NoIntrinsic },
    { "error", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestError), (intptr_t)0, NoIntrinsic },
    { "webkitErrorMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestWebkitErrorMessage), (intptr_t)0, NoIntrinsic },
    { "source", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestSource), (intptr_t)0, NoIntrinsic },
    { "transaction", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestTransaction), (intptr_t)0, NoIntrinsic },
    { "readyState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestReadyState), (intptr_t)0, NoIntrinsic },
    { "onsuccess", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestOnsuccess), (intptr_t)setJSIDBRequestOnsuccess, NoIntrinsic },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestOnerror), (intptr_t)setJSIDBRequestOnerror, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBRequestTable = { 33, 31, JSIDBRequestTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSIDBRequestConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBRequestConstructorTable = { 1, 0, JSIDBRequestConstructorTableValues, 0 };
static const HashTable* getJSIDBRequestConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBRequestConstructorTable);
}

const ClassInfo JSIDBRequestConstructor::s_info = { "IDBRequestConstructor", &Base::s_info, 0, getJSIDBRequestConstructorTable, CREATE_METHOD_TABLE(JSIDBRequestConstructor) };

JSIDBRequestConstructor::JSIDBRequestConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSIDBRequestConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSIDBRequestPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSIDBRequestConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBRequestConstructor, JSDOMWrapper>(exec, getJSIDBRequestConstructorTable(exec), jsCast<JSIDBRequestConstructor*>(cell), propertyName, slot);
}

bool JSIDBRequestConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBRequestConstructor, JSDOMWrapper>(exec, getJSIDBRequestConstructorTable(exec), jsCast<JSIDBRequestConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSIDBRequestPrototypeTableValues[] =
{
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBRequestPrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBRequestPrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBRequestPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBRequestPrototypeTable = { 8, 7, JSIDBRequestPrototypeTableValues, 0 };
static const HashTable* getJSIDBRequestPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBRequestPrototypeTable);
}

const ClassInfo JSIDBRequestPrototype::s_info = { "IDBRequestPrototype", &Base::s_info, 0, getJSIDBRequestPrototypeTable, CREATE_METHOD_TABLE(JSIDBRequestPrototype) };

JSObject* JSIDBRequestPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBRequest>(exec, globalObject);
}

bool JSIDBRequestPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBRequestPrototype* thisObject = jsCast<JSIDBRequestPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSIDBRequestPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSIDBRequestPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBRequestPrototype* thisObject = jsCast<JSIDBRequestPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSIDBRequestPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSIDBRequestTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBRequestTable);
}

const ClassInfo JSIDBRequest::s_info = { "IDBRequest", &Base::s_info, 0, getJSIDBRequestTable , CREATE_METHOD_TABLE(JSIDBRequest) };

JSIDBRequest::JSIDBRequest(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBRequest> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSIDBRequest::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSIDBRequest::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSIDBRequestPrototype::create(exec->vm(), globalObject, JSIDBRequestPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSIDBRequest::destroy(JSC::JSCell* cell)
{
    JSIDBRequest* thisObject = static_cast<JSIDBRequest*>(cell);
    thisObject->JSIDBRequest::~JSIDBRequest();
}

JSIDBRequest::~JSIDBRequest()
{
    releaseImplIfNotNull();
}

bool JSIDBRequest::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBRequest* thisObject = jsCast<JSIDBRequest*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSIDBRequest, Base>(exec, getJSIDBRequestTable(exec), thisObject, propertyName, slot);
}

bool JSIDBRequest::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBRequest* thisObject = jsCast<JSIDBRequest*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSIDBRequest, Base>(exec, getJSIDBRequestTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsIDBRequestResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(asObject(slotBase));
    ExceptionCode ec = 0;
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->result(ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue jsIDBRequestError(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(asObject(slotBase));
    ExceptionCode ec = 0;
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->error(ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue jsIDBRequestWebkitErrorMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(asObject(slotBase));
    ExceptionCode ec = 0;
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    JSC::JSValue result = jsStringOrUndefined(exec, impl->webkitErrorMessage(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsIDBRequestSource(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->source()));
    return result;
}


JSValue jsIDBRequestTransaction(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->transaction()));
    return result;
}


JSValue jsIDBRequestReadyState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->readyState());
    return result;
}


JSValue jsIDBRequestOnsuccess(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    if (EventListener* listener = impl->onsuccess()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsIDBRequestOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsIDBRequestConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBRequest* domObject = jsCast<JSIDBRequest*>(asObject(slotBase));
    return JSIDBRequest::getConstructor(exec, domObject->globalObject());
}

void JSIDBRequest::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSIDBRequest* thisObject = jsCast<JSIDBRequest*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSIDBRequest, Base>(exec, propertyName, value, getJSIDBRequestTable(exec), thisObject, slot);
}

void setJSIDBRequestOnsuccess(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(thisObject);
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    impl->setOnsuccess(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSIDBRequestOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(thisObject);
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSIDBRequest::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBRequestConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIDBRequestPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBRequest::s_info))
        return throwVMTypeError(exec);
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBRequest::s_info);
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBRequestPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBRequest::s_info))
        return throwVMTypeError(exec);
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBRequest::s_info);
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBRequestPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBRequest::s_info))
        return throwVMTypeError(exec);
    JSIDBRequest* castedThis = jsCast<JSIDBRequest*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBRequest::s_info);
    IDBRequest* impl = static_cast<IDBRequest*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSIDBRequest::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSIDBRequest* thisObject = jsCast<JSIDBRequest*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSIDBRequest* jsIDBRequest)
{
    if (jsIDBRequest->hasCustomProperties())
        return true;
    if (jsIDBRequest->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSIDBRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSIDBRequest* jsIDBRequest = jsCast<JSIDBRequest*>(handle.get().asCell());
    if (jsIDBRequest->impl()->hasPendingActivity())
        return true;
    if (jsIDBRequest->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsIDBRequest))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSIDBRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSIDBRequest* jsIDBRequest = jsCast<JSIDBRequest*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsIDBRequest->impl(), jsIDBRequest);
    jsIDBRequest->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7IDBRequest@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10IDBRequestE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IDBRequest* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSIDBRequest>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7IDBRequest@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10IDBRequestE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails IDBRequest does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(IDBRequest), IDBRequest_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // IDBRequest has subclasses. If IDBRequest has subclasses that get passed
    // to toJS() we currently require IDBRequest you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<IDBRequest>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSIDBRequest>(exec, globalObject, impl);
}

IDBRequest* toIDBRequest(JSC::JSValue value)
{
    return value.inherits(&JSIDBRequest::s_info) ? jsCast<JSIDBRequest*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
