/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMessagePort.h"

#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "MessagePort.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMessagePortTableValues[] =
{
    { "onmessage", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessagePortOnmessage), (intptr_t)setJSMessagePortOnmessage, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessagePortConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMessagePortTable = { 4, 3, JSMessagePortTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMessagePortConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMessagePortConstructorTable = { 1, 0, JSMessagePortConstructorTableValues, 0 };
static const HashTable* getJSMessagePortConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSMessagePortConstructorTable);
}

const ClassInfo JSMessagePortConstructor::s_info = { "MessagePortConstructor", &Base::s_info, 0, getJSMessagePortConstructorTable, CREATE_METHOD_TABLE(JSMessagePortConstructor) };

JSMessagePortConstructor::JSMessagePortConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMessagePortConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSMessagePortPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSMessagePortConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessagePortConstructor, JSDOMWrapper>(exec, getJSMessagePortConstructorTable(exec), jsCast<JSMessagePortConstructor*>(cell), propertyName, slot);
}

bool JSMessagePortConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMessagePortConstructor, JSDOMWrapper>(exec, getJSMessagePortConstructorTable(exec), jsCast<JSMessagePortConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSMessagePortPrototypeTableValues[] =
{
    { "postMessage", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMessagePortPrototypeFunctionPostMessage), (intptr_t)1, NoIntrinsic },
    { "start", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMessagePortPrototypeFunctionStart), (intptr_t)0, NoIntrinsic },
    { "close", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMessagePortPrototypeFunctionClose), (intptr_t)0, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMessagePortPrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMessagePortPrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMessagePortPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMessagePortPrototypeTable = { 17, 15, JSMessagePortPrototypeTableValues, 0 };
static const HashTable* getJSMessagePortPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSMessagePortPrototypeTable);
}

const ClassInfo JSMessagePortPrototype::s_info = { "MessagePortPrototype", &Base::s_info, 0, getJSMessagePortPrototypeTable, CREATE_METHOD_TABLE(JSMessagePortPrototype) };

JSObject* JSMessagePortPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMessagePort>(exec, globalObject);
}

bool JSMessagePortPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMessagePortPrototype* thisObject = jsCast<JSMessagePortPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSMessagePortPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSMessagePortPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMessagePortPrototype* thisObject = jsCast<JSMessagePortPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSMessagePortPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSMessagePortTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSMessagePortTable);
}

const ClassInfo JSMessagePort::s_info = { "MessagePort", &Base::s_info, 0, getJSMessagePortTable , CREATE_METHOD_TABLE(JSMessagePort) };

JSMessagePort::JSMessagePort(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MessagePort> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSMessagePort::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSMessagePort::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMessagePortPrototype::create(exec->vm(), globalObject, JSMessagePortPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSMessagePort::destroy(JSC::JSCell* cell)
{
    JSMessagePort* thisObject = static_cast<JSMessagePort*>(cell);
    thisObject->JSMessagePort::~JSMessagePort();
}

JSMessagePort::~JSMessagePort()
{
    releaseImplIfNotNull();
}

bool JSMessagePort::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMessagePort* thisObject = jsCast<JSMessagePort*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMessagePort, Base>(exec, getJSMessagePortTable(exec), thisObject, propertyName, slot);
}

bool JSMessagePort::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMessagePort* thisObject = jsCast<JSMessagePort*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMessagePort, Base>(exec, getJSMessagePortTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsMessagePortOnmessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMessagePort* castedThis = jsCast<JSMessagePort*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MessagePort* impl = static_cast<MessagePort*>(castedThis->impl());
    if (EventListener* listener = impl->onmessage()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsMessagePortConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMessagePort* domObject = jsCast<JSMessagePort*>(asObject(slotBase));
    return JSMessagePort::getConstructor(exec, domObject->globalObject());
}

void JSMessagePort::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSMessagePort* thisObject = jsCast<JSMessagePort*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSMessagePort, Base>(exec, propertyName, value, getJSMessagePortTable(exec), thisObject, slot);
}

void setJSMessagePortOnmessage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSMessagePort* castedThis = jsCast<JSMessagePort*>(thisObject);
    MessagePort* impl = static_cast<MessagePort*>(castedThis->impl());
    impl->setOnmessage(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSMessagePort::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMessagePortConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionPostMessage(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMessagePort::s_info))
        return throwVMTypeError(exec);
    JSMessagePort* castedThis = jsCast<JSMessagePort*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMessagePort::s_info);
    return JSValue::encode(castedThis->postMessage(exec));
}

EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionStart(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMessagePort::s_info))
        return throwVMTypeError(exec);
    JSMessagePort* castedThis = jsCast<JSMessagePort*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMessagePort::s_info);
    MessagePort* impl = static_cast<MessagePort*>(castedThis->impl());
    impl->start();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionClose(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMessagePort::s_info))
        return throwVMTypeError(exec);
    JSMessagePort* castedThis = jsCast<JSMessagePort*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMessagePort::s_info);
    MessagePort* impl = static_cast<MessagePort*>(castedThis->impl());
    impl->close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMessagePort::s_info))
        return throwVMTypeError(exec);
    JSMessagePort* castedThis = jsCast<JSMessagePort*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMessagePort::s_info);
    MessagePort* impl = static_cast<MessagePort*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMessagePort::s_info))
        return throwVMTypeError(exec);
    JSMessagePort* castedThis = jsCast<JSMessagePort*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMessagePort::s_info);
    MessagePort* impl = static_cast<MessagePort*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMessagePort::s_info))
        return throwVMTypeError(exec);
    JSMessagePort* castedThis = jsCast<JSMessagePort*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMessagePort::s_info);
    MessagePort* impl = static_cast<MessagePort*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSMessagePort* jsMessagePort)
{
    if (jsMessagePort->hasCustomProperties())
        return true;
    if (jsMessagePort->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSMessagePortOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSMessagePort* jsMessagePort = jsCast<JSMessagePort*>(handle.get().asCell());
    if (jsMessagePort->impl()->hasPendingActivity())
        return true;
    if (jsMessagePort->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsMessagePort))
        return false;
    MessagePort* root = jsMessagePort->impl();
    return visitor.containsOpaqueRoot(root);
}

void JSMessagePortOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSMessagePort* jsMessagePort = jsCast<JSMessagePort*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMessagePort->impl(), jsMessagePort);
    jsMessagePort->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MessagePort@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11MessagePortE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MessagePort* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMessagePort>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7MessagePort@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11MessagePortE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails MessagePort does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(MessagePort), MessagePort_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // MessagePort has subclasses. If MessagePort has subclasses that get passed
    // to toJS() we currently require MessagePort you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<MessagePort>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSMessagePort>(exec, globalObject, impl);
}

MessagePort* toMessagePort(JSC::JSValue value)
{
    return value.inherits(&JSMessagePort::s_info) ? jsCast<JSMessagePort*>(asObject(value))->impl() : 0;
}

}
