/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGUnitTypes.h"

#include "SVGUnitTypes.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGUnitTypesTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGUnitTypesTable = { 2, 1, JSSVGUnitTypesTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGUnitTypesConstructorTableValues[] =
{
    { "SVG_UNIT_TYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_UNIT_TYPE_USERSPACEONUSE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_USERSPACEONUSE), (intptr_t)0, NoIntrinsic },
    { "SVG_UNIT_TYPE_OBJECTBOUNDINGBOX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_OBJECTBOUNDINGBOX), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGUnitTypesConstructorTable = { 8, 7, JSSVGUnitTypesConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGUnitTypes::SVG_UNIT_TYPE_UNKNOWN, SVGUnitTypesEnumSVG_UNIT_TYPE_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGUnitTypes::SVG_UNIT_TYPE_USERSPACEONUSE, SVGUnitTypesEnumSVG_UNIT_TYPE_USERSPACEONUSEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGUnitTypes::SVG_UNIT_TYPE_OBJECTBOUNDINGBOX, SVGUnitTypesEnumSVG_UNIT_TYPE_OBJECTBOUNDINGBOXIsWrongUseDoNotCheckConstants);

const ClassInfo JSSVGUnitTypesConstructor::s_info = { "SVGUnitTypesConstructor", &Base::s_info, &JSSVGUnitTypesConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGUnitTypesConstructor) };

JSSVGUnitTypesConstructor::JSSVGUnitTypesConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGUnitTypesConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGUnitTypesPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGUnitTypesConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGUnitTypesConstructor, JSDOMWrapper>(exec, &JSSVGUnitTypesConstructorTable, jsCast<JSSVGUnitTypesConstructor*>(cell), propertyName, slot);
}

bool JSSVGUnitTypesConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGUnitTypesConstructor, JSDOMWrapper>(exec, &JSSVGUnitTypesConstructorTable, jsCast<JSSVGUnitTypesConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGUnitTypesPrototypeTableValues[] =
{
    { "SVG_UNIT_TYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_UNIT_TYPE_USERSPACEONUSE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_USERSPACEONUSE), (intptr_t)0, NoIntrinsic },
    { "SVG_UNIT_TYPE_OBJECTBOUNDINGBOX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_OBJECTBOUNDINGBOX), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGUnitTypesPrototypeTable = { 8, 7, JSSVGUnitTypesPrototypeTableValues, 0 };
const ClassInfo JSSVGUnitTypesPrototype::s_info = { "SVGUnitTypesPrototype", &Base::s_info, &JSSVGUnitTypesPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGUnitTypesPrototype) };

JSObject* JSSVGUnitTypesPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGUnitTypes>(exec, globalObject);
}

bool JSSVGUnitTypesPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGUnitTypesPrototype* thisObject = jsCast<JSSVGUnitTypesPrototype*>(cell);
    return getStaticValueSlot<JSSVGUnitTypesPrototype, JSObject>(exec, &JSSVGUnitTypesPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGUnitTypesPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGUnitTypesPrototype* thisObject = jsCast<JSSVGUnitTypesPrototype*>(object);
    return getStaticValueDescriptor<JSSVGUnitTypesPrototype, JSObject>(exec, &JSSVGUnitTypesPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGUnitTypes::s_info = { "SVGUnitTypes", &Base::s_info, &JSSVGUnitTypesTable, 0 , CREATE_METHOD_TABLE(JSSVGUnitTypes) };

JSSVGUnitTypes::JSSVGUnitTypes(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGUnitTypes> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGUnitTypes::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGUnitTypes::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGUnitTypesPrototype::create(exec->vm(), globalObject, JSSVGUnitTypesPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGUnitTypes::destroy(JSC::JSCell* cell)
{
    JSSVGUnitTypes* thisObject = static_cast<JSSVGUnitTypes*>(cell);
    thisObject->JSSVGUnitTypes::~JSSVGUnitTypes();
}

JSSVGUnitTypes::~JSSVGUnitTypes()
{
    releaseImplIfNotNull();
}

bool JSSVGUnitTypes::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGUnitTypes* thisObject = jsCast<JSSVGUnitTypes*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGUnitTypes, Base>(exec, &JSSVGUnitTypesTable, thisObject, propertyName, slot);
}

bool JSSVGUnitTypes::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGUnitTypes* thisObject = jsCast<JSSVGUnitTypes*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGUnitTypes, Base>(exec, &JSSVGUnitTypesTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGUnitTypesConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUnitTypes* domObject = jsCast<JSSVGUnitTypes*>(asObject(slotBase));
    return JSSVGUnitTypes::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGUnitTypes::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGUnitTypesConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGUnitTypesSVG_UNIT_TYPE_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGUnitTypesSVG_UNIT_TYPE_USERSPACEONUSE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGUnitTypesSVG_UNIT_TYPE_OBJECTBOUNDINGBOX(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

static inline bool isObservable(JSSVGUnitTypes* jsSVGUnitTypes)
{
    if (jsSVGUnitTypes->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGUnitTypesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGUnitTypes* jsSVGUnitTypes = jsCast<JSSVGUnitTypes*>(handle.get().asCell());
    if (!isObservable(jsSVGUnitTypes))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGUnitTypesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGUnitTypes* jsSVGUnitTypes = jsCast<JSSVGUnitTypes*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGUnitTypes->impl(), jsSVGUnitTypes);
    jsSVGUnitTypes->releaseImpl();
}

SVGUnitTypes* toSVGUnitTypes(JSC::JSValue value)
{
    return value.inherits(&JSSVGUnitTypes::s_info) ? jsCast<JSSVGUnitTypes*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
