/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSTextTrackCueList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSTextTrackCue.h"
#include "TextTrackCue.h"
#include "TextTrackCueList.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTextTrackCueListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCueListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCueListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextTrackCueListTable = { 5, 3, JSTextTrackCueListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSTextTrackCueListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextTrackCueListConstructorTable = { 1, 0, JSTextTrackCueListConstructorTableValues, 0 };
const ClassInfo JSTextTrackCueListConstructor::s_info = { "TextTrackCueListConstructor", &Base::s_info, &JSTextTrackCueListConstructorTable, 0, CREATE_METHOD_TABLE(JSTextTrackCueListConstructor) };

JSTextTrackCueListConstructor::JSTextTrackCueListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTextTrackCueListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSTextTrackCueListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSTextTrackCueListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextTrackCueListConstructor, JSDOMWrapper>(exec, &JSTextTrackCueListConstructorTable, jsCast<JSTextTrackCueListConstructor*>(cell), propertyName, slot);
}

bool JSTextTrackCueListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTextTrackCueListConstructor, JSDOMWrapper>(exec, &JSTextTrackCueListConstructorTable, jsCast<JSTextTrackCueListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSTextTrackCueListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTextTrackCueListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { "getCueById", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTextTrackCueListPrototypeFunctionGetCueById), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextTrackCueListPrototypeTable = { 4, 3, JSTextTrackCueListPrototypeTableValues, 0 };
const ClassInfo JSTextTrackCueListPrototype::s_info = { "TextTrackCueListPrototype", &Base::s_info, &JSTextTrackCueListPrototypeTable, 0, CREATE_METHOD_TABLE(JSTextTrackCueListPrototype) };

JSObject* JSTextTrackCueListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTextTrackCueList>(exec, globalObject);
}

bool JSTextTrackCueListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTextTrackCueListPrototype* thisObject = jsCast<JSTextTrackCueListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSTextTrackCueListPrototypeTable, thisObject, propertyName, slot);
}

bool JSTextTrackCueListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTextTrackCueListPrototype* thisObject = jsCast<JSTextTrackCueListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTextTrackCueListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSTextTrackCueList::s_info = { "TextTrackCueList", &Base::s_info, &JSTextTrackCueListTable, 0 , CREATE_METHOD_TABLE(JSTextTrackCueList) };

JSTextTrackCueList::JSTextTrackCueList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<TextTrackCueList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSTextTrackCueList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSTextTrackCueList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTextTrackCueListPrototype::create(exec->vm(), globalObject, JSTextTrackCueListPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSTextTrackCueList::destroy(JSC::JSCell* cell)
{
    JSTextTrackCueList* thisObject = static_cast<JSTextTrackCueList*>(cell);
    thisObject->JSTextTrackCueList::~JSTextTrackCueList();
}

JSTextTrackCueList::~JSTextTrackCueList()
{
    releaseImplIfNotNull();
}

bool JSTextTrackCueList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTextTrackCueList* thisObject = jsCast<JSTextTrackCueList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSTextTrackCueList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<TextTrackCueList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSTextTrackCueList, Base>(exec, &JSTextTrackCueListTable, thisObject, propertyName, slot);
}

bool JSTextTrackCueList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTextTrackCueList* thisObject = jsCast<JSTextTrackCueList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSTextTrackCueListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<TextTrackCueList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSTextTrackCueList, Base>(exec, &JSTextTrackCueListTable, thisObject, propertyName, descriptor);
}

bool JSTextTrackCueList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSTextTrackCueList* thisObject = jsCast<JSTextTrackCueList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<TextTrackCueList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsTextTrackCueListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTextTrackCueList* castedThis = jsCast<JSTextTrackCueList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TextTrackCueList* impl = static_cast<TextTrackCueList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsTextTrackCueListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTextTrackCueList* domObject = jsCast<JSTextTrackCueList*>(asObject(slotBase));
    return JSTextTrackCueList::getConstructor(exec, domObject->globalObject());
}

void JSTextTrackCueList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSTextTrackCueList* thisObject = jsCast<JSTextTrackCueList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<TextTrackCueList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSTextTrackCueList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextTrackCueListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTextTrackCueListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTextTrackCueList::s_info))
        return throwVMTypeError(exec);
    JSTextTrackCueList* castedThis = jsCast<JSTextTrackCueList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTextTrackCueList::s_info);
    TextTrackCueList* impl = static_cast<TextTrackCueList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTextTrackCueListPrototypeFunctionGetCueById(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTextTrackCueList::s_info))
        return throwVMTypeError(exec);
    JSTextTrackCueList* castedThis = jsCast<JSTextTrackCueList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTextTrackCueList::s_info);
    TextTrackCueList* impl = static_cast<TextTrackCueList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& id(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getCueById(id)));
    return JSValue::encode(result);
}


JSValue JSTextTrackCueList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSTextTrackCueList* thisObj = jsCast<JSTextTrackCueList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<TextTrackCueList*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSTextTrackCueList* jsTextTrackCueList)
{
    if (jsTextTrackCueList->hasCustomProperties())
        return true;
    return false;
}

bool JSTextTrackCueListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSTextTrackCueList* jsTextTrackCueList = jsCast<JSTextTrackCueList*>(handle.get().asCell());
    if (!isObservable(jsTextTrackCueList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSTextTrackCueListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSTextTrackCueList* jsTextTrackCueList = jsCast<JSTextTrackCueList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTextTrackCueList->impl(), jsTextTrackCueList);
    jsTextTrackCueList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, TextTrackCueList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTextTrackCueList>(exec, impl))
        return result;
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TextTrackCueList.
    COMPILE_ASSERT(!__is_polymorphic(TextTrackCueList), TextTrackCueList_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<TextTrackCueList>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSTextTrackCueList>(exec, globalObject, impl);
}

TextTrackCueList* toTextTrackCueList(JSC::JSValue value)
{
    return value.inherits(&JSTextTrackCueList::s_info) ? jsCast<JSTextTrackCueList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(VIDEO_TRACK)
