/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGScriptElement.h"

#include "KURL.h"
#include "SVGScriptElement.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGScriptElementTableValues[] =
{
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGScriptElementType), (intptr_t)setJSSVGScriptElementType, NoIntrinsic },
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGScriptElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGScriptElementHref), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGScriptElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGScriptElementTable = { 9, 7, JSSVGScriptElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGScriptElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGScriptElementConstructorTable = { 1, 0, JSSVGScriptElementConstructorTableValues, 0 };
const ClassInfo JSSVGScriptElementConstructor::s_info = { "SVGScriptElementConstructor", &Base::s_info, &JSSVGScriptElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGScriptElementConstructor) };

JSSVGScriptElementConstructor::JSSVGScriptElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGScriptElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGScriptElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGScriptElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGScriptElementConstructor, JSDOMWrapper>(exec, &JSSVGScriptElementConstructorTable, jsCast<JSSVGScriptElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGScriptElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGScriptElementConstructor, JSDOMWrapper>(exec, &JSSVGScriptElementConstructorTable, jsCast<JSSVGScriptElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGScriptElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGScriptElementPrototypeTable = { 1, 0, JSSVGScriptElementPrototypeTableValues, 0 };
const ClassInfo JSSVGScriptElementPrototype::s_info = { "SVGScriptElementPrototype", &Base::s_info, &JSSVGScriptElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGScriptElementPrototype) };

JSObject* JSSVGScriptElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGScriptElement>(exec, globalObject);
}

const ClassInfo JSSVGScriptElement::s_info = { "SVGScriptElement", &Base::s_info, &JSSVGScriptElementTable, 0 , CREATE_METHOD_TABLE(JSSVGScriptElement) };

JSSVGScriptElement::JSSVGScriptElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGScriptElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGScriptElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGScriptElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGScriptElementPrototype::create(exec->vm(), globalObject, JSSVGScriptElementPrototype::createStructure(exec->vm(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGScriptElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGScriptElement* thisObject = jsCast<JSSVGScriptElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGScriptElement, Base>(exec, &JSSVGScriptElementTable, thisObject, propertyName, slot);
}

bool JSSVGScriptElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGScriptElement* thisObject = jsCast<JSSVGScriptElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGScriptElement, Base>(exec, &JSSVGScriptElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGScriptElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGScriptElement* castedThis = jsCast<JSSVGScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGScriptElement* impl = static_cast<SVGScriptElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGScriptElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGScriptElement* castedThis = jsCast<JSSVGScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGScriptElement* impl = static_cast<SVGScriptElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGScriptElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGScriptElement* castedThis = jsCast<JSSVGScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGScriptElement* impl = static_cast<SVGScriptElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGScriptElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGScriptElement* domObject = jsCast<JSSVGScriptElement*>(asObject(slotBase));
    return JSSVGScriptElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGScriptElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGScriptElement* thisObject = jsCast<JSSVGScriptElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGScriptElement, Base>(exec, propertyName, value, &JSSVGScriptElementTable, thisObject, slot);
}

void setJSSVGScriptElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGScriptElement* castedThis = jsCast<JSSVGScriptElement*>(thisObject);
    SVGScriptElement* impl = static_cast<SVGScriptElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setType(nativeValue);
}


JSValue JSSVGScriptElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGScriptElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
