/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSTextTrackCue_h
#define JSTextTrackCue_h

#if ENABLE(VIDEO_TRACK)

#include "JSDOMBinding.h"
#include "TextTrackCue.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSTextTrackCue : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSTextTrackCue* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<TextTrackCue> impl)
    {
        JSTextTrackCue* ptr = new (NotNull, JSC::allocateCell<JSTextTrackCue>(globalObject->vm().heap)) JSTextTrackCue(structure, globalObject, impl);
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void put(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static void destroy(JSC::JSCell*);
    ~JSTextTrackCue();
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);
    static void visitChildren(JSCell*, JSC::SlotVisitor&);

    TextTrackCue* impl() const { return m_impl; }
    void releaseImpl() { m_impl->deref(); m_impl = 0; }

    void releaseImplIfNotNull()
    {
        if (m_impl) {
            m_impl->deref();
            m_impl = 0;
        }
    }

private:
    TextTrackCue* m_impl;
protected:
    JSTextTrackCue(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<TextTrackCue>);
    void finishCreation(JSC::VM&);
    static const unsigned StructureFlags = JSC::OverridesVisitChildren | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

class JSTextTrackCueOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, TextTrackCue*)
{
    DEFINE_STATIC_LOCAL(JSTextTrackCueOwner, jsTextTrackCueOwner, ());
    return &jsTextTrackCueOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, TextTrackCue*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, TextTrackCue*);
TextTrackCue* toTextTrackCue(JSC::JSValue);

class JSTextTrackCuePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSTextTrackCuePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextTrackCuePrototype* ptr = new (NotNull, JSC::allocateCell<JSTextTrackCuePrototype>(vm.heap)) JSTextTrackCuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSTextTrackCuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

class JSTextTrackCueConstructor : public DOMConstructorObject {
private:
    JSTextTrackCueConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSTextTrackCueConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSTextTrackCueConstructor* ptr = new (NotNull, JSC::allocateCell<JSTextTrackCueConstructor>(*exec->heap())) JSTextTrackCueConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
    static JSC::EncodedJSValue JSC_HOST_CALL constructJSTextTrackCue(JSC::ExecState*);
    static JSC::ConstructType getConstructData(JSC::JSCell*, JSC::ConstructData&);
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTextTrackCuePrototypeFunctionGetCueAsHTML(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTextTrackCuePrototypeFunctionAddEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTextTrackCuePrototypeFunctionRemoveEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTextTrackCuePrototypeFunctionDispatchEvent(JSC::ExecState*);
// Attributes

JSC::JSValue jsTextTrackCueTrack(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsTextTrackCueId(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCueId(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCueStartTime(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCueStartTime(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCueEndTime(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCueEndTime(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCuePauseOnExit(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCuePauseOnExit(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCueVertical(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCueVertical(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCueSnapToLines(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCueSnapToLines(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCueLine(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCueLine(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCuePosition(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCuePosition(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCueSize(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCueSize(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCueAlign(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCueAlign(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCueText(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCueText(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCueOnenter(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCueOnenter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCueOnexit(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSTextTrackCueOnexit(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsTextTrackCueConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif // ENABLE(VIDEO_TRACK)

#endif
