// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/

/*
 *  Please check the following before installing this file:
 *
 *  If you are running AT&T System V or similar systems in which
 *  there is no _bufsiz field in _iobuf, then comment out the
 *  #define HAVE_BUFSIZ line below.
 *
 *  Check whether your libc.a sprintf function returns
 *  an int (as do most) versus a char* (BSD), and (un)comment
 *  the corresponding SPRINTF_RETURNS_INT line.
 *
 *  Check the value of BUFSIZ against the one in your /usr/include/stdio.h.
 *
 *  Carefully check the fields and order of _iobuf declaration against
 *  the one in your /usr/include/stdio.h. Xenix-based systems
 *  may need some re-ordering of _iobuf. fields.
 *
 *  Note that some _IOXXX #defines may not be present in your 
 *  /usr/include/stdio.h. This is ok, so long as the ones that
 *  are present in both are set to the same values.
 *
 *  Some of the prototypes refer to functions that may not be
 *  present in your libc.a. This is ok so long as you do not
 *  actually call such functions.
 *
 */

#ifndef FILE
#pragma once


/* check and possibly comment out the following */

#ifndef USG
#define HAVE_BUFSIZ 
#endif

//#define SPRINTF_RETURNS_INT

/* check and possibly redefine the following */
#define BUFSIZ  1024            

extern  struct  _iobuf {
    int      _cnt;
    char*    _ptr;
    char*    _base;
#   ifdef HAVE_BUFSIZ
    int     _bufsiz;
    short   _flag;
#   else
    char    _flag;
#   endif
    char    _file;
} _iob[];

#define FILE     struct _iobuf

#define _IOFBF    00000
#define _IOREAD   00001
#define _IOWRT    00002
#define _IONBF    00004
#define _IOMYBUF  00010
#define _IOEOF    00020
#define _IOERR    00040
#define _IOSTRG   00100
#define _IOLBF    00200
#define _IORW     00400
#define _IOAPPEND 01000

#define EOF       (-1)

#ifndef NULL
#define NULL      0
#endif

#define stdin     (&_iob[0])
#define stdout    (&_iob[1])
#define stderr    (&_iob[2])

#define getc(p) (--(p)->_cnt>=0?(int)(*(unsigned char*)(p)->_ptr++):_filbuf(p))
#define putc(x,p) (--(p)->_cnt>=0? ((int)((unsigned char)((*(p)->_ptr++=(unsigned)(x))))):_flsbuf((unsigned)(x),p))

#define clearerr(p) ((p)->_flag &= ~(_IOERR|_IOEOF))
#define getchar()   getc(stdin)
#define putchar(x)  putc(x,stdout)
#define feof(p)     (((p)->_flag&_IOEOF)!=0)
#define ferror(p)   (((p)->_flag&_IOERR)!=0)
#define fileno(p)   ((p)->_file)

extern "C" {

int    _doprnt(const char*, void*, FILE*);
int    _doscan(FILE*, const char*, void*);
int    _filbuf(FILE*);
int    _flsbuf(unsigned, FILE*);
int    fclose(FILE*);
FILE*  fdopen(int, const char*);
int    fflush(FILE*);
int    fgetc(FILE*);
char*  fgets(char*, int, FILE *);
FILE*  fopen(const char*, const char*);
int    fprintf(FILE*, const char* ...);
int    fputc(int, FILE*);
int    fputs(const char*, FILE*);
int    fread(void*, int, int, FILE*);
FILE*  freopen(const char*, const char*, FILE*);
int    fscanf(FILE*, const char* ...);
int    fseek(FILE*, long, int);
long   ftell(FILE *);
int    fwrite(const void*, int, int, FILE*);
char*  gets(char*);
int    getw(FILE*);
int    pclose(FILE*);
FILE*  popen(const char*, const char*);
int    printf(const char* ...);
void   puts(const char*);
int    putw(int, FILE*);
int    scanf(const char* ...);
void   setbuf(FILE*, char*);
void   setbuffer(FILE*, char*, int);
void   setlinebuf(FILE*);
void   setvbuf(FILE*, char*, int, int);
int    sscanf(char*, const char* ...);
FILE*  tmpfile();
int    ungetc(int, FILE*);
int    vfprintf(FILE*, const char*, void* ap);
int    vprintf(const char*, void* ap);

#ifdef SPRINTF_RETURNS_INT
int    sprintf(char*, const char* ...);
int    vsprintf(char*, const char*, void* ap);
#else
char*  sprintf(char*, const char* ...);
char*  vsprintf(char*, const char*, void* ap);
#endif

}

#ifndef L_ctermid
#define L_ctermid	9 
#endif
#ifndef L_cuserid
#define L_cuserid	9
#endif
#ifndef P_tmpdir
#define	P_tmpdir    "/tmp/"
#endif
#ifndef L_tmpnam
#define	L_tmpnam    (sizeof(P_tmpdir) + 15)
#endif


#endif // FILE
