'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) source.n,v 1.2 2001/09/09 23:56:04 irox Exp
'\" 
.so man.macros
.TH source n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
source \- Evaluate a file or resource as a Tcl script
.SH SYNOPSIS
\fBsource \fIfileName\fR
.sp
\fBsource\fR \fB\-rsrc \fIresourceName \fR?\fIfileName\fR?
.sp
\fBsource\fR \fB\-rsrcid \fIresourceId \fR?\fIfileName\fR?
.BE

.SH DESCRIPTION
.PP
This command takes the contents of the specified file or resource
and passes it to the Tcl interpreter as a text script.  The return
value from \fBsource\fR is the return value of the last command
executed in the script.  If an error occurs in evaluating the contents
of the script then the \fBsource\fR command will return that error.
If a \fBreturn\fR command is invoked from within the script then the
remainder of the file will be skipped and the \fBsource\fR command
will return normally with the result from the \fBreturn\fR command.

The \fI\-rsrc\fR and \fI\-rsrcid\fR forms of this command are only
available on Macintosh computers.  These versions of the command
allow you to source a script from a \fBTEXT\fR resource.  You may specify
what \fBTEXT\fR resource to source by either name or id.  By default Tcl
searches all open resource files, which include the current
application and any loaded C extensions.  Alternatively, you may
specify the \fIfileName\fR where the \fBTEXT\fR resource can be found.

.SH KEYWORDS
file, script
