# wind.mt - Wind River Systems common target configuration file fragment.
# 
# This file is included by all our target specific fragments and
# contains rules an definitions common to all our target
# configurations. If you cannot use 'include' because your 'make'
# is not gmake or is otherwise broken then you'll have to remove
# all the uses of 'include' and rename this file "wind.ms". Then
# configure gdb with --site=wind which causes it to be included
# automatically in the gdb Makefile.

#
# This is a bit of clever trickery to allow the user to build a gdb
# that doesn't include all the backends.  By default on WTX and RDB
# are included. To change this comment/uncomment the appropriate 
# BUILD_<backend> line in the block below:

BUILD_VXMON=	NO
#BUILD_VXMON=	VXM

BUILD_RDB=	RDB
#BUILD_RDB=	NO

BUILD_WTX=	WTX
#BUILD_WTX=	NO

# Note: REMOTE_VX_SUFFIX must be defined in the .mt file that includes
# this file. These are files are named vxworks$(REMOTE_VX_SUFFIX).mt

TARGET_VXMON_OBJS=	remote-vxm.o remote-vxm$(REMOTE_VX_SUFFIX).o
TARGET_RDB_OBJS=	remote-vx.o remote-vx$(REMOTE_VX_SUFFIX).o \
			  xdr_ld.o xdr_ptrace.o xdr_rdb.o
TARGET_WTX_OBJS=	remote-wtx.o
TARGET_NO_OBJS= 

# If this use of macros in macro names may cause your 'make' some
# grief then you'll have to edit the REMOTE_OBS definition by hand.

REMOTE_OBS=	$(TARGET_$(BUILD_VXMON)_OBJS) \
		  $(TARGET_$(BUILD_RDB)_OBJS) \
		  $(TARGET_$(BUILD_WTX)_OBJS)

#
# Configuration to get correct libraries and includes
#

WIND_INC=	$(WIND_BASE)/host/include

ifeq ($(WIND_HOST_TYPE),x86-win32)
   WPWR_LIB=	$(WIND_BASE)/host/$(WIND_HOST_TYPE)/lib/libwpwr.lib
   WTX_TCL_LIB=	$(WIND_BASE)/host/$(WIND_HOST_TYPE)/lib/wtxapidll.lib \
		$(WIND_BASE)/host/$(WIND_HOST_TYPE)/lib/wtxtcldll.lib

   TCL_LIB=	$(WIND_BASE)/host/$(WIND_HOST_TYPE)/lib/tcldll.lib
   TCL_DIR=	$(WIND_BASE)/host/src/tcl/tcl/generic
else
   WPWR_LIB=	$(WIND_BASE)/host/$(WIND_HOST_TYPE)/lib/libwpwr.a
   WTX_TCL_LIB=	$(WIND_BASE)/host/$(WIND_HOST_TYPE)/lib/libwtxtcl.a

   TCL_LIB=	$(WIND_BASE)/host/$(WIND_HOST_TYPE)/lib/libtcl.a
   TCL_DIR=	$(WIND_BASE)/host/src/tcl/tcl/generic
endif

#
# Now define the macros used by the main gdb makefile
#

# Extra libs that go into the gdb link line
#

ifeq ($(WIND_HOST_TYPE),parisc-hpux9)
    TM_CLIBS=	$(WTX_TCL_LIB) $(WPWR_LIB) $(TCL_LIB) -lm /usr/lib/libdld.sl
endif

ifeq ($(WIND_HOST_TYPE),sun4-solaris2)
    TM_CLIBS=	$(WTX_TCL_LIB) $(WPWR_LIB) $(TCL_LIB) -lm -ldl 
endif

ifeq ($(WIND_HOST_TYPE),sun4-sunos4)
    TM_CLIBS=	$(WTX_TCL_LIB) $(WPWR_LIB) $(TCL_LIB) -lm
endif

ifeq ($(WIND_HOST_TYPE),rs6000-aix4)
    TM_CLIBS=	$(WTX_TCL_LIB) $(WPWR_LIB) $(TCL_LIB) -lm -lld
endif

ifeq ($(WIND_HOST_TYPE),x86-win32)
    TM_CLIBS=	$(WTX_TCL_LIB) $(TCL_LIB) -lwsock32
endif

# Extra flags for compiling this targets C files
#
MT_CFLAGS=	-I$(WIND_INC) -I$(TCL_DIR) -DHOST

# Extra libraries for gdb to depend on, see gdb rule in Makefile
#
TM_CDEPS=	$(WPWR_LIB) $(WTX_TCL_LIB) $(TCL_LIB)

# Define a macro so anyone not building a WRS target won't get burned
# when building because the don't have these Wind River files
#
REMOTE_WTX_DEPS=$(WIND_INC)/wtx.h $(WIND_INC)/a_out.h \
	$(WIND_INC)/wtxtcl.h $(TCL_DIR)/tcl.h $(defs_h) $(inferior_h) \
	$(gdbcore_h) $(gdbcmd_h) gdbthread.h

