/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion.fileProcessors;

import java.io.File;
import java.util.HashSet;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.config.exclusion.MatcherSet;
import org.apache.rat.config.exclusion.fileProcessors.AbstractFileProcessorBuilder;
import org.apache.rat.document.DocumentName;
import org.apache.rat.utils.ExtendedIterator;

public class CVSIgnoreBuilder
extends AbstractFileProcessorBuilder {
    public CVSIgnoreBuilder() {
        super(".cvsignore", (String)null, true);
    }

    @Override
    protected MatcherSet process(Consumer<MatcherSet> matcherSetConsumer, DocumentName root, DocumentName documentName) {
        File dir = new File(documentName.getName());
        HashSet<String> result = new HashSet<String>();
        ExtendedIterator<String> iter = ExclusionUtils.asIterator(dir, StringUtils::isNotBlank);
        while (iter.hasNext()) {
            String[] parts;
            String line = (String)iter.next();
            for (String part : parts = line.split("\\s+")) {
                if (part.isEmpty()) continue;
                result.add(ExclusionUtils.qualifyPattern(documentName, part));
            }
        }
        return new MatcherSet.Builder().addExcluded(documentName, result).build();
    }
}

