/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.compile;

import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.shared.common.error.StandardException;

public abstract class OptimizerPlan {
    public static RowSource makeRowSource(UniqueTupleDescriptor utd, DataDictionary dd) throws StandardException {
        if (utd == null) {
            return null;
        }
        if (utd instanceof ConglomerateDescriptor) {
            return new ConglomerateRS((ConglomerateDescriptor)utd, dd);
        }
        if (utd instanceof AliasDescriptor) {
            return new TableFunctionRS((AliasDescriptor)utd);
        }
        return null;
    }

    public abstract void bind(DataDictionary var1, LanguageConnectionContext var2, CompilerContext var3) throws StandardException;

    public abstract boolean isBound();

    public abstract int countLeafNodes();

    public abstract OptimizerPlan leftmostLeaf();

    public abstract boolean isLeftPrefixOf(OptimizerPlan var1);

    public static final class TableFunctionRS
    extends RowSource<AliasDescriptor> {
        public TableFunctionRS(String schemaName, String rowSourceName) {
            super(schemaName, rowSourceName);
        }

        public TableFunctionRS(AliasDescriptor ad) {
            this._descriptor = ad;
            this._schemaName = ad.getSchemaName();
            this._rowSourceName = ad.getName();
        }

        @Override
        public void bind(DataDictionary dataDictionary, LanguageConnectionContext lcc, CompilerContext cc) throws StandardException {
            super.bind(dataDictionary, lcc, cc);
            if (this._descriptor == null) {
                this._descriptor = dataDictionary.getAliasDescriptor(this._schema.getUUID().toString(), this._rowSourceName, 'F');
            }
            if (this._descriptor == null) {
                throw StandardException.newException("42X94", AliasDescriptor.getAliasType('F'), this._schemaName + "." + this._rowSourceName);
            }
        }

        @Override
        public String toString() {
            return super.toString() + "()";
        }
    }

    public static final class ConglomerateRS
    extends RowSource<ConglomerateDescriptor> {
        public ConglomerateRS(String schemaName, String rowSourceName) {
            super(schemaName, rowSourceName);
        }

        public ConglomerateRS(ConglomerateDescriptor cd, DataDictionary dataDictionary) throws StandardException {
            this._descriptor = cd;
            this._schema = dataDictionary.getSchemaDescriptor(cd.getSchemaID(), null);
            this._schemaName = this._schema.getSchemaName();
            this._rowSourceName = cd.getConglomerateName();
        }

        @Override
        public void bind(DataDictionary dataDictionary, LanguageConnectionContext lcc, CompilerContext cc) throws StandardException {
            super.bind(dataDictionary, lcc, cc);
            if (this._descriptor == null) {
                this._descriptor = dataDictionary.getConglomerateDescriptor(this._rowSourceName, this._schema, false);
            }
            if (this._descriptor == null) {
                throw StandardException.newException("42X65", this._schemaName + "." + this._rowSourceName);
            }
        }
    }

    public static abstract class RowSource<D extends UniqueTupleDescriptor>
    extends OptimizerPlan {
        protected String _schemaName;
        protected String _rowSourceName;
        protected SchemaDescriptor _schema;
        protected D _descriptor;

        public RowSource(String schemaName, String rowSourceName) {
            this._schemaName = schemaName;
            this._rowSourceName = rowSourceName;
        }

        protected RowSource() {
        }

        public D getDescriptor() {
            return this._descriptor;
        }

        @Override
        public void bind(DataDictionary dataDictionary, LanguageConnectionContext lcc, CompilerContext cc) throws StandardException {
            if (this._schema == null) {
                this._schema = StatementUtil.getSchemaDescriptor(this._schemaName, true, dataDictionary, lcc, cc);
                this._schemaName = this._schema.getSchemaName();
            }
        }

        @Override
        public boolean isBound() {
            return this._descriptor != null;
        }

        @Override
        public int countLeafNodes() {
            return 1;
        }

        @Override
        public OptimizerPlan leftmostLeaf() {
            return this;
        }

        @Override
        public boolean isLeftPrefixOf(OptimizerPlan that) {
            return this.equals(that.leftmostLeaf());
        }

        public String toString() {
            return IdUtil.mkQualifiedName(this._schemaName, this._rowSourceName);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            RowSource that = (RowSource)other;
            if (!this.isBound() || !that.isBound()) {
                return false;
            }
            return this._schemaName.equals(that._schemaName) && this._rowSourceName.equals(that._rowSourceName);
        }
    }

    public static class DeadEnd
    extends OptimizerPlan {
        private String _name;

        public DeadEnd(String name) {
            this._name = name;
        }

        @Override
        public void bind(DataDictionary dataDictionary, LanguageConnectionContext lcc, CompilerContext cc) throws StandardException {
        }

        @Override
        public boolean isBound() {
            return true;
        }

        @Override
        public int countLeafNodes() {
            return 1;
        }

        @Override
        public OptimizerPlan leftmostLeaf() {
            return this;
        }

        @Override
        public boolean isLeftPrefixOf(OptimizerPlan that) {
            return this.equals(that.leftmostLeaf());
        }

        public String toString() {
            return this._name;
        }
    }

    public static final class Join
    extends OptimizerPlan {
        final JoinStrategy strategy;
        final OptimizerPlan leftChild;
        final OptimizerPlan rightChild;
        private boolean _isBound;
        private int _leafNodeCount = 0;

        public Join(JoinStrategy strategy, OptimizerPlan leftChild, OptimizerPlan rightChild) {
            this.strategy = strategy;
            this.leftChild = leftChild;
            this.rightChild = rightChild;
        }

        @Override
        public void bind(DataDictionary dataDictionary, LanguageConnectionContext lcc, CompilerContext cc) throws StandardException {
            if (!(this.rightChild instanceof RowSource)) {
                throw StandardException.newException("42ZCD", new Object[0]);
            }
            this.leftChild.bind(dataDictionary, lcc, cc);
            this.rightChild.bind(dataDictionary, lcc, cc);
            this._isBound = true;
        }

        @Override
        public boolean isBound() {
            return this._isBound;
        }

        @Override
        public int countLeafNodes() {
            if (this._leafNodeCount <= 0) {
                this._leafNodeCount = this.leftChild.countLeafNodes() + this.rightChild.countLeafNodes();
            }
            return this._leafNodeCount;
        }

        @Override
        public OptimizerPlan leftmostLeaf() {
            return this.leftChild.leftmostLeaf();
        }

        @Override
        public boolean isLeftPrefixOf(OptimizerPlan other) {
            int thatLeafCount;
            if (!(other instanceof Join)) {
                return false;
            }
            Join that = (Join)other;
            int thisLeafCount = this.countLeafNodes();
            if (thisLeafCount > (thatLeafCount = that.countLeafNodes())) {
                return false;
            }
            if (thisLeafCount < thatLeafCount) {
                return this.isLeftPrefixOf(that.leftChild);
            }
            return this.equals(that);
        }

        public String toString() {
            return "( " + this.leftChild.toString() + " " + this.strategy.getOperatorSymbol() + " " + this.rightChild.toString() + " )";
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Join)) {
                return false;
            }
            Join that = (Join)other;
            if (!this.strategy.getOperatorSymbol().equals(that.strategy.getOperatorSymbol())) {
                return false;
            }
            return this.leftChild.equals(that.leftChild) && this.rightChild.equals(that.rightChild);
        }
    }
}

