/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

class HasCorrelatedCRsVisitor
implements Visitor {
    private boolean hasCorrelatedCRs;

    HasCorrelatedCRsVisitor() {
    }

    @Override
    public Visitable visit(Visitable node) {
        if (node instanceof ColumnReference) {
            if (((ColumnReference)node).getCorrelated()) {
                this.hasCorrelatedCRs = true;
            }
        } else if (node instanceof VirtualColumnNode) {
            if (((VirtualColumnNode)node).getCorrelated()) {
                this.hasCorrelatedCRs = true;
            }
        } else if (node instanceof MethodCallNode && (((MethodCallNode)node).getMethodName().equals("getTriggerExecutionContext") || ((MethodCallNode)node).getMethodName().equals("TriggerOldTransitionRows") || ((MethodCallNode)node).getMethodName().equals("TriggerNewTransitionRows"))) {
            this.hasCorrelatedCRs = true;
        }
        return node;
    }

    @Override
    public boolean stopTraversal() {
        return this.hasCorrelatedCRs;
    }

    @Override
    public boolean skipChildren(Visitable v) {
        return false;
    }

    @Override
    public boolean visitChildrenFirst(Visitable v) {
        return false;
    }

    boolean hasCorrelatedCRs() {
        return this.hasCorrelatedCRs;
    }

    void setHasCorrelatedCRs(boolean value) {
        this.hasCorrelatedCRs = value;
    }
}

