/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LockTableTest
extends BaseJDBCTestCase {
    public LockTableTest(String name) {
        super(name);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.storage.rowLocking", "false");
        properties.setProperty("derby.locks.waitTimeout", "7");
        properties.setProperty("derby.locks.deadlockTimeout", "5");
        Object suite = TestConfiguration.embeddedSuite(LockTableTest.class);
        suite = new DatabasePropertyTestSetup((Test)suite, properties, true);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                Connection conn = this.getConnection();
                conn.setAutoCommit(false);
                s.executeUpdate("create schema u1");
                s.executeUpdate("create schema u2");
                conn.commit();
            }
        };
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        try (Statement s = this.createStatement();){
            s = this.createStatement();
            s.executeUpdate("drop table u1.t1");
            s.executeUpdate("drop schema u1 restrict");
            s.executeUpdate("drop schema u2 restrict");
        }
        super.tearDown();
    }

    private Connection setConnection(String userString) throws SQLException {
        Connection c1 = this.openUserConnection(userString);
        c1.setAutoCommit(false);
        return c1;
    }

    private void setupTable(Statement s) throws SQLException {
        s.executeUpdate("create table t1(c1 int)");
        s.executeUpdate("insert into t1 values 1");
    }

    public static String getSelectLocksString() {
        String sql = "select cast(username as char(8)) as username, cast(t.type as char(15)) as trantype, cast(l.type as char(8)) as type, cast(lockcount as char(3)) as cnt, mode, cast(tablename as char(12)) as tabname, cast(lockname as char(10)) as lockname, state, status from syscs_diag.lock_table l right outer join syscs_diag.transaction_table t on l.xid = t.xid where l.tableType <> 'S' order by tabname, type desc, mode, cnt, lockname";
        return sql;
    }

    public void testSystemTable() throws SQLException {
        Statement s = this.createStatement();
        LockTableTest.assertStatementError("42X62", s, "lock table sys.systables in share mode");
        s.close();
    }

    public void testTXvsTXLocks() throws SQLException {
        Connection c1 = this.setConnection("U1");
        Statement s1 = c1.createStatement();
        Connection c2 = this.setConnection("U2");
        Statement s2 = c2.createStatement();
        this.setupTable(s1);
        c1.commit();
        s1.executeUpdate("lock table u1.t1 in exclusive mode");
        LockTableTest.assertStatementError(new String[]{"X0X02", "40XL1"}, s2, "lock table u1.t1 in exclusive mode");
        ResultSet rs = s1.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(rs, new String[][]{{"U1", "UserTransaction", "TABLE", "1", "X", "T1", "Tablelock", "GRANT", "ACTIVE"}});
        s1.executeUpdate("insert into t1 values 2");
        rs = s1.executeQuery("select count(*) from t1");
        JDBC.assertSingleValueResultSet(rs, "2");
        LockTableTest.assertStatementError("40XL1", s2, "insert into u1.t1 values 9");
        rs = s1.executeQuery("select count(*) from t1");
        JDBC.assertSingleValueResultSet(rs, "2");
        rs = s1.executeQuery("select count(*) from u1.t1");
        JDBC.assertSingleValueResultSet(rs, "2");
        rs.close();
        c1.commit();
        s1.executeUpdate("drop table U1.t1");
        c1.commit();
        s1.close();
        s2.close();
        c1.close();
        c2.rollback();
        c2.close();
    }

    public void testTXvsTSLocks() throws SQLException {
        Connection c1 = this.setConnection("U1");
        Statement s1 = c1.createStatement();
        Connection c2 = this.setConnection("U2");
        Statement s2 = c2.createStatement();
        this.setupTable(s1);
        c1.commit();
        s1.executeUpdate("lock table t1 in exclusive mode");
        LockTableTest.assertStatementError(new String[]{"X0X02", "40XL1"}, s2, "lock table u1.t1 in share mode");
        ResultSet rs = s1.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(rs, new String[][]{{"U1", "UserTransaction", "TABLE", "1", "X", "T1", "Tablelock", "GRANT", "ACTIVE"}});
        s1.executeUpdate("insert into t1 values 3");
        rs = s1.executeQuery("select count(*) from t1");
        JDBC.assertSingleValueResultSet(rs, "2");
        s1.executeUpdate("drop table U1.t1");
        c1.commit();
        s1.close();
        s2.close();
        c1.close();
        c2.rollback();
        c2.close();
    }

    public void testTSvsTXLocks() throws SQLException {
        Connection c1 = this.setConnection("U1");
        Statement s1 = c1.createStatement();
        Connection c2 = this.setConnection("U2");
        Statement s2 = c2.createStatement();
        this.setupTable(s1);
        c1.commit();
        s1.executeUpdate("lock table t1 in share mode");
        LockTableTest.assertStatementError(new String[]{"X0X02", "40XL1"}, s2, "lock table u1.t1 in exclusive mode");
        ResultSet rs = s1.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(rs, new String[][]{{"U1", "UserTransaction", "TABLE", "1", "S", "T1", "Tablelock", "GRANT", "ACTIVE"}});
        s1.executeUpdate("insert into t1 values 4");
        rs = s1.executeQuery("select count(*) from t1");
        JDBC.assertSingleValueResultSet(rs, "2");
        s1.executeUpdate("drop table U1.t1");
        c1.commit();
        s1.close();
        s2.close();
        c1.close();
        c2.rollback();
        c2.close();
    }

    public void testTSvsTSLocks() throws SQLException {
        Connection c1 = this.setConnection("U1");
        Statement s1 = c1.createStatement();
        Connection c2 = this.setConnection("U2");
        Statement s2 = c2.createStatement();
        this.setupTable(s1);
        c1.commit();
        s1.executeUpdate("lock table t1 in share mode");
        LockTableTest.assertUpdateCount(s2, 0, "lock table u1.t1 in share mode");
        ResultSet rs = s1.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(rs, new String[][]{{"U2", "UserTransaction", "TABLE", "1", "S", "T1", "Tablelock", "GRANT", "ACTIVE"}, {"U1", "UserTransaction", "TABLE", "1", "S", "T1", "Tablelock", "GRANT", "ACTIVE"}});
        LockTableTest.assertStatementError("40XL1", s1, "insert into t1 values 5");
        rs = s1.executeQuery("select count(*) from t1");
        JDBC.assertSingleValueResultSet(rs, "1");
        c2.rollback();
        c1.rollback();
        s1.executeUpdate("drop table U1.t1");
        c1.commit();
        s1.close();
        s2.close();
        c1.close();
        c2.close();
    }

    public void testWithRolledBack() throws SQLException {
        Connection c1 = this.setConnection("U1");
        Statement s1 = c1.createStatement();
        Connection c2 = this.setConnection("U2");
        Statement s2 = c2.createStatement();
        this.setupTable(s1);
        c1.commit();
        s1.executeUpdate("create table t2(c1 int)");
        c1.commit();
        s1.executeUpdate("lock table t1 in share mode");
        s2.executeUpdate("lock table u1.t2 in share mode");
        LockTableTest.assertStatementError(new String[]{"X0X02", "40XL1"}, s2, "lock table u1.t1 in exclusive mode");
        ResultSet rs = s1.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(rs, new String[][]{{"U1", "UserTransaction", "TABLE", "1", "S", "T1", "Tablelock", "GRANT", "ACTIVE"}, {"U2", "UserTransaction", "TABLE", "1", "S", "T2", "Tablelock", "GRANT", "ACTIVE"}});
        c2.rollback();
        c1.rollback();
        s1.executeUpdate("drop table U1.t2");
        s1.executeUpdate("drop table U1.t1");
        c1.commit();
        s1.close();
        s2.close();
        c1.close();
        c2.close();
    }
}

