/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.AbstractBasicBuilder;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.StandardHttpHeaders;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StandardHttpRequest
extends StandardHttpHeaders
implements HttpRequest {
    public static final String METHOD_POST = "POST";
    private final URI uri;
    private final String method;
    private final String bodyString;
    private final InputStream bodyStream;

    public StandardHttpRequest(Map<String, List<String>> headers, URI uri, String method, String bodyString, InputStream bodyStream) {
        super(headers);
        this.uri = uri;
        this.method = method;
        this.bodyString = bodyString;
        this.bodyStream = bodyStream;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String bodyString() {
        return this.bodyString;
    }

    public InputStream bodyStream() {
        return this.bodyStream;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends AbstractBasicBuilder<Builder>
    implements HttpRequest.Builder {
        private String method = "GET";
        private InputStream bodyAsStream;
        private String bodyAsString;

        public Builder() {
        }

        public Builder(StandardHttpRequest original) {
            super.uri(original.uri());
            super.setHeaders(original.headers());
            this.method = original.method;
            this.bodyAsString = original.bodyString;
            this.bodyAsStream = original.bodyStream;
        }

        @Override
        public StandardHttpRequest build() {
            return new StandardHttpRequest(this.getHeaders(), Objects.requireNonNull(this.getUri()), this.method, this.bodyAsString, this.bodyAsStream);
        }

        @Override
        public HttpRequest.Builder uri(String uri) {
            return (HttpRequest.Builder)super.uri(URI.create(uri));
        }

        @Override
        public HttpRequest.Builder url(URL url) {
            try {
                return (HttpRequest.Builder)super.uri(url.toURI());
            }
            catch (URISyntaxException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public HttpRequest.Builder post(String contentType, byte[] writeValueAsBytes) {
            return this.post(contentType, new ByteArrayInputStream(writeValueAsBytes), writeValueAsBytes.length);
        }

        @Override
        public HttpRequest.Builder post(String contentType, InputStream stream, long length) {
            if (length >= 0L) {
                this.header("Content-Length", Long.toString(length));
            }
            this.method = StandardHttpRequest.METHOD_POST;
            this.contentType(contentType);
            this.bodyAsStream = stream;
            return this;
        }

        @Override
        public HttpRequest.Builder method(String method, String contentType, String body) {
            this.method = method;
            this.contentType(contentType);
            this.bodyAsString = body;
            return this;
        }

        private void contentType(String contentType) {
            if (contentType != null) {
                this.setHeader("Content-Type", contentType);
            }
        }

        @Override
        public HttpRequest.Builder expectContinue() {
            this.setHeader("Expect", "100-Continue");
            return this;
        }
    }
}

