/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.registry;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.config.WorkerServerLoadProtection;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskExecutorContainerProvider;
import org.apache.dolphinscheduler.server.worker.registry.WorkerConnectionStateListener;
import org.apache.dolphinscheduler.server.worker.task.WorkerHeartBeatTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkerRegistryClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerRegistryClient.class);
    @Autowired
    private WorkerConfig workerConfig;
    @Autowired
    private WorkerServerLoadProtection workerServerLoadProtection;
    @Autowired
    private PhysicalTaskExecutorContainerProvider physicalTaskExecutorContainerDelegator;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private MetricsProvider metricsProvider;
    private WorkerHeartBeatTask workerHeartBeatTask;

    @PostConstruct
    public void initWorkRegistry() {
        this.workerHeartBeatTask = new WorkerHeartBeatTask(this.workerConfig, this.workerServerLoadProtection, this.metricsProvider, this.registryClient, this.physicalTaskExecutorContainerDelegator.getExecutorContainer());
    }

    public void start() {
        try {
            this.registry();
            this.registryClient.addConnectionStateListener((ConnectionListener)new WorkerConnectionStateListener(this.registryClient));
        }
        catch (Exception ex) {
            throw new RegistryException("Worker registry client start up error", (Throwable)ex);
        }
    }

    private void registry() {
        String workerRegistryPath = this.workerConfig.getWorkerRegistryPath();
        this.registryClient.remove(workerRegistryPath);
        this.registryClient.persistEphemeral(workerRegistryPath, JSONUtils.toJsonString((Object)this.workerHeartBeatTask.getHeartBeat()));
        log.info("Worker node: {} registry to registry center {} successfully", (Object)this.workerConfig.getWorkerAddress(), (Object)workerRegistryPath);
        while (!this.registryClient.checkNodeExists(this.workerConfig.getWorkerAddress(), RegistryNodeType.WORKER)) {
            ThreadUtils.sleep((long)1000L);
        }
        this.workerHeartBeatTask.start();
        log.info("Worker node: {} registry finished", (Object)this.workerConfig.getWorkerAddress());
    }

    public Optional<Host> getAlertServerAddress() {
        List serverList = this.registryClient.getServerList(RegistryNodeType.ALERT_SERVER);
        if (CollectionUtils.isEmpty((Collection)serverList)) {
            return Optional.empty();
        }
        Server server = (Server)serverList.get(0);
        return Optional.of(new Host(server.getHost(), server.getPort()));
    }

    public void setRegistryStoppable(IStoppable stoppable) {
        this.registryClient.setStoppable(stoppable);
    }

    @Override
    public void close() throws IOException {
        if (this.workerHeartBeatTask != null) {
            this.workerHeartBeatTask.shutdown();
        }
        this.registryClient.close();
        log.info("Closed WorkerRegistryClient");
    }

    public boolean isAvailable() {
        return this.registryClient.isConnected();
    }
}

