/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.FileSystemDataSource;
import com.amazonaws.services.sagemaker.model.S3DataSource;
import com.amazonaws.services.sagemaker.model.transform.DataSourceMarshaller;
import java.io.Serializable;

public class DataSource
implements Serializable,
Cloneable,
StructuredPojo {
    private S3DataSource s3DataSource;
    private FileSystemDataSource fileSystemDataSource;

    public void setS3DataSource(S3DataSource s3DataSource) {
        this.s3DataSource = s3DataSource;
    }

    public S3DataSource getS3DataSource() {
        return this.s3DataSource;
    }

    public DataSource withS3DataSource(S3DataSource s3DataSource) {
        this.setS3DataSource(s3DataSource);
        return this;
    }

    public void setFileSystemDataSource(FileSystemDataSource fileSystemDataSource) {
        this.fileSystemDataSource = fileSystemDataSource;
    }

    public FileSystemDataSource getFileSystemDataSource() {
        return this.fileSystemDataSource;
    }

    public DataSource withFileSystemDataSource(FileSystemDataSource fileSystemDataSource) {
        this.setFileSystemDataSource(fileSystemDataSource);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3DataSource() != null) {
            sb.append("S3DataSource: ").append(this.getS3DataSource()).append(",");
        }
        if (this.getFileSystemDataSource() != null) {
            sb.append("FileSystemDataSource: ").append(this.getFileSystemDataSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        if (other.getS3DataSource() == null ^ this.getS3DataSource() == null) {
            return false;
        }
        if (other.getS3DataSource() != null && !other.getS3DataSource().equals(this.getS3DataSource())) {
            return false;
        }
        if (other.getFileSystemDataSource() == null ^ this.getFileSystemDataSource() == null) {
            return false;
        }
        return other.getFileSystemDataSource() == null || other.getFileSystemDataSource().equals(this.getFileSystemDataSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3DataSource() == null ? 0 : this.getS3DataSource().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemDataSource() == null ? 0 : this.getFileSystemDataSource().hashCode());
        return hashCode;
    }

    public DataSource clone() {
        try {
            return (DataSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

