/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.PrivateEndpoint;
import com.azure.resourcemanager.compute.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.compute.models.PrivateLinkServiceConnectionState;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class PrivateEndpointConnectionProperties {
    @JsonProperty(value="privateEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private PrivateEndpoint privateEndpoint;
    @JsonProperty(value="privateLinkServiceConnectionState", required=true)
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private PrivateEndpointConnectionProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndpointConnectionProperties.class);

    public PrivateEndpoint privateEndpoint() {
        return this.privateEndpoint;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateEndpointConnectionProperties withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property privateLinkServiceConnectionState in model PrivateEndpointConnectionProperties"));
        }
        this.privateLinkServiceConnectionState().validate();
    }
}

