/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.registry.api.ha;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.registry.api.Event;
import org.apache.dolphinscheduler.registry.api.Registry;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.dolphinscheduler.registry.api.ha.DefaultServerStatusChangeListener;
import org.apache.dolphinscheduler.registry.api.ha.HAServer;
import org.apache.dolphinscheduler.registry.api.ha.ServerStatusChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHAServer
implements HAServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHAServer.class);
    private final Registry registry;
    private final String selectorPath;
    private final String serverIdentify;
    private HAServer.ServerStatus serverStatus;
    private final List<ServerStatusChangeListener> serverStatusChangeListeners;
    private static final long DEFAULT_RETRY_INTERVAL = 5000L;
    private static final int DEFAULT_MAX_RETRY_TIMES = 20;

    public AbstractHAServer(Registry registry, String selectorPath, String serverIdentify) {
        this.registry = registry;
        this.selectorPath = (String)Preconditions.checkNotNull((Object)selectorPath);
        this.serverIdentify = (String)Preconditions.checkNotNull((Object)serverIdentify);
        this.serverStatus = HAServer.ServerStatus.STAND_BY;
        this.serverStatusChangeListeners = Lists.newArrayList((Object[])new ServerStatusChangeListener[]{new DefaultServerStatusChangeListener()});
    }

    @Override
    public void start() {
        this.registry.subscribe(this.selectorPath, new SubscribeListener(){

            @Override
            public void notify(Event event) {
                if (Event.Type.REMOVE.equals((Object)event.getType())) {
                    if (AbstractHAServer.this.serverIdentify.equals(event.getEventData())) {
                        AbstractHAServer.this.statusChange(HAServer.ServerStatus.STAND_BY);
                    } else if (AbstractHAServer.this.participateElection()) {
                        AbstractHAServer.this.statusChange(HAServer.ServerStatus.ACTIVE);
                    }
                }
            }

            @Override
            public SubscribeListener.SubscribeScope getSubscribeScope() {
                return SubscribeListener.SubscribeScope.PATH_ONLY;
            }
        });
        if (this.participateElection()) {
            this.statusChange(HAServer.ServerStatus.ACTIVE);
        } else {
            log.info("Server {} is standby", (Object)this.serverIdentify);
        }
    }

    @Override
    public boolean isActive() {
        return HAServer.ServerStatus.ACTIVE.equals((Object)this.getServerStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean participateElection() {
        String electionLock = this.selectorPath + "-lock";
        int i = 0;
        while (i < 20) {
            try {
                try {
                    if (this.registry.acquireLock(electionLock)) {
                        if (!this.registry.exists(this.selectorPath)) {
                            this.registry.put(this.selectorPath, this.serverIdentify, true);
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = this.serverIdentify.equals(this.registry.get(this.selectorPath));
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.registry.releaseLock(electionLock);
                }
            }
            catch (Exception e) {
                log.error("Participate election error, meet an exception, will retry after {}ms", (Object)5000L, (Object)e);
                ThreadUtils.sleep((long)5000L);
                ++i;
            }
        }
        throw new IllegalStateException("Participate election failed after retry 20 times");
    }

    @Override
    public void addServerStatusChangeListener(ServerStatusChangeListener listener) {
        this.serverStatusChangeListeners.add(listener);
    }

    @Override
    public HAServer.ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statusChange(HAServer.ServerStatus targetStatus) {
        HAServer.ServerStatus originStatus = this.serverStatus;
        this.serverStatus = targetStatus;
        AbstractHAServer abstractHAServer = this;
        synchronized (abstractHAServer) {
            try {
                this.serverStatusChangeListeners.forEach(listener -> listener.change(originStatus, this.serverStatus));
            }
            catch (Exception ex) {
                log.error("Trigger ServerStatusChangeListener from {} -> {} error", new Object[]{originStatus, targetStatus, ex});
            }
        }
    }
}

