/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.cihandler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class CharacterFilter
extends Reader {
    private final BufferedReader reader;

    public CharacterFilter(BufferedReader reader) {
        this.reader = reader;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int numChars = this.reader.read(cbuf, off, len);
        if (numChars == -1) {
            return -1;
        }
        for (int i = off; i < off + numChars; ++i) {
            int c = cbuf[i];
            cbuf[i] = CharacterFilter.isValidXMLCharacter((char)c) ? c : 32;
        }
        return numChars;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static boolean isValidXMLCharacter(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
    }
}

