/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.resourcemanager.monitor.MonitorManager;
import com.azure.resourcemanager.monitor.fluent.models.MetricAlertResourceInner;
import com.azure.resourcemanager.monitor.models.MetricAlertCondition;
import com.azure.resourcemanager.monitor.models.MetricDynamicAlertCondition;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Map;

public interface MetricAlert
extends GroupableResource<MonitorManager, MetricAlertResourceInner>,
Refreshable<MetricAlert>,
Updatable<Update> {
    public String description();

    public int severity();

    public boolean enabled();

    public Collection<String> scopes();

    public Duration evaluationFrequency();

    public Duration windowSize();

    public Map<String, MetricAlertCondition> alertCriterias();

    public Map<String, MetricDynamicAlertCondition> dynamicAlertCriterias();

    public boolean autoMitigate();

    public Collection<String> actionGroupIds();

    public OffsetDateTime lastUpdatedTime();

    public static interface Update
    extends Appliable<MetricAlert>,
    UpdateStages.WithMetricUpdate,
    Resource.UpdateWithTags<Update> {
    }

    public static interface UpdateStages {

        public static interface WithMetricUpdate {
            public Update withPeriod(Duration var1);

            public Update withFrequency(Duration var1);

            public Update withSeverity(int var1);

            public Update withDescription(String var1);

            public Update withRuleEnabled();

            public Update withRuleDisabled();

            public Update withActionGroups(String ... var1);

            public Update withoutActionGroup(String var1);

            public MetricAlertCondition.UpdateDefinitionStages.Blank.MetricName<Update> defineAlertCriteria(String var1);

            public MetricDynamicAlertCondition.UpdateDefinitionStages.Blank.MetricName<Update> defineDynamicAlertCriteria(String var1);

            public MetricAlertCondition.UpdateStages updateAlertCriteria(String var1);

            public MetricDynamicAlertCondition.UpdateStages updateDynamicAlertCriteria(String var1);

            public Update withoutAlertCriteria(String var1);

            public Update withAutoMitigation();

            public Update withoutAutoMitigation();
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreateDynamicCondition
        extends Creatable<MetricAlert>,
        Resource.DefinitionWithTags<WithCreate> {
            public WithCreate withoutAutoMitigation();

            public WithActionGroup withRuleDisabled();
        }

        public static interface WithCreate
        extends Creatable<MetricAlert>,
        Resource.DefinitionWithTags<WithCreate>,
        WithCriteriaDefinition {
            public WithCreate withoutAutoMitigation();

            public WithActionGroup withRuleDisabled();
        }

        public static interface WithCriteriaDefinitionMultipleResource {
            public MetricAlertCondition.DefinitionStages.Blank.MetricName<WithCreate> defineAlertCriteria(String var1);

            public MetricDynamicAlertCondition.DefinitionStages.Blank.MetricName<WithCreate> defineDynamicAlertCriteria(String var1);
        }

        public static interface WithActionGroupMultipleResource {
            public WithCriteriaDefinitionMultipleResource withActionGroups(String ... var1);
        }

        public static interface WithSeverityMultipleResource {
            public WithActionGroupMultipleResource withAlertDetails(int var1, String var2);
        }

        public static interface WithEvaluationFrequencyMultipleResource {
            public WithSeverityMultipleResource withFrequency(Duration var1);
        }

        public static interface WithWindowSizeMultipleResource {
            public WithEvaluationFrequencyMultipleResource withPeriod(Duration var1);
        }

        public static interface WithCriteriaDefinition {
            public MetricAlertCondition.DefinitionStages.Blank.MetricName<WithCreate> defineAlertCriteria(String var1);
        }

        public static interface WithActionGroup {
            public WithCriteriaDefinition withActionGroups(String ... var1);
        }

        public static interface WithSeverity {
            public WithActionGroup withAlertDetails(int var1, String var2);
        }

        public static interface WithEvaluationFrequency {
            public WithSeverity withFrequency(Duration var1);
        }

        public static interface WithWindowSize {
            public WithEvaluationFrequency withPeriod(Duration var1);
        }

        public static interface WithScopes {
            public WithWindowSize withTargetResource(String var1);

            public WithWindowSize withTargetResource(HasId var1);

            public WithWindowSizeMultipleResource withMultipleTargetResources(Collection<String> var1, String var2, String var3);

            public WithWindowSizeMultipleResource withMultipleTargetResources(Collection<? extends Resource> var1);
        }

        public static interface Blank
        extends GroupableResource.DefinitionStages.WithGroupAndRegion<WithScopes> {
        }
    }

    public static interface DefinitionMultipleResource
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreateDynamicCondition,
    DefinitionStages.WithScopes,
    DefinitionStages.WithWindowSizeMultipleResource,
    DefinitionStages.WithEvaluationFrequencyMultipleResource,
    DefinitionStages.WithSeverityMultipleResource,
    DefinitionStages.WithActionGroupMultipleResource,
    DefinitionStages.WithCriteriaDefinitionMultipleResource {
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate,
    DefinitionStages.WithScopes,
    DefinitionStages.WithWindowSize,
    DefinitionStages.WithEvaluationFrequency,
    DefinitionStages.WithSeverity,
    DefinitionStages.WithActionGroup,
    DefinitionStages.WithCriteriaDefinition {
    }
}

