/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta1NonResourceRule;
import io.kubernetes.client.openapi.models.V1beta1ResourceRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SubjectRulesReviewStatus contains the result of a rules check. This check can be incomplete depending on the set of authorizers the server is configured with and any errors experienced during evaluation. Because authorization rules are additive, if a rule appears in a list it's safe to assume the subject has that permission, even if that list is incomplete.")
public class V1beta1SubjectRulesReviewStatus {
    public static final String SERIALIZED_NAME_EVALUATION_ERROR = "evaluationError";
    @SerializedName(value="evaluationError")
    private String evaluationError;
    public static final String SERIALIZED_NAME_INCOMPLETE = "incomplete";
    @SerializedName(value="incomplete")
    private Boolean incomplete;
    public static final String SERIALIZED_NAME_NON_RESOURCE_RULES = "nonResourceRules";
    @SerializedName(value="nonResourceRules")
    private List<V1beta1NonResourceRule> nonResourceRules = new ArrayList<V1beta1NonResourceRule>();
    public static final String SERIALIZED_NAME_RESOURCE_RULES = "resourceRules";
    @SerializedName(value="resourceRules")
    private List<V1beta1ResourceRule> resourceRules = new ArrayList<V1beta1ResourceRule>();

    public V1beta1SubjectRulesReviewStatus evaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EvaluationError can appear in combination with Rules. It indicates an error occurred during rule evaluation, such as an authorizer that doesn't support rule evaluation, and that ResourceRules and/or NonResourceRules may be incomplete.")
    public String getEvaluationError() {
        return this.evaluationError;
    }

    public void setEvaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
    }

    public V1beta1SubjectRulesReviewStatus incomplete(Boolean incomplete) {
        this.incomplete = incomplete;
        return this;
    }

    @ApiModelProperty(required=true, value="Incomplete is true when the rules returned by this call are incomplete. This is most commonly encountered when an authorizer, such as an external authorizer, doesn't support rules evaluation.")
    public Boolean getIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(Boolean incomplete) {
        this.incomplete = incomplete;
    }

    public V1beta1SubjectRulesReviewStatus nonResourceRules(List<V1beta1NonResourceRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
        return this;
    }

    public V1beta1SubjectRulesReviewStatus addNonResourceRulesItem(V1beta1NonResourceRule nonResourceRulesItem) {
        this.nonResourceRules.add(nonResourceRulesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="NonResourceRules is the list of actions the subject is allowed to perform on non-resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.")
    public List<V1beta1NonResourceRule> getNonResourceRules() {
        return this.nonResourceRules;
    }

    public void setNonResourceRules(List<V1beta1NonResourceRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
    }

    public V1beta1SubjectRulesReviewStatus resourceRules(List<V1beta1ResourceRule> resourceRules) {
        this.resourceRules = resourceRules;
        return this;
    }

    public V1beta1SubjectRulesReviewStatus addResourceRulesItem(V1beta1ResourceRule resourceRulesItem) {
        this.resourceRules.add(resourceRulesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="ResourceRules is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.")
    public List<V1beta1ResourceRule> getResourceRules() {
        return this.resourceRules;
    }

    public void setResourceRules(List<V1beta1ResourceRule> resourceRules) {
        this.resourceRules = resourceRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1SubjectRulesReviewStatus v1beta1SubjectRulesReviewStatus = (V1beta1SubjectRulesReviewStatus)o;
        return Objects.equals(this.evaluationError, v1beta1SubjectRulesReviewStatus.evaluationError) && Objects.equals(this.incomplete, v1beta1SubjectRulesReviewStatus.incomplete) && Objects.equals(this.nonResourceRules, v1beta1SubjectRulesReviewStatus.nonResourceRules) && Objects.equals(this.resourceRules, v1beta1SubjectRulesReviewStatus.resourceRules);
    }

    public int hashCode() {
        return Objects.hash(this.evaluationError, this.incomplete, this.nonResourceRules, this.resourceRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1SubjectRulesReviewStatus {\n");
        sb.append("    evaluationError: ").append(this.toIndentedString(this.evaluationError)).append("\n");
        sb.append("    incomplete: ").append(this.toIndentedString(this.incomplete)).append("\n");
        sb.append("    nonResourceRules: ").append(this.toIndentedString(this.nonResourceRules)).append("\n");
        sb.append("    resourceRules: ").append(this.toIndentedString(this.resourceRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

