/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.PrivateDnsZoneGroupsClient;
import com.azure.resourcemanager.network.fluent.models.PrivateDnsZoneGroupInner;
import com.azure.resourcemanager.network.implementation.PrivateDnsZoneGroupImpl;
import com.azure.resourcemanager.network.implementation.PrivateEndpointImpl;
import com.azure.resourcemanager.network.models.PrivateDnsZoneGroup;
import com.azure.resourcemanager.network.models.PrivateDnsZoneGroups;
import com.azure.resourcemanager.network.models.PrivateEndpoint;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.IndependentChildrenImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public class PrivateDnsZoneGroupsImpl
extends IndependentChildrenImpl<PrivateDnsZoneGroup, PrivateDnsZoneGroupImpl, PrivateDnsZoneGroupInner, PrivateDnsZoneGroupsClient, NetworkManager, PrivateEndpoint>
implements PrivateDnsZoneGroups {
    private final PrivateEndpointImpl parent;

    protected PrivateDnsZoneGroupsImpl(PrivateEndpointImpl parent) {
        super((Object)((NetworkManagementClient)((NetworkManager)parent.manager()).serviceClient()).getPrivateDnsZoneGroups(), (Manager)((NetworkManager)parent.manager()));
        this.parent = parent;
    }

    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        return ((PrivateDnsZoneGroupsClient)this.innerModel()).deleteAsync(groupName, parentName, name);
    }

    public Mono<PrivateDnsZoneGroup> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((PrivateDnsZoneGroupsClient)this.innerModel()).getAsync(resourceGroup, parentName, name).map(this::wrapModel);
    }

    public PagedIterable<PrivateDnsZoneGroup> listByParent(String resourceGroupName, String parentName) {
        return PagedConverter.mapPage(((PrivateDnsZoneGroupsClient)this.innerModel()).list(parentName, resourceGroupName), this::wrapModel);
    }

    protected PrivateDnsZoneGroupImpl wrapModel(String name) {
        return new PrivateDnsZoneGroupImpl(name, new PrivateDnsZoneGroupInner(), this.parent);
    }

    protected PrivateDnsZoneGroupImpl wrapModel(PrivateDnsZoneGroupInner innerModel) {
        return new PrivateDnsZoneGroupImpl(innerModel.name(), innerModel, this.parent);
    }

    public PrivateDnsZoneGroupImpl define(String name) {
        return this.wrapModel(name);
    }

    public PagedIterable<PrivateDnsZoneGroup> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<PrivateDnsZoneGroup> listAsync() {
        return PagedConverter.mapPage(((PrivateDnsZoneGroupsClient)this.innerModel()).listAsync(this.parent.name(), this.parent.resourceGroupName()), this::wrapModel);
    }
}

