/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.RoutingIntentsClient;
import com.azure.resourcemanager.network.fluent.models.RoutingIntentInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ListRoutingIntentResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class RoutingIntentsClientImpl
implements RoutingIntentsClient {
    private final RoutingIntentsService service;
    private final NetworkManagementClientImpl client;

    RoutingIntentsClientImpl(NetworkManagementClientImpl client) {
        this.service = (RoutingIntentsService)RestProxy.create(RoutingIntentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String virtualHubName, String routingIntentName, RoutingIntentInner routingIntentParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        if (routingIntentParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routingIntentParameters is required and cannot be null."));
        }
        routingIntentParameters.validate();
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routingIntentName, "2022-05-01", routingIntentParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String virtualHubName, String routingIntentName, RoutingIntentInner routingIntentParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        if (routingIntentParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routingIntentParameters is required and cannot be null."));
        }
        routingIntentParameters.validate();
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routingIntentName, "2022-05-01", routingIntentParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RoutingIntentInner>, RoutingIntentInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, String routingIntentName, RoutingIntentInner routingIntentParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RoutingIntentInner.class), (Type)((Object)RoutingIntentInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RoutingIntentInner>, RoutingIntentInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, String routingIntentName, RoutingIntentInner routingIntentParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RoutingIntentInner.class), (Type)((Object)RoutingIntentInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RoutingIntentInner>, RoutingIntentInner> beginCreateOrUpdate(String resourceGroupName, String virtualHubName, String routingIntentName, RoutingIntentInner routingIntentParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RoutingIntentInner>, RoutingIntentInner> beginCreateOrUpdate(String resourceGroupName, String virtualHubName, String routingIntentName, RoutingIntentInner routingIntentParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoutingIntentInner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, String routingIntentName, RoutingIntentInner routingIntentParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RoutingIntentInner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, String routingIntentName, RoutingIntentInner routingIntentParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoutingIntentInner createOrUpdate(String resourceGroupName, String virtualHubName, String routingIntentName, RoutingIntentInner routingIntentParameters) {
        return (RoutingIntentInner)((Object)this.createOrUpdateAsync(resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoutingIntentInner createOrUpdate(String resourceGroupName, String virtualHubName, String routingIntentName, RoutingIntentInner routingIntentParameters, Context context) {
        return (RoutingIntentInner)((Object)this.createOrUpdateAsync(resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoutingIntentInner>> getWithResponseAsync(String resourceGroupName, String virtualHubName, String routingIntentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routingIntentName, "2022-05-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoutingIntentInner>> getWithResponseAsync(String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routingIntentName, "2022-05-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoutingIntentInner> getAsync(String resourceGroupName, String virtualHubName, String routingIntentName) {
        return this.getWithResponseAsync(resourceGroupName, virtualHubName, routingIntentName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RoutingIntentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoutingIntentInner> getWithResponse(String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, virtualHubName, routingIntentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoutingIntentInner get(String resourceGroupName, String virtualHubName, String routingIntentName) {
        return (RoutingIntentInner)((Object)this.getWithResponse(resourceGroupName, virtualHubName, routingIntentName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String virtualHubName, String routingIntentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routingIntentName, "2022-05-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, routingIntentName, "2022-05-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, String routingIntentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, virtualHubName, routingIntentName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, virtualHubName, routingIntentName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualHubName, String routingIntentName) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, routingIntentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, routingIntentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String virtualHubName, String routingIntentName) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, routingIntentName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, routingIntentName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualHubName, String routingIntentName) {
        this.deleteAsync(resourceGroupName, virtualHubName, routingIntentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        this.deleteAsync(resourceGroupName, virtualHubName, routingIntentName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoutingIntentInner>> listSinglePageAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, "2022-05-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListRoutingIntentResult)res.getValue()).value(), ((ListRoutingIntentResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoutingIntentInner>> listSinglePageAsync(String resourceGroupName, String virtualHubName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, "2022-05-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListRoutingIntentResult)res.getValue()).value(), ((ListRoutingIntentResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoutingIntentInner> listAsync(String resourceGroupName, String virtualHubName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, virtualHubName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RoutingIntentInner> listAsync(String resourceGroupName, String virtualHubName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, virtualHubName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoutingIntentInner> list(String resourceGroupName, String virtualHubName) {
        return new PagedIterable(this.listAsync(resourceGroupName, virtualHubName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoutingIntentInner> list(String resourceGroupName, String virtualHubName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, virtualHubName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoutingIntentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListRoutingIntentResult)res.getValue()).value(), ((ListRoutingIntentResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoutingIntentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListRoutingIntentResult)res.getValue()).value(), ((ListRoutingIntentResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface RoutingIntentsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routingIntent/{routingIntentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @PathParam(value="routingIntentName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") RoutingIntentInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routingIntent/{routingIntentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoutingIntentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @PathParam(value="routingIntentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routingIntent/{routingIntentName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @PathParam(value="routingIntentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routingIntent")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListRoutingIntentResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListRoutingIntentResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

