/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.FavTaskDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.FavTaskService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="FAVOURITE_TAG")
@RestController
@RequestMapping(value={"/favourite"})
public class FavTaskController
extends BaseController {
    @Resource
    private FavTaskService favTaskService;

    @Operation(summary="listTaskType", description="QUERY_TASK_TYPE_LIST")
    @GetMapping(value={"/taskTypes"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_TASK_TYPE_ERROR)
    public Result listTaskType(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<FavTaskDto> favTaskList = this.favTaskService.getFavTaskList(loginUser);
        return this.success(Status.SUCCESS.getMsg(), favTaskList);
    }

    @Operation(summary="deleteTaskType", description="DELETE_TASK_TYPE")
    @DeleteMapping(value={"/{taskType}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_TYPE_ERROR)
    public Result deleteFavTask(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="taskType") String taskType) {
        boolean b = this.favTaskService.deleteFavTask(loginUser, taskType);
        return this.success(b);
    }

    @Operation(summary="addTaskType", description="ADD_TASK_TYPE")
    @PostMapping(value={"/{taskType}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.ADD_TASK_TYPE_ERROR)
    public Result addFavTask(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="taskType") String taskType) {
        int i = this.favTaskService.addFavTask(loginUser, taskType);
        return this.success(i > 0);
    }
}

