/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cronutils.model.Cron;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.ScheduleParam;
import org.apache.dolphinscheduler.api.dto.schedule.ScheduleCreateRequest;
import org.apache.dolphinscheduler.api.dto.schedule.ScheduleFilterRequest;
import org.apache.dolphinscheduler.api.dto.schedule.ScheduleUpdateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.api.vo.ScheduleVO;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.mapper.EnvironmentMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.scheduler.api.SchedulerApi;
import org.apache.dolphinscheduler.service.cron.CronUtils;
import org.apache.dolphinscheduler.service.exceptions.CronParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SchedulerServiceImpl
extends BaseServiceImpl
implements SchedulerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerServiceImpl.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;
    @Autowired
    private SchedulerApi schedulerApi;
    @Autowired
    private EnvironmentMapper environmentMapper;
    @Autowired
    private TenantMapper tenantMapper;

    @Override
    @Transactional
    public Map<String, Object> insertSchedule(User loginUser, long projectCode, long workflowDefinitionCode, String schedule, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority workflowInstancePriority, String workerGroup, String tenantCode, Long environmentCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, null);
        if (!hasProjectAndPerm) {
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode);
        this.executorService.checkWorkflowDefinitionValid(projectCode, workflowDefinition, workflowDefinitionCode, workflowDefinition.getVersion());
        Schedule scheduleExists = this.scheduleMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode);
        if (scheduleExists != null) {
            log.error("Schedule already exist, scheduleId:{}, workflowDefinitionCode:{}", (Object)scheduleExists.getId(), (Object)workflowDefinitionCode);
            this.putMsg(result, Status.SCHEDULE_ALREADY_EXISTS, workflowDefinitionCode, scheduleExists.getId());
            return result;
        }
        Schedule scheduleObj = new Schedule();
        Date now = new Date();
        this.checkValidTenant(tenantCode);
        scheduleObj.setTenantCode(tenantCode);
        scheduleObj.setProjectName(project.getName());
        scheduleObj.setWorkflowDefinitionCode(workflowDefinitionCode);
        scheduleObj.setWorkflowDefinitionName(workflowDefinition.getName());
        ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)schedule, ScheduleParam.class);
        if (DateUtils.differSec((Date)scheduleParam.getStartTime(), (Date)scheduleParam.getEndTime()) == 0L) {
            log.warn("The start time must not be the same as the end or time can not be null.");
            this.putMsg(result, Status.SCHEDULE_START_TIME_END_TIME_SAME, new Object[0]);
            return result;
        }
        if (scheduleParam.getStartTime().getTime() > scheduleParam.getEndTime().getTime()) {
            log.warn("The start time must smaller than end time");
            this.putMsg(result, Status.START_TIME_BIGGER_THAN_END_TIME_ERROR, new Object[0]);
            return result;
        }
        scheduleObj.setStartTime(scheduleParam.getStartTime());
        scheduleObj.setEndTime(scheduleParam.getEndTime());
        if (!CronUtils.isValidExpression((String)scheduleParam.getCrontab())) {
            log.error("Schedule crontab verify failure, crontab:{}.", (Object)scheduleParam.getCrontab());
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, scheduleParam.getCrontab());
            return result;
        }
        scheduleObj.setCrontab(scheduleParam.getCrontab());
        scheduleObj.setTimezoneId(scheduleParam.getTimezoneId());
        scheduleObj.setWarningType(warningType);
        scheduleObj.setWarningGroupId(warningGroupId);
        scheduleObj.setFailureStrategy(failureStrategy);
        scheduleObj.setCreateTime(now);
        scheduleObj.setUpdateTime(now);
        scheduleObj.setUserId(loginUser.getId().intValue());
        scheduleObj.setUserName(loginUser.getUserName());
        scheduleObj.setReleaseState(ReleaseState.OFFLINE);
        scheduleObj.setWorkflowInstancePriority(workflowInstancePriority);
        scheduleObj.setWorkerGroup(workerGroup);
        scheduleObj.setEnvironmentCode(environmentCode);
        this.scheduleMapper.insert(scheduleObj);
        workflowDefinition.setWarningGroupId(Integer.valueOf(warningGroupId));
        this.workflowDefinitionMapper.updateById(workflowDefinition);
        result.put("data", this.scheduleMapper.selectById((Serializable)scheduleObj.getId()));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        log.info("Schedule create complete, projectCode:{}, workflowDefinitionCode:{}, scheduleId:{}.", new Object[]{projectCode, workflowDefinitionCode, scheduleObj.getId()});
        result.put("scheduleId", scheduleObj.getId());
        return result;
    }

    protected void projectPermCheckByWorkflowCode(User loginUser, long workflowDefinitionCode) {
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode);
        if (workflowDefinition == null) {
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, workflowDefinitionCode);
        }
        Project project = this.projectMapper.queryByCode(workflowDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, null);
    }

    private void scheduleParamCheck(String scheduleParamStr) {
        ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)scheduleParamStr, ScheduleParam.class);
        if (scheduleParam == null) {
            throw new ServiceException(Status.PARSE_SCHEDULE_PARAM_ERROR, scheduleParamStr);
        }
        if (DateUtils.differSec((Date)scheduleParam.getStartTime(), (Date)scheduleParam.getEndTime()) == 0L) {
            throw new ServiceException(Status.SCHEDULE_START_TIME_END_TIME_SAME);
        }
        if (scheduleParam.getStartTime().getTime() > scheduleParam.getEndTime().getTime()) {
            throw new ServiceException(Status.START_TIME_BIGGER_THAN_END_TIME_ERROR);
        }
        if (!CronUtils.isValidExpression((String)scheduleParam.getCrontab())) {
            throw new ServiceException(Status.SCHEDULE_CRON_CHECK_FAILED, scheduleParam.getCrontab());
        }
    }

    @Override
    @Transactional
    public Schedule createSchedulesV2(User loginUser, ScheduleCreateRequest scheduleCreateRequest) {
        this.projectPermCheckByWorkflowCode(loginUser, scheduleCreateRequest.getWorkflowDefinitionCode());
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(scheduleCreateRequest.getWorkflowDefinitionCode());
        this.executorService.checkWorkflowDefinitionValid(workflowDefinition.getProjectCode(), workflowDefinition, workflowDefinition.getCode(), workflowDefinition.getVersion());
        Schedule scheduleExists = this.scheduleMapper.queryByWorkflowDefinitionCode(scheduleCreateRequest.getWorkflowDefinitionCode());
        if (scheduleExists != null) {
            throw new ServiceException(Status.SCHEDULE_ALREADY_EXISTS, scheduleCreateRequest.getWorkflowDefinitionCode(), scheduleExists.getId());
        }
        this.checkValidTenant(scheduleCreateRequest.getTenantCode());
        Schedule schedule = scheduleCreateRequest.convert2Schedule();
        Environment environment = this.environmentMapper.queryByEnvironmentCode(schedule.getEnvironmentCode());
        if (environment == null) {
            throw new ServiceException(Status.QUERY_ENVIRONMENT_BY_CODE_ERROR, schedule.getEnvironmentCode());
        }
        schedule.setUserId(loginUser.getId().intValue());
        schedule.setUserName(loginUser.getUserName());
        schedule.setWorkflowDefinitionName(workflowDefinition.getName());
        this.scheduleParamCheck(scheduleCreateRequest.getScheduleParam());
        int create = this.scheduleMapper.insert(schedule);
        if (create <= 0) {
            throw new ServiceException(Status.CREATE_SCHEDULE_ERROR);
        }
        workflowDefinition.setWarningGroupId(Integer.valueOf(schedule.getWarningGroupId()));
        this.workflowDefinitionMapper.updateById(workflowDefinition);
        return schedule;
    }

    @Override
    @Transactional
    public Map<String, Object> updateSchedule(User loginUser, long projectCode, Integer id, String scheduleExpression, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority workflowInstancePriority, String workerGroup, String tenantCode, Long environmentCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, null);
        if (!hasProjectAndPerm) {
            return result;
        }
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)id);
        if (schedule == null) {
            log.error("Schedule does not exist, scheduleId:{}.", (Object)id);
            this.putMsg(result, Status.SCHEDULE_NOT_EXISTS, id);
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(schedule.getWorkflowDefinitionCode());
        if (workflowDefinition == null || projectCode != workflowDefinition.getProjectCode()) {
            log.error("workflow definition does not exist, workflowDefinitionCode:{}.", (Object)schedule.getWorkflowDefinitionCode());
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(schedule.getWorkflowDefinitionCode()));
            return result;
        }
        this.updateSchedule(result, schedule, workflowDefinition, scheduleExpression, warningType, warningGroupId, failureStrategy, workflowInstancePriority, workerGroup, tenantCode, (long)environmentCode);
        return result;
    }

    @Override
    @Transactional
    public Schedule updateSchedulesV2(User loginUser, Integer scheduleId, ScheduleUpdateRequest scheduleUpdateRequest) {
        Environment environment;
        Schedule scheduleUpdate;
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)scheduleId);
        if (schedule == null) {
            throw new ServiceException(Status.SCHEDULE_NOT_EXISTS, scheduleId);
        }
        try {
            scheduleUpdate = scheduleUpdateRequest.mergeIntoSchedule(schedule);
            this.scheduleParamCheck(scheduleUpdateRequest.updateScheduleParam(scheduleUpdate));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, scheduleUpdateRequest.toString());
        }
        this.projectPermCheckByWorkflowCode(loginUser, scheduleUpdate.getWorkflowDefinitionCode());
        if (scheduleUpdate.getEnvironmentCode() != null && (environment = this.environmentMapper.queryByEnvironmentCode(scheduleUpdate.getEnvironmentCode())) == null) {
            throw new ServiceException(Status.QUERY_ENVIRONMENT_BY_CODE_ERROR, scheduleUpdate.getEnvironmentCode());
        }
        int update = this.scheduleMapper.updateById(scheduleUpdate);
        if (update <= 0) {
            throw new ServiceException(Status.UPDATE_SCHEDULE_ERROR);
        }
        return scheduleUpdate;
    }

    @Override
    @Transactional
    public Schedule getSchedule(User loginUser, Integer scheduleId) {
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)scheduleId);
        if (schedule == null) {
            throw new ServiceException(Status.SCHEDULE_NOT_EXISTS, scheduleId);
        }
        this.projectPermCheckByWorkflowCode(loginUser, schedule.getWorkflowDefinitionCode());
        return schedule;
    }

    @Override
    public Result querySchedule(User loginUser, long projectCode, long workflowDefinitionCode, String searchVal, Integer pageNo, Integer pageSize) {
        WorkflowDefinition workflowDefinition;
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, "project:view");
        if (!hasProjectAndPerm) {
            return result;
        }
        if (workflowDefinitionCode != 0L && ((workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode)) == null || projectCode != workflowDefinition.getProjectCode())) {
            log.error("workflow definition does not exist, workflowDefinitionCode:{}.", (Object)workflowDefinitionCode);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, new Object[]{String.valueOf(workflowDefinitionCode)});
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage schedulePage = this.scheduleMapper.queryByProjectAndWorkflowDefinitionCodePaging((IPage)page, projectCode, workflowDefinitionCode, searchVal);
        ArrayList<ScheduleVO> scheduleList = new ArrayList<ScheduleVO>();
        for (Schedule schedule : schedulePage.getRecords()) {
            scheduleList.add(new ScheduleVO(schedule));
        }
        PageInfo<ScheduleVO> pageInfo = new PageInfo<ScheduleVO>(pageNo, pageSize);
        pageInfo.setTotal((int)schedulePage.getTotal());
        pageInfo.setTotalList(scheduleList);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public List<Schedule> queryScheduleByWorkflowDefinitionCodes(@NonNull List<Long> workflowDefinitionCodes) {
        if (workflowDefinitionCodes == null) {
            throw new NullPointerException("workflowDefinitionCodes is marked non-null but is null");
        }
        if (CollectionUtils.isEmpty(workflowDefinitionCodes)) {
            return Collections.emptyList();
        }
        return this.scheduleMapper.querySchedulesByWorkflowDefinitionCodes(workflowDefinitionCodes);
    }

    @Override
    @Transactional
    public PageInfo<Schedule> filterSchedules(User loginUser, ScheduleFilterRequest scheduleFilterRequest) {
        if (scheduleFilterRequest.getProjectName() != null) {
            Project project = this.projectMapper.queryByName(scheduleFilterRequest.getProjectName());
            this.projectService.checkProjectAndAuthThrowException(loginUser, project, null);
        }
        Page page = new Page((long)scheduleFilterRequest.getPageNo().intValue(), (long)scheduleFilterRequest.getPageSize().intValue());
        IPage scheduleIPage = this.scheduleMapper.filterSchedules((IPage)page, scheduleFilterRequest.convert2Schedule());
        PageInfo<Schedule> pageInfo = new PageInfo<Schedule>(scheduleFilterRequest.getPageNo(), scheduleFilterRequest.getPageSize());
        pageInfo.setTotal((int)scheduleIPage.getTotal());
        pageInfo.setTotalList(scheduleIPage.getRecords());
        return pageInfo;
    }

    @Override
    public Map<String, Object> queryScheduleList(User loginUser, long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, null);
        if (!hasProjectAndPerm) {
            return result;
        }
        List schedules = this.scheduleMapper.querySchedulerListByProjectName(project.getName());
        ArrayList<ScheduleVO> scheduleList = new ArrayList<ScheduleVO>();
        for (Schedule schedule : schedules) {
            scheduleList.add(new ScheduleVO(schedule));
        }
        result.put("data", scheduleList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkValid(Map<String, Object> result, boolean bool, Status status) {
        if (bool) {
            this.putMsg(result, status, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void deleteSchedulesById(User loginUser, Integer scheduleId) {
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)scheduleId);
        if (schedule == null) {
            throw new ServiceException(Status.SCHEDULE_NOT_EXISTS, scheduleId);
        }
        if (schedule.getReleaseState() == ReleaseState.ONLINE) {
            throw new ServiceException(Status.SCHEDULE_STATE_ONLINE, scheduleId);
        }
        if (loginUser.getId().intValue() != schedule.getUserId() && loginUser.getUserType() != UserType.ADMIN_USER) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        this.projectPermCheckByWorkflowCode(loginUser, schedule.getWorkflowDefinitionCode());
        int delete = this.scheduleMapper.deleteById((Serializable)scheduleId);
        if (delete <= 0) {
            throw new ServiceException(Status.DELETE_SCHEDULE_BY_ID_ERROR);
        }
    }

    @Override
    public Map<String, Object> previewSchedule(User loginUser, String schedule) {
        Cron cron;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)schedule, ScheduleParam.class);
        assert (scheduleParam != null);
        ZoneId zoneId = TimeZone.getTimeZone(scheduleParam.getTimezoneId()).toZoneId();
        ZonedDateTime now = ZonedDateTime.now(zoneId);
        ZonedDateTime startTime = ZonedDateTime.ofInstant(scheduleParam.getStartTime().toInstant(), zoneId);
        ZonedDateTime endTime = ZonedDateTime.ofInstant(scheduleParam.getEndTime().toInstant(), zoneId);
        startTime = now.isAfter(startTime) ? now : startTime;
        try {
            cron = CronUtils.parse2Cron((String)scheduleParam.getCrontab());
        }
        catch (CronParseException e) {
            log.error("Parse cron to cron expression error, crontab:{}.", (Object)scheduleParam.getCrontab(), (Object)e);
            this.putMsg(result, Status.PARSE_TO_CRON_EXPRESSION_ERROR, new Object[0]);
            return result;
        }
        List selfFireDateList = CronUtils.getSelfFireDateList((ZonedDateTime)startTime, (ZonedDateTime)endTime, (Cron)cron, (int)5);
        List previewDateList = selfFireDateList.stream().map(t -> DateUtils.dateToString((ZonedDateTime)t, (ZoneId)zoneId)).collect(Collectors.toList());
        result.put("data", previewDateList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateScheduleByWorkflowDefinitionCode(User loginUser, long projectCode, long workflowDefinitionCode, String scheduleExpression, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority workflowInstancePriority, String workerGroup, String tenantCode, long environmentCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        Schedule schedule = this.scheduleMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode);
        if (schedule == null) {
            log.error("Schedule of workflow definition does not exist, workflowDefinitionCode:{}.", (Object)workflowDefinitionCode);
            this.putMsg(result, Status.SCHEDULE_CRON_NOT_EXISTS, workflowDefinitionCode);
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode);
        if (workflowDefinition == null || projectCode != workflowDefinition.getProjectCode()) {
            log.error("workflow definition does not exist, workflowDefinitionCode:{}.", (Object)workflowDefinitionCode);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(workflowDefinitionCode));
            return result;
        }
        this.updateSchedule(result, schedule, workflowDefinition, scheduleExpression, warningType, warningGroupId, failureStrategy, workflowInstancePriority, workerGroup, tenantCode, environmentCode);
        return result;
    }

    @Override
    @Transactional
    public void onlineScheduler(User loginUser, Long projectCode, Integer schedulerId) {
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:definition:release");
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)schedulerId);
        this.doOnlineScheduler(schedule);
    }

    @Override
    @Transactional
    public void onlineSchedulerByWorkflowCode(Long workflowDefinitionCode) {
        Schedule schedule = this.scheduleMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode.longValue());
        this.doOnlineScheduler(schedule);
    }

    private void doOnlineScheduler(Schedule schedule) {
        if (schedule == null) {
            return;
        }
        if (ReleaseState.ONLINE.equals((Object)schedule.getReleaseState())) {
            log.debug("The schedule is already online, scheduleId:{}.", (Object)schedule.getId());
            return;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(schedule.getWorkflowDefinitionCode());
        if (!ReleaseState.ONLINE.equals((Object)workflowDefinition.getReleaseState())) {
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NOT_RELEASE, workflowDefinition.getName());
        }
        schedule.setReleaseState(ReleaseState.ONLINE);
        schedule.setUpdateTime(new Date());
        this.scheduleMapper.updateById(schedule);
        Project project = this.projectMapper.queryByCode(workflowDefinition.getProjectCode());
        this.schedulerApi.insertOrUpdateScheduleTask(project.getId().intValue(), schedule);
    }

    @Override
    @Transactional
    public void offlineScheduler(User loginUser, Long projectCode, Integer schedulerId) {
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:definition:release");
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)schedulerId);
        this.doOfflineScheduler(schedule);
    }

    @Override
    @Transactional
    public void offlineSchedulerByWorkflowCode(Long workflowDefinitionCode) {
        Schedule schedule = this.scheduleMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode.longValue());
        this.doOfflineScheduler(schedule);
    }

    private void doOfflineScheduler(Schedule schedule) {
        if (schedule == null) {
            return;
        }
        if (ReleaseState.OFFLINE.equals((Object)schedule.getReleaseState())) {
            log.debug("The schedule is already offline, scheduleId:{}.", (Object)schedule.getId());
            return;
        }
        schedule.setUpdateTime(new Date());
        schedule.setReleaseState(ReleaseState.OFFLINE);
        this.scheduleMapper.updateById(schedule);
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(schedule.getWorkflowDefinitionCode());
        Project project = this.projectMapper.queryByCode(workflowDefinition.getProjectCode());
        this.schedulerApi.deleteScheduleTask(project.getId().intValue(), schedule.getId().intValue());
    }

    private void updateSchedule(Map<String, Object> result, Schedule schedule, WorkflowDefinition workflowDefinition, String scheduleExpression, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority workflowInstancePriority, String workerGroup, String tenantCode, long environmentCode) {
        if (this.checkValid(result, schedule.getReleaseState() == ReleaseState.ONLINE, Status.SCHEDULE_CRON_ONLINE_FORBID_UPDATE)) {
            log.warn("Schedule can not be updated due to schedule is {}, scheduleId:{}.", (Object)ReleaseState.ONLINE.getDescp(), (Object)schedule.getId());
            return;
        }
        Date now = new Date();
        this.checkValidTenant(tenantCode);
        schedule.setTenantCode(tenantCode);
        if (!StringUtils.isEmpty((CharSequence)scheduleExpression)) {
            ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)scheduleExpression, ScheduleParam.class);
            if (scheduleParam == null) {
                log.warn("Parameter scheduleExpression is invalid, so parse cron error.");
                this.putMsg(result, Status.PARSE_TO_CRON_EXPRESSION_ERROR, new Object[0]);
                return;
            }
            if (DateUtils.differSec((Date)scheduleParam.getStartTime(), (Date)scheduleParam.getEndTime()) == 0L) {
                log.warn("The start time must not be the same as the end or time can not be null.");
                this.putMsg(result, Status.SCHEDULE_START_TIME_END_TIME_SAME, new Object[0]);
                return;
            }
            if (scheduleParam.getStartTime().getTime() > scheduleParam.getEndTime().getTime()) {
                log.warn("The start time must smaller than end time");
                this.putMsg(result, Status.START_TIME_BIGGER_THAN_END_TIME_ERROR, new Object[0]);
                return;
            }
            schedule.setStartTime(scheduleParam.getStartTime());
            schedule.setEndTime(scheduleParam.getEndTime());
            if (!CronUtils.isValidExpression((String)scheduleParam.getCrontab())) {
                log.error("Schedule crontab verify failure, crontab:{}.", (Object)scheduleParam.getCrontab());
                this.putMsg(result, Status.SCHEDULE_CRON_CHECK_FAILED, scheduleParam.getCrontab());
                return;
            }
            schedule.setCrontab(scheduleParam.getCrontab());
            schedule.setTimezoneId(scheduleParam.getTimezoneId());
        }
        if (warningType != null) {
            schedule.setWarningType(warningType);
        }
        schedule.setWarningGroupId(warningGroupId);
        if (failureStrategy != null) {
            schedule.setFailureStrategy(failureStrategy);
        }
        schedule.setWorkerGroup(workerGroup);
        schedule.setEnvironmentCode(Long.valueOf(environmentCode));
        schedule.setUpdateTime(now);
        schedule.setWorkflowInstancePriority(workflowInstancePriority);
        this.scheduleMapper.updateById(schedule);
        workflowDefinition.setWarningGroupId(Integer.valueOf(warningGroupId));
        this.workflowDefinitionMapper.updateById(workflowDefinition);
        log.info("Schedule update complete, projectCode:{}, workflowDefinitionCode:{}, scheduleId:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), schedule.getId()});
        result.put("data", schedule);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
    }

    private void checkValidTenant(String tenantCode) {
        Tenant tenant;
        if (!"default".equals(tenantCode) && (tenant = this.tenantMapper.queryByTenantCode(tenantCode)) == null) {
            throw new ServiceException(Status.TENANT_NOT_EXIST, tenantCode);
        }
    }
}

