/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import com.google.common.io.Files;
import java.util.Objects;
import org.apache.dolphinscheduler.api.dto.resources.UpdateFileDto;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceValidator;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class UpdateFileDtoValidator
extends AbstractResourceValidator<UpdateFileDto> {
    public UpdateFileDtoValidator(StorageOperator storageOperator, TenantDao tenantDao) {
        super(storageOperator, tenantDao);
    }

    @Override
    public void validate(UpdateFileDto updateFileDto) {
        String fileAbsolutePath = updateFileDto.getFileAbsolutePath();
        User loginUser = updateFileDto.getLoginUser();
        MultipartFile file = updateFileDto.getFile();
        if (!Objects.equals(Files.getFileExtension((String)(file.getOriginalFilename() == null ? file.getName() : file.getOriginalFilename())), Files.getFileExtension((String)updateFileDto.getFileAbsolutePath()))) {
            throw new ServiceException("file extension cannot not change");
        }
        this.exceptionResourceAbsolutePathInvalidated(fileAbsolutePath);
        this.exceptionResourceNotExists(fileAbsolutePath);
        this.exceptionResourceIsNotFile(fileAbsolutePath);
        this.exceptionUserNoResourcePermission(loginUser, fileAbsolutePath);
        this.exceptionFileInvalidated(file);
    }
}

