/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.util.ModelMapper;
import io.kubernetes.client.util.labels.Labels;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class KubectlLabel<ApiType extends KubernetesObject>
extends Kubectl.ResourceBuilder<ApiType, KubectlLabel<ApiType>>
implements Kubectl.Executable<ApiType> {
    private final Map<String, String> addingLabels = new HashMap<String, String>();

    KubectlLabel(Class<ApiType> apiTypeClass) {
        super(apiTypeClass);
    }

    public KubectlLabel<ApiType> addLabel(String key, String value) {
        this.addingLabels.put(key, value);
        return this;
    }

    @Override
    public ApiType execute() throws KubectlException {
        KubernetesObject currentObj;
        this.verifyArguments();
        this.refreshDiscovery();
        if (this.isNamespaced(this.apiTypeClass)) {
            try {
                currentObj = (KubernetesObject)this.getGenericApi().get(this.namespace, this.name).throwsApiException().getObject();
            }
            catch (ApiException e) {
                throw new KubectlException(e);
            }
        }
        try {
            currentObj = (KubernetesObject)this.getGenericApi().get(this.name).throwsApiException().getObject();
        }
        catch (ApiException e) {
            throw new KubectlException(e);
        }
        Labels.addLabels((KubernetesObject)currentObj, this.addingLabels);
        try {
            return (ApiType)((KubernetesObject)this.getGenericApi().update(currentObj).throwsApiException().getObject());
        }
        catch (ApiException e) {
            throw new KubectlException(e);
        }
    }

    public boolean isNamespaced(Class<ApiType> apiTypeClass) {
        Boolean isNamespaced = ModelMapper.isNamespaced(apiTypeClass);
        if (isNamespaced == null) {
            return false;
        }
        return isNamespaced != false || !StringUtils.isEmpty((CharSequence)this.namespace);
    }

    private void verifyArguments() throws KubectlException {
        if (null == this.name) {
            throw new KubectlException("missing name argument");
        }
    }
}

