/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.CapacitySize;
import com.amazonaws.services.sagemaker.model.TrafficRoutingConfigType;
import com.amazonaws.services.sagemaker.model.transform.TrafficRoutingConfigMarshaller;
import java.io.Serializable;

public class TrafficRoutingConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private Integer waitIntervalInSeconds;
    private CapacitySize canarySize;
    private CapacitySize linearStepSize;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public TrafficRoutingConfig withType(String type) {
        this.setType(type);
        return this;
    }

    public TrafficRoutingConfig withType(TrafficRoutingConfigType type) {
        this.type = type.toString();
        return this;
    }

    public void setWaitIntervalInSeconds(Integer waitIntervalInSeconds) {
        this.waitIntervalInSeconds = waitIntervalInSeconds;
    }

    public Integer getWaitIntervalInSeconds() {
        return this.waitIntervalInSeconds;
    }

    public TrafficRoutingConfig withWaitIntervalInSeconds(Integer waitIntervalInSeconds) {
        this.setWaitIntervalInSeconds(waitIntervalInSeconds);
        return this;
    }

    public void setCanarySize(CapacitySize canarySize) {
        this.canarySize = canarySize;
    }

    public CapacitySize getCanarySize() {
        return this.canarySize;
    }

    public TrafficRoutingConfig withCanarySize(CapacitySize canarySize) {
        this.setCanarySize(canarySize);
        return this;
    }

    public void setLinearStepSize(CapacitySize linearStepSize) {
        this.linearStepSize = linearStepSize;
    }

    public CapacitySize getLinearStepSize() {
        return this.linearStepSize;
    }

    public TrafficRoutingConfig withLinearStepSize(CapacitySize linearStepSize) {
        this.setLinearStepSize(linearStepSize);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getWaitIntervalInSeconds() != null) {
            sb.append("WaitIntervalInSeconds: ").append(this.getWaitIntervalInSeconds()).append(",");
        }
        if (this.getCanarySize() != null) {
            sb.append("CanarySize: ").append(this.getCanarySize()).append(",");
        }
        if (this.getLinearStepSize() != null) {
            sb.append("LinearStepSize: ").append(this.getLinearStepSize());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficRoutingConfig)) {
            return false;
        }
        TrafficRoutingConfig other = (TrafficRoutingConfig)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getWaitIntervalInSeconds() == null ^ this.getWaitIntervalInSeconds() == null) {
            return false;
        }
        if (other.getWaitIntervalInSeconds() != null && !other.getWaitIntervalInSeconds().equals(this.getWaitIntervalInSeconds())) {
            return false;
        }
        if (other.getCanarySize() == null ^ this.getCanarySize() == null) {
            return false;
        }
        if (other.getCanarySize() != null && !other.getCanarySize().equals(this.getCanarySize())) {
            return false;
        }
        if (other.getLinearStepSize() == null ^ this.getLinearStepSize() == null) {
            return false;
        }
        return other.getLinearStepSize() == null || other.getLinearStepSize().equals(this.getLinearStepSize());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getWaitIntervalInSeconds() == null ? 0 : this.getWaitIntervalInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getCanarySize() == null ? 0 : this.getCanarySize().hashCode());
        hashCode = 31 * hashCode + (this.getLinearStepSize() == null ? 0 : this.getLinearStepSize().hashCode());
        return hashCode;
    }

    public TrafficRoutingConfig clone() {
        try {
            return (TrafficRoutingConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrafficRoutingConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

